/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.edit;

import com.waxmonster.model.LineChunk;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.edit.AbstractLineEdit;
import com.waxmonster.waxlab.edit.WaxLabCannotRedoException;
import com.waxmonster.waxlab.edit.WaxLabCannotUndoException;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class LineChunkSplitEdit
extends AbstractLineEdit {
    private static final long serialVersionUID = 6633503218036597888L;
    private static final Logger logger = Logger.getLogger(LineChunkSplitEdit.class.getName());
    private Line line;
    private LineChunk chunk;
    private long splitOfs;
    private LineChunk[] parts;
    private boolean undone;

    public LineChunkSplitEdit(AbstractLineWrapper lineWrapper, Line line, LineChunk chunk, long splitOfs) throws IOException {
        super(lineWrapper);
        this.line = line;
        this.chunk = chunk;
        this.splitOfs = splitOfs;
        this.perform();
    }

    protected void perform() throws IOException {
        Line line = this.line;
        if (line == null) {
            return;
        }
        LineChunk chunk = this.chunk;
        if (chunk == null) {
            return;
        }
        long splitOfs = this.splitOfs;
        LineChunk[] parts = this.splitLineChunk(line, chunk, splitOfs);
        this.parts = parts;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Line line = this.line;
        if (line == null) {
            return;
        }
        try {
            LineChunk chunk;
            LineChunk[] parts = this.parts;
            if (parts != null) {
                for (LineChunk part : parts) {
                    if (part == null) continue;
                    this.removeLineChunk(line, part);
                }
            }
            if ((chunk = this.chunk) != null) {
                this.addLineChunk(line, chunk);
            }
        }
        catch (Exception e) {
            throw new WaxLabCannotUndoException(e);
        }
        finally {
            this.undone = true;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Line line = this.line;
        if (line == null) {
            return;
        }
        try {
            LineChunk[] parts;
            LineChunk chunk = this.chunk;
            if (chunk != null) {
                this.removeLineChunk(line, chunk);
            }
            if ((parts = this.parts) != null) {
                for (LineChunk part : parts) {
                    if (part == null) continue;
                    this.addLineChunk(line, part);
                }
            }
        }
        catch (Exception e) {
            throw new WaxLabCannotRedoException(e);
        }
        finally {
            this.undone = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void die() {
        super.die();
        try {
            if (this.undone) {
                LineChunk[] parts = this.parts;
                if (parts != null) {
                    for (LineChunk part : parts) {
                        if (part == null) continue;
                        try {
                            this.closeLineChunk(this.line, part);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
            } else {
                LineChunk chunk = this.chunk;
                if (chunk != null) {
                    try {
                        this.closeLineChunk(this.line, chunk);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
        finally {
            this.line = null;
            this.chunk = null;
            this.parts = null;
            this.splitOfs = 0L;
        }
    }

    public LineChunk getFirstPart() {
        LineChunk[] arr = this.parts;
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public LineChunk getLastPart() {
        LineChunk[] arr = this.parts;
        return arr != null && arr.length > 0 ? arr[arr.length - 1] : null;
    }

    public Line getLine() {
        return this.line;
    }

    protected void setLine(Line line) {
        this.line = line;
    }

    public LineChunk getChunk() {
        return this.chunk;
    }

    protected void setChunk(LineChunk chunk) {
        this.chunk = chunk;
    }

    public long getSplitOfs() {
        return this.splitOfs;
    }

    protected void setSplitOfs(long splitOfs) {
        this.splitOfs = splitOfs;
    }
}

