/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.edit;

import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.MultiLinePanel;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class WaxLabSelectionEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -3216135180466593028L;
    private MultiLinePanel linePanel;
    private List oldSelectedLines;
    private Line oldFocusLine;
    private long oldCursorPosition;
    private long oldSelectionAnchorPos;
    private long oldSelectionLeadPos;
    private List newSelectedLines;
    private Line newFocusLine;
    private long newCursorPosition;
    private long newSelectionAnchorPos;
    private long newSelectionLeadPos;

    public WaxLabSelectionEdit(MultiLinePanel linePanel, long newCursorPosition, long newSelectionAnchorPos, long newSelectionLeadPos) {
        Line line;
        AbstractLineWrapper wrapper;
        this.linePanel = linePanel;
        this.oldCursorPosition = linePanel.getCursorPosition();
        this.oldSelectionAnchorPos = linePanel.getSelectionAnchorPos();
        this.oldSelectionLeadPos = linePanel.getSelectionLeadPos();
        this.newCursorPosition = newCursorPosition;
        this.newSelectionAnchorPos = newSelectionAnchorPos;
        this.newSelectionLeadPos = newSelectionLeadPos;
        int focusLineIndex = linePanel.getFocusLineIndex();
        if (focusLineIndex >= 0 && (wrapper = linePanel.getLineWrapperAt(focusLineIndex)) != null && (line = wrapper.getLine()) != null) {
            this.oldFocusLine = line;
        }
        this.oldSelectedLines = new LinkedList();
        int[] sel = linePanel.getSelectedLineIndices();
        int num = sel.length;
        for (int i = 0; i < num; ++i) {
            Line line2;
            AbstractLineWrapper wrapper2 = linePanel.getLineWrapperAt(sel[i]);
            if (wrapper2 == null || (line2 = wrapper2.getLine()) == null) continue;
            this.oldSelectedLines.add(line2);
        }
        this.newFocusLine = this.oldFocusLine;
        this.newSelectedLines = this.oldSelectedLines;
    }

    public void perform() {
        this.perform(this.newFocusLine, this.newSelectedLines, this.newCursorPosition, this.newSelectionAnchorPos, this.newSelectionLeadPos);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.perform(this.oldFocusLine, this.oldSelectedLines, this.oldCursorPosition, this.oldSelectionAnchorPos, this.oldSelectionLeadPos);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.perform();
    }

    @Override
    public void die() {
        super.die();
        this.linePanel = null;
    }

    protected void perform(Line focusLine, List selectedLines, long cursorPosition, long selectionAnchorPos, long selectionLeadPos) {
        int focusLineIndex;
        MultiLinePanel linePanel = this.linePanel;
        if (linePanel == null) {
            return;
        }
        if (selectedLines != null) {
            int num = selectedLines.size();
            int[] selectedLineIndices = new int[num];
            int idx = 0;
            for (Line line : selectedLines) {
                int lineIndex = this.getLineIndex(linePanel, line);
                if (lineIndex < 0) continue;
                selectedLineIndices[idx++] = lineIndex;
            }
            if (idx < num) {
                int[] arr = new int[idx];
                System.arraycopy(selectedLineIndices, 0, arr, 0, idx);
                selectedLineIndices = arr;
            }
            linePanel.setSelectedLineIndices(selectedLineIndices);
        }
        if (focusLine != null && (focusLineIndex = this.getLineIndex(linePanel, focusLine)) >= 0) {
            linePanel.setFocusLineIndex(focusLineIndex);
            linePanel.scrollLineToVisible(focusLineIndex);
        }
        linePanel.setSelectionAnchorPos(selectionAnchorPos);
        linePanel.setSelectionLeadPos(selectionLeadPos);
        linePanel.moveCursorPosition(cursorPosition, false);
    }

    protected int getLineIndex(MultiLinePanel linePanel, Line line) {
        if (line == null) {
            return -1;
        }
        AbstractLineWrapper[] wrappers = linePanel.getLineWrappers();
        if (wrappers == null) {
            return -1;
        }
        int num = wrappers.length;
        for (int i = 0; i < num; ++i) {
            AbstractLineWrapper wrapper = wrappers[i];
            if (wrapper == null || wrapper.getLine() != line) continue;
            return i;
        }
        return -1;
    }
}

