/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.media.control.Control;
import com.waxmonster.model.ChunkListener;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.view.LineManager;
import com.waxmonster.model.view.LineView;
import com.waxmonster.scratch.AudioScratchPlayer;
import com.waxmonster.view.ScrollPos;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewLayout;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineFeature;
import com.waxmonster.waxlab.LineListener;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.edit.AbstractLineEdit;
import com.waxmonster.waxlab.edit.LineChunkAddEdit;
import com.waxmonster.waxlab.edit.LineChunkMoveEdit;
import com.waxmonster.waxlab.edit.LineChunkRemoveEdit;
import com.waxmonster.waxlab.edit.LineChunkSplitEdit;
import com.waxmonster.waxlab.util.LineModelCopyInfo;
import com.waxmonster.waxlab.util.LineWrapper;
import com.waxmonster.waxlab.view.LineHeaderPanel;
import com.waxmonster.waxlab.view.MultiLinePanel;
import com.waxmonster.waxlab.view.MultiLineUtil;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public abstract class AbstractLineWrapper
implements LineWrapper {
    private static final Logger logger = Logger.getLogger(AbstractLineWrapper.class.getName());
    protected static final int MIN_HALF = -1073741824;
    protected static final int MAX_HALF = 0x40000000;
    protected static final LineView[] NONE_VIEWS = new LineView[0];
    private static final int DEFAULT_MODIFY_BUFFER_FRAMES = 16384;
    protected final MultiLinePanel panel;
    protected final Line line;
    protected int gridIndex;
    protected int trackSize;
    protected int normalTrackSize;
    protected WaxLabViewSettings viewSettings;
    protected final LineHandler lineHandler = new LineHandler();
    protected final ChunkHandler chunkHandler = new ChunkHandler();
    protected final RefreshLater refreshLater = new RefreshLater();
    private volatile boolean refreshPending;
    private volatile int refreshTimeLen = 0;
    protected ViewLayout viewLayout;
    protected ScrollView scrollView;
    protected TileView tileView;
    protected LineView[] lineViews = NONE_VIEWS;
    protected LineChunk recChunk;
    protected boolean recRefreshToPos;
    protected long prevRecUnits;
    protected long prevRecPos;
    protected double zoomRate = 1.0;
    protected int orientation;
    protected boolean horiz = true;
    protected View[] frontViews;
    protected LineHeaderPanel lineHeaderPanel;
    protected JPopupMenu linePopupMenu;
    protected LineManager lineManager;
    protected AbstractLineWrapper[] lineWrappers;
    protected KeyListener keyListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected MouseWheelListener mouseWheelListener;
    private int modifyBufferFrames = 16384;

    public AbstractLineWrapper(MultiLinePanel panel, Line line, ViewLayout layout, int gridIndex) {
        this.panel = panel;
        this.line = line;
        this.zoomRate = panel.getZoomRate();
        this.viewLayout = layout;
        this.gridIndex = gridIndex;
    }

    protected void init() {
        this.line.registerLineListener((LineListener)this.lineHandler);
    }

    public void dispose() {
        this.line.unregisterLineListener((LineListener)this.lineHandler);
        TileView tv = this.tileView;
        if (tv != null) {
            tv.flush();
            this.tileView = null;
        }
        this.setLineViews(NONE_VIEWS);
    }

    public MultiLinePanel getPanel() {
        return this.panel;
    }

    public Line getLine() {
        return this.line;
    }

    public ViewLayout getViewLayout() {
        return this.viewLayout;
    }

    public void setViewLayout(ViewLayout viewLayout) {
        this.viewLayout = viewLayout;
    }

    public ScrollView getScrollView() {
        return this.scrollView;
    }

    public void setScrollView(ScrollView scrollView) {
        this.scrollView = scrollView;
    }

    public TileView getTileView() {
        return this.tileView;
    }

    public void setTileView(TileView tileView) {
        this.tileView = tileView;
    }

    public LineView[] getLineViews() {
        return this.lineViews;
    }

    public void setLineViews(LineView[] newLineViews) {
        this.lineViews = newLineViews;
    }

    public double getZoomRate() {
        return this.zoomRate;
    }

    public void setZoomRate(double zoomRate) {
        if (this.zoomRate == zoomRate) {
            return;
        }
        this.zoomRate = zoomRate;
        LineView[] lineViews = this.lineViews;
        int n = lineViews.length;
        for (int i = 0; i < n; ++i) {
            lineViews[i].setZoomRate(zoomRate);
        }
        TileView tv = this.tileView;
        if (tv != null) {
            tv.invalidate();
        }
    }

    public void validate() {
        TileView tv = this.tileView;
        if (tv != null) {
            tv.invalidate();
        }
    }

    public void repaint() {
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        LineHeaderPanel lhp;
        this.orientation = orientation;
        this.horiz = orientation == 0 || orientation == 1;
        ScrollView sv = this.scrollView;
        if (sv != null) {
            ScrollPos p = sv.getPosition();
            p.x = 0L;
            p.y = 0L;
            sv.setPosition(p);
        }
        if ((lhp = this.lineHeaderPanel) != null) {
            lhp.setOrientation(orientation);
        }
    }

    public View[] getFrontViews() {
        return this.frontViews;
    }

    public void setFrontViews(View[] frontViews) {
        this.frontViews = frontViews;
    }

    public LineChunk getRecChunk() {
        return this.recChunk;
    }

    public void setRecChunk(LineChunk recChunk) {
        this.recChunk = recChunk;
        this.prevRecUnits = 0L;
        this.prevRecPos = 0L;
    }

    public boolean isRecRefreshToPos() {
        return this.recRefreshToPos;
    }

    protected void setRecRefreshToPos(boolean recRefreshToPos) {
        this.recRefreshToPos = recRefreshToPos;
    }

    public void validateRecView() {
        TileView tv;
        long recPos;
        LineChunk rc = this.recChunk;
        if (rc == null) {
            return;
        }
        LineModel rm = rc.getLineModel();
        if (rm == null) {
            return;
        }
        long min = 0L;
        long max = 0L;
        long recUnits = rm.getUnitLength();
        if (recUnits != this.prevRecUnits) {
            this.panel.adjustTimeLength(rc);
            double unitRate = rm.getUnitRate();
            long base = rc.getChunkOfs() - rc.getModelOfs();
            min = base + LineUtil.getNanoOfs((long)this.prevRecUnits, (double)unitRate);
            max = base + LineUtil.getNanoOfs((long)recUnits, (double)unitRate);
            this.prevRecUnits = recUnits;
        }
        if (this.recRefreshToPos && (recPos = this.panel.getTimePosition()) != this.prevRecPos) {
            if (this.prevRecPos < min || min == 0L) {
                min = this.prevRecPos;
            }
            if (recPos > max || max == 0L) {
                max = recPos;
            }
            this.prevRecPos = recPos;
        }
        if (min < max && (tv = this.tileView) != null) {
            min = LineUtil.getUnitOfs((long)min, (double)this.zoomRate);
            if ((max = LineUtil.getUnitOfs((long)max, (double)this.zoomRate) - min) >= 0L) {
                switch (this.orientation) {
                    case 0: {
                        tv.invalidate((int)min - 1, -1073741824, (int)max + 3, Integer.MAX_VALUE);
                        break;
                    }
                    case 2: {
                        tv.invalidate(-1073741824, (int)min - 1, Integer.MAX_VALUE, (int)max + 3);
                    }
                }
            }
        }
    }

    public JPopupMenu getLinePopupMenu() {
        return this.linePopupMenu;
    }

    public void setLinePopupMenu(JPopupMenu linePopupMenu) {
        this.linePopupMenu = linePopupMenu;
    }

    public LineManager getLineManager() {
        return this.lineManager;
    }

    public void setLineManager(LineManager lineManager) {
        this.lineManager = lineManager;
    }

    protected AbstractLineWrapper[] getLineWrappers() {
        return this.lineWrappers;
    }

    protected void setLineWrappers(AbstractLineWrapper[] lineWrappers) {
        this.lineWrappers = lineWrappers;
    }

    public void showExportLineDialog(Component parent, WaxLab waxLab) {
    }

    protected void handleControlAdded(Line line, Control control) {
    }

    protected void handleControlRemoved(Line line, Control control) {
    }

    protected void handleLineChanged(Line line) {
        LineHeaderPanel headerPanel = this.getLineHeaderPanel();
        if (headerPanel != null) {
            headerPanel.refreshWidgetToggleButtons();
            headerPanel.refresh();
            this.panel.refreshMultiLineHeader();
        }
    }

    protected void handleWidgetAdded(Line line, LineWidget widget) {
        LineHeaderPanel headerPanel = this.getLineHeaderPanel();
        if (headerPanel != null) {
            headerPanel.refreshWidgetToggleButtons();
            headerPanel.refresh();
            this.panel.refreshMultiLineHeader();
        }
    }

    protected void handleWidgetRemoved(Line line, LineWidget widget) {
        LineHeaderPanel headerPanel = this.getLineHeaderPanel();
        if (headerPanel != null) {
            headerPanel.refreshWidgetToggleButtons();
            headerPanel.refresh();
            this.panel.refreshMultiLineHeader();
        }
    }

    protected void handleWidgetChanged(Line line, LineWidget widget) {
        LineHeaderPanel headerPanel = this.getLineHeaderPanel();
        if (headerPanel != null) {
            headerPanel.refreshWidgetToggleButton(widget);
        }
    }

    protected void handleChunkAdded(LineChunk chunk, int index) {
        ++this.refreshTimeLen;
        this.refreshLater();
    }

    protected void handleChunkRemoved(LineChunk chunk, int index) {
        ++this.refreshTimeLen;
        this.refreshLater();
    }

    protected void handleChunkMoved(LineChunk chunk, int index, int oldIndex, long oldOfs, long oldEnd) {
        ++this.refreshTimeLen;
        this.refreshLater();
    }

    protected void handleChunksChanged(long ofs, long end) {
        ++this.refreshTimeLen;
        this.refreshLater();
    }

    public boolean refreshLater() {
        if (this.refreshPending) {
            return false;
        }
        this.refreshPending = true;
        SwingUtilities.invokeLater(this.refreshLater);
        return true;
    }

    public abstract void refresh();

    public abstract void layout();

    public void scroll(long timePos, long scrollPos, long pix) {
        ScrollPos p = this.scrollView.getPosition();
        if (this.horiz) {
            p.x = pix;
        } else {
            p.y = pix;
        }
        this.scrollView.setPosition(p);
    }

    public void scrollLinePageUp() {
    }

    public void scrollLinePageDown() {
    }

    public void setScratchPlayer(AudioScratchPlayer scratchPlayer) {
    }

    protected KeyListener getKeyListener() {
        return this.keyListener;
    }

    protected void setKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
    }

    protected MouseListener getMouseListener() {
        return this.mouseListener;
    }

    protected void setMouseListener(MouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    protected MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    protected void setMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    protected MouseWheelListener getMouseWheelListener() {
        return this.mouseWheelListener;
    }

    protected void setMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListener = mouseWheelListener;
    }

    protected int getRelativeX(int x) {
        ScrollView sv = this.scrollView;
        if (sv != null) {
            return x - sv.getX();
        }
        return x;
    }

    protected int getRelativeY(int y) {
        ScrollView sv = this.scrollView;
        if (sv != null) {
            return y - sv.getY();
        }
        return y;
    }

    public int getGridIndex() {
        return this.gridIndex;
    }

    public void setGridIndex(int gridIndex) {
        this.gridIndex = gridIndex;
    }

    public int getTrackSize() {
        return this.trackSize;
    }

    public void setTrackSize(int trackSize) {
        this.trackSize = trackSize;
    }

    public int getNormalTrackSize() {
        return this.normalTrackSize;
    }

    public void setNormalTrackSize(int normalTrackSize) {
        this.normalTrackSize = normalTrackSize;
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        this.refreshLineHeaderPanel();
    }

    protected UndoManager getUndoManager() {
        return MultiLineUtil.getUndoManager(this.panel);
    }

    protected ClipboardManager getClipboardManager() {
        return MultiLineUtil.getClipboardManager(this.panel);
    }

    public LineModelCopyInfo[] performCopyAction(long ofs, long end) throws Exception {
        Line line = this.getLine();
        if (line == null) {
            return null;
        }
        ChunkModel chunkModel = line.getChunkModel();
        if (chunkModel == null) {
            return null;
        }
        LineChunk[] chunks = chunkModel.getChunks(new LineChunk[chunkModel.getChunkCount()]);
        if (chunks == null) {
            return null;
        }
        int num = chunks.length;
        if (num < 1) {
            return null;
        }
        LinkedList<LineModelCopyInfo> infoList = null;
        for (int i = 0; i < num; ++i) {
            LineChunk chunk = chunks[i];
            LineModelCopyInfo info = null;
            if (chunk != null) {
                info = this.performCopyAction(chunk, ofs, end);
            }
            if (info == null) continue;
            if (infoList == null) {
                infoList = new LinkedList<LineModelCopyInfo>();
            }
            infoList.add(info);
        }
        if (infoList == null) {
            return null;
        }
        LineModelCopyInfo[] result = infoList.toArray(new LineModelCopyInfo[infoList.size()]);
        return result;
    }

    protected LineModelCopyInfo performCopyAction(LineChunk chunk, long ofs, long end) throws Exception {
        MutableLineChunk chunkCopy;
        long modelEnd;
        long modelOfs;
        long chunkOfs;
        if (end <= ofs) {
            return null;
        }
        if (chunk == null) {
            return null;
        }
        Line line = this.line;
        if (line == null) {
            return null;
        }
        LineModel lineModel = chunk.getLineModel();
        if (lineModel == null) {
            return null;
        }
        long lineOfs = chunk.getChunkOfs();
        if (lineOfs >= end) {
            return null;
        }
        long lineEnd = chunk.getChunkEnd();
        if (lineEnd <= ofs) {
            return null;
        }
        long chunkEnd = Math.min(end, lineEnd) - ofs;
        if (ofs < lineOfs) {
            chunkOfs = lineOfs - ofs;
            modelOfs = chunk.getModelOfs();
            modelEnd = chunk.getModelEnd();
            if (modelEnd - modelOfs > end - lineOfs) {
                modelEnd = modelOfs + end - lineOfs;
            }
        } else {
            chunkOfs = 0L;
            modelOfs = chunk.getModelOfs() + ofs - lineOfs;
            modelEnd = chunk.getModelEnd();
            if (modelEnd - modelOfs > end - ofs) {
                modelEnd = modelOfs + end - ofs;
            }
        }
        if (modelEnd < modelOfs) {
            modelEnd = modelOfs;
        }
        if ((chunkCopy = lineModel.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd)) == null) {
            return null;
        }
        return new LineModelCopyInfo((LineChunk)chunkCopy, line);
    }

    public UndoableEdit performDeleteAction(long ofs, long end) throws Exception {
        Line line = this.getLine();
        if (line == null) {
            return null;
        }
        ChunkModel chunkModel = line.getChunkModel();
        if (chunkModel == null) {
            return null;
        }
        LineChunk[] chunks = chunkModel.getChunks(new LineChunk[chunkModel.getChunkCount()]);
        if (chunks == null) {
            return null;
        }
        int num = chunks.length;
        if (num < 1) {
            return null;
        }
        CompoundEdit edits = null;
        try {
            for (int i = 0; i < num; ++i) {
                int n;
                UndoableEdit[] arr;
                LineChunk chunk = chunks[i];
                if (chunk == null || (arr = this.performDeleteAction(chunk, ofs, end)) == null || (n = arr.length) < 1) continue;
                if (edits == null) {
                    edits = new CompoundEdit();
                }
                for (int k = 0; k < n; ++k) {
                    UndoableEdit edit = arr[k];
                    if (edit == null) continue;
                    edits.addEdit(edit);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (edits == null) {
            return null;
        }
        edits.end();
        return edits;
    }

    protected UndoableEdit[] performDeleteAction(LineChunk chunk, long ofs, long end) throws Exception {
        LineChunkSplitEdit splitEdit;
        long splitOfs;
        if (chunk == null) {
            return null;
        }
        if (end <= ofs) {
            return null;
        }
        long chunkOfs = chunk.getChunkOfs();
        if (chunkOfs >= end) {
            return null;
        }
        long chunkEnd = chunk.getChunkEnd();
        if (chunkEnd <= ofs) {
            return null;
        }
        LinkedList<AbstractLineEdit> editList = new LinkedList<AbstractLineEdit>();
        LineChunk removeChunk = chunk;
        if (ofs > chunkOfs) {
            splitOfs = ofs - chunkOfs;
            splitEdit = new LineChunkSplitEdit(this, this.line, removeChunk, splitOfs);
            editList.add(splitEdit);
            removeChunk = splitEdit.getLastPart();
            chunkOfs = ofs;
        }
        if (end < chunkEnd) {
            splitOfs = end - chunkOfs;
            splitEdit = new LineChunkSplitEdit(this, this.line, removeChunk, splitOfs);
            editList.add(splitEdit);
            removeChunk = splitEdit.getFirstPart();
        }
        LineChunkRemoveEdit removeEdit = new LineChunkRemoveEdit(this, this.line, removeChunk);
        editList.add(removeEdit);
        return editList.toArray(new UndoableEdit[editList.size()]);
    }

    public UndoableEdit performMoveAction(long minStartTime, long maxEndTime, long moveNanos) throws Exception {
        Line line = this.getLine();
        if (line == null) {
            return null;
        }
        ChunkModel chunkModel = line.getChunkModel();
        if (chunkModel == null) {
            return null;
        }
        LineChunk[] chunks = chunkModel.getChunks(new LineChunk[chunkModel.getChunkCount()]);
        if (chunks == null) {
            return null;
        }
        int num = chunks.length;
        if (num < 1) {
            return null;
        }
        CompoundEdit edits = null;
        try {
            for (int i = 0; i < num; ++i) {
                UndoableEdit edit;
                LineChunk chunk = chunks[i];
                if (chunk == null || (edit = this.performMoveAction(chunk, minStartTime, maxEndTime, moveNanos)) == null) continue;
                if (edits == null) {
                    edits = new CompoundEdit();
                }
                edits.addEdit(edit);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (edits == null) {
            return null;
        }
        edits.end();
        return edits;
    }

    protected UndoableEdit performMoveAction(LineChunk chunk, long minStartTime, long maxEndTime, long moveNanos) throws Exception {
        Line line = this.getLine();
        if (line == null) {
            return null;
        }
        if (chunk == null) {
            return null;
        }
        if (moveNanos == 0L) {
            return null;
        }
        long chunkOfs = chunk.getChunkOfs();
        if (chunkOfs < minStartTime) {
            return null;
        }
        long chunkEnd = chunk.getChunkEnd();
        if (chunkEnd > maxEndTime) {
            return null;
        }
        long newChunkOfs = LineUtil.longSum((long)chunkOfs, (long)moveNanos);
        long newChunkEnd = LineUtil.longSum((long)chunkEnd, (long)moveNanos);
        int newIndex = chunk.getZOrder();
        LineChunkMoveEdit edit = new LineChunkMoveEdit(this, line, chunk, newChunkOfs, newChunkEnd, newIndex);
        return edit;
    }

    public UndoableEdit performSplitAction(long splitTime) throws Exception {
        Line line = this.getLine();
        if (line == null) {
            return null;
        }
        ChunkModel chunkModel = line.getChunkModel();
        if (chunkModel == null) {
            return null;
        }
        LineChunk[] chunks = chunkModel.getChunks(new LineChunk[chunkModel.getChunkCount()]);
        if (chunks == null) {
            return null;
        }
        int num = chunks.length;
        if (num < 1) {
            return null;
        }
        CompoundEdit edits = null;
        try {
            for (int i = 0; i < num; ++i) {
                UndoableEdit edit;
                LineChunk chunk = chunks[i];
                if (chunk == null || (edit = this.performSplitAction(chunk, splitTime)) == null) continue;
                if (edits == null) {
                    edits = new CompoundEdit();
                }
                edits.addEdit(edit);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (edits == null) {
            return null;
        }
        edits.end();
        return edits;
    }

    protected UndoableEdit performSplitAction(LineChunk chunk, long splitTime) throws Exception {
        Line line = this.getLine();
        if (line == null) {
            return null;
        }
        if (chunk == null) {
            return null;
        }
        long chunkOfs = chunk.getChunkOfs();
        if (chunkOfs >= splitTime) {
            return null;
        }
        long chunkEnd = chunk.getChunkEnd();
        if (chunkEnd <= splitTime) {
            return null;
        }
        long splitOfs = splitTime - chunkOfs;
        LineChunkSplitEdit edit = new LineChunkSplitEdit(this, line, chunk, splitOfs);
        return edit;
    }

    public UndoableEdit performPasteAction(LineChunk chunk) throws Exception {
        LineChunkAddEdit edit = new LineChunkAddEdit(this, this.line, chunk);
        return edit;
    }

    protected int getModifyBufferFrames() {
        return this.modifyBufferFrames;
    }

    protected void setModifyBufferFrames(int modifyBufferFrames) {
        this.modifyBufferFrames = modifyBufferFrames;
    }

    public LineHeaderPanel getLineHeaderPanel() {
        if (this.lineHeaderPanel == null) {
            this.setLineHeaderPanel(this.createLineHeaderPanel());
            this.refreshLineHeaderPanel();
        }
        return this.lineHeaderPanel;
    }

    protected void setLineHeaderPanel(LineHeaderPanel lineHeaderPanel) {
        this.lineHeaderPanel = lineHeaderPanel;
    }

    protected LineHeaderPanel createLineHeaderPanel() {
        LineHeaderPanel panel = new LineHeaderPanel();
        panel.setLineWrapper(this);
        panel.setOrientation(this.getOrientation());
        return panel;
    }

    protected void refreshLineHeaderPanel() {
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        LineHeaderPanel lhp = this.getLineHeaderPanel();
        if (lhp == null) {
            return;
        }
        lhp.setForeground(viewSettings.getTitleForeground());
        lhp.setNormalViewBorder(viewSettings.getTitleBorder());
        lhp.setFont(viewSettings.getTitleFont());
        lhp.setSelectedViewBackground(viewSettings.getSelectedViewBackground());
        lhp.setSelectedViewForeground(viewSettings.getSelectedViewForeground());
        lhp.setSelectedViewBorder(viewSettings.getSelectedViewBorder());
        lhp.setSelectedViewFont(viewSettings.getSelectedViewFont());
        lhp.setFocusViewBackground(viewSettings.getFocusViewBackground());
        lhp.setFocusViewForeground(viewSettings.getFocusViewForeground());
        lhp.setFocusViewBorder(viewSettings.getFocusViewBorder());
        lhp.setFocusViewFont(viewSettings.getFocusViewFont());
        int titleSize = 10;
        Font font = viewSettings.getFocusViewFont();
        if (font != null) {
            titleSize = lhp.getFontMetrics(font).getHeight() + 4;
        }
        lhp.setTitleSize(titleSize);
    }

    protected void layoutLineView(LineView view) {
        view.setOrientation(this.orientation);
        view.setZoomRate(this.zoomRate);
        Rectangle bounds = view.getBounds();
        if (this.horiz) {
            bounds.width = 0x40000000;
            bounds.height = this.trackSize;
        } else {
            bounds.width = this.trackSize;
            bounds.height = 0x40000000;
        }
        view.setBounds(bounds);
    }

    protected class RefreshLater
    implements Runnable {
        protected RefreshLater() {
        }

        @Override
        public void run() {
            AbstractLineWrapper.this.refreshPending = false;
            AbstractLineWrapper.this.refresh();
            if (AbstractLineWrapper.this.refreshTimeLen > 0) {
                AbstractLineWrapper.this.refreshTimeLen = 0;
                AbstractLineWrapper.this.panel.adjustTimeLength();
            }
            if (!AbstractLineWrapper.this.panel.isUpdateTimerRunning()) {
                AbstractLineWrapper.this.panel.repaint();
            }
        }
    }

    protected class ChunkHandler
    implements ChunkListener {
        protected ChunkHandler() {
        }

        public void chunkAdded(LineChunk chunk, int index) {
            AbstractLineWrapper.this.handleChunkAdded(chunk, index);
        }

        public void chunkRemoved(LineChunk chunk, int index) {
            AbstractLineWrapper.this.handleChunkRemoved(chunk, index);
        }

        public void chunkMoved(LineChunk chunk, int index, int oldIndex, long oldOfs, long oldEnd) {
            AbstractLineWrapper.this.handleChunkMoved(chunk, index, oldIndex, oldOfs, oldEnd);
        }

        public void chunksChanged(long ofs, long end) {
            AbstractLineWrapper.this.handleChunksChanged(ofs, end);
        }
    }

    protected class LineHandler
    implements LineListener {
        protected LineHandler() {
        }

        public void lineChanged(Line line) {
            AbstractLineWrapper.this.handleLineChanged(line);
        }

        public void controlAdded(Line line, Control control) {
            AbstractLineWrapper.this.handleControlAdded(line, control);
        }

        public void controlRemoved(Line line, Control control) {
            AbstractLineWrapper.this.handleControlRemoved(line, control);
        }

        public void featureAdded(Line line, LineFeature feature) {
        }

        public void featureRemoved(Line line, LineFeature feature) {
        }

        public void featureChanged(Line line, LineFeature feature) {
        }

        public void featureSynced(Line line, LineFeature feature) {
        }

        public void widgetAdded(Line line, LineWidget widget) {
            AbstractLineWrapper.this.handleWidgetAdded(line, widget);
        }

        public void widgetRemoved(Line line, LineWidget widget) {
            AbstractLineWrapper.this.handleWidgetRemoved(line, widget);
        }

        public void widgetChanged(Line line, LineWidget widget) {
            AbstractLineWrapper.this.handleWidgetChanged(line, widget);
        }
    }
}

