/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.scratch.AudioScratchPlayer;
import com.waxmonster.view.ScrollPos;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.ViewLayout;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.ClockScratchPositionView;
import com.waxmonster.waxlab.view.MultiLinePanel;
import com.waxmonster.waxlab.view.ScratchPositionView;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;

public abstract class AbstractScratchLineWrapper
extends AbstractLineWrapper {
    private static final Logger logger = Logger.getLogger(AbstractScratchLineWrapper.class.getName());
    private boolean invertedDirection;
    private ScratchPositionView scratchPositionView;
    protected ClockScratchPositionView clockScratchPositionView;
    private long timecodeLatencyFrames;
    private boolean timecodeAutoScrolling;
    private int timecodeScrollThreshold;
    private AudioScratchPlayer scratchPlayer;
    private final double[] tca = new double[1];
    private final int latencyAvgFactor;
    private final int latencyAvgDivisor;
    private Timer timecodeScrollTimer;
    private TimecodeScroller timecodeScroller;
    private int timecodeScrollDelay = 10;
    private int timecodeScrollInitialDelay = 100;
    private int timecodeScrollIncrement;
    private boolean timecodeScrollSpeedup;
    private int timecodeScrollCounter;
    private int timecodeScrollFactor;
    private int timecodeScrollMaxFactor = 100;
    private int timecodeScrollSpeedupDelay = 20;

    public AbstractScratchLineWrapper(MultiLinePanel panel, Line line, ViewLayout layout, int gridIndex) {
        super(panel, line, layout, gridIndex);
        this.clockScratchPositionView = new ClockScratchPositionView();
        this.clockScratchPositionView.setAutoHide(true);
        this.timecodeScroller = new TimecodeScroller();
        this.timecodeScrollTimer = new Timer(this.timecodeScrollDelay, this.timecodeScroller);
        this.latencyAvgDivisor = 100;
        this.latencyAvgFactor = this.latencyAvgDivisor - 1;
    }

    @Override
    public void setViewSettings(WaxLabViewSettings viewSettings) {
        super.setViewSettings(viewSettings);
        this.clockScratchPositionView.setViewSettings(viewSettings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void scroll(long timePos, long scrollPos, long pix) {
        double val;
        long delay;
        long fp;
        TimecodeModel tcm;
        super.scroll(timePos, scrollPos, pix);
        LineChunk chunk = this.recChunk;
        if (chunk != null) {
            LineModel model = chunk.getLineModel();
            if (model == null || !(model instanceof TimecodeModel)) return;
            tcm = (TimecodeModel)model;
            fp = tcm.getFrameLength() - 1L;
            if (fp < 0L) {
                return;
            }
        } else {
            ChunkModel cm;
            int idx;
            long ofs;
            if (timePos < 0L) {
                ofs = this.panel.getCursorPosition();
                if (ofs < scrollPos || ofs >= scrollPos + this.panel.getVisibleTime()) {
                    ofs = scrollPos + this.panel.getVisibleHalf();
                }
            } else {
                ofs = timePos;
            }
            if ((idx = (cm = this.line.getChunkModel()).getIntervalIndex(ofs + 1L) - 1) < 0) {
                return;
            }
            chunk = cm.getIntervalAt(idx).getLastChunk();
            if (chunk == null) {
                return;
            }
            if (ofs >= chunk.getChunkEnd()) {
                return;
            }
            LineModel model = chunk.getLineModel();
            if (model == null || !(model instanceof TimecodeModel)) {
                return;
            }
            tcm = (TimecodeModel)model;
            fp = LineUtil.getUnitOfs((long)(ofs += chunk.getModelOfs() - chunk.getChunkOfs()), (double)tcm.getUnitRate());
            if (fp < 0L) {
                return;
            }
        }
        long latency = this.timecodeLatencyFrames;
        long frames = tcm.getFrameLength();
        latency = fp >= frames ? ((delay = fp - frames) > latency ? delay : (latency * (long)this.latencyAvgFactor + delay) / (long)this.latencyAvgDivisor) : latency * (long)this.latencyAvgFactor / (long)this.latencyAvgDivisor;
        this.timecodeLatencyFrames = latency;
        if ((fp -= latency) >= frames) {
            fp = frames - 1L;
        }
        if (fp < 0L) {
            if (frames <= 0L) return;
            fp = 0L;
        }
        try {
            tcm.get(fp, this.tca, 0, 1);
            val = this.tca[0];
            if (val != val) {
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        if (!this.timecodeAutoScrolling) return;
        double v = this.invertedDirection ? 1.048576E7 + val * this.zoomRate / 1000.0 : 1.048576E7 - val * this.zoomRate / 1000.0;
        int th = this.timecodeScrollThreshold;
        Rectangle bnd = this.scrollView.getBounds();
        ScrollPos pnt = this.scrollView.getPosition();
        if (this.horiz) {
            int h = bnd.height;
            if (v < (double)(pnt.y + (long)th)) {
                pnt.y = (long)v - (long)th;
            } else if (v >= (double)(pnt.y + (long)h - 1L - (long)th)) {
                pnt.y = Math.round(v - (double)h + 1.0 + (double)th);
            }
        } else {
            int w = bnd.width;
            if (v < (double)(pnt.x + (long)th)) {
                pnt.x = (long)v - (long)th;
            } else if (v >= (double)(pnt.x + (long)w - 1L - (long)th)) {
                pnt.x = Math.round(v - (double)w + 1.0 + (double)th);
            }
        }
        this.scrollView.setPosition(pnt);
    }

    protected void handleMouseWheelMoved(MouseWheelEvent e) {
        int rotation = e.getWheelRotation();
        switch (e.getScrollType()) {
            case 0: {
                e.consume();
                int scroll = rotation * e.getScrollAmount() * this.getPanel().getScrollUnitSize();
                this.scrollTimecode(scroll);
                return;
            }
        }
    }

    protected void scrollTimecode(int scrollPixels) {
        ScrollView scrollView = this.getScrollView();
        ScrollPos p = scrollView.getPosition();
        if (this.horiz) {
            p.y += (long)scrollPixels;
        } else {
            p.x += (long)scrollPixels;
        }
        scrollView.setPosition(p);
        this.validate();
        this.repaint();
    }

    protected void handleKeyPressed(KeyEvent e) {
        int kc = e.getKeyCode();
        switch (kc) {
            case 37: 
            case 38: {
                if (e.isAltDown() && (!this.horiz && e.getKeyCode() == 37 || this.horiz && e.getKeyCode() == 38)) {
                    e.consume();
                    boolean speedup = true;
                    this.startTimecodeScrollTimer(-1, speedup);
                }
                return;
            }
            case 39: 
            case 40: {
                if (e.isAltDown() && (!this.horiz && e.getKeyCode() == 39 || this.horiz && e.getKeyCode() == 40)) {
                    e.consume();
                    boolean speedup = true;
                    this.startTimecodeScrollTimer(1, speedup);
                }
                return;
            }
        }
    }

    protected void handleKeyReleased(KeyEvent e) {
        int kc = e.getKeyCode();
        switch (kc) {
            case 37: 
            case 38: {
                if ((!this.horiz && e.getKeyCode() == 37 || this.horiz && e.getKeyCode() == 38) && this.timecodeScrollIncrement < 0) {
                    this.stopTimecodeScrollTimer();
                }
                return;
            }
            case 39: 
            case 40: {
                if ((!this.horiz && e.getKeyCode() == 39 || this.horiz && e.getKeyCode() == 40) && this.timecodeScrollIncrement > 0) {
                    this.stopTimecodeScrollTimer();
                }
                return;
            }
        }
    }

    protected void handleKeyTyped(KeyEvent e) {
    }

    protected void startTimecodeScrollTimer(int increment, boolean speedup) {
        if (this.timecodeScrollTimer.isRunning()) {
            if (increment > 0 && this.timecodeScrollIncrement > 0 || increment < 0 && this.timecodeScrollIncrement < 0) {
                return;
            }
            this.timecodeScrollIncrement = increment;
            this.timecodeScrollSpeedup = speedup;
            this.timecodeScrollCounter = 0;
            this.timecodeScrollFactor = 1;
            this.timecodeScroller.actionPerformed(null);
            return;
        }
        this.timecodeScrollIncrement = increment;
        this.timecodeScrollSpeedup = speedup;
        this.timecodeScrollCounter = 0;
        this.timecodeScrollFactor = 1;
        this.timecodeScroller.actionPerformed(null);
        this.timecodeScrollTimer.setInitialDelay(this.timecodeScrollInitialDelay);
        this.timecodeScrollTimer.setDelay(this.timecodeScrollDelay);
        this.timecodeScrollTimer.start();
    }

    protected void stopTimecodeScrollTimer() {
        this.timecodeScrollIncrement = 0;
        this.timecodeScrollTimer.stop();
    }

    @Override
    public void scrollLinePageUp() {
        super.scrollLinePageUp();
        Rectangle bnd = this.scrollView.getBounds();
        int scrollPixels = this.horiz ? bnd.height / 2 : bnd.width / 2;
        this.scrollTimecode(-scrollPixels);
    }

    @Override
    public void scrollLinePageDown() {
        super.scrollLinePageDown();
        Rectangle bnd = this.scrollView.getBounds();
        int scrollPixels = this.horiz ? bnd.height / 2 : bnd.width / 2;
        this.scrollTimecode(scrollPixels);
    }

    public boolean isInvertedDirection() {
        return this.invertedDirection;
    }

    public void setInvertedDirection(boolean invertedDirection) {
        this.invertedDirection = invertedDirection;
    }

    public boolean isTimecodeAutoScrolling() {
        return this.timecodeAutoScrolling;
    }

    public void setTimecodeAutoScrolling(boolean timecodeAutoScrolling) {
        this.timecodeAutoScrolling = timecodeAutoScrolling;
    }

    public int getTimecodeScrollThreshold() {
        return this.timecodeScrollThreshold;
    }

    public void setTimecodeScrollThreshold(int timecodeScrollThreshold) {
        this.timecodeScrollThreshold = timecodeScrollThreshold;
    }

    public ScratchPositionView getScratchPositionView() {
        return this.scratchPositionView;
    }

    public void setScratchPositionView(ScratchPositionView scratchPositionView) {
        this.scratchPositionView = scratchPositionView;
        this.refreshScratchPositionView();
    }

    public AudioScratchPlayer getScratchPlayer() {
        return this.scratchPlayer;
    }

    @Override
    public void setScratchPlayer(AudioScratchPlayer scratchPlayer) {
        this.scratchPlayer = scratchPlayer;
        this.refreshScratchPositionView();
    }

    protected void refreshScratchPositionView() {
        ScratchPositionView tpv = this.scratchPositionView;
        if (tpv != null) {
            tpv.setScratchPlayer(this.scratchPlayer);
        }
    }

    public int getTimecodeScrollDelay() {
        return this.timecodeScrollDelay;
    }

    public void setTimecodeScrollDelay(int timecodeScrollDelay) {
        this.timecodeScrollDelay = timecodeScrollDelay;
    }

    public int getTimecodeScrollInitialDelay() {
        return this.timecodeScrollInitialDelay;
    }

    public void setTimecodeScrollInitialDelay(int timecodeScrollInitialDelay) {
        this.timecodeScrollInitialDelay = timecodeScrollInitialDelay;
    }

    public int getTimecodeScrollSpeedupDelay() {
        return this.timecodeScrollSpeedupDelay;
    }

    public void setTimecodeScrollSpeedupDelay(int timecodeScrollSpeedupDelay) {
        this.timecodeScrollSpeedupDelay = timecodeScrollSpeedupDelay;
    }

    public int getTimecodeScrollMaxFactor() {
        return this.timecodeScrollMaxFactor;
    }

    public void setTimecodeScrollMaxFactor(int timecodeScrollMaxFactor) {
        this.timecodeScrollMaxFactor = timecodeScrollMaxFactor;
    }

    public ClockScratchPositionView getClockScratchPositionView() {
        return this.clockScratchPositionView;
    }

    protected void setClockScratchPositionView(ClockScratchPositionView clockScratchPositionView) {
        this.clockScratchPositionView = clockScratchPositionView;
    }

    protected class TimecodeScroller
    implements ActionListener {
        protected TimecodeScroller() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int scrollPixels = AbstractScratchLineWrapper.this.timecodeScrollIncrement * AbstractScratchLineWrapper.this.timecodeScrollFactor;
            AbstractScratchLineWrapper.this.scrollTimecode(scrollPixels);
            if (AbstractScratchLineWrapper.this.timecodeScrollSpeedup && ++AbstractScratchLineWrapper.this.timecodeScrollCounter > AbstractScratchLineWrapper.this.timecodeScrollSpeedupDelay && AbstractScratchLineWrapper.this.timecodeScrollFactor < AbstractScratchLineWrapper.this.timecodeScrollMaxFactor) {
                AbstractScratchLineWrapper.this.timecodeScrollFactor++;
                AbstractScratchLineWrapper.this.timecodeScrollCounter = 0;
            }
        }
    }
}

