/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Editor;
import com.spacekiller.util.EditorContext;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanObserver;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.Selectable;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.impl.FaderClickFaderPointRenderer;
import com.waxmonster.editor.impl.FaderMoveFaderPointRenderer;
import com.waxmonster.midi.MidiMappable;
import com.waxmonster.midi.MidiMapper;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.TimecodeManager;
import com.waxmonster.timecode.common.LfsrTimecodeFormat;
import com.waxmonster.timecode.debug.TimecodeGeneratorOptions;
import com.waxmonster.timecode.debug.TimecodeGeneratorPanel;
import com.waxmonster.view.BackgroundView;
import com.waxmonster.view.CloneView;
import com.waxmonster.view.GridBagViewLayout;
import com.waxmonster.view.ScrollPos;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewLayout;
import com.waxmonster.waxlab.AudioLine;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabListener;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabPanel;
import com.waxmonster.waxlab.util.LineWrapper;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.AudioLineWrapper;
import com.waxmonster.waxlab.view.EditorLineWrapper;
import com.waxmonster.waxlab.view.MidiLineWrapper;
import com.waxmonster.waxlab.view.MultiLinePanel;
import com.waxmonster.waxlab.view.MultiLineSelection;
import com.waxmonster.waxlab.view.MultiLineUtil;
import com.waxmonster.waxlab.view.PositionBarView;
import com.waxmonster.waxlab.view.TimecodeLineWrapper;
import com.waxmonster.waxlab.view.WaxLabOnAirPanel;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoManager;

public abstract class AbstractWaxLabPanel
extends JPanel
implements WaxLabPanel,
Editor,
BeanObserver,
Selectable,
MidiMappable {
    private static final long serialVersionUID = -4468705849804715148L;
    private static final Logger logger = Logger.getLogger(AbstractWaxLabPanel.class.getName());
    private static final String PROPERTY_LINE_PANEL_AREA_SELECTED = "linePanelAreaSelected";
    private static final String PROPERTY_LINE_PANEL_PASTE_ENABLED = "linePanelPasteEnabled";
    private static final String PROPERTY_LINE_PANEL_CUT_ENABLED = "linePanelCutEnabled";
    private static final String PROPERTY_LINE_PANEL_COPY_ENABLED = "linePanelCopyEnabled";
    private static final String PROPERTY_EDITOR_PROPERTIES_ENABLED = "editorPropertiesEnabled";
    private static final String PROPERTY_EDITOR_PASTE_ENABLED = "editorPasteEnabled";
    private static final String PROPERTY_EDITOR_CUT_ENABLED = "editorCutEnabled";
    private static final String PROPERTY_EDITOR_CLONE_ENABLED = "editorCloneEnabled";
    private static final String PROPERTY_EDITOR_COPY_ENABLED = "editorCopyEnabled";
    private static final String PROPERTY_EDITOR_ELEMENTS_SELECTED = "editorElementsSelected";
    private static final String PROPERTY_TIMECODE_LINE_SELECTED = "timecodeLineSelected";
    private static final String PROPERTY_AUDIO_LINE_SELECTED = "audioLineSelected";
    private static final String PROPERTY_MOVE_DOWN_ENABLED = "moveDownEnabled";
    private static final String PROPERTY_MOVE_UP_ENABLED = "moveUpEnabled";
    private static final String PROPERTY_LINE_SELECTED = "lineSelected";
    private static final String PROPERTY_STOP_ENABLED = "stopEnabled";
    private static final String PROPERTY_PAUSE_ENABLED = "pauseEnabled";
    private static final String PROPERTY_START_ENABLED = "startEnabled";
    private static final String PROPERTY_SAVE_ENABLED = "saveEnabled";
    private static final String PROPERTY_OPEN_ENABLED = "openEnabled";
    private static final String PROPERTY_ACTIVE = "active";
    protected static final String PROPERTY_REFRESH_RATE = "refreshRate";
    protected static final String PROPERTY_LINE_ORIENTATION = "lineOrientation";
    protected static final String PROPERTY_STOP_DELAY_MILLIS = "stopDelayMillis";
    protected static final String PROPERTY_SHOW_ON_AIR_PANEL = "showOnAirPanel";
    private static final int DEFAULT_REFRESH_RATE = 50;
    private static final int MAX_REFRESH_INTERVAL = 86400000;
    private static final Line[] NULL_LINES = new Line[0];
    protected static final int DEFAULT_LINE_HEADER_SIZE = 80;
    private static final int LATE_KEY_EVENT_MAX_DELAY = 1000;
    protected final WaxLab waxLab;
    protected Clock clock;
    protected SyncMediator mediator;
    protected final MultiLinePanel linePanel;
    protected final MultiLineSelection selection;
    private Map lineWrapperMap = new HashMap();
    private final WaxLabHandler waxLabHandler = new WaxLabHandler();
    private final StateChangedHandler stateChangedHandler = new StateChangedHandler();
    private final EditorSelectionChangeHandler editorSelectionChangeHandler = new EditorSelectionChangeHandler();
    private final RefreshLater refreshLater = new RefreshLater();
    private volatile boolean refreshPending;
    private Timer refreshTimer;
    private int refreshRate = -1;
    private WaxLabViewSettings viewSettings;
    private int orientation = 0;
    private JPanel toolbarPanel;
    private JToolBar toolBar;
    private JPopupMenu titlePopupMenu;
    private JPopupMenu rulerPopupMenu;
    private JPopupMenu cornerPopupMenu;
    private ViewLayout viewLayout;
    private ScrollView rulerScrollView;
    private PositionBarView posBarView;
    private BackgroundView fillView;
    GridBagConstraints fillConstr;
    private WaxLabDevice waxLabDevice;
    private long startLineOfs;
    private MidiMapper midiMapper;
    private UndoManager undoManager;
    private ClipboardManager clipboardManager;
    private BeanDropSupport beanDropSupport;
    private int stopDelayMillis;
    private Timer stopDelayTimer;
    private DelayedStop delayedStop;
    private WaxLabOnAirPanel waxLabOnAirPanel;
    private boolean showOnAirWindow;
    private Color[] faderShadeColors;
    private FaderMoveFaderPointRenderer faderMoveRenderer;
    private FaderClickFaderPointRenderer faderClickRenderer;
    private JPopupMenu audioLinePopupMenu;
    private JPopupMenu timecodeLinePopupMenu;
    private JPopupMenu midiLinePopupMenu;
    private JPopupMenu faderLinePopupMenu;
    private JPopupMenu editorLinePopupMenu;
    private boolean active;
    private boolean openEnabled;
    private boolean saveEnabled;
    private boolean startEnabled;
    private boolean pauseEnabled;
    private boolean stopEnabled;
    private boolean lineSelected;
    private boolean audioLineSelected;
    private boolean timecodeLineSelected;
    private boolean moveUpEnabled;
    private boolean moveDownEnabled;
    private boolean editorCopyEnabled;
    private boolean editorCloneEnabled;
    private boolean editorCutEnabled;
    private boolean editorPasteEnabled;
    private boolean editorPropertiesEnabled;
    private boolean editorElementsSelected;
    private boolean linePanelCopyEnabled;
    private boolean linePanelCutEnabled;
    private boolean linePanelPasteEnabled;
    private boolean linePanelAreaSelected;

    public AbstractWaxLabPanel(WaxLab waxLab) {
        this.setLayout(new BorderLayout());
        this.waxLab = waxLab;
        this.openEnabled = true;
        this.saveEnabled = true;
        this.startEnabled = true;
        this.editorPasteEnabled = true;
        this.linePanelPasteEnabled = true;
        this.viewSettings = new WaxLabViewSettings();
        this.viewLayout = new GridBagViewLayout();
        this.posBarView = new PositionBarView();
        Rectangle posViewBounds = this.posBarView.getBounds();
        posViewBounds.setBounds(0, 0, -1, -1);
        this.posBarView.setBounds(posViewBounds);
        this.fillView = new BackgroundView();
        this.fillView.setPaint(null);
        this.fillConstr = new GridBagConstraints();
        this.fillConstr.weightx = 1.0;
        this.fillConstr.weighty = 1.0;
        this.toolbarPanel = new JPanel();
        this.toolbarPanel.setOpaque(true);
        this.toolbarPanel.setLayout(new GridLayout(1, 1));
        this.add((Component)this.toolbarPanel, "North");
        this.refreshTimer = new Timer(1000, new Refresher());
        this.refreshTimer.setRepeats(true);
        this.refreshTimer.setCoalesce(true);
        this.setRefreshRate(-1);
        this.delayedStop = new DelayedStop();
        this.stopDelayTimer = new Timer(1000, this.delayedStop);
        this.stopDelayTimer.setRepeats(false);
        this.stopDelayTimer.setCoalesce(true);
        this.waxLabOnAirPanel = new WaxLabOnAirPanel();
        this.waxLabOnAirPanel.setWindowBounds(new Rectangle(10, 10, 30, 30));
        this.faderMoveRenderer = new FaderMoveFaderPointRenderer();
        this.faderClickRenderer = new FaderClickFaderPointRenderer();
        this.faderShadeColors = new Color[]{Color.RED};
        this.linePanel = new MultiLinePanel(this);
        this.linePanel.setViewLayout(this.viewLayout);
        this.linePanel.setOpaque(false);
        this.add((Component)this.linePanel, "Center");
        this.selection = new MultiLineSelection(this.linePanel);
        this.linePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("selectedLineIndices".equals(name)) {
                    AbstractWaxLabPanel.this.handleLinesSelected();
                }
                if ("maximizedLineIndex".equals(name)) {
                    AbstractWaxLabPanel.this.handleMaximizedLineChanged();
                }
            }
        });
        this.rulerScrollView = new ScrollView();
        this.linePanel.setLineSeparatorScrollView(this.rulerScrollView);
        this.linePanel.setPositionBarView(this.posBarView);
        waxLab.registerWaxLabListener((WaxLabListener)this.waxLabHandler);
        this.initActionMap();
        this.initInputMap();
    }

    protected void initActionMap() {
        ActionMap actionMap = this.getActionMap();
        if (actionMap == null) {
            return;
        }
        actionMap.put("ToggleStartPauseAction", new ToggleStartPauseAction());
        actionMap.put("ToggleStartStopAction", new ToggleStartStopAction());
        actionMap = this.linePanel.getActionMap();
        if (actionMap == null) {
            return;
        }
        actionMap.put("ToggleStartPauseAction", new ToggleStartPauseAction());
    }

    protected void initInputMap() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap == null) {
            return;
        }
        inputMap.put(KeyStroke.getKeyStroke(19, 0), "ToggleStartPauseAction");
        inputMap.put(KeyStroke.getKeyStroke(19, 64), "ToggleStartStopAction");
        inputMap = this.linePanel.getInputMap(1);
        if (inputMap == null) {
            return;
        }
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "ToggleStartPauseAction");
    }

    public Component getComponent() {
        return this;
    }

    public MidiMapper getMidiMapper() {
        return this.midiMapper;
    }

    public void setMidiMapper(MidiMapper midiMapper) {
        this.midiMapper = midiMapper;
    }

    public WaxLabDevice getWaxLabDevice() {
        return this.waxLabDevice;
    }

    public void setWaxLabDevice(WaxLabDevice waxLabDevice) {
        this.waxLabDevice = waxLabDevice;
    }

    public void actionStart() {
        try {
            if (this.waxLab.isActive()) {
                if (this.stopDelayTimer.isRunning()) {
                    this.delayedStop.setAction(0);
                    if (this.stopDelayTimer.isRunning()) {
                        this.stopDelayTimer.stop();
                        this.updateStatusInfo();
                    }
                }
                return;
            }
            this.start();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void actionPause() {
        if (!this.waxLab.isActive()) {
            return;
        }
        int delay = this.stopDelayMillis;
        if (delay > 0 && this.waxLab.isActive()) {
            this.delayedStop.setAction(1);
            if (!this.stopDelayTimer.isRunning()) {
                this.stopDelayTimer.setInitialDelay(delay);
                this.stopDelayTimer.setDelay(delay);
                this.stopDelayTimer.start();
            }
            this.updateStatusInfo();
            return;
        }
        this.pause();
    }

    public void actionStop() {
        if (!this.waxLab.isActive()) {
            return;
        }
        int delay = this.stopDelayMillis;
        if (delay > 0 && this.waxLab.isActive()) {
            this.delayedStop.setAction(2);
            if (!this.stopDelayTimer.isRunning()) {
                this.stopDelayTimer.setInitialDelay(delay);
                this.stopDelayTimer.setDelay(delay);
                this.stopDelayTimer.start();
            }
            this.updateStatusInfo();
            return;
        }
        this.stop();
    }

    protected synchronized void start() {
        try {
            if (this.waxLab.isActive()) {
                return;
            }
            this.delayedStop.setAction(0);
            long startLineOfs = this.linePanel.getCursorPosition();
            if (startLineOfs < 0L) {
                startLineOfs = 0L;
            }
            this.startLineOfs = startLineOfs;
            this.waxLab.start(startLineOfs);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected synchronized void stop() {
        try {
            if (!this.waxLab.isActive()) {
                return;
            }
            this.waxLab.stop();
            long newCursorPos = this.linePanel.getCursorPosition();
            boolean center = false;
            this.linePanel.moveCursorPosition(newCursorPos, center);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected synchronized void pause() {
        try {
            if (!this.waxLab.isActive()) {
                return;
            }
            long newCursorPos = -1L;
            SyncMediator sm = this.mediator;
            if (sm != null) {
                long nanoBase = sm.getStartTimeBase();
                long nanoSync = sm.nanoSync(this.clock.nanos());
                long nanos = nanoSync - nanoBase;
                newCursorPos = this.startLineOfs + nanos;
            }
            this.waxLab.stop();
            if (newCursorPos >= 0L) {
                boolean center = false;
                this.linePanel.moveCursorPosition(newCursorPos, center);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final WaxLab getWaxLab() {
        return this.waxLab;
    }

    public void refreshLater() {
        if (this.refreshPending) {
            return;
        }
        this.refreshPending = true;
        SwingUtilities.invokeLater(this.refreshLater);
    }

    protected void handleStateChanged() {
        WaxLab lab = this.waxLab;
        if (lab == null) {
            return;
        }
        boolean active = lab.isActive();
        if (active) {
            this.setActive(true);
            this.linePanel.setHidePositionBarView(false);
            this.linePanel.setRulerViewMode(1);
            if (!this.refreshTimer.isRunning()) {
                this.refreshTimer.start();
            }
        } else {
            this.refreshTimer.stop();
            this.setActive(false);
            this.linePanel.setHidePositionBarView(true);
            this.linePanel.setRulerViewMode(0);
        }
        this.updateStatusInfo();
        this.linePanel.refresh();
    }

    protected synchronized void updateStatusInfo() {
        boolean active = this.active;
        int delayedAction = 0;
        if (this.stopDelayTimer.isRunning()) {
            delayedAction = this.delayedStop.getAction();
        }
        this.setStartEnabled(!active || delayedAction != 0);
        this.setPauseEnabled(active && delayedAction != 1);
        this.setStopEnabled(active && delayedAction != 2);
        this.setOpenEnabled(!active);
        if (this.waxLabOnAirPanel != null) {
            if (active && this.showOnAirWindow) {
                Color backCol;
                boolean stopping = delayedAction == 1 || delayedAction == 2;
                Color color = backCol = stopping ? this.viewSettings.getOnAirStoppingColor() : this.viewSettings.getOnAirRunningColor();
                if (backCol == null) {
                    backCol = Color.RED;
                }
                this.waxLabOnAirPanel.setBackground(backCol);
                if (this.waxLabOnAirPanel.isWindowVisible()) {
                    this.waxLabOnAirPanel.repaint();
                } else {
                    this.waxLabOnAirPanel.setAlwaysOnTop(true);
                    this.waxLabOnAirPanel.setDragWindowEnabled(true);
                    this.waxLabOnAirPanel.setWindowVisible(true);
                }
            } else if (this.waxLabOnAirPanel != null && this.waxLabOnAirPanel.isWindowVisible()) {
                this.waxLabOnAirPanel.setWindowVisible(false);
                Rectangle onAirBounds = this.waxLabOnAirPanel.getWindowBounds();
                if (onAirBounds != null) {
                    this.viewSettings.setOnAirWindowBounds(onAirBounds);
                }
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    protected synchronized void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.firePropertyChange(PROPERTY_ACTIVE, !active, active);
    }

    public boolean isOpenEnabled() {
        return this.openEnabled;
    }

    protected synchronized void setOpenEnabled(boolean openEnabled) {
        if (this.openEnabled == openEnabled) {
            return;
        }
        this.openEnabled = openEnabled;
        this.firePropertyChange(PROPERTY_OPEN_ENABLED, !openEnabled, openEnabled);
    }

    public boolean isSaveEnabled() {
        return this.saveEnabled;
    }

    protected synchronized void setSaveEnabled(boolean saveEnabled) {
        if (this.saveEnabled == saveEnabled) {
            return;
        }
        this.saveEnabled = saveEnabled;
        this.firePropertyChange(PROPERTY_SAVE_ENABLED, !saveEnabled, saveEnabled);
    }

    public boolean isStartEnabled() {
        return this.startEnabled;
    }

    protected synchronized void setStartEnabled(boolean startEnabled) {
        this.startEnabled = startEnabled;
        this.firePropertyChange(PROPERTY_START_ENABLED, !startEnabled, startEnabled);
    }

    public boolean isPauseEnabled() {
        return this.pauseEnabled;
    }

    protected synchronized void setPauseEnabled(boolean pauseEnabled) {
        this.pauseEnabled = pauseEnabled;
        this.firePropertyChange(PROPERTY_PAUSE_ENABLED, !pauseEnabled, pauseEnabled);
    }

    public boolean isStopEnabled() {
        return this.stopEnabled;
    }

    protected synchronized void setStopEnabled(boolean stopEnabled) {
        this.stopEnabled = stopEnabled;
        this.firePropertyChange(PROPERTY_STOP_ENABLED, !stopEnabled, stopEnabled);
    }

    public boolean isLineSelected() {
        return this.lineSelected;
    }

    protected synchronized void setLineSelected(boolean lineSelected) {
        if (this.lineSelected == lineSelected) {
            return;
        }
        this.lineSelected = lineSelected;
        this.firePropertyChange(PROPERTY_LINE_SELECTED, !lineSelected, lineSelected);
    }

    public boolean isMoveUpEnabled() {
        return this.moveUpEnabled;
    }

    protected synchronized void setMoveUpEnabled(boolean moveUpEnabled) {
        if (this.moveUpEnabled == moveUpEnabled) {
            return;
        }
        this.moveUpEnabled = moveUpEnabled;
        this.firePropertyChange(PROPERTY_MOVE_UP_ENABLED, !moveUpEnabled, moveUpEnabled);
    }

    public boolean isMoveDownEnabled() {
        return this.moveDownEnabled;
    }

    protected synchronized void setMoveDownEnabled(boolean moveDownEnabled) {
        if (this.moveDownEnabled == moveDownEnabled) {
            return;
        }
        this.moveDownEnabled = moveDownEnabled;
        this.firePropertyChange(PROPERTY_MOVE_DOWN_ENABLED, !moveDownEnabled, moveDownEnabled);
    }

    public boolean isAudioLineSelected() {
        return this.audioLineSelected;
    }

    protected synchronized void setAudioLineSelected(boolean audioLineSelected) {
        if (this.audioLineSelected == audioLineSelected) {
            return;
        }
        this.audioLineSelected = audioLineSelected;
        this.firePropertyChange(PROPERTY_AUDIO_LINE_SELECTED, !audioLineSelected, audioLineSelected);
    }

    public boolean isTimecodeLineSelected() {
        return this.timecodeLineSelected;
    }

    protected synchronized void setTimecodeLineSelected(boolean timecodeLineSelected) {
        if (this.timecodeLineSelected == timecodeLineSelected) {
            return;
        }
        this.timecodeLineSelected = timecodeLineSelected;
        this.firePropertyChange(PROPERTY_TIMECODE_LINE_SELECTED, !timecodeLineSelected, timecodeLineSelected);
    }

    public boolean isEditorElementsSelected() {
        return this.editorElementsSelected;
    }

    public void setEditorElementsSelected(boolean editorElementsSelected) {
        if (this.editorElementsSelected == editorElementsSelected) {
            return;
        }
        this.editorElementsSelected = editorElementsSelected;
        this.firePropertyChange(PROPERTY_EDITOR_ELEMENTS_SELECTED, !editorElementsSelected, editorElementsSelected);
    }

    public boolean isEditorCopyEnabled() {
        return this.editorCopyEnabled;
    }

    public void setEditorCopyEnabled(boolean editorCopyEnabled) {
        if (this.editorCopyEnabled == editorCopyEnabled) {
            return;
        }
        this.editorCopyEnabled = editorCopyEnabled;
        this.firePropertyChange(PROPERTY_EDITOR_COPY_ENABLED, !editorCopyEnabled, editorCopyEnabled);
    }

    public boolean isEditorCloneEnabled() {
        return this.editorCloneEnabled;
    }

    public void setEditorCloneEnabled(boolean editorCloneEnabled) {
        if (this.editorCloneEnabled == editorCloneEnabled) {
            return;
        }
        this.editorCloneEnabled = editorCloneEnabled;
        this.firePropertyChange(PROPERTY_EDITOR_CLONE_ENABLED, !editorCloneEnabled, editorCloneEnabled);
    }

    public boolean isEditorCutEnabled() {
        return this.editorCutEnabled;
    }

    public void setEditorCutEnabled(boolean editorCutEnabled) {
        if (this.editorCutEnabled == editorCutEnabled) {
            return;
        }
        this.editorCutEnabled = editorCutEnabled;
        this.firePropertyChange(PROPERTY_EDITOR_CUT_ENABLED, !editorCutEnabled, editorCutEnabled);
    }

    public boolean isEditorPasteEnabled() {
        return this.editorPasteEnabled;
    }

    public void setEditorPasteEnabled(boolean editorPasteEnabled) {
        if (this.editorPasteEnabled == editorPasteEnabled) {
            return;
        }
        this.editorPasteEnabled = editorPasteEnabled;
        this.firePropertyChange(PROPERTY_EDITOR_PASTE_ENABLED, !editorPasteEnabled, editorPasteEnabled);
    }

    public boolean isEditorPropertiesEnabled() {
        return this.editorPropertiesEnabled;
    }

    public void setEditorPropertiesEnabled(boolean editorPropertiesEnabled) {
        if (this.editorPropertiesEnabled == editorPropertiesEnabled) {
            return;
        }
        this.editorPropertiesEnabled = editorPropertiesEnabled;
        this.firePropertyChange(PROPERTY_EDITOR_PROPERTIES_ENABLED, !editorPropertiesEnabled, editorPropertiesEnabled);
    }

    public synchronized void refresh() {
        BackgroundView fillView;
        AbstractLineWrapper wrapper2;
        int orient;
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.finer("refresh...");
        }
        boolean horiz = (orient = this.orientation) == 0 || orient == 1;
        int focusLineIndex = this.linePanel.getFocusLineIndex();
        int[] selectedLineIndices = this.linePanel.getSelectedLineIndices();
        int maximizedLineIndex = this.linePanel.getMaximizedLineIndex();
        this.viewLayout.removeAllViews();
        ScrollPos rulerScrollPos = this.rulerScrollView.getPosition();
        if (horiz) {
            rulerScrollPos.y = 0L;
        } else {
            rulerScrollPos.x = 0L;
        }
        this.rulerScrollView.setPosition(rulerScrollPos);
        int lineSepSize = this.viewSettings.getLineSeparatorSize();
        Dimension lineSepPref = new Dimension(lineSepSize, lineSepSize);
        this.linePanel.setLineSeparatorSize(lineSepSize);
        this.posBarView.setColor(this.viewSettings.getPositionBarColor());
        this.linePanel.setPositionBarSize(this.viewSettings.getPositionBarSize());
        HashSet oldWrappers = new HashSet(this.lineWrapperMap.values());
        int lineCount = 0;
        LinkedList<AbstractLineWrapper> lineWrappers = new LinkedList<AbstractLineWrapper>();
        LinkedList<CloneView> lineSeparators = new LinkedList<CloneView>();
        int gridIndex = 0;
        WaxLab waxLab = this.waxLab;
        if (waxLab != null) {
            Line[] lines = waxLab.getLines();
            lineCount = lines.length;
            if (maximizedLineIndex >= lineCount) {
                maximizedLineIndex = -1;
            }
            for (int i = 0; i < lineCount; ++i) {
                Line line = lines[i];
                if (line == null) continue;
                int lineGridIndex = gridIndex;
                if (maximizedLineIndex >= 0 && maximizedLineIndex != i) {
                    lineGridIndex = -1;
                }
                ViewLayout viewLayout = this.viewLayout;
                wrapper2 = (AbstractLineWrapper)this.lineWrapperMap.get(line);
                if (wrapper2 == null) {
                    if (line instanceof AudioLine) {
                        AudioLine audioLine = (AudioLine)line;
                        AudioLineWrapper audioWrapper = new AudioLineWrapper(this.linePanel, audioLine, viewLayout, lineGridIndex, this.linePanel, this.viewSettings);
                        audioWrapper.setLinePopupMenu(this.audioLinePopupMenu);
                        audioWrapper.setFaderShadeColors(this.faderShadeColors);
                        wrapper2 = audioWrapper;
                    } else if (line instanceof MidiLine) {
                        MidiLine midiLine = (MidiLine)line;
                        MidiLineWrapper midiWrapper = new MidiLineWrapper(this.linePanel, midiLine, viewLayout, lineGridIndex, this.linePanel, this.viewSettings);
                        midiWrapper.setLinePopupMenu(this.midiLinePopupMenu);
                        wrapper2 = midiWrapper;
                    } else if (line instanceof TimecodeLine) {
                        TimecodeLine timecodeLine = (TimecodeLine)line;
                        TimecodeLineWrapper timecodeWrapper = new TimecodeLineWrapper(this.linePanel, timecodeLine, viewLayout, lineGridIndex, this.linePanel, this.viewSettings);
                        timecodeWrapper.setLinePopupMenu(this.timecodeLinePopupMenu);
                        timecodeWrapper.setFaderShadeColors(this.faderShadeColors);
                        wrapper2 = timecodeWrapper;
                    } else if (line instanceof EditorLine) {
                        EditorLine editorLine = (EditorLine)line;
                        WaxLabPreferences waxLabPrefs = waxLab.getWaxLabPreferences();
                        float mergeFrameRate = waxLabPrefs.getPreferredAudioFrameRate();
                        EditorLineWrapper editorWrapper = new EditorLineWrapper(this.linePanel, editorLine, viewLayout, lineGridIndex, this.linePanel, this.viewSettings, mergeFrameRate);
                        editorWrapper.setLinePopupMenu(this.editorLinePopupMenu);
                        editorWrapper.setBeanDropSupport(this.beanDropSupport);
                        editorWrapper.setClipboardManager(this.clipboardManager);
                        editorWrapper.setEditorSelectionChangeHandler(this.editorSelectionChangeHandler);
                        editorWrapper.setInterpolatorRegistry(waxLab.getInterpolatorRegistry());
                        editorWrapper.setFaderClickRenderer(this.faderClickRenderer);
                        editorWrapper.setFaderMoveRenderer(this.faderMoveRenderer);
                        wrapper2 = editorWrapper;
                    }
                    if (wrapper2 == null) continue;
                    this.lineWrapperMap.put(line, wrapper2);
                } else {
                    oldWrappers.remove(wrapper2);
                    wrapper2.setGridIndex(lineGridIndex);
                }
                wrapper2.setViewSettings(this.viewSettings);
                wrapper2.setOrientation(orient);
                wrapper2.layout();
                if (line instanceof AbstractLine) {
                    AbstractLine asl = (AbstractLine)line;
                    asl.setWrapper((LineWrapper)wrapper2);
                }
                lineWrappers.add(wrapper2);
                ++gridIndex;
                if (maximizedLineIndex >= 0) continue;
                CloneView cloneView = new CloneView((View)this.rulerScrollView);
                cloneView.setPreferredSize(lineSepPref);
                GridBagConstraints gbc = new GridBagConstraints();
                if (horiz) {
                    gbc.gridx = 0;
                    gbc.gridy = gridIndex;
                    gbc.weightx = 1.0;
                    gbc.weighty = 0.0;
                } else {
                    gbc.gridx = gridIndex;
                    gbc.gridy = 0;
                    gbc.weightx = 0.0;
                    gbc.weighty = 1.0;
                }
                gbc.fill = 1;
                viewLayout.addView((View)cloneView, (Object)gbc);
                lineSeparators.add(cloneView);
                ++gridIndex;
            }
        }
        if (!oldWrappers.isEmpty()) {
            for (AbstractLineWrapper wrapper2 : oldWrappers) {
                wrapper2.dispose();
            }
        }
        if (maximizedLineIndex < 0 && (fillView = this.fillView) != null) {
            if (horiz) {
                this.fillConstr.gridx = 0;
                this.fillConstr.gridy = gridIndex;
            } else {
                this.fillConstr.gridx = gridIndex;
                this.fillConstr.gridy = 0;
            }
            this.viewLayout.addView((View)fillView, (Object)this.fillConstr);
        }
        View[] separators = lineSeparators.toArray(new View[lineSeparators.size()]);
        this.linePanel.setLineSeparators(separators);
        AbstractLineWrapper[] wrappers = lineWrappers.toArray(new AbstractLineWrapper[lineWrappers.size()]);
        this.linePanel.setLineWrappers(wrappers);
        int num = wrappers.length;
        for (int i = 0; i < num; ++i) {
            wrapper2 = wrappers[i];
            wrapper2.setLineWrappers(wrappers);
            wrapper2.refresh();
        }
        this.linePanel.setOrientation(orient);
        if (selectedLineIndices.length > 0) {
            this.linePanel.setSelectedLineIndices(selectedLineIndices);
        }
        if (focusLineIndex >= 0 && focusLineIndex < lineCount) {
            this.linePanel.setFocusLineIndex(focusLineIndex);
        }
        this.handleEditorSelectionChanged();
        this.linePanel.setZoomRate(this.linePanel.getZoomRate());
        if (finer) {
            logger.finer("refresh done.");
        }
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public synchronized void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
        if (this.waxLab != null) {
            this.waxLab.setProperty(PROPERTY_REFRESH_RATE, String.valueOf(refreshRate));
        }
        if (refreshRate < 0) {
            refreshRate = 50;
        }
        int delay = refreshRate > 0 ? (int)Math.round(1000.0 / (double)refreshRate) : 86400000;
        this.refreshTimer.setInitialDelay(delay);
        this.refreshTimer.setDelay(delay);
    }

    protected UndoManager lookupUndoManager() {
        Workbench workbench = WorkbenchUtilities.getWorkbench((Component)this.linePanel);
        if (workbench != null) {
            return workbench.getUndoManager();
        }
        return null;
    }

    public UndoManager getUndoManager() {
        if (this.undoManager == null) {
            this.setUndoManager(this.lookupUndoManager());
        }
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public ClipboardManager getClipboardManager() {
        return this.clipboardManager;
    }

    public void setClipboardManager(ClipboardManager clipboardManager) {
        this.clipboardManager = clipboardManager;
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    public WaxLabViewSettings getViewSettings() {
        WaxLabViewSettings orig = this.viewSettings;
        return orig == null ? null : orig.cloneWaxMonsterViewSettings();
    }

    public synchronized void setViewSettings(WaxLabViewSettings newViewSettings) {
        this.viewSettings = newViewSettings.cloneWaxMonsterViewSettings();
        this.linePanel.setBackgroundPaint(this.viewSettings.getBackgroundPaint());
        this.linePanel.setSelectionPaint(this.viewSettings.getSelectionPaint());
        this.linePanel.setCursorPaint(this.viewSettings.getCursorPaint());
        this.linePanel.setRulerBackground(this.viewSettings.getRulerBackground());
        this.linePanel.setRulerBorderColor(this.viewSettings.getRulerBorderColor());
        this.linePanel.setRulerMinorTickColor(this.viewSettings.getRulerMinorTickColor());
        this.linePanel.setRulerMajorTickColor(this.viewSettings.getRulerMajorTickColor());
        this.linePanel.setRulerLabelColor(this.viewSettings.getRulerLabelColor());
        this.linePanel.setRulerLabelFont(this.viewSettings.getRulerLabelFont());
        this.linePanel.setRulerMaxTileCacheCount(this.viewSettings.getRulerMaxTileCacheCount());
        this.linePanel.setLineScrollUnitIncrement(this.viewSettings.getLineScrollUnitIncrement());
        Color startColor = this.viewSettings.getTimecodeViewBackground();
        Color endColor = new Color(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), 0);
        int shadeSteps = this.viewSettings.getShadingColorSteps();
        this.faderShadeColors = this.createColorArray(startColor, endColor, shadeSteps);
        Color faderClickBack = null;
        Color viewBack = this.viewSettings.getEditorViewBackground();
        if (viewBack != null) {
            if (viewBack instanceof Color) {
                Color col = viewBack;
                int alpha = Math.round(this.viewSettings.getEditorFaderOffClickOpacity() * 255.0f);
                faderClickBack = new Color(col.getRed(), col.getGreen(), col.getBlue(), alpha);
            }
            this.faderClickRenderer.setOffClickBackPaint(faderClickBack);
        }
        this.faderClickRenderer.setOffClickLineColor(this.viewSettings.getEditorFaderOffClickLineColor());
        this.faderClickRenderer.setOffClickFillColor(this.viewSettings.getEditorFaderOffClickFillColor());
        this.faderClickRenderer.setOnClickLineColor(this.viewSettings.getEditorFaderOnClickLineColor());
        this.faderClickRenderer.setOnClickFillColor(this.viewSettings.getEditorFaderOnClickFillColor());
        this.faderMoveRenderer.setPointLineColor(this.viewSettings.getEditorFaderMoveLineColor());
        Color onColor = this.viewSettings.getEditorFaderMoveFillColorOn();
        Color offColor = this.viewSettings.getEditorFaderMoveFillColorOff();
        int colSteps = this.viewSettings.getEditorFaderMoveFillColorSteps();
        Color[] pointFillColors = this.createColorArray(onColor, offColor, colSteps);
        this.faderMoveRenderer.setPointFillColors(pointFillColors);
        Rectangle onAirBounds = this.viewSettings.getOnAirWindowBounds();
        if (onAirBounds != null && this.waxLabOnAirPanel != null) {
            if (onAirBounds.width < 1 || onAirBounds.height < 1) {
                onAirBounds.width = 30;
                onAirBounds.height = 30;
            }
            this.waxLabOnAirPanel.setWindowBounds(onAirBounds);
        }
        this.refreshLater();
    }

    protected void handleEditorSelectionChanged() {
        AbstractLineWrapper wrapper;
        boolean elementsSelected = false;
        boolean enableProperties = false;
        boolean enableCopy = false;
        boolean enableCut = false;
        int selIndex = this.linePanel.getFocusLineIndex();
        if (selIndex >= 0 && (wrapper = this.linePanel.getLineWrapperAt(selIndex)) != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            if (editor.getSelectedWaxEditorItemCount() > 0) {
                elementsSelected = true;
                enableCopy = true;
                enableCut = true;
                enableProperties = true;
            } else if (editor.getSelectedFaderPointCount() > 0) {
                elementsSelected = true;
                enableProperties = true;
            } else {
                WaxEditorItem[] models = editor.getWaxEditorItemsForSelectedPoints();
                if (models.length > 0) {
                    elementsSelected = true;
                    enableCut = true;
                }
            }
        }
        this.setEditorElementsSelected(elementsSelected);
        this.setEditorCopyEnabled(enableCopy);
        this.setEditorCloneEnabled(enableCopy);
        this.setEditorCutEnabled(enableCut);
        this.setEditorPropertiesEnabled(enableProperties);
    }

    public int getStopDelayMillis() {
        return this.stopDelayMillis;
    }

    public synchronized void setStopDelayMillis(int stopDelayMillis) {
        if (stopDelayMillis < 0) {
            stopDelayMillis = 0;
        }
        this.stopDelayMillis = stopDelayMillis;
        if (this.waxLab != null) {
            this.waxLab.setProperty(PROPERTY_STOP_DELAY_MILLIS, String.valueOf(stopDelayMillis));
        }
        this.stopDelayTimer.setInitialDelay(stopDelayMillis);
        this.stopDelayTimer.setDelay(stopDelayMillis);
    }

    public boolean isShowOnAirWindow() {
        return this.showOnAirWindow;
    }

    public synchronized void setShowOnAirWindow(boolean showOnAirPanel) {
        WaxLab lab;
        this.showOnAirWindow = showOnAirPanel;
        if (this.waxLab != null) {
            this.waxLab.setProperty(PROPERTY_SHOW_ON_AIR_PANEL, String.valueOf(showOnAirPanel));
        }
        if ((lab = this.waxLab) != null) {
            this.updateStatusInfo();
        }
    }

    public Rectangle getOnAirWindowBounds() {
        return this.waxLabOnAirPanel.getWindowBounds();
    }

    public synchronized void setOnAirWindowBounds(Rectangle onAirWindowBounds) {
        if (onAirWindowBounds != null) {
            this.waxLabOnAirPanel.setWindowBounds(onAirWindowBounds);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public void openTimecodeGeneratorDialog() throws Exception {
        TimecodeManager timecodeManager;
        TimecodeGeneratorOptions options = new TimecodeGeneratorOptions();
        options.setResolution(1000);
        options.setLength(1000);
        LfsrTimecodeFormat[] lfsrTimecodeFormats = null;
        if (this.waxLab != null && (timecodeManager = this.waxLab.getTimecodeManager()) != null) {
            int num;
            TimecodeFormat[] timecodeFormats = timecodeManager.getTimecodeFormats();
            int n = num = timecodeFormats == null ? 0 : timecodeFormats.length;
            if (num > 0) {
                LinkedList<LfsrTimecodeFormat> list = new LinkedList<LfsrTimecodeFormat>();
                for (int i = 0; i < num; ++i) {
                    TimecodeFormat format = timecodeFormats[i];
                    if (format == null || !(format instanceof LfsrTimecodeFormat)) continue;
                    list.add((LfsrTimecodeFormat)format);
                }
                lfsrTimecodeFormats = list.toArray(new LfsrTimecodeFormat[list.size()]);
            }
        }
        TimecodeGeneratorPanel panel = new TimecodeGeneratorPanel();
        panel.setTimecodeFormats(lfsrTimecodeFormats);
        panel.setOptions(options);
        String iconResource = "/com/waxmonster/timecode/debug/icons/timecode_generator_icon16.png";
        Image iconImage = null;
        try {
            ImageIcon icon;
            URL iconURL = this.getClass().getResource(iconResource);
            if (iconURL != null && (icon = new ImageIcon(iconURL)) != null) {
                iconImage = icon.getImage();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        JFrame frame = new JFrame();
        frame.setResizable(true);
        frame.setTitle("Timecode Generator");
        frame.setContentPane((Container)panel);
        frame.setIconImage(iconImage);
        frame.pack();
        Tools.centerWindow((Component)this, (Window)frame);
        frame.setVisible(true);
    }

    public void openMovieGeneratorDialog() throws Exception {
        this.linePanel.showMovieGeneratorDialog();
    }

    protected Color[] createColorArray(Color startColor, Color endColor, int steps) {
        if (steps < 0) {
            steps = 0;
        }
        int num = steps + 2;
        Color[] arr = new Color[num];
        arr[0] = startColor;
        arr[num - 1] = endColor;
        for (int i = 1; i <= steps; ++i) {
            double endFactor = (double)i / (double)num;
            double startFactor = 1.0 - endFactor;
            int r = (int)((double)startColor.getRed() * startFactor + (double)endColor.getRed() * endFactor);
            int g = (int)((double)startColor.getGreen() * startFactor + (double)endColor.getGreen() * endFactor);
            int b = (int)((double)startColor.getBlue() * startFactor + (double)endColor.getBlue() * endFactor);
            int a = (int)((double)startColor.getAlpha() * startFactor + (double)endColor.getAlpha() * endFactor);
            arr[i] = new Color(r, g, b, a);
        }
        return arr;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public synchronized void setToolBar(JToolBar toolBar) {
        if (this.toolBar == toolBar) {
            return;
        }
        this.toolBar = toolBar;
        this.toolbarPanel.removeAll();
        if (toolBar != null) {
            this.toolbarPanel.add(toolBar);
        }
        this.toolbarPanel.validate();
        this.toolbarPanel.repaint();
    }

    public JPopupMenu getTitlePopupMenu() {
        return this.titlePopupMenu;
    }

    public void setTitlePopupMenu(JPopupMenu titlePopupMenu) {
        this.titlePopupMenu = titlePopupMenu;
        this.linePanel.setTitlePopupMenu(titlePopupMenu);
    }

    public JPopupMenu getRulerPopupMenu() {
        return this.rulerPopupMenu;
    }

    public void setRulerPopupMenu(JPopupMenu rulerPopupMenu) {
        this.rulerPopupMenu = rulerPopupMenu;
        this.linePanel.setRulerPopupMenu(rulerPopupMenu);
    }

    public JPopupMenu getCornerPopupMenu() {
        return this.cornerPopupMenu;
    }

    public void setCornerPopupMenu(JPopupMenu cornerPopupMenu) {
        this.cornerPopupMenu = cornerPopupMenu;
        this.linePanel.setCornerMenu(cornerPopupMenu);
    }

    public Line[] getSelectedStudioLines() {
        int[] sel = this.linePanel.getSelectedLineIndices();
        int num = sel.length;
        if (num < 1) {
            return NULL_LINES;
        }
        Line[] arr = new Line[num];
        for (int i = 0; i < num; ++i) {
            AbstractLineWrapper wrapper = this.linePanel.getLineWrapperAt(sel[i]);
            arr[i] = wrapper == null ? null : wrapper.getLine();
        }
        return arr;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public synchronized void setOrientation(int orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        if (this.waxLab != null) {
            this.waxLab.setProperty(PROPERTY_LINE_ORIENTATION, String.valueOf(orientation));
        }
        this.refreshLater();
    }

    public JPopupMenu getAudioLinePopupMenu() {
        return this.audioLinePopupMenu;
    }

    public void setAudioLinePopupMenu(JPopupMenu audioLinePopupMenu) {
        this.audioLinePopupMenu = audioLinePopupMenu;
    }

    public JPopupMenu getTimecodeLinePopupMenu() {
        return this.timecodeLinePopupMenu;
    }

    public void setTimecodeLinePopupMenu(JPopupMenu timecodeLinePopupMenu) {
        this.timecodeLinePopupMenu = timecodeLinePopupMenu;
    }

    public JPopupMenu getMidiLinePopupMenu() {
        return this.midiLinePopupMenu;
    }

    public void setMidiLinePopupMenu(JPopupMenu midiLinePopupMenu) {
        this.midiLinePopupMenu = midiLinePopupMenu;
    }

    public JPopupMenu getFaderLinePopupMenu() {
        return this.faderLinePopupMenu;
    }

    public void setFaderLinePopupMenu(JPopupMenu faderLinePopupMenu) {
        this.faderLinePopupMenu = faderLinePopupMenu;
    }

    public JPopupMenu getEditorLinePopupMenu() {
        return this.editorLinePopupMenu;
    }

    public void setEditorLinePopupMenu(JPopupMenu editorLinePopupMenu) {
        this.editorLinePopupMenu = editorLinePopupMenu;
    }

    public boolean isRefreshTimerRunning() {
        return this.refreshTimer.isRunning();
    }

    protected void handleLinesSelected() {
        int lineIndex = this.linePanel.getFocusLineIndex();
        int lineCount = this.linePanel.getLineCount();
        int[] sel = this.linePanel.getSelectedLineIndices();
        int minSelIndex = -1;
        int maxSelIndex = -1;
        for (int i = 0; i < sel.length; ++i) {
            int idx = sel[i];
            if (idx < 0) continue;
            if (idx < minSelIndex || minSelIndex < 0) {
                minSelIndex = idx;
            }
            if (idx <= maxSelIndex && maxSelIndex >= 0) continue;
            maxSelIndex = idx;
        }
        this.setLineSelected(minSelIndex >= 0);
        this.setMoveUpEnabled(minSelIndex > 0);
        this.setMoveDownEnabled(maxSelIndex >= 0 && maxSelIndex < lineCount - 1);
        boolean audioLine = false;
        boolean tcLine = false;
        if (lineIndex >= 0 && sel.length == 1) {
            Line line = this.waxLab.getLineAt(lineIndex);
            audioLine = line instanceof AudioLine;
            tcLine = line instanceof TimecodeLine;
        }
        this.setAudioLineSelected(audioLine);
        this.setTimecodeLineSelected(tcLine);
    }

    protected void handleMaximizedLineChanged() {
        this.refresh();
    }

    protected AbstractLineWrapper getFocusLineWrapper() {
        int selIndex;
        WaxLab studio = this.getWaxLab();
        if (studio != null && (selIndex = this.linePanel.getFocusLineIndex()) >= 0) {
            return this.linePanel.getLineWrapperAt(selIndex);
        }
        return null;
    }

    public void setEditorContext(EditorContext context) {
    }

    public boolean isDirty() throws Exception {
        if (this.waxLab != null) {
            return this.waxLab.isDirty();
        }
        return false;
    }

    public void scrollLineToVisible(int lineIndex) {
        this.linePanel.scrollLineToVisible(lineIndex);
    }

    public void selectAll() {
        this.linePanel.selectAll();
    }

    public void deselectAll() {
        this.linePanel.deselectAll();
    }

    protected boolean ignoreLateKeyEvent(ActionEvent ev, AbstractAction aa) {
        long delay = System.currentTimeMillis() - ev.getWhen();
        if (delay > 1000L) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Ignoring late event: " + ev + ", action=" + aa);
            }
            return true;
        }
        return false;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public boolean addBean(Object o) throws Exception {
        logger.warning("TODO addBean: " + this + ", object=" + o);
        return false;
    }

    public void invokeCopyAction() throws Exception {
        MultiLineUtil.performCopyAction(this.linePanel);
    }

    public void invokeCutAction() throws Exception {
        boolean keepDeletedArea = false;
        MultiLineUtil.performCutAction(this.linePanel, keepDeletedArea);
    }

    public void invokeDeleteAction() throws Exception {
        boolean keepDeletedArea = false;
        MultiLineUtil.performDeleteAction(this.linePanel, keepDeletedArea);
    }

    public void invokePasteAction() throws Exception {
        boolean replaceArea = false;
        MultiLineUtil.performPasteAction(this.linePanel, replaceArea);
    }

    public void invokePasteReplaceAction() throws Exception {
        boolean replaceArea = true;
        MultiLineUtil.performPasteAction(this.linePanel, replaceArea);
    }

    public void invokeInsertFileAction() throws Exception {
        boolean replaceArea = false;
        MultiLineUtil.performInsertFileAction(this.linePanel, replaceArea);
    }

    public void invokeReverseAction() throws Exception {
        throw new UnsupportedOperationException("TODO");
    }

    public void invokeInverseAction() throws Exception {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isLinePanelCopyEnabled() {
        return this.linePanelCopyEnabled;
    }

    public void setLinePanelCopyEnabled(boolean linePanelCopyEnabled) {
        if (this.linePanelCopyEnabled == linePanelCopyEnabled) {
            return;
        }
        this.linePanelCopyEnabled = linePanelCopyEnabled;
        this.firePropertyChange(PROPERTY_LINE_PANEL_COPY_ENABLED, !linePanelCopyEnabled, linePanelCopyEnabled);
    }

    public boolean isLinePanelCutEnabled() {
        return this.linePanelCutEnabled;
    }

    public void setLinePanelCutEnabled(boolean linePanelCutEnabled) {
        if (this.linePanelCutEnabled == linePanelCutEnabled) {
            return;
        }
        this.linePanelCutEnabled = linePanelCutEnabled;
        this.firePropertyChange(PROPERTY_LINE_PANEL_CUT_ENABLED, !linePanelCutEnabled, linePanelCutEnabled);
    }

    public boolean isLinePanelPasteEnabled() {
        return this.linePanelPasteEnabled;
    }

    public void setLinePanelPasteEnabled(boolean linePanelPasteEnabled) {
        if (this.linePanelPasteEnabled == linePanelPasteEnabled) {
            return;
        }
        this.linePanelPasteEnabled = linePanelPasteEnabled;
        this.firePropertyChange(PROPERTY_LINE_PANEL_PASTE_ENABLED, !linePanelPasteEnabled, linePanelPasteEnabled);
    }

    public boolean isLinePanelAreaSelected() {
        return this.linePanelAreaSelected;
    }

    public void setLinePanelAreaSelected(boolean linePanelAreaSelected) {
        if (this.linePanelAreaSelected == linePanelAreaSelected) {
            return;
        }
        this.linePanelAreaSelected = linePanelAreaSelected;
        this.firePropertyChange(PROPERTY_LINE_PANEL_AREA_SELECTED, !linePanelAreaSelected, linePanelAreaSelected);
    }

    protected void lineSelectionAreaChanged(MultiLinePanel linePanel) {
        double selLead;
        double selAnchor;
        boolean areaSelected = false;
        if (linePanel != null && (selAnchor = (double)linePanel.getSelectionAnchorPos()) >= 0.0 && (selLead = (double)linePanel.getSelectionLeadPos()) >= 0.0) {
            areaSelected = true;
        }
        if (areaSelected != this.linePanelAreaSelected) {
            this.setLinePanelAreaSelected(areaSelected);
            this.setLinePanelCopyEnabled(areaSelected);
            this.setLinePanelCutEnabled(areaSelected);
        }
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public SyncMediator getMediator() {
        return this.mediator;
    }

    public void setMediator(SyncMediator mediator) {
        this.mediator = mediator;
    }

    protected class ToggleStartStopAction
    extends AbstractAction {
        private static final long serialVersionUID = 7027718289484458268L;
        public static final String ACTION_KEY = "ToggleStartStopAction";

        protected ToggleStartStopAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractWaxLabPanel.this.ignoreLateKeyEvent(e, this)) {
                return;
            }
            if (AbstractWaxLabPanel.this.waxLab.isActive()) {
                AbstractWaxLabPanel.this.actionStop();
            } else {
                AbstractWaxLabPanel.this.actionStart();
            }
        }
    }

    protected class ToggleStartPauseAction
    extends AbstractAction {
        private static final long serialVersionUID = -959115048095740249L;
        public static final String ACTION_KEY = "ToggleStartPauseAction";

        protected ToggleStartPauseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractWaxLabPanel.this.ignoreLateKeyEvent(e, this)) {
                return;
            }
            if (AbstractWaxLabPanel.this.waxLab.isActive()) {
                AbstractWaxLabPanel.this.actionPause();
            } else {
                AbstractWaxLabPanel.this.actionStart();
            }
        }
    }

    protected class EditorSelectionChangeHandler
    implements ChangeListener {
        protected EditorSelectionChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractWaxLabPanel.this.handleEditorSelectionChanged();
        }
    }

    protected class DelayedStop
    implements ActionListener {
        public static final int ACTION_NONE = 0;
        public static final int ACTION_PAUSE = 1;
        public static final int ACTION_STOP = 2;
        private int action;

        protected DelayedStop() {
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            switch (this.action) {
                case 1: {
                    AbstractWaxLabPanel.this.pause();
                    break;
                }
                case 2: {
                    AbstractWaxLabPanel.this.stop();
                }
            }
        }

        public synchronized int getAction() {
            return this.action;
        }

        public synchronized void setAction(int action) {
            this.action = action;
        }
    }

    protected class RefreshLater
    implements Runnable {
        protected RefreshLater() {
        }

        @Override
        public void run() {
            AbstractWaxLabPanel.this.refreshPending = false;
            AbstractWaxLabPanel.this.refresh();
        }
    }

    protected class Refresher
    implements ActionListener {
        protected Refresher() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SyncMediator sm = AbstractWaxLabPanel.this.mediator;
            if (sm == null) {
                return;
            }
            long nanoBase = sm.getStartTimeBase();
            long nanoSync = sm.nanoSync(AbstractWaxLabPanel.this.clock.nanos());
            long nanos = nanoSync - nanoBase;
            AbstractWaxLabPanel.this.linePanel.updateTimePosition(AbstractWaxLabPanel.this.startLineOfs + nanos);
        }
    }

    protected class StateChangedHandler
    implements Runnable {
        protected StateChangedHandler() {
        }

        @Override
        public void run() {
            AbstractWaxLabPanel.this.handleStateChanged();
        }
    }

    protected class WaxLabHandler
    implements WaxLabListener {
        protected WaxLabHandler() {
        }

        public void stateChanged(boolean active) {
            if (!active && logger.isLoggable(Level.FINE)) {
                AbstractLineWrapper[] wrappers = AbstractWaxLabPanel.this.linePanel.getLineWrappers();
                logger.fine("WaxLab stopped: lines=" + wrappers.length);
                if (logger.isLoggable(Level.FINER)) {
                    for (int i = 0; i < wrappers.length; ++i) {
                        TileView tv = wrappers[i].getTileView();
                        if (tv == null) continue;
                        String tileInfo = "[created=" + tv.getCreateTileCounter() + ", reused=" + tv.getReuseTileCounter() + ", repainted=" + tv.getRepaintTileCounter() + ", recycled=" + tv.getRecycleTileCounter() + ", contentLost=" + tv.getContentLostCounter() + ", restored=" + tv.getRestoreImageCounter() + ", incompatile=" + tv.getIncompatibleImageCounter() + "]";
                        logger.finer("Line#" + i + ": tileView=" + tileInfo);
                    }
                }
            }
            SwingUtilities.invokeLater(AbstractWaxLabPanel.this.stateChangedHandler);
        }

        public void lineInserted(Line line, int index) {
            AbstractWaxLabPanel.this.refreshLater();
        }

        public void lineRemoved(Line line, int index) {
            AbstractWaxLabPanel.this.refreshLater();
        }

        public void lineMoved(Line line, int newIndex) {
            AbstractWaxLabPanel.this.refreshLater();
        }

        public void lineChanged(Line line) {
            AbstractWaxLabPanel.this.refreshLater();
        }
    }
}

