/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.media.control.AbstractEnumControl;
import com.spacekiller.util.media.control.ComboBoxControlPanel;
import com.spacekiller.util.media.control.Control;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.studio.PortType;
import com.waxmonster.waxlab.AudioLineConfig;
import com.waxmonster.waxlab.AudioRenderControl;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.util.WaxLabXmlUtil;
import com.waxmonster.waxlab.view.CommonLineConfigPanel;
import com.waxmonster.waxlab.view.TimecodeLineConfigPanel;
import com.waxmonster.waxlab.view.WaxLabPortChooser;
import com.waxmonster.waxlab.view.WaxLabViewUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class AudioLineConfigPanel
extends JPanel {
    private static final long serialVersionUID = -6789634637965471545L;
    private static final Logger logger = Logger.getLogger(AudioLineConfigPanel.class.getName());
    private static final String AUDIO_RENDER_DEFAULT = "<Default>";
    private static final String[] AUDIO_RENDER_MODES = new String[]{"<Default>", "Mono", "Stereo", "Peaks", "Colorized"};
    private WaxLabPortInfo[] waxLabPorts;
    private AudioLineConfig audioLineConfig;
    private AudioRenderControl audioRenderControl;
    private boolean refreshing;
    private JPanel jPanelRecording = null;
    private JPanel jPanelPlayback = null;
    private JCheckBox jCheckBoxRecording = null;
    private JCheckBox jCheckBoxPlayback = null;
    private JPanel jPanelViewOptions = null;
    private JCheckBox jCheckBoxBackgroundShading = null;
    private JPanel panelRecProps;
    private JLabel labelRecChannels;
    private JComboBox comboBoxRecChannels;
    private JLabel labelRecBits;
    private JComboBox comboBoxRecSampleType;
    private JPanel panel;
    private JLabel labelPlayChannels;
    private JComboBox comboBoxPlayChannels;
    private JLabel lblPortsRec;
    private WaxLabPortChooser waxLabPortChooserRec;
    private JLabel lblPortsPlay;
    private WaxLabPortChooser waxLabPortChooserPlay;
    private JPanel panel_1;
    private JLabel lblAudioRendering_1;
    private ComboBoxControlPanel comboBoxControlPanelAudioRenderMode;
    private JTabbedPane tabbedPane;
    private JPanel panelAudioPortsTab;
    private JPanel panelViewOptionsTab;
    private CommonLineConfigPanel commonLineConfigPanel;
    private JPanel panelFill;

    public AudioLineConfigPanel() {
        this.initialize();
        this.initAudioLineConfigPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints21.gridy = 1;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(559, 462));
        GridBagConstraints gbc_commonLineConfigPanel = new GridBagConstraints();
        gbc_commonLineConfigPanel.insets = new Insets(0, 0, 5, 0);
        gbc_commonLineConfigPanel.weightx = 1.0;
        gbc_commonLineConfigPanel.fill = 1;
        gbc_commonLineConfigPanel.gridx = 0;
        gbc_commonLineConfigPanel.gridy = 0;
        this.add((Component)this.getCommonLineConfigPanel(), gbc_commonLineConfigPanel);
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.weightx = 1.0;
        gbc_tabbedPane.insets = new Insets(0, 0, 5, 0);
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 1;
        this.add((Component)this.getTabbedPane(), gbc_tabbedPane);
        GridBagConstraints gbc_panelFill = new GridBagConstraints();
        gbc_panelFill.weighty = 1.0;
        gbc_panelFill.weightx = 1.0;
        gbc_panelFill.fill = 1;
        gbc_panelFill.gridx = 0;
        gbc_panelFill.gridy = 2;
        this.add((Component)this.getPanelFill(), gbc_panelFill);
    }

    protected void initAudioLineConfigPanel() {
        this.audioRenderControl = new AudioRenderControlImpl(AUDIO_RENDER_MODES);
        this.getComboBoxControlPanelAudioRenderMode().setControl((Control)this.audioRenderControl);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            this.getCommonLineConfigPanel().setLineConfig((LineConfig)this.audioLineConfig);
            boolean recEnabled = false;
            int recFrameType = -1;
            int recSampleType = -1;
            boolean playEnabled = false;
            int playFrameType = -1;
            boolean backgroundShading = false;
            String audioRenderMode = null;
            WaxLabPortInfo[] recPorts = null;
            WaxLabPortInfo[] playPorts = null;
            if (this.audioLineConfig != null) {
                recEnabled = this.audioLineConfig.isRecordingEnabled();
                recFrameType = this.audioLineConfig.getRecordingFrameType();
                recSampleType = this.audioLineConfig.getRecordingSampleType();
                playEnabled = this.audioLineConfig.isPlaybackEnabled();
                playFrameType = this.audioLineConfig.getPlaybackFrameType();
                backgroundShading = this.audioLineConfig.isBackgroundShading();
                audioRenderMode = this.audioLineConfig.getAudioRenderMode();
                recPorts = this.audioLineConfig.getRecordingPorts();
                playPorts = this.audioLineConfig.getPlaybackPorts();
            }
            this.jCheckBoxRecording.setSelected(recEnabled);
            int[] sampleTypes = WaxLabViewUtil.getSampleTypes();
            this.comboBoxRecSampleType.removeAllItems();
            int recSampleTypeIndex = -1;
            for (int i = 0; i < sampleTypes.length; ++i) {
                int sampleType = sampleTypes[i];
                String sampleTypeString = WaxLabViewUtil.formatSampleType(sampleType);
                if (sampleTypeString == null) continue;
                if (recSampleType == sampleType) {
                    recSampleTypeIndex = this.comboBoxRecSampleType.getItemCount();
                }
                this.comboBoxRecSampleType.addItem(sampleTypeString);
            }
            if (recSampleTypeIndex >= 0) {
                this.comboBoxRecSampleType.setSelectedIndex(recSampleTypeIndex);
            }
            int[] frameTypes = WaxLabViewUtil.getFrameTypes();
            this.comboBoxRecChannels.removeAllItems();
            int recFrameTypeIndex = -1;
            for (int i = 0; i < frameTypes.length; ++i) {
                int frameType = frameTypes[i];
                String frameTypeString = WaxLabViewUtil.formatFrameType(frameType);
                if (frameTypeString == null) continue;
                if (recFrameType == frameType) {
                    recFrameTypeIndex = this.comboBoxRecChannels.getItemCount();
                }
                this.comboBoxRecChannels.addItem(frameTypeString);
            }
            if (recFrameTypeIndex >= 0) {
                this.comboBoxRecChannels.setSelectedIndex(recFrameTypeIndex);
            }
            int recChannels = WaxLabXmlUtil.getFrameTypeChannelCount((int)recFrameType);
            this.waxLabPortChooserRec.setAudioChannelCount(recChannels);
            this.waxLabPortChooserRec.setSelectedPorts(recPorts);
            this.jCheckBoxPlayback.setSelected(playEnabled);
            this.comboBoxPlayChannels.removeAllItems();
            int playFrameTypeIndex = -1;
            for (int i = 0; i < frameTypes.length; ++i) {
                int frameType = frameTypes[i];
                String frameTypeString = WaxLabViewUtil.formatFrameType(frameType);
                if (frameTypeString == null) continue;
                if (playFrameType == frameType) {
                    playFrameTypeIndex = this.comboBoxPlayChannels.getItemCount();
                }
                this.comboBoxPlayChannels.addItem(frameTypeString);
            }
            if (playFrameTypeIndex >= 0) {
                this.comboBoxPlayChannels.setSelectedIndex(playFrameTypeIndex);
            }
            int playChannels = WaxLabXmlUtil.getFrameTypeChannelCount((int)playFrameType);
            this.waxLabPortChooserPlay.setAudioChannelCount(playChannels);
            this.waxLabPortChooserPlay.setSelectedPorts(playPorts);
            this.jCheckBoxBackgroundShading.setSelected(backgroundShading);
            try {
                if (audioRenderMode == null) {
                    audioRenderMode = AUDIO_RENDER_DEFAULT;
                }
                this.audioRenderControl.setValue((Object)audioRenderMode);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.checkEnable();
            this.checkPorts();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    private JPanel getJPanelRecording() {
        if (this.jPanelRecording == null) {
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.anchor = 17;
            gridBagConstraints41.gridy = 0;
            this.jPanelRecording = new JPanel();
            GridBagLayout gbl_jPanelRecording = new GridBagLayout();
            gbl_jPanelRecording.rowHeights = new int[]{0, 0};
            gbl_jPanelRecording.rowWeights = new double[]{0.0, 0.0};
            gbl_jPanelRecording.columnWidths = new int[]{0};
            gbl_jPanelRecording.columnWeights = new double[]{0.0};
            this.jPanelRecording.setLayout(gbl_jPanelRecording);
            this.jPanelRecording.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Audio Recording", 4, 2, null, new Color(51, 51, 51)));
            this.jPanelRecording.add((Component)this.getJCheckBoxRecording(), gridBagConstraints41);
            GridBagConstraints gbc_panelRecProps = new GridBagConstraints();
            gbc_panelRecProps.insets = new Insets(0, 4, 4, 4);
            gbc_panelRecProps.weightx = 1.0;
            gbc_panelRecProps.fill = 1;
            gbc_panelRecProps.gridx = 0;
            gbc_panelRecProps.gridy = 1;
            this.jPanelRecording.add((Component)this.getPanelRecProps(), gbc_panelRecProps);
        }
        return this.jPanelRecording;
    }

    private JPanel getJPanelPlayback() {
        if (this.jPanelPlayback == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.gridy = 0;
            this.jPanelPlayback = new JPanel();
            GridBagLayout gbl_jPanelPlayback = new GridBagLayout();
            gbl_jPanelPlayback.rowHeights = new int[]{0, 0};
            gbl_jPanelPlayback.rowWeights = new double[]{0.0, 0.0};
            gbl_jPanelPlayback.columnWidths = new int[]{0};
            gbl_jPanelPlayback.columnWeights = new double[]{0.0};
            this.jPanelPlayback.setLayout(gbl_jPanelPlayback);
            this.jPanelPlayback.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Audio Playback", 4, 2, null, new Color(51, 51, 51)));
            this.jPanelPlayback.add((Component)this.getJCheckBoxPlayback(), gridBagConstraints10);
            GridBagConstraints gbc_panel = new GridBagConstraints();
            gbc_panel.insets = new Insets(0, 4, 4, 4);
            gbc_panel.fill = 1;
            gbc_panel.gridx = 0;
            gbc_panel.gridy = 1;
            this.jPanelPlayback.add((Component)this.getPanel(), gbc_panel);
        }
        return this.jPanelPlayback;
    }

    public AudioLineConfig getAudioLineConfig() {
        return this.audioLineConfig;
    }

    public void setAudioLineConfig(AudioLineConfig audioLineConfig) {
        this.audioLineConfig = audioLineConfig;
        this.refresh();
    }

    protected void checkEnable() {
        boolean recEnabled = this.jCheckBoxRecording.isSelected();
        this.labelRecChannels.setEnabled(recEnabled);
        this.comboBoxRecChannels.setEnabled(recEnabled);
        this.labelRecBits.setEnabled(recEnabled);
        this.comboBoxRecSampleType.setEnabled(recEnabled);
        this.lblPortsRec.setEnabled(recEnabled);
        this.waxLabPortChooserRec.setEnabled(recEnabled);
        boolean playEnabled = this.jCheckBoxPlayback.isSelected();
        this.labelPlayChannels.setEnabled(playEnabled);
        this.comboBoxPlayChannels.setEnabled(playEnabled);
        this.lblPortsPlay.setEnabled(playEnabled);
        this.waxLabPortChooserPlay.setEnabled(playEnabled);
    }

    protected void apply() {
        AudioLineConfig config = this.getAudioLineConfig();
        if (config == null) {
            return;
        }
        config.setRecordingEnabled(this.jCheckBoxRecording.isSelected());
        config.setPlaybackEnabled(this.jCheckBoxPlayback.isSelected());
        config.setBackgroundShading(this.jCheckBoxBackgroundShading.isSelected());
        String audioRenderMode = null;
        Object audioRenderModeItem = this.audioRenderControl.getValue();
        if (audioRenderModeItem != null && AUDIO_RENDER_DEFAULT.equals(audioRenderMode = String.valueOf(audioRenderModeItem))) {
            audioRenderMode = null;
        }
        config.setAudioRenderMode(audioRenderMode);
        int recSampleType = -1;
        Object recSampleTypeItem = this.comboBoxRecSampleType.getSelectedItem();
        if (recSampleTypeItem != null) {
            recSampleType = WaxLabViewUtil.parseSampleType(String.valueOf(recSampleTypeItem));
        }
        config.setRecordingSampleType(recSampleType);
        int recFrameType = -1;
        Object recFrameTypeItem = this.comboBoxRecChannels.getSelectedItem();
        if (recFrameTypeItem != null) {
            recFrameType = WaxLabViewUtil.parseFrameType(String.valueOf(recFrameTypeItem));
        }
        config.setRecordingFrameType(recFrameType);
        int playFrameType = -1;
        Object playFrameTypeItem = this.comboBoxPlayChannels.getSelectedItem();
        if (playFrameTypeItem != null) {
            playFrameType = WaxLabViewUtil.parseFrameType(String.valueOf(playFrameTypeItem));
        }
        config.setPlaybackFrameType(playFrameType);
        WaxLabPortInfo[] recPorts = this.waxLabPortChooserRec.getSelectedPorts();
        config.setRecordingPorts(recPorts);
        WaxLabPortInfo[] playPorts = this.waxLabPortChooserPlay.getSelectedPorts();
        config.setPlaybackPorts(playPorts);
    }

    private JCheckBox getJCheckBoxRecording() {
        if (this.jCheckBoxRecording == null) {
            this.jCheckBoxRecording = new JCheckBox();
            this.jCheckBoxRecording.setText("Enabled");
            this.jCheckBoxRecording.setToolTipText("Recording enabled ?");
            this.jCheckBoxRecording.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AudioLineConfigPanel.this.checkEnable();
                    if (!AudioLineConfigPanel.this.refreshing) {
                        AudioLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxRecording;
    }

    private JCheckBox getJCheckBoxPlayback() {
        if (this.jCheckBoxPlayback == null) {
            this.jCheckBoxPlayback = new JCheckBox();
            this.jCheckBoxPlayback.setText("Enabled");
            this.jCheckBoxPlayback.setOpaque(false);
            this.jCheckBoxPlayback.setToolTipText("Playback enabled ?");
            this.jCheckBoxPlayback.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AudioLineConfigPanel.this.checkEnable();
                    if (!AudioLineConfigPanel.this.refreshing) {
                        AudioLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxPlayback;
    }

    private JPanel getJPanelViewOptions() {
        if (this.jPanelViewOptions == null) {
            GridBagConstraints gridBagConstraints191 = new GridBagConstraints();
            gridBagConstraints191.anchor = 17;
            gridBagConstraints191.gridy = 1;
            gridBagConstraints191.weightx = 1.0;
            gridBagConstraints191.gridx = 0;
            this.jPanelViewOptions = new JPanel();
            GridBagLayout gbl_jPanelViewOptions = new GridBagLayout();
            gbl_jPanelViewOptions.rowWeights = new double[]{1.0, 0.0};
            gbl_jPanelViewOptions.columnWeights = new double[]{0.0};
            this.jPanelViewOptions.setLayout(gbl_jPanelViewOptions);
            this.jPanelViewOptions.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "View Options", 4, 2, null, new Color(51, 51, 51)));
            GridBagConstraints gbc_panel_1 = new GridBagConstraints();
            gbc_panel_1.insets = new Insets(4, 4, 4, 4);
            gbc_panel_1.fill = 1;
            gbc_panel_1.gridx = 0;
            gbc_panel_1.gridy = 0;
            this.jPanelViewOptions.add((Component)this.getPanel_1(), gbc_panel_1);
            this.jPanelViewOptions.add((Component)this.getJCheckBoxBackgroundShading(), gridBagConstraints191);
        }
        return this.jPanelViewOptions;
    }

    private JCheckBox getJCheckBoxBackgroundShading() {
        if (this.jCheckBoxBackgroundShading == null) {
            this.jCheckBoxBackgroundShading = new JCheckBox();
            this.jCheckBoxBackgroundShading.setToolTipText("Background shading ?");
            this.jCheckBoxBackgroundShading.setOpaque(false);
            this.jCheckBoxBackgroundShading.setText("Fade Background");
            this.jCheckBoxBackgroundShading.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!AudioLineConfigPanel.this.refreshing) {
                        AudioLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxBackgroundShading;
    }

    public void enableRecording() {
        this.getJCheckBoxRecording().setSelected(true);
    }

    public void enablePlayback() {
        this.getJCheckBoxPlayback().setSelected(true);
    }

    private JPanel getPanelRecProps() {
        if (this.panelRecProps == null) {
            this.panelRecProps = new JPanel();
            GridBagLayout gbl_panelRecProps = new GridBagLayout();
            gbl_panelRecProps.columnWidths = new int[]{0, 0, 0, 0, 0};
            gbl_panelRecProps.rowHeights = new int[]{0, 0, 0};
            gbl_panelRecProps.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panelRecProps.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelRecProps.setLayout(gbl_panelRecProps);
            GridBagConstraints gbc_labelRecChannels = new GridBagConstraints();
            gbc_labelRecChannels.anchor = 17;
            gbc_labelRecChannels.insets = new Insets(0, 0, 5, 5);
            gbc_labelRecChannels.gridx = 0;
            gbc_labelRecChannels.gridy = 0;
            this.panelRecProps.add((Component)this.getLabelRecChannels(), gbc_labelRecChannels);
            GridBagConstraints gbc_comboBoxRecChannels = new GridBagConstraints();
            gbc_comboBoxRecChannels.insets = new Insets(0, 0, 5, 5);
            gbc_comboBoxRecChannels.gridx = 1;
            gbc_comboBoxRecChannels.gridy = 0;
            this.panelRecProps.add((Component)this.getComboBoxRecChannels(), gbc_comboBoxRecChannels);
            GridBagConstraints gbc_labelRecBits = new GridBagConstraints();
            gbc_labelRecBits.insets = new Insets(0, 4, 5, 5);
            gbc_labelRecBits.gridx = 2;
            gbc_labelRecBits.gridy = 0;
            this.panelRecProps.add((Component)this.getLabelRecBits(), gbc_labelRecBits);
            GridBagConstraints gbc_comboBoxRecSampleType = new GridBagConstraints();
            gbc_comboBoxRecSampleType.anchor = 17;
            gbc_comboBoxRecSampleType.insets = new Insets(0, 4, 5, 0);
            gbc_comboBoxRecSampleType.gridx = 3;
            gbc_comboBoxRecSampleType.gridy = 0;
            this.panelRecProps.add((Component)this.getComboBoxRecSampleType(), gbc_comboBoxRecSampleType);
            GridBagConstraints gbc_lblPortsRec = new GridBagConstraints();
            gbc_lblPortsRec.anchor = 18;
            gbc_lblPortsRec.insets = new Insets(4, 0, 4, 5);
            gbc_lblPortsRec.gridx = 0;
            gbc_lblPortsRec.gridy = 1;
            this.panelRecProps.add((Component)this.getLblPortsRec(), gbc_lblPortsRec);
            GridBagConstraints gbc_waxLabPortChooserRec = new GridBagConstraints();
            gbc_waxLabPortChooserRec.weightx = 1.0;
            gbc_waxLabPortChooserRec.fill = 1;
            gbc_waxLabPortChooserRec.anchor = 17;
            gbc_waxLabPortChooserRec.gridwidth = 3;
            gbc_waxLabPortChooserRec.gridx = 1;
            gbc_waxLabPortChooserRec.gridy = 1;
            this.panelRecProps.add((Component)this.getWaxLabPortChooserRec(), gbc_waxLabPortChooserRec);
        }
        return this.panelRecProps;
    }

    private JLabel getLabelRecChannels() {
        if (this.labelRecChannels == null) {
            this.labelRecChannels = new JLabel("Channels:");
            this.labelRecChannels.setToolTipText("Number of audio channels");
        }
        return this.labelRecChannels;
    }

    private JComboBox getComboBoxRecChannels() {
        if (this.comboBoxRecChannels == null) {
            this.comboBoxRecChannels = new JComboBox();
            this.comboBoxRecChannels.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !AudioLineConfigPanel.this.refreshing) {
                        AudioLineConfigPanel.this.checkPorts();
                        AudioLineConfigPanel.this.apply();
                    }
                }
            });
            this.comboBoxRecChannels.setOpaque(false);
        }
        return this.comboBoxRecChannels;
    }

    private JLabel getLabelRecBits() {
        if (this.labelRecBits == null) {
            this.labelRecBits = new JLabel("Sample Type:");
            this.labelRecBits.setToolTipText("Audio sample type");
        }
        return this.labelRecBits;
    }

    private JComboBox getComboBoxRecSampleType() {
        if (this.comboBoxRecSampleType == null) {
            this.comboBoxRecSampleType = new JComboBox();
            this.comboBoxRecSampleType.setToolTipText("Audio sample type");
            this.comboBoxRecSampleType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!AudioLineConfigPanel.this.refreshing) {
                        AudioLineConfigPanel.this.apply();
                    }
                }
            });
            this.comboBoxRecSampleType.setOpaque(false);
        }
        return this.comboBoxRecSampleType;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gbl_panel = new GridBagLayout();
            gbl_panel.columnWidths = new int[]{0, 0, 0};
            gbl_panel.rowHeights = new int[]{25, 0, 0};
            gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panel.setLayout(gbl_panel);
            GridBagConstraints gbc_labelPlayChannels = new GridBagConstraints();
            gbc_labelPlayChannels.anchor = 17;
            gbc_labelPlayChannels.insets = new Insets(0, 0, 5, 5);
            gbc_labelPlayChannels.gridx = 0;
            gbc_labelPlayChannels.gridy = 0;
            this.panel.add((Component)this.getLabelPlayChannels(), gbc_labelPlayChannels);
            GridBagConstraints gbc_comboBoxPlayChannels = new GridBagConstraints();
            gbc_comboBoxPlayChannels.anchor = 17;
            gbc_comboBoxPlayChannels.insets = new Insets(0, 0, 5, 0);
            gbc_comboBoxPlayChannels.gridx = 1;
            gbc_comboBoxPlayChannels.gridy = 0;
            this.panel.add((Component)this.getComboBoxPlayChannels(), gbc_comboBoxPlayChannels);
            GridBagConstraints gbc_lblPortsPlay = new GridBagConstraints();
            gbc_lblPortsPlay.anchor = 18;
            gbc_lblPortsPlay.insets = new Insets(4, 0, 4, 5);
            gbc_lblPortsPlay.gridx = 0;
            gbc_lblPortsPlay.gridy = 1;
            this.panel.add((Component)this.getLblPortsPlay(), gbc_lblPortsPlay);
            GridBagConstraints gbc_waxLabPortChooserPlay = new GridBagConstraints();
            gbc_waxLabPortChooserPlay.weightx = 1.0;
            gbc_waxLabPortChooserPlay.fill = 1;
            gbc_waxLabPortChooserPlay.anchor = 17;
            gbc_waxLabPortChooserPlay.gridx = 1;
            gbc_waxLabPortChooserPlay.gridy = 1;
            this.panel.add((Component)this.getWaxLabPortChooserPlay(), gbc_waxLabPortChooserPlay);
        }
        return this.panel;
    }

    private JLabel getLabelPlayChannels() {
        if (this.labelPlayChannels == null) {
            this.labelPlayChannels = new JLabel("Channels:");
            this.labelPlayChannels.setToolTipText("Number of audio channels");
        }
        return this.labelPlayChannels;
    }

    private JComboBox getComboBoxPlayChannels() {
        if (this.comboBoxPlayChannels == null) {
            this.comboBoxPlayChannels = new JComboBox();
            this.comboBoxPlayChannels.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !AudioLineConfigPanel.this.refreshing) {
                        AudioLineConfigPanel.this.checkPorts();
                        AudioLineConfigPanel.this.apply();
                    }
                }
            });
            this.comboBoxPlayChannels.setOpaque(false);
        }
        return this.comboBoxPlayChannels;
    }

    private JLabel getLblPortsRec() {
        if (this.lblPortsRec == null) {
            this.lblPortsRec = new JLabel("Input Ports:");
            this.lblPortsRec.setToolTipText("Recording input port(s)");
        }
        return this.lblPortsRec;
    }

    private WaxLabPortChooser getWaxLabPortChooserRec() {
        if (this.waxLabPortChooserRec == null) {
            this.waxLabPortChooserRec = new WaxLabPortChooser();
            this.waxLabPortChooserRec.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!AudioLineConfigPanel.this.refreshing) {
                        AudioLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.waxLabPortChooserRec;
    }

    private JLabel getLblPortsPlay() {
        if (this.lblPortsPlay == null) {
            this.lblPortsPlay = new JLabel("Output Ports:");
            this.lblPortsPlay.setToolTipText("Playback output port(s)");
        }
        return this.lblPortsPlay;
    }

    private WaxLabPortChooser getWaxLabPortChooserPlay() {
        if (this.waxLabPortChooserPlay == null) {
            this.waxLabPortChooserPlay = new WaxLabPortChooser();
            this.waxLabPortChooserPlay.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!AudioLineConfigPanel.this.refreshing) {
                        AudioLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.waxLabPortChooserPlay;
    }

    public WaxLabPortInfo[] getWaxLabPorts() {
        return this.waxLabPorts;
    }

    public void setWaxLabPorts(WaxLabPortInfo[] waxLabPorts) {
        this.waxLabPorts = waxLabPorts;
        LinkedList<WaxLabPortInfo> listInput = new LinkedList<WaxLabPortInfo>();
        LinkedList<WaxLabPortInfo> listOutput = new LinkedList<WaxLabPortInfo>();
        if (waxLabPorts != null) {
            for (int i = 0; i < waxLabPorts.length; ++i) {
                WaxLabPortInfo info = waxLabPorts[i];
                if (info == null) continue;
                PortType portType = info.getType();
                if (portType != null && portType instanceof AudioInputPortType) {
                    listInput.add(info);
                }
                if (portType == null || !(portType instanceof AudioOutputPortType)) continue;
                listOutput.add(info);
            }
        }
        WaxLabPortInfo[] inputPorts = listInput.toArray(new WaxLabPortInfo[listInput.size()]);
        this.waxLabPortChooserRec.setAvailablePorts(inputPorts);
        WaxLabPortInfo[] outputPorts = listOutput.toArray(new WaxLabPortInfo[listOutput.size()]);
        this.waxLabPortChooserPlay.setAvailablePorts(outputPorts);
    }

    protected void checkPorts() {
        int recFrameType = -1;
        Object recFrameTypeItem = this.comboBoxRecChannels.getSelectedItem();
        if (recFrameTypeItem != null) {
            recFrameType = WaxLabViewUtil.parseFrameType(String.valueOf(recFrameTypeItem));
        }
        int recChannels = -1;
        if (recFrameType >= 0) {
            recChannels = WaxLabXmlUtil.getFrameTypeChannelCount((int)recFrameType);
        }
        int playFrameType = -1;
        Object playFrameTypeitem = this.comboBoxPlayChannels.getSelectedItem();
        if (playFrameTypeitem != null) {
            playFrameType = WaxLabViewUtil.parseFrameType(String.valueOf(playFrameTypeitem));
        }
        int playChannels = -1;
        if (playFrameType >= 0) {
            playChannels = WaxLabXmlUtil.getFrameTypeChannelCount((int)playFrameType);
        }
        if (recChannels < 0) {
            recChannels = 0;
        }
        if (playChannels < 0) {
            playChannels = 0;
        }
        if (recChannels != this.waxLabPortChooserRec.getAudioChannelCount() || playChannels != this.waxLabPortChooserPlay.getAudioChannelCount()) {
            this.waxLabPortChooserRec.setAudioChannelCount(recChannels);
            this.waxLabPortChooserPlay.setAudioChannelCount(playChannels);
            this.validate();
            this.repaint();
        }
    }

    private JPanel getPanel_1() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            GridBagLayout gbl_panel_1 = new GridBagLayout();
            gbl_panel_1.columnWidths = new int[]{0, 0, 0};
            gbl_panel_1.rowHeights = new int[]{0, 0};
            gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_1.rowWeights = new double[]{1.0, Double.MIN_VALUE};
            this.panel_1.setLayout(gbl_panel_1);
            GridBagConstraints gbc_lblAudioRendering_1 = new GridBagConstraints();
            gbc_lblAudioRendering_1.insets = new Insets(0, 0, 0, 5);
            gbc_lblAudioRendering_1.gridx = 0;
            gbc_lblAudioRendering_1.gridy = 0;
            this.panel_1.add((Component)this.getLblAudioRendering_1(), gbc_lblAudioRendering_1);
            GridBagConstraints gbc_comboBoxControlPanelAudioRenderMode = new GridBagConstraints();
            gbc_comboBoxControlPanelAudioRenderMode.fill = 1;
            gbc_comboBoxControlPanelAudioRenderMode.gridx = 1;
            gbc_comboBoxControlPanelAudioRenderMode.gridy = 0;
            this.panel_1.add((Component)this.getComboBoxControlPanelAudioRenderMode(), gbc_comboBoxControlPanelAudioRenderMode);
        }
        return this.panel_1;
    }

    private JLabel getLblAudioRendering_1() {
        if (this.lblAudioRendering_1 == null) {
            this.lblAudioRendering_1 = new JLabel("Audio Rendering:");
        }
        return this.lblAudioRendering_1;
    }

    private ComboBoxControlPanel getComboBoxControlPanelAudioRenderMode() {
        if (this.comboBoxControlPanelAudioRenderMode == null) {
            this.comboBoxControlPanelAudioRenderMode = new ComboBoxControlPanel();
        }
        return this.comboBoxControlPanelAudioRenderMode;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1);
            this.tabbedPane.setTabLayoutPolicy(1);
            this.tabbedPane.addTab("Audio  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/audioline_icon.gif")), this.getPanelAudioPortsTab(), "Audio ports");
            this.tabbedPane.addTab("View  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/color_icon.gif")), this.getPanelViewOptionsTab(), "View options");
        }
        return this.tabbedPane;
    }

    private JPanel getPanelAudioPortsTab() {
        if (this.panelAudioPortsTab == null) {
            this.panelAudioPortsTab = new JPanel();
            GridBagLayout gbl_panelAudioPortsTab = new GridBagLayout();
            gbl_panelAudioPortsTab.columnWidths = new int[]{246, 0};
            gbl_panelAudioPortsTab.rowHeights = new int[]{117, 117, 0};
            gbl_panelAudioPortsTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelAudioPortsTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelAudioPortsTab.setLayout(gbl_panelAudioPortsTab);
            GridBagConstraints gbc_jPanelRecording = new GridBagConstraints();
            gbc_jPanelRecording.weightx = 1.0;
            gbc_jPanelRecording.fill = 1;
            gbc_jPanelRecording.insets = new Insets(4, 4, 5, 5);
            gbc_jPanelRecording.gridx = 0;
            gbc_jPanelRecording.gridy = 0;
            this.panelAudioPortsTab.add((Component)this.getJPanelRecording(), gbc_jPanelRecording);
            GridBagConstraints gbc_jPanelPlayback = new GridBagConstraints();
            gbc_jPanelPlayback.insets = new Insets(4, 4, 5, 5);
            gbc_jPanelPlayback.weightx = 1.0;
            gbc_jPanelPlayback.fill = 1;
            gbc_jPanelPlayback.gridx = 0;
            gbc_jPanelPlayback.gridy = 1;
            this.panelAudioPortsTab.add((Component)this.getJPanelPlayback(), gbc_jPanelPlayback);
        }
        return this.panelAudioPortsTab;
    }

    private JPanel getPanelViewOptionsTab() {
        if (this.panelViewOptionsTab == null) {
            this.panelViewOptionsTab = new JPanel();
            GridBagLayout gbl_panelViewOptionsTab = new GridBagLayout();
            gbl_panelViewOptionsTab.columnWidths = new int[]{152, 0};
            gbl_panelViewOptionsTab.rowHeights = new int[]{81, 0};
            gbl_panelViewOptionsTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelViewOptionsTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelViewOptionsTab.setLayout(gbl_panelViewOptionsTab);
            GridBagConstraints gbc_jPanelViewOptions = new GridBagConstraints();
            gbc_jPanelViewOptions.insets = new Insets(4, 4, 5, 5);
            gbc_jPanelViewOptions.weightx = 1.0;
            gbc_jPanelViewOptions.fill = 1;
            gbc_jPanelViewOptions.gridx = 0;
            gbc_jPanelViewOptions.gridy = 0;
            this.panelViewOptionsTab.add((Component)this.getJPanelViewOptions(), gbc_jPanelViewOptions);
        }
        return this.panelViewOptionsTab;
    }

    private CommonLineConfigPanel getCommonLineConfigPanel() {
        if (this.commonLineConfigPanel == null) {
            this.commonLineConfigPanel = new CommonLineConfigPanel();
        }
        return this.commonLineConfigPanel;
    }

    private JPanel getPanelFill() {
        if (this.panelFill == null) {
            this.panelFill = new JPanel();
        }
        return this.panelFill;
    }

    protected class AudioRenderControlImpl
    extends AbstractEnumControl
    implements AudioRenderControl {
        public AudioRenderControlImpl(Object[] renderModes) {
            this.setValues(renderModes);
        }

        protected void applyValue(Object v) {
            if (!AudioLineConfigPanel.this.refreshing) {
                AudioLineConfigPanel.this.apply();
            }
        }
    }
}

