/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.model.ChunkListener;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.CachedAudioModel;
import com.waxmonster.model.view.ChunkModelLineView;
import com.waxmonster.model.view.ChunkRenderer;
import com.waxmonster.model.view.LineManager;
import com.waxmonster.model.view.LineView;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewLayout;
import com.waxmonster.waxlab.AudioLine;
import com.waxmonster.waxlab.AudioLineConfig;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.ChunkRendererUtil;
import com.waxmonster.waxlab.view.MultiLinePanel;
import com.waxmonster.waxlab.view.WaxLabFileFilters;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;

public class AudioLineWrapper
extends AbstractLineWrapper {
    private static final Logger logger = Logger.getLogger(AudioLineWrapper.class.getName());
    private final AudioLine audioLine;
    private ChunkModelLineView chunkModelLineView;
    private ChunkRenderer audioChunkRenderer;
    private int audioInitCapacity;
    private Color[] faderShadeColors;
    private int faderInitCapacity;
    private String audioRenderMode;
    private LineChunk prevRecChunk;

    public AudioLineWrapper(MultiLinePanel panel, AudioLine audioLine, ViewLayout layout, int gridIndex, LineManager manager, WaxLabViewSettings viewSettings) {
        super(panel, (Line)audioLine, layout, gridIndex);
        this.audioLine = audioLine;
        this.setLineManager(manager);
        int trackSize = audioLine.getTrackSize();
        if (trackSize < 0) {
            trackSize = viewSettings.getAudioViewSize();
        }
        this.setTrackSize(trackSize);
        ScrollView scrollView = new ScrollView();
        this.setScrollView(scrollView);
        this.setRecRefreshToPos(false);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        ChunkModel chunkModel = this.line.getChunkModel();
        if (chunkModel != null) {
            chunkModel.registerChunkListener((ChunkListener)this.chunkHandler);
        }
    }

    @Override
    public void dispose() {
        ChunkModel chunkModel = this.line.getChunkModel();
        if (chunkModel != null) {
            chunkModel.unregisterChunkListener((ChunkListener)this.chunkHandler);
        }
        super.dispose();
    }

    public final AudioLine getAudioLine() {
        return this.audioLine;
    }

    public int getAudioInitCapacity() {
        return this.audioInitCapacity;
    }

    public void setAudioInitCapacity(int audioInitCapacity) {
        this.audioInitCapacity = audioInitCapacity;
    }

    public Color[] getFaderShadeColors() {
        return this.faderShadeColors;
    }

    public void setFaderShadeColors(Color[] faderShadeColors) {
        this.faderShadeColors = faderShadeColors;
    }

    public int getFaderInitCapacity() {
        return this.faderInitCapacity;
    }

    public void setFaderInitCapacity(int faderInitCapacity) {
        this.faderInitCapacity = faderInitCapacity;
    }

    public long computeTimeLength() {
        return this.line.computeTimeLength();
    }

    @Override
    public void refresh() {
        TileView tileView;
        int tileHeight;
        AudioLineConfig config = this.audioLine.getAudioLineConfig();
        String audioRenderMode = null;
        if (config != null) {
            audioRenderMode = config.getAudioRenderMode();
        }
        if (audioRenderMode == null) {
            audioRenderMode = "Peaks";
        }
        if (audioRenderMode != null && !audioRenderMode.equals(this.audioRenderMode)) {
            this.audioRenderMode = audioRenderMode;
            this.audioChunkRenderer = null;
        }
        if (this.chunkModelLineView == null) {
            this.chunkModelLineView = new ChunkModelLineView();
        }
        this.chunkModelLineView.setChunkModel(this.audioLine.getChunkModel());
        if (this.audioChunkRenderer == null) {
            this.audioChunkRenderer = ChunkRendererUtil.getInstance().createAudioChunkRenderer(audioRenderMode, this.audioInitCapacity, this.viewSettings);
        }
        this.chunkModelLineView.setChunkRenderer(this.audioChunkRenderer);
        this.chunkModelLineView.setLineManager(this.lineManager);
        this.layoutLineView((LineView)this.chunkModelLineView);
        this.lineViews = new LineView[]{this.chunkModelLineView};
        this.setLineViews(this.lineViews);
        int tileWidth = this.trackSize;
        if (tileWidth < 1) {
            tileWidth = 1;
        }
        if ((tileHeight = this.trackSize) < 1) {
            tileHeight = 1;
        }
        if ((tileView = this.tileView) != null && (tileView.getTileWidth() != tileWidth || tileView.getTileHeight() != tileHeight)) {
            tileView.flush();
            tileView = null;
        }
        if (tileView == null) {
            int maxTileCacheCount = this.viewSettings.getAudioTileCacheCount();
            if (maxTileCacheCount < 1) {
                maxTileCacheCount = 1;
            }
            Color audioLineBackground = this.viewSettings.getAudioViewBackground();
            tileView = new TileView(tileWidth, tileHeight, maxTileCacheCount, (Paint)audioLineBackground);
            this.setTileView(tileView);
            this.scrollView.setViews(new View[]{tileView});
        }
        tileView.replaceAllViews((View[])this.lineViews);
        tileView.invalidate();
        LineChunk oldChunk = this.prevRecChunk;
        LineChunk recChunk = this.audioLine.getRecChunk();
        if (recChunk != oldChunk) {
            this.prevRecChunk = recChunk;
            this.setRecChunk(recChunk);
            if (recChunk == null) {
                this.panel.unregisterRecordingWrapper(this);
            } else if (oldChunk == null) {
                this.panel.registerRecordingWrapper(this);
            }
        }
    }

    @Override
    public void layout() {
        ScrollView wrapperView;
        boolean horiz;
        int orient = this.orientation;
        boolean bl = horiz = orient == 0 || orient == 1;
        if (this.scrollView != null) {
            Dimension prefSize = this.scrollView.getPreferredSize();
            prefSize.width = this.trackSize;
            prefSize.height = this.trackSize;
            this.scrollView.setPreferredSize(prefSize);
        }
        if ((wrapperView = this.scrollView) != null) {
            int index = this.getGridIndex();
            GridBagConstraints gbc = new GridBagConstraints();
            if (horiz) {
                gbc.gridx = 0;
                gbc.gridy = index;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
            } else {
                gbc.gridx = index;
                gbc.gridy = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 1.0;
            }
            gbc.fill = 1;
            ViewLayout viewLayout = this.viewLayout;
            if (viewLayout != null) {
                viewLayout.removeView((View)wrapperView);
                if (index >= 0) {
                    viewLayout.addView((View)wrapperView, (Object)gbc);
                }
            }
        }
    }

    @Override
    public void setViewSettings(WaxLabViewSettings viewSettings) {
        super.setViewSettings(viewSettings);
        if (viewSettings != null) {
            this.setAudioInitCapacity(viewSettings.getAudioInitCapacity());
            this.setFaderInitCapacity(viewSettings.getFaderInitCapacity());
            if (this.tileView != null) {
                int maxTileCacheCount = viewSettings.getAudioTileCacheCount();
                if (maxTileCacheCount < 1) {
                    maxTileCacheCount = 1;
                }
                this.tileView.setMaxTileCacheCount(maxTileCacheCount);
                this.tileView.setBackground((Paint)viewSettings.getAudioViewBackground());
            }
        }
    }

    public File showOpenFileDialog() throws Exception {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setDialogTitle("Open Audio File");
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        WaxLabFileFilters.AudioFileFilter fileFilter = new WaxLabFileFilters.AudioFileFilter();
        chooser.setFileFilter(fileFilter);
        int rc = chooser.showOpenDialog(this.panel);
        if (rc != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        return file;
    }

    public LineChunk[] openLineChunks(File file) throws Exception {
        boolean readOnly;
        String[] trackIds;
        CachedAudioModel model;
        if (file == null) {
            return null;
        }
        AbstractWaxLabPanel waxPanel = this.panel.getWaxLabPanel();
        if (waxPanel == null) {
            return null;
        }
        WaxLab waxLab = waxPanel.getWaxLab();
        if (waxLab == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating audio model for file: " + file);
        }
        if ((model = waxLab.createCachedAudioModel(file, trackIds = null, readOnly = true)) == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Frame length: " + model.getFrameLength());
            logger.fine("Frame rate: " + model.getFrameRate());
            logger.fine("Channels: " + model.getChannels());
        }
        long modelOfs = 0L;
        long modelEnd = model.getNanoLength();
        long chunkOfs = 0L;
        long chunkEnd = modelEnd;
        MutableLineChunk chunk = model.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
        return new LineChunk[]{chunk};
    }
}

