/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.model.view.ChunkRenderer;
import com.waxmonster.model.view.MidiChunkRenderer;
import com.waxmonster.model.view.PeakAudioChunkRenderer;
import com.waxmonster.model.view.PolyAudioChunkRenderer;
import com.waxmonster.model.view.PolyTimecodeChunkRenderer;
import com.waxmonster.model.view.SimpleMidiChunkRenderer;
import com.waxmonster.model.view.SpectroAudioChunkRenderer;
import com.waxmonster.model.view.StrokeUtil;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public class ChunkRendererUtil {
    private static ChunkRendererUtil INSTANCE;

    protected ChunkRendererUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChunkRendererUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ChunkRendererUtil> clazz = ChunkRendererUtil.class;
        synchronized (ChunkRendererUtil.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ChunkRendererUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public ChunkRenderer createAudioChunkRenderer(String audioRenderMode, int audioInitCapacity, WaxLabViewSettings viewSettings) {
        if (audioRenderMode == null) {
            audioRenderMode = "Peaks";
        }
        if ("Mono".equals(audioRenderMode)) {
            PolyAudioChunkRenderer renderer = new PolyAudioChunkRenderer(audioInitCapacity);
            renderer.setMono(true);
            renderer.setColor(viewSettings.getAudioMonoLineColor());
            int thickness = viewSettings.getAudioLineThickness();
            Stroke stroke = StrokeUtil.getInstance().getStrokeForWidth(thickness);
            renderer.setStroke(stroke);
            return renderer;
        }
        if ("Stereo".equals(audioRenderMode)) {
            PolyAudioChunkRenderer renderer = new PolyAudioChunkRenderer(audioInitCapacity);
            renderer.setMono(false);
            renderer.setColor(viewSettings.getAudioMonoLineColor());
            renderer.setColors(new Color[]{viewSettings.getAudioStereoLeftLineColor(), viewSettings.getAudioStereoRightLineColor()});
            int thickness = viewSettings.getAudioLineThickness();
            Stroke stroke = StrokeUtil.getInstance().getStrokeForWidth(thickness);
            renderer.setStroke(stroke);
            return renderer;
        }
        if ("Peaks".equals(audioRenderMode)) {
            PeakAudioChunkRenderer renderer = new PeakAudioChunkRenderer();
            renderer.setColor(viewSettings.getAudioPeakFillColor());
            return renderer;
        }
        if ("Colorized".equals(audioRenderMode)) {
            SpectroAudioChunkRenderer renderer = new SpectroAudioChunkRenderer();
            renderer.setBackgroundPaint((Paint)viewSettings.getAudioViewBackground());
            renderer.setChannel(0);
            return renderer;
        }
        throw new IllegalArgumentException("Unsupported audioRenderMode: " + audioRenderMode);
    }

    public MidiChunkRenderer createMidiChunkRenderer(String midiRenderMode, WaxLabViewSettings viewSettings) {
        SimpleMidiChunkRenderer renderer = new SimpleMidiChunkRenderer();
        return renderer;
    }

    public ChunkRenderer createTimecodeChunkRenderer(String timecodeRenderMode, int timecodeInitCapacity, boolean timecodeInverted, WaxLabViewSettings viewSettings) {
        PolyTimecodeChunkRenderer renderer = new PolyTimecodeChunkRenderer(timecodeInitCapacity);
        renderer.setInverted(timecodeInverted);
        renderer.setColor(viewSettings.getTimecodeLineColor());
        int thickness = viewSettings.getTimecodeLineThickness();
        Stroke stroke = StrokeUtil.getInstance().getStrokeForWidth(thickness);
        renderer.setStroke(stroke);
        return renderer;
    }
}

