/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioScratchPlayer;
import com.waxmonster.view.AbstractView;
import com.waxmonster.waxlab.view.ScratchPositionView;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.LinkedList;

public class ClockScratchPositionView
extends AbstractView
implements ScratchPositionView {
    protected static final double MATH_2_PI = Math.PI * 2;
    protected static final double MATH_2_PI_POS = Math.PI * 2;
    protected static final double MATH_2_PI_NEG = Math.PI * -2;
    protected static final double ROTATION = Math.PI * 2;
    protected static final double NORTH = Math.PI;
    protected static final double SOUTH = 0.0;
    protected static final double EAST = 1.5707963267948966;
    protected static final double WEST = 4.71238898038469;
    protected static final Color DEFAULT_CLOCK_BACK_COLOR = new Color(240, 240, 240);
    protected static final Color DEFAULT_NORTH_COLOR = new Color(96, 192, 64);
    protected static final Color DEFAULT_SOUTH_COLOR = new Color(192, 64, 64);
    protected static final Color DEFAULT_EAST_COLOR = new Color(133, 166, 192);
    protected static final Color DEFAULT_WEST_COLOR = new Color(177, 177, 32);
    protected static final int DEFAULT_OUTER_THICKNESS = 12;
    private AudioScratchPlayer scratchPlayer;
    private double frameRate;
    private boolean clockwise;
    private double rotationMillis;
    private double factor;
    private boolean autoHide;
    private AbstractRenderer[] renderers;
    protected double modelAnchor;
    protected double modelBPM;
    protected double modelDuration;
    protected double modelPosition;
    protected double modelOrigin;
    protected double playerOffset;
    protected double playerOrigin;
    protected double playerPosition;
    protected double playerVelocity;
    protected double relativePitch;
    private double effectivePitch;
    private boolean pitchComputed;
    private double pitchTolerance = 0.15;
    private int pitchSize = 10;
    private double[] pitchQueue;
    private int pitchHead;
    private int pitchWait;
    protected int width;
    protected int height;
    protected double mxd;
    protected double myd;
    protected int mxi;
    protected int myi;
    protected int cw;
    protected int ch;
    private WaxLabViewSettings viewSettings;
    private Paint outerBackground = Color.LIGHT_GRAY;
    protected int outerThickness = 12;
    protected int outerThickness2 = this.outerThickness * 2;
    private Paint clockBackground = DEFAULT_CLOCK_BACK_COLOR;
    private Paint clockArrowPaint = Color.BLACK;
    private Paint centerBackground = Color.GRAY;
    private Paint centerOutlinePaint = Color.DARK_GRAY;
    private Paint textPaint = Color.GRAY;
    private Font largeFont = new Font("Monospaced", 1, 24);
    private Font mediumFont = new Font("Monospaced", 1, 16);
    private Font smallFont = new Font("Monospaced", 1, 14);
    private Paint crosshairPaint = Color.BLACK;
    private Paint positionArcPaint = Color.GRAY;
    protected Color northColor = DEFAULT_NORTH_COLOR;
    protected Color eastColor = DEFAULT_EAST_COLOR;
    protected Color southColor = DEFAULT_SOUTH_COLOR;
    protected Color westColor = DEFAULT_WEST_COLOR;
    private double thicknessNorth = 0.3;
    private double thicknessEast = 0.3;
    private double thicknessSouth = 0.3;
    private double thicknessWest = 0.3;
    private int maxRadarBeats = 4;
    private Paint[][] distanceColors;
    private double radarThickness = 0.3;
    private boolean rotationCountRendererEnabled = true;
    private boolean beatCountRendererEnabled = true;
    private boolean beatRadarRendererEnabled = true;
    private boolean beatCompassLineRendererEnabled = true;
    private boolean beatCompassPolyRendererEnabled = false;

    public ClockScratchPositionView() {
        this.setRotationMillis(1800.0);
        this.setClockwise(true);
        this.setPitchSize(this.pitchSize);
        int colorCount = 20;
        Color[] distanceColorsNorth = this.createFadeInColorArray(this.northColor, colorCount);
        Color[] distanceColorsEast = this.createFadeInColorArray(this.eastColor, colorCount);
        Color[] distanceColorsSouth = this.createFadeInColorArray(this.southColor, colorCount);
        Color[] distanceColorsWest = this.createFadeInColorArray(this.westColor, colorCount);
        this.distanceColors = new Paint[][]{distanceColorsNorth, distanceColorsEast, distanceColorsSouth, distanceColorsWest};
        this.refresh();
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.width = bounds.width;
        this.height = bounds.height;
        this.mxd = (double)this.width / 2.0;
        this.myd = (double)this.height / 2.0;
        this.mxi = (int)Math.round(this.mxd);
        this.myi = (int)Math.round(this.myd);
        this.cw = (int)Math.round((double)this.width / 30.0) / 2 * 2;
        this.ch = (int)Math.round((double)this.height / 30.0) / 2 * 2;
    }

    public void paint(Graphics2D g) {
        AudioScratchPlayer player = this.scratchPlayer;
        if (player != null) {
            AudioScratchModel model = player.getAudioScratchModel();
            if (model != null) {
                this.modelAnchor = model.getAnchor();
                this.modelBPM = model.getBPM();
                this.modelDuration = model.getDuration();
                this.modelOrigin = model.getOrigin();
            } else {
                this.modelAnchor = 0.0;
                this.modelBPM = 0.0;
                this.modelDuration = -1.0;
                this.modelOrigin = 0.0;
            }
            this.playerOffset = player.getOffset();
            this.playerOrigin = player.getOrigin();
            this.playerPosition = player.getPosition();
            this.playerVelocity = player.getVelocity();
            this.relativePitch = player.getPitch();
        } else {
            if (this.autoHide) {
                return;
            }
            this.modelAnchor = 0.0;
            this.modelBPM = 0.0;
            this.modelDuration = -1.0;
            this.modelOrigin = 0.0;
            this.playerOffset = 0.0;
            this.playerOrigin = 0.0;
            this.playerPosition = 0.0;
            this.playerVelocity = 0.0;
            this.relativePitch = 0.0;
        }
        this.modelPosition = this.playerOffset - this.modelAnchor;
        this.pitchComputed = false;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AbstractRenderer[] arr = this.renderers;
        int num = arr.length;
        int i = 0;
        while (i < num) {
            arr[i++].paint(g);
        }
    }

    protected void paintClockPositionLine(Graphics2D g, double alpha, double mx, double my, int cw, int ch) {
        double sin = Math.sin(alpha);
        double cos = Math.cos(alpha);
        double rx = mx + sin * mx;
        double ry = my + cos * my;
        g.drawLine((int)Math.round(mx), (int)Math.round(my), (int)Math.round(rx), (int)Math.round(ry));
    }

    protected void paintClockPositionPoly(Graphics2D g, double alpha, double mx, double my, int cw, int ch, double thick) {
        double sin = Math.sin(alpha);
        double cos = Math.cos(alpha);
        double rx = mx + sin * mx;
        double ry = my + cos * my;
        double dx = cos * (double)cw * thick;
        double dy = sin * (double)ch * thick;
        int[] xp = new int[]{(int)Math.round(mx - dx), (int)Math.round(mx + dx), (int)Math.round(rx + dx), (int)Math.round(rx - dx)};
        int[] yp = new int[]{(int)Math.round(my + dy), (int)Math.round(my - dy), (int)Math.round(ry - dy), (int)Math.round(ry + dy)};
        g.fillPolygon(xp, yp, 4);
    }

    protected String formatTrackPosition(double tpm) {
        String posStr;
        long digits;
        if (tpm < 0.0) {
            digits = (long)(-tpm / 100.0);
            posStr = "-";
        } else {
            digits = (long)(tpm / 100.0);
            posStr = "";
        }
        long secs = digits / 10L;
        if (secs < 60L) {
            posStr = posStr + "0:" + Integer.toString(100 + (int)secs).substring(1) + "." + Integer.toString((int)(digits % 10L));
        } else {
            long mins = secs / 60L;
            posStr = posStr + Long.toString(mins) + ":" + Integer.toString(100 + (int)(secs % 60L)).substring(1) + "." + Integer.toString((int)(digits % 10L));
        }
        return posStr;
    }

    protected String formatPitch(double pit) {
        if ((pit = (double)Math.round(pit) / 10.0) > 0.0) {
            return "+" + Double.toString(pit) + '%';
        }
        if (pit < 0.0) {
            return Double.toString(pit) + '%';
        }
        return "0.0%";
    }

    protected String formatRotations(double rots) {
        return Integer.toString((int)rots) + ":" + Integer.toString((int)(rots * 4.0 % 4.0));
    }

    protected String formatBeats(double beats) {
        int count = (int)beats;
        return Integer.toString(count / 4) + ":" + Integer.toString(count % 4);
    }

    public double getEffectivePitch() {
        if (!this.pitchComputed) {
            double v;
            this.pitchQueue[this.pitchHead] = v = this.frameRate * this.playerVelocity * this.relativePitch;
            this.pitchHead = (this.pitchHead + 1) % this.pitchSize;
            if (this.pitchWait > 0) {
                --this.pitchWait;
            } else {
                double min = this.pitchQueue[0];
                double max = this.pitchQueue[0];
                for (int i = 1; i < this.pitchSize; ++i) {
                    v = this.pitchQueue[i];
                    if (v < min) {
                        min = v;
                    }
                    if (!(v > max)) continue;
                    max = v;
                }
                double dif = Math.abs(max - min);
                double avg = (max + min) / 2.0;
                double abs = Math.abs(avg);
                if (abs > 1.0) {
                    dif /= abs;
                }
                if (dif < this.pitchTolerance) {
                    this.effectivePitch = avg;
                    this.pitchWait = this.pitchSize;
                }
            }
            this.pitchComputed = true;
        }
        return this.effectivePitch;
    }

    public void flush() {
    }

    public double getRotationMillis() {
        return this.rotationMillis;
    }

    public void setRotationMillis(double rotationMillis) {
        this.rotationMillis = rotationMillis;
        this.refreshFactor();
    }

    public boolean isClockwise() {
        return this.clockwise;
    }

    public void setClockwise(boolean clockwise) {
        this.clockwise = clockwise;
        this.refreshFactor();
    }

    protected void refreshFactor() {
        double value = Math.PI * 2 / this.rotationMillis;
        if (this.clockwise) {
            value = -value;
        }
        this.factor = value;
    }

    public Paint getCenterBackground() {
        return this.centerBackground;
    }

    public void setCenterBackground(Paint centerBackground) {
        this.centerBackground = centerBackground;
    }

    @Override
    public AudioScratchPlayer getScratchPlayer() {
        return this.scratchPlayer;
    }

    @Override
    public void setScratchPlayer(AudioScratchPlayer scratchPlayer) {
        this.scratchPlayer = scratchPlayer;
        if (scratchPlayer != null) {
            this.frameRate = scratchPlayer.getFrameRate();
        }
    }

    public int getOuterThickness() {
        return this.outerThickness;
    }

    public void setOuterThickness(int v) {
        this.outerThickness = v;
        this.outerThickness2 = v * 2;
    }

    public Paint getOuterBackground() {
        return this.outerBackground;
    }

    public void setOuterBackground(Paint outerBackground) {
        this.outerBackground = outerBackground;
    }

    public Paint getClockBackground() {
        return this.clockBackground;
    }

    public void setClockBackground(Paint clockBackground) {
        this.clockBackground = clockBackground;
    }

    public Paint getClockArrowPaint() {
        return this.clockArrowPaint;
    }

    public void setClockArrowPaint(Paint clockArrowPaint) {
        this.clockArrowPaint = clockArrowPaint;
    }

    public Paint getCenterOutlinePaint() {
        return this.centerOutlinePaint;
    }

    public void setCenterOutlinePaint(Paint centerOutlinePaint) {
        this.centerOutlinePaint = centerOutlinePaint;
    }

    public Paint getCrosshairPaint() {
        return this.crosshairPaint;
    }

    public void setCrosshairPaint(Paint crosshairPaint) {
        this.crosshairPaint = crosshairPaint;
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint textPaint) {
        this.textPaint = textPaint;
    }

    public Paint getPositionArcPaint() {
        return this.positionArcPaint;
    }

    public void setPositionArcPaint(Paint positionArcPaint) {
        this.positionArcPaint = positionArcPaint;
    }

    public Font getLargeFont() {
        return this.largeFont;
    }

    public void setLargeFont(Font largeFont) {
        this.largeFont = largeFont;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public void setSmallFont(Font smallFont) {
        this.smallFont = smallFont;
    }

    public Font getMediumFont() {
        return this.mediumFont;
    }

    public void setMediumFont(Font mediumFont) {
        this.mediumFont = mediumFont;
    }

    protected Color[] createFadeInColorArray(Color color, int count) {
        float[] cc = this.getColorCompsRGBA(color);
        float r = cc[0];
        float g = cc[1];
        float b = cc[2];
        float a = 0.0f;
        Color colorNone = new Color(r, g, b, a);
        return this.createColorArray(colorNone, color, count);
    }

    protected Color[] createColorArray(Color color1, Color color2, int count) {
        float[] ca = this.getColorCompsRGBA(color1);
        float[] cb = this.getColorCompsRGBA(color2);
        Color[] arr = new Color[count];
        for (int i = 0; i < count; ++i) {
            float x = (float)i / (float)count;
            x = (float)Math.sqrt(x);
            float z = 1.0f - x;
            float r = ca[0] * x + cb[0] * z;
            float g = ca[1] * x + cb[1] * z;
            float b = ca[2] * x + cb[2] * z;
            float a = ca[3] * x + cb[3] * z;
            arr[i] = new Color(r, g, b, a);
        }
        return arr;
    }

    protected float[] getColorCompsRGBA(Color col) {
        float[] arr = new float[]{(float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f, (float)col.getAlpha() / 255.0f};
        return arr;
    }

    public void refresh() {
        this.renderers = this.createRenderers();
    }

    protected AbstractRenderer[] createRenderers() {
        LinkedList<AbstractRenderer> rendererList = new LinkedList<AbstractRenderer>();
        rendererList.add(new BackgroundRenderer());
        rendererList.add(new TrackAmountRenderer());
        rendererList.add(new OuterCrosshairRenderer());
        rendererList.add(new ClockBackgroundRenderer());
        if (this.beatRadarRendererEnabled) {
            rendererList.add(new BeatRadarRenderer());
        }
        if (this.beatCompassLineRendererEnabled) {
            rendererList.add(new BeatCompassLineRenderer());
        }
        if (this.beatCompassPolyRendererEnabled) {
            rendererList.add(new BeatCompassPolyRenderer());
        }
        rendererList.add(new TrackPitchRenderer());
        rendererList.add(new TrackTempoRenderer());
        if (this.rotationCountRendererEnabled) {
            rendererList.add(new RotationCountRenderer());
        }
        if (this.beatCountRendererEnabled) {
            rendererList.add(new BeatCountRenderer());
        }
        rendererList.add(new TrackPositionRenderer());
        rendererList.add(new ClockArrowRenderer());
        rendererList.add(new ClockCenterRenderer());
        return rendererList.toArray(new AbstractRenderer[rendererList.size()]);
    }

    public boolean isRotationCountRendererEnabled() {
        return this.rotationCountRendererEnabled;
    }

    public void setRotationCountRendererEnabled(boolean rotationCountRendererEnabled) {
        this.rotationCountRendererEnabled = rotationCountRendererEnabled;
    }

    public boolean isBeatCountRendererEnabled() {
        return this.beatCountRendererEnabled;
    }

    public void setBeatCountRendererEnabled(boolean beatCountRendererEnabled) {
        this.beatCountRendererEnabled = beatCountRendererEnabled;
    }

    public boolean isBeatRadarRendererEnabled() {
        return this.beatRadarRendererEnabled;
    }

    public void setBeatRadarRendererEnabled(boolean beatRadarRendererEnabled) {
        this.beatRadarRendererEnabled = beatRadarRendererEnabled;
    }

    public boolean isBeatCompassLineRendererEnabled() {
        return this.beatCompassLineRendererEnabled;
    }

    public void setBeatCompassLineRendererEnabled(boolean beatCompassLineRendererEnabled) {
        this.beatCompassLineRendererEnabled = beatCompassLineRendererEnabled;
    }

    public boolean isBeatCompassPolyRendererEnabled() {
        return this.beatCompassPolyRendererEnabled;
    }

    public void setBeatCompassPolyRendererEnabled(boolean beatCompassPolyRendererEnabled) {
        this.beatCompassPolyRendererEnabled = beatCompassPolyRendererEnabled;
    }

    public double getPitchTolerance() {
        return this.pitchTolerance;
    }

    public void setPitchTolerance(double pitchTolerance) {
        this.pitchTolerance = pitchTolerance;
    }

    public int getPitchSize() {
        return this.pitchSize;
    }

    public void setPitchSize(int pitchSize) {
        if (pitchSize < 1) {
            pitchSize = 1;
        }
        if (this.pitchQueue == null || this.pitchQueue.length < pitchSize) {
            this.pitchQueue = new double[pitchSize];
        }
        this.pitchHead = 0;
        this.pitchSize = pitchSize;
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        this.setOuterBackground(viewSettings.getClockOuterBackground());
        this.setOuterThickness(viewSettings.getClockOuterThickness());
        this.setClockBackground(viewSettings.getClockBackground());
        this.setClockArrowPaint(viewSettings.getClockArrowPaint());
        this.setCenterBackground(viewSettings.getClockCenterBackground());
        this.setCenterOutlinePaint(viewSettings.getClockCenterOutlinePaint());
        this.setPositionArcPaint(viewSettings.getClockPositionArcPaint());
        this.setCrosshairPaint(viewSettings.getClockCrosshairPaint());
        this.setTextPaint(viewSettings.getClockTextPaint());
        this.refresh();
    }

    public boolean isAutoHide() {
        return this.autoHide;
    }

    public void setAutoHide(boolean autoHide) {
        this.autoHide = autoHide;
    }

    protected class FIXmeBeatRenderer
    extends AbstractRenderer {
        protected FIXmeBeatRenderer() {
        }

        @Override
        public void paint(Graphics2D g) {
            double bpm = ClockScratchPositionView.this.modelBPM;
            if (!(bpm > 0.0)) {
                return;
            }
        }
    }

    public class BeatRadarRenderer
    extends AbstractRenderer {
        @Override
        public void paint(Graphics2D g) {
            double bpm = ClockScratchPositionView.this.modelBPM;
            if (!(bpm > 0.0)) {
                return;
            }
            double r = (ClockScratchPositionView.this.playerPosition - ClockScratchPositionView.this.playerOrigin) / ClockScratchPositionView.this.rotationMillis;
            double rof = r - (double)((long)r);
            double rmp = ClockScratchPositionView.this.modelPosition - ClockScratchPositionView.this.modelOrigin;
            double mpb = 60000.0 / bpm;
            double beats = rmp / mpb;
            long beat = (long)beats;
            double bfr = beats - (double)beat;
            double rpm = 60000.0 / ClockScratchPositionView.this.rotationMillis;
            double rpbr = rpm / bpm / ClockScratchPositionView.this.relativePitch;
            double rob = rof - bfr * rpbr;
            double alpha = 0.0 - rob * (Math.PI * 2);
            double rpba = rpbr * (Math.PI * 2);
            double bedi = bfr;
            if (rpbr >= 0.0) {
                rpba = -rpba;
            }
            for (int i = 0; i < ClockScratchPositionView.this.maxRadarBeats; ++i) {
                double intens;
                if (i > 0) {
                    ++beat;
                    alpha += rpba;
                    intens = ((double)i - bedi) / (double)ClockScratchPositionView.this.maxRadarBeats;
                } else {
                    intens = bedi;
                }
                int barBeatIndex = (int)Math.abs(beat) % 4;
                Paint[] dpc = ClockScratchPositionView.this.distanceColors[barBeatIndex];
                int dpn = dpc.length;
                int col = (int)((double)dpn * intens);
                if (col < 0) {
                    col = -col;
                }
                if (col >= dpn) {
                    col = dpn - 1;
                }
                g.setPaint(dpc[col]);
                ClockScratchPositionView.this.paintClockPositionPoly(g, Math.PI + alpha, ClockScratchPositionView.this.mxd, ClockScratchPositionView.this.myd, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch, ClockScratchPositionView.this.radarThickness);
            }
        }
    }

    public class BeatCompassPolyRenderer
    extends AbstractRenderer {
        @Override
        public void paint(Graphics2D g) {
            double bpm = ClockScratchPositionView.this.modelBPM;
            if (!(bpm > 0.0)) {
                return;
            }
            double r = (ClockScratchPositionView.this.playerPosition - ClockScratchPositionView.this.playerOrigin) / ClockScratchPositionView.this.rotationMillis;
            double rof = r - (double)((long)r);
            double mpb = 60000.0 / bpm;
            double beats = (ClockScratchPositionView.this.modelPosition - ClockScratchPositionView.this.modelOrigin) / mpb;
            double bars = beats / 4.0;
            long bar = (long)bars;
            double cbo = bars - (double)bar - rof;
            double alpha = cbo * (Math.PI * 2);
            g.setPaint(ClockScratchPositionView.this.northColor);
            ClockScratchPositionView.this.paintClockPositionPoly(g, Math.PI + alpha, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch, ClockScratchPositionView.this.thicknessNorth);
            g.setPaint(ClockScratchPositionView.this.eastColor);
            ClockScratchPositionView.this.paintClockPositionPoly(g, 1.5707963267948966 + alpha, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch, ClockScratchPositionView.this.thicknessEast);
            g.setPaint(ClockScratchPositionView.this.southColor);
            ClockScratchPositionView.this.paintClockPositionPoly(g, 0.0 + alpha, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch, ClockScratchPositionView.this.thicknessSouth);
            g.setPaint(ClockScratchPositionView.this.westColor);
            ClockScratchPositionView.this.paintClockPositionPoly(g, 4.71238898038469 + alpha, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch, ClockScratchPositionView.this.thicknessWest);
        }
    }

    public class BeatCompassLineRenderer
    extends AbstractRenderer {
        @Override
        public void paint(Graphics2D g) {
            double bpm = ClockScratchPositionView.this.modelBPM;
            if (!(bpm > 0.0)) {
                return;
            }
            double r = (ClockScratchPositionView.this.playerPosition - ClockScratchPositionView.this.playerOrigin) / ClockScratchPositionView.this.rotationMillis;
            double rof = r - (double)((long)r);
            double mpb = 60000.0 / bpm;
            double beats = (ClockScratchPositionView.this.modelPosition - ClockScratchPositionView.this.modelOrigin) / mpb;
            double bars = beats / 4.0;
            long bar = (long)bars;
            double cbo = bars - (double)bar - rof;
            double alpha = cbo * (Math.PI * 2);
            g.setPaint(ClockScratchPositionView.this.northColor);
            ClockScratchPositionView.this.paintClockPositionLine(g, Math.PI + alpha, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch);
            g.setPaint(ClockScratchPositionView.this.eastColor);
            ClockScratchPositionView.this.paintClockPositionLine(g, 1.5707963267948966 + alpha, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch);
            g.setPaint(ClockScratchPositionView.this.southColor);
            ClockScratchPositionView.this.paintClockPositionLine(g, 0.0 + alpha, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch);
            g.setPaint(ClockScratchPositionView.this.westColor);
            ClockScratchPositionView.this.paintClockPositionLine(g, 4.71238898038469 + alpha, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch);
        }
    }

    public class ClockCenterRenderer
    extends AbstractRenderer {
        @Override
        public void paint(Graphics2D g) {
            int x = Math.round(ClockScratchPositionView.this.mxi - ClockScratchPositionView.this.cw);
            int y = Math.round(ClockScratchPositionView.this.myi - ClockScratchPositionView.this.ch);
            int w = Math.round(ClockScratchPositionView.this.cw * 2);
            int h = Math.round(ClockScratchPositionView.this.ch * 2);
            g.setPaint(ClockScratchPositionView.this.centerBackground);
            g.fillArc(x, y, w, h, 0, 360);
            g.setPaint(ClockScratchPositionView.this.centerOutlinePaint);
            g.drawArc(x, y, w, h, 0, 360);
        }
    }

    public class ClockArrowRenderer
    extends AbstractRenderer {
        private Paint paint;

        public ClockArrowRenderer() {
            this.paint = ClockScratchPositionView.this.clockArrowPaint;
        }

        @Override
        public void paint(Graphics2D g) {
            double alpha = Math.PI + (ClockScratchPositionView.this.playerPosition - ClockScratchPositionView.this.playerOrigin) * ClockScratchPositionView.this.factor;
            double thick = 0.6;
            g.setPaint(this.paint);
            ClockScratchPositionView.this.paintClockPositionPoly(g, alpha, ClockScratchPositionView.this.mxd, ClockScratchPositionView.this.myd, ClockScratchPositionView.this.cw, ClockScratchPositionView.this.ch, thick);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public class TrackTempoRenderer
    extends AbstractRenderer {
        private Paint paint;

        public TrackTempoRenderer() {
            this.paint = ClockScratchPositionView.this.textPaint;
        }

        @Override
        public void paint(Graphics2D g) {
            double bpm = ClockScratchPositionView.this.modelBPM;
            if (!(bpm > 0.0)) {
                return;
            }
            double pit = ClockScratchPositionView.this.getEffectivePitch();
            long rnd = Math.round(bpm * pit / 100.0);
            String bpmStr = Integer.toString((int)(rnd / 10L)) + "." + Integer.toString(10 + (int)Math.abs(rnd % 10L)).substring(1);
            g.setFont(ClockScratchPositionView.this.largeFont);
            FontMetrics fm = g.getFontMetrics();
            int y = ClockScratchPositionView.this.height * 6 / 20 + fm.getAscent() / 2;
            g.setPaint(this.paint);
            g.drawString(bpmStr, (int)Math.round(ClockScratchPositionView.this.mxd - (double)fm.stringWidth(bpmStr) / 2.0), y);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public class TrackPitchRenderer
    extends AbstractRenderer {
        private Paint paint;

        public TrackPitchRenderer() {
            this.paint = ClockScratchPositionView.this.textPaint;
        }

        @Override
        public void paint(Graphics2D g) {
            double pit = ClockScratchPositionView.this.getEffectivePitch();
            String pitStr = ClockScratchPositionView.this.formatPitch(pit);
            g.setFont(ClockScratchPositionView.this.smallFont);
            FontMetrics fm = g.getFontMetrics();
            int y = ClockScratchPositionView.this.height * 4 / 20 + fm.getAscent() / 2;
            g.setPaint(this.paint);
            g.drawString(pitStr, (int)Math.round(ClockScratchPositionView.this.mxd - (double)fm.stringWidth(pitStr) / 2.0), y);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public class BeatCountRenderer
    extends AbstractRenderer {
        private Paint paint;

        public BeatCountRenderer() {
            this.paint = ClockScratchPositionView.this.textPaint;
        }

        @Override
        public void paint(Graphics2D g) {
            double bpm = ClockScratchPositionView.this.modelBPM;
            if (!(bpm > 0.0)) {
                return;
            }
            double beats = (ClockScratchPositionView.this.modelPosition - ClockScratchPositionView.this.modelOrigin) * bpm / 60000.0;
            String beatStr = ClockScratchPositionView.this.formatBeats(beats);
            g.setFont(ClockScratchPositionView.this.mediumFont);
            FontMetrics fm = g.getFontMetrics();
            int y = (int)((double)ClockScratchPositionView.this.height / 2.0 - (double)fm.getHeight() / 2.0 + (double)fm.getAscent());
            g.setPaint(this.paint);
            g.drawString(beatStr, (int)Math.round(ClockScratchPositionView.this.mxd * 1.5 - (double)fm.stringWidth(beatStr) / 2.0), y);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public class RotationCountRenderer
    extends AbstractRenderer {
        private Paint paint;

        public RotationCountRenderer() {
            this.paint = ClockScratchPositionView.this.textPaint;
        }

        @Override
        public void paint(Graphics2D g) {
            double rots = (ClockScratchPositionView.this.playerPosition - ClockScratchPositionView.this.playerOrigin) / ClockScratchPositionView.this.rotationMillis;
            String rotStr = ClockScratchPositionView.this.formatRotations(rots);
            g.setFont(ClockScratchPositionView.this.mediumFont);
            FontMetrics fm = g.getFontMetrics();
            int y = (int)((double)ClockScratchPositionView.this.height / 2.0 - (double)fm.getHeight() / 2.0 + (double)fm.getAscent());
            g.setPaint(this.paint);
            g.drawString(rotStr, (int)Math.round(ClockScratchPositionView.this.mxd * 0.5 - (double)fm.stringWidth(rotStr) / 2.0), y);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public class TrackPositionRenderer
    extends AbstractRenderer {
        private Paint paint;

        public TrackPositionRenderer() {
            this.paint = ClockScratchPositionView.this.textPaint;
        }

        @Override
        public void paint(Graphics2D g) {
            String posStr = ClockScratchPositionView.this.formatTrackPosition(ClockScratchPositionView.this.modelPosition);
            g.setPaint(this.paint);
            g.setFont(ClockScratchPositionView.this.largeFont);
            FontMetrics fm = g.getFontMetrics();
            int y = ClockScratchPositionView.this.height * 13 / 20 + fm.getAscent() / 2;
            g.drawString(posStr, (int)Math.round(ClockScratchPositionView.this.mxd - (double)fm.stringWidth(posStr) / 2.0), y);
            if (ClockScratchPositionView.this.modelPosition >= 0.0 && ClockScratchPositionView.this.modelPosition <= ClockScratchPositionView.this.modelDuration) {
                double rem = ClockScratchPositionView.this.modelPosition - ClockScratchPositionView.this.modelDuration;
                posStr = ClockScratchPositionView.this.formatTrackPosition(rem);
                g.setFont(ClockScratchPositionView.this.smallFont);
                fm = g.getFontMetrics();
                y = ClockScratchPositionView.this.height * 18 / 23 + fm.getAscent() / 2;
                g.drawString(posStr, (int)Math.round(ClockScratchPositionView.this.mxd - (double)fm.stringWidth(posStr) / 2.0), y);
            }
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public class OuterCrosshairRenderer
    extends AbstractRenderer {
        private Paint paint;

        public OuterCrosshairRenderer() {
            this.paint = ClockScratchPositionView.this.crosshairPaint;
        }

        @Override
        public void paint(Graphics2D g) {
            g.setPaint(this.paint);
            g.drawLine(ClockScratchPositionView.this.mxi, 0, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.outerThickness2);
            g.drawLine(ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.height, ClockScratchPositionView.this.mxi, ClockScratchPositionView.this.height - ClockScratchPositionView.this.outerThickness2);
            g.drawLine(0, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.outerThickness2, ClockScratchPositionView.this.myi);
            g.drawLine(ClockScratchPositionView.this.width, ClockScratchPositionView.this.myi, ClockScratchPositionView.this.width - ClockScratchPositionView.this.outerThickness2, ClockScratchPositionView.this.myi);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public class ClockBackgroundRenderer
    extends AbstractRenderer {
        private Paint paint;

        public ClockBackgroundRenderer() {
            this.paint = ClockScratchPositionView.this.clockBackground;
        }

        @Override
        public void paint(Graphics2D g) {
            g.setPaint(this.paint);
            g.fillArc(ClockScratchPositionView.this.outerThickness, ClockScratchPositionView.this.outerThickness, ClockScratchPositionView.this.width - ClockScratchPositionView.this.outerThickness2, ClockScratchPositionView.this.height - ClockScratchPositionView.this.outerThickness2, 0, 360);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public class TrackAmountRenderer
    extends AbstractRenderer {
        private Paint paint;

        public TrackAmountRenderer() {
            this.paint = ClockScratchPositionView.this.positionArcPaint;
        }

        @Override
        public void paint(Graphics2D g) {
            double dur = ClockScratchPositionView.this.modelDuration;
            double tpm = ClockScratchPositionView.this.modelPosition;
            if (dur > 0.0 && tpm >= 0.0) {
                int angle = tpm > dur ? -360 : (int)(-360.0 * tpm / dur);
                g.setPaint(this.paint);
                g.fillArc(0, 0, ClockScratchPositionView.this.width, ClockScratchPositionView.this.height, 90, angle);
            }
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public class BackgroundRenderer
    extends AbstractRenderer {
        private Paint paint;

        public BackgroundRenderer() {
            this.paint = ClockScratchPositionView.this.outerBackground;
        }

        @Override
        public void paint(Graphics2D g) {
            g.setPaint(this.paint);
            g.fillArc(0, 0, ClockScratchPositionView.this.width, ClockScratchPositionView.this.height, 0, 360);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }
    }

    public abstract class AbstractRenderer
    implements ScratchPositionRenderer {
    }

    public static interface ScratchPositionRenderer {
        public void paint(Graphics2D var1);
    }
}

