/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.waxlab.LineConfig;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CommonLineConfigPanel
extends JPanel {
    private static final long serialVersionUID = -6418332629501406389L;
    private LineConfig lineConfig;
    private boolean refreshing;
    private JTextField textFieldName;

    public CommonLineConfigPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblNewLabel = new JLabel("Name:");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.insets = new Insets(4, 4, 5, 5);
        gbc_lblNewLabel.anchor = 13;
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        this.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.textFieldName = new JTextField();
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldName.weightx = 1.0;
        gbc_textFieldName.fill = 2;
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 0;
        this.add((Component)this.textFieldName, gbc_textFieldName);
        this.textFieldName.setColumns(10);
        this.initCommonLineConfigPanel();
    }

    protected void initCommonLineConfigPanel() {
        this.getTextFieldName().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!CommonLineConfigPanel.this.refreshing) {
                    CommonLineConfigPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!CommonLineConfigPanel.this.refreshing) {
                    CommonLineConfigPanel.this.apply();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!CommonLineConfigPanel.this.refreshing) {
                    CommonLineConfigPanel.this.apply();
                }
            }
        });
        this.refresh();
    }

    public LineConfig getLineConfig() {
        return this.lineConfig;
    }

    public void setLineConfig(LineConfig lineConfig) {
        this.lineConfig = lineConfig;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            String name = null;
            if (this.lineConfig != null) {
                name = this.lineConfig.getName();
            }
            if (name == null) {
                name = "";
            }
            this.textFieldName.setText(name);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        LineConfig config = this.getLineConfig();
        if (config == null) {
            return;
        }
        config.setName(this.textFieldName.getText());
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }
}

