/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.FileLocator;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Resource;
import com.spacekiller.util.Tools;
import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.editor.ScratchPatternProvider;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.DefaultWaxEditorModel;
import com.waxmonster.editor.impl.WaxMonsterFaderMoveInterpreterConfig;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.model.AudioChunk;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MidiChunk;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.TimecodeChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.CachedAudioModel;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.Studio;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.TimecodeManager;
import com.waxmonster.waxlab.AudioLine;
import com.waxmonster.waxlab.AudioLineConfig;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.MidiLineConfig;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.AbstractScratchModeControl;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabLiveFeederResource;
import com.waxmonster.waxlab.util.WaxLabXmlUtil;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.AudioLineConfigPanel;
import com.waxmonster.waxlab.view.EditorLineConfigPanel;
import com.waxmonster.waxlab.view.EditorLineWrapper;
import com.waxmonster.waxlab.view.MidiLineConfigPanel;
import com.waxmonster.waxlab.view.MultiLineUtil;
import com.waxmonster.waxlab.view.ScratchAnalyzerPanel;
import com.waxmonster.waxlab.view.ScratchAnalyzerTask;
import com.waxmonster.waxlab.view.TimecodeDecoderTask;
import com.waxmonster.waxlab.view.TimecodeLineConfigPanel;
import com.waxmonster.waxlab.view.WaxLabFileFilters;
import com.waxmonster.waxlab.view.WaxLabLineConfigDialog;
import com.waxmonster.waxlab.view.WaxLabSettingsPanel;
import com.waxmonster.waxlab.view.WaxLabWizardPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class DefaultWaxLabPanel
extends AbstractWaxLabPanel {
    private static final long serialVersionUID = -4399276933224521369L;
    private static final Logger logger = Logger.getLogger(DefaultWaxLabPanel.class.getName());
    private File currentDirectory;
    private File currentFile;
    private MidiFactory midiFactory;
    private MidiFormatter midiFormatter;
    private ScratchPatternProvider[] scratchPatternProviders;
    private URL wizardAudioURL;

    public DefaultWaxLabPanel(WaxLab waxLab) {
        super(waxLab);
        DropTargetHandler dropTargetHandler = new DropTargetHandler();
        this.linePanel.setLineDropTargetListener(dropTargetHandler);
        this.currentDirectory = Platform.getInstance().getDataDir();
    }

    public void actionOpen() {
        int rc;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(true);
        if (this.currentDirectory != null) {
            chooser.setCurrentDirectory(this.currentDirectory);
        }
        if (this.currentFile != null) {
            chooser.setSelectedFile(this.currentFile);
        }
        if ((rc = chooser.showOpenDialog(this)) != 0) {
            return;
        }
        File[] files = chooser.getSelectedFiles();
        if (files.length < 1) {
            return;
        }
        this.currentFile = files[0];
        this.currentDirectory = this.currentFile.getParentFile();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                Point location = null;
                this.dropFile(file, location);
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void save() throws Exception {
        File projectDir;
        Studio studio;
        WaxLabDevice waxLabDevice;
        File file = this.waxLab.getWaxLabFile();
        if (file == null && (waxLabDevice = this.getWaxLabDevice()) != null && (studio = waxLabDevice.getStudio()) != null && (projectDir = studio.getDirectory()) != null) {
            String waxLabName = this.waxLab.getName();
            if (waxLabName == null && ((waxLabName = waxLabDevice.getTitle()) == null || waxLabName.length() < 1) && (waxLabName = waxLabDevice.getName()) == null) {
                waxLabName = "WaxLab";
            }
            for (int i = 1; i < 1000; ++i) {
                String waxLabFileName = waxLabName;
                if (i > 1) {
                    waxLabFileName = waxLabFileName + "_" + String.valueOf(i);
                }
                if ((file = new File(projectDir, waxLabFileName = waxLabFileName + ".xml")).exists()) continue;
                this.waxLab.setWaxLabFile(file);
                break;
            }
        }
        this.actionSave();
    }

    public void actionSave() {
        File file = this.waxLab.getWaxLabFile();
        if (file == null) {
            this.actionSaveAs();
            return;
        }
        try {
            boolean includeModelFiles = true;
            this.save(file, includeModelFiles);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void actionSaveAs() {
        try {
            String title = "Save WaxLab Device";
            String fileSuffix = ".xml";
            WaxLabFileFilters.WaxLabFileFilter fileFilter = new WaxLabFileFilters.WaxLabFileFilter();
            File waxLabFile = this.waxLab.getWaxLabFile();
            File file = this.promptSaveFile(title, waxLabFile, fileFilter, fileSuffix);
            if (file == null) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Saving WaxLab config to file: " + file);
            }
            boolean includeModelFiles = true;
            this.save(file, includeModelFiles);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean save(File targetFile, boolean includeModelFiles) throws IOException {
        boolean backup = true;
        File backupFile = null;
        if (backup && targetFile.exists() && targetFile.isFile()) {
            backupFile = new File(targetFile.getPath() + ".bak");
            if (backupFile.exists() && !backupFile.delete()) {
                throw new IOException("Failed to delete old backup file: " + backupFile);
            }
            if (!targetFile.renameTo(backupFile)) {
                throw new IOException("Failed to rename old waxlab file: " + targetFile + " to " + backupFile);
            }
        }
        boolean success = false;
        try {
            this.waxLab.saveWaxLabConfig(targetFile, includeModelFiles);
            this.waxLab.setWaxLabFile(targetFile);
            if (includeModelFiles) {
                HashSet doneModelSet = new HashSet();
                Line[] lines = this.waxLab.getLines();
                for (int i = 0; i < lines.length; ++i) {
                    Line line = lines[i];
                    if (line == null || this.saveLine(line, doneModelSet)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            this.waxLab.saveWaxLabConfig(targetFile, includeModelFiles);
            this.waxLab.clearDirtyFlag();
            success = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (!success) {
                if (targetFile.delete()) {
                    if (backupFile != null) {
                        if (backupFile.renameTo(targetFile)) {
                            logger.info("Restored backup file: " + backupFile + " -> " + targetFile);
                        } else {
                            logger.warning("Failed to restore backup file: " + backupFile + " -> " + targetFile);
                        }
                    }
                } else {
                    logger.warning("Failed to delete corrupted file: " + targetFile);
                }
            }
        }
    }

    protected File promptSaveFile(String dialogTitle, File selectedFile, FileFilter fileFilter, String fileSuffix) {
        boolean doPrompt = true;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(1);
        chooser.setDialogTitle(dialogTitle);
        chooser.setMultiSelectionEnabled(false);
        if (this.currentDirectory != null) {
            chooser.setCurrentDirectory(this.currentDirectory);
        }
        if (selectedFile != null) {
            chooser.setSelectedFile(selectedFile);
        } else {
            doPrompt = true;
        }
        if (doPrompt) {
            int rc;
            this.showWaxLabWindow();
            if (fileFilter != null) {
                chooser.setFileFilter(fileFilter);
            }
            if ((rc = chooser.showSaveDialog(this)) != 0) {
                return null;
            }
            selectedFile = chooser.getSelectedFile();
        }
        File file = selectedFile;
        String fileName = file.getName();
        if (fileSuffix != null && !fileName.toLowerCase().endsWith(fileSuffix)) {
            fileName = fileName + fileSuffix;
            file = new File(file.getParentFile(), fileName);
        }
        if (file.exists()) {
            this.showWaxLabWindow();
            String title = "Overwrite ?";
            String message = "File already exists. Overwrite ?";
            int optionType = 0;
            int rc = JOptionPane.showConfirmDialog(this, message, title, optionType);
            if (rc != 0) {
                return null;
            }
        }
        this.currentFile = file;
        this.currentDirectory = file.getParentFile();
        return file;
    }

    protected void showWaxLabWindow() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(true);
            if (window instanceof Frame) {
                ((Frame)window).setState(0);
            }
            window.toFront();
            window.requestFocus();
        }
    }

    protected boolean saveLine(Line line, Set doneModelSet) throws IOException {
        if (line == null) {
            return false;
        }
        if (line instanceof AudioLine) {
            return this.saveAudioLine((AudioLine)line, doneModelSet);
        }
        if (line instanceof TimecodeLine) {
            return this.saveTimecodeLine((TimecodeLine)line, doneModelSet);
        }
        if (line instanceof MidiLine) {
            return this.saveMidiLine((MidiLine)line, doneModelSet);
        }
        if (line instanceof EditorLine) {
            return this.saveEditorLine((EditorLine)line, doneModelSet);
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Unsupported line type: " + line.getClass().getName());
        }
        return false;
    }

    protected boolean saveAudioLine(AudioLine line, Set doneModelSet) throws IOException {
        AudioChunk[] chunks = line.getAudioChunks();
        for (int i = 0; i < chunks.length; ++i) {
            AudioChunk chunk = chunks[i];
            AudioModel model = chunk.getAudioModel();
            if (model == null || !doneModelSet.add(model)) continue;
            model.flush();
        }
        return true;
    }

    protected boolean saveTimecodeLine(TimecodeLine line, Set doneModelSet) throws IOException {
        TimecodeChunk[] chunks = line.getTimecodeChunks();
        for (int i = 0; i < chunks.length; ++i) {
            TimecodeChunk chunk = chunks[i];
            TimecodeModel model = chunk.getTimecodeModel();
            if (model == null || !doneModelSet.add(model)) continue;
            model.flush();
        }
        return true;
    }

    protected boolean saveMidiLine(MidiLine line, Set doneModelSet) throws IOException {
        MidiChunk[] chunks = line.getMidiChunks();
        for (int i = 0; i < chunks.length; ++i) {
            MidiChunk chunk = chunks[i];
            MidiModel model = chunk.getMidiModel();
            if (model == null || !doneModelSet.add(model)) continue;
            model.flush();
        }
        return true;
    }

    protected boolean saveEditorLine(EditorLine line, Set doneModelSet) throws IOException {
        WaxEditorModel[] chunks = line.getEditorChunks();
        for (int i = 0; i < chunks.length; ++i) {
            WaxEditorModel chunk = chunks[i];
            WaxEditorModel model = chunk;
            if (model == null || !doneModelSet.add(model)) continue;
            model.flush();
        }
        return true;
    }

    protected File backupFile(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (!file.isFile()) {
            return null;
        }
        File backupFile = new File(file.getPath() + ".bak");
        if (backupFile.exists() && !backupFile.delete()) {
            logger.warning("Failed to delete old backup file: " + backupFile);
            return null;
        }
        if (!file.renameTo(backupFile)) {
            logger.warning("Failed to rename backup file: " + file + " -> " + backupFile);
            return null;
        }
        return backupFile;
    }

    protected boolean restoreFile(File backupFile, File targetFile) {
        if (backupFile.renameTo(targetFile)) {
            logger.warning("Restored backup file: " + backupFile + " -> " + targetFile);
            return true;
        }
        logger.warning("Failed to rename backup file: " + backupFile + " -> " + targetFile);
        return false;
    }

    public void showSettingsDialog() {
        try {
            WaxLabPortInfo port;
            int i;
            int newDelay;
            boolean recStatus;
            int newRate;
            WaxLabDevice dev = this.getWaxLabDevice();
            if (dev == null) {
                return;
            }
            File contentDirectory = this.waxLab.getContentDirectory();
            String clockType = this.waxLab.getClockType();
            WaxLabPortInfo clockAudioPort = this.waxLab.getClockAudioPort();
            WaxLabPortInfo midiInputPort = this.waxLab.getMidiInputPort();
            MidiAction[] availableMidiActions = this.waxLab.getMidiActions();
            MidiMapping[] midiMappings = this.waxLab.getMidiMappings();
            WaxLabPortInfo midiOutputPort = this.waxLab.getMidiOutputPort();
            String[] availableMidiEvents = this.waxLab.getMidiEvents();
            MidiTrigger[] midiTriggers = this.waxLab.getMidiTriggers();
            WaxLabSettingsPanel panel = new WaxLabSettingsPanel();
            panel.setStudio(dev.getStudio());
            panel.setMidiFormatter(this.getMidiFormatter());
            panel.setMidiActions(availableMidiActions);
            panel.setMidiMappings(midiMappings);
            panel.setMidiEvents(availableMidiEvents);
            panel.setMidiTriggers(midiTriggers);
            panel.setLineOrientation(this.getOrientation());
            panel.setRefreshRate(this.getRefreshRate());
            panel.setShowOnAirWindow(this.isShowOnAirWindow());
            panel.setStopDelayMillis(this.getStopDelayMillis());
            panel.setInputPortTypes(dev.getSupportedInputPortTypes());
            panel.setOutputPortTypes(dev.getSupportedOutputPortTypes());
            LinkedList<WaxLabPortInfo> oldInputs = new LinkedList<WaxLabPortInfo>();
            LinkedList<WaxLabPortInfo> oldOutputs = new LinkedList<WaxLabPortInfo>();
            HashMap<WaxLabPortInfo, WaxLabPortInfo> portInfoMap = new HashMap<WaxLabPortInfo, WaxLabPortInfo>();
            WaxLabPortInfo[] oldPorts = dev.getWaxLabPorts();
            for (int i2 = 0; i2 < oldPorts.length; ++i2) {
                WaxLabPortInfo oldPort = oldPorts[i2];
                WaxLabPortInfo clone = oldPort.clonePortInfo();
                portInfoMap.put(oldPort, clone);
                if (clone.isInput()) {
                    oldInputs.add(clone);
                    continue;
                }
                oldOutputs.add(clone);
            }
            panel.setInputPorts(oldInputs.toArray(new WaxLabPortInfo[oldInputs.size()]));
            panel.setOutputPorts(oldOutputs.toArray(new WaxLabPortInfo[oldOutputs.size()]));
            panel.setContentDirectory(contentDirectory);
            panel.setClockType(clockType);
            panel.setClockAudioPort(clockAudioPort);
            panel.setMidiInputPort(midiInputPort);
            panel.setMidiOutputPort(midiOutputPort);
            panel.validate();
            WaxLabSettingsPanel message = panel;
            String title = "Wax Lab Settings";
            int optionType = 2;
            int messageType = -1;
            Icon icon = null;
            int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType, icon);
            if (rc != 0) {
                return;
            }
            int newOrient = panel.getLineOrientation();
            if (newOrient != this.getOrientation()) {
                this.setOrientation(newOrient);
            }
            if ((newRate = panel.getRefreshRate()) != this.getRefreshRate()) {
                this.setRefreshRate(newRate);
            }
            if ((recStatus = panel.isShowOnAirWindow()) != this.isShowOnAirWindow()) {
                this.setShowOnAirWindow(recStatus);
            }
            if ((newDelay = panel.getStopDelayMillis()) != this.getStopDelayMillis()) {
                this.setStopDelayMillis(newDelay);
            }
            this.waxLab.setContentDirectory(panel.getContentDirectory());
            this.waxLab.setClockAudioPort(panel.getClockAudioPort());
            this.waxLab.setClockType(panel.getClockType());
            this.waxLab.setMidiInputPort(panel.getMidiInputPort());
            MidiMapping[] newMappings = panel.getMidiMappings();
            this.waxLab.setMidiMappings(newMappings);
            this.waxLab.setMidiOutputPort(panel.getMidiOutputPort());
            MidiTrigger[] newTriggers = panel.getMidiTriggers();
            this.waxLab.setMidiTriggers(newTriggers);
            Line[] lines = this.waxLab.getLines();
            for (int i3 = 0; i3 < lines.length; ++i3) {
                EditorLine editorLine;
                MidiLine midiLine;
                TimecodeLine tcLine;
                AudioLine audioLine;
                AudioLineConfig lineConfig;
                Line line = lines[i3];
                if (line == null) continue;
                if (line instanceof AudioLine && (lineConfig = (audioLine = (AudioLine)line).getAudioLineConfig()) != null) {
                    lineConfig.setPlaybackPorts(this.resolveWaxLabPortInfos(lineConfig.getPlaybackPorts(), portInfoMap));
                    lineConfig.setRecordingPorts(this.resolveWaxLabPortInfos(lineConfig.getRecordingPorts(), portInfoMap));
                }
                if (line instanceof TimecodeLine && (lineConfig = (tcLine = (TimecodeLine)line).getTimecodeLineConfig()) != null) {
                    lineConfig.setPreFaderPorts(this.resolveWaxLabPortInfos(lineConfig.getPreFaderPorts(), portInfoMap));
                    lineConfig.setPostFaderPorts(this.resolveWaxLabPortInfos(lineConfig.getPostFaderPorts(), portInfoMap));
                    lineConfig.setRecordingPorts(this.resolveWaxLabPortInfos(lineConfig.getRecordingPorts(), portInfoMap));
                    lineConfig.setLiveFeedPorts(this.resolveWaxLabPortInfos(lineConfig.getLiveFeedPorts(), portInfoMap));
                    lineConfig.setMidiOutputPort(this.resolveWaxLabPortInfo(lineConfig.getMidiOutputPort(), portInfoMap));
                }
                if (line instanceof MidiLine && (lineConfig = (midiLine = (MidiLine)line).getMidiLineConfig()) != null) {
                    lineConfig.setPlaybackPort(this.resolveWaxLabPortInfo(lineConfig.getPlaybackPort(), portInfoMap));
                    lineConfig.setRecordingPort(this.resolveWaxLabPortInfo(lineConfig.getRecordingPort(), portInfoMap));
                }
                if (!(line instanceof EditorLine) || (lineConfig = (editorLine = (EditorLine)line).getEditorLineConfig()) == null) continue;
                lineConfig.setPlaybackPorts(this.resolveWaxLabPortInfos(lineConfig.getPlaybackPorts(), portInfoMap));
            }
            WaxLabPortInfo[] newInputs = panel.getInputPorts();
            WaxLabPortInfo[] newOutputs = panel.getOutputPorts();
            int newCount = newInputs.length + newOutputs.length;
            WaxLabPortInfo[] newPorts = new WaxLabPortInfo[newCount];
            int index = 0;
            for (i = 0; i < newInputs.length; ++i) {
                port = newInputs[i];
                port.setInput(true);
                newPorts[index++] = port;
            }
            for (i = 0; i < newOutputs.length; ++i) {
                port = newOutputs[i];
                port.setInput(false);
                newPorts[index++] = port;
            }
            dev.setWaxLabPorts(newPorts);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private WaxLabPortInfo[] resolveWaxLabPortInfos(WaxLabPortInfo[] infos, Map portInfoMap) {
        if (infos == null) {
            return null;
        }
        int num = infos.length;
        for (int i = 0; i < num; ++i) {
            infos[i] = this.resolveWaxLabPortInfo(infos[i], portInfoMap);
        }
        return infos;
    }

    private WaxLabPortInfo resolveWaxLabPortInfo(WaxLabPortInfo info, Map portInfoMap) {
        WaxLabPortInfo newInfo = (WaxLabPortInfo)portInfoMap.get(info);
        return newInfo == null ? info : newInfo;
    }

    public void showWizardDialog() {
        try {
            String lineTitle;
            int i;
            Line line;
            WaxLabWizardPanel wizard = new WaxLabWizardPanel();
            logger.info("wizardAudioURL: " + this.wizardAudioURL);
            if (this.wizardAudioURL != null) {
                wizard.playAudioClip(this.wizardAudioURL);
            }
            WaxLabWizardPanel message = wizard;
            String title = "Wax Wizard";
            int optionType = 2;
            int messageType = -1;
            Icon icon = null;
            int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType, icon);
            wizard.stopAudioClip();
            if (rc != 0) {
                return;
            }
            int deckCount = wizard.getDeckCount();
            if (deckCount < 1) {
                return;
            }
            boolean createAudioLines = wizard.isAudioEnabled();
            boolean createTimecodeLines = wizard.isTimecodeEnabled();
            boolean createLineFaders = wizard.isLineFaderEnabled();
            boolean createCrossFaders = wizard.isCrossFaderEnabled();
            boolean singleDeckLeft = deckCount == 1 ? wizard.isSingleDeckLeft() : false;
            boolean enableRecording = wizard.isEnableRecording();
            boolean createInputPorts = wizard.isCreateInputPorts();
            boolean enablePlayback = wizard.isEnablePlayback();
            boolean createOutputPorts = wizard.isCreateOutputPorts();
            boolean openConfig = wizard.isOpenConfigDialogs();
            ArrayList<Object> lines = new ArrayList<Object>();
            for (int i2 = 0; i2 < deckCount; ++i2) {
                AudioLine audioLine = null;
                if (createAudioLines) {
                    audioLine = this.waxLab.createAudioLine();
                }
                TimecodeLine timecodeLine = null;
                if (createTimecodeLines) {
                    boolean leftDeck = true;
                    if (i2 % 2 == 1 || deckCount == 1 && !singleDeckLeft) {
                        leftDeck = false;
                    }
                    timecodeLine = this.waxLab.createTimecodeLine(leftDeck);
                }
                if (i2 % 2 == 1 || deckCount == 1 && !singleDeckLeft) {
                    if (timecodeLine != null) {
                        lines.add(timecodeLine);
                    }
                    if (audioLine == null) continue;
                    lines.add(audioLine);
                    continue;
                }
                if (audioLine != null) {
                    lines.add(audioLine);
                }
                if (timecodeLine == null) continue;
                lines.add(timecodeLine);
            }
            Line[] studioLines = lines.toArray(new Line[lines.size()]);
            this.generateLineNames(studioLines, true, true, true, true);
            WaxLabDevice dev = this.getWaxLabDevice();
            if (dev != null && (createInputPorts || createOutputPorts)) {
                LinkedList<WaxLabPortInfo> createdPortList = new LinkedList<WaxLabPortInfo>();
                for (int i3 = 0; i3 < studioLines.length; ++i3) {
                    MidiLine midiLine;
                    String portName;
                    WaxLabPortInfo portInfo;
                    AudioLineConfig config;
                    line = studioLines[i3];
                    String lineName = line.getName();
                    if (line instanceof AudioLine) {
                        int playbackFrameType;
                        int k;
                        int frameType;
                        int channels;
                        AudioLine audioLine = (AudioLine)line;
                        config = audioLine.getAudioLineConfig();
                        if (config == null) continue;
                        if (createInputPorts && (channels = WaxLabXmlUtil.getFrameTypeChannelCount((int)(frameType = config.getRecordingFrameType()))) > 0) {
                            WaxLabPortInfo[] recordingPorts = new WaxLabPortInfo[channels];
                            for (k = 0; k < channels; ++k) {
                                portInfo = new WaxLabPortInfo();
                                portInfo.setInput(true);
                                portInfo.setType((PortType)AudioInputPortType.MONO);
                                portName = "" + lineName + "-In";
                                if (channels == 2) {
                                    portName = portName + "-" + (k == 0 ? "Left" : "Right");
                                } else if (channels > 2) {
                                    portName = portName + "-" + (k + 1);
                                }
                                portInfo.setName(portName);
                                recordingPorts[k] = portInfo;
                                createdPortList.add(portInfo);
                            }
                            config.setRecordingPorts(recordingPorts);
                        }
                        if (!createOutputPorts || (channels = WaxLabXmlUtil.getFrameTypeChannelCount((int)(playbackFrameType = config.getPlaybackFrameType()))) <= 0) continue;
                        WaxLabPortInfo[] playbackPorts = new WaxLabPortInfo[channels];
                        for (k = 0; k < channels; ++k) {
                            portInfo = new WaxLabPortInfo();
                            portInfo.setInput(false);
                            portInfo.setType((PortType)AudioOutputPortType.MONO);
                            portName = "" + lineName + "-Out";
                            if (channels == 2) {
                                portName = portName + "-" + (k == 0 ? "Left" : "Right");
                            } else if (channels > 2) {
                                portName = portName + "-" + (k + 1);
                            }
                            portInfo.setName(portName);
                            playbackPorts[k] = portInfo;
                            createdPortList.add(portInfo);
                        }
                        config.setPlaybackPorts(playbackPorts);
                        continue;
                    }
                    if (line instanceof TimecodeLine) {
                        int playbackFrameType;
                        int channels;
                        int channels2;
                        TimecodeLine tcLine = (TimecodeLine)line;
                        config = tcLine.getTimecodeLineConfig();
                        if (config == null) continue;
                        if (createInputPorts && (channels2 = 2) > 0) {
                            WaxLabPortInfo[] recordingPorts = new WaxLabPortInfo[channels2];
                            for (int k = 0; k < channels2; ++k) {
                                WaxLabPortInfo portInfo2 = new WaxLabPortInfo();
                                portInfo2.setInput(true);
                                portInfo2.setType((PortType)AudioInputPortType.MONO);
                                String portName2 = "" + lineName + "-In-" + (k == 0 ? "Left" : "Right");
                                portInfo2.setName(portName2);
                                recordingPorts[k] = portInfo2;
                                createdPortList.add(portInfo2);
                            }
                            config.setRecordingPorts(recordingPorts);
                        }
                        if (!createOutputPorts || (channels = WaxLabXmlUtil.getFrameTypeChannelCount((int)(playbackFrameType = config.getPlaybackFrameType()))) <= 0) continue;
                        WaxLabPortInfo[] playbackPorts = new WaxLabPortInfo[channels];
                        for (int k = 0; k < channels; ++k) {
                            portInfo = new WaxLabPortInfo();
                            portInfo.setInput(false);
                            portInfo.setType((PortType)AudioOutputPortType.MONO);
                            portName = "" + lineName + "-Out";
                            if (channels == 2) {
                                portName = portName + "-" + (k == 0 ? "Left" : "Right");
                            } else if (channels > 2) {
                                portName = portName + "-" + (k + 1);
                            }
                            portInfo.setName(portName);
                            playbackPorts[k] = portInfo;
                            createdPortList.add(portInfo);
                        }
                        config.setPostFaderPorts(playbackPorts);
                        continue;
                    }
                    if (!(line instanceof MidiLine) || (config = (midiLine = (MidiLine)line).getMidiLineConfig()) == null) continue;
                    if (createInputPorts) {
                        WaxLabPortInfo portInfo3 = new WaxLabPortInfo();
                        portInfo3.setInput(true);
                        portInfo3.setType((PortType)MidiInputPortType.TYPE);
                        String portName3 = "" + lineName + "-In";
                        portInfo3.setName(portName3);
                        createdPortList.add(portInfo3);
                        config.setRecordingPort(portInfo3);
                    }
                    if (!createOutputPorts) continue;
                    WaxLabPortInfo portInfo4 = new WaxLabPortInfo();
                    portInfo4.setInput(false);
                    portInfo4.setType((PortType)MidiOutputPortType.TYPE);
                    String portName4 = "" + lineName + "-Out";
                    portInfo4.setName(portName4);
                    createdPortList.add(portInfo4);
                    config.setPlaybackPort(portInfo4);
                }
                if (!createdPortList.isEmpty()) {
                    WaxLabPortInfo[] createdPorts = createdPortList.toArray(new WaxLabPortInfo[createdPortList.size()]);
                    WaxLabPortInfo[] currentPorts = this.getWaxLabDevice().getWaxLabPorts();
                    WaxLabPortInfo[] newPorts = new WaxLabPortInfo[currentPorts.length + createdPorts.length];
                    System.arraycopy(currentPorts, 0, newPorts, 0, currentPorts.length);
                    System.arraycopy(createdPorts, 0, newPorts, currentPorts.length, createdPorts.length);
                    dev.setWaxLabPorts(newPorts);
                }
            }
            int firstLineIndex = this.waxLab.getLineCount();
            for (i = 0; i < studioLines.length; ++i) {
                this.waxLab.addLine(studioLines[i]);
            }
            if (enableRecording || enablePlayback) {
                for (i = 0; i < studioLines.length; ++i) {
                    line = studioLines[i];
                    lineTitle = "Dummy";
                    boolean autoCommit = true;
                    this.actionConfigure(line, lineTitle, enableRecording, enablePlayback, autoCommit);
                }
            }
            this.refresh();
            if (openConfig) {
                for (i = 0; i < studioLines.length; ++i) {
                    line = studioLines[i];
                    lineTitle = "Configure " + line.getName();
                    this.linePanel.setFocusLineIndex(firstLineIndex + i);
                    if (!this.actionConfigure(line, lineTitle)) break;
                }
            }
            this.linePanel.setSelectedLineIndices(null);
            this.linePanel.setFocusLineIndex(-1);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void generateLineNames(Line[] lines, boolean checkAudio, boolean checkTimecode, boolean checkMidi, boolean checkEditor) {
        int num = lines.length;
        if (num < 1) {
            return;
        }
        int nextId = 1;
        if (this.waxLab != null) {
            HashSet<String> existingNames = new HashSet<String>();
            Line[] existingLines = this.waxLab.getLines();
            if (existingLines != null) {
                for (int i = 0; i < existingLines.length; ++i) {
                    existingNames.add(existingLines[i].getName());
                }
            }
            while (nextId < Integer.MAX_VALUE && (checkAudio && existingNames.contains(this.generateAudioLineName(nextId)) || checkTimecode && existingNames.contains(this.generateTimecodeLineName(nextId)) || checkMidi && existingNames.contains(this.generateMidiLineName(nextId)) || checkEditor && existingNames.contains(this.generateEditorLineName(nextId)))) {
                ++nextId;
            }
        }
        int nextAudioId = nextId;
        int nextTimecodeId = nextId;
        int nextEditorId = nextId;
        int nextMidiId = nextId;
        for (int i = 0; i < num; ++i) {
            Line line = lines[i];
            if (line instanceof AudioLine) {
                line.setName(this.generateAudioLineName(nextAudioId++));
                continue;
            }
            if (line instanceof TimecodeLine) {
                line.setName(this.generateTimecodeLineName(nextTimecodeId++));
                continue;
            }
            if (line instanceof EditorLine) {
                line.setName(this.generateEditorLineName(nextEditorId++));
                continue;
            }
            if (!(line instanceof MidiLine)) continue;
            line.setName(this.generateMidiLineName(nextMidiId++));
        }
    }

    protected String generateAudioLineName(int id) {
        return "Audio " + id;
    }

    protected String generateMidiLineName(int id) {
        return "Midi " + id;
    }

    protected String generateTimecodeLineName(int id) {
        return "Scratch " + id;
    }

    protected String generateEditorLineName(int id) {
        return "Editor " + id;
    }

    public void addAudioLine() {
        try {
            AudioLine line = this.waxLab.createAudioLine();
            this.generateLineNames(new Line[]{line}, true, false, false, false);
            this.actionAddLine((Line)line, "Add Audio Line");
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addTimecodeLine() {
        try {
            boolean leftDeck = false;
            TimecodeLine line = this.waxLab.createTimecodeLine(leftDeck);
            this.generateLineNames(new Line[]{line}, false, true, false, false);
            this.actionAddLine((Line)line, "Add Timecode Line");
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addMidiLine() {
        try {
            MidiLine line = this.waxLab.createMidiLine();
            this.generateLineNames(new Line[]{line}, false, false, true, false);
            this.actionAddLine((Line)line, "Add MIDI Line");
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addEditorLine() {
        try {
            EditorLine line = this.waxLab.createEditorLine();
            this.generateLineNames(new Line[]{line}, false, false, false, true);
            DefaultWaxEditorModel editorModel1 = new DefaultWaxEditorModel();
            line.getMutableChunkModel().addChunk((LineChunk)editorModel1);
            this.actionAddLine((Line)line, "Add Editor Line");
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public boolean actionAddLine(Line line, String title) {
        try {
            if (!this.actionConfigure(line, title)) {
                return false;
            }
            int index = this.waxLab.getLineCount();
            this.waxLab.addLine(line);
            SwingUtilities.invokeLater(new SelectLinesLater(new int[]{index}, index));
            return true;
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    public void showLineConfigDialog() {
        int selLineIndex = this.linePanel.getFocusLineIndex();
        if (selLineIndex < 0) {
            return;
        }
        AbstractLineWrapper wrapper = this.linePanel.getLineWrapperAt(selLineIndex);
        Line line = wrapper.getLine();
        if (line == null) {
            return;
        }
        String title = line instanceof AudioLine ? "Audio Line Configuration" : (line instanceof TimecodeLine ? "Scratch Line Configuration" : (line instanceof MidiLine ? "Midi Line Configuration" : (line instanceof EditorLine ? "Editor Line Configuration" : "Line Configuration")));
        this.actionConfigure(line, title);
    }

    protected boolean actionConfigure(Line line, String title) {
        return this.actionConfigure(line, title, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean actionConfigure(Line line, String title, boolean autoEnableRecording, boolean autoEnablePlayback, boolean autoCommit) {
        if (line == null) {
            return false;
        }
        Object tempMidiManager = null;
        try {
            JPanel panel;
            AudioLineConfig newConfig;
            EditorLine editorLine2;
            TimecodeLine timecodeLine;
            MidiLine midiLine;
            JPanel panel2;
            AudioLineConfig clone;
            AudioLine audioLine;
            WaxLabDevice waxLabDev = this.getWaxLabDevice();
            Studio studio = waxLabDev == null ? null : waxLabDev.getStudio();
            WaxLabPortInfo[] waxLabPorts = waxLabDev == null ? null : waxLabDev.getWaxLabPorts();
            Line[] waxLabLines = this.waxLab == null ? null : this.waxLab.getLines();
            AudioLineConfig lineConfig = null;
            AudioLineConfig lineConfigClone = null;
            JPanel configPanel = null;
            String iconImageResource = null;
            if (line instanceof AudioLine) {
                audioLine = (AudioLine)line;
                AudioLineConfig audioLineConfig = audioLine.getAudioLineConfig();
                clone = (AudioLineConfig)audioLineConfig.cloneLineConfig();
                clone.setName(audioLine.getName());
                panel2 = new AudioLineConfigPanel();
                ((AudioLineConfigPanel)panel2).setWaxLabPorts(waxLabPorts);
                ((AudioLineConfigPanel)panel2).setAudioLineConfig(clone);
                lineConfig = audioLineConfig;
                lineConfigClone = clone;
                configPanel = panel2;
                if (autoEnableRecording) {
                    ((AudioLineConfigPanel)panel2).enableRecording();
                }
                if (autoEnablePlayback) {
                    ((AudioLineConfigPanel)panel2).enablePlayback();
                }
                iconImageResource = "/com/waxmonster/waxlab/view/icons/audioline_icon.gif";
            } else if (line instanceof MidiLine) {
                midiLine = (MidiLine)line;
                MidiLineConfig midiLineConfig = midiLine.getMidiLineConfig();
                clone = (MidiLineConfig)midiLineConfig.cloneLineConfig();
                clone.setName(midiLine.getName());
                panel2 = new MidiLineConfigPanel();
                ((MidiLineConfigPanel)panel2).setWaxLabPorts(waxLabPorts);
                ((MidiLineConfigPanel)panel2).setMidiLineConfig((MidiLineConfig)clone);
                lineConfig = midiLineConfig;
                lineConfigClone = clone;
                configPanel = panel2;
                if (autoEnableRecording) {
                    ((MidiLineConfigPanel)panel2).enableRecording();
                }
                if (autoEnablePlayback) {
                    ((MidiLineConfigPanel)panel2).enablePlayback();
                }
                iconImageResource = "/com/waxmonster/waxlab/view/icons/note_clef_icon16.png";
            } else if (line instanceof TimecodeLine) {
                TimecodeManager timecodeManager;
                timecodeLine = (TimecodeLine)line;
                TimecodeLineConfig timecodeLineConfig = timecodeLine.getTimecodeLineConfig();
                clone = (TimecodeLineConfig)timecodeLineConfig.cloneLineConfig();
                clone.setName(timecodeLine.getName());
                TimecodeFormat[] timecodeFormats = null;
                if (this.waxLab != null && (timecodeManager = this.waxLab.getTimecodeManager()) != null) {
                    timecodeFormats = timecodeManager.getTimecodeFormats();
                }
                boolean liveFeed = false;
                Resource audioResource = timecodeLine.getScratchAudioResource();
                if (audioResource != null && audioResource instanceof WaxLabLiveFeederResource) {
                    liveFeed = true;
                }
                MidiAction[] midiActions = timecodeLine.getMidiActions();
                MidiMapping[] midiMappings = timecodeLine.getMidiMappings();
                String[] midiEvents = timecodeLine.getMidiEvents();
                MidiTrigger[] midiTriggers = timecodeLine.getMidiTriggers();
                TimecodeLineConfigPanel panel3 = new TimecodeLineConfigPanel();
                panel3.setStudio(studio);
                panel3.setWaxLabDevice(waxLabDev);
                panel3.setWaxLabPorts(waxLabPorts);
                panel3.setWaxLabLines(waxLabLines);
                panel3.setTimecodeLine(timecodeLine);
                panel3.setTimecodeFormats(timecodeFormats);
                panel3.setTimecodeLineConfig((TimecodeLineConfig)clone);
                panel3.setLiveFeed(liveFeed);
                panel3.setAudioResource(audioResource);
                panel3.setMidiFormatter(this.getMidiFormatter());
                panel3.setMidiActions(midiActions);
                panel3.setMidiMappings(midiMappings);
                panel3.setMidiEvents(midiEvents);
                panel3.setMidiTriggers(midiTriggers);
                lineConfig = timecodeLineConfig;
                lineConfigClone = clone;
                configPanel = panel3;
                if (autoEnableRecording) {
                    panel3.enableRecording();
                }
                if (autoEnablePlayback) {
                    panel3.enableScratching();
                }
                iconImageResource = "/com/waxmonster/waxlab/view/icons/timecode_icon.png";
            } else if (line instanceof EditorLine) {
                editorLine2 = (EditorLine)line;
                EditorLineConfig editorLineConfig = editorLine2.getEditorLineConfig();
                clone = (EditorLineConfig)editorLineConfig.cloneLineConfig();
                clone.setName(editorLine2.getName());
                Resource audioResource = editorLine2.getScratchAudioResource();
                EditorLineConfigPanel panel4 = new EditorLineConfigPanel();
                panel4.setWaxLabPorts(waxLabPorts);
                panel4.setEditorLineConfig((EditorLineConfig)clone);
                panel4.setAudioResource(audioResource);
                lineConfig = editorLineConfig;
                lineConfigClone = clone;
                configPanel = panel4;
                if (autoEnablePlayback) {
                    panel4.enablePlayback();
                }
                iconImageResource = "/com/waxmonster/waxlab/view/icons/editor_icon.png";
            }
            if (configPanel == null || lineConfig == null) {
                boolean editorLine2 = false;
                return editorLine2;
            }
            if (!autoCommit) {
                URL iconImageURL;
                Image iconImage = null;
                if (iconImageResource != null && (iconImageURL = this.getClass().getResource(iconImageResource)) != null) {
                    iconImage = new ImageIcon(iconImageURL).getImage();
                }
                Frame ownerFrame = null;
                if (iconImage != null) {
                    ownerFrame = new JFrame();
                    ((Frame)ownerFrame).setIconImage(iconImage);
                } else {
                    Window ownerWindow = SwingUtilities.getWindowAncestor(this);
                    if (ownerWindow != null && ownerWindow instanceof Frame) {
                        ownerFrame = (Frame)ownerWindow;
                    }
                }
                WaxLabLineConfigDialog dialog = new WaxLabLineConfigDialog(ownerFrame);
                dialog.setTitle(title);
                dialog.setConfigPanel(configPanel);
                dialog.setModal(true);
                dialog.pack();
                Tools.centerWindow((Component)this, (Window)dialog);
                dialog.setVisible(true);
                if (!dialog.isConfirmed()) {
                    boolean audioResource = false;
                    return audioResource;
                }
            }
            if (line instanceof AudioLine) {
                audioLine = (AudioLine)line;
                newConfig = lineConfigClone;
                this.waxLab.applyLineConfig((Line)audioLine, (LineConfig)newConfig);
            } else if (line instanceof TimecodeLine) {
                timecodeLine = (TimecodeLine)line;
                newConfig = (TimecodeLineConfig)lineConfigClone;
                panel = (TimecodeLineConfigPanel)configPanel;
                MidiMapping[] mappings = ((TimecodeLineConfigPanel)panel).getMidiMappings();
                timecodeLine.setMidiMappings(mappings);
                MidiTrigger[] triggers = ((TimecodeLineConfigPanel)panel).getMidiTriggers();
                timecodeLine.setMidiTriggers(triggers);
                Object resource = ((TimecodeLineConfigPanel)panel).isLiveFeed() ? new WaxLabLiveFeederResource() : ((TimecodeLineConfigPanel)panel).getAudioResource();
                timecodeLine.setScratchResource(resource, null);
                this.waxLab.applyLineConfig((Line)timecodeLine, (LineConfig)newConfig);
            } else if (line instanceof EditorLine) {
                editorLine2 = (EditorLine)line;
                newConfig = (EditorLineConfig)lineConfigClone;
                panel = (EditorLineConfigPanel)configPanel;
                Resource resource = ((EditorLineConfigPanel)panel).getAudioResource();
                editorLine2.setScratchResource(resource, null);
                this.waxLab.applyLineConfig((Line)editorLine2, (LineConfig)newConfig);
            } else if (line instanceof MidiLine) {
                midiLine = (MidiLine)line;
                newConfig = (MidiLineConfig)lineConfigClone;
                this.waxLab.applyLineConfig((Line)midiLine, (LineConfig)newConfig);
            }
            this.refreshLater();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempMidiManager != null) {
                tempMidiManager.close();
            }
        }
    }

    public void openTimecodeDecoderDialog() {
        try {
            TimecodeLine tcLine;
            int x;
            Line[] sel = this.getSelectedStudioLines();
            if (sel.length != 1) {
                return;
            }
            Line line = sel[0];
            if (!(line instanceof AudioLine)) {
                return;
            }
            AudioLine audioLine = (AudioLine)line;
            AudioModel audioModel = null;
            AudioChunk[] chunks = audioLine.getAudioChunks();
            if (chunks.length > 0) {
                AudioChunk chunk = chunks[chunks.length - 1];
                audioModel = chunk.getAudioModel();
            }
            logger.info("Audio model: " + audioModel);
            if (audioModel == null) {
                String title = "Timecode Decoder";
                String message = "The selected line does not contain any audio chunks to decode.";
                int messageType = 1;
                JOptionPane.showMessageDialog(this, message, title, messageType);
                return;
            }
            float frameRate = audioModel.getFrameRate();
            long frameLen = audioModel.getFrameLength();
            int channels = audioModel.getChannels();
            logger.info(" - Channels: " + channels);
            logger.info(" - Frame rate: " + frameRate);
            logger.info(" - Frame length: " + frameLen);
            if (channels != 2) {
                throw new RuntimeException("Invalid number of channels: " + channels + " != 2");
            }
            if (!(audioModel instanceof CachedAudioModel)) {
                throw new RuntimeException("Unsupported audio model type: " + audioModel.getClass().getName());
            }
            CachedAudioModel mutableAudioModel = (CachedAudioModel)audioModel;
            String fileNamePrefix = mutableAudioModel.getName();
            if (fileNamePrefix == null) {
                fileNamePrefix = "analyzed";
            }
            if ((x = fileNamePrefix.lastIndexOf(".")) >= 0) {
                fileNamePrefix = fileNamePrefix.substring(0, x);
            }
            if ((tcLine = null) == null) {
                boolean leftDeck = false;
                tcLine = this.waxLab.createTimecodeLine(leftDeck);
                tcLine.setName("NEW");
            }
            String title = "Timecode Decoder";
            this.actionConfigure((Line)tcLine, title, true, true, true);
            if (!this.actionConfigure((Line)tcLine, title)) {
                return;
            }
            TimecodeLineConfig tcConfig = tcLine.getTimecodeLineConfig();
            String tcFormatName = tcConfig.getTimecodeFormatName();
            int mode = AbstractScratchModeControl.getTimecodeDecoderMode((String)tcConfig.getScratchMode());
            if (mode < 0 || mode == 0) {
                mode = 1;
            }
            TimecodeManager tcManager = this.waxLab.getTimecodeManager();
            TimecodeFormat[] tcFormats = tcManager.getTimecodeFormats();
            TimecodeFormat tcFormat = null;
            if (tcFormatName != null) {
                for (int i = 0; i < tcFormats.length; ++i) {
                    if (!tcFormatName.equals(tcFormats[i].getName())) continue;
                    tcFormat = tcFormats[i];
                    break;
                }
            }
            logger.info("Timecode format: " + tcFormat);
            if (tcFormat == null) {
                throw new RuntimeException("Timecode format not found: " + tcFormatName);
            }
            logger.info("Starting timecode decoder task: audioModel=" + mutableAudioModel + ", timecodeFormat=" + tcFormat);
            TimecodeDecoderTask task = new TimecodeDecoderTask(this.waxLab, this, this.linePanel, mutableAudioModel, tcFormat, mode, fileNamePrefix, tcLine);
            ExecutionManager execMan = Platform.getInstance().getExecutionManager();
            if (execMan != null) {
                execMan.addExecution((Execution)task);
            }
            task.start();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void openScratchAnalyzerDialog() {
        try {
            EditorLine editorLine;
            Line[] sel = this.getSelectedStudioLines();
            if (sel.length != 1) {
                return;
            }
            Line selLine = sel[0];
            if (!(selLine instanceof TimecodeLine)) {
                return;
            }
            TimecodeLine tcLine = (TimecodeLine)selLine;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Timecode line: " + tcLine);
            }
            TimecodeModel tcModel = null;
            TimecodeChunk[] tcChunks = tcLine.getTimecodeChunks();
            if (tcChunks.length > 0) {
                TimecodeChunk chunk = tcChunks[tcChunks.length - 1];
                tcModel = chunk.getTimecodeModel();
            }
            logger.info("Timecode model: " + tcModel);
            if (tcModel == null) {
                String title = "Scratch Analyzer";
                String message = "The selected line does not contain any timecode chunks to analyze.";
                int messageType = 1;
                JOptionPane.showMessageDialog(this, message, title, messageType);
                return;
            }
            Object midiLine = null;
            FaderCurve faderCurve = null;
            boolean faderReverse = false;
            FaderModel faderModel = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Fader model: " + faderModel);
                if (faderModel != null) {
                    logger.fine("Fader curve: " + faderCurve);
                }
            }
            ScratchAnalyzerPanel panel = new ScratchAnalyzerPanel();
            String faderInfoText = "";
            Icon faderInfoIcon = null;
            if (midiLine == null) {
                faderInfoText = "No Midi line is associated to deck !";
            } else if (faderModel == null) {
                faderInfoText = "No fader model is available for line: " + midiLine.getName();
            }
            faderInfoIcon = faderInfoText.length() < 1 ? null : Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/view/icons/info_icon16.gif");
            panel.setFaderEnabled(faderModel != null);
            panel.setFaderSelected(faderModel != null);
            panel.setFaderInfoText(faderInfoText);
            panel.setFaderInfoIcon(faderInfoIcon);
            String title = "Scratch Analyzer";
            int optionType = 2;
            int messageType = -1;
            Icon icon = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/view/icons/scratch_analyzer_icon48.png");
            int rc = JOptionPane.showConfirmDialog(this, panel, title, optionType, messageType, icon);
            if (rc != 0) {
                return;
            }
            if (!panel.isFaderSelected()) {
                faderModel = null;
            }
            double maxFaderErrorRateInPercent = panel.getMaxFaderErrorRate();
            double maxFaderErrorRateNormalized = maxFaderErrorRateInPercent / 100.0;
            double maxFaderPointsPerSec = panel.getMaxFaderPoints();
            int maxFaderPoints = 2;
            if (faderModel != null) {
                float frameRate = faderModel.getFrameRate();
                long frameLen = faderModel.getFrameLength();
                double seconds = (float)frameLen / frameRate;
                if (seconds > 0.0) {
                    maxFaderPoints = (int)(maxFaderPointsPerSec * seconds);
                }
                if (maxFaderPoints < 2) {
                    maxFaderPoints = 2;
                }
            }
            WaxMonsterFaderMoveInterpreterConfig faderMoveInterpreterConfig = null;
            if (faderModel != null && panel.isFaderInterSelected()) {
                faderMoveInterpreterConfig = panel.getFaderMoveInterpreterConfig();
            }
            double maxErrorRate = panel.getMaxTimecodeErrorRate();
            double maxPointsPerSec = panel.getMaxTimecodePoints();
            float frameRate = tcModel.getFrameRate();
            long frameLen = tcModel.getFrameLength();
            double seconds = (float)frameLen / frameRate;
            int maxPoints = 2;
            if (seconds > 0.0) {
                maxPoints = (int)(maxPointsPerSec * seconds);
            }
            if (maxPoints < 2) {
                maxPoints = 2;
            }
            if ((editorLine = null) == null) {
                editorLine = this.waxLab.createEditorLine();
                this.generateLineNames(new Line[]{editorLine}, false, false, false, true);
                EditorLineConfig lineConfig = editorLine.getEditorLineConfig();
                if (lineConfig != null && faderCurve != null) {
                    lineConfig.setFaderCurve(faderCurve);
                }
            }
            logger.info("Starting scratch analyzer task: maxPointsPerSec=" + maxPointsPerSec + ", maxPoints=" + maxPoints + ", maxErrorRate=" + maxErrorRate + ", timecodeModel=" + tcModel + ", faderModel=" + faderModel + ", faderReverse=" + faderReverse + ", faderCurve=" + faderCurve);
            String name = "Scratch analyzer: " + tcModel.getName();
            ScratchAnalyzerTask task = new ScratchAnalyzerTask(name, this.waxLab, this, this.linePanel, editorLine, tcModel, maxPoints, maxErrorRate, faderModel, maxFaderPoints, maxFaderErrorRateNormalized, faderReverse, faderCurve, faderMoveInterpreterConfig);
            ExecutionManager execMan = Platform.getInstance().getExecutionManager();
            if (execMan != null) {
                execMan.addExecution((Execution)task);
            }
            task.start();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected Line createLine(File file) throws IOException {
        EditorLine line;
        String lineName = file.getName();
        int x = lineName.lastIndexOf(46);
        if (x >= 0) {
            lineName = lineName.substring(0, x);
        }
        if ((line = null) == null && this.waxLab.isTimecodeFile(file)) {
            boolean leftDeck = false;
            TimecodeLine timecodeLine = this.waxLab.createTimecodeLine(leftDeck);
            line = timecodeLine;
        }
        if (line == null && this.waxLab.isWaxEditorFile(file)) {
            EditorLine editorLine;
            line = editorLine = this.waxLab.createEditorLine();
        }
        if (line == null && this.waxLab.isMidiFile(file)) {
            MidiLine midiLine = this.waxLab.createMidiLine();
            line = midiLine;
        }
        if (line == null && this.waxLab.isAudioFile(file)) {
            AudioLine audioLine = this.waxLab.createAudioLine();
            line = audioLine;
        }
        if (line == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Unsupported file type: " + file);
            }
            return null;
        }
        line.setName(lineName);
        this.waxLab.addLine((Line)line);
        this.refresh();
        String title = "Dummy";
        boolean autoEnableRecording = false;
        boolean autoEnablePlayback = true;
        boolean autoCommit = true;
        this.actionConfigure((Line)line, title, autoEnableRecording, autoEnablePlayback, autoCommit);
        return line;
    }

    protected void dropFile(File file, Point location) throws IOException {
        Line line;
        String fileNameLower;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("dropFile: file=" + file + ", location=" + location);
        }
        if ((fileNameLower = file.getName().toLowerCase()).endsWith(".xml")) {
            this.loadWaxLabFile(file);
            return;
        }
        int lineIndex = -1;
        long timePos = 0L;
        if (location != null) {
            int x = location.x;
            int y = location.y;
            lineIndex = this.linePanel.lineIndexAtPoint(x, y);
            timePos = this.linePanel.timePositionForPoint(x, y);
        }
        AbstractLineWrapper lineWrapper = null;
        if (lineIndex >= 0) {
            lineWrapper = this.linePanel.getLineWrapperAt(lineIndex);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("dropFile: location=" + location + ", lineIndex=" + lineIndex + ", lineWrapper=" + lineWrapper + ", timePos=" + timePos);
        }
        if (lineWrapper == null && (lineWrapper = this.linePanel.getLineWrapperAt(lineIndex = this.waxLab.getLineIndex(line = this.createLine(file)))) == null) {
            logger.warning("Line wrapper not found: lineIndex=" + lineIndex + ", line=" + line);
        }
        if (lineWrapper != null) {
            boolean replaceArea = false;
            MultiLineUtil.performInsertFileAction(this.linePanel, lineWrapper, timePos, replaceArea, file);
        }
    }

    public void loadWaxLabFile(File file) throws IOException {
        int oldLineCount = this.waxLab.getLineCount();
        boolean includeModelFiles = true;
        this.waxLab.loadWaxLabConfig(file, includeModelFiles);
        if (oldLineCount < 1) {
            this.waxLab.setWaxLabFile(file);
            this.loadWaxLabSettings();
            this.waxLab.clearDirtyFlag();
        }
    }

    public void loadWaxLabFile(URL url) throws IOException {
        int oldLineCount = this.waxLab.getLineCount();
        boolean includeModelFiles = true;
        this.waxLab.loadWaxLabConfig(url, includeModelFiles);
        if (oldLineCount < 1) {
            this.loadWaxLabSettings();
        }
    }

    public void loadWaxLabFile(String path, boolean locate) throws IOException {
        File waxLabFile;
        block11: {
            waxLabFile = new File(path);
            if (!waxLabFile.isAbsolute()) {
                Studio studio;
                WaxLabDevice dev = this.getWaxLabDevice();
                Studio studio2 = studio = dev == null ? null : dev.getStudio();
                if (studio != null) {
                    String studioPath;
                    File studioDir = studio.getDirectory();
                    String string = studioPath = studioDir == null ? null : studioDir.getPath();
                    if (studioPath != null) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Resolving relative path: " + path + ", studioPath=" + studioPath);
                        }
                        try {
                            URL studioURL = new URL(studioPath);
                            URL waxLabURL = new URL(studioURL, path);
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer("Resolved relative URL: " + waxLabURL);
                            }
                            this.loadWaxLabFile(waxLabURL);
                            return;
                        }
                        catch (MalformedURLException e) {
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer("Path is not a relative URL: " + e.getMessage());
                            }
                            waxLabFile = new File(studioDir, path);
                            if (!logger.isLoggable(Level.FINER)) break block11;
                            logger.finer("Resolved relative File: " + waxLabFile);
                        }
                    }
                }
            }
        }
        if (!waxLabFile.exists()) {
            FileLocator locator;
            waxLabFile = null;
            if (locate && (locator = Platform.getInstance().getFileLocator()) != null) {
                waxLabFile = locator.locateFile(path);
            }
            if (waxLabFile == null) {
                throw new FileNotFoundException("WaxLab file not found: " + path);
            }
        }
        this.loadWaxLabFile(waxLabFile);
    }

    protected void loadWaxLabSettings() {
        int newOrient = -1;
        String sLineOrient = this.waxLab.getProperty("lineOrientation");
        if (sLineOrient != null && sLineOrient.length() > 0) {
            try {
                newOrient = Integer.parseInt(sLineOrient.trim());
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (newOrient != 0 && newOrient != 2) {
            newOrient = 0;
        }
        this.setOrientation(newOrient);
        int newRate = -1;
        String sRefreshRate = this.waxLab.getProperty("refreshRate");
        if (sRefreshRate != null && sRefreshRate.length() > 0) {
            try {
                newRate = Integer.parseInt(sRefreshRate.trim());
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        this.setRefreshRate(newRate);
        int stopDelay = -1;
        String sStopDelay = this.waxLab.getProperty("stopDelayMillis");
        if (sStopDelay != null && sStopDelay.length() > 0) {
            try {
                stopDelay = Integer.parseInt(sStopDelay.trim());
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (stopDelay < 0) {
            stopDelay = 0;
        }
        this.setStopDelayMillis(stopDelay);
        boolean showOnAirPanel = false;
        String sStatusInfo = this.waxLab.getProperty("showOnAirPanel");
        if (sStatusInfo != null) {
            showOnAirPanel = "true".equalsIgnoreCase(sStatusInfo.trim());
        }
        this.setShowOnAirWindow(showOnAirPanel);
    }

    public void removeSelectedLines() {
        WaxLab studio = this.getWaxLab();
        if (studio == null) {
            return;
        }
        Line[] lines = this.getSelectedStudioLines();
        for (int i = 0; i < lines.length; ++i) {
            studio.removeLine(lines[i]);
        }
        this.linePanel.setSelectedLineIndices(null);
    }

    public void removeAllLines() {
        WaxLab studio = this.getWaxLab();
        if (studio == null) {
            return;
        }
        this.linePanel.setMaximizedLineIndex(-1);
        int count = studio.getLineCount();
        for (int i = count - 1; i >= 0; --i) {
            studio.removeLine(studio.getLineAt(i));
        }
        this.linePanel.setSelectedLineIndices(null);
    }

    public void moveSelectedLines(int positions) {
        if (positions == 0) {
            return;
        }
        WaxLab studio = this.getWaxLab();
        if (studio == null) {
            return;
        }
        int count = studio.getLineCount();
        if (count < 1) {
            return;
        }
        int[] indices = this.linePanel.getSelectedLineIndices();
        if (indices.length < 1) {
            return;
        }
        int focusIndex = this.linePanel.getFocusLineIndex();
        int newFocusIndex = -1;
        int num = indices.length;
        int[] newIndices = new int[num];
        for (int i = 0; i < num; ++i) {
            int pos = positions < 0 ? i : num - i - 1;
            int index = indices[pos];
            int newIndex = index + positions;
            if (newIndex >= count) {
                newIndex = count - 1;
            }
            if (newIndex < 0) {
                newIndex = 0;
            }
            Line line = studio.getLineAt(index);
            studio.moveLine(line, newIndex);
            if (index == focusIndex) {
                newFocusIndex = newIndex;
            }
            newIndices[pos] = newIndex;
        }
        this.refresh();
        this.linePanel.setSelectedLineIndices(newIndices);
        this.linePanel.setFocusLineIndex(newFocusIndex);
        this.linePanel.setMaximizedLineIndex(-1);
    }

    public Line getMaximizedLine() {
        int lineIndex = this.linePanel.getMaximizedLineIndex();
        if (lineIndex < 0) {
            return null;
        }
        AbstractLineWrapper wrapper = this.linePanel.getLineWrapperAt(lineIndex);
        return wrapper.getLine();
    }

    public void setMaximizedLine(Line line) {
        int selIndex;
        WaxLab studio = this.getWaxLab();
        if (studio == null) {
            return;
        }
        int lineIndex = studio.getLineIndex(line);
        this.linePanel.setMaximizedLineIndex(lineIndex);
        if (lineIndex < 0 && (selIndex = this.linePanel.getFocusLineIndex()) >= 0) {
            this.linePanel.scrollLineToVisible(selIndex);
        }
    }

    public void removeSelectedElements() {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            editor.deleteSelectedElements();
        }
    }

    public void cloneSelectedElements() throws Exception {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            editor.cloneSelectedElements();
        }
    }

    public void copySelectedElements() throws Exception {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            editor.copySelectedElements();
        }
    }

    public void cutSelectedElements() {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            editor.cutSelectedElements();
        }
    }

    public void pasteElements() throws Exception {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            editor.pasteElements();
        }
    }

    public void insertTimecodePoint() {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            editor.insertTimecodePoint();
            return;
        }
    }

    public void insertFaderClick() {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            editor.insertFaderClick();
            return;
        }
    }

    public void showPropertiesDialog() {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            editor.showProperties();
            return;
        }
    }

    public void showInsertScratchPatternDialog() {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null && wrapper instanceof EditorLineWrapper) {
            EditorLineWrapper editor = (EditorLineWrapper)wrapper;
            editor.showInsertScratchPatternDialog();
            return;
        }
    }

    public void showExportSelectedLineDialog() {
        AbstractLineWrapper wrapper = this.getFocusLineWrapper();
        if (wrapper != null) {
            wrapper.showExportLineDialog(this, this.waxLab);
        }
    }

    public URL getWizardAudioURL() {
        return this.wizardAudioURL;
    }

    public void setWizardAudioURL(URL wizardAudioURL) {
        this.wizardAudioURL = wizardAudioURL;
    }

    protected MidiFormatter createMidiFormatter() {
        return DefaultMidiFormatter.getSharedInstance();
    }

    public MidiFormatter getMidiFormatter() {
        if (this.midiFormatter == null) {
            this.setMidiFormatter(this.createMidiFormatter());
        }
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    protected MidiFactory createMidiFactory() {
        return DefaultMidiFactory.getInstance();
    }

    public MidiFactory getMidiFactory() {
        if (this.midiFactory == null) {
            this.setMidiFactory(this.createMidiFactory());
        }
        return this.midiFactory;
    }

    public void setMidiFactory(MidiFactory midiFactory) {
        this.midiFactory = midiFactory;
    }

    public ScratchPatternProvider[] getScratchPatternProviders() {
        return this.scratchPatternProviders;
    }

    public void setScratchPatternProviders(ScratchPatternProvider[] scratchPatternProviders) {
        this.scratchPatternProviders = scratchPatternProviders;
        this.linePanel.setScratchPatternProviders(scratchPatternProviders);
    }

    @Override
    protected void initActionMap() {
        super.initActionMap();
        ActionMap actionMap = this.getActionMap();
        if (actionMap == null) {
            return;
        }
        actionMap.put("ShowWizardDialogAction", new ShowWizardDialogAction());
        actionMap.put("ShowSettingsDialogAction", new ShowSettingsDialogAction());
        actionMap.put("ShowLineConfigDialogAction", new ShowLineConfigDialogAction());
        actionMap.put("ShowLinePopupMenuAction", new ShowLinePopupMenuAction());
        actionMap.put("ShowTitlePopupMenuAction", new ShowTitlePopupMenuAction());
    }

    @Override
    protected void initInputMap() {
        super.initInputMap();
        InputMap inputMap = this.getInputMap(2);
        if (inputMap == null) {
            return;
        }
        inputMap.put(KeyStroke.getKeyStroke(87, 640), "ShowWizardDialogAction");
        inputMap.put(KeyStroke.getKeyStroke(10, 640), "ShowSettingsDialogAction");
        inputMap.put(KeyStroke.getKeyStroke(10, 512), "ShowLineConfigDialogAction");
        inputMap.put(KeyStroke.getKeyStroke(121, 128), "ShowLinePopupMenuAction");
        inputMap.put(KeyStroke.getKeyStroke(121, 64), "ShowTitlePopupMenuAction");
    }

    protected class ShowTitlePopupMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -5640862610168135086L;
        public static final String ACTION_KEY = "ShowTitlePopupMenuAction";

        protected ShowTitlePopupMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultWaxLabPanel.this.linePanel.showTitlePopupMenu();
        }
    }

    protected class ShowLinePopupMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -4982987349167287015L;
        public static final String ACTION_KEY = "ShowLinePopupMenuAction";

        protected ShowLinePopupMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultWaxLabPanel.this.linePanel.showLinePopupMenu();
        }
    }

    protected class ShowLineConfigDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = 844110248927557252L;
        public static final String ACTION_KEY = "ShowLineConfigDialogAction";

        protected ShowLineConfigDialogAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultWaxLabPanel.this.showLineConfigDialog();
        }
    }

    protected class ShowWizardDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = 5350362007996308532L;
        public static final String ACTION_KEY = "ShowWizardDialogAction";

        protected ShowWizardDialogAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultWaxLabPanel.this.showWizardDialog();
        }
    }

    protected class ShowSettingsDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = 400487953047896170L;
        public static final String ACTION_KEY = "ShowSettingsDialogAction";

        protected ShowSettingsDialogAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultWaxLabPanel.this.showSettingsDialog();
        }
    }

    protected class DropTargetHandler
    extends DropTargetAdapter {
        protected DropTargetHandler() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                dtde.acceptDrop(0x40000000);
                Transferable trans = dtde.getTransferable();
                List list = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                if (list != null && !list.isEmpty()) {
                    for (Object obj : list) {
                        if (!(obj instanceof File)) continue;
                        DefaultWaxLabPanel.this.dropFile((File)obj, dtde.getLocation());
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class SelectLinesLater
    implements Runnable {
        private int[] selectedLineIndices;
        private int focusLineIndex;

        public SelectLinesLater(int[] selectedLineIndices, int focusLineIndex) {
            this.selectedLineIndices = selectedLineIndices;
            this.focusLineIndex = focusLineIndex;
        }

        @Override
        public void run() {
            DefaultWaxLabPanel.this.linePanel.setSelectedLineIndices(this.selectedLineIndices);
            DefaultWaxLabPanel.this.linePanel.setFocusLineIndex(this.focusLineIndex);
        }
    }
}

