/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.media.control.AbstractDoubleControl;
import com.spacekiller.util.media.control.AbstractEnumControl;
import com.spacekiller.util.media.control.AbstractFloatControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.DoubleControl;
import com.spacekiller.util.media.control.FloatControl;
import com.spacekiller.util.media.control.TextFieldControlPanel;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.FaderCurveChooser;
import com.waxmonster.fader.impl.FaderCurveViewer;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.studio.PortType;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.PitchBpmControl;
import com.waxmonster.waxlab.PitchDeckControl;
import com.waxmonster.waxlab.PitchFactorControl;
import com.waxmonster.waxlab.PitchModeControl;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.AbstractPitchBpmControl;
import com.waxmonster.waxlab.impl.AbstractPitchFactorControl;
import com.waxmonster.waxlab.impl.AbstractPitchModeControl;
import com.waxmonster.waxlab.util.WaxLabXmlUtil;
import com.waxmonster.waxlab.view.CommonLineConfigPanel;
import com.waxmonster.waxlab.view.PitchControlPanel;
import com.waxmonster.waxlab.view.TimecodeLineConfigPanel;
import com.waxmonster.waxlab.view.VolumeControlPanel;
import com.waxmonster.waxlab.view.WaxLabPortChooser;
import com.waxmonster.waxlab.view.WaxLabViewUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditorLineConfigPanel
extends JPanel {
    private static final long serialVersionUID = -7496282121476023392L;
    private static final Logger logger = Logger.getLogger(EditorLineConfigPanel.class.getName());
    private WaxLabPortInfo[] waxLabPorts;
    private EditorLineConfig editorLineConfig;
    private Resource audioResource;
    private DoubleControl volumeControl;
    private PitchModeControlImpl pitchModeControl;
    private PitchFactorControlImpl pitchFactorControl;
    private PitchBpmControlImpl pitchBpmControl;
    private PitchDeckControlImpl pitchDeckControl;
    private FloatControl resampleControl;
    private boolean refreshing;
    private JPanel jPanelDecoder = null;
    private JCheckBox jCheckBoxPlaybackEnabled = null;
    private JLabel jLabelPlaybackFile = null;
    private JPanel jPanelAudioModel = null;
    private JComboBox jComboBoxPlaybackFile = null;
    private JButton jButtonBrowsePlaybackFile = null;
    private JPanel panelViewOptions = null;
    private JCheckBox jCheckBoxInvertedView = null;
    private JCheckBox jCheckBoxHideFaderPoints = null;
    private JCheckBox jCheckBoxHideTimecodePoints = null;
    private FaderCurveViewer faderCurveViewer = null;
    private JCheckBox jCheckBoxDisableAutoScroll = null;
    private JLabel labelChannels;
    private JComboBox comboBoxPlayChannels;
    private FaderCurveChooser faderCurveChooser;
    private JPanel panelCurveViewer;
    private JPanel panelCurve;
    private JLabel lblVolume;
    private JLabel lblOutputPorts;
    private WaxLabPortChooser waxLabPortChooserPlay;
    private JLabel lblPitch;
    private VolumeControlPanel volumeControlPanel;
    private JTabbedPane tabbedPane;
    private JPanel panelViewOptionsTab;
    private JPanel panelAudioPortsTab;
    private JPanel panelScratchControlTab;
    private JPanel panelScratchOutputPorts;
    private JPanel panelFaderCurveTab;
    private JPanel panelScratchControl;
    private JPanel panelTrackSource;
    private PitchControlPanel pitchControlPanel;
    private JPanel panelTrackSourceTab;
    private JPanel panel;
    private JRadioButton radioButtonOutputSampleRate;
    private JRadioButton radioButtonSourceSampleRate;
    private JRadioButton radioButtonCustomSampleRate;
    private TextFieldControlPanel textFieldControlPanelResampleCustom;
    private JLabel label;
    private CommonLineConfigPanel commonLineConfigPanel;

    public EditorLineConfigPanel() {
        this.initialize();
        this.initEditorLineConfigPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.gridy = 1;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(569, 445));
        GridBagConstraints gbc_commonLineConfigPanel = new GridBagConstraints();
        gbc_commonLineConfigPanel.weightx = 1.0;
        gbc_commonLineConfigPanel.insets = new Insets(0, 0, 5, 0);
        gbc_commonLineConfigPanel.fill = 1;
        gbc_commonLineConfigPanel.gridx = 0;
        gbc_commonLineConfigPanel.gridy = 0;
        this.add((Component)this.getCommonLineConfigPanel(), gbc_commonLineConfigPanel);
        this.add((Component)this.getJPanelDecoder(), gridBagConstraints2);
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.weighty = 1.0;
        gbc_tabbedPane.weightx = 1.0;
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 2;
        this.add((Component)this.getTabbedPane(), gbc_tabbedPane);
    }

    public EditorLineConfig getEditorLineConfig() {
        return this.editorLineConfig;
    }

    public void setEditorLineConfig(EditorLineConfig editorLineConfig) {
        this.editorLineConfig = editorLineConfig;
        this.refresh();
    }

    private JPanel getJPanelDecoder() {
        if (this.jPanelDecoder == null) {
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.weightx = 1.0;
            gridBagConstraints28.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints28.anchor = 17;
            gridBagConstraints28.gridy = 0;
            gridBagConstraints28.gridx = 0;
            this.jPanelDecoder = new JPanel();
            GridBagLayout gbl_jPanelDecoder = new GridBagLayout();
            gbl_jPanelDecoder.rowHeights = new int[]{0, 0, 0, 0};
            gbl_jPanelDecoder.rowWeights = new double[]{0.0, 1.0, 1.0, 1.0};
            gbl_jPanelDecoder.columnWidths = new int[]{0};
            gbl_jPanelDecoder.columnWeights = new double[]{0.0};
            this.jPanelDecoder.setLayout(gbl_jPanelDecoder);
            this.jPanelDecoder.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Scratch Playback", 0, 0, null, null));
            this.jPanelDecoder.add((Component)this.getJCheckBoxPlaybackEnabled(), gridBagConstraints28);
        }
        return this.jPanelDecoder;
    }

    private JCheckBox getJCheckBoxPlaybackEnabled() {
        if (this.jCheckBoxPlaybackEnabled == null) {
            this.jCheckBoxPlaybackEnabled = new JCheckBox();
            this.jCheckBoxPlaybackEnabled.setOpaque(false);
            this.jCheckBoxPlaybackEnabled.setText("Enabled");
            this.jCheckBoxPlaybackEnabled.setToolTipText("Playback enabled ?");
            this.jCheckBoxPlaybackEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditorLineConfigPanel.this.checkEnable();
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxPlaybackEnabled;
    }

    private JPanel getJPanelAudioModel() {
        if (this.jPanelAudioModel == null) {
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.insets = new Insets(0, 4, 0, 0);
            gridBagConstraints34.gridy = 0;
            gridBagConstraints34.gridx = 1;
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.fill = 1;
            gridBagConstraints33.gridy = 0;
            gridBagConstraints33.weightx = 1.0;
            gridBagConstraints33.gridx = 0;
            this.jPanelAudioModel = new JPanel();
            this.jPanelAudioModel.setLayout(new GridBagLayout());
            this.jPanelAudioModel.setOpaque(false);
            this.jPanelAudioModel.add((Component)this.getJComboBoxPlaybackFile(), gridBagConstraints33);
            this.jPanelAudioModel.add((Component)this.getJButtonBrowsePlaybackFile(), gridBagConstraints34);
        }
        return this.jPanelAudioModel;
    }

    private JComboBox getJComboBoxPlaybackFile() {
        if (this.jComboBoxPlaybackFile == null) {
            this.jComboBoxPlaybackFile = new JComboBox();
            this.jComboBoxPlaybackFile.setOpaque(false);
            this.jComboBoxPlaybackFile.setPreferredSize(new Dimension(350, 25));
            this.jComboBoxPlaybackFile.setToolTipText("Audio file");
            this.jComboBoxPlaybackFile.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!EditorLineConfigPanel.this.refreshing) {
                        File file = null;
                        Object item = EditorLineConfigPanel.this.jComboBoxPlaybackFile.getSelectedItem();
                        if (item != null) {
                            String path = String.valueOf(item);
                            file = new File(path);
                        }
                        EditorLineConfigPanel.this.setAudioResource((Resource)new FileResource(file));
                    }
                }
            });
        }
        return this.jComboBoxPlaybackFile;
    }

    private JButton getJButtonBrowsePlaybackFile() {
        if (this.jButtonBrowsePlaybackFile == null) {
            this.jButtonBrowsePlaybackFile = new JButton();
            this.jButtonBrowsePlaybackFile.setToolTipText("Open audio file...");
            this.jButtonBrowsePlaybackFile.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonBrowsePlaybackFile.setIcon(new ImageIcon(EditorLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/button-browse.gif")));
            this.jButtonBrowsePlaybackFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorLineConfigPanel.this.actionBrowsePlaybackFile();
                }
            });
        }
        return this.jButtonBrowsePlaybackFile;
    }

    private JPanel getPanelViewOptions() {
        if (this.panelViewOptions == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.gridy = 1;
            GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
            gridBagConstraints61.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints61.anchor = 17;
            gridBagConstraints61.gridx = 0;
            gridBagConstraints61.gridy = 0;
            gridBagConstraints61.weightx = 1.0;
            gridBagConstraints61.fill = 0;
            this.panelViewOptions = new JPanel();
            this.panelViewOptions.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "View Options", 4, 2, null, null));
            this.panelViewOptions.setLayout(new GridBagLayout());
            this.panelViewOptions.add((Component)this.getJCheckBoxInvertedView(), gridBagConstraints61);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridy = 0;
            this.panelViewOptions.add((Component)this.getJCheckBoxHideTimecodePoints(), gridBagConstraints5);
            this.panelViewOptions.add((Component)this.getJCheckBoxDisableAutoScroll(), gridBagConstraints12);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 1;
            this.panelViewOptions.add((Component)this.getJCheckBoxHideFaderPoints(), gridBagConstraints);
        }
        return this.panelViewOptions;
    }

    private JCheckBox getJCheckBoxInvertedView() {
        if (this.jCheckBoxInvertedView == null) {
            this.jCheckBoxInvertedView = new JCheckBox();
            this.jCheckBoxInvertedView.setOpaque(false);
            this.jCheckBoxInvertedView.setText("Inverted Direction");
            this.jCheckBoxInvertedView.setToolTipText("Inverted view direction ?");
            this.jCheckBoxInvertedView.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxInvertedView;
    }

    private JCheckBox getJCheckBoxHideFaderPoints() {
        if (this.jCheckBoxHideFaderPoints == null) {
            this.jCheckBoxHideFaderPoints = new JCheckBox();
            this.jCheckBoxHideFaderPoints.setOpaque(false);
            this.jCheckBoxHideFaderPoints.setText("Hide Fader Points");
            this.jCheckBoxHideFaderPoints.setToolTipText("Hide fader points ?");
            this.jCheckBoxHideFaderPoints.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxHideFaderPoints;
    }

    private JCheckBox getJCheckBoxHideTimecodePoints() {
        if (this.jCheckBoxHideTimecodePoints == null) {
            this.jCheckBoxHideTimecodePoints = new JCheckBox();
            this.jCheckBoxHideTimecodePoints.setOpaque(false);
            this.jCheckBoxHideTimecodePoints.setText("Hide Timecode Points");
            this.jCheckBoxHideTimecodePoints.setToolTipText("Hide timecode points ?");
            this.jCheckBoxHideTimecodePoints.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxHideTimecodePoints;
    }

    protected void initEditorLineConfigPanel() {
        ButtonGroup groupResampling = new ButtonGroup();
        groupResampling.add(this.radioButtonOutputSampleRate);
        groupResampling.add(this.radioButtonSourceSampleRate);
        groupResampling.add(this.radioButtonCustomSampleRate);
        this.volumeControl = new VolumeControlImpl();
        this.volumeControlPanel.setTextFormat(new DecimalFormat("0.0"));
        this.volumeControlPanel.setVolumeControl(this.volumeControl);
        this.pitchModeControl = new PitchModeControlImpl();
        this.pitchFactorControl = new PitchFactorControlImpl();
        this.pitchBpmControl = new PitchBpmControlImpl();
        this.pitchDeckControl = new PitchDeckControlImpl();
        this.pitchControlPanel.setPitchRanges(AbstractPitchFactorControl.getCommonPitchRanges());
        this.pitchControlPanel.setPitchModeControl((PitchModeControl)this.pitchModeControl);
        this.pitchControlPanel.setPitchFactorControl((PitchFactorControl)this.pitchFactorControl);
        this.pitchControlPanel.setPitchBpmControl((PitchBpmControl)this.pitchBpmControl);
        this.pitchControlPanel.setPitchDeckControl(this.pitchDeckControl);
        this.resampleControl = new ResampleControlImpl();
        this.resampleControl.setFloat(44100.0f);
        this.textFieldControlPanelResampleCustom.setControl((Control)this.resampleControl);
        this.checkEnable();
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            this.getCommonLineConfigPanel().setLineConfig((LineConfig)this.editorLineConfig);
            boolean playEnabled = false;
            int playFrameType = -1;
            double volumeFactor = 1.0;
            boolean invertedView = false;
            boolean hideTimecodePoints = false;
            boolean hideFaderPoints = false;
            boolean timecodeAutoScrolling = true;
            FaderCurve faderCurve = null;
            WaxLabPortInfo[] playPorts = null;
            float resampleRate = 0.0f;
            if (this.editorLineConfig != null) {
                playEnabled = this.editorLineConfig.isPlaybackEnabled();
                playFrameType = this.editorLineConfig.getPlaybackFrameType();
                volumeFactor = this.editorLineConfig.getVolumeFactor();
                invertedView = this.editorLineConfig.isInvertedView();
                hideTimecodePoints = this.editorLineConfig.isHideTimecodePoints();
                hideFaderPoints = this.editorLineConfig.isHideFaderPoints();
                timecodeAutoScrolling = this.editorLineConfig.isTimecodeAutoScrolling();
                faderCurve = this.editorLineConfig.getFaderCurve();
                playPorts = this.editorLineConfig.getPlaybackPorts();
                resampleRate = this.editorLineConfig.getResampleRate();
            }
            this.jCheckBoxPlaybackEnabled.setSelected(playEnabled);
            int[] frameTypes = WaxLabViewUtil.getFrameTypes();
            this.comboBoxPlayChannels.removeAllItems();
            int playFrameTypeIndex = -1;
            for (int i = 0; i < frameTypes.length; ++i) {
                int frameType = frameTypes[i];
                String frameTypeString = WaxLabViewUtil.formatFrameType(frameType);
                if (frameTypeString == null) continue;
                if (playFrameType == frameType) {
                    playFrameTypeIndex = this.comboBoxPlayChannels.getItemCount();
                }
                this.comboBoxPlayChannels.addItem(frameTypeString);
            }
            if (playFrameTypeIndex >= 0) {
                this.comboBoxPlayChannels.setSelectedIndex(playFrameTypeIndex);
            }
            int playChannels = WaxLabXmlUtil.getFrameTypeChannelCount((int)playFrameType);
            this.waxLabPortChooserPlay.setAudioChannelCount(playChannels);
            this.waxLabPortChooserPlay.setSelectedPorts(playPorts);
            this.volumeControl.setDouble(volumeFactor * 100.0);
            this.jCheckBoxInvertedView.setSelected(invertedView);
            this.jCheckBoxHideTimecodePoints.setSelected(hideTimecodePoints);
            this.jCheckBoxHideFaderPoints.setSelected(hideFaderPoints);
            this.jCheckBoxDisableAutoScroll.setSelected(!timecodeAutoScrolling);
            this.jComboBoxPlaybackFile.removeAllItems();
            Resource audioResource = this.getAudioResource();
            if (audioResource != null) {
                String path = audioResource.toString();
                int fileIndex = this.jComboBoxPlaybackFile.getItemCount();
                this.jComboBoxPlaybackFile.addItem(path);
                this.jComboBoxPlaybackFile.setSelectedIndex(fileIndex);
            }
            this.faderCurveChooser.setFaderCurve(faderCurve);
            this.refreshFaderCurveViewer();
            if (Float.isNaN(resampleRate)) {
                this.radioButtonSourceSampleRate.setSelected(true);
            } else if (resampleRate > 0.0f) {
                this.radioButtonCustomSampleRate.setSelected(true);
                this.resampleControl.setFloat(resampleRate);
            } else {
                this.radioButtonOutputSampleRate.setSelected(true);
            }
            this.checkEnable();
            this.checkPorts();
        }
        finally {
            this.refreshing = false;
        }
    }

    public Resource getAudioResource() {
        return this.audioResource;
    }

    public void setAudioResource(Resource audioResource) {
        this.audioResource = audioResource;
        this.refresh();
    }

    protected void checkEnable() {
        this.textFieldControlPanelResampleCustom.setEnabled(this.radioButtonCustomSampleRate.isSelected());
    }

    protected void actionBrowsePlaybackFile() {
        int rc;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        File audioFile = null;
        Resource audioResource = this.getAudioResource();
        if (audioResource != null && audioResource.isFile()) {
            try {
                audioFile = audioResource.getFile();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (audioFile != null) {
            chooser.setSelectedFile(audioFile);
        }
        if ((rc = chooser.showOpenDialog(this)) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.setAudioResource((Resource)new FileResource(file));
    }

    protected void apply() {
        float resampleRate;
        EditorLineConfig config = this.getEditorLineConfig();
        if (config == null) {
            return;
        }
        config.setPlaybackEnabled(this.jCheckBoxPlaybackEnabled.isSelected());
        config.setInvertedView(this.jCheckBoxInvertedView.isSelected());
        config.setHideTimecodePoints(this.getJCheckBoxHideTimecodePoints().isSelected());
        config.setHideFaderPoints(this.getJCheckBoxHideFaderPoints().isSelected());
        config.setTimecodeAutoScrolling(!this.getJCheckBoxDisableAutoScroll().isSelected());
        config.setFaderCurve(this.faderCurveChooser.getFaderCurve());
        config.setVolumeFactor(this.volumeControl.getDouble() / 100.0);
        if (this.radioButtonOutputSampleRate.isSelected()) {
            resampleRate = 0.0f;
        } else if (this.radioButtonSourceSampleRate.isSelected()) {
            resampleRate = Float.NaN;
        } else {
            resampleRate = this.resampleControl.getFloat();
            if (resampleRate < 0.0f) {
                resampleRate = 0.0f;
            }
        }
        config.setResampleRate(resampleRate);
        int playFrameType = -1;
        Object playFrameTypeItem = this.comboBoxPlayChannels.getSelectedItem();
        if (playFrameTypeItem != null) {
            playFrameType = WaxLabViewUtil.parseFrameType(String.valueOf(playFrameTypeItem));
        }
        config.setPlaybackFrameType(playFrameType);
        WaxLabPortInfo[] playPorts = this.waxLabPortChooserPlay.getSelectedPorts();
        config.setPlaybackPorts(playPorts);
    }

    public void enablePlayback() {
        this.getJCheckBoxPlaybackEnabled().setSelected(true);
    }

    private FaderCurveViewer getFaderCurveViewer() {
        if (this.faderCurveViewer == null) {
            this.faderCurveViewer = new FaderCurveViewer();
            this.faderCurveViewer.setBorder(null);
        }
        return this.faderCurveViewer;
    }

    private JCheckBox getJCheckBoxDisableAutoScroll() {
        if (this.jCheckBoxDisableAutoScroll == null) {
            this.jCheckBoxDisableAutoScroll = new JCheckBox();
            this.jCheckBoxDisableAutoScroll.setText("Disable Auto-Scrolling");
            this.jCheckBoxDisableAutoScroll.setToolTipText("Disable automatic timecode scrolling ?");
            this.jCheckBoxDisableAutoScroll.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxDisableAutoScroll;
    }

    private JLabel getLabelChannels() {
        if (this.labelChannels == null) {
            this.labelChannels = new JLabel("Channels:");
            this.labelChannels.setToolTipText("Number of audio channels");
        }
        return this.labelChannels;
    }

    private JComboBox getComboBoxPlayChannels() {
        if (this.comboBoxPlayChannels == null) {
            this.comboBoxPlayChannels = new JComboBox();
            this.comboBoxPlayChannels.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.checkPorts();
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
            this.comboBoxPlayChannels.setOpaque(false);
        }
        return this.comboBoxPlayChannels;
    }

    protected void refreshFaderCurveViewer() {
        if (this.faderCurveViewer == null) {
            return;
        }
        this.faderCurveViewer.removeAllFaderCurves();
        FaderCurve curve = this.faderCurveChooser.getFaderCurve();
        int orient = 1;
        this.faderCurveViewer.setOrientation(orient);
        if (curve != null) {
            this.faderCurveViewer.addFaderCurve(curve, Color.BLUE);
        }
        this.faderCurveViewer.validate();
        this.faderCurveViewer.repaint();
    }

    private FaderCurveChooser getFaderCurveChooser() {
        if (this.faderCurveChooser == null) {
            this.faderCurveChooser = new FaderCurveChooser();
            this.faderCurveChooser.setMinimumSize(new Dimension(50, 26));
            this.faderCurveChooser.setPreferredSize(new Dimension(200, 26));
            this.faderCurveChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                        EditorLineConfigPanel.this.refreshFaderCurveViewer();
                    }
                }
            });
            this.faderCurveChooser.setOpaque(false);
        }
        return this.faderCurveChooser;
    }

    private JPanel getPanelCurveViewer() {
        if (this.panelCurveViewer == null) {
            this.panelCurveViewer = new JPanel();
            this.panelCurveViewer.setBorder(new LineBorder(Color.LIGHT_GRAY));
            this.panelCurveViewer.setOpaque(false);
            this.panelCurveViewer.setLayout(new GridLayout(1, 0, 0, 0));
            this.panelCurveViewer.add((Component)this.getFaderCurveViewer());
        }
        return this.panelCurveViewer;
    }

    private JPanel getPanelCurve() {
        if (this.panelCurve == null) {
            this.panelCurve = new JPanel();
            this.panelCurve.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Fader Curve", 4, 2, null, null));
            GridBagLayout gbl_panelCurve = new GridBagLayout();
            gbl_panelCurve.columnWidths = new int[]{0, 0};
            gbl_panelCurve.rowHeights = new int[]{0, 0, 0};
            gbl_panelCurve.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelCurve.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelCurve.setLayout(gbl_panelCurve);
            GridBagConstraints gbc_faderCurveChooser = new GridBagConstraints();
            gbc_faderCurveChooser.insets = new Insets(4, 4, 4, 4);
            gbc_faderCurveChooser.fill = 2;
            gbc_faderCurveChooser.weightx = 1.0;
            gbc_faderCurveChooser.gridx = 0;
            gbc_faderCurveChooser.gridy = 0;
            this.panelCurve.add((Component)this.getFaderCurveChooser(), gbc_faderCurveChooser);
            GridBagConstraints gbc_panelCurveViewer = new GridBagConstraints();
            gbc_panelCurveViewer.insets = new Insets(4, 4, 4, 4);
            gbc_panelCurveViewer.weightx = 1.0;
            gbc_panelCurveViewer.weighty = 1.0;
            gbc_panelCurveViewer.fill = 1;
            gbc_panelCurveViewer.gridx = 0;
            gbc_panelCurveViewer.gridy = 1;
            this.panelCurve.add((Component)this.getPanelCurveViewer(), gbc_panelCurveViewer);
        }
        return this.panelCurve;
    }

    private JLabel getLblVolume() {
        if (this.lblVolume == null) {
            this.lblVolume = new JLabel("Output Volume:");
            this.lblVolume.setToolTipText("Volume factor");
        }
        return this.lblVolume;
    }

    private JLabel getLblOutputPorts() {
        if (this.lblOutputPorts == null) {
            this.lblOutputPorts = new JLabel("Output Ports:");
            this.lblOutputPorts.setToolTipText("Playback output port(s)");
        }
        return this.lblOutputPorts;
    }

    private WaxLabPortChooser getWaxLabPortChooserPlay() {
        if (this.waxLabPortChooserPlay == null) {
            this.waxLabPortChooserPlay = new WaxLabPortChooser();
            this.waxLabPortChooserPlay.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.waxLabPortChooserPlay;
    }

    public WaxLabPortInfo[] getWaxLabPorts() {
        return this.waxLabPorts;
    }

    public void setWaxLabPorts(WaxLabPortInfo[] waxLabPorts) {
        this.waxLabPorts = waxLabPorts;
        LinkedList<WaxLabPortInfo> listOutput = new LinkedList<WaxLabPortInfo>();
        if (waxLabPorts != null) {
            for (int i = 0; i < waxLabPorts.length; ++i) {
                PortType portType;
                WaxLabPortInfo info = waxLabPorts[i];
                if (info == null || (portType = info.getType()) == null || !(portType instanceof AudioOutputPortType)) continue;
                listOutput.add(info);
            }
        }
        WaxLabPortInfo[] outputPorts = listOutput.toArray(new WaxLabPortInfo[listOutput.size()]);
        this.waxLabPortChooserPlay.setAvailablePorts(outputPorts);
    }

    protected void checkPorts() {
        int playFrameType = -1;
        Object playFrameTypeitem = this.comboBoxPlayChannels.getSelectedItem();
        if (playFrameTypeitem != null) {
            playFrameType = WaxLabViewUtil.parseFrameType(String.valueOf(playFrameTypeitem));
        }
        int playChannels = -1;
        if (playFrameType >= 0) {
            playChannels = WaxLabXmlUtil.getFrameTypeChannelCount((int)playFrameType);
        }
        if (playChannels < 0) {
            playChannels = 0;
        }
        if (playChannels != this.waxLabPortChooserPlay.getAudioChannelCount()) {
            this.waxLabPortChooserPlay.setAudioChannelCount(playChannels);
            this.validate();
            this.repaint();
        }
    }

    private JLabel getLblPitch() {
        if (this.lblPitch == null) {
            this.lblPitch = new JLabel("Relative Pitch TODO:");
            this.lblPitch.setToolTipText("Relative pitch factor");
        }
        return this.lblPitch;
    }

    private VolumeControlPanel getVolumeControlPanel() {
        if (this.volumeControlPanel == null) {
            this.volumeControlPanel = new VolumeControlPanel();
        }
        return this.volumeControlPanel;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1);
            this.tabbedPane.setTabLayoutPolicy(1);
            this.tabbedPane.addTab("Output  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/export_wiz.gif")), this.getPanelAudioPortsTab(), "Audio output ports");
            this.tabbedPane.addTab("Scratch  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/timecode_icon.png")), this.getPanelScratchControlTab(), "Scratch control");
            this.tabbedPane.addTab("Track  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/audioline_icon.gif")), this.getPanelTrackSourceTab(), "Track source");
            this.tabbedPane.addTab("Fader  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/fader_icon.png")), this.getPanelFaderCurveTab(), "Fader control");
            this.tabbedPane.addTab("View  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/color_icon.gif")), this.getPanelViewOptionsTab(), "View options");
        }
        return this.tabbedPane;
    }

    private JPanel getPanelViewOptionsTab() {
        if (this.panelViewOptionsTab == null) {
            this.panelViewOptionsTab = new JPanel();
            GridBagLayout gbl_panelViewOptionsTab = new GridBagLayout();
            gbl_panelViewOptionsTab.columnWidths = new int[]{315, 0};
            gbl_panelViewOptionsTab.rowHeights = new int[]{82, 0};
            gbl_panelViewOptionsTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelViewOptionsTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelViewOptionsTab.setLayout(gbl_panelViewOptionsTab);
            GridBagConstraints gbc_panelViewOptions = new GridBagConstraints();
            gbc_panelViewOptions.fill = 1;
            gbc_panelViewOptions.weightx = 1.0;
            gbc_panelViewOptions.insets = new Insets(4, 4, 4, 4);
            gbc_panelViewOptions.anchor = 18;
            gbc_panelViewOptions.gridx = 0;
            gbc_panelViewOptions.gridy = 0;
            this.panelViewOptionsTab.add((Component)this.getPanelViewOptions(), gbc_panelViewOptions);
        }
        return this.panelViewOptionsTab;
    }

    private JPanel getPanelAudioPortsTab() {
        if (this.panelAudioPortsTab == null) {
            this.panelAudioPortsTab = new JPanel();
            GridBagLayout gbl_panelAudioPortsTab = new GridBagLayout();
            gbl_panelAudioPortsTab.columnWidths = new int[]{0, 0};
            gbl_panelAudioPortsTab.rowHeights = new int[]{0, 0};
            gbl_panelAudioPortsTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelAudioPortsTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelAudioPortsTab.setLayout(gbl_panelAudioPortsTab);
            GridBagConstraints gbc_panelScratchOutputPorts = new GridBagConstraints();
            gbc_panelScratchOutputPorts.weightx = 1.0;
            gbc_panelScratchOutputPorts.insets = new Insets(4, 4, 4, 4);
            gbc_panelScratchOutputPorts.fill = 1;
            gbc_panelScratchOutputPorts.gridx = 0;
            gbc_panelScratchOutputPorts.gridy = 0;
            this.panelAudioPortsTab.add((Component)this.getPanelScratchOutputPorts(), gbc_panelScratchOutputPorts);
        }
        return this.panelAudioPortsTab;
    }

    private JPanel getPanelScratchControlTab() {
        if (this.panelScratchControlTab == null) {
            this.panelScratchControlTab = new JPanel();
            GridBagLayout gbl_panelScratchControlTab = new GridBagLayout();
            gbl_panelScratchControlTab.columnWidths = new int[]{0, 0};
            gbl_panelScratchControlTab.rowHeights = new int[]{0, 0};
            gbl_panelScratchControlTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelScratchControlTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelScratchControlTab.setLayout(gbl_panelScratchControlTab);
            GridBagConstraints gbc_panelScratchControl = new GridBagConstraints();
            gbc_panelScratchControl.weightx = 1.0;
            gbc_panelScratchControl.insets = new Insets(4, 4, 0, 4);
            gbc_panelScratchControl.anchor = 11;
            gbc_panelScratchControl.fill = 2;
            gbc_panelScratchControl.gridx = 0;
            gbc_panelScratchControl.gridy = 0;
            this.panelScratchControlTab.add((Component)this.getPanelScratchControl(), gbc_panelScratchControl);
        }
        return this.panelScratchControlTab;
    }

    private JPanel getPanelScratchOutputPorts() {
        if (this.panelScratchOutputPorts == null) {
            this.panelScratchOutputPorts = new JPanel();
            this.panelScratchOutputPorts.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Scratch Audio Output", 4, 2, null, null));
            GridBagLayout gbl_panelScratchOutputPorts = new GridBagLayout();
            gbl_panelScratchOutputPorts.columnWidths = new int[]{0, 0, 0};
            gbl_panelScratchOutputPorts.rowHeights = new int[]{0, 0, 0};
            gbl_panelScratchOutputPorts.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelScratchOutputPorts.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelScratchOutputPorts.setLayout(gbl_panelScratchOutputPorts);
            GridBagConstraints gbc_labelChannels = new GridBagConstraints();
            gbc_labelChannels.anchor = 17;
            gbc_labelChannels.insets = new Insets(4, 4, 5, 5);
            gbc_labelChannels.gridx = 0;
            gbc_labelChannels.gridy = 0;
            this.panelScratchOutputPorts.add((Component)this.getLabelChannels(), gbc_labelChannels);
            GridBagConstraints gbc_comboBoxPlayChannels = new GridBagConstraints();
            gbc_comboBoxPlayChannels.anchor = 17;
            gbc_comboBoxPlayChannels.insets = new Insets(4, 4, 5, 5);
            gbc_comboBoxPlayChannels.gridx = 1;
            gbc_comboBoxPlayChannels.gridy = 0;
            this.panelScratchOutputPorts.add((Component)this.getComboBoxPlayChannels(), gbc_comboBoxPlayChannels);
            GridBagConstraints gbc_lblOutputPorts = new GridBagConstraints();
            gbc_lblOutputPorts.anchor = 18;
            gbc_lblOutputPorts.insets = new Insets(8, 4, 5, 5);
            gbc_lblOutputPorts.gridx = 0;
            gbc_lblOutputPorts.gridy = 1;
            this.panelScratchOutputPorts.add((Component)this.getLblOutputPorts(), gbc_lblOutputPorts);
            GridBagConstraints gbc_waxLabPortChooserPlay = new GridBagConstraints();
            gbc_waxLabPortChooserPlay.insets = new Insets(4, 4, 5, 5);
            gbc_waxLabPortChooserPlay.weightx = 1.0;
            gbc_waxLabPortChooserPlay.fill = 1;
            gbc_waxLabPortChooserPlay.gridx = 1;
            gbc_waxLabPortChooserPlay.gridy = 1;
            this.panelScratchOutputPorts.add((Component)this.getWaxLabPortChooserPlay(), gbc_waxLabPortChooserPlay);
        }
        return this.panelScratchOutputPorts;
    }

    private JPanel getPanelFaderCurveTab() {
        if (this.panelFaderCurveTab == null) {
            this.panelFaderCurveTab = new JPanel();
            GridBagLayout gbl_panelFaderCurveTab = new GridBagLayout();
            gbl_panelFaderCurveTab.columnWidths = new int[]{0, 0};
            gbl_panelFaderCurveTab.rowHeights = new int[]{0, 0};
            gbl_panelFaderCurveTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelFaderCurveTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelFaderCurveTab.setLayout(gbl_panelFaderCurveTab);
            GridBagConstraints gbc_panelCurve = new GridBagConstraints();
            gbc_panelCurve.insets = new Insets(4, 4, 4, 4);
            gbc_panelCurve.fill = 1;
            gbc_panelCurve.weighty = 1.0;
            gbc_panelCurve.weightx = 1.0;
            gbc_panelCurve.gridx = 0;
            gbc_panelCurve.gridy = 0;
            this.panelFaderCurveTab.add((Component)this.getPanelCurve(), gbc_panelCurve);
        }
        return this.panelFaderCurveTab;
    }

    private JPanel getPanelScratchControl() {
        if (this.panelScratchControl == null) {
            this.panelScratchControl = new JPanel();
            this.panelScratchControl.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Scratch Control", 4, 2, null, null));
            GridBagLayout gbl_panelScratchControl = new GridBagLayout();
            gbl_panelScratchControl.columnWidths = new int[]{0, 0, 0};
            gbl_panelScratchControl.rowHeights = new int[]{0, 0, 0};
            gbl_panelScratchControl.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelScratchControl.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelScratchControl.setLayout(gbl_panelScratchControl);
            GridBagConstraints gbc_lblVolume = new GridBagConstraints();
            gbc_lblVolume.anchor = 17;
            gbc_lblVolume.insets = new Insets(4, 4, 5, 5);
            gbc_lblVolume.gridx = 0;
            gbc_lblVolume.gridy = 0;
            this.panelScratchControl.add((Component)this.getLblVolume(), gbc_lblVolume);
            GridBagConstraints gbc_volumeControlPanel = new GridBagConstraints();
            gbc_volumeControlPanel.insets = new Insets(4, 4, 5, 5);
            gbc_volumeControlPanel.fill = 2;
            gbc_volumeControlPanel.weightx = 1.0;
            gbc_volumeControlPanel.gridx = 1;
            gbc_volumeControlPanel.gridy = 0;
            this.panelScratchControl.add((Component)this.getVolumeControlPanel(), gbc_volumeControlPanel);
            GridBagConstraints gbc_lblPitch = new GridBagConstraints();
            gbc_lblPitch.anchor = 18;
            gbc_lblPitch.insets = new Insets(8, 4, 5, 5);
            gbc_lblPitch.gridx = 0;
            gbc_lblPitch.gridy = 1;
            this.panelScratchControl.add((Component)this.getLblPitch(), gbc_lblPitch);
            GridBagConstraints gbc_pitchControlPanel = new GridBagConstraints();
            gbc_pitchControlPanel.insets = new Insets(4, 4, 5, 5);
            gbc_pitchControlPanel.fill = 1;
            gbc_pitchControlPanel.gridx = 1;
            gbc_pitchControlPanel.gridy = 1;
            this.panelScratchControl.add((Component)this.getPitchControlPanel(), gbc_pitchControlPanel);
        }
        return this.panelScratchControl;
    }

    private JPanel getPanelTrackSource() {
        if (this.panelTrackSource == null) {
            this.panelTrackSource = new JPanel();
            this.panelTrackSource.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Track Source", 4, 2, null, null));
            GridBagLayout gbl_panelTrackSource = new GridBagLayout();
            gbl_panelTrackSource.columnWidths = new int[]{0, 0, 0};
            gbl_panelTrackSource.rowHeights = new int[]{0, 0};
            gbl_panelTrackSource.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelTrackSource.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelTrackSource.setLayout(gbl_panelTrackSource);
            this.jLabelPlaybackFile = new JLabel();
            GridBagConstraints gbc_jLabelPlaybackFile = new GridBagConstraints();
            gbc_jLabelPlaybackFile.insets = new Insets(4, 4, 5, 5);
            gbc_jLabelPlaybackFile.gridx = 0;
            gbc_jLabelPlaybackFile.gridy = 0;
            this.panelTrackSource.add((Component)this.jLabelPlaybackFile, gbc_jLabelPlaybackFile);
            this.jLabelPlaybackFile.setToolTipText("Audio resource");
            this.jLabelPlaybackFile.setText("Audio Resource:");
            GridBagConstraints gbc_jPanelAudioModel = new GridBagConstraints();
            gbc_jPanelAudioModel.weightx = 1.0;
            gbc_jPanelAudioModel.fill = 2;
            gbc_jPanelAudioModel.insets = new Insets(4, 4, 5, 5);
            gbc_jPanelAudioModel.gridx = 1;
            gbc_jPanelAudioModel.gridy = 0;
            this.panelTrackSource.add((Component)this.getJPanelAudioModel(), gbc_jPanelAudioModel);
        }
        return this.panelTrackSource;
    }

    private PitchControlPanel getPitchControlPanel() {
        if (this.pitchControlPanel == null) {
            this.pitchControlPanel = new PitchControlPanel();
            this.pitchControlPanel.setBorder(new EtchedBorder(1, null, null));
        }
        return this.pitchControlPanel;
    }

    private JPanel getPanelTrackSourceTab() {
        if (this.panelTrackSourceTab == null) {
            this.panelTrackSourceTab = new JPanel();
            GridBagLayout gbl_panelTrackSourceTab = new GridBagLayout();
            gbl_panelTrackSourceTab.columnWidths = new int[]{0, 0};
            gbl_panelTrackSourceTab.rowHeights = new int[]{0, 0, 0};
            gbl_panelTrackSourceTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelTrackSourceTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelTrackSourceTab.setLayout(gbl_panelTrackSourceTab);
            GridBagConstraints gbc_panelTrackSource = new GridBagConstraints();
            gbc_panelTrackSource.insets = new Insets(4, 4, 5, 4);
            gbc_panelTrackSource.weightx = 1.0;
            gbc_panelTrackSource.fill = 1;
            gbc_panelTrackSource.gridx = 0;
            gbc_panelTrackSource.gridy = 0;
            this.panelTrackSourceTab.add((Component)this.getPanelTrackSource(), gbc_panelTrackSource);
            GridBagConstraints gbc_panel = new GridBagConstraints();
            gbc_panel.insets = new Insets(4, 4, 4, 4);
            gbc_panel.fill = 1;
            gbc_panel.gridx = 0;
            gbc_panel.gridy = 1;
            this.panelTrackSourceTab.add((Component)this.getPanel(), gbc_panel);
        }
        return this.panelTrackSourceTab;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Audio Resampling", 4, 2, null, new Color(51, 51, 51)));
            GridBagLayout gbl_panel = new GridBagLayout();
            gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
            gbl_panel.rowHeights = new int[]{0, 0, 0, 0};
            gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
            this.panel.setLayout(gbl_panel);
            GridBagConstraints gbc_radioButtonOutputSampleRate = new GridBagConstraints();
            gbc_radioButtonOutputSampleRate.anchor = 17;
            gbc_radioButtonOutputSampleRate.insets = new Insets(4, 4, 5, 5);
            gbc_radioButtonOutputSampleRate.gridx = 0;
            gbc_radioButtonOutputSampleRate.gridy = 0;
            this.panel.add((Component)this.getRadioButtonOutputSampleRate(), gbc_radioButtonOutputSampleRate);
            GridBagConstraints gbc_radioButtonSourceSampleRate = new GridBagConstraints();
            gbc_radioButtonSourceSampleRate.anchor = 17;
            gbc_radioButtonSourceSampleRate.insets = new Insets(4, 4, 5, 5);
            gbc_radioButtonSourceSampleRate.gridx = 0;
            gbc_radioButtonSourceSampleRate.gridy = 1;
            this.panel.add((Component)this.getRadioButtonSourceSampleRate(), gbc_radioButtonSourceSampleRate);
            GridBagConstraints gbc_radioButtonCustomSampleRate = new GridBagConstraints();
            gbc_radioButtonCustomSampleRate.anchor = 17;
            gbc_radioButtonCustomSampleRate.insets = new Insets(4, 4, 5, 5);
            gbc_radioButtonCustomSampleRate.gridx = 0;
            gbc_radioButtonCustomSampleRate.gridy = 2;
            this.panel.add((Component)this.getRadioButtonCustomSampleRate(), gbc_radioButtonCustomSampleRate);
            GridBagConstraints gbc_textFieldControlPanelResampleCustom = new GridBagConstraints();
            gbc_textFieldControlPanelResampleCustom.fill = 2;
            gbc_textFieldControlPanelResampleCustom.insets = new Insets(0, 0, 0, 5);
            gbc_textFieldControlPanelResampleCustom.gridx = 1;
            gbc_textFieldControlPanelResampleCustom.gridy = 2;
            this.panel.add((Component)this.getTextFieldControlPanelResampleCustom(), gbc_textFieldControlPanelResampleCustom);
            GridBagConstraints gbc_label = new GridBagConstraints();
            gbc_label.gridx = 2;
            gbc_label.gridy = 2;
            this.panel.add((Component)this.getLabel(), gbc_label);
        }
        return this.panel;
    }

    private JRadioButton getRadioButtonOutputSampleRate() {
        if (this.radioButtonOutputSampleRate == null) {
            this.radioButtonOutputSampleRate = new JRadioButton("Output sample rate");
            this.radioButtonOutputSampleRate.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditorLineConfigPanel.this.checkEnable();
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
            this.radioButtonOutputSampleRate.setToolTipText("Resampling to output sample rate (default)");
        }
        return this.radioButtonOutputSampleRate;
    }

    private JRadioButton getRadioButtonSourceSampleRate() {
        if (this.radioButtonSourceSampleRate == null) {
            this.radioButtonSourceSampleRate = new JRadioButton("Source sample rate");
            this.radioButtonSourceSampleRate.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditorLineConfigPanel.this.checkEnable();
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
            this.radioButtonSourceSampleRate.setToolTipText("Keep source sample rate (no resampling)");
        }
        return this.radioButtonSourceSampleRate;
    }

    private JRadioButton getRadioButtonCustomSampleRate() {
        if (this.radioButtonCustomSampleRate == null) {
            this.radioButtonCustomSampleRate = new JRadioButton("Custom sample rate:");
            this.radioButtonCustomSampleRate.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditorLineConfigPanel.this.checkEnable();
                    if (!EditorLineConfigPanel.this.refreshing) {
                        EditorLineConfigPanel.this.apply();
                    }
                }
            });
            this.radioButtonCustomSampleRate.setToolTipText("Custom sample rate (e.g. over-sampling)");
        }
        return this.radioButtonCustomSampleRate;
    }

    private TextFieldControlPanel getTextFieldControlPanelResampleCustom() {
        if (this.textFieldControlPanelResampleCustom == null) {
            this.textFieldControlPanelResampleCustom = new TextFieldControlPanel();
            this.textFieldControlPanelResampleCustom.setEnabled(false);
            this.textFieldControlPanelResampleCustom.setColumns(10);
        }
        return this.textFieldControlPanelResampleCustom;
    }

    private JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel("Hz.");
        }
        return this.label;
    }

    private CommonLineConfigPanel getCommonLineConfigPanel() {
        if (this.commonLineConfigPanel == null) {
            this.commonLineConfigPanel = new CommonLineConfigPanel();
        }
        return this.commonLineConfigPanel;
    }

    protected class ResampleControlImpl
    extends AbstractFloatControl {
        public ResampleControlImpl() {
            this.setMinimum(1.0f);
            this.setMaximum(1048576.0f);
        }

        protected void applyFloat(float v) {
            if (!EditorLineConfigPanel.this.refreshing) {
                EditorLineConfigPanel.this.apply();
            }
        }
    }

    protected class PitchDeckControlImpl
    extends AbstractEnumControl
    implements PitchDeckControl {
        protected PitchDeckControlImpl() {
        }

        protected void applyValue(Object v) {
            if (!EditorLineConfigPanel.this.refreshing) {
                EditorLineConfigPanel.this.apply();
            }
        }

        protected void setValues(Object[] values) {
            super.setValues(values);
        }

        public PitchDeck getPitchDeck() {
            throw new UnsupportedOperationException();
        }
    }

    protected class PitchBpmControlImpl
    extends AbstractPitchBpmControl {
        protected PitchBpmControlImpl() {
        }

        protected void applyDouble(double v) {
            if (!EditorLineConfigPanel.this.refreshing) {
                EditorLineConfigPanel.this.apply();
            }
        }
    }

    protected class PitchFactorControlImpl
    extends AbstractPitchFactorControl {
        protected PitchFactorControlImpl() {
        }

        protected void applyDouble(double v) {
            if (!EditorLineConfigPanel.this.refreshing) {
                EditorLineConfigPanel.this.apply();
            }
        }
    }

    protected class PitchModeControlImpl
    extends AbstractPitchModeControl {
        protected PitchModeControlImpl() {
        }

        protected void applyValue(Object v) {
            if (!EditorLineConfigPanel.this.refreshing) {
                EditorLineConfigPanel.this.apply();
            }
        }
    }

    protected class VolumeControlImpl
    extends AbstractDoubleControl {
        public VolumeControlImpl() {
            this.setMinimum(0.0);
            this.setMaximum(100.0);
        }

        protected void applyDouble(double v) {
            if (!EditorLineConfigPanel.this.refreshing) {
                EditorLineConfigPanel.this.apply();
            }
        }
    }
}

