/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.Data;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.media.control.AbstractAudioFormatControl;
import com.spacekiller.util.media.control.AudioFormatSettingsPanel;
import com.spacekiller.util.sound.AudioFile;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.model.impl.DefaultFaderFile;
import com.waxmonster.model.impl.DefaultTimecodeFile;
import com.waxmonster.model.impl.FaderFile;
import com.waxmonster.model.impl.TimecodeFile;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.WaxLab;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class EditorLineExportPanel
extends JPanel {
    private static final long serialVersionUID = -5635696359319928995L;
    private static final Logger logger = Logger.getLogger(EditorLineExportPanel.class.getName());
    private WaxLab waxLab;
    private EditorLine editorLine;
    private JDialog dialog;
    private JComboBox comboBoxTimecodeRate;
    private JComboBox comboBoxFaderRate;
    private AudioFormatSettingsPanel audioFormatSettingsPanel;

    public EditorLineExportPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Export Timecode Sample File", 4, 2, null, null));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(4, 4, 5, 4);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        this.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblTimecodeSampleRate = new JLabel("Sample Rate:");
        GridBagConstraints gbc_lblTimecodeSampleRate = new GridBagConstraints();
        gbc_lblTimecodeSampleRate.anchor = 17;
        gbc_lblTimecodeSampleRate.insets = new Insets(4, 4, 4, 4);
        gbc_lblTimecodeSampleRate.gridx = 0;
        gbc_lblTimecodeSampleRate.gridy = 0;
        panel_1.add((Component)lblTimecodeSampleRate, gbc_lblTimecodeSampleRate);
        this.comboBoxTimecodeRate = new JComboBox();
        this.comboBoxTimecodeRate.setOpaque(false);
        this.comboBoxTimecodeRate.setEditable(true);
        GridBagConstraints gbc_comboBoxTimecodeRate = new GridBagConstraints();
        gbc_comboBoxTimecodeRate.weightx = 1.0;
        gbc_comboBoxTimecodeRate.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxTimecodeRate.fill = 2;
        gbc_comboBoxTimecodeRate.gridx = 1;
        gbc_comboBoxTimecodeRate.gridy = 0;
        panel_1.add((Component)this.comboBoxTimecodeRate, gbc_comboBoxTimecodeRate);
        JButton btnExportTimecode = new JButton("Export...");
        btnExportTimecode.setMargin(new Insets(2, 4, 2, 4));
        btnExportTimecode.setIcon(new ImageIcon(EditorLineExportPanel.class.getResource("/com/waxmonster/waxlab/view/icons/export_icon16.gif")));
        btnExportTimecode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorLineExportPanel.this.actionExportTimecodeModel();
            }
        });
        GridBagConstraints gbc_btnExportTimecode = new GridBagConstraints();
        gbc_btnExportTimecode.insets = new Insets(4, 4, 4, 4);
        gbc_btnExportTimecode.anchor = 13;
        gbc_btnExportTimecode.gridx = 1;
        gbc_btnExportTimecode.gridy = 1;
        panel_1.add((Component)btnExportTimecode, gbc_btnExportTimecode);
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Export Fader Sample File", 4, 2, null, null));
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(4, 4, 5, 4);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 1;
        this.add((Component)panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel_2.setLayout(gbl_panel_2);
        JLabel labelFaderSampleRate = new JLabel("Sample Rate:");
        GridBagConstraints gbc_labelFaderSampleRate = new GridBagConstraints();
        gbc_labelFaderSampleRate.anchor = 17;
        gbc_labelFaderSampleRate.insets = new Insets(4, 4, 4, 4);
        gbc_labelFaderSampleRate.gridx = 0;
        gbc_labelFaderSampleRate.gridy = 0;
        panel_2.add((Component)labelFaderSampleRate, gbc_labelFaderSampleRate);
        this.comboBoxFaderRate = new JComboBox();
        this.comboBoxFaderRate.setOpaque(false);
        this.comboBoxFaderRate.setEditable(true);
        GridBagConstraints gbc_comboBoxFaderRate = new GridBagConstraints();
        gbc_comboBoxFaderRate.weightx = 1.0;
        gbc_comboBoxFaderRate.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxFaderRate.fill = 2;
        gbc_comboBoxFaderRate.gridx = 1;
        gbc_comboBoxFaderRate.gridy = 0;
        panel_2.add((Component)this.comboBoxFaderRate, gbc_comboBoxFaderRate);
        JButton btnExportFader = new JButton("Export...");
        btnExportFader.setMargin(new Insets(2, 4, 2, 4));
        btnExportFader.setIcon(new ImageIcon(EditorLineExportPanel.class.getResource("/com/waxmonster/waxlab/view/icons/export_icon16.gif")));
        btnExportFader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorLineExportPanel.this.actionExportFaderModel();
            }
        });
        GridBagConstraints gbc_btnExportFader = new GridBagConstraints();
        gbc_btnExportFader.insets = new Insets(4, 4, 4, 4);
        gbc_btnExportFader.anchor = 13;
        gbc_btnExportFader.gridx = 1;
        gbc_btnExportFader.gridy = 1;
        panel_2.add((Component)btnExportFader, gbc_btnExportFader);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Export Scratch Audio File", 4, 2, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weightx = 1.0;
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 2;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.audioFormatSettingsPanel = new AudioFormatSettingsPanel();
        GridBagConstraints gbc_audioFormatSettingsPanel = new GridBagConstraints();
        gbc_audioFormatSettingsPanel.weightx = 1.0;
        gbc_audioFormatSettingsPanel.insets = new Insets(4, 4, 4, 4);
        gbc_audioFormatSettingsPanel.fill = 1;
        gbc_audioFormatSettingsPanel.gridx = 0;
        gbc_audioFormatSettingsPanel.gridy = 0;
        panel.add((Component)this.audioFormatSettingsPanel, gbc_audioFormatSettingsPanel);
        JButton btnExportAudioFile = new JButton("Export...");
        btnExportAudioFile.setMargin(new Insets(2, 4, 2, 4));
        btnExportAudioFile.setIcon(new ImageIcon(EditorLineExportPanel.class.getResource("/com/waxmonster/waxlab/view/icons/export_icon16.gif")));
        GridBagConstraints gbc_btnExportAudioFile = new GridBagConstraints();
        gbc_btnExportAudioFile.insets = new Insets(4, 4, 4, 4);
        gbc_btnExportAudioFile.anchor = 13;
        gbc_btnExportAudioFile.gridx = 0;
        gbc_btnExportAudioFile.gridy = 1;
        panel.add((Component)btnExportAudioFile, gbc_btnExportAudioFile);
        btnExportAudioFile.setToolTipText("Export scratch to audio file...");
        btnExportAudioFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorLineExportPanel.this.actionExportScratchAudioFile();
            }
        });
        this.initEditorLineExportPanel();
    }

    public EditorLine getEditorLine() {
        return this.editorLine;
    }

    public void setEditorLine(EditorLine editorLine) {
        this.editorLine = editorLine;
    }

    public WaxLab getWaxLab() {
        return this.waxLab;
    }

    public void setWaxLab(WaxLab waxLab) {
        this.waxLab = waxLab;
    }

    protected void initEditorLineExportPanel() {
        float frameRate = AbstractAudioFormatControl.getDefaultAudioFrameRate();
        int sampleBits = 16;
        int channels = 2;
        int frameSize = sampleBits / 8 * channels;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        boolean bigEndian = false;
        AudioFormat audioFormat = new AudioFormat(encoding, frameRate, sampleBits, channels, frameSize, frameRate, bigEndian);
        this.audioFormatSettingsPanel.setAudioFormat(audioFormat);
        float[] commonRates = AbstractAudioFormatControl.getCommonAudioFrameRates();
        int selTimecodeRateIndex = -1;
        for (int i = 0; i < commonRates.length; ++i) {
            float rate = commonRates[i];
            if (rate == frameRate) {
                selTimecodeRateIndex = this.comboBoxTimecodeRate.getItemCount();
            }
            this.comboBoxTimecodeRate.addItem(this.getFrameRateNumber(rate));
        }
        if (selTimecodeRateIndex >= 0) {
            this.comboBoxTimecodeRate.setSelectedIndex(selTimecodeRateIndex);
        }
    }

    public void showDialog(Component parent, String title) {
        Window window = SwingUtilities.getWindowAncestor(parent);
        this.dialog = window != null && window instanceof Frame ? new JDialog((Frame)window) : new JDialog();
        this.dialog.setTitle(title);
        this.dialog.setContentPane(this);
        this.dialog.pack();
        Tools.centerWindow((Component)parent, (Window)this.dialog);
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
    }

    protected long computeEditorLineTimeLength() {
        double endTime = 0.0;
        WaxEditorModel[] wems = this.editorLine.getEditorChunks();
        for (int i = 0; i < wems.length; ++i) {
            WaxEditorModel wem = wems[i];
            double wemStartTime = wem.getStartTime();
            int num = wem.getItemCount();
            for (int k = 0; k < num; ++k) {
                double itemEndTime;
                WaxEditorItem item = wem.getItemAt(k);
                ScratchEditorModel sem = item.getModel();
                if (sem == null || !((itemEndTime = wemStartTime + item.getStartTime() + sem.getTimeLength()) > endTime)) continue;
                endTime = itemEndTime;
            }
        }
        return (long)Math.ceil(endTime * 1000000.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionExportScratchAudioFile() {
        try {
            AudioFormat audioFormat = this.audioFormatSettingsPanel.getAudioFormat();
            int bufferFrames = this.waxLab.getWaxLabPreferences().getAudioExportBufferSize() / audioFormat.getFrameSize();
            if (bufferFrames < 1) {
                bufferFrames = 1;
            }
            long lineOfs = 0L;
            long lineEnd = this.computeEditorLineTimeLength();
            JFileChooser fileChooser = new JFileChooser();
            File dataDir = Platform.getInstance().getDataDir();
            if (dataDir != null) {
                fileChooser.setCurrentDirectory(dataDir);
            }
            fileChooser.setDialogType(1);
            fileChooser.setFileSelectionMode(0);
            int rc = fileChooser.showDialog(this, "Export");
            if (rc != 0) {
                return;
            }
            File exportFile = fileChooser.getSelectedFile();
            if (exportFile == null) {
                return;
            }
            if (exportFile.exists() && !this.promptOverwrite(exportFile)) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("actionExportScratchAudioFile: editorLine=" + this.editorLine + ", lineOfs=" + lineOfs + ", lineEnd=" + lineEnd + ", audioFormat=" + audioFormat);
            }
            AudioFile audioFile = this.waxLab.createAudioFile(exportFile, audioFormat);
            long framePos = 0L;
            try {
                this.waxLab.exportEditorLineToAudioFile(this.editorLine, lineOfs, lineEnd, bufferFrames, audioFile, framePos);
            }
            finally {
                audioFile.close();
            }
            if (this.dialog != null) {
                this.dialog.dispose();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected JComboBox getComboBoxTimecodeRate() {
        return this.comboBoxTimecodeRate;
    }

    protected JComboBox getComboBoxFaderRate() {
        return this.comboBoxFaderRate;
    }

    protected AudioFormatSettingsPanel getAudioFormatSettingsPanel() {
        return this.audioFormatSettingsPanel;
    }

    protected Number getFrameRateNumber(float frameRate) {
        int intRate = (int)frameRate;
        if (frameRate == (float)intRate) {
            return Data.toInteger((int)intRate);
        }
        return Data.toFloat((float)frameRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionExportTimecodeModel() {
        try {
            Object sampleRateObj = this.comboBoxTimecodeRate.getSelectedItem();
            float sampleRate = Float.parseFloat(String.valueOf(sampleRateObj));
            int bufferFrames = this.waxLab.getWaxLabPreferences().getTimecodeExportBufferSize() / 8;
            if (bufferFrames < 1) {
                bufferFrames = 1;
            }
            long lineOfs = 0L;
            long lineEnd = this.computeEditorLineTimeLength();
            JFileChooser fileChooser = new JFileChooser();
            File dataDir = Platform.getInstance().getDataDir();
            if (dataDir != null) {
                fileChooser.setCurrentDirectory(dataDir);
            }
            fileChooser.setDialogType(1);
            fileChooser.setFileSelectionMode(0);
            int rc = fileChooser.showDialog(this, "Export");
            if (rc != 0) {
                return;
            }
            File exportFile = fileChooser.getSelectedFile();
            if (exportFile == null) {
                return;
            }
            if (exportFile.exists() && !this.promptOverwrite(exportFile)) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("actionExportTimecodeModel: editorLine=" + this.editorLine + ", lineOfs=" + lineOfs + ", lineEnd=" + lineEnd + ", sampleRate=" + sampleRate);
            }
            DefaultTimecodeFile timecodeFile = new DefaultTimecodeFile(exportFile, sampleRate);
            long framePos = 0L;
            try {
                this.waxLab.exportEditorLineToTimecodeFile(this.editorLine, lineOfs, lineEnd, bufferFrames, (TimecodeFile)timecodeFile, framePos);
            }
            finally {
                timecodeFile.close();
            }
            if (this.dialog != null) {
                this.dialog.dispose();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionExportFaderModel() {
        try {
            Object sampleRateObj = this.comboBoxFaderRate.getSelectedItem();
            float sampleRate = Float.parseFloat(String.valueOf(sampleRateObj));
            int bufferFrames = this.waxLab.getWaxLabPreferences().getFaderExportBufferSize() / 4;
            if (bufferFrames < 1) {
                bufferFrames = 1;
            }
            long lineOfs = 0L;
            long lineEnd = this.computeEditorLineTimeLength();
            JFileChooser fileChooser = new JFileChooser();
            File dataDir = Platform.getInstance().getDataDir();
            if (dataDir != null) {
                fileChooser.setCurrentDirectory(dataDir);
            }
            fileChooser.setDialogType(1);
            fileChooser.setFileSelectionMode(0);
            int rc = fileChooser.showDialog(this, "Export");
            if (rc != 0) {
                return;
            }
            File exportFile = fileChooser.getSelectedFile();
            if (exportFile == null) {
                return;
            }
            if (exportFile.exists() && !this.promptOverwrite(exportFile)) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("actionExportFaderModel: editorLine=" + this.editorLine + ", lineOfs=" + lineOfs + ", lineEnd=" + lineEnd + ", sampleRate=" + sampleRate);
            }
            DefaultFaderFile faderFile = new DefaultFaderFile(exportFile, sampleRate);
            long framePos = 0L;
            try {
                this.waxLab.exportEditorLineToFaderFile(this.editorLine, lineOfs, lineEnd, bufferFrames, (FaderFile)faderFile, framePos);
            }
            finally {
                faderFile.close();
            }
            if (this.dialog != null) {
                this.dialog.dispose();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected boolean promptOverwrite(File file) {
        int messageType;
        int optionType;
        String title = "Overwrite ?";
        String message = "Are you sure to overwrite existing file:\n" + file;
        int rc = JOptionPane.showConfirmDialog(this, message, title, optionType = 2, messageType = 3);
        return rc == 0;
    }
}

