/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.Data;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.waxmonster.editor.FaderClick;
import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.FaderPoint;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.ScratchPattern;
import com.waxmonster.editor.ScratchPatternProvider;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.WaxEditorLineView;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.DefaultFaderClick;
import com.waxmonster.editor.impl.DefaultScratchEditorModel;
import com.waxmonster.editor.impl.DefaultWaxEditorFile;
import com.waxmonster.editor.impl.DefaultWaxEditorItem;
import com.waxmonster.editor.impl.DefaultWaxEditorLineView;
import com.waxmonster.editor.impl.DefaultWaxEditorModel;
import com.waxmonster.editor.impl.FaderClickFaderPointRenderer;
import com.waxmonster.editor.impl.FaderClickPropertiesPanel;
import com.waxmonster.editor.impl.FaderMoveFaderPointRenderer;
import com.waxmonster.editor.impl.PropertiesPanel;
import com.waxmonster.editor.impl.WaxEditorItemPropertiesPanel;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.model.ChunkListener;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.view.LineManager;
import com.waxmonster.model.view.LineView;
import com.waxmonster.view.ScrollPos;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewLayout;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.view.AbstractScratchLineWrapper;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.EditorLineExportPanel;
import com.waxmonster.waxlab.view.MultiLinePanel;
import com.waxmonster.waxlab.view.ScratchGeneratorPanel;
import com.waxmonster.waxlab.view.WaxLabFileFilters;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class EditorLineWrapper
extends AbstractScratchLineWrapper {
    private static final Logger logger = Logger.getLogger(EditorLineWrapper.class.getName());
    private static final int MAX_SIZE = 0x40000000;
    private final EditorLine editorLine;
    private final DefaultWaxEditorLineView editorView;
    private boolean hideTimecodePoints;
    private boolean hideFaderPoints;
    private double maxPointDistance = 6.0;
    private double maxModelDistance = 10.0;
    private double minPointDistMillis = 1.0;
    private double minFaderPointOffset = 1.0E-4;
    private FaderMoveFaderPointRenderer faderMoveRenderer;
    private FaderClickFaderPointRenderer faderClickRenderer;
    private ClipboardManager clipboardManager;
    private BeanDropSupport beanDropSupport;
    private InterpolatorRegistry interpolatorRegistry;
    private ChangeListener editorSelectionChangeHandler;
    private boolean pressed;
    private boolean dragging;
    private DragPoint[] dragPointsOld;
    private DragPoint[] dragPointsNew;
    private Map dragItemMap;
    private DragItem[] dragItems;
    private DragFaderMove[] dragFaderMoves;
    private int anchorX;
    private int anchorY;
    private double anchorPos;
    private double anchorVal;
    private ScratchGeneratorPanel scratchGeneratorPanel;
    private JDialog scratchGeneratorDialog;
    private Timer pointMoveTimer;
    private PointMover pointMover;
    private int pointMoveDelay = 10;
    private int pointMoveInitialDelay = 100;
    private int pointMoveIncrementX;
    private int pointMoveIncrementY;
    private boolean pointMoveSpeedup;
    private int pointMoveCounter;
    private int pointMoveFactorX;
    private int pointMoveFactorY;
    private int pointMoveMaxFactor = 100;
    private int pointMoveSpeedupDelay = 20;

    public EditorLineWrapper(MultiLinePanel panel, EditorLine editorLine, ViewLayout layout, int gridIndex, LineManager manager, WaxLabViewSettings viewSettings, float mergeFrameRate) {
        super(panel, (Line)editorLine, layout, gridIndex);
        this.editorLine = editorLine;
        this.setLineManager(manager);
        this.anchorX = -1;
        this.anchorY = -1;
        this.dragging = false;
        this.pointMover = new PointMover();
        this.pointMoveTimer = new Timer(this.pointMoveDelay, this.pointMover);
        this.setKeyListener(new KeyHandler());
        MouseHandler mouseHandler = new MouseHandler();
        this.setMouseListener(mouseHandler);
        this.setMouseMotionListener(mouseHandler);
        this.setMouseWheelListener(mouseHandler);
        int orient = panel.getOrientation();
        boolean horiz = orient == 0 || orient == 1;
        int trackSize = editorLine.getTrackSize();
        if (trackSize < 0) {
            trackSize = viewSettings.getEditorViewSize();
        }
        this.setTrackSize(trackSize);
        this.tileView = null;
        this.editorView = new DefaultWaxEditorLineView(mergeFrameRate, this.tileView);
        this.editorView.setLineManager(manager);
        this.setLineViews(new LineView[]{this.editorView});
        Rectangle bounds = this.editorView.getBounds();
        if (horiz) {
            bounds.width = 0x40000000;
            bounds.height = trackSize;
        } else {
            bounds.width = trackSize;
            bounds.height = 0x40000000;
        }
        this.editorView.setBounds(bounds);
        ScrollView scrollView = new ScrollView();
        scrollView.setViews(new View[]{this.editorView});
        this.setScrollView(scrollView);
        this.setRecRefreshToPos(false);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        ChunkModel chunkModel = this.line.getChunkModel();
        if (chunkModel != null) {
            chunkModel.registerChunkListener((ChunkListener)this.chunkHandler);
        }
    }

    @Override
    public void dispose() {
        ChunkModel chunkModel = this.line.getChunkModel();
        if (chunkModel != null) {
            chunkModel.unregisterChunkListener((ChunkListener)this.chunkHandler);
        }
        super.dispose();
    }

    public EditorLine getEditorLine() {
        return this.editorLine;
    }

    public double getMaxPointDistance() {
        return this.maxPointDistance;
    }

    public void setMaxPointDistance(double maxPointDistance) {
        this.maxPointDistance = maxPointDistance;
    }

    public double getMinPointDistMillis() {
        return this.minPointDistMillis;
    }

    public void setMinPointDistMillis(double minPointDistMillis) {
        this.minPointDistMillis = minPointDistMillis;
    }

    protected double getPositionForLocation(int x, int y) {
        ScrollPos vp;
        double viewX = 0.0;
        double viewY = 0.0;
        ScrollView scrollView = this.getScrollView();
        if (scrollView != null && (vp = scrollView.getPosition()) != null) {
            viewX = vp.x;
            viewY = vp.y;
        }
        switch (this.getOrientation()) {
            case 0: {
                return (viewX + (double)x) * 1000.0 / this.zoomRate;
            }
            case 2: {
                return (viewY + (double)y) * 1000.0 / this.zoomRate;
            }
        }
        return 0.0;
    }

    protected double getValueForLocation(int x, int y) {
        ScrollPos vp;
        double viewX = 0.0;
        double viewY = 0.0;
        ScrollView scrollView = this.getScrollView();
        if (scrollView != null && (vp = scrollView.getPosition()) != null) {
            viewX = vp.x;
            viewY = vp.y;
        }
        double timePerUnit = 1000.0 / this.zoomRate;
        switch (this.getOrientation()) {
            case 0: {
                if (this.isInvertedDirection()) {
                    return (viewY + (double)y - 1.048576E7) * timePerUnit;
                }
                return (1.048576E7 - (viewY + (double)y)) * timePerUnit;
            }
            case 2: {
                if (this.isInvertedDirection()) {
                    return (viewX + (double)x - 1.048576E7) * timePerUnit;
                }
                return (1.048576E7 - (viewX + (double)x)) * timePerUnit;
            }
        }
        return 0.0;
    }

    protected WaxEditorModel getWaxEditorModel(double pos, double val) {
        DefaultWaxEditorLineView view = this.editorView;
        if (view == null) {
            return null;
        }
        WaxEditorModel best = null;
        double bestStart = 0.0;
        int num = view.getWaxEditorModelCount();
        for (int i = 0; i < num; ++i) {
            WaxEditorModel wem = view.getWaxEditorModelAt(i);
            double startTime = wem.getStartTime();
            if (startTime > pos || best != null && !(startTime > bestStart)) continue;
            best = wem;
            bestStart = startTime;
        }
        return best;
    }

    protected WaxEditorItem getScratchEditorModelRef(double pos, double val) throws IOException {
        DefaultWaxEditorLineView view = this.editorView;
        if (view == null) {
            return null;
        }
        int num = view.getWaxEditorModelCount();
        WaxEditorItem bestItem = null;
        double bestDist = 0.0;
        for (int k = 0; k < num; ++k) {
            WaxEditorModel wem = view.getWaxEditorModelAt(k);
            double wemStart = wem.getStartTime();
            int itemCount = wem.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                double itmStartTime;
                double framePos;
                TimecodeModel itm;
                WaxEditorItem item = wem.getItemAt(j);
                ScratchEditorModel sem = item.getModel();
                double start = wemStart + item.getStartTime();
                double tlen = sem.getTimeLength();
                if (!(pos >= start) || !(pos < start + tlen) || (itm = view.getInterpolatedTimecodeModel(item)) == null || !((framePos = (pos - (itmStartTime = 0.0)) * (double)itm.getFrameRate() / 1000.0) >= 0.0) || !(framePos < (double)itm.getFrameLength())) continue;
                double[] dst = new double[1];
                itm.getValues(framePos, 1.0, dst, 0, 1);
                double timePerUnit = 1000.0 / this.zoomRate;
                double dist = Math.abs(dst[0] - val) / timePerUnit;
                if (bestItem != null && !(dist < bestDist)) continue;
                bestItem = item;
                bestDist = dist;
            }
        }
        if (bestItem != null && bestDist <= this.maxModelDistance) {
            return bestItem;
        }
        return null;
    }

    protected TimecodePoint getTimecodePoint(double pos, double val) {
        double millisPerUnit;
        double timePerUnit = millisPerUnit = 1000.0 / this.zoomRate;
        DefaultWaxEditorLineView view = this.editorView;
        int num = view == null ? 0 : view.getWaxEditorModelCount();
        for (int k = 0; k < num; ++k) {
            WaxEditorModel wem = view.getWaxEditorModelAt(k);
            int itemCount = wem.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                double dist;
                double v;
                double o;
                int idx;
                int i;
                WaxEditorItem item = wem.getItemAt(j);
                ScratchEditorModel model = item.getModel();
                int size = model.getTimecodePointCount();
                double relOfs = pos - item.getStartTime() - wem.getStartTime();
                double relVal = val - item.getStartValue();
                int bestIndex = -1;
                double a = relOfs / millisPerUnit;
                double b = relVal / timePerUnit;
                double bestDist = Math.sqrt(a * a + b * b);
                for (i = idx = model.getTimecodePointIndexFor(relOfs); i < size; ++i) {
                    o = model.getTimecodePointOffsetAt(i);
                    v = model.getTimecodePointValueAt(i);
                    a = Math.abs(relOfs - o) / millisPerUnit;
                    if (a > this.maxPointDistance) break;
                    b = Math.abs(relVal - v) / timePerUnit;
                    dist = Math.sqrt(a * a + b * b);
                    if (bestIndex >= 0 && !(dist < bestDist)) continue;
                    bestIndex = i;
                    bestDist = dist;
                }
                for (i = idx - 1; i >= 0; --i) {
                    o = model.getTimecodePointOffsetAt(i);
                    v = model.getTimecodePointValueAt(i);
                    a = Math.abs(relOfs - o) / millisPerUnit;
                    if (a > this.maxPointDistance) break;
                    b = Math.abs(relVal - v) / timePerUnit;
                    dist = Math.sqrt(a * a + b * b);
                    if (bestIndex >= 0 && !(dist < bestDist)) continue;
                    bestIndex = i;
                    bestDist = dist;
                }
                if (!(bestDist <= this.maxPointDistance)) continue;
                return new TimecodePoint(item, bestIndex);
            }
        }
        return null;
    }

    protected TimecodePoint putTimecodePoint(double pos, double val) {
        double rel;
        ScratchEditorModel model;
        WaxEditorItem item;
        WaxEditorModel wem;
        DefaultWaxEditorLineView view = this.editorView;
        WaxEditorItem prevItem = null;
        double prevStart = 0.0;
        double prevEnd = 0.0;
        WaxEditorItem nextItem = null;
        double nextStart = 0.0;
        int num = view.getWaxEditorModelCount();
        block0: for (int k = 0; k < num; ++k) {
            wem = view.getWaxEditorModelAt(k);
            double wemStart = wem.getStartTime();
            int itemCount = wem.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                item = wem.getItemAt(j);
                model = item.getModel();
                double start = wemStart + item.getStartTime();
                if (pos < start) {
                    if (nextItem != null && !(start < nextStart)) continue;
                    nextItem = item;
                    nextStart = start;
                    continue;
                }
                double end = start + model.getTimeLength();
                if (pos >= end) {
                    if (prevItem != null && !(end > prevEnd)) continue;
                    prevItem = item;
                    prevStart = start;
                    prevEnd = end;
                    continue;
                }
                if (!item.isEditable()) {
                    return null;
                }
                rel = pos - start;
                if (rel <= 0.0) {
                    prevItem = null;
                    nextItem = item;
                    continue block0;
                }
                double rv = val - item.getStartValue();
                Double oldValue = null;
                if (model.containsTimecodePoint(rel)) {
                    oldValue = Data.toDouble((double)model.getTimecodePoint(rel));
                }
                int index = model.putTimecodePoint(rel, rv);
                UndoManager undoManager = this.getUndoManager();
                if (undoManager != null) {
                    undoManager.addEdit(new PutTimecodePointEdit(model, rel, rv, oldValue));
                }
                return new TimecodePoint(item, index);
            }
        }
        if (prevItem != null && !prevItem.isEditable()) {
            prevItem = null;
        }
        if (nextItem != null && !nextItem.isEditable()) {
            nextItem = null;
        }
        if (prevItem != null && nextItem != null) {
            if (pos - prevEnd < nextStart - pos) {
                nextItem = null;
            } else {
                prevItem = null;
            }
        }
        if (prevItem == null && nextItem == null) {
            AbstractWaxLabPanel wlp = this.panel.getWaxLabPanel();
            wem = new DefaultWaxEditorModel();
            model = new DefaultScratchEditorModel();
            item = new DefaultWaxEditorItem(model);
            item.setAutoConnect(true);
            item.setStartTime(0.0);
            item.setStartValue(0.0);
            wem.addItem(item);
            this.editorLine.getMutableChunkModel().addChunk((LineChunk)wem);
            prevItem = item;
        }
        if (prevItem != null) {
            item = prevItem;
            model = item.getModel();
            rel = pos - prevStart;
            double rv = val - item.getStartValue();
            Double oldValue = null;
            if (model.containsTimecodePoint(rel)) {
                oldValue = Data.toDouble((double)model.getTimecodePoint(rel));
            }
            int index = model.putTimecodePoint(rel, rv);
            UndoManager undoManager = this.getUndoManager();
            if (undoManager != null) {
                undoManager.addEdit(new PutTimecodePointEdit(model, rel, rv, oldValue));
            }
            return new TimecodePoint(prevItem, index);
        }
        if (nextItem != null) {
            item = nextItem;
            model = item.getModel();
            rel = nextStart - pos;
            double rv = item.getStartValue() - val;
            WaxEditorItem[] items = this.getWaxEditorItems(model);
            EditorLineWrapper.putTimecodeStartPoint(model, items, rel, rv);
            UndoManager undoManager = this.getUndoManager();
            if (undoManager != null) {
                undoManager.addEdit(new PutTimecodeStartPointEdit(model, items, rel, rv));
            }
            return new TimecodePoint(nextItem, -1);
        }
        return null;
    }

    protected FaderPoint getFaderPoint(double pos, double val) {
        double millisPerUnit;
        double timePerUnit = millisPerUnit = 1000.0 / this.zoomRate;
        int num = this.editorView.getFaderPointCount();
        FaderPoint bestPoint = null;
        double bestDist = 0.0;
        for (int i = 0; i < num; ++i) {
            double b;
            FaderPoint fp = this.editorView.getFaderPointAt(i);
            double a = Math.abs(fp.getPointTime() - pos) / millisPerUnit;
            if (a > this.maxPointDistance || (b = Math.abs(fp.getPointValue() - val) / timePerUnit) > this.maxPointDistance) continue;
            double dist = Math.sqrt(a * a + b * b);
            if (bestPoint != null && !(dist < bestDist)) continue;
            bestPoint = fp;
            bestDist = dist;
        }
        if (bestDist <= this.maxPointDistance) {
            return bestPoint;
        }
        return null;
    }

    protected FaderMovePoint putFaderMove(double pos, double val, FaderMove move) {
        double rel;
        double start;
        ScratchEditorModel model;
        WaxEditorItem item;
        WaxEditorModel wem;
        DefaultWaxEditorLineView view = this.editorView;
        int num = view.getWaxEditorModelCount();
        WaxEditorItem prevItem = null;
        double prevEnd = 0.0;
        WaxEditorItem nextItem = null;
        double nextStart = 0.0;
        block0: for (int k = 0; k < num; ++k) {
            wem = view.getWaxEditorModelAt(k);
            int itemCount = wem.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                item = wem.getItemAt(j);
                model = item.getModel();
                start = wem.getStartTime() + item.getStartTime();
                if (pos < start) {
                    if (nextItem != null && !(start < nextStart)) continue;
                    nextItem = item;
                    nextStart = start;
                    continue;
                }
                double end = start + model.getTimeLength();
                if (pos >= end) {
                    if (prevItem != null && !(end > prevEnd)) continue;
                    prevItem = item;
                    prevEnd = end;
                    continue;
                }
                if (!item.isEditable()) {
                    return null;
                }
                rel = pos - start;
                if (rel <= 0.0) {
                    prevItem = null;
                    nextItem = item;
                    continue block0;
                }
                FaderMove oldValue = model.getFaderMove(rel);
                int index = model.putFaderMove(rel, move);
                UndoManager undoManager = this.getUndoManager();
                if (undoManager != null) {
                    undoManager.addEdit(new PutFaderMoveEdit(wem, model, rel, move, oldValue));
                }
                wem.setDirty(true);
                return new FaderMovePoint(item, index);
            }
        }
        if (prevItem != null && !prevItem.isEditable()) {
            prevItem = null;
        }
        if (nextItem != null && !nextItem.isEditable()) {
            nextItem = null;
        }
        if (prevItem != null && nextItem != null) {
            if (pos - prevEnd < nextStart - pos) {
                nextItem = null;
            } else {
                prevItem = null;
            }
        }
        if (prevItem != null) {
            item = prevItem;
            wem = item.getParent();
            model = item.getModel();
            start = wem.getStartTime() + item.getStartTime();
            rel = pos - start;
            FaderMove oldValue = model.getFaderMove(rel);
            int index = model.putFaderMove(rel, move);
            UndoManager undoManager = this.getUndoManager();
            if (undoManager != null) {
                undoManager.addEdit(new PutFaderMoveEdit(wem, model, rel, move, oldValue));
            }
            wem.setDirty(true);
            return new FaderMovePoint(item, index);
        }
        if (nextItem != null) {
            item = nextItem;
            wem = item.getParent();
            model = item.getModel();
            start = wem.getStartTime() + item.getStartTime();
            double d = start - pos;
        }
        logger.info("FIXME putFaderMove: pos=" + pos + ", val=" + val + ", move=" + move);
        return null;
    }

    protected void handleMousePressed(MouseEvent ev) {
        this.pressed = true;
        int x = this.getRelativeX(ev.getX());
        int y = this.getRelativeY(ev.getY());
        double pos = this.getPositionForLocation(x, y);
        double val = this.getValueForLocation(x, y);
        if (!this.dragging) {
            this.anchorX = x;
            this.anchorY = y;
            this.anchorPos = pos;
            this.anchorVal = val;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("mousePressed: x=" + x + ", y=" + y + ", pos=" + pos + ", val=" + val);
        }
        if (!this.hideTimecodePoints) {
            TimecodePoint tp = this.getTimecodePoint(pos, val);
            if (tp != null && tp.item.isEditable()) {
                WaxEditorItem item = tp.item;
                int index = tp.index;
                if (ev.isControlDown()) {
                    if (!this.editorView.isTimecodePointSelected(item, index)) {
                        this.editorView.selectTimecodePoint(item, index);
                    } else {
                        this.editorView.deselectTimecodePoint(item, index);
                    }
                } else if (!ev.isShiftDown() && !this.editorView.isTimecodePointSelected(item, index)) {
                    this.editorView.deselectAllTimecodePoints();
                    this.editorView.selectTimecodePoint(item, index);
                }
                this.editorView.deselectAllWaxEditorItems();
                this.editorView.deselectAllFaderPoints();
                this.editorView.refresh();
                ev.consume();
            } else if (ev.getClickCount() >= 2 && ev.getClickCount() % 2 == 0) {
                tp = this.putTimecodePoint(pos, val);
                if (tp != null) {
                    WaxEditorItem item = tp.item;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("point added: pos=" + pos + ", val=" + val + ", point=" + tp);
                    }
                    this.editorView.deselectAllWaxEditorItems();
                    this.editorView.deselectAllFaderPoints();
                    this.editorView.refresh();
                    if (ev.isControlDown()) {
                        int[] sel = this.editorView.getSelectedTimecodePoints(item);
                        for (int i = sel.length - 1; i >= 0; --i) {
                            if (sel[i] < tp.index) continue;
                            this.editorView.deselectTimecodePoint(item, sel[i]);
                            this.editorView.selectTimecodePoint(item, sel[i] + 1);
                        }
                    } else {
                        this.editorView.deselectAllTimecodePoints();
                    }
                    this.editorView.selectTimecodePoint(item, tp.index);
                    WaxEditorModel wem = item.getParent();
                    if (wem != null) {
                        wem.setDirty(true);
                    }
                    ev.consume();
                    this.validate();
                }
            } else if (!ev.isControlDown() && !ev.isShiftDown()) {
                this.editorView.deselectAllTimecodePoints();
            }
        }
        if (!ev.isConsumed() && !this.hideFaderPoints) {
            FaderPoint fp = this.getFaderPoint(pos, val);
            if (fp != null) {
                this.editorView.deselectAllWaxEditorItems();
                this.editorView.deselectAllTimecodePoints();
                if (ev.isControlDown()) {
                    if (this.editorView.isFaderPointSelected(fp)) {
                        this.editorView.deselectFaderPoint(fp);
                    } else {
                        this.editorView.selectFaderPoint(fp);
                    }
                } else if (!this.editorView.isFaderPointSelected(fp)) {
                    this.editorView.deselectAllFaderPoints();
                    this.editorView.selectFaderPoint(fp);
                }
                this.editorView.refresh();
                ev.consume();
            } else if (!ev.isControlDown() && !ev.isShiftDown()) {
                this.editorView.deselectAllFaderPoints();
            }
        }
        if (!ev.isConsumed()) {
            try {
                WaxEditorItem tem = this.getScratchEditorModelRef(pos, val);
                if (tem != null) {
                    this.editorView.deselectAllTimecodePoints();
                    this.editorView.deselectAllFaderPoints();
                    if (ev.isControlDown()) {
                        if (this.editorView.isWaxEditorItemSelected(tem)) {
                            this.editorView.deselectWaxEditorItem(tem);
                        } else {
                            this.editorView.selectWaxEditorItem(tem);
                        }
                        this.editorView.refresh();
                    } else if (!this.editorView.isWaxEditorItemSelected(tem)) {
                        this.editorView.deselectAllWaxEditorItems();
                        this.editorView.selectWaxEditorItem(tem);
                        this.editorView.refresh();
                    }
                } else if (!ev.isControlDown() && !ev.isShiftDown()) {
                    this.editorView.deselectAllWaxEditorItems();
                    this.editorView.refresh();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.repaint();
    }

    protected void handleMouseReleased(MouseEvent ev) {
        this.pressed = false;
        if (this.dragging) {
            UndoManager undoManager = this.getUndoManager();
            if (undoManager != null) {
                if (this.dragItems == null) {
                    undoManager.addEdit(new MoveTimecodePointsEdit(this.dragPointsOld, this.dragPointsNew, this.dragItemMap));
                } else {
                    CompoundEdit edit = new CompoundEdit();
                    for (DragItem dm : this.dragItems) {
                        WaxEditorItem item = dm.item;
                        double oldStartTime = dm.startTime;
                        double oldStartValue = dm.startValue;
                        double newStartTime = item.getStartTime();
                        double newStartValue = item.getStartValue();
                        edit.addEdit(new MoveItemEdit(item, oldStartTime, oldStartValue, newStartTime, newStartValue));
                    }
                    edit.end();
                    undoManager.addEdit(edit);
                }
            }
            this.dragging = false;
            this.dragPointsOld = null;
            this.dragPointsNew = null;
            this.dragItemMap = null;
            this.dragItems = null;
            this.dragFaderMoves = null;
            ev.consume();
            return;
        }
    }

    protected void handleMouseClicked(MouseEvent ev) {
    }

    protected void handleMouseEntered(MouseEvent ev) {
    }

    protected void handleMouseExited(MouseEvent ev) {
    }

    protected void handleMouseMoved(MouseEvent ev) {
    }

    protected void handleMouseDragged(MouseEvent ev) {
        int x = this.getRelativeX(ev.getX());
        int y = this.getRelativeY(ev.getY());
        double pos = this.getPositionForLocation(x, y);
        double val = this.getValueForLocation(x, y);
        if (this.anchorX < 0 && this.anchorY < 0) {
            this.anchorX = x;
            this.anchorY = y;
            this.anchorPos = pos;
            this.anchorVal = val;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("mouseDragged: x=" + x + ", y=" + y + ", pos=" + pos + ", val=" + val);
        }
        if (!this.dragging && this.pressed) {
            FaderPoint fp;
            DragPoint[] points;
            WaxEditorItem item;
            TimecodePoint tp;
            if (!this.hideTimecodePoints && (tp = this.getTimecodePoint(this.anchorPos, this.anchorVal)) != null && this.editorView.isTimecodePointSelected(item = tp.item, tp.index) && (points = this.getUniqueSelectedPoints()) != null && points.length > 0) {
                int num = points.length;
                HashMap<ScratchEditorModel, WaxEditorItem[]> itemMap = new HashMap<ScratchEditorModel, WaxEditorItem[]>();
                DragPoint[] newPoints = new DragPoint[num];
                for (int i = 0; i < num; ++i) {
                    newPoints[i] = new DragPoint(points[i]);
                    ScratchEditorModel scratchEditorModel = newPoints[i].item.getModel();
                    if (itemMap.containsKey(scratchEditorModel)) continue;
                    WaxEditorItem[] items = this.getWaxEditorItems(scratchEditorModel);
                    itemMap.put(scratchEditorModel, items);
                }
                this.dragPointsOld = points;
                this.dragPointsNew = newPoints;
                this.dragItemMap = itemMap;
                this.dragging = true;
            }
            if (!this.dragging && !this.hideFaderPoints && (fp = this.getFaderPoint(this.anchorPos, this.anchorVal)) != null && this.editorView.isFaderPointSelected(fp)) {
                FaderPoint[] sel = this.editorView.getSelectedFaderPoints();
                int num = sel.length;
                this.dragFaderMoves = new DragFaderMove[num];
                for (int i = 0; i < num; ++i) {
                    this.dragFaderMoves[i] = new DragFaderMove(sel[i]);
                }
                this.dragging = true;
            }
            if (!this.dragging && this.anchorPos >= 0.0) {
                try {
                    WaxEditorItem item2 = this.getScratchEditorModelRef(this.anchorPos, this.anchorVal);
                    if (item2 != null) {
                        this.editorView.deselectAllTimecodePoints();
                        this.editorView.deselectAllFaderPoints();
                        this.editorView.selectWaxEditorItem(item2);
                        WaxEditorItem[] items = this.editorView.getSelectedWaxEditorItems();
                        int num = items.length;
                        DragItem[] dms = new DragItem[num];
                        for (int i = 0; i < num; ++i) {
                            item2 = items[i];
                            dms[i] = new DragItem(item2, item2.getStartTime(), item2.getStartValue());
                        }
                        this.dragItems = dms;
                        this.dragging = true;
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    this.pressed = false;
                }
            }
        }
        if (this.dragging) {
            WaxEditorItem item;
            double deltaOfs = pos - this.anchorPos;
            double deltaVal = val - this.anchorVal;
            if (this.dragFaderMoves != null) {
                WaxEditorModel wem;
                int num = this.dragFaderMoves.length;
                for (int i = 0; i < num; ++i) {
                    DragFaderMove dragFaderMove = this.dragFaderMoves[i];
                    item = dragFaderMove.newItem;
                    ScratchEditorModel sem = item.getModel();
                    sem.removeFaderMove(dragFaderMove.newOffset);
                    dragFaderMove.newOffset = dragFaderMove.oldOffset + deltaOfs;
                    if (dragFaderMove.newOffset > sem.getTimeLength() - dragFaderMove.faderMove.getTimeLength()) {
                        dragFaderMove.newOffset = sem.getTimeLength() - dragFaderMove.faderMove.getTimeLength();
                    }
                    if (dragFaderMove.newOffset < this.minFaderPointOffset) {
                        dragFaderMove.newOffset = this.minFaderPointOffset;
                    }
                    sem.putFaderMove(dragFaderMove.newOffset, dragFaderMove.faderMove);
                    wem = item.getParent();
                    if (wem == null) continue;
                    wem.setDirty(true);
                }
                this.editorView.refresh();
                this.editorView.deselectAllFaderPoints();
                for (int i = 0; i < num; ++i) {
                    DragFaderMove dragFaderMove = this.dragFaderMoves[i];
                    item = dragFaderMove.newItem;
                    ScratchEditorModel sem = item.getModel();
                    wem = item.getParent();
                    double startTime = wem.getStartTime() + item.getStartTime() + dragFaderMove.newOffset;
                    FaderPoint fp = this.editorView.getFaderPoint(startTime);
                    if (fp == null) continue;
                    this.editorView.selectFaderPoint(fp);
                }
            } else if (this.dragItems == null) {
                int num = this.dragPointsOld.length;
                DragPoint[] dragPointArray = new DragPoint[num];
                EditorLineWrapper.movePoints(this.dragPointsOld, this.dragPointsNew, dragPointArray, deltaOfs, deltaVal, this.dragItemMap, this.minPointDistMillis);
                this.dragPointsNew = dragPointArray;
                this.selectPoints(this.dragPointsNew);
                this.editorView.refresh();
            } else {
                for (DragItem dragItem : this.dragItems) {
                    item = dragItem.item;
                    item.setStartTime(dragItem.startTime + deltaOfs);
                    item.setStartValue(dragItem.startValue + deltaVal);
                    WaxEditorModel wem = item.getParent();
                    if (wem == null) continue;
                    wem.setDirty(true);
                }
                this.editorView.refresh();
            }
            ev.consume();
            this.validate();
            this.repaint();
        }
    }

    protected static void movePoints(DragPoint[] dragPointsOld, DragPoint[] dragPointsNew, DragPoint[] arr, double deltaOfs, double deltaVal, Map itemMap, double minPointDistMillis) {
        AffectedStartPoint af;
        ScratchEditorModel sem;
        WaxEditorItem item;
        DragPoint np;
        int i;
        HashMap<ScratchEditorModel, AffectedStartPoint> affectedStartPoints = null;
        int num = dragPointsOld.length;
        for (i = 0; i < num; ++i) {
            np = new DragPoint(dragPointsOld[i]);
            np.offset += deltaOfs;
            np.value += deltaVal;
            arr[i] = np;
            if (np.offset <= 0.0) {
                if (np.offset == 0.0) {
                    np.offset -= minPointDistMillis;
                }
                item = np.item;
                sem = item.getModel();
                if (affectedStartPoints == null) {
                    affectedStartPoints = new HashMap<ScratchEditorModel, AffectedStartPoint>();
                    af = null;
                } else {
                    af = (AffectedStartPoint)affectedStartPoints.get(sem);
                }
                if (af == null) {
                    af = new AffectedStartPoint(sem, dragPointsNew[i], np);
                    affectedStartPoints.put(sem, af);
                    continue;
                }
                if (np.offset < af.point.offset) {
                    af.current = dragPointsNew[i];
                    af.point = np;
                    continue;
                }
            }
            if (!(dragPointsNew[i].offset <= 0.0)) continue;
            item = np.item;
            sem = item.getModel();
            if (affectedStartPoints == null) {
                affectedStartPoints = new HashMap();
                af = null;
            } else {
                af = (AffectedStartPoint)affectedStartPoints.get(sem);
            }
            if (af == null) {
                af = new AffectedStartPoint(sem, dragPointsNew[i], np);
                affectedStartPoints.put(sem, af);
                continue;
            }
            if (!(np.offset < af.point.offset)) continue;
            af.current = dragPointsNew[i];
            af.point = np;
        }
        if (affectedStartPoints != null) {
            for (Map.Entry me : affectedStartPoints.entrySet()) {
                WaxEditorItem[] items;
                int k;
                sem = (ScratchEditorModel)me.getKey();
                af = (AffectedStartPoint)me.getValue();
                np = af.point;
                double o = np.offset;
                double v = np.value;
                int size = sem.getTimecodePointCount();
                if (size > 0) {
                    double[] px = new double[size];
                    sem.getTimecodePointOffsets(0, px, 0, size);
                    double[] py = new double[size];
                    sem.getTimecodePointValues(0, py, 0, size);
                    sem.removeAllTimecodePoints();
                    if (px[0] <= o) {
                        o = px[0];
                        v = py[0];
                        px[0] = 0.0;
                        py[0] = 0.0;
                    } else if (af.current.offset > 0.0) {
                        sem.putTimecodePoint(-o, -v);
                    }
                    for (k = 0; k < size; ++k) {
                        if (!(px[k] > o)) continue;
                        sem.putTimecodePoint(px[k] - o, py[k] - v);
                    }
                }
                if ((size = sem.getFaderMoveCount()) > 0) {
                    sem.moveFaderMoves(0, size, -o);
                }
                if ((items = (WaxEditorItem[])itemMap.get(sem)) != null) {
                    int itemCount = items.length;
                    for (k = 0; k < itemCount; ++k) {
                        items[k].setStartTime(items[k].getStartTime() + o);
                        items[k].setStartValue(items[k].getStartValue() + v);
                    }
                }
                for (int k2 = 0; k2 < num; ++k2) {
                    if (arr[k2].item.getModel() != sem) continue;
                    arr[k2].offset -= o;
                    arr[k2].value -= v;
                    dragPointsOld[k2].offset -= o;
                    dragPointsOld[k2].value -= v;
                    dragPointsNew[k2].offset -= o;
                    dragPointsNew[k2].value -= v;
                }
            }
        }
        for (i = 0; i < num; ++i) {
            np = dragPointsNew[i];
            if (!(np.offset > 0.0)) continue;
            item = np.item;
            sem = item.getModel();
            sem.removeTimecodePoint(np.offset);
            WaxEditorModel wem = item.getParent();
            if (wem == null) continue;
            wem.setDirty(true);
        }
        for (int i2 = 0; i2 < num; ++i2) {
            np = arr[i2];
            double ofs = np.offset;
            if (ofs <= 0.0) continue;
            item = np.item;
            sem = item.getModel();
            int idx = sem.getTimecodePointIndexFor(ofs);
            if (idx < sem.getTimecodePointCount() && sem.getTimecodePointOffsetAt(idx) - ofs < minPointDistMillis) {
                ofs = sem.getTimecodePointOffsetAt(idx) - minPointDistMillis;
            }
            if (idx > 0) {
                if (ofs - sem.getTimecodePointOffsetAt(idx - 1) < minPointDistMillis) {
                    ofs = sem.getTimecodePointOffsetAt(idx - 1) + minPointDistMillis;
                }
            } else if (ofs < minPointDistMillis) {
                ofs = minPointDistMillis;
            }
            np.offset = ofs;
            sem.putTimecodePoint(ofs, np.value);
            WaxEditorModel wem = item.getParent();
            if (wem == null) continue;
            wem.setDirty(true);
        }
    }

    protected void selectPoints(DragPoint[] p) {
        this.editorView.deselectAllTimecodePoints();
        for (DragPoint dp : p) {
            if (dp.offset > 0.0) {
                ScratchEditorModel model = dp.item.getModel();
                int index = model.getTimecodePointIndexFor(dp.offset);
                if (index < 0) continue;
                this.editorView.selectTimecodePoint(dp.item, index);
                continue;
            }
            this.editorView.selectTimecodePoint(dp.item, -1);
        }
    }

    protected void cancelDragging() {
        if (!this.dragging) {
            return;
        }
        if (this.dragItems == null) {
            MoveTimecodePointsEdit edit = new MoveTimecodePointsEdit(this.dragPointsOld, this.dragPointsNew, this.dragItemMap);
            edit.undo();
            this.selectPoints(this.dragPointsOld);
        } else {
            for (DragItem dm : this.dragItems) {
                WaxEditorItem item = dm.item;
                double oldStartTime = dm.startTime;
                double oldStartValue = dm.startValue;
                double newStartTime = item.getStartTime();
                double newStartValue = item.getStartValue();
                MoveItemEdit edit = new MoveItemEdit(item, oldStartTime, oldStartValue, newStartTime, newStartValue);
                edit.undo();
            }
        }
        this.pressed = false;
        this.dragging = false;
        this.dragPointsOld = null;
        this.dragPointsNew = null;
        this.dragItemMap = null;
        this.dragItems = null;
        this.dragFaderMoves = null;
        this.editorView.refresh();
        this.validate();
        this.repaint();
    }

    @Override
    protected void handleKeyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                if (e.isAltDown()) break;
                if (e.isControlDown()) {
                    e.consume();
                    this.startPointMoveTimer(-1, 0, true);
                }
                return;
            }
            case 39: {
                if (e.isAltDown()) break;
                if (e.isControlDown()) {
                    e.consume();
                    this.startPointMoveTimer(1, 0, true);
                }
                return;
            }
            case 38: {
                if (e.isAltDown()) break;
                if (e.isControlDown()) {
                    e.consume();
                    this.startPointMoveTimer(0, -1, true);
                }
                return;
            }
            case 40: {
                if (e.isAltDown()) break;
                if (e.isControlDown()) {
                    e.consume();
                    this.startPointMoveTimer(0, 1, true);
                }
                return;
            }
            case 65: {
                if (e.isControlDown()) {
                    this.selectAll();
                    e.consume();
                }
                return;
            }
            case 67: {
                if (e.isControlDown()) {
                    try {
                        this.copySelectedElements();
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    e.consume();
                }
                return;
            }
            case 75: {
                if (e.isControlDown()) {
                    try {
                        this.cloneSelectedElements();
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    e.consume();
                }
                return;
            }
            case 86: {
                if (e.isControlDown()) {
                    try {
                        this.pasteElements();
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    e.consume();
                }
                return;
            }
            case 88: {
                if (e.isControlDown()) {
                    try {
                        this.cutSelectedElements();
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    e.consume();
                }
                return;
            }
            case 90: {
                if (e.isControlDown()) {
                    UndoManager undoManager = this.getUndoManager();
                    if (undoManager != null && undoManager.canUndo()) {
                        undoManager.undo();
                        this.getPanel().requestViewFocus();
                    }
                    e.consume();
                }
                return;
            }
            case 89: {
                if (e.isControlDown()) {
                    UndoManager undoManager = this.getUndoManager();
                    if (undoManager != null && undoManager.canRedo()) {
                        undoManager.redo();
                        this.getPanel().requestViewFocus();
                    }
                    e.consume();
                }
                return;
            }
        }
        super.handleKeyPressed(e);
    }

    @Override
    protected void handleKeyReleased(KeyEvent e) {
        super.handleKeyReleased(e);
        switch (e.getKeyCode()) {
            case 37: {
                if (this.pointMoveIncrementX < 0) {
                    this.stopPointMoveTimer(true, false);
                }
                return;
            }
            case 39: {
                if (this.pointMoveIncrementX > 0) {
                    this.stopPointMoveTimer(true, false);
                }
                return;
            }
            case 38: {
                if (this.pointMoveIncrementY < 0) {
                    this.stopPointMoveTimer(false, true);
                }
                return;
            }
            case 40: {
                if (this.pointMoveIncrementY > 0) {
                    this.stopPointMoveTimer(false, true);
                }
                return;
            }
        }
    }

    @Override
    protected void handleKeyTyped(KeyEvent e) {
        char kc = e.getKeyChar();
        switch (kc) {
            case '\u007f': {
                this.deleteSelectedElements();
                e.consume();
                return;
            }
            case '\u001b': {
                if (this.dragging) {
                    this.cancelDragging();
                }
                e.consume();
                return;
            }
        }
        super.handleKeyTyped(e);
    }

    protected void startPointMoveTimer(int incrementX, int incrementY, boolean speedup) {
        if (this.pointMoveTimer.isRunning()) {
            boolean change = false;
            if (incrementX > 0 && incrementX > this.pointMoveIncrementX || incrementX < 0 && incrementX < this.pointMoveIncrementX) {
                change = true;
                this.pointMoveIncrementX = incrementX;
                this.pointMoveFactorX = 1;
            }
            if (incrementY > 0 && incrementY > this.pointMoveIncrementY || incrementY < 0 && incrementY < this.pointMoveIncrementY) {
                change = true;
                this.pointMoveIncrementY = incrementY;
                this.pointMoveFactorY = 1;
            }
            if (!change) {
                return;
            }
            this.pointMoveSpeedup = speedup;
            this.pointMoveCounter = 0;
            this.pointMover.actionPerformed(null);
            return;
        }
        this.pointMoveIncrementX = incrementX;
        this.pointMoveIncrementY = incrementY;
        this.pointMoveSpeedup = speedup;
        this.pointMoveCounter = 0;
        this.pointMoveFactorX = 1;
        this.pointMoveFactorY = 1;
        this.pointMover.actionPerformed(null);
        this.pointMoveTimer.setInitialDelay(this.pointMoveInitialDelay);
        this.pointMoveTimer.setDelay(this.pointMoveDelay);
        this.pointMoveTimer.start();
    }

    protected void stopPointMoveTimer(boolean stopX, boolean stopY) {
        if (stopX) {
            this.pointMoveIncrementX = 0;
        }
        if (stopY) {
            this.pointMoveIncrementY = 0;
        }
        if (this.pointMoveIncrementX == 0 && this.pointMoveIncrementY == 0) {
            this.pointMoveTimer.stop();
        }
    }

    public void deleteSelectedElements() {
        WaxEditorItem[] models;
        FaderPoint[] fps;
        ScratchEditorModel sem;
        WaxEditorItem item;
        double ofs;
        int i;
        UndoManager undoManager = this.getUndoManager();
        CompoundEdit edit = new CompoundEdit();
        DragPoint[] points = this.getUniqueSelectedPoints();
        boolean deleteStartPoints = false;
        int num = points == null ? 0 : points.length;
        for (i = 0; i < num; ++i) {
            ofs = points[i].offset;
            if (ofs > 0.0) {
                item = points[i].item;
                sem = item.getModel();
                double val = sem.removeTimecodePoint(ofs);
                if (undoManager == null) continue;
                edit.addEdit(new RemoveTimecodePointEdit(sem, ofs, val));
                continue;
            }
            deleteStartPoints = true;
        }
        if (deleteStartPoints) {
            for (i = 0; i < num; ++i) {
                ofs = points[i].offset;
                if (!(ofs <= 0.0)) continue;
                item = points[i].item;
                sem = item.getModel();
                WaxEditorModel parent = item.getParent();
                int size = sem.getTimecodePointCount();
                if (size > 0) {
                    ofs = sem.getTimecodePointOffsetAt(0);
                    double val = sem.getTimecodePointValueAt(0);
                    WaxEditorItem[] items = this.getWaxEditorItems(sem);
                    EditorLineWrapper.removeTimecodeStartPoint(sem, items, ofs, val);
                    if (undoManager == null) continue;
                    edit.addEdit(new RemoveTimecodeStartPointEdit(sem, items, ofs, val));
                    continue;
                }
                WaxEditorItem[] items = this.getWaxEditorItems(sem);
                for (int k = 0; k < items.length; ++k) {
                    item = items[k];
                    parent = item.getParent();
                    if (parent == null) continue;
                    parent.removeItem(item);
                    if (undoManager == null) continue;
                    edit.addEdit(new RemoveItemEdit(parent, item));
                }
            }
        }
        if ((fps = this.editorView.getSelectedFaderPoints()).length > 0) {
            this.editorView.deselectAllFaderPoints();
            for (int i2 = 0; i2 < fps.length; ++i2) {
                FaderPoint fp = fps[i2];
                item = fp.getWaxEditorItem();
                sem = item.getModel();
                FaderMove fm = sem.removeFaderMove(fp.getStartOffset());
                if (fm == null || undoManager == null) continue;
                edit.addEdit(new RemoveFaderMoveEdit(item.getParent(), sem, fp.getStartOffset(), fm));
            }
        }
        if ((models = this.editorView.getSelectedWaxEditorItems()).length > 0) {
            this.editorView.deselectAllWaxEditorItems();
            for (int i3 = 0; i3 < models.length; ++i3) {
                item = models[i3];
                WaxEditorModel wem = item.getParent();
                if (wem == null) continue;
                wem.removeItem(item);
                if (undoManager == null) continue;
                edit.addEdit(new RemoveItemEdit(wem, item));
            }
        }
        if (undoManager != null) {
            edit.end();
            undoManager.addEdit(edit);
        }
        this.editorView.deselectAllTimecodePoints();
        this.editorView.refresh();
        this.validate();
        this.repaint();
    }

    public void cloneSelectedElements() throws Exception {
        WaxEditorItem[] refs = this.editorView.getSelectedWaxEditorItems();
        if (refs.length < 1) {
            return;
        }
        ArrayList<CloningWaxEditorItem> beans = new ArrayList<CloningWaxEditorItem>(refs.length);
        for (int i = 0; i < refs.length; ++i) {
            WaxEditorItem ref = refs[i];
            if (ref == null) continue;
            beans.add(new CloningWaxEditorItem(ref));
        }
        this.getClipboardManager().setContents(beans, null, null);
        this.editorView.refresh();
        this.validate();
        this.repaint();
    }

    public void copySelectedElements() throws Exception {
        WaxEditorItem[] refs = this.editorView.getSelectedWaxEditorItems();
        if (refs.length < 1) {
            return;
        }
        ArrayList<WaxEditorItem> beans = new ArrayList<WaxEditorItem>(refs.length);
        for (int i = 0; i < refs.length; ++i) {
            WaxEditorItem copy;
            WaxEditorItem ref = refs[i];
            if (ref == null || (copy = ref.createCopy()) == null) continue;
            beans.add(copy);
        }
        this.getClipboardManager().setContents(beans, null, null);
        this.editorView.refresh();
        this.validate();
        this.repaint();
    }

    public void cutSelectedElements() {
        WaxEditorItem[] refs = this.editorView.getSelectedWaxEditorItems();
        if (refs.length < 1) {
            this.splitScratchEditorModels();
            return;
        }
        ArrayList<WaxEditorItem> beans = new ArrayList<WaxEditorItem>(refs.length);
        for (int i = 0; i < refs.length; ++i) {
            WaxEditorItem ref = refs[i];
            beans.add(ref);
        }
        this.getClipboardManager().setContents(beans, null, null);
        this.deleteSelectedElements();
    }

    public void pasteElements() throws Exception {
        ClipboardManager clip = this.getClipboardManager();
        if (clip == null) {
            return;
        }
        Collection objects = clip.getObjects();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pasteElements: " + objects);
        }
        if (objects == null) {
            return;
        }
        if (objects.isEmpty()) {
            return;
        }
        Line studioLine = this.getLine();
        if (studioLine == null || !(studioLine instanceof EditorLine)) {
            return;
        }
        EditorLine editorLine = (EditorLine)studioLine;
        WaxEditorModel parent = this.getWaxEditorModel(this.anchorPos, this.anchorVal);
        double startTime = this.anchorPos - parent.getStartTime();
        double startValue = this.anchorVal;
        for (Object obj : objects) {
            if (obj == null) continue;
            if (obj instanceof WaxEditorModel) {
                WaxEditorModel wem = (WaxEditorModel)obj;
                editorLine.getMutableChunkModel().addChunk((LineChunk)wem);
                UndoManager undoManager = this.getUndoManager();
                if (undoManager == null) continue;
                continue;
            }
            if (obj instanceof WaxEditorItem) {
                WaxEditorItem theItem;
                WaxEditorItem itemObj = (WaxEditorItem)obj;
                if (itemObj instanceof CloningWaxEditorItem) {
                    CloningWaxEditorItem cloning = (CloningWaxEditorItem)itemObj;
                    WaxEditorItem orig = cloning.getItem();
                    if (orig == null) continue;
                    theItem = orig.createClone();
                } else {
                    theItem = itemObj.getParent() == null ? itemObj : itemObj.createCopy();
                }
                if (theItem == null) continue;
                theItem.setStartTime(startTime);
                theItem.setStartValue(startValue);
                parent.addItem(theItem);
                UndoManager undoManager = this.getUndoManager();
                if (undoManager == null) continue;
                undoManager.addEdit(new AddItemEdit(parent, theItem));
                continue;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Unsupported object: " + obj.getClass() + " => " + obj.toString());
        }
        this.editorView.refresh();
        this.validate();
        this.repaint();
    }

    protected FaderClick createFaderClick() {
        DefaultFaderClick move = new DefaultFaderClick();
        move.setAttackDuration(20.0);
        move.setPeakValue(0.0f);
        move.setReleaseDuration(20.0);
        move.setTargetValue(1.0f);
        move.setTimeLength(100.0);
        return move;
    }

    public void insertFaderClick() {
        double pos = this.anchorPos;
        double val = this.anchorVal;
        FaderClick move = this.createFaderClick();
        FaderMovePoint point = this.putFaderMove(pos -= move.getAttackDuration() + (move.getTimeLength() - move.getAttackDuration() - move.getReleaseDuration()) / 2.0, val, (FaderMove)move);
        if (point == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("FaderMove inserted: pos=" + pos + ", val=" + val + ", move=" + move);
        }
        this.editorView.deselectAllWaxEditorItems();
        this.editorView.deselectAllTimecodePoints();
        this.editorView.refresh();
        this.editorView.deselectAllTimecodePoints();
        WaxEditorItem item = point.item;
        WaxEditorModel wem = item.getParent();
        ScratchEditorModel sem = item.getModel();
        double startTime = wem.getStartTime() + item.getStartTime() + sem.getFaderMoveOffsetAt(point.index);
        FaderPoint fp = this.editorView.getFaderPoint(startTime);
        if (fp != null) {
            this.editorView.selectFaderPoint(fp);
        }
        this.validate();
        this.repaint();
    }

    public void insertTimecodePoint() {
        double pos = this.anchorPos;
        double val = this.anchorVal;
        TimecodePoint tp = this.putTimecodePoint(pos, val);
        if (tp == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("point inserted: pos=" + pos + ", val=" + val + ", point=" + tp);
        }
        this.editorView.deselectAllWaxEditorItems();
        this.editorView.refresh();
        this.editorView.deselectAllTimecodePoints();
        this.editorView.selectTimecodePoint(tp.item, tp.index);
        this.validate();
        this.repaint();
    }

    public void showInsertScratchPatternDialog() {
        WaxEditorItem item;
        WaxEditorItem[] selItems;
        WaxEditorModel parent = null;
        WaxEditorItem targetItem = null;
        double startTime = 0.0;
        double startValue = 0.0;
        if (this.editorView.getSelectedWaxEditorItemCount() == 1 && (selItems = this.editorView.getSelectedWaxEditorItems()) != null && selItems.length == 1 && (item = selItems[0]) != null) {
            parent = item.getParent();
            ScratchEditorModel model = item.getModel();
            if (parent != null && model != null) {
                double itemEndTime;
                targetItem = item;
                startTime = itemEndTime = item.getStartTime() + model.getTimeLength();
                startValue = item.getStartValue();
                int num = model.getTimecodePointCount();
                if (num > 0) {
                    startValue += model.getTimecodePointValueAt(num - 1);
                }
            }
        }
        if (parent == null) {
            parent = this.getWaxEditorModel(this.anchorPos, this.anchorVal);
            startTime = this.anchorPos - parent.getStartTime();
            startValue = this.anchorVal;
        }
        if (parent == null) {
            return;
        }
        if (this.scratchGeneratorDialog == null) {
            this.scratchGeneratorPanel = new ScratchGeneratorPanel();
            this.scratchGeneratorPanel.setEditorLineWrapper(this);
            LinkedList<ScratchPattern> scratchPatternList = new LinkedList<ScratchPattern>();
            ScratchPatternProvider[] providers = this.getPanel().getScratchPatternProviders();
            if (providers != null) {
                for (int i = 0; i < providers.length; ++i) {
                    ScratchPattern[] patterns;
                    ScratchPatternProvider provider = providers[i];
                    if (provider == null || (patterns = provider.getScratchPatterns()) == null) continue;
                    for (int k = 0; k < patterns.length; ++k) {
                        ScratchPattern pattern = patterns[k];
                        if (pattern == null) continue;
                        scratchPatternList.add(pattern);
                    }
                }
            }
            ScratchPattern[] scratchPatterns = scratchPatternList.toArray(new ScratchPattern[scratchPatternList.size()]);
            this.scratchGeneratorPanel.setScratchPatterns(scratchPatterns);
            Window window = SwingUtilities.getWindowAncestor(this.getPanel());
            JDialog dialog = window != null && window instanceof JFrame ? new JDialog((JFrame)window) : new JDialog();
            this.scratchGeneratorDialog = dialog;
            this.scratchGeneratorDialog.setModal(false);
            this.scratchGeneratorPanel.setDialog(this.scratchGeneratorDialog);
            this.scratchGeneratorPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel contentPane = new JPanel();
            contentPane.setLayout(new GridLayout(1, 1));
            contentPane.add(this.scratchGeneratorPanel);
            this.scratchGeneratorDialog.setTitle("Scratch Generator");
            this.scratchGeneratorDialog.setContentPane(contentPane);
            this.scratchGeneratorDialog.pack();
            Tools.centerWindow((Component)this.getPanel(), (Window)this.scratchGeneratorDialog);
        }
        this.scratchGeneratorPanel.setTargetWaxEditorModel(parent);
        this.scratchGeneratorPanel.setTargetWaxEditorItem(targetItem);
        this.scratchGeneratorPanel.setInsertTimePosition(startTime);
        this.scratchGeneratorPanel.setInsertNeedlePosition(startValue);
        if (this.scratchGeneratorDialog.isVisible()) {
            this.scratchGeneratorDialog.toFront();
        } else {
            this.scratchGeneratorDialog.setVisible(true);
        }
    }

    public boolean insertWaxEditorItem(WaxEditorItem item, WaxEditorModel target) {
        if (item == null || target == null) {
            return false;
        }
        if (item.getParent() != null) {
            return false;
        }
        target.addItem(item);
        UndoManager undoManager = this.getUndoManager();
        if (undoManager != null) {
            undoManager.addEdit(new AddItemEdit(target, item));
        }
        if (this.editorView != null) {
            this.editorView.deselectAllWaxEditorItems();
            this.editorView.selectWaxEditorItem(item);
        }
        this.validate();
        this.repaint();
        return true;
    }

    public boolean appendScratchEditorModel(WaxEditorItem item, ScratchEditorModel model) {
        WaxEditorModel wem;
        FaderMove oldValue;
        if (item == null || model == null) {
            return false;
        }
        ScratchEditorModel sem = item.getModel();
        if (sem == null) {
            return false;
        }
        double insertOffset = sem.getTimeLength();
        double insertValue = 0.0;
        int num = sem.getTimecodePointCount();
        if (num > 0) {
            insertValue = sem.getTimecodePointValueAt(num - 1);
        }
        CompoundEdit edit = new CompoundEdit();
        int tn = model.getTimecodePointCount();
        for (int i = 0; i < tn; ++i) {
            double offset = insertOffset + model.getTimecodePointOffsetAt(i);
            double value = insertValue + model.getTimecodePointValueAt(i);
            oldValue = null;
            sem.putTimecodePoint(offset, value);
            edit.addEdit(new PutTimecodePointEdit(sem, offset, value, (Double)oldValue));
        }
        int fn = model.getFaderMoveCount();
        for (int i = 0; i < fn; ++i) {
            double offset = insertOffset + model.getFaderMoveOffsetAt(i);
            FaderMove value = model.getFaderMoveAt(i);
            oldValue = null;
            sem.putFaderMove(offset, value);
            edit.addEdit(new PutFaderMoveEdit(item.getParent(), sem, offset, value, oldValue));
        }
        edit.end();
        UndoManager undoManager = this.getUndoManager();
        if (undoManager != null) {
            undoManager.addEdit(edit);
        }
        if ((wem = item.getParent()) != null) {
            wem.itemChanged(item);
        }
        this.validate();
        this.repaint();
        return true;
    }

    public void splitScratchEditorModels() {
        DragPoint[] points = this.getUniqueSelectedPoints();
        if (points == null || points.length < 1) {
            return;
        }
        HashMap<ScratchEditorModel, TreeSet<Integer>> map = new HashMap<ScratchEditorModel, TreeSet<Integer>>();
        for (int i = 0; i < points.length; ++i) {
            WaxEditorItem item = points[i].item;
            ScratchEditorModel model = item.getModel();
            double offset = points[i].offset;
            if (offset <= 0.0) continue;
            int size = model.getTimecodePointCount();
            int index = model.getTimecodePointIndexFor(offset);
            if (index < 0 || index + 1 >= size) continue;
            double check = model.getTimecodePointOffsetAt(index);
            if (check != offset) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("Unexpected point offset: " + check + " != " + offset);
                continue;
            }
            TreeSet<Integer> set = (TreeSet<Integer>)map.get(model);
            if (set == null) {
                set = new TreeSet<Integer>();
                map.put(model, set);
            }
            set.add(Data.toInteger((int)index));
        }
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry me : map.entrySet()) {
            ScratchEditorModel sem = (ScratchEditorModel)me.getKey();
            Set set = (Set)me.getValue();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Split: model=" + sem + ", indices=" + set);
            }
            Integer[] indexes = set.toArray(new Integer[set.size()]);
            int num = indexes.length;
            int[] indices = new int[num];
            for (int k = 0; k < num; ++k) {
                indices[k] = indexes[k];
            }
            this.splitScratchEditorModel(sem, indices);
        }
        this.editorView.deselectAllTimecodePoints();
        this.editorView.refresh();
        this.validate();
        this.repaint();
    }

    protected boolean splitScratchEditorModel(ScratchEditorModel model, int[] indices) {
        int splitCount = indices.length;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Splitting model: points=" + splitCount + ", model=" + model);
        }
        if (splitCount < 1) {
            return true;
        }
        int size = model.getTimecodePointCount();
        for (int i = 0; i < splitCount; ++i) {
            int k;
            double faderMoveOfs;
            int k2;
            double endOffset;
            int count;
            int index = indices[i];
            double offset = model.getTimecodePointOffsetAt(index);
            double value = model.getTimecodePointValueAt(index);
            if (i + 1 < splitCount) {
                count = indices[i + 1] - index;
                endOffset = model.getTimecodePointOffsetAt(indices[i + 1]);
            } else {
                count = size - 1 - index;
                endOffset = -1.0;
            }
            int moveIndex = -1;
            int moveCount = 0;
            int moves = model.getFaderMoveCount();
            for (k2 = 0; k2 < moves; ++k2) {
                faderMoveOfs = model.getFaderMoveOffsetAt(k2);
                if (!(faderMoveOfs > offset)) continue;
                moveIndex = k2;
                break;
            }
            if (moveIndex >= 0) {
                moveCount = moves - moveIndex;
                if (endOffset >= 0.0) {
                    for (k2 = moveIndex; k2 < moves; ++k2) {
                        faderMoveOfs = model.getFaderMoveOffsetAt(k2);
                        if (!(faderMoveOfs >= endOffset)) continue;
                        moveCount = k2 - moveIndex;
                        break;
                    }
                }
            }
            DefaultScratchEditorModel split = new DefaultScratchEditorModel(count, moveCount);
            int end = index + 1 + count;
            for (k = index + 1; k < end; ++k) {
                split.putTimecodePoint(model.getTimecodePointOffsetAt(k) - offset, model.getTimecodePointValueAt(k) - value);
            }
            end = moveIndex + moveCount;
            for (k = moveIndex; k < end; ++k) {
                split.putFaderMove(model.getFaderMoveOffsetAt(k) - offset, model.getFaderMoveAt(k));
            }
            for (k = end - 1; k >= moveIndex; --k) {
                model.removeFaderMoveAt(k);
            }
            WaxEditorItem[] items = this.getWaxEditorItems(model);
            for (int k3 = 0; k3 < items.length; ++k3) {
                WaxEditorItem item = items[k3];
                WaxEditorModel itemParent = item.getParent();
                if (itemParent == null) continue;
                DefaultWaxEditorItem splitItem = new DefaultWaxEditorItem((ScratchEditorModel)split);
                splitItem.setStartTime(item.getStartTime() + offset);
                splitItem.setStartValue(item.getStartValue() + value);
                splitItem.setInterpolation(item.getInterpolation());
                splitItem.setAutoConnect(item.isAutoConnect());
                splitItem.setEditable(item.isEditable());
                itemParent.addItem((WaxEditorItem)splitItem);
            }
        }
        int index = indices[0];
        for (int i = size - 1; i > index; --i) {
            model.removeTimecodePointAt(i);
        }
        return true;
    }

    protected WaxEditorItem[] getWaxEditorItems(ScratchEditorModel model) {
        DefaultWaxEditorLineView view = this.editorView;
        int num = view == null ? 0 : view.getWaxEditorModelCount();
        LinkedList<WaxEditorItem> list = new LinkedList<WaxEditorItem>();
        for (int k = 0; k < num; ++k) {
            WaxEditorModel wem = view.getWaxEditorModelAt(k);
            int itemCount = wem.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                WaxEditorItem item = wem.getItemAt(j);
                if (item.getModel() != model) continue;
                list.add(item);
            }
        }
        return list.toArray(new WaxEditorItem[list.size()]);
    }

    protected DragPoint[] getUniqueSelectedPoints() {
        HashSet<DragPoint> points = new HashSet<DragPoint>();
        HashMap indexMap = new HashMap();
        WaxEditorItem[] items = this.editorView.getWaxEditorItemsForSelectedPoints();
        for (int j = 0; j < items.length; ++j) {
            WaxEditorItem item = items[j];
            ScratchEditorModel model = item.getModel();
            int[] sel = this.editorView.getSelectedTimecodePoints(item);
            int num = sel.length;
            if (num < 1) continue;
            HashSet<Integer> indexSet = (HashSet<Integer>)indexMap.get(model);
            if (indexSet == null) {
                indexSet = new HashSet<Integer>();
                indexMap.put(model, indexSet);
            }
            for (int i = 0; i < num; ++i) {
                double val;
                double ofs;
                int idx = sel[i];
                Integer key = Data.toInteger((int)idx);
                if (!indexSet.add(key)) continue;
                if (idx >= 0) {
                    ofs = model.getTimecodePointOffsetAt(idx);
                    val = model.getTimecodePointValueAt(idx);
                } else {
                    ofs = 0.0;
                    val = 0.0;
                }
                points.add(new DragPoint(item, ofs, val));
            }
        }
        return points.toArray(new DragPoint[points.size()]);
    }

    public void moveSelectedPointsXY(double x, double y) {
        double millisPerUnit;
        double timePerUnit = millisPerUnit = 1000.0 / this.zoomRate;
        switch (this.getOrientation()) {
            case 0: {
                double incOfs = x * millisPerUnit;
                double incVal = this.isInvertedDirection() ? y * timePerUnit : -y * timePerUnit;
                this.moveSelectedPoints(incOfs, incVal);
                return;
            }
            case 2: {
                double incOfs = y * millisPerUnit;
                double incVal = this.isInvertedDirection() ? x * timePerUnit : -x * timePerUnit;
                this.moveSelectedPoints(incOfs, incVal);
                return;
            }
        }
    }

    public void moveSelectedPoints(double incOfs, double incVal) {
        DragPoint[] movePointsOld = this.getUniqueSelectedPoints();
        int num = movePointsOld.length;
        if (num < 1) {
            return;
        }
        HashMap<ScratchEditorModel, WaxEditorItem[]> itemMap = new HashMap<ScratchEditorModel, WaxEditorItem[]>();
        DragPoint[] movePointsNew = new DragPoint[num];
        for (int i = 0; i < num; ++i) {
            movePointsNew[i] = new DragPoint(movePointsOld[i]);
            WaxEditorItem item = movePointsNew[i].item;
            ScratchEditorModel sem = item.getModel();
            if (itemMap.containsKey(sem)) continue;
            WaxEditorItem[] items = this.getWaxEditorItems(sem);
            itemMap.put(sem, items);
        }
        DragPoint[] arr = new DragPoint[num];
        EditorLineWrapper.movePoints(movePointsOld, movePointsNew, arr, incOfs, incVal, itemMap, this.minPointDistMillis);
        this.selectPoints(arr);
        this.editorView.refresh();
        this.validate();
        this.repaint();
    }

    public void selectAll() {
        if (this.editorView != null) {
            this.editorView.deselectAllTimecodePoints();
            this.editorView.selectAllWaxEditorItems();
            this.editorView.refresh();
        }
        this.repaint();
    }

    public void showProperties() {
        PropertiesPanel panel = this.createPropertiesPanel();
        if (panel == null) {
            return;
        }
        String title = panel.getTitle();
        if (title == null) {
            title = "Properties";
        }
        PropertiesPanel message = panel;
        int optionType = 2;
        int messageType = -1;
        Icon icon = null;
        int rc = JOptionPane.showConfirmDialog(this.getPanel(), message, title, optionType, messageType, icon);
        if (rc != 0) {
            return;
        }
        panel.apply();
        this.editorView.refresh();
        this.validate();
        this.repaint();
    }

    protected PropertiesPanel createPropertiesPanel() {
        WaxEditorItem ref;
        WaxEditorItem[] modelRefs;
        FaderPoint fp;
        FaderMove fm;
        FaderPoint[] points;
        if (this.editorView.getSelectedFaderPointCount() > 0 && (points = this.editorView.getSelectedFaderPoints()).length > 0 && (fm = (fp = points[0]).getFaderMove()) != null && fm instanceof DefaultFaderClick) {
            DefaultFaderClick fc = (DefaultFaderClick)fm;
            FaderClickPropertiesPanel panel = new FaderClickPropertiesPanel();
            panel.setTitle("Fader Click Properties");
            panel.setFaderClick(fc);
            return panel;
        }
        if (this.editorView.getSelectedWaxEditorItemCount() > 0 && (modelRefs = this.editorView.getSelectedWaxEditorItems()).length > 0 && (ref = modelRefs[0]) != null) {
            WaxEditorItemPropertiesPanel panel = new WaxEditorItemPropertiesPanel();
            panel.setTitle("Scratch Model Properties");
            panel.setInterpolatorRegistry(this.interpolatorRegistry);
            panel.setItem(ref);
            return panel;
        }
        return null;
    }

    public WaxEditorItem[] getWaxEditorItemsForSelectedPoints() {
        return this.editorView.getWaxEditorItemsForSelectedPoints();
    }

    public int getSelectedWaxEditorItemCount() {
        return this.editorView.getSelectedWaxEditorItemCount();
    }

    public int getSelectedFaderPointCount() {
        return this.editorView.getSelectedFaderPointCount();
    }

    public boolean isHideTimecodePoints() {
        return this.hideTimecodePoints;
    }

    public void setHideTimecodePoints(boolean hideTimecodePoints) {
        this.hideTimecodePoints = hideTimecodePoints;
    }

    public boolean isHideFaderPoints() {
        return this.hideFaderPoints;
    }

    public void setHideFaderPoints(boolean hideFaderPoints) {
        this.hideFaderPoints = hideFaderPoints;
    }

    public double getMaxModelDistance() {
        return this.maxModelDistance;
    }

    public void setMaxModelDistance(double maxModelDistance) {
        this.maxModelDistance = maxModelDistance;
    }

    @Override
    public ClipboardManager getClipboardManager() {
        return this.clipboardManager;
    }

    public void setClipboardManager(ClipboardManager clipboardManager) {
        this.clipboardManager = clipboardManager;
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    protected static void putTimecodeStartPoint(ScratchEditorModel orig, WaxEditorItem[] items, double rel, double rv) {
        int size = orig.getTimecodePointCount();
        orig.moveTimecodePoints(0, size, rel, rv);
        size = orig.getFaderMoveCount();
        orig.moveFaderMoves(0, size, rel);
        if (rel > 0.0) {
            orig.putTimecodePoint(rel, rv);
        }
        for (WaxEditorItem item : items) {
            item.setStartTime(item.getStartTime() - rel);
            item.setStartValue(item.getStartValue() - rv);
        }
    }

    protected static void removeTimecodeStartPoint(ScratchEditorModel orig, WaxEditorItem[] items, double rel, double rv) {
        if (rel > 0.0) {
            orig.removeTimecodePoint(rel);
        }
        int size = orig.getTimecodePointCount();
        orig.moveTimecodePoints(0, size, -rel, -rv);
        size = orig.getFaderMoveCount();
        orig.moveFaderMoves(0, size, -rel);
        for (WaxEditorItem item : items) {
            item.setStartTime(item.getStartTime() + rel);
            item.setStartValue(item.getStartValue() + rv);
        }
    }

    public long getTimecodeScrollPosition() {
        ScrollView scrollView = this.getScrollView();
        if (scrollView == null) {
            return 0L;
        }
        ScrollPos pos = scrollView.getPosition();
        switch (this.getOrientation()) {
            case 0: {
                return pos.y;
            }
            case 2: {
                return pos.x;
            }
        }
        return 0L;
    }

    @Override
    public void showExportLineDialog(Component parent, WaxLab waxLab) {
        Line studioLine = this.getLine();
        if (studioLine instanceof EditorLine) {
            EditorLine editorLine = (EditorLine)studioLine;
            String title = "Export Scratch-Editor Line";
            EditorLineExportPanel panel = new EditorLineExportPanel();
            panel.setWaxLab(waxLab);
            panel.setEditorLine(editorLine);
            panel.showDialog(parent, title);
        }
    }

    protected WaxEditorLineView getEditorView() {
        return this.editorView;
    }

    protected int getFaderDeck(String leftDeckName, String rightDeckName) {
        return -1;
    }

    public long computeTimeLength() {
        return this.line.computeTimeLength();
    }

    @Override
    public void refresh() {
        TileView tileView;
        int tileHeight;
        this.editorView.setZoomRate(this.zoomRate);
        int tileWidth = this.trackSize;
        if (tileWidth < 1) {
            tileWidth = 1;
        }
        if ((tileHeight = this.trackSize) < 1) {
            tileHeight = 1;
        }
        if ((tileView = this.tileView) != null && (tileView.getTileWidth() != tileWidth || tileView.getTileHeight() != tileHeight)) {
            tileView.flush();
            tileView = null;
        }
        if (tileView == null) {
            int maxTileCacheCount = this.viewSettings.getTimecodeTileCacheCount();
            if (maxTileCacheCount < 1) {
                maxTileCacheCount = 1;
            }
            Color editorLineBackground = this.viewSettings.getEditorViewBackground();
            this.tileView = tileView = new TileView(tileWidth, tileHeight, maxTileCacheCount, (Paint)editorLineBackground);
            this.editorView.setTileView(tileView);
        }
        WaxEditorModel[] models = this.editorLine.getEditorChunks();
        this.editorView.replaceAllWaxEditorModels(models);
    }

    public ChangeListener getEditorSelectionChangeHandler() {
        return this.editorSelectionChangeHandler;
    }

    public void setEditorSelectionChangeHandler(ChangeListener newHandler) {
        if (this.editorSelectionChangeHandler == newHandler) {
            return;
        }
        if (this.editorSelectionChangeHandler != null) {
            this.editorView.removeSelectionChangeListener(this.editorSelectionChangeHandler);
        }
        this.editorSelectionChangeHandler = newHandler;
        if (this.editorSelectionChangeHandler != null) {
            this.editorView.addSelectionChangeListener(this.editorSelectionChangeHandler);
        }
    }

    public InterpolatorRegistry getInterpolatorRegistry() {
        return this.interpolatorRegistry;
    }

    public void setInterpolatorRegistry(InterpolatorRegistry newRegistry) {
        this.interpolatorRegistry = newRegistry;
        this.editorView.setInterpolatorRegistry(newRegistry);
    }

    @Override
    public void layout() {
        EditorLineConfig config;
        int orient = this.orientation;
        boolean horiz = orient == 0 || orient == 1;
        boolean invertedView = false;
        boolean hideTimecodePoints = false;
        boolean hideFaderPoints = false;
        boolean timecodeAutoScrolling = true;
        FaderCurve faderCurve = null;
        EditorLine editorLine = this.editorLine;
        if (editorLine != null && (config = editorLine.getEditorLineConfig()) != null) {
            invertedView = config.isInvertedView();
            hideTimecodePoints = config.isHideTimecodePoints();
            hideFaderPoints = config.isHideFaderPoints();
            timecodeAutoScrolling = config.isTimecodeAutoScrolling();
            faderCurve = config.getFaderCurve();
        }
        this.setInvertedDirection(invertedView);
        this.setTimecodeAutoScrolling(timecodeAutoScrolling);
        this.setHideTimecodePoints(hideTimecodePoints);
        this.setHideFaderPoints(hideFaderPoints);
        DefaultWaxEditorLineView editorView = this.editorView;
        if (editorView != null) {
            editorView.setInverted(invertedView);
            editorView.setHideTimecodePoints(hideTimecodePoints);
            editorView.setHideFaderPoints(hideFaderPoints);
            editorView.setFaderCurve(faderCurve);
        }
        if (this.scrollView != null) {
            Dimension prefSize = this.scrollView.getPreferredSize();
            prefSize.width = this.trackSize;
            prefSize.height = this.trackSize;
            this.scrollView.setPreferredSize(prefSize);
        }
        double prevTcPos = editorLine.getTimecodeScrollPosition();
        double timeScale = 1000.0 / this.zoomRate;
        long timecodeScrollPos = invertedView ? (long)(1.048576E7 + prevTcPos / timeScale - (double)(this.trackSize / 2)) : (long)(1.048576E7 - prevTcPos / timeScale - (double)(this.trackSize / 2));
        ScrollPos pos = this.scrollView.getPosition();
        if (horiz) {
            pos.y = timecodeScrollPos;
        } else {
            pos.x = timecodeScrollPos;
        }
        this.scrollView.setPosition(pos);
        ScrollView wrapperView = this.scrollView;
        if (wrapperView != null) {
            int index = this.getGridIndex();
            GridBagConstraints gbc = new GridBagConstraints();
            if (horiz) {
                gbc.gridx = 0;
                gbc.gridy = index;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
            } else {
                gbc.gridx = index;
                gbc.gridy = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 1.0;
            }
            gbc.fill = 1;
            ViewLayout viewLayout = this.viewLayout;
            if (viewLayout != null) {
                viewLayout.removeView((View)wrapperView);
                if (index >= 0) {
                    viewLayout.addView((View)wrapperView, (Object)gbc);
                }
            }
        }
    }

    @Override
    public void setViewSettings(WaxLabViewSettings viewSettings) {
        super.setViewSettings(viewSettings);
        if (viewSettings != null) {
            int timecodeScrollThreshold = viewSettings.getTimecodeScrollThreshold();
            if (timecodeScrollThreshold < 0) {
                timecodeScrollThreshold = 0;
            }
            this.setTimecodeScrollThreshold(timecodeScrollThreshold);
            if (this.editorView != null) {
                this.editorView.setTimecodeLineColor(viewSettings.getEditorTimecodeLineColor());
                this.editorView.setTimecodePointColor(viewSettings.getEditorTimecodePointColor());
                this.editorView.setSelectedTimecodePointColor(viewSettings.getEditorSelectedPointColor());
                this.editorView.setSelectedModelBackground(viewSettings.getEditorSelectedModelBackground());
            }
            if (this.tileView != null) {
                int maxTileCacheCount = viewSettings.getTimecodeTileCacheCount();
                if (maxTileCacheCount < 1) {
                    maxTileCacheCount = 1;
                }
                this.tileView.setMaxTileCacheCount(maxTileCacheCount);
                this.tileView.setBackground((Paint)viewSettings.getEditorViewBackground());
            }
        }
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        if (this.editorView != null) {
            this.editorView.setOrientation(orientation);
        }
    }

    public FaderMoveFaderPointRenderer getFaderMoveRenderer() {
        return this.faderMoveRenderer;
    }

    public void setFaderMoveRenderer(FaderMoveFaderPointRenderer faderMoveRenderer) {
        this.faderMoveRenderer = faderMoveRenderer;
        if (this.editorView != null) {
            this.editorView.setFaderMoveRenderer(faderMoveRenderer);
        }
    }

    public FaderClickFaderPointRenderer getFaderClickRenderer() {
        return this.faderClickRenderer;
    }

    public void setFaderClickRenderer(FaderClickFaderPointRenderer faderClickRenderer) {
        this.faderClickRenderer = faderClickRenderer;
        if (this.editorView != null) {
            this.editorView.setFaderClickRenderer(faderClickRenderer);
        }
    }

    public File showOpenFileDialog() throws Exception {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setDialogTitle("Open Editor File");
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        WaxLabFileFilters.WaxEditorFileFilter fileFilter = new WaxLabFileFilters.WaxEditorFileFilter();
        chooser.setFileFilter(fileFilter);
        int rc = chooser.showOpenDialog(this.panel);
        if (rc != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        return file;
    }

    public LineChunk[] openLineChunks(File file) throws Exception {
        DefaultWaxEditorFile wef;
        WaxEditorModel[] wems;
        int num;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating wax-editor model for file: " + file);
        }
        if ((num = (wems = (wef = new DefaultWaxEditorFile(file)).readWaxEditorFile()).length) < 1) {
            return null;
        }
        return wems;
    }

    protected static class CloningWaxEditorItem
    extends DefaultWaxEditorItem {
        private final WaxEditorItem item;

        public CloningWaxEditorItem(WaxEditorItem item) {
            super(null);
            this.item = item;
        }

        public final WaxEditorItem getItem() {
            return this.item;
        }

        public WaxEditorItem createCopy() throws CloneNotSupportedException {
            return this.item.createClone();
        }

        public WaxEditorItem createClone() throws CloneNotSupportedException {
            return this.item.createClone();
        }
    }

    protected static class MoveTimecodePointsEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = -4094179617964453550L;
        final DragPoint[] dragPointsOld;
        final DragPoint[] dragPointsNew;
        final Map itemMap;

        public MoveTimecodePointsEdit(DragPoint[] dragPointsOld, DragPoint[] dragPointsNew, Map itemMap) {
            this.dragPointsOld = dragPointsOld;
            this.dragPointsNew = dragPointsNew;
            this.itemMap = itemMap;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            double minPointDistMillis = 0.0;
            double deltaOfs = 0.0;
            double deltaVal = 0.0;
            DragPoint[] arr = new DragPoint[this.dragPointsOld.length];
            EditorLineWrapper.movePoints(this.dragPointsOld, this.dragPointsNew, arr, deltaOfs, deltaVal, this.itemMap, minPointDistMillis);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            double minPointDistMillis = 0.0;
            double deltaOfs = 0.0;
            double deltaVal = 0.0;
            DragPoint[] arr = new DragPoint[this.dragPointsOld.length];
            EditorLineWrapper.movePoints(this.dragPointsNew, this.dragPointsOld, arr, deltaOfs, deltaVal, this.itemMap, minPointDistMillis);
        }
    }

    protected static class MoveItemEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = 7757420796718970095L;
        final WaxEditorItem item;
        final double oldStartTime;
        final double oldStartValue;
        final double newStartTime;
        final double newStartValue;

        public MoveItemEdit(WaxEditorItem item, double oldStartTime, double oldStartValue, double newStartTime, double newStartValue) {
            this.item = item;
            this.oldStartTime = oldStartTime;
            this.oldStartValue = oldStartValue;
            this.newStartTime = newStartTime;
            this.newStartValue = newStartValue;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.item.setStartTime(this.oldStartTime);
            this.item.setStartValue(this.oldStartValue);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.item.setStartTime(this.newStartTime);
            this.item.setStartValue(this.newStartValue);
        }
    }

    protected static class RemoveItemEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = 2354153380438514795L;
        final WaxEditorModel parent;
        final WaxEditorItem item;

        public RemoveItemEdit(WaxEditorModel parent, WaxEditorItem item) {
            this.parent = parent;
            this.item = item;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.parent.addItem(this.item);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.parent.removeItem(this.item);
        }
    }

    protected static class AddItemEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = -6926141980996759707L;
        final WaxEditorModel parent;
        final WaxEditorItem item;

        public AddItemEdit(WaxEditorModel parent, WaxEditorItem item) {
            this.parent = parent;
            this.item = item;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.parent.removeItem(this.item);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.parent.addItem(this.item);
        }
    }

    protected static class RemoveFaderMoveEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = 8701597262642323165L;
        final WaxEditorModel parent;
        final ScratchEditorModel model;
        final double offset;
        final FaderMove value;

        public RemoveFaderMoveEdit(WaxEditorModel parent, ScratchEditorModel model, double offset, FaderMove value) {
            this.parent = parent;
            this.model = model;
            this.offset = offset;
            this.value = value;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.putFaderMove(this.offset, this.value);
            if (this.parent != null) {
                this.parent.setDirty(true);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.removeFaderMove(this.offset);
            if (this.parent != null) {
                this.parent.setDirty(true);
            }
        }
    }

    protected static class PutFaderMoveEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = 5344565416694315932L;
        final WaxEditorModel parent;
        final ScratchEditorModel model;
        final double offset;
        final FaderMove value;
        final FaderMove oldValue;

        public PutFaderMoveEdit(WaxEditorModel parent, ScratchEditorModel model, double offset, FaderMove value, FaderMove oldValue) {
            this.parent = parent;
            this.model = model;
            this.offset = offset;
            this.value = value;
            this.oldValue = oldValue;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.removeFaderMove(this.offset);
            if (this.oldValue != null) {
                this.model.putFaderMove(this.offset, this.oldValue);
            }
            if (this.parent != null) {
                this.parent.setDirty(true);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.putFaderMove(this.offset, this.value);
            if (this.parent != null) {
                this.parent.setDirty(true);
            }
        }
    }

    protected static class RemoveTimecodeStartPointEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = -1268250830912790108L;
        final ScratchEditorModel orig;
        final WaxEditorItem[] items;
        final double offset;
        final double value;

        public RemoveTimecodeStartPointEdit(ScratchEditorModel orig, WaxEditorItem[] items, double offset, double value) {
            this.orig = orig;
            this.items = items;
            this.offset = offset;
            this.value = value;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            EditorLineWrapper.putTimecodeStartPoint(this.orig, this.items, this.offset, this.value);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            EditorLineWrapper.removeTimecodeStartPoint(this.orig, this.items, this.offset, this.value);
        }
    }

    protected static class PutTimecodeStartPointEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = 664288440615695231L;
        final ScratchEditorModel orig;
        final WaxEditorItem[] items;
        final double offset;
        final double value;

        public PutTimecodeStartPointEdit(ScratchEditorModel orig, WaxEditorItem[] items, double offset, double value) {
            this.orig = orig;
            this.items = items;
            this.offset = offset;
            this.value = value;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            EditorLineWrapper.removeTimecodeStartPoint(this.orig, this.items, this.offset, this.value);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            EditorLineWrapper.putTimecodeStartPoint(this.orig, this.items, this.offset, this.value);
        }
    }

    protected static class RemoveTimecodePointEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = 967774415937857504L;
        final ScratchEditorModel model;
        final double offset;
        final double value;

        public RemoveTimecodePointEdit(ScratchEditorModel model, double offset, double value) {
            this.model = model;
            this.offset = offset;
            this.value = value;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.putTimecodePoint(this.offset, this.value);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.removeTimecodePoint(this.offset);
        }
    }

    protected static class PutTimecodePointEdit
    extends AbstractWaxEdit {
        private static final long serialVersionUID = 384776869602630225L;
        final ScratchEditorModel model;
        final double offset;
        final double value;
        final Double oldValue;

        public PutTimecodePointEdit(ScratchEditorModel model, double offset, double value, Double oldValue) {
            this.model = model;
            this.offset = offset;
            this.value = value;
            this.oldValue = oldValue;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.removeTimecodePoint(this.offset);
            if (this.oldValue != null) {
                this.model.putTimecodePoint(this.offset, this.oldValue.doubleValue());
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.putTimecodePoint(this.offset, this.value);
        }
    }

    protected static abstract class AbstractWaxEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 6379067997296933264L;
    }

    protected static class FaderMovePoint {
        WaxEditorItem item;
        int index;

        public FaderMovePoint(WaxEditorItem item, int index) {
            this.item = item;
            this.index = index;
        }
    }

    protected static class DragFaderMove {
        FaderMove faderMove;
        WaxEditorItem oldItem;
        double oldOffset;
        WaxEditorItem newItem;
        double newOffset;

        public DragFaderMove(WaxEditorItem item, FaderMove faderMove, double offset) {
            this.faderMove = faderMove;
            this.oldItem = item;
            this.oldOffset = offset;
            this.newItem = item;
            this.newOffset = offset;
        }

        public DragFaderMove(FaderPoint fp) {
            this(fp.getWaxEditorItem(), fp.getFaderMove(), fp.getStartOffset());
        }
    }

    protected static class DragItem {
        WaxEditorItem item;
        double startTime;
        double startValue;

        public DragItem(WaxEditorItem item, double startTime, double startValue) {
            this.item = item;
            this.startTime = startTime;
            this.startValue = startValue;
        }
    }

    protected static class AffectedStartPoint {
        ScratchEditorModel model;
        DragPoint current;
        DragPoint point;

        public AffectedStartPoint(ScratchEditorModel model, DragPoint current, DragPoint point) {
            this.model = model;
            this.current = current;
            this.point = point;
        }
    }

    protected static class DragPoint {
        WaxEditorItem item;
        double offset;
        double value;

        public DragPoint(WaxEditorItem item, double offset, double value) {
            this.item = item;
            this.offset = offset;
            this.value = value;
        }

        public DragPoint(DragPoint p) {
            this.item = p.item;
            this.offset = p.offset;
            this.value = p.value;
        }
    }

    protected static class TimecodePoint {
        WaxEditorItem item;
        int index;

        public TimecodePoint(WaxEditorItem item, int index) {
            this.item = item;
            this.index = index;
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            EditorLineWrapper.this.handleMouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            EditorLineWrapper.this.handleMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            EditorLineWrapper.this.handleMouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            EditorLineWrapper.this.handleMouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            EditorLineWrapper.this.handleMouseExited(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            EditorLineWrapper.this.handleMouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            EditorLineWrapper.this.handleMouseMoved(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            EditorLineWrapper.this.handleMouseWheelMoved(e);
        }
    }

    protected class PointMover
    implements ActionListener {
        protected PointMover() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int moveX = EditorLineWrapper.this.pointMoveIncrementX * EditorLineWrapper.this.pointMoveFactorX;
            int moveY = EditorLineWrapper.this.pointMoveIncrementY * EditorLineWrapper.this.pointMoveFactorY;
            EditorLineWrapper.this.moveSelectedPointsXY(moveX, moveY);
            if (EditorLineWrapper.this.pointMoveSpeedup && ++EditorLineWrapper.this.pointMoveCounter > EditorLineWrapper.this.pointMoveSpeedupDelay) {
                EditorLineWrapper.this.pointMoveCounter = 0;
                if (EditorLineWrapper.this.pointMoveFactorX < EditorLineWrapper.this.pointMoveMaxFactor) {
                    EditorLineWrapper.this.pointMoveFactorX++;
                }
                if (EditorLineWrapper.this.pointMoveFactorY < EditorLineWrapper.this.pointMoveMaxFactor) {
                    EditorLineWrapper.this.pointMoveFactorY++;
                }
            }
        }
    }

    protected class KeyHandler
    extends KeyAdapter
    implements KeyListener {
        protected KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            EditorLineWrapper.this.handleKeyTyped(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            EditorLineWrapper.this.handleKeyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            EditorLineWrapper.this.handleKeyReleased(e);
        }
    }
}

