/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.fader.Fader;
import com.waxmonster.fader.FaderConfig;
import com.waxmonster.fader.midi.DefaultMidiFaderConfig;
import com.waxmonster.studio.Device;
import com.waxmonster.waxlab.view.FaderConfigOptionsPanel;
import com.waxmonster.waxlab.view.TimecodeLineConfigPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FaderConfigManagerPanel
extends JPanel {
    private static final long serialVersionUID = 4271352863076208278L;
    private static final Logger logger = Logger.getLogger(FaderConfigManagerPanel.class.getName());
    public static final String PROPERTY_FADER_CONFIGS = "faderConfigs";
    private static final String ACTION_REMOVE = "RemoveSelectedFaders";
    private static final String ACTION_MOVE_UP = "MoveUpSelectedFaders";
    private static final String ACTION_MOVE_DOWN = "MoveDownSelectedFaders";
    private FaderConfig[] faderConfigs;
    private Device device;
    private int channelCount;
    private DefaultListModel faderListModel;
    private boolean refreshing;
    private JList listFaders;
    private JButton buttonFaderAdd;
    private JButton buttonFaderRemove;
    private JButton buttonFaderMoveUp;
    private JButton buttonFaderMoveDown;
    private FaderConfigOptionsPanel faderConfigOptionsPanel;
    private JPanel panelFaderOptions;
    private JButton btnPresets;

    public FaderConfigManagerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelFaderList = new JPanel();
        panelFaderList.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Faders", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panelFaderList = new GridBagConstraints();
        gbc_panelFaderList.weighty = 1.0;
        gbc_panelFaderList.insets = new Insets(0, 0, 0, 5);
        gbc_panelFaderList.fill = 1;
        gbc_panelFaderList.gridx = 0;
        gbc_panelFaderList.gridy = 0;
        this.add((Component)panelFaderList, gbc_panelFaderList);
        GridBagLayout gbl_panelFaderList = new GridBagLayout();
        gbl_panelFaderList.columnWidths = new int[]{0, 0};
        gbl_panelFaderList.rowHeights = new int[]{0, 0, 0};
        gbl_panelFaderList.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelFaderList.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelFaderList.setLayout(gbl_panelFaderList);
        JScrollPane scrollPaneFaderList = new JScrollPane();
        GridBagConstraints gbc_scrollPaneFaderList = new GridBagConstraints();
        gbc_scrollPaneFaderList.weighty = 1.0;
        gbc_scrollPaneFaderList.weightx = 1.0;
        gbc_scrollPaneFaderList.fill = 1;
        gbc_scrollPaneFaderList.insets = new Insets(4, 4, 5, 4);
        gbc_scrollPaneFaderList.gridx = 0;
        gbc_scrollPaneFaderList.gridy = 0;
        panelFaderList.add((Component)scrollPaneFaderList, gbc_scrollPaneFaderList);
        this.listFaders = new JList();
        this.listFaders.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!FaderConfigManagerPanel.this.refreshing) {
                    FaderConfigManagerPanel.this.checkEnable();
                    FaderConfigManagerPanel.this.handleFaderSelected();
                }
            }
        });
        scrollPaneFaderList.setViewportView(this.listFaders);
        JPanel panelButtons = new JPanel();
        panelButtons.setOpaque(false);
        panelButtons.setEnabled(false);
        GridBagConstraints gbc_panelButtons = new GridBagConstraints();
        gbc_panelButtons.insets = new Insets(0, 4, 4, 4);
        gbc_panelButtons.fill = 1;
        gbc_panelButtons.gridx = 0;
        gbc_panelButtons.gridy = 1;
        panelFaderList.add((Component)panelButtons, gbc_panelButtons);
        GridBagLayout gbl_panelButtons = new GridBagLayout();
        gbl_panelButtons.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panelButtons.rowHeights = new int[]{0, 0};
        gbl_panelButtons.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelButtons.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelButtons.setLayout(gbl_panelButtons);
        this.buttonFaderAdd = new JButton("");
        this.buttonFaderAdd.setIcon(new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/insert.gif")));
        this.buttonFaderAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaderConfigManagerPanel.this.actionFaderAdd();
            }
        });
        this.buttonFaderAdd.setToolTipText("Add Fader");
        this.buttonFaderAdd.setMargin(new Insets(2, 4, 2, 4));
        this.buttonFaderAdd.setEnabled(false);
        GridBagConstraints gbc_buttonFaderAdd = new GridBagConstraints();
        gbc_buttonFaderAdd.insets = new Insets(0, 0, 0, 5);
        gbc_buttonFaderAdd.gridx = 0;
        gbc_buttonFaderAdd.gridy = 0;
        panelButtons.add((Component)this.buttonFaderAdd, gbc_buttonFaderAdd);
        this.buttonFaderRemove = new JButton("");
        this.buttonFaderRemove.setIcon(new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/remove_icon16.gif")));
        this.buttonFaderRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaderConfigManagerPanel.this.actionRemove();
            }
        });
        this.buttonFaderRemove.setToolTipText("Remove Fader");
        this.buttonFaderRemove.setMargin(new Insets(2, 4, 2, 4));
        this.buttonFaderRemove.setEnabled(false);
        GridBagConstraints gbc_buttonFaderRemove = new GridBagConstraints();
        gbc_buttonFaderRemove.insets = new Insets(0, 0, 0, 5);
        gbc_buttonFaderRemove.gridx = 1;
        gbc_buttonFaderRemove.gridy = 0;
        panelButtons.add((Component)this.buttonFaderRemove, gbc_buttonFaderRemove);
        this.buttonFaderMoveUp = new JButton("");
        this.buttonFaderMoveUp.setIcon(new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/pageup.gif")));
        this.buttonFaderMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaderConfigManagerPanel.this.actionMoveUp();
            }
        });
        this.buttonFaderMoveUp.setToolTipText("Move Up");
        this.buttonFaderMoveUp.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFaderMoveUp.setEnabled(false);
        GridBagConstraints gbc_buttonFaderMoveUp = new GridBagConstraints();
        gbc_buttonFaderMoveUp.insets = new Insets(0, 0, 0, 5);
        gbc_buttonFaderMoveUp.gridx = 2;
        gbc_buttonFaderMoveUp.gridy = 0;
        panelButtons.add((Component)this.buttonFaderMoveUp, gbc_buttonFaderMoveUp);
        this.buttonFaderMoveDown = new JButton("");
        this.buttonFaderMoveDown.setIcon(new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/pagedown.gif")));
        this.buttonFaderMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaderConfigManagerPanel.this.actionMoveDown();
            }
        });
        this.buttonFaderMoveDown.setToolTipText("Move Down");
        this.buttonFaderMoveDown.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFaderMoveDown.setEnabled(false);
        GridBagConstraints gbc_buttonFaderMoveDown = new GridBagConstraints();
        gbc_buttonFaderMoveDown.insets = new Insets(0, 0, 0, 5);
        gbc_buttonFaderMoveDown.gridx = 3;
        gbc_buttonFaderMoveDown.gridy = 0;
        panelButtons.add((Component)this.buttonFaderMoveDown, gbc_buttonFaderMoveDown);
        this.btnPresets = new JButton("Presets...");
        this.btnPresets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.warning("TODO presets...");
            }
        });
        this.btnPresets.setToolTipText("Manage presets...");
        this.btnPresets.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnPresets = new GridBagConstraints();
        gbc_btnPresets.anchor = 13;
        gbc_btnPresets.weightx = 1.0;
        gbc_btnPresets.gridx = 4;
        gbc_btnPresets.gridy = 0;
        panelButtons.add((Component)this.btnPresets, gbc_btnPresets);
        this.panelFaderOptions = new JPanel();
        this.panelFaderOptions.setEnabled(false);
        this.panelFaderOptions.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Fader Options", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panelFaderOptions = new GridBagConstraints();
        gbc_panelFaderOptions.weightx = 1.0;
        gbc_panelFaderOptions.weighty = 1.0;
        gbc_panelFaderOptions.fill = 1;
        gbc_panelFaderOptions.gridx = 1;
        gbc_panelFaderOptions.gridy = 0;
        this.add((Component)this.panelFaderOptions, gbc_panelFaderOptions);
        GridBagLayout gbl_panelFaderOptions = new GridBagLayout();
        gbl_panelFaderOptions.columnWidths = new int[]{0, 0};
        gbl_panelFaderOptions.rowHeights = new int[]{0, 0};
        gbl_panelFaderOptions.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelFaderOptions.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelFaderOptions.setLayout(gbl_panelFaderOptions);
        this.faderConfigOptionsPanel = new FaderConfigOptionsPanel();
        this.faderConfigOptionsPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!FaderConfigManagerPanel.this.refreshing) {
                    FaderConfigManagerPanel.this.applyFaderConfig();
                }
            }
        });
        GridBagConstraints gbc_faderConfigOptionsPanel = new GridBagConstraints();
        gbc_faderConfigOptionsPanel.insets = new Insets(4, 4, 4, 4);
        gbc_faderConfigOptionsPanel.weighty = 1.0;
        gbc_faderConfigOptionsPanel.weightx = 1.0;
        gbc_faderConfigOptionsPanel.fill = 1;
        gbc_faderConfigOptionsPanel.gridx = 0;
        gbc_faderConfigOptionsPanel.gridy = 0;
        this.panelFaderOptions.add((Component)this.faderConfigOptionsPanel, gbc_faderConfigOptionsPanel);
        this.initFaderConfigManagerPanel();
    }

    protected JList getListFaders() {
        return this.listFaders;
    }

    protected JButton getButtonFaderAdd() {
        return this.buttonFaderAdd;
    }

    protected JButton getButtonFaderRemove() {
        return this.buttonFaderRemove;
    }

    protected JButton getButtonFaderMoveUp() {
        return this.buttonFaderMoveUp;
    }

    protected JButton getButtonFaderMoveDown() {
        return this.buttonFaderMoveDown;
    }

    protected FaderConfigOptionsPanel getFaderConfigOptionsPanel() {
        return this.faderConfigOptionsPanel;
    }

    protected JPanel getPanelFaderOptions() {
        return this.panelFaderOptions;
    }

    protected void initFaderConfigManagerPanel() {
        this.faderListModel = new DefaultListModel();
        this.listFaders.setModel(this.faderListModel);
        this.listFaders.setCellRenderer(new FaderConfigListCellRenderer());
        this.listFaders.getActionMap().put(ACTION_REMOVE, new ActionRemove());
        this.listFaders.getInputMap().put(KeyStroke.getKeyStroke(127, 0), ACTION_REMOVE);
        this.listFaders.getActionMap().put(ACTION_MOVE_UP, new ActionMoveUp());
        this.listFaders.getInputMap().put(KeyStroke.getKeyStroke(38, 8), ACTION_MOVE_UP);
        this.listFaders.getActionMap().put(ACTION_MOVE_DOWN, new ActionMoveDown());
        this.listFaders.getInputMap().put(KeyStroke.getKeyStroke(40, 8), ACTION_MOVE_DOWN);
        this.handleFaderSelected();
    }

    public FaderConfig[] getFaderConfigs() {
        return this.faderConfigs;
    }

    public void setFaderConfigs(FaderConfig[] faderConfigs) {
        this.faderConfigs = faderConfigs;
        this.refresh();
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
        this.faderConfigOptionsPanel.setDevice(device);
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int channelCount) {
        this.channelCount = channelCount;
        this.faderConfigOptionsPanel.setChannelCount(channelCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            int selFaderIndex = this.listFaders.getSelectedIndex();
            this.faderListModel.removeAllElements();
            int numFaders = this.faderConfigs == null ? 0 : this.faderConfigs.length;
            for (int i = 0; i < numFaders; ++i) {
                FaderConfig faderConfig = this.faderConfigs[i];
                if (faderConfig == null) continue;
                this.faderListModel.addElement(faderConfig);
            }
            if (selFaderIndex >= 0 && selFaderIndex < this.faderListModel.getSize()) {
                this.listFaders.setSelectedIndex(selFaderIndex);
            }
        }
        finally {
            this.refreshing = false;
        }
        this.checkEnable();
        this.handleFaderSelected();
    }

    protected void checkEnable() {
        boolean fadeEnabled = this.isEnabled();
        int[] sel = this.listFaders.getSelectedIndices();
        int size = this.faderListModel.getSize();
        this.listFaders.setEnabled(fadeEnabled);
        this.buttonFaderAdd.setEnabled(fadeEnabled);
        this.buttonFaderRemove.setEnabled(sel.length > 0);
        this.buttonFaderMoveUp.setEnabled(sel.length > 0 && sel[0] > 0);
        this.buttonFaderMoveDown.setEnabled(sel.length > 0 && sel[sel.length - 1] < size - 1);
        this.panelFaderOptions.setEnabled(sel.length > 0);
        if (sel.length < 1) {
            this.listFaders.clearSelection();
            this.faderConfigOptionsPanel.setFaderConfig(null);
        }
    }

    protected void applyFaderConfig() {
        int index = this.listFaders.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DefaultMidiFaderConfig faderConfig = this.faderConfigOptionsPanel.getFaderConfig();
        if (faderConfig == null) {
            return;
        }
        this.applyFaderListModel();
        this.listFaders.validate();
        this.listFaders.repaint();
    }

    protected void handleFaderSelected() {
        DefaultMidiFaderConfig faderConfig = null;
        try {
            int[] sel = this.listFaders.getSelectedIndices();
            if (sel != null && sel.length == 1) {
                Object faderConfigObj;
                int faderIndex = sel[0];
                Object v0 = faderConfigObj = faderIndex < 0 ? null : this.faderListModel.getElementAt(faderIndex);
                if (faderConfigObj != null && faderConfigObj instanceof DefaultMidiFaderConfig) {
                    faderConfig = faderConfigObj;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.faderConfigOptionsPanel.setFaderConfig(faderConfig);
    }

    protected void actionFaderAdd() {
        DefaultMidiFaderConfig faderConfig = new DefaultMidiFaderConfig();
        faderConfig.setFaderName("New Fader");
        int index = this.faderListModel.getSize();
        this.faderListModel.add(index, faderConfig);
        this.applyFaderListModel();
        this.listFaders.setSelectedIndex(index);
    }

    protected void actionRemove() {
        int[] sel = this.listFaders.getSelectedIndices();
        for (int i = sel.length - 1; i >= 0; --i) {
            this.faderListModel.removeElementAt(sel[i]);
        }
        this.applyFaderListModel();
    }

    protected void actionMoveUp() {
        int[] sel = this.listFaders.getSelectedIndices();
        if (sel.length > 0 && sel[0] > 0) {
            for (int i = 0; i < sel.length; ++i) {
                int index = sel[i];
                if (index > 0) {
                    Object element = this.faderListModel.remove(index);
                    this.faderListModel.add(--index, element);
                }
                sel[i] = index;
            }
            this.listFaders.setSelectedIndices(sel);
            this.listFaders.ensureIndexIsVisible(sel[0]);
            this.applyFaderListModel();
        }
    }

    protected void actionMoveDown() {
        int[] sel = this.listFaders.getSelectedIndices();
        int size = this.faderListModel.getSize();
        if (sel.length > 0 && sel[sel.length - 1] < size - 1) {
            for (int i = sel.length - 1; i >= 0; --i) {
                int index = sel[i];
                if (index < size - 1) {
                    Object element = this.faderListModel.remove(index);
                    this.faderListModel.add(++index, element);
                }
                sel[i] = index;
            }
            this.listFaders.setSelectedIndices(sel);
            this.listFaders.ensureIndexIsVisible(sel[sel.length - 1]);
            this.applyFaderListModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFaderListModel() {
        FaderConfig[] oldArr = this.getFaderConfigs();
        int num = this.faderListModel.getSize();
        FaderConfig[] arr = new FaderConfig[num];
        for (int i = 0; i < num; ++i) {
            arr[i] = (FaderConfig)this.faderListModel.get(i);
        }
        this.faderConfigs = arr;
        try {
            this.refreshing = true;
            this.firePropertyChange(PROPERTY_FADER_CONFIGS, oldArr, arr);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected class ActionMoveDown
    extends AbstractAction {
        private static final long serialVersionUID = 541856998331610831L;

        protected ActionMoveDown() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FaderConfigManagerPanel.this.actionMoveDown();
        }
    }

    protected class ActionMoveUp
    extends AbstractAction {
        private static final long serialVersionUID = -6081710239852711067L;

        protected ActionMoveUp() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FaderConfigManagerPanel.this.actionMoveUp();
        }
    }

    protected class ActionRemove
    extends AbstractAction {
        private static final long serialVersionUID = -7217287730649087275L;

        protected ActionRemove() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FaderConfigManagerPanel.this.actionRemove();
        }
    }

    protected class FaderConfigListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8937568306209705319L;

        protected FaderConfigListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FaderConfig) {
                int channelMask;
                FaderConfig faderConfig = (FaderConfig)value;
                String name = faderConfig.getFaderName();
                this.setText(String.valueOf(name));
                boolean enabled = faderConfig.isFaderEnabled();
                if (enabled && Fader.areAllChannelsMasked((int)(channelMask = faderConfig.getChannelMask()), (int)FaderConfigManagerPanel.this.channelCount)) {
                    enabled = false;
                }
                this.setEnabled(enabled);
            }
            return result;
        }
    }
}

