/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.media.control.AbstractFloatControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.FaderControlPanel;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.spacekiller.util.swing.DocumentAdapter;
import com.waxmonster.fader.Fader;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.ChannelMaskEditor;
import com.waxmonster.fader.impl.FaderCurveChooser;
import com.waxmonster.fader.impl.FaderCurveUtil;
import com.waxmonster.fader.impl.FaderCurveViewer;
import com.waxmonster.fader.midi.DefaultMidiFaderConfig;
import com.waxmonster.midi.AbstractMidiAction;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.MidiMappingManagerPanel;
import com.waxmonster.studio.Device;
import com.waxmonster.waxlab.view.TimecodeLineConfigPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FaderConfigOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 176216250593550367L;
    private static final Logger logger = Logger.getLogger(FaderConfigOptionsPanel.class.getName());
    public static final String PROPERTY_FADER_CONFIG = "faderConfig";
    private DefaultMidiFaderConfig faderConfig;
    private Device device;
    private FaderInitPosControlImpl faderInitPosControl;
    private int channelCount = 2;
    private String[] channelNames;
    private String[] channelTips;
    private boolean refreshing;
    private JTextField textFieldName;
    private JLabel labelName;
    private JLabel labelType;
    private JLabel labelCurve;
    private JLabel labelPreview;
    private JLabel labelInitPos;
    private JCheckBox checkBoxReverseMode;
    private FaderCurveChooser faderCurveChooser;
    private FaderCurveViewer faderCurveViewer;
    private FaderControlPanel faderControlPanel;
    private JPanel panelFaderCurveView;
    private JLabel lblMapping;
    private JPanel panel;
    private JButton btnFaderMidiMapping;
    private JTextField textFieldFaderMidiMapping;
    private JComboBox comboBoxFaderType;
    private JCheckBox chckbxFaderEnabled;
    private JPanel panelFillEnabled;
    private JLabel lblChannels;
    private JPanel panelCurve;
    private ChannelMaskEditor channelMaskEditor;
    private JPanel panelChannels;

    public FaderConfigOptionsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelFaderConfig = new JPanel();
        GridBagConstraints gbc_panelFaderConfig = new GridBagConstraints();
        gbc_panelFaderConfig.fill = 1;
        gbc_panelFaderConfig.gridx = 0;
        gbc_panelFaderConfig.gridy = 0;
        this.add((Component)panelFaderConfig, gbc_panelFaderConfig);
        GridBagLayout gbl_panelFaderConfig = new GridBagLayout();
        gbl_panelFaderConfig.columnWidths = new int[]{0, 0, 0};
        gbl_panelFaderConfig.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panelFaderConfig.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelFaderConfig.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelFaderConfig.setLayout(gbl_panelFaderConfig);
        this.labelName = new JLabel("Name:");
        this.labelName.setToolTipText("Fader name");
        GridBagConstraints gbc_labelName = new GridBagConstraints();
        gbc_labelName.anchor = 17;
        gbc_labelName.insets = new Insets(0, 0, 5, 5);
        gbc_labelName.gridx = 0;
        gbc_labelName.gridy = 0;
        panelFaderConfig.add((Component)this.labelName, gbc_labelName);
        this.textFieldName = new JTextField();
        this.textFieldName.setToolTipText("Fader name");
        this.textFieldName.setOpaque(false);
        this.textFieldName.setColumns(10);
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.weightx = 1.0;
        gbc_textFieldName.fill = 2;
        gbc_textFieldName.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 0;
        panelFaderConfig.add((Component)this.textFieldName, gbc_textFieldName);
        this.labelType = new JLabel("Type:");
        this.labelType.setToolTipText("Fader type");
        GridBagConstraints gbc_labelType = new GridBagConstraints();
        gbc_labelType.anchor = 18;
        gbc_labelType.insets = new Insets(4, 0, 5, 5);
        gbc_labelType.gridx = 0;
        gbc_labelType.gridy = 1;
        panelFaderConfig.add((Component)this.labelType, gbc_labelType);
        JPanel panel_1 = new JPanel();
        panel_1.setOpaque(false);
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.fill = 1;
        gbc_panel_1.insets = new Insets(0, 0, 5, 0);
        gbc_panel_1.gridx = 1;
        gbc_panel_1.gridy = 1;
        panelFaderConfig.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        this.comboBoxFaderType = new JComboBox();
        this.comboBoxFaderType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!FaderConfigOptionsPanel.this.refreshing) {
                    FaderConfigOptionsPanel.this.apply();
                    FaderConfigOptionsPanel.this.refreshFaderCurveViewer();
                }
            }
        });
        GridBagConstraints gbc_comboBoxFaderType = new GridBagConstraints();
        gbc_comboBoxFaderType.insets = new Insets(0, 0, 0, 5);
        gbc_comboBoxFaderType.fill = 2;
        gbc_comboBoxFaderType.gridx = 0;
        gbc_comboBoxFaderType.gridy = 0;
        panel_1.add((Component)this.comboBoxFaderType, gbc_comboBoxFaderType);
        this.panelFillEnabled = new JPanel();
        this.panelFillEnabled.setOpaque(false);
        GridBagConstraints gbc_panelFillEnabled = new GridBagConstraints();
        gbc_panelFillEnabled.weightx = 1.0;
        gbc_panelFillEnabled.fill = 1;
        gbc_panelFillEnabled.gridx = 1;
        gbc_panelFillEnabled.gridy = 0;
        panel_1.add((Component)this.panelFillEnabled, gbc_panelFillEnabled);
        this.lblChannels = new JLabel("Channels:");
        this.lblChannels.setToolTipText("Channels to fade");
        GridBagConstraints gbc_lblChannels = new GridBagConstraints();
        gbc_lblChannels.anchor = 17;
        gbc_lblChannels.insets = new Insets(0, 0, 5, 5);
        gbc_lblChannels.gridx = 0;
        gbc_lblChannels.gridy = 2;
        panelFaderConfig.add((Component)this.lblChannels, gbc_lblChannels);
        this.panelChannels = new JPanel();
        GridBagConstraints gbc_panelChannels = new GridBagConstraints();
        gbc_panelChannels.insets = new Insets(0, 0, 5, 0);
        gbc_panelChannels.fill = 1;
        gbc_panelChannels.gridx = 1;
        gbc_panelChannels.gridy = 2;
        panelFaderConfig.add((Component)this.panelChannels, gbc_panelChannels);
        GridBagLayout gbl_panelChannels = new GridBagLayout();
        gbl_panelChannels.columnWidths = new int[]{0, 0, 0};
        gbl_panelChannels.rowHeights = new int[]{0, 0};
        gbl_panelChannels.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelChannels.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelChannels.setLayout(gbl_panelChannels);
        this.chckbxFaderEnabled = new JCheckBox("Enabled:");
        GridBagConstraints gbc_chckbxFaderEnabled = new GridBagConstraints();
        gbc_chckbxFaderEnabled.insets = new Insets(0, 0, 0, 5);
        gbc_chckbxFaderEnabled.gridx = 0;
        gbc_chckbxFaderEnabled.gridy = 0;
        this.panelChannels.add((Component)this.chckbxFaderEnabled, gbc_chckbxFaderEnabled);
        this.chckbxFaderEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!FaderConfigOptionsPanel.this.refreshing) {
                    FaderConfigOptionsPanel.this.apply();
                    FaderConfigOptionsPanel.this.checkEnable();
                    FaderConfigOptionsPanel.this.refreshFaderCurveViewer();
                }
            }
        });
        this.chckbxFaderEnabled.setToolTipText("Fader enabled ?");
        this.channelMaskEditor = new ChannelMaskEditor();
        GridBagConstraints gbc_channelMaskEditor = new GridBagConstraints();
        gbc_channelMaskEditor.gridx = 1;
        gbc_channelMaskEditor.gridy = 0;
        this.panelChannels.add((Component)this.channelMaskEditor, gbc_channelMaskEditor);
        this.channelMaskEditor.setChannelCount(3);
        this.channelMaskEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!FaderConfigOptionsPanel.this.refreshing) {
                    FaderConfigOptionsPanel.this.apply();
                    FaderConfigOptionsPanel.this.refreshFaderCurveViewer();
                }
            }
        });
        this.labelCurve = new JLabel("Curve:");
        this.labelCurve.setToolTipText("Fader curve");
        GridBagConstraints gbc_labelCurve = new GridBagConstraints();
        gbc_labelCurve.anchor = 17;
        gbc_labelCurve.insets = new Insets(0, 0, 5, 5);
        gbc_labelCurve.gridx = 0;
        gbc_labelCurve.gridy = 3;
        panelFaderConfig.add((Component)this.labelCurve, gbc_labelCurve);
        this.panelCurve = new JPanel();
        GridBagConstraints gbc_panelCurve = new GridBagConstraints();
        gbc_panelCurve.weightx = 1.0;
        gbc_panelCurve.insets = new Insets(0, 0, 5, 0);
        gbc_panelCurve.fill = 1;
        gbc_panelCurve.gridx = 1;
        gbc_panelCurve.gridy = 3;
        panelFaderConfig.add((Component)this.panelCurve, gbc_panelCurve);
        GridBagLayout gbl_panelCurve = new GridBagLayout();
        gbl_panelCurve.columnWidths = new int[]{0, 0, 0};
        gbl_panelCurve.rowHeights = new int[]{0, 0};
        gbl_panelCurve.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelCurve.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelCurve.setLayout(gbl_panelCurve);
        this.checkBoxReverseMode = new JCheckBox("Reverse");
        GridBagConstraints gbc_checkBoxReverseMode = new GridBagConstraints();
        gbc_checkBoxReverseMode.insets = new Insets(0, 0, 0, 5);
        gbc_checkBoxReverseMode.gridx = 0;
        gbc_checkBoxReverseMode.gridy = 0;
        this.panelCurve.add((Component)this.checkBoxReverseMode, gbc_checkBoxReverseMode);
        this.checkBoxReverseMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!FaderConfigOptionsPanel.this.refreshing) {
                    FaderConfigOptionsPanel.this.apply();
                    FaderConfigOptionsPanel.this.refreshFaderCurveViewer();
                }
            }
        });
        this.checkBoxReverseMode.setToolTipText("Reverse ? (Hamster-Switch)");
        this.faderCurveChooser = new FaderCurveChooser();
        GridBagConstraints gbc_faderCurveChooser = new GridBagConstraints();
        gbc_faderCurveChooser.fill = 2;
        gbc_faderCurveChooser.weightx = 1.0;
        gbc_faderCurveChooser.gridx = 1;
        gbc_faderCurveChooser.gridy = 0;
        this.panelCurve.add((Component)this.faderCurveChooser, gbc_faderCurveChooser);
        this.faderCurveChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!FaderConfigOptionsPanel.this.refreshing) {
                    FaderConfigOptionsPanel.this.apply();
                    FaderConfigOptionsPanel.this.refreshFaderCurveViewer();
                }
            }
        });
        GridBagLayout gbl_faderCurveChooser = (GridBagLayout)this.faderCurveChooser.getLayout();
        gbl_faderCurveChooser.rowWeights = new double[]{0.0};
        gbl_faderCurveChooser.rowHeights = new int[]{0};
        gbl_faderCurveChooser.columnWeights = new double[]{0.0, 0.0};
        gbl_faderCurveChooser.columnWidths = new int[]{0, 0};
        this.faderCurveChooser.setToolTipText("Fader curve");
        this.faderCurveChooser.setOpaque(false);
        this.labelPreview = new JLabel("Preview:");
        this.labelPreview.setToolTipText("Fader curve preview");
        GridBagConstraints gbc_labelPreview = new GridBagConstraints();
        gbc_labelPreview.anchor = 18;
        gbc_labelPreview.insets = new Insets(4, 0, 5, 5);
        gbc_labelPreview.gridx = 0;
        gbc_labelPreview.gridy = 4;
        panelFaderConfig.add((Component)this.labelPreview, gbc_labelPreview);
        this.panelFaderCurveView = new JPanel();
        this.panelFaderCurveView.setToolTipText("Fader curve preview");
        this.panelFaderCurveView.setOpaque(false);
        this.panelFaderCurveView.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_panelFaderCurveView = new GridBagConstraints();
        gbc_panelFaderCurveView.weighty = 1.0;
        gbc_panelFaderCurveView.weightx = 1.0;
        gbc_panelFaderCurveView.fill = 1;
        gbc_panelFaderCurveView.insets = new Insets(0, 0, 5, 0);
        gbc_panelFaderCurveView.gridx = 1;
        gbc_panelFaderCurveView.gridy = 4;
        panelFaderConfig.add((Component)this.panelFaderCurveView, gbc_panelFaderCurveView);
        this.panelFaderCurveView.setLayout(new GridLayout(1, 0, 0, 0));
        this.faderCurveViewer = new FaderCurveViewer();
        this.faderCurveViewer.setOrientation(1);
        this.panelFaderCurveView.add((Component)this.faderCurveViewer);
        this.labelInitPos = new JLabel("Initial Pos.:");
        this.labelInitPos.setToolTipText("Initial fader position");
        GridBagConstraints gbc_labelInitPos = new GridBagConstraints();
        gbc_labelInitPos.anchor = 17;
        gbc_labelInitPos.insets = new Insets(0, 0, 5, 5);
        gbc_labelInitPos.gridx = 0;
        gbc_labelInitPos.gridy = 5;
        panelFaderConfig.add((Component)this.labelInitPos, gbc_labelInitPos);
        this.faderControlPanel = new FaderControlPanel();
        this.faderControlPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!FaderConfigOptionsPanel.this.refreshing) {
                    FaderConfigOptionsPanel.this.apply();
                }
            }
        });
        this.faderControlPanel.setToolTipText("Initial fader position");
        this.faderControlPanel.setOrientation(0);
        this.faderControlPanel.setOpaque(false);
        GridBagConstraints gbc_faderControlPanel = new GridBagConstraints();
        gbc_faderControlPanel.insets = new Insets(0, 0, 5, 0);
        gbc_faderControlPanel.weightx = 1.0;
        gbc_faderControlPanel.fill = 1;
        gbc_faderControlPanel.gridx = 1;
        gbc_faderControlPanel.gridy = 5;
        panelFaderConfig.add((Component)this.faderControlPanel, gbc_faderControlPanel);
        this.lblMapping = new JLabel("Mapping:");
        this.lblMapping.setToolTipText("MIDI fader mapping");
        GridBagConstraints gbc_lblMapping = new GridBagConstraints();
        gbc_lblMapping.anchor = 17;
        gbc_lblMapping.insets = new Insets(0, 0, 0, 5);
        gbc_lblMapping.gridx = 0;
        gbc_lblMapping.gridy = 6;
        panelFaderConfig.add((Component)this.lblMapping, gbc_lblMapping);
        this.panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 1;
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 6;
        panelFaderConfig.add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.textFieldFaderMidiMapping = new JTextField();
        this.textFieldFaderMidiMapping.setToolTipText("MIDI fader mapping");
        this.textFieldFaderMidiMapping.setEditable(false);
        this.textFieldFaderMidiMapping.setOpaque(false);
        GridBagConstraints gbc_textFieldFaderMidiMapping = new GridBagConstraints();
        gbc_textFieldFaderMidiMapping.weightx = 1.0;
        gbc_textFieldFaderMidiMapping.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldFaderMidiMapping.fill = 1;
        gbc_textFieldFaderMidiMapping.gridx = 0;
        gbc_textFieldFaderMidiMapping.gridy = 0;
        this.panel.add((Component)this.textFieldFaderMidiMapping, gbc_textFieldFaderMidiMapping);
        this.textFieldFaderMidiMapping.setColumns(10);
        this.btnFaderMidiMapping = new JButton("");
        this.btnFaderMidiMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaderConfigOptionsPanel.this.showFaderMidiMappingDialog();
            }
        });
        this.btnFaderMidiMapping.setMargin(new Insets(4, 4, 4, 4));
        this.btnFaderMidiMapping.setIcon(new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/midi_mapping_icon16.png")));
        this.btnFaderMidiMapping.setToolTipText("MIDI fader mapping...");
        GridBagConstraints gbc_btnFaderMidiMapping = new GridBagConstraints();
        gbc_btnFaderMidiMapping.gridx = 1;
        gbc_btnFaderMidiMapping.gridy = 0;
        this.panel.add((Component)this.btnFaderMidiMapping, gbc_btnFaderMidiMapping);
        this.initFaderConfigOptionsPanel();
    }

    protected void initFaderConfigOptionsPanel() {
        this.faderInitPosControl = new FaderInitPosControlImpl();
        this.faderControlPanel.setControl((Control)this.faderInitPosControl);
        this.textFieldName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void handle(DocumentEvent e) {
                if (!FaderConfigOptionsPanel.this.refreshing) {
                    FaderConfigOptionsPanel.this.apply();
                }
            }
        });
    }

    protected JLabel getLabelName() {
        return this.labelName;
    }

    protected JLabel getLabelType() {
        return this.labelType;
    }

    protected JLabel getLabelCurve() {
        return this.labelCurve;
    }

    protected JLabel getLabelPreview() {
        return this.labelPreview;
    }

    protected JLabel getLabelInitPos() {
        return this.labelInitPos;
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }

    protected JCheckBox getCheckBoxReverseMode() {
        return this.checkBoxReverseMode;
    }

    protected FaderCurveChooser getFaderCurveChooser() {
        return this.faderCurveChooser;
    }

    protected FaderCurveViewer getFaderCurveViewer() {
        return this.faderCurveViewer;
    }

    protected FaderControlPanel getFaderControlPanel() {
        return this.faderControlPanel;
    }

    public DefaultMidiFaderConfig getFaderConfig() {
        return this.faderConfig;
    }

    public void setFaderConfig(DefaultMidiFaderConfig faderConfig) {
        this.faderConfig = faderConfig;
        this.refresh();
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int channelCount) {
        if (this.channelCount == channelCount) {
            return;
        }
        this.channelCount = channelCount;
        String[] chNames = null;
        switch (channelCount) {
            case 1: {
                chNames = new String[]{"1"};
                break;
            }
            case 2: {
                chNames = new String[]{"L", "R"};
            }
        }
        this.channelNames = chNames;
        this.channelTips = null;
        this.channelMaskEditor.setChannelNames(this.channelNames);
        this.channelMaskEditor.setChannelTips(this.channelTips);
        this.channelMaskEditor.setChannelCount(channelCount);
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            String faderName = null;
            int faderType = -1;
            boolean faderEnabled = false;
            int channelMask = -1;
            boolean reverseMode = false;
            float initValue = 0.0f;
            FaderCurve faderCurve = null;
            DefaultMidiFaderConfig faderConfig = this.faderConfig;
            if (faderConfig != null) {
                faderName = faderConfig.getFaderName();
                faderType = faderConfig.getFaderType();
                faderEnabled = faderConfig.isFaderEnabled();
                channelMask = faderConfig.getChannelMask();
                reverseMode = faderConfig.isReverseMode();
                initValue = faderConfig.getInitValue();
                faderCurve = faderConfig.getFaderCurve();
            }
            if (faderName == null) {
                faderName = "";
            }
            this.textFieldName.setText(faderName);
            this.comboBoxFaderType.removeAllItems();
            int selFaderTypeIndex = -1;
            int[] faderTypes = DefaultMidiFaderConfig.getFaderTypes();
            for (int i = 0; i < faderTypes.length; ++i) {
                int fType = faderTypes[i];
                if (fType == faderType) {
                    selFaderTypeIndex = i;
                }
                this.comboBoxFaderType.addItem(String.valueOf(DefaultMidiFaderConfig.getFaderTypeName((int)fType)));
            }
            if (selFaderTypeIndex >= 0) {
                this.comboBoxFaderType.setSelectedIndex(selFaderTypeIndex);
            }
            this.chckbxFaderEnabled.setSelected(faderEnabled);
            this.channelMaskEditor.setChannelMask(channelMask);
            this.checkBoxReverseMode.setSelected(reverseMode);
            this.faderInitPosControl.setFloat(initValue);
            this.faderCurveChooser.setFaderCurve(faderCurve);
            this.refreshFaderCurveViewer();
            this.refreshMidiMappingInfo();
        }
        finally {
            this.refreshing = false;
        }
        this.checkEnable();
    }

    protected void refreshFaderCurveViewer() {
        if (this.faderCurveViewer == null) {
            return;
        }
        this.faderCurveViewer.removeAllFaderCurves();
        DefaultMidiFaderConfig faderConfig = this.faderConfig;
        if (faderConfig != null && faderConfig.isFaderEnabled()) {
            FaderCurve curve = faderConfig.getFaderCurve();
            int channelMask = faderConfig.getChannelMask();
            if (Fader.areAllChannelsMasked((int)channelMask, (int)this.channelCount)) {
                curve = null;
            }
            if (curve != null) {
                boolean reverse = false;
                switch (faderConfig.getFaderType()) {
                    case 1: {
                        reverse = !reverse;
                        break;
                    }
                    case 3: {
                        boolean bl = reverse = !reverse;
                    }
                }
                if (faderConfig.isReverseMode()) {
                    boolean bl = reverse = !reverse;
                }
                if (reverse) {
                    curve = FaderCurveUtil.getReversedFaderCurve((FaderCurve)curve);
                }
                this.faderCurveViewer.addFaderCurve(curve, Color.BLUE);
                this.faderCurveViewer.setOrientation(1);
            }
        }
        this.faderCurveViewer.validate();
        this.faderCurveViewer.repaint();
    }

    protected void refreshMidiMappingInfo() {
        if (this.textFieldFaderMidiMapping == null) {
            return;
        }
        MidiMapping mapping = null;
        DefaultMidiFaderConfig faderConfig = this.faderConfig;
        if (faderConfig != null) {
            mapping = faderConfig.getMidiMapping();
        }
        String text = null;
        if (mapping != null) {
            text = mapping.toString();
        }
        if (text == null) {
            text = "";
        }
        this.textFieldFaderMidiMapping.setText(text);
    }

    protected void checkEnable() {
        boolean faderSelected = this.faderConfig != null;
        this.labelName.setEnabled(faderSelected);
        this.textFieldName.setEnabled(faderSelected);
        this.labelType.setEnabled(faderSelected);
        this.comboBoxFaderType.setEnabled(faderSelected);
        this.chckbxFaderEnabled.setEnabled(faderSelected);
        this.lblChannels.setEnabled(faderSelected);
        this.checkBoxReverseMode.setEnabled(faderSelected);
        this.labelCurve.setEnabled(faderSelected);
        this.faderCurveChooser.setEnabled(faderSelected);
        this.labelPreview.setEnabled(faderSelected);
        this.panelFaderCurveView.setEnabled(faderSelected);
        this.faderCurveViewer.setEnabled(faderSelected);
        this.labelInitPos.setEnabled(faderSelected);
        this.faderControlPanel.setEnabled(faderSelected);
        this.lblMapping.setEnabled(faderSelected);
        this.textFieldFaderMidiMapping.setEnabled(faderSelected);
        this.btnFaderMidiMapping.setEnabled(faderSelected);
        int channelMask = -1;
        DefaultMidiFaderConfig conf = this.getFaderConfig();
        if (this.chckbxFaderEnabled.isSelected() && conf != null) {
            channelMask = conf.getChannelMask();
        }
        this.channelMaskEditor.setChannelMask(channelMask);
        this.channelMaskEditor.setEnabled(faderSelected && this.chckbxFaderEnabled.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply() {
        DefaultMidiFaderConfig config = this.getFaderConfig();
        if (config == null) {
            return;
        }
        config.setFaderName(this.textFieldName.getText());
        config.setFaderType(DefaultMidiFaderConfig.getFaderType((Object)this.comboBoxFaderType.getSelectedItem()));
        config.setFaderEnabled(this.chckbxFaderEnabled.isSelected());
        if (this.chckbxFaderEnabled.isSelected() && this.channelMaskEditor.isEnabled()) {
            config.setChannelMask(this.channelMaskEditor.getChannelMask());
        }
        config.setReverseMode(this.checkBoxReverseMode.isSelected());
        config.setInitValue(this.faderInitPosControl.getFloat());
        config.setFaderCurve(this.faderCurveChooser.getFaderCurve());
        try {
            this.refreshing = true;
            this.firePropertyChange(PROPERTY_FADER_CONFIG, null, config);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JPanel getPanelFaderCurveView() {
        return this.panelFaderCurveView;
    }

    protected JTextField getTextFieldFaderMidiMapping() {
        return this.textFieldFaderMidiMapping;
    }

    protected JLabel getLblMapping() {
        return this.lblMapping;
    }

    protected JButton getBtnFaderMidiMapping() {
        return this.btnFaderMidiMapping;
    }

    protected void showFaderMidiMappingDialog() {
        if (this.device == null) {
            return;
        }
        DefaultMidiFaderConfig faderConfig = this.getFaderConfig();
        if (faderConfig == null) {
            return;
        }
        try {
            int index;
            int channel;
            String dummyFaderActionName = "fade";
            DummyMidiAction dummyFaderAction = new DummyMidiAction(dummyFaderActionName);
            MidiMappingManagerPanel panel = new MidiMappingManagerPanel();
            panel.setStudio(this.device.getStudio());
            panel.setDeviceName("FaderMidiMapping");
            panel.setMidiFactory(DefaultMidiFactory.getInstance());
            panel.setMidiFormatter((MidiFormatter)DefaultMidiFormatter.getSharedInstance());
            panel.setAvailableActions(new MidiAction[]{dummyFaderAction});
            MidiMapping origMapping = faderConfig.getMidiMapping();
            if (origMapping != null) {
                channel = origMapping.getChannel();
                index = origMapping.getIndex();
            } else {
                channel = 0;
                index = -1;
            }
            MidiMapping cloneMapping = new MidiMapping(channel, 176, index, dummyFaderActionName);
            panel.setMappings(new MidiMapping[]{cloneMapping});
            String title = "MIDI Fader Mapping";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            MidiMapping newMapping = null;
            MidiMapping[] newMappings = panel.getMappings();
            if (newMappings != null && newMappings.length > 0) {
                newMapping = newMappings[0];
            }
            faderConfig.setMidiMapping(newMapping);
            this.refreshMidiMappingInfo();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected JComboBox getComboBoxFaderType() {
        return this.comboBoxFaderType;
    }

    protected JCheckBox getChckbxFaderEnabled() {
        return this.chckbxFaderEnabled;
    }

    protected JLabel getLblChannels() {
        return this.lblChannels;
    }

    protected ChannelMaskEditor getChannelMaskEditor() {
        return this.channelMaskEditor;
    }

    protected static class DummyMidiAction
    extends AbstractMidiAction {
        public DummyMidiAction(String name) {
            super(name);
        }

        public void invoke(long time, int status, int data1, int data2) {
        }
    }

    protected class FaderInitPosControlImpl
    extends AbstractFloatControl {
        public FaderInitPosControlImpl() {
            this.setMinimum(0.0f);
            this.setMaximum(1.0f);
        }

        protected void applyFloat(float v) {
            if (!FaderConfigOptionsPanel.this.refreshing) {
                FaderConfigOptionsPanel.this.apply();
            }
        }
    }
}

