/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMappable;
import com.waxmonster.midi.MidiMapper;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.AbstractMidiMapper;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineMidiMapping;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.util.LineWrapper;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.LineHeaderTitle;
import com.waxmonster.waxlab.view.LineWidgetToggleButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class LineHeaderPanel
extends JPanel
implements MidiMappable {
    private static final long serialVersionUID = 6284736697571123093L;
    private AbstractLineWrapper lineWrapper;
    private int orientation = -1;
    private boolean horiz;
    private boolean lineSelected;
    private boolean lineFocused;
    private final MidiMapperImpl midiMapper;
    private LineHeaderTitle lineHeaderTitle;
    private JPanel widgetButtonsPanel;
    private List widgetToggleButtons;
    private int titleSize;
    private Insets widgetButtonMargin;
    private Border normalViewBorder;
    private Color selectedViewBackground = Color.LIGHT_GRAY;
    private Color selectedViewForeground = Color.BLACK;
    private Border selectedViewBorder = new LineBorder(Color.GRAY, 1);
    private Font selectedViewFont;
    private Color focusViewBackground = Color.LIGHT_GRAY;
    private Color focusViewForeground = Color.BLACK;
    private Border focusViewBorder = new LineBorder(Color.GRAY, 2);
    private Font focusViewFont;

    public LineHeaderPanel() {
        this.midiMapper = new MidiMapperImpl();
        this.widgetToggleButtons = new ArrayList();
        this.lineHeaderTitle = new LineHeaderTitle(this);
        this.widgetButtonsPanel = new JPanel();
        this.widgetButtonsPanel.setLayout(new GridBagLayout());
        this.widgetButtonMargin = new Insets(0, 0, 0, 0);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
    }

    public AbstractLineWrapper getLineWrapper() {
        return this.lineWrapper;
    }

    public void setLineWrapper(AbstractLineWrapper lineWrapper) {
        this.lineWrapper = lineWrapper;
        this.refreshWidgetToggleButtons();
        this.refresh();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.horiz = orientation == 0 || orientation == 1;
        this.refresh();
    }

    public MidiMapper getMidiMapper() {
        return this.midiMapper;
    }

    public boolean isLineSelected() {
        return this.lineSelected;
    }

    public void setLineSelected(boolean lineSelected) {
        this.lineSelected = lineSelected;
        this.invalidate();
    }

    public boolean isLineFocused() {
        return this.lineFocused;
    }

    public void setLineFocused(boolean lineFocused) {
        this.lineFocused = lineFocused;
        this.invalidate();
    }

    public int getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(int titleSize) {
        this.titleSize = titleSize;
        this.lineHeaderTitle.setPreferredSize(new Dimension(titleSize, titleSize));
        this.lineHeaderTitle.setMinimumSize(new Dimension(titleSize, titleSize));
    }

    public Border getSelectedViewBorder() {
        return this.selectedViewBorder;
    }

    public void setSelectedViewBorder(Border selectedViewBorder) {
        this.selectedViewBorder = selectedViewBorder;
    }

    public Color getSelectedViewForeground() {
        return this.selectedViewForeground;
    }

    public void setSelectedViewForeground(Color selectedViewForeground) {
        this.selectedViewForeground = selectedViewForeground;
    }

    public Font getSelectedViewFont() {
        return this.selectedViewFont;
    }

    public void setSelectedViewFont(Font selectedViewFont) {
        this.selectedViewFont = selectedViewFont;
    }

    public Border getNormalViewBorder() {
        return this.normalViewBorder;
    }

    public void setNormalViewBorder(Border normalViewBorder) {
        this.normalViewBorder = normalViewBorder;
    }

    public Border getFocusViewBorder() {
        return this.focusViewBorder;
    }

    public void setFocusViewBorder(Border focusViewBorder) {
        this.focusViewBorder = focusViewBorder;
    }

    public Color getSelectedViewBackground() {
        return this.selectedViewBackground;
    }

    public void setSelectedViewBackground(Color selectedViewBackground) {
        this.selectedViewBackground = selectedViewBackground;
    }

    public Color getFocusViewBackground() {
        return this.focusViewBackground;
    }

    public void setFocusViewBackground(Color focusViewBackground) {
        this.focusViewBackground = focusViewBackground;
    }

    public Color getFocusViewForeground() {
        return this.focusViewForeground;
    }

    public void setFocusViewForeground(Color focusViewForeground) {
        this.focusViewForeground = focusViewForeground;
    }

    public Font getFocusViewFont() {
        return this.focusViewFont;
    }

    public void setFocusViewFont(Font focusViewFont) {
        this.focusViewFont = focusViewFont;
    }

    public void refresh() {
        this.removeAll();
        int gridWidgets = 0;
        int gridTitle = 1;
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.horiz) {
            gbc.gridx = gridTitle;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
        } else {
            gbc.gridx = 0;
            gbc.gridy = gridTitle;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
        }
        gbc.fill = 1;
        this.add((Component)this.lineHeaderTitle, gbc);
        this.widgetButtonsPanel.removeAll();
        int num = this.widgetToggleButtons.size();
        for (int i = 0; i < num; ++i) {
            LineWidgetToggleButton button = (LineWidgetToggleButton)this.widgetToggleButtons.get(i);
            gbc = new GridBagConstraints();
            if (this.horiz) {
                gbc.gridx = 0;
                gbc.gridy = i;
            } else {
                gbc.gridx = i;
                gbc.gridy = 0;
            }
            this.widgetButtonsPanel.add((Component)button, gbc);
        }
        gbc = new GridBagConstraints();
        if (this.horiz) {
            gbc.gridx = gridWidgets;
            gbc.gridy = 0;
        } else {
            gbc.gridx = 0;
            gbc.gridy = gridWidgets;
        }
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.widgetButtonsPanel, gbc);
    }

    protected synchronized void refreshWidgetToggleButtons() {
        Line line;
        int num = this.widgetToggleButtons.size();
        for (int i = 0; i < num; ++i) {
            LineWidgetToggleButton button = (LineWidgetToggleButton)this.widgetToggleButtons.get(i);
            this.midiMapper.unregisterMidiAction(button);
        }
        this.widgetToggleButtons.clear();
        AbstractLineWrapper lineWrapper = this.lineWrapper;
        if (lineWrapper != null && (line = lineWrapper.getLine()) != null) {
            LineWidget[] widgets = line.getLineWidgets();
            num = widgets == null ? 0 : widgets.length;
            for (int i = 0; i < num; ++i) {
                LineWidget widget = widgets[i];
                if (widget == null) continue;
                String name = widget.getName();
                if (name == null) {
                    name = "";
                }
                String tooltip = widget.getTooltip();
                LineWidgetToggleButton button = new LineWidgetToggleButton();
                button.setLineWrapper(lineWrapper);
                button.setLineWidget(widget);
                button.setMargin(this.widgetButtonMargin);
                button.setName(name);
                button.setToolTipText(tooltip);
                button.validate();
                this.widgetToggleButtons.add(button);
                MidiAction toggleMidiAction = widget.getToggleMidiAction();
                if (toggleMidiAction == null) continue;
                String actionName = LineMidiMapping.parseLineAction((String)toggleMidiAction.getName());
                String action = LineMidiMapping.formatLineAction((Line)line, (String)actionName);
                this.midiMapper.registerMidiAction(button, action);
            }
        }
    }

    protected synchronized void refreshWidgetToggleButton(LineWidget widget) {
        int num = this.widgetToggleButtons.size();
        for (int i = 0; i < num; ++i) {
            LineWidgetToggleButton button = (LineWidgetToggleButton)this.widgetToggleButtons.get(i);
            if (button.getLineWidget() != widget) continue;
            button.refresh();
            break;
        }
    }

    protected MidiMapping[] getLineMidiMappings(LineWrapper wrapper) {
        int num;
        if (wrapper == null) {
            return null;
        }
        Line line = wrapper.getLine();
        if (line == null) {
            return null;
        }
        WaxLab waxLab = line.getWaxLab();
        if (waxLab == null) {
            return null;
        }
        MidiMapping[] mappings = waxLab.getMidiMappings();
        int n = num = mappings == null ? 0 : mappings.length;
        if (num < 1) {
            return null;
        }
        String lineName = line.getName();
        if (lineName == null) {
            return null;
        }
        LinkedList<MidiMapping> list = new LinkedList<MidiMapping>();
        for (int i = 0; i < num; ++i) {
            MidiMapping mapping = mappings[i];
            if (mapping == null) continue;
            if (mapping instanceof LineMidiMapping) {
                LineMidiMapping lineMapping = (LineMidiMapping)mapping;
                if (line != lineMapping.getLine()) continue;
                list.add(mapping);
                continue;
            }
            if (!lineName.equals(LineMidiMapping.parseLineName((String)mapping.getAction()))) continue;
            list.add(mapping);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new MidiMapping[list.size()]);
    }

    protected void setLineMidiMappings(LineWrapper wrapper, MidiMapping[] lineMappings) {
        MidiMapping mapping;
        int i;
        if (wrapper == null) {
            return;
        }
        Line line = wrapper.getLine();
        if (line == null) {
            return;
        }
        WaxLab waxLab = line.getWaxLab();
        if (waxLab == null) {
            return;
        }
        MidiMapping[] mappings = waxLab.getMidiMappings();
        int num = mappings == null ? 0 : mappings.length;
        String lineName = line.getName();
        if (lineName == null) {
            return;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        for (i = 0; i < num; ++i) {
            LineMidiMapping lineMapping;
            mapping = mappings[i];
            if (mapping == null || mapping instanceof LineMidiMapping && line == (lineMapping = (LineMidiMapping)mapping).getLine() || lineName.equals(LineMidiMapping.parseLineName((String)mapping.getAction()))) continue;
            list.add(mapping);
        }
        num = lineMappings == null ? 0 : lineMappings.length;
        for (i = 0; i < num; ++i) {
            mapping = lineMappings[i];
            if (mapping == null) continue;
            if (mapping instanceof LineMidiMapping) {
                list.add(mapping);
                continue;
            }
            String actionName = LineMidiMapping.parseLineAction((String)mapping.getAction());
            String action = LineMidiMapping.formatLineAction((Line)line, (String)actionName);
            LineMidiMapping lineMapping = new LineMidiMapping(mapping.getChannel(), mapping.getCommand(), mapping.getIndex(), action, line);
            list.add(lineMapping);
        }
        mappings = list.toArray(new MidiMapping[list.size()]);
        waxLab.setMidiMappings(mappings);
    }

    protected class MidiMapperImpl
    extends AbstractMidiMapper {
        protected MidiMapperImpl() {
        }

        public MidiMapping[] getMidiMappings(Object component) {
            AbstractLineWrapper wrapper = LineHeaderPanel.this.getLineWrapper();
            return LineHeaderPanel.this.getLineMidiMappings(wrapper);
        }

        public void setMidiMappings(Object component, MidiMapping[] mappings) {
            AbstractLineWrapper wrapper = LineHeaderPanel.this.getLineWrapper();
            LineHeaderPanel.this.setLineMidiMappings(wrapper, mappings);
        }
    }
}

