/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.LineHeaderPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class LineHeaderTitle
extends JComponent {
    private static final long serialVersionUID = 3218479118651821846L;
    private LineHeaderPanel lineHeaderPanel;

    public LineHeaderTitle(LineHeaderPanel lineHeaderPanel) {
        this.lineHeaderPanel = lineHeaderPanel;
        this.setOpaque(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean horiz;
        AbstractLineWrapper wrapper;
        Font focFont;
        Font selFont;
        super.paintComponent(g);
        LineHeaderPanel lhp = this.lineHeaderPanel;
        if (lhp == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Color foreground = this.getForeground();
        Font font = this.getFont();
        Color selBackground = lhp.getSelectedViewBackground();
        Color selForeground = lhp.getSelectedViewForeground();
        if (selForeground == null) {
            selForeground = foreground;
        }
        if ((selFont = lhp.getSelectedViewFont()) == null) {
            selFont = font;
        }
        Color focBackground = lhp.getFocusViewBackground();
        Color focForeground = lhp.getFocusViewForeground();
        if (focForeground == null) {
            focForeground = foreground;
        }
        if ((focFont = lhp.getFocusViewFont()) == null) {
            focFont = font;
        }
        if ((wrapper = lhp.getLineWrapper()) == null) {
            return;
        }
        Line line = wrapper.getLine();
        if (line == null) {
            return;
        }
        String title = line.getName();
        if (title == null) {
            title = "";
        }
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        Border border = lhp.getNormalViewBorder();
        Font textFont = font;
        Color textColor = foreground;
        Color backColor = null;
        if (lhp.isLineSelected()) {
            if (lhp.isLineFocused()) {
                border = lhp.getFocusViewBorder();
                textFont = focFont;
                textColor = focForeground;
                backColor = focBackground;
            } else {
                border = lhp.getSelectedViewBorder();
                textFont = selFont;
                textColor = selForeground;
                backColor = selBackground;
            }
        }
        if (backColor != null) {
            g.setColor(backColor);
            g.fillRect(x, y, w, h);
        }
        if (border != null) {
            border.paintBorder(this, g, x, y, w, h);
        }
        Graphics2D gt = (Graphics2D)g2d.create(x, y, w, h);
        FontMetrics fm = gt.getFontMetrics();
        int tw = fm.stringWidth(title);
        int asc = fm.getAscent();
        gt.setFont(textFont);
        gt.setColor(textColor);
        int orient = lhp.getOrientation();
        boolean bl = horiz = orient == 0 || orient == 1;
        if (horiz) {
            gt.rotate(-1.5707963267948966);
            gt.drawString(title, -h / 2 - tw / 2, asc + 1);
        } else {
            gt.drawString(title, w / 2 - tw / 2, asc + 1);
        }
        gt.dispose();
    }
}

