/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.swing.BorderUtil;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import java.awt.event.ItemEvent;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class LineWidgetToggleButton
extends JToggleButton {
    private static final long serialVersionUID = 6047982264259065812L;
    private LineWidget lineWidget;
    private AbstractLineWrapper lineWrapper;
    private int iconKind = 1;
    private boolean refreshing;

    public LineWidgetToggleButton() {
        BorderUtil.setCompoundJToggleButtonBorder((JToggleButton)this);
    }

    public LineWidget getLineWidget() {
        return this.lineWidget;
    }

    public void setLineWidget(LineWidget lineWidget) {
        this.lineWidget = lineWidget;
        this.refresh();
    }

    public AbstractLineWrapper getLineWrapper() {
        return this.lineWrapper;
    }

    public void setLineWrapper(AbstractLineWrapper lineWrapper) {
        this.lineWrapper = lineWrapper;
        this.refresh();
    }

    public int getIconKind() {
        return this.iconKind;
    }

    public void setIconKind(int iconKind) {
        this.iconKind = iconKind;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            boolean selected = false;
            LineWidget widget = this.getLineWidget();
            if (widget != null) {
                selected = widget.isSelected();
                Icon icon = selected ? (widget.isActive() ? widget.getActiveIcon(this.iconKind) : widget.getSelectedIcon(this.iconKind)) : widget.getUnselectedIcon(this.iconKind);
                if (icon != this.getIcon()) {
                    this.setIcon(icon);
                }
            }
            if (selected != this.isSelected()) {
                this.setSelected(selected);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    @Override
    protected void fireItemStateChanged(ItemEvent event) {
        boolean selected;
        boolean enabled;
        super.fireItemStateChanged(event);
        if (!this.refreshing && (enabled = this.apply(selected = event.getStateChange() == 1)) != selected) {
            this.refresh();
        }
    }

    protected boolean apply(boolean selected) {
        Line line;
        LineWidget widget = this.getLineWidget();
        if (widget != null && selected != widget.isSelected() && (line = widget.getLine()) != null && line instanceof AbstractLine) {
            AbstractLine al = (AbstractLine)line;
            al.setLineWidgetSelected(widget, selected);
            return al.isLineWidgetSelected(widget);
        }
        return false;
    }
}

