/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.studio.PortType;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.MidiLineConfig;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.view.CommonLineConfigPanel;
import com.waxmonster.waxlab.view.TimecodeLineConfigPanel;
import com.waxmonster.waxlab.view.WaxLabPortChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MidiLineConfigPanel
extends JPanel {
    private static final long serialVersionUID = 5574045480451481263L;
    private static final String HIDE_CONTROL_DEFAULT = "<default>";
    private static final String HIDE_CONTROL_1_SECOND = "1000";
    private static final String HIDE_CONTROL_10_SECONDS = "10000";
    private WaxLabPortInfo[] waxLabPorts;
    private MidiLineConfig midiLineConfig;
    private boolean refreshing;
    private WaxLabPortChooser waxLabPortChooserRec;
    private WaxLabPortChooser waxLabPortChooserPlay;
    private JCheckBox chckbxRecording;
    private JCheckBox chckbxPlayback;
    private JLabel lblInputPort;
    private JLabel lblOutputPort;
    private CommonLineConfigPanel commonLineConfigPanel;
    private JPanel panelMidiViewOptions;
    private JPanel panelHideInactiveControls;
    private JCheckBox chckbxHideInactiveControls;
    private JLabel lblHideControlMillis;
    private JComboBox comboBoxHideInactiveControls;
    private JLabel lblTickRate;
    private JComboBox comboBoxTickRate;

    public MidiLineConfigPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.commonLineConfigPanel = new CommonLineConfigPanel();
        GridBagConstraints gbc_commonLineConfigPanel = new GridBagConstraints();
        gbc_commonLineConfigPanel.insets = new Insets(0, 0, 5, 0);
        gbc_commonLineConfigPanel.fill = 1;
        gbc_commonLineConfigPanel.gridx = 0;
        gbc_commonLineConfigPanel.gridy = 0;
        this.add((Component)this.commonLineConfigPanel, gbc_commonLineConfigPanel);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setTabLayoutPolicy(1);
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.weighty = 1.0;
        gbc_tabbedPane.weightx = 1.0;
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 1;
        this.add((Component)tabbedPane, gbc_tabbedPane);
        JPanel panelMidiPortsTab = new JPanel();
        tabbedPane.addTab("MIDI  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/midi_mapping_icon16.png")), panelMidiPortsTab, "MIDI ports");
        GridBagLayout gbl_panelMidiPortsTab = new GridBagLayout();
        gbl_panelMidiPortsTab.columnWidths = new int[]{0, 0};
        gbl_panelMidiPortsTab.rowHeights = new int[]{0, 0, 0};
        gbl_panelMidiPortsTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMidiPortsTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelMidiPortsTab.setLayout(gbl_panelMidiPortsTab);
        JPanel panelMidiInput = new JPanel();
        panelMidiInput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Recording", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panelMidiInput = new GridBagConstraints();
        gbc_panelMidiInput.weightx = 1.0;
        gbc_panelMidiInput.insets = new Insets(4, 4, 5, 5);
        gbc_panelMidiInput.fill = 1;
        gbc_panelMidiInput.gridx = 0;
        gbc_panelMidiInput.gridy = 0;
        panelMidiPortsTab.add((Component)panelMidiInput, gbc_panelMidiInput);
        GridBagLayout gbl_panelMidiInput = new GridBagLayout();
        gbl_panelMidiInput.columnWidths = new int[]{0, 0, 0};
        gbl_panelMidiInput.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelMidiInput.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelMidiInput.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelMidiInput.setLayout(gbl_panelMidiInput);
        this.chckbxRecording = new JCheckBox("Enabled");
        this.chckbxRecording.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MidiLineConfigPanel.this.checkEnable();
                if (!MidiLineConfigPanel.this.refreshing) {
                    MidiLineConfigPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_chckbxRecording = new GridBagConstraints();
        gbc_chckbxRecording.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxRecording.gridx = 0;
        gbc_chckbxRecording.gridy = 0;
        panelMidiInput.add((Component)this.chckbxRecording, gbc_chckbxRecording);
        this.lblInputPort = new JLabel("Input Port:");
        GridBagConstraints gbc_lblInputPort = new GridBagConstraints();
        gbc_lblInputPort.anchor = 17;
        gbc_lblInputPort.insets = new Insets(4, 4, 5, 5);
        gbc_lblInputPort.gridx = 0;
        gbc_lblInputPort.gridy = 1;
        panelMidiInput.add((Component)this.lblInputPort, gbc_lblInputPort);
        this.waxLabPortChooserRec = new WaxLabPortChooser();
        this.waxLabPortChooserRec.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!MidiLineConfigPanel.this.refreshing) {
                    MidiLineConfigPanel.this.apply();
                }
            }
        });
        this.waxLabPortChooserRec.setAudioChannelCount(0);
        GridBagConstraints gbc_waxLabPortChooserRec = new GridBagConstraints();
        gbc_waxLabPortChooserRec.fill = 1;
        gbc_waxLabPortChooserRec.insets = new Insets(4, 4, 5, 0);
        gbc_waxLabPortChooserRec.anchor = 17;
        gbc_waxLabPortChooserRec.weightx = 1.0;
        gbc_waxLabPortChooserRec.gridx = 1;
        gbc_waxLabPortChooserRec.gridy = 1;
        panelMidiInput.add((Component)this.waxLabPortChooserRec, gbc_waxLabPortChooserRec);
        this.lblTickRate = new JLabel("Tick Rate:");
        this.lblTickRate.setToolTipText("Ticks per second");
        GridBagConstraints gbc_lblTickRate = new GridBagConstraints();
        gbc_lblTickRate.anchor = 17;
        gbc_lblTickRate.insets = new Insets(4, 4, 5, 5);
        gbc_lblTickRate.gridx = 0;
        gbc_lblTickRate.gridy = 2;
        panelMidiInput.add((Component)this.lblTickRate, gbc_lblTickRate);
        this.comboBoxTickRate = new JComboBox();
        this.comboBoxTickRate.setToolTipText("Ticks per second");
        this.comboBoxTickRate.setEditable(true);
        this.comboBoxTickRate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiLineConfigPanel.this.refreshing) {
                    MidiLineConfigPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxTickRate = new GridBagConstraints();
        gbc_comboBoxTickRate.insets = new Insets(4, 4, 5, 5);
        gbc_comboBoxTickRate.anchor = 17;
        gbc_comboBoxTickRate.gridx = 1;
        gbc_comboBoxTickRate.gridy = 2;
        panelMidiInput.add((Component)this.comboBoxTickRate, gbc_comboBoxTickRate);
        JPanel panelMidiOutput = new JPanel();
        panelMidiOutput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Playback", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panelMidiOutput = new GridBagConstraints();
        gbc_panelMidiOutput.weightx = 1.0;
        gbc_panelMidiOutput.insets = new Insets(4, 4, 5, 5);
        gbc_panelMidiOutput.fill = 1;
        gbc_panelMidiOutput.gridx = 0;
        gbc_panelMidiOutput.gridy = 1;
        panelMidiPortsTab.add((Component)panelMidiOutput, gbc_panelMidiOutput);
        GridBagLayout gbl_panelMidiOutput = new GridBagLayout();
        gbl_panelMidiOutput.columnWidths = new int[]{0, 0, 0};
        gbl_panelMidiOutput.rowHeights = new int[]{0, 0, 0};
        gbl_panelMidiOutput.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelMidiOutput.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelMidiOutput.setLayout(gbl_panelMidiOutput);
        this.chckbxPlayback = new JCheckBox("Enabled");
        this.chckbxPlayback.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MidiLineConfigPanel.this.checkEnable();
                if (!MidiLineConfigPanel.this.refreshing) {
                    MidiLineConfigPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_chckbxPlayback = new GridBagConstraints();
        gbc_chckbxPlayback.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxPlayback.gridx = 0;
        gbc_chckbxPlayback.gridy = 0;
        panelMidiOutput.add((Component)this.chckbxPlayback, gbc_chckbxPlayback);
        this.lblOutputPort = new JLabel("Output Port:");
        GridBagConstraints gbc_lblOutputPort = new GridBagConstraints();
        gbc_lblOutputPort.anchor = 17;
        gbc_lblOutputPort.insets = new Insets(4, 4, 5, 5);
        gbc_lblOutputPort.gridx = 0;
        gbc_lblOutputPort.gridy = 1;
        panelMidiOutput.add((Component)this.lblOutputPort, gbc_lblOutputPort);
        this.waxLabPortChooserPlay = new WaxLabPortChooser();
        this.waxLabPortChooserPlay.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!MidiLineConfigPanel.this.refreshing) {
                    MidiLineConfigPanel.this.apply();
                }
            }
        });
        this.waxLabPortChooserPlay.setAudioChannelCount(0);
        GridBagConstraints gbc_waxLabPortChooserPlay = new GridBagConstraints();
        gbc_waxLabPortChooserPlay.fill = 1;
        gbc_waxLabPortChooserPlay.insets = new Insets(4, 4, 5, 5);
        gbc_waxLabPortChooserPlay.anchor = 17;
        gbc_waxLabPortChooserPlay.weightx = 1.0;
        gbc_waxLabPortChooserPlay.gridx = 1;
        gbc_waxLabPortChooserPlay.gridy = 1;
        panelMidiOutput.add((Component)this.waxLabPortChooserPlay, gbc_waxLabPortChooserPlay);
        JPanel panelViewOptionsTab = new JPanel();
        tabbedPane.addTab("View  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/color_icon.gif")), panelViewOptionsTab, "View options");
        GridBagLayout gbl_panelViewOptionsTab = new GridBagLayout();
        gbl_panelViewOptionsTab.columnWidths = new int[]{0, 0};
        gbl_panelViewOptionsTab.rowHeights = new int[]{0, 0};
        gbl_panelViewOptionsTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelViewOptionsTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelViewOptionsTab.setLayout(gbl_panelViewOptionsTab);
        this.panelMidiViewOptions = new JPanel();
        this.panelMidiViewOptions.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "View Options", 4, 2, null, null));
        GridBagConstraints gbc_panelMidiViewOptions = new GridBagConstraints();
        gbc_panelMidiViewOptions.weightx = 1.0;
        gbc_panelMidiViewOptions.insets = new Insets(4, 4, 5, 5);
        gbc_panelMidiViewOptions.fill = 1;
        gbc_panelMidiViewOptions.gridx = 0;
        gbc_panelMidiViewOptions.gridy = 0;
        panelViewOptionsTab.add((Component)this.panelMidiViewOptions, gbc_panelMidiViewOptions);
        GridBagLayout gbl_panelMidiViewOptions = new GridBagLayout();
        gbl_panelMidiViewOptions.columnWidths = new int[]{0, 0};
        gbl_panelMidiViewOptions.rowHeights = new int[]{0, 0};
        gbl_panelMidiViewOptions.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMidiViewOptions.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelMidiViewOptions.setLayout(gbl_panelMidiViewOptions);
        this.panelHideInactiveControls = new JPanel();
        GridBagConstraints gbc_panelHideInactiveControls = new GridBagConstraints();
        gbc_panelHideInactiveControls.insets = new Insets(4, 4, 4, 4);
        gbc_panelHideInactiveControls.weightx = 1.0;
        gbc_panelHideInactiveControls.fill = 1;
        gbc_panelHideInactiveControls.gridx = 0;
        gbc_panelHideInactiveControls.gridy = 0;
        this.panelMidiViewOptions.add((Component)this.panelHideInactiveControls, gbc_panelHideInactiveControls);
        GridBagLayout gbl_panelHideInactiveControls = new GridBagLayout();
        gbl_panelHideInactiveControls.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelHideInactiveControls.rowHeights = new int[]{0, 0};
        gbl_panelHideInactiveControls.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelHideInactiveControls.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelHideInactiveControls.setLayout(gbl_panelHideInactiveControls);
        this.chckbxHideInactiveControls = new JCheckBox("Hide inactive controls after:");
        this.chckbxHideInactiveControls.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MidiLineConfigPanel.this.checkEnable();
                if (!MidiLineConfigPanel.this.refreshing) {
                    MidiLineConfigPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_chckbxHideInactiveControls = new GridBagConstraints();
        gbc_chckbxHideInactiveControls.insets = new Insets(0, 0, 0, 5);
        gbc_chckbxHideInactiveControls.gridx = 0;
        gbc_chckbxHideInactiveControls.gridy = 0;
        this.panelHideInactiveControls.add((Component)this.chckbxHideInactiveControls, gbc_chckbxHideInactiveControls);
        this.comboBoxHideInactiveControls = new JComboBox();
        this.comboBoxHideInactiveControls.setEditable(true);
        this.comboBoxHideInactiveControls.setToolTipText("Milliseconds");
        GridBagConstraints gbc_comboBoxHideInactiveControls = new GridBagConstraints();
        gbc_comboBoxHideInactiveControls.insets = new Insets(0, 0, 0, 5);
        gbc_comboBoxHideInactiveControls.fill = 2;
        gbc_comboBoxHideInactiveControls.gridx = 1;
        gbc_comboBoxHideInactiveControls.gridy = 0;
        this.panelHideInactiveControls.add((Component)this.comboBoxHideInactiveControls, gbc_comboBoxHideInactiveControls);
        this.lblHideControlMillis = new JLabel("ms.");
        this.lblHideControlMillis.setToolTipText("Milliseconds");
        GridBagConstraints gbc_lblHideControlMillis = new GridBagConstraints();
        gbc_lblHideControlMillis.gridx = 2;
        gbc_lblHideControlMillis.gridy = 0;
        this.panelHideInactiveControls.add((Component)this.lblHideControlMillis, gbc_lblHideControlMillis);
    }

    public MidiLineConfig getMidiLineConfig() {
        return this.midiLineConfig;
    }

    public void setMidiLineConfig(MidiLineConfig midiLineConfig) {
        this.midiLineConfig = midiLineConfig;
        this.refresh();
    }

    protected void apply() {
        MidiLineConfig config = this.getMidiLineConfig();
        if (config == null) {
            return;
        }
        config.setRecordingEnabled(this.chckbxRecording.isSelected());
        config.setPlaybackEnabled(this.chckbxPlayback.isSelected());
        float tickRate = -1.0f;
        Object tickRateItem = this.comboBoxTickRate.getSelectedItem();
        if (tickRateItem != null) {
            String tickRateStr = tickRateItem.toString();
            if ((tickRateStr = tickRateStr.trim()).length() > 0) {
                try {
                    tickRate = Float.parseFloat(tickRateStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (tickRate < 1.0f) {
            tickRate = 9000.0f;
        }
        config.setRecordingTickRate(tickRate);
        WaxLabPortInfo recPort = null;
        WaxLabPortInfo[] recPorts = this.waxLabPortChooserRec.getSelectedPorts();
        if (recPorts != null && recPorts.length > 0) {
            recPort = recPorts[0];
        }
        config.setRecordingPort(recPort);
        WaxLabPortInfo playPort = null;
        WaxLabPortInfo[] playPorts = this.waxLabPortChooserPlay.getSelectedPorts();
        if (playPorts != null && playPorts.length > 0) {
            playPort = playPorts[0];
        }
        config.setPlaybackPort(playPort);
        config.setHideInactiveControls(this.chckbxHideInactiveControls.isSelected());
        Object item = this.comboBoxHideInactiveControls.getSelectedItem();
        long hideInactiveControlMillis = -1L;
        if (item != null && item != HIDE_CONTROL_DEFAULT) {
            String s = item.toString();
            if ((s = s.trim()).length() > 0) {
                try {
                    hideInactiveControlMillis = Long.parseLong(s);
                    if (hideInactiveControlMillis < 0L) {
                        hideInactiveControlMillis = -1L;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        config.setHideInactiveControlMillis(hideInactiveControlMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            this.getCommonLineConfigPanel().setLineConfig((LineConfig)this.midiLineConfig);
            boolean recordingEnabled = false;
            boolean playbackEnabled = false;
            WaxLabPortInfo recPort = null;
            WaxLabPortInfo playPort = null;
            float recordingTickRate = -1.0f;
            boolean hideInactiveControls = false;
            long hideInactiveControlMillis = -1L;
            if (this.midiLineConfig != null) {
                recordingEnabled = this.midiLineConfig.isRecordingEnabled();
                playbackEnabled = this.midiLineConfig.isPlaybackEnabled();
                recPort = this.midiLineConfig.getRecordingPort();
                playPort = this.midiLineConfig.getPlaybackPort();
                recordingTickRate = this.midiLineConfig.getRecordingTickRate();
                hideInactiveControls = this.midiLineConfig.isHideInactiveControls();
                hideInactiveControlMillis = this.midiLineConfig.getHideInactiveControlMillis();
            }
            this.waxLabPortChooserRec.setSelectedPorts(new WaxLabPortInfo[]{recPort});
            this.waxLabPortChooserPlay.setSelectedPorts(new WaxLabPortInfo[]{playPort});
            this.chckbxRecording.setSelected(recordingEnabled);
            this.chckbxPlayback.setSelected(playbackEnabled);
            if (recordingTickRate <= 0.0f) {
                recordingTickRate = 9000.0f;
            }
            this.comboBoxTickRate.removeAllItems();
            this.comboBoxTickRate.addItem(this.formatTickRate(9000.0f));
            this.comboBoxTickRate.setSelectedItem(this.formatTickRate(recordingTickRate));
            this.chckbxHideInactiveControls.setSelected(hideInactiveControls);
            this.comboBoxHideInactiveControls.removeAllItems();
            this.comboBoxHideInactiveControls.addItem(HIDE_CONTROL_DEFAULT);
            this.comboBoxHideInactiveControls.addItem(HIDE_CONTROL_1_SECOND);
            this.comboBoxHideInactiveControls.addItem(HIDE_CONTROL_10_SECONDS);
            if (hideInactiveControlMillis > 0L) {
                this.comboBoxHideInactiveControls.setSelectedItem(String.valueOf(hideInactiveControlMillis));
            } else {
                this.comboBoxHideInactiveControls.setSelectedItem(HIDE_CONTROL_DEFAULT);
            }
            this.checkEnable();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void checkEnable() {
        boolean recEnable = this.chckbxRecording.isSelected();
        this.lblInputPort.setEnabled(recEnable);
        this.waxLabPortChooserRec.setEnabled(recEnable);
        this.lblTickRate.setEnabled(recEnable);
        this.comboBoxTickRate.setEnabled(recEnable);
        boolean playEnable = this.chckbxPlayback.isSelected();
        this.lblOutputPort.setEnabled(playEnable);
        this.waxLabPortChooserPlay.setEnabled(playEnable);
        boolean hideInactiveControls = this.chckbxHideInactiveControls.isSelected();
        this.comboBoxHideInactiveControls.setEnabled(hideInactiveControls);
        this.lblHideControlMillis.setEnabled(hideInactiveControls);
    }

    public String formatTickRate(float tickRate) {
        String s = String.valueOf(tickRate);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public WaxLabPortInfo[] getWaxLabPorts() {
        return this.waxLabPorts;
    }

    public void setWaxLabPorts(WaxLabPortInfo[] waxLabPorts) {
        this.waxLabPorts = waxLabPorts;
        LinkedList<WaxLabPortInfo> listInput = new LinkedList<WaxLabPortInfo>();
        LinkedList<WaxLabPortInfo> listOutput = new LinkedList<WaxLabPortInfo>();
        if (waxLabPorts != null) {
            for (int i = 0; i < waxLabPorts.length; ++i) {
                WaxLabPortInfo info = waxLabPorts[i];
                if (info == null) continue;
                PortType portType = info.getType();
                if (portType != null && portType instanceof MidiInputPortType) {
                    listInput.add(info);
                }
                if (portType == null || !(portType instanceof MidiOutputPortType)) continue;
                listOutput.add(info);
            }
        }
        WaxLabPortInfo[] inputPorts = listInput.toArray(new WaxLabPortInfo[listInput.size()]);
        this.waxLabPortChooserRec.setAvailablePorts(inputPorts);
        WaxLabPortInfo[] outputPorts = listOutput.toArray(new WaxLabPortInfo[listOutput.size()]);
        this.waxLabPortChooserPlay.setAvailablePorts(outputPorts);
    }

    public void enableRecording() {
        this.getChckbxRecording().setSelected(true);
    }

    public void enablePlayback() {
        this.getChckbxPlayback().setSelected(true);
    }

    protected WaxLabPortChooser getWaxLabPortChooserRec() {
        return this.waxLabPortChooserRec;
    }

    protected WaxLabPortChooser getWaxLabPortChooserPlay() {
        return this.waxLabPortChooserPlay;
    }

    protected JCheckBox getChckbxRecording() {
        return this.chckbxRecording;
    }

    protected JCheckBox getChckbxPlayback() {
        return this.chckbxPlayback;
    }

    protected JLabel getLblInputPort() {
        return this.lblInputPort;
    }

    protected JLabel getLblOutputPort() {
        return this.lblOutputPort;
    }

    protected CommonLineConfigPanel getCommonLineConfigPanel() {
        return this.commonLineConfigPanel;
    }

    protected JCheckBox getChckbxHideInactiveControls() {
        return this.chckbxHideInactiveControls;
    }

    protected JComboBox getComboBoxHideInactiveControls() {
        return this.comboBoxHideInactiveControls;
    }

    protected JLabel getLblHideControlMillis() {
        return this.lblHideControlMillis;
    }

    protected JComboBox getComboBoxTickRate() {
        return this.comboBoxTickRate;
    }

    protected JLabel getLblTickRate() {
        return this.lblTickRate;
    }
}

