/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.waxmonster.model.ChunkListener;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.MidiTrack;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.view.ChunkRenderer;
import com.waxmonster.model.view.LineManager;
import com.waxmonster.model.view.LineView;
import com.waxmonster.model.view.MidiChunkModelLineView;
import com.waxmonster.model.view.MidiChunkRenderer;
import com.waxmonster.model.view.MidiColorPalette;
import com.waxmonster.model.view.SimpleMidiChunkRenderer;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewLayout;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.MidiLineConfig;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.ChunkRendererUtil;
import com.waxmonster.waxlab.view.MidiTrackSelectionPanel;
import com.waxmonster.waxlab.view.MultiLinePanel;
import com.waxmonster.waxlab.view.TimecodeLineWrapper;
import com.waxmonster.waxlab.view.WaxLabFileFilters;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class MidiLineWrapper
extends AbstractLineWrapper {
    private static final Logger logger = Logger.getLogger(MidiLineWrapper.class.getName());
    private final MidiLine midiLine;
    private MidiChunkModelLineView chunkModelLineView;
    private MidiChunkRenderer midiChunkRenderer;
    private LineChunk prevRecChunk;

    public MidiLineWrapper(MultiLinePanel panel, MidiLine midiLine, ViewLayout layout, int gridIndex, LineManager manager, WaxLabViewSettings viewSettings) {
        super(panel, (Line)midiLine, layout, gridIndex);
        this.midiLine = midiLine;
        this.setLineManager(manager);
        int trackSize = midiLine.getTrackSize();
        if (trackSize < 0) {
            trackSize = viewSettings.getMidiViewSize();
        }
        this.setTrackSize(trackSize);
        ScrollView scrollView = new ScrollView();
        this.setScrollView(scrollView);
        this.setRecRefreshToPos(true);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        ChunkModel chunkModel = this.line.getChunkModel();
        if (chunkModel != null) {
            chunkModel.registerChunkListener((ChunkListener)this.chunkHandler);
        }
    }

    @Override
    public void dispose() {
        ChunkModel chunkModel = this.line.getChunkModel();
        if (chunkModel != null) {
            chunkModel.unregisterChunkListener((ChunkListener)this.chunkHandler);
        }
        super.dispose();
    }

    public MidiLine getMidiLine() {
        return this.midiLine;
    }

    protected int getFaderDeck(String leftDeckName, String rightDeckName) {
        return -1;
    }

    protected void refreshMidiChunkRenderer(ChunkRenderer midiRenderer, MidiLineConfig lineConfig) {
        WaxLabViewSettings vs;
        if (midiRenderer == null) {
            return;
        }
        SimpleMidiChunkRenderer renderer = (SimpleMidiChunkRenderer)midiRenderer;
        MidiColorPalette palette = this.midiLine.getMidiColorPalette();
        renderer.setPalette(palette);
        long maxControlInactiveMillis = -1L;
        if (lineConfig != null) {
            maxControlInactiveMillis = lineConfig.isHideInactiveControls() ? lineConfig.getHideInactiveControlMillis() : 0L;
        }
        if (maxControlInactiveMillis < 0L && (vs = this.viewSettings) != null) {
            maxControlInactiveMillis = vs.getMidiHideControlInactiveMillis();
        }
        renderer.setMaxControlInactiveMillis(maxControlInactiveMillis);
    }

    public long computeTimeLength() {
        return this.line.computeTimeLength();
    }

    @Override
    public void refresh() {
        TileView tileView;
        int tileHeight;
        MidiLineConfig config = this.midiLine.getMidiLineConfig();
        if (this.chunkModelLineView == null) {
            this.chunkModelLineView = new MidiChunkModelLineView();
        }
        this.chunkModelLineView.setChunkModel(this.midiLine.getChunkModel());
        if (this.midiChunkRenderer == null) {
            String midiRenderMode = null;
            this.midiChunkRenderer = ChunkRendererUtil.getInstance().createMidiChunkRenderer(midiRenderMode, this.viewSettings);
        }
        this.refreshMidiChunkRenderer((ChunkRenderer)this.midiChunkRenderer, config);
        this.chunkModelLineView.setChunkRenderer((ChunkRenderer)this.midiChunkRenderer);
        this.chunkModelLineView.setLineManager(this.lineManager);
        this.layoutLineView((LineView)this.chunkModelLineView);
        this.lineViews = new LineView[]{this.chunkModelLineView};
        this.setLineViews(this.lineViews);
        int tileWidth = this.trackSize;
        if (tileWidth < 1) {
            tileWidth = 1;
        }
        if ((tileHeight = this.trackSize) < 1) {
            tileHeight = 1;
        }
        if ((tileView = this.tileView) != null && (tileView.getTileWidth() != tileWidth || tileView.getTileHeight() != tileHeight)) {
            tileView.flush();
            tileView = null;
        }
        if (tileView == null) {
            int maxTileCacheCount = this.viewSettings.getMidiTileCacheCount();
            if (maxTileCacheCount < 1) {
                maxTileCacheCount = 1;
            }
            Color audioLineBackground = this.viewSettings.getMidiViewBackground();
            tileView = new TileView(tileWidth, tileHeight, maxTileCacheCount, (Paint)audioLineBackground);
            this.setTileView(tileView);
            this.scrollView.setViews(new View[]{tileView});
        }
        tileView.replaceAllViews((View[])this.lineViews);
        tileView.invalidate();
        LineChunk oldChunk = this.prevRecChunk;
        LineChunk recChunk = this.midiLine.getRecChunk();
        if (recChunk != oldChunk) {
            this.prevRecChunk = recChunk;
            this.setRecChunk(recChunk);
            if (recChunk == null) {
                this.panel.unregisterRecordingWrapper(this);
                this.midiChunkRenderer.setRecordingChunk(null);
                this.chunkModelLineView.setRecordingChunk(null);
            } else {
                this.midiChunkRenderer.setLineManager(this.lineManager);
                this.midiChunkRenderer.setRecordingChunk(recChunk);
                this.chunkModelLineView.setRecordingChunk(recChunk);
                if (oldChunk == null) {
                    this.panel.registerRecordingWrapper(this);
                }
            }
            AbstractLineWrapper[] wrappers = this.lineWrappers;
            int num = wrappers == null ? 0 : wrappers.length;
            for (int i = 0; i < num; ++i) {
                TimecodeLineConfig tcLineConfig;
                Line line;
                AbstractLineWrapper wrapper = wrappers[i];
                if (!(wrapper instanceof TimecodeLineWrapper) || (line = wrapper.getLine()) == null || !(line instanceof TimecodeLine) || (tcLineConfig = ((TimecodeLine)line).getTimecodeLineConfig()) == null || tcLineConfig.getFaderMidiLine() != this.midiLine) continue;
                ((TimecodeLineWrapper)wrapper).handleMidiRecordingChanged(this.midiLine);
            }
        }
    }

    protected boolean isHideMidiRecordingHelperView() {
        MultiLinePanel panel = this.panel;
        return panel != null && panel.isHideMidiRecordingHelperView();
    }

    @Override
    public void layout() {
        ScrollView wrapperView;
        boolean horiz;
        int orient = this.orientation;
        boolean bl = horiz = orient == 0 || orient == 1;
        if (this.scrollView != null) {
            Dimension prefSize = this.scrollView.getPreferredSize();
            prefSize.width = this.trackSize;
            prefSize.height = this.trackSize;
            this.scrollView.setPreferredSize(prefSize);
        }
        if ((wrapperView = this.scrollView) != null) {
            int index = this.getGridIndex();
            GridBagConstraints gbc = new GridBagConstraints();
            if (horiz) {
                gbc.gridx = 0;
                gbc.gridy = index;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
            } else {
                gbc.gridx = index;
                gbc.gridy = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 1.0;
            }
            gbc.fill = 1;
            ViewLayout viewLayout = this.viewLayout;
            if (viewLayout != null) {
                viewLayout.removeView((View)wrapperView);
                if (index >= 0) {
                    viewLayout.addView((View)wrapperView, (Object)gbc);
                }
            }
        }
    }

    @Override
    public void setViewSettings(WaxLabViewSettings viewSettings) {
        super.setViewSettings(viewSettings);
        if (viewSettings != null && this.tileView != null) {
            int maxTileCacheCount = viewSettings.getMidiTileCacheCount();
            if (maxTileCacheCount < 1) {
                maxTileCacheCount = 1;
            }
            this.tileView.setMaxTileCacheCount(maxTileCacheCount);
            this.tileView.setBackground((Paint)viewSettings.getMidiViewBackground());
        }
    }

    public File showOpenFileDialog() throws Exception {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setDialogTitle("Open MIDI File");
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        WaxLabFileFilters.MidiFileFilter fileFilter = new WaxLabFileFilters.MidiFileFilter();
        chooser.setFileFilter(fileFilter);
        int rc = chooser.showOpenDialog(this.panel);
        if (rc != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        return file;
    }

    public LineChunk[] openLineChunks(File file) throws Exception {
        MidiModel midiModel;
        boolean readOnly;
        FileResource resource;
        MidiTrack[] midiTracks;
        if (file == null) {
            return null;
        }
        AbstractWaxLabPanel waxPanel = this.panel.getWaxLabPanel();
        if (waxPanel == null) {
            return null;
        }
        WaxLab waxLab = waxPanel.getWaxLab();
        if (waxLab == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating MidiModel(s) for file: " + file);
        }
        if ((midiTracks = waxLab.createMidiTracks((Resource)(resource = new FileResource(file)), readOnly = true)) == null) {
            return null;
        }
        int numTracks = midiTracks.length;
        if (numTracks < 1) {
            return null;
        }
        MidiTrack[] selectedMidiTracks = midiTracks;
        if (numTracks > 1) {
            MidiTrackSelectionPanel selPanel = new MidiTrackSelectionPanel();
            selPanel.setPreferredSize(new Dimension(400, 400));
            selPanel.setTracks(midiTracks);
            selPanel.setSelectedTracks(selectedMidiTracks);
            MidiTrackSelectionPanel message = selPanel;
            String title = "Select MIDI Track(s)";
            int optionType = 2;
            int messageType = -1;
            int rc = JOptionPane.showConfirmDialog(this.panel, message, title, optionType, messageType);
            if (rc != 0) {
                return null;
            }
            selectedMidiTracks = selPanel.getSelectedTracks();
            if (selectedMidiTracks == null || selectedMidiTracks.length < 1) {
                return null;
            }
        }
        if ((midiModel = waxLab.createMidiModel(selectedMidiTracks)) == null) {
            return null;
        }
        long modelOfs = 0L;
        long chunkOfs = 0L;
        long modelEnd = midiModel.getNanoLength();
        long chunkEnd = modelEnd;
        MutableLineChunk midiChunk = midiModel.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
        if (midiChunk == null) {
            return null;
        }
        return new LineChunk[]{midiChunk};
    }
}

