/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.model.MidiTrack;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MidiTrackSelectionPanel
extends JPanel {
    private static final long serialVersionUID = -1909666475079079937L;
    private boolean refreshing;
    private MidiTrack[] tracks;
    private MidiTrack[] selectedTracks;
    private DefaultListModel trackInfoListModel;
    private JList listTracks;

    public MidiTrackSelectionPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelBorder = new JPanel();
        panelBorder.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Tracks", 4, 2, null, null));
        GridBagConstraints gbc_panelBorder = new GridBagConstraints();
        gbc_panelBorder.weighty = 1.0;
        gbc_panelBorder.weightx = 1.0;
        gbc_panelBorder.insets = new Insets(4, 4, 4, 4);
        gbc_panelBorder.fill = 1;
        gbc_panelBorder.gridx = 0;
        gbc_panelBorder.gridy = 0;
        this.add((Component)panelBorder, gbc_panelBorder);
        GridBagLayout gbl_panelBorder = new GridBagLayout();
        gbl_panelBorder.columnWidths = new int[]{0, 0};
        gbl_panelBorder.rowHeights = new int[]{0, 0};
        gbl_panelBorder.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelBorder.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelBorder.setLayout(gbl_panelBorder);
        JPanel panelTrackSelection = new JPanel();
        GridBagConstraints gbc_panelTrackSelection = new GridBagConstraints();
        gbc_panelTrackSelection.weighty = 1.0;
        gbc_panelTrackSelection.weightx = 1.0;
        gbc_panelTrackSelection.insets = new Insets(4, 4, 4, 4);
        gbc_panelTrackSelection.fill = 1;
        gbc_panelTrackSelection.gridx = 0;
        gbc_panelTrackSelection.gridy = 0;
        panelBorder.add((Component)panelTrackSelection, gbc_panelTrackSelection);
        GridBagLayout gbl_panelTrackSelection = new GridBagLayout();
        gbl_panelTrackSelection.columnWidths = new int[]{0, 0};
        gbl_panelTrackSelection.rowHeights = new int[]{0, 0};
        gbl_panelTrackSelection.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelTrackSelection.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelTrackSelection.setLayout(gbl_panelTrackSelection);
        JScrollPane scrollPaneTracks = new JScrollPane();
        GridBagConstraints gbc_scrollPaneTracks = new GridBagConstraints();
        gbc_scrollPaneTracks.weighty = 1.0;
        gbc_scrollPaneTracks.weightx = 1.0;
        gbc_scrollPaneTracks.fill = 1;
        gbc_scrollPaneTracks.gridx = 0;
        gbc_scrollPaneTracks.gridy = 0;
        panelTrackSelection.add((Component)scrollPaneTracks, gbc_scrollPaneTracks);
        this.listTracks = new JList();
        this.listTracks.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!MidiTrackSelectionPanel.this.refreshing) {
                    MidiTrackSelectionPanel.this.apply();
                }
            }
        });
        scrollPaneTracks.setViewportView(this.listTracks);
        this.initMidiTrackSelectionPanel();
    }

    protected void initMidiTrackSelectionPanel() {
        this.trackInfoListModel = new DefaultListModel();
        this.getListTracks().setModel(this.trackInfoListModel);
        this.getListTracks().setCellRenderer(new TrackListCellRenderer());
    }

    protected JList getListTracks() {
        return this.listTracks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            this.trackInfoListModel.removeAllElements();
            MidiTrack[] selTracks = this.selectedTracks;
            int selCount = selTracks == null ? 0 : selTracks.length;
            int[] sel = new int[selCount];
            int selIndex = 0;
            MidiTrack[] infos = this.tracks;
            int num = infos == null ? 0 : infos.length;
            block3: for (int i = 0; i < num; ++i) {
                MidiTrack track = infos[i];
                this.trackInfoListModel.addElement(track);
                for (int k = 0; k < selCount; ++k) {
                    if (selTracks[k] != track) continue;
                    sel[selIndex++] = i;
                    continue block3;
                }
            }
            if (selIndex > 0) {
                if (selIndex < sel.length) {
                    int[] arr = new int[selIndex];
                    System.arraycopy(sel, 0, arr, 0, selIndex);
                    sel = arr;
                }
                this.getListTracks().setSelectedIndices(sel);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    public void apply() {
        int[] sel = this.getListTracks().getSelectedIndices();
        int num = sel.length;
        this.selectedTracks = new MidiTrack[num];
        for (int i = 0; i < num; ++i) {
            this.selectedTracks[i] = this.tracks[sel[i]];
        }
    }

    public MidiTrack[] getTracks() {
        return this.tracks;
    }

    public void setTracks(MidiTrack[] tracks) {
        this.tracks = tracks;
        this.refresh();
    }

    public MidiTrack[] getSelectedTracks() {
        return this.selectedTracks;
    }

    public void setSelectedTracks(MidiTrack[] selectedTracks) {
        this.selectedTracks = selectedTracks;
        this.refresh();
    }

    protected class TrackListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -6669462516087854643L;

        protected TrackListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            if (value != null && value instanceof MidiTrack) {
                MidiTrack track = (MidiTrack)value;
                text = track.getTrackId();
                if (text == null) {
                    text = "?";
                }
                text = "#" + text + ": ";
                String trackName = track.getTrackName();
                if (trackName != null) {
                    text = text + trackName;
                }
                long eventCount = track.getEventCount();
                text = text + " (" + eventCount + " events)";
            }
            if (text == null) {
                text = String.valueOf(value);
            }
            this.setText(text);
            return comp;
        }
    }
}

