/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.movie.MovieProducerType;
import com.spacekiller.util.movie.plugin.MovieProducerTypeChooser;
import com.waxmonster.model.LineUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MovieGeneratorPanel
extends JPanel {
    private static final long serialVersionUID = 2694225819251622800L;
    private long timeLength;
    private long startTime;
    private long stopTime;
    private double frameRate;
    private boolean hidePositionBar;
    private boolean hideSelectionView;
    private int imageWidth;
    private int imageHeight;
    private MovieProducerType[] movieProducerTypes;
    private MovieProducerType movieProducerType;
    private boolean refreshing;
    private JLabel jLabel2 = null;
    private JTextField jTextFieldFrameRate = null;
    private JLabel jLabel3 = null;
    private JPanel panel;
    private JPanel panel_1;
    private JLabel lblImageSize;
    private JPanel panel_2;
    private JTextField textFieldWidth;
    private JLabel lblX;
    private JTextField textFieldHeight;
    private MovieProducerTypeChooser movieProducerTypeChooser;
    private JLabel lblStartTime;
    private JLabel lblStopTime;
    private JLabel lblViewOptions;
    private JPanel panel_3;
    private JPanel panel_4;
    private JPanel panel_5;
    private JPanel panel_6;
    private JCheckBox chckbxHidepositionbar;
    private JTextField textFieldStartTime;
    private JTextField textFieldStopTime;
    private JTextField textFieldFrameCount;
    private JButton btnTostart;
    private JButton btnToend;
    private JCheckBox chckbxHideSelectionView;

    public MovieGeneratorPanel() {
        this.initialize();
        this.initMovieGeneratorPanel();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0};
        gridBagLayout.rowWeights = new double[]{0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(520, 384));
        GridBagConstraints gbc_panel_6 = new GridBagConstraints();
        gbc_panel_6.fill = 1;
        gbc_panel_6.gridx = 0;
        gbc_panel_6.gridy = 0;
        this.add((Component)this.getPanel_6(), gbc_panel_6);
    }

    private JTextField getJTextFieldFrameRate() {
        if (this.jTextFieldFrameRate == null) {
            this.jTextFieldFrameRate = new JTextField();
            this.jTextFieldFrameRate.setOpaque(false);
            this.jTextFieldFrameRate.setColumns(5);
            this.jTextFieldFrameRate.setToolTipText("Number of frames per second");
        }
        return this.jTextFieldFrameRate;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gbl_panel = new GridBagLayout();
            gbl_panel.columnWidths = new int[]{0, 0, 0};
            gbl_panel.rowHeights = new int[]{0, 0};
            gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel.setLayout(gbl_panel);
            GridBagConstraints gbc_jTextFieldFrameRate = new GridBagConstraints();
            gbc_jTextFieldFrameRate.insets = new Insets(0, 0, 0, 5);
            gbc_jTextFieldFrameRate.fill = 1;
            gbc_jTextFieldFrameRate.gridx = 0;
            gbc_jTextFieldFrameRate.gridy = 0;
            this.panel.add((Component)this.getJTextFieldFrameRate(), gbc_jTextFieldFrameRate);
            GridBagConstraints gbc_textFieldFrameCount = new GridBagConstraints();
            gbc_textFieldFrameCount.weightx = 1.0;
            gbc_textFieldFrameCount.fill = 1;
            gbc_textFieldFrameCount.gridx = 1;
            gbc_textFieldFrameCount.gridy = 0;
            this.panel.add((Component)this.getTextFieldFrameCount(), gbc_textFieldFrameCount);
        }
        return this.panel;
    }

    private JPanel getPanel_1() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            GridBagLayout gbl_panel_1 = new GridBagLayout();
            gbl_panel_1.columnWidths = new int[]{0, 0};
            gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
            gbl_panel_1.columnWeights = new double[]{0.0, 0.0};
            gbl_panel_1.rowWeights = new double[]{1.0, 1.0, 1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panel_1.setLayout(gbl_panel_1);
            GridBagConstraints gbc_lblStartTime = new GridBagConstraints();
            gbc_lblStartTime.anchor = 17;
            gbc_lblStartTime.insets = new Insets(4, 4, 5, 5);
            gbc_lblStartTime.gridx = 0;
            gbc_lblStartTime.gridy = 0;
            this.panel_1.add((Component)this.getLblStartTime(), gbc_lblStartTime);
            GridBagConstraints gbc_panel_4 = new GridBagConstraints();
            gbc_panel_4.insets = new Insets(4, 4, 5, 0);
            gbc_panel_4.fill = 1;
            gbc_panel_4.gridx = 1;
            gbc_panel_4.gridy = 0;
            this.panel_1.add((Component)this.getPanel_4(), gbc_panel_4);
            GridBagConstraints gbc_lblStopTime = new GridBagConstraints();
            gbc_lblStopTime.anchor = 17;
            gbc_lblStopTime.insets = new Insets(4, 4, 5, 5);
            gbc_lblStopTime.gridx = 0;
            gbc_lblStopTime.gridy = 1;
            this.panel_1.add((Component)this.getLblStopTime(), gbc_lblStopTime);
            GridBagConstraints gbc_panel_5 = new GridBagConstraints();
            gbc_panel_5.insets = new Insets(4, 4, 5, 0);
            gbc_panel_5.fill = 1;
            gbc_panel_5.gridx = 1;
            gbc_panel_5.gridy = 1;
            this.panel_1.add((Component)this.getPanel_5(), gbc_panel_5);
            GridBagConstraints gbc_lblViewOptions = new GridBagConstraints();
            gbc_lblViewOptions.anchor = 18;
            gbc_lblViewOptions.insets = new Insets(4, 4, 5, 5);
            gbc_lblViewOptions.gridx = 0;
            gbc_lblViewOptions.gridy = 2;
            this.panel_1.add((Component)this.getLblViewOptions(), gbc_lblViewOptions);
            GridBagConstraints gbc_panel_3 = new GridBagConstraints();
            gbc_panel_3.insets = new Insets(4, 4, 5, 0);
            gbc_panel_3.fill = 1;
            gbc_panel_3.gridx = 1;
            gbc_panel_3.gridy = 2;
            this.panel_1.add((Component)this.getPanel_3(), gbc_panel_3);
            GridBagConstraints gbc_lblImageSize = new GridBagConstraints();
            gbc_lblImageSize.anchor = 17;
            gbc_lblImageSize.insets = new Insets(4, 4, 5, 5);
            gbc_lblImageSize.gridx = 0;
            gbc_lblImageSize.gridy = 3;
            this.panel_1.add((Component)this.getLblImageSize(), gbc_lblImageSize);
            GridBagConstraints gbc_panel_2 = new GridBagConstraints();
            gbc_panel_2.insets = new Insets(4, 4, 5, 0);
            gbc_panel_2.fill = 1;
            gbc_panel_2.gridx = 1;
            gbc_panel_2.gridy = 3;
            this.panel_1.add((Component)this.getPanel_2(), gbc_panel_2);
            this.jLabel2 = new JLabel();
            GridBagConstraints gbc_jLabel2 = new GridBagConstraints();
            gbc_jLabel2.anchor = 17;
            gbc_jLabel2.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel2.gridx = 0;
            gbc_jLabel2.gridy = 4;
            this.panel_1.add((Component)this.jLabel2, gbc_jLabel2);
            this.jLabel2.setText("Frame Rate:");
            GridBagConstraints gbc_panel = new GridBagConstraints();
            gbc_panel.insets = new Insets(4, 4, 5, 0);
            gbc_panel.fill = 2;
            gbc_panel.gridx = 1;
            gbc_panel.gridy = 4;
            this.panel_1.add((Component)this.getPanel(), gbc_panel);
            this.jLabel3 = new JLabel();
            GridBagConstraints gbc_jLabel3 = new GridBagConstraints();
            gbc_jLabel3.anchor = 17;
            gbc_jLabel3.insets = new Insets(4, 4, 0, 5);
            gbc_jLabel3.gridx = 0;
            gbc_jLabel3.gridy = 5;
            this.panel_1.add((Component)this.jLabel3, gbc_jLabel3);
            this.jLabel3.setText("Movie Producer:");
            GridBagConstraints gbc_movieProducerTypeChooser = new GridBagConstraints();
            gbc_movieProducerTypeChooser.weightx = 1.0;
            gbc_movieProducerTypeChooser.insets = new Insets(4, 4, 0, 0);
            gbc_movieProducerTypeChooser.fill = 1;
            gbc_movieProducerTypeChooser.gridx = 1;
            gbc_movieProducerTypeChooser.gridy = 5;
            this.panel_1.add((Component)this.getMovieProducerTypeChooser(), gbc_movieProducerTypeChooser);
        }
        return this.panel_1;
    }

    private JLabel getLblImageSize() {
        if (this.lblImageSize == null) {
            this.lblImageSize = new JLabel("Frame Size:");
        }
        return this.lblImageSize;
    }

    public long getTimeLength() {
        return this.timeLength;
    }

    public void setTimeLength(long timeLength) {
        this.timeLength = timeLength;
        this.refreshFrameCount();
    }

    private JPanel getPanel_2() {
        if (this.panel_2 == null) {
            this.panel_2 = new JPanel();
            GridBagLayout gbl_panel_2 = new GridBagLayout();
            gbl_panel_2.columnWidths = new int[]{0, 0, 0, 0};
            gbl_panel_2.rowHeights = new int[]{0, 0};
            gbl_panel_2.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_2.setLayout(gbl_panel_2);
            GridBagConstraints gbc_textFieldWidth = new GridBagConstraints();
            gbc_textFieldWidth.fill = 1;
            gbc_textFieldWidth.gridx = 0;
            gbc_textFieldWidth.gridy = 0;
            this.panel_2.add((Component)this.getTextFieldWidth(), gbc_textFieldWidth);
            GridBagConstraints gbc_lblX = new GridBagConstraints();
            gbc_lblX.insets = new Insets(4, 4, 4, 4);
            gbc_lblX.anchor = 13;
            gbc_lblX.gridx = 1;
            gbc_lblX.gridy = 0;
            this.panel_2.add((Component)this.getLblX(), gbc_lblX);
            GridBagConstraints gbc_textFieldHeight = new GridBagConstraints();
            gbc_textFieldHeight.fill = 1;
            gbc_textFieldHeight.gridx = 2;
            gbc_textFieldHeight.gridy = 0;
            this.panel_2.add((Component)this.getTextFieldHeight(), gbc_textFieldHeight);
        }
        return this.panel_2;
    }

    private JTextField getTextFieldWidth() {
        if (this.textFieldWidth == null) {
            this.textFieldWidth = new JTextField();
            this.textFieldWidth.setToolTipText("Image width");
            this.textFieldWidth.setOpaque(false);
            this.textFieldWidth.setColumns(5);
        }
        return this.textFieldWidth;
    }

    private JLabel getLblX() {
        if (this.lblX == null) {
            this.lblX = new JLabel("x");
        }
        return this.lblX;
    }

    private JTextField getTextFieldHeight() {
        if (this.textFieldHeight == null) {
            this.textFieldHeight = new JTextField();
            this.textFieldHeight.setToolTipText("Image height");
            this.textFieldHeight.setOpaque(false);
            this.textFieldHeight.setColumns(5);
        }
        return this.textFieldHeight;
    }

    private MovieProducerTypeChooser getMovieProducerTypeChooser() {
        if (this.movieProducerTypeChooser == null) {
            this.movieProducerTypeChooser = new MovieProducerTypeChooser();
            this.movieProducerTypeChooser.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!MovieGeneratorPanel.this.refreshing) {
                        MovieGeneratorPanel.this.apply();
                    }
                }
            });
        }
        return this.movieProducerTypeChooser;
    }

    private JLabel getLblStartTime() {
        if (this.lblStartTime == null) {
            this.lblStartTime = new JLabel("Start Time:");
        }
        return this.lblStartTime;
    }

    private JLabel getLblStopTime() {
        if (this.lblStopTime == null) {
            this.lblStopTime = new JLabel("Stop Time:");
        }
        return this.lblStopTime;
    }

    private JLabel getLblViewOptions() {
        if (this.lblViewOptions == null) {
            this.lblViewOptions = new JLabel("View Options:");
        }
        return this.lblViewOptions;
    }

    private JPanel getPanel_3() {
        if (this.panel_3 == null) {
            this.panel_3 = new JPanel();
            GridBagLayout gbl_panel_3 = new GridBagLayout();
            gbl_panel_3.columnWidths = new int[]{0, 0};
            gbl_panel_3.rowHeights = new int[]{0, 0, 0};
            gbl_panel_3.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_3.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panel_3.setLayout(gbl_panel_3);
            GridBagConstraints gbc_chckbxHideSelectionView = new GridBagConstraints();
            gbc_chckbxHideSelectionView.insets = new Insets(0, 0, 5, 0);
            gbc_chckbxHideSelectionView.anchor = 17;
            gbc_chckbxHideSelectionView.gridx = 0;
            gbc_chckbxHideSelectionView.gridy = 0;
            this.panel_3.add((Component)this.getChckbxHideSelectionView(), gbc_chckbxHideSelectionView);
            GridBagConstraints gbc_chckbxHidepositionbar = new GridBagConstraints();
            gbc_chckbxHidepositionbar.anchor = 17;
            gbc_chckbxHidepositionbar.gridx = 0;
            gbc_chckbxHidepositionbar.gridy = 1;
            this.panel_3.add((Component)this.getChckbxHidepositionbar(), gbc_chckbxHidepositionbar);
        }
        return this.panel_3;
    }

    private JPanel getPanel_4() {
        if (this.panel_4 == null) {
            this.panel_4 = new JPanel();
            GridBagLayout gbl_panel_4 = new GridBagLayout();
            gbl_panel_4.columnWidths = new int[]{0, 0, 0};
            gbl_panel_4.rowHeights = new int[]{0, 0};
            gbl_panel_4.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_4.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_4.setLayout(gbl_panel_4);
            GridBagConstraints gbc_textFieldStartTime = new GridBagConstraints();
            gbc_textFieldStartTime.insets = new Insets(0, 0, 0, 5);
            gbc_textFieldStartTime.weightx = 1.0;
            gbc_textFieldStartTime.fill = 1;
            gbc_textFieldStartTime.gridx = 0;
            gbc_textFieldStartTime.gridy = 0;
            this.panel_4.add((Component)this.getTextFieldStartTime(), gbc_textFieldStartTime);
            GridBagConstraints gbc_btnTostart = new GridBagConstraints();
            gbc_btnTostart.gridx = 1;
            gbc_btnTostart.gridy = 0;
            this.panel_4.add((Component)this.getBtnTostart(), gbc_btnTostart);
        }
        return this.panel_4;
    }

    private JPanel getPanel_5() {
        if (this.panel_5 == null) {
            this.panel_5 = new JPanel();
            GridBagLayout gbl_panel_5 = new GridBagLayout();
            gbl_panel_5.columnWidths = new int[]{0, 0, 0};
            gbl_panel_5.rowHeights = new int[]{0, 0};
            gbl_panel_5.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_5.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_5.setLayout(gbl_panel_5);
            GridBagConstraints gbc_textFieldStopTime = new GridBagConstraints();
            gbc_textFieldStopTime.insets = new Insets(0, 0, 0, 5);
            gbc_textFieldStopTime.weightx = 1.0;
            gbc_textFieldStopTime.fill = 1;
            gbc_textFieldStopTime.gridx = 0;
            gbc_textFieldStopTime.gridy = 0;
            this.panel_5.add((Component)this.getTextFieldStopTime(), gbc_textFieldStopTime);
            GridBagConstraints gbc_btnToend = new GridBagConstraints();
            gbc_btnToend.gridx = 1;
            gbc_btnToend.gridy = 0;
            this.panel_5.add((Component)this.getBtnToend(), gbc_btnToend);
        }
        return this.panel_5;
    }

    private JPanel getPanel_6() {
        if (this.panel_6 == null) {
            this.panel_6 = new JPanel();
            this.panel_6.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Movie Generator", 4, 2, null, null));
            GridBagLayout gbl_panel_6 = new GridBagLayout();
            gbl_panel_6.columnWidths = new int[]{0, 0};
            gbl_panel_6.rowHeights = new int[]{0, 0};
            gbl_panel_6.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_6.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_6.setLayout(gbl_panel_6);
            GridBagConstraints gbc_panel_1 = new GridBagConstraints();
            gbc_panel_1.weighty = 1.0;
            gbc_panel_1.weightx = 1.0;
            gbc_panel_1.fill = 1;
            gbc_panel_1.insets = new Insets(4, 4, 4, 4);
            gbc_panel_1.gridx = 0;
            gbc_panel_1.gridy = 0;
            this.panel_6.add((Component)this.getPanel_1(), gbc_panel_1);
        }
        return this.panel_6;
    }

    private JCheckBox getChckbxHidepositionbar() {
        if (this.chckbxHidepositionbar == null) {
            this.chckbxHidepositionbar = new JCheckBox("Hide Position view");
            this.chckbxHidepositionbar.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!MovieGeneratorPanel.this.refreshing) {
                        MovieGeneratorPanel.this.apply();
                    }
                }
            });
            this.chckbxHidepositionbar.setToolTipText("Hide time-position bar view");
        }
        return this.chckbxHidepositionbar;
    }

    private JTextField getTextFieldStartTime() {
        if (this.textFieldStartTime == null) {
            this.textFieldStartTime = new JTextField();
            this.textFieldStartTime.setToolTipText("Start time in seconds");
            this.textFieldStartTime.setOpaque(false);
            this.textFieldStartTime.setColumns(10);
        }
        return this.textFieldStartTime;
    }

    private JTextField getTextFieldStopTime() {
        if (this.textFieldStopTime == null) {
            this.textFieldStopTime = new JTextField();
            this.textFieldStopTime.setToolTipText("Stop time in seconds");
            this.textFieldStopTime.setOpaque(false);
            this.textFieldStopTime.setColumns(10);
        }
        return this.textFieldStopTime;
    }

    private JTextField getTextFieldFrameCount() {
        if (this.textFieldFrameCount == null) {
            this.textFieldFrameCount = new JTextField();
            this.textFieldFrameCount.setEditable(false);
            this.textFieldFrameCount.setOpaque(false);
            this.textFieldFrameCount.setColumns(15);
        }
        return this.textFieldFrameCount;
    }

    protected void initMovieGeneratorPanel() {
        this.getJTextFieldFrameRate().setText("25");
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleEvent();
            }

            protected void handleEvent() {
                if (!MovieGeneratorPanel.this.refreshing) {
                    MovieGeneratorPanel.this.apply();
                }
                MovieGeneratorPanel.this.refreshFrameCount();
            }
        };
        this.getTextFieldStartTime().getDocument().addDocumentListener(documentListener);
        this.getTextFieldStopTime().getDocument().addDocumentListener(documentListener);
        this.getJTextFieldFrameRate().getDocument().addDocumentListener(documentListener);
        this.getTextFieldWidth().getDocument().addDocumentListener(documentListener);
        this.getTextFieldHeight().getDocument().addDocumentListener(documentListener);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            double startSecs = (double)this.getStartTime() / 1.0E9;
            double stopSecs = (double)this.getStopTime() / 1.0E9;
            this.getTextFieldStartTime().setText(String.valueOf(Math.floor(startSecs * 1000.0) / 1000.0));
            this.getTextFieldStopTime().setText(String.valueOf(Math.ceil(stopSecs * 1000.0) / 1000.0));
            String sFrameRate = String.valueOf(this.getFrameRate());
            if (sFrameRate.endsWith(".0")) {
                sFrameRate = sFrameRate.substring(0, sFrameRate.length() - 2);
            }
            this.getJTextFieldFrameRate().setText(sFrameRate);
            this.getChckbxHidepositionbar().setSelected(this.isHidePositionBar());
            this.getChckbxHideSelectionView().setSelected(this.isHideSelectionView());
            this.getTextFieldWidth().setText(String.valueOf(this.getImageWidth()));
            this.getTextFieldHeight().setText(String.valueOf(this.getImageHeight()));
            this.getMovieProducerTypeChooser().setMovieProducerTypes(this.getMovieProducerTypes());
            this.getMovieProducerTypeChooser().setMovieProducerType(this.getMovieProducerType());
        }
        finally {
            this.refreshing = false;
        }
        this.checkEnable();
    }

    protected synchronized void apply() {
        long startTime = -1L;
        try {
            startTime = (long)(Double.parseDouble(this.getTextFieldStartTime().getText().trim()) * 1.0E9);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        long stopTime = -1L;
        try {
            stopTime = (long)(Double.parseDouble(this.getTextFieldStopTime().getText().trim()) * 1.0E9);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        float frameRate = -1.0f;
        try {
            frameRate = Float.parseFloat(this.getJTextFieldFrameRate().getText().trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        boolean hidePositionBar = this.getChckbxHidepositionbar().isSelected();
        boolean hideSelectionView = this.getChckbxHideSelectionView().isSelected();
        int imageWidth = -1;
        try {
            imageWidth = Integer.parseInt(this.getTextFieldWidth().getText().trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int imageHeight = -1;
        try {
            imageHeight = Integer.parseInt(this.getTextFieldHeight().getText().trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        MovieProducerType movieProducerType = this.getMovieProducerTypeChooser().getMovieProducerType();
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.frameRate = frameRate;
        this.hidePositionBar = hidePositionBar;
        this.hideSelectionView = hideSelectionView;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.movieProducerType = movieProducerType;
        this.checkEnable();
    }

    protected synchronized void checkEnable() {
        long timeLen;
        Color normalForeground = this.getForeground();
        Color errorForeground = Color.RED;
        long startTime = this.getStartTime();
        long stopTime = this.getStopTime();
        if (stopTime < startTime) {
            stopTime = -1L;
        }
        if (startTime > (timeLen = this.getTimeLength())) {
            startTime = -1L;
        }
        if (stopTime > timeLen + 1000000L) {
            stopTime = -1L;
        }
        this.getTextFieldStartTime().setForeground(startTime < 0L ? errorForeground : normalForeground);
        this.getTextFieldStopTime().setForeground(stopTime < 0L ? errorForeground : normalForeground);
        double frameRate = this.getFrameRate();
        this.getJTextFieldFrameRate().setForeground(frameRate <= 0.0 ? errorForeground : normalForeground);
        int imageWidth = this.getImageWidth();
        this.getTextFieldWidth().setForeground(imageWidth <= 0 ? errorForeground : normalForeground);
        int imageHeight = this.getImageHeight();
        this.getTextFieldHeight().setForeground(imageHeight <= 0 ? errorForeground : normalForeground);
        this.refreshFrameCount();
    }

    protected void refreshFrameCount() {
        long timeNanos;
        long timeLen = this.getTimeLength();
        long startTime = this.getStartTime();
        long stopTime = this.getStopTime();
        double frameRate = this.getFrameRate();
        if (startTime < 0L) {
            startTime = 0L;
        }
        if (startTime > timeLen) {
            startTime = timeLen;
        }
        if (stopTime < 0L) {
            stopTime = timeLen;
        }
        if (stopTime > timeLen) {
            stopTime = timeLen;
        }
        if ((timeNanos = stopTime - startTime) < 0L) {
            timeNanos = 0L;
        }
        long frames = -1L;
        if (frameRate > 0.0) {
            int integerFrames;
            long timeInc = LineUtil.getNanoOfs((long)1L, (double)frameRate);
            double doubleFrames = (double)timeNanos / (double)timeInc;
            if (doubleFrames > (double)(integerFrames = (int)doubleFrames)) {
                ++integerFrames;
            }
            frames = 1 + integerFrames;
        }
        if (frames < 0L) {
            frames = 0L;
        }
        this.getTextFieldFrameCount().setText("Total " + String.valueOf(frames) + " frame(s)");
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.refresh();
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
        this.refresh();
    }

    public boolean isHidePositionBar() {
        return this.hidePositionBar;
    }

    public void setHidePositionBar(boolean hidePositionBar) {
        this.hidePositionBar = hidePositionBar;
        this.refresh();
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
        this.refresh();
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
        this.refresh();
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
        this.refresh();
    }

    public MovieProducerType[] getMovieProducerTypes() {
        return this.movieProducerTypes;
    }

    public void setMovieProducerTypes(MovieProducerType[] movieProducerTypes) {
        this.movieProducerTypes = movieProducerTypes;
        this.refresh();
    }

    public MovieProducerType getMovieProducerType() {
        return this.movieProducerType;
    }

    public void setMovieProducerType(MovieProducerType movieProducerType) {
        this.movieProducerType = movieProducerType;
        this.refresh();
    }

    private JButton getBtnTostart() {
        if (this.btnTostart == null) {
            this.btnTostart = new JButton("|<");
            this.btnTostart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MovieGeneratorPanel.this.actionMinimumStartTime();
                }
            });
            this.btnTostart.setMargin(new Insets(2, 4, 2, 4));
            this.btnTostart.setToolTipText("From start");
        }
        return this.btnTostart;
    }

    private JButton getBtnToend() {
        if (this.btnToend == null) {
            this.btnToend = new JButton(">|");
            this.btnToend.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MovieGeneratorPanel.this.actionMaximumStopTime();
                }
            });
            this.btnToend.setMargin(new Insets(2, 4, 2, 4));
            this.btnToend.setToolTipText("Until end");
        }
        return this.btnToend;
    }

    protected void actionMinimumStartTime() {
        double secs = 0.0;
        this.getTextFieldStartTime().setText(String.valueOf(secs));
    }

    protected void actionMaximumStopTime() {
        double secs = (double)this.getTimeLength() / 1.0E9;
        this.getTextFieldStopTime().setText(String.valueOf(Math.ceil(secs * 1000.0) / 1000.0));
    }

    private JCheckBox getChckbxHideSelectionView() {
        if (this.chckbxHideSelectionView == null) {
            this.chckbxHideSelectionView = new JCheckBox("Hide Selection view");
            this.chckbxHideSelectionView.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!MovieGeneratorPanel.this.refreshing) {
                        MovieGeneratorPanel.this.apply();
                    }
                }
            });
        }
        return this.chckbxHideSelectionView;
    }

    public boolean isHideSelectionView() {
        return this.hideSelectionView;
    }

    public void setHideSelectionView(boolean hideSelectionView) {
        this.hideSelectionView = hideSelectionView;
        this.refresh();
    }
}

