/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.movie.MovieProducer;
import com.waxmonster.model.LineUtil;
import com.waxmonster.waxlab.view.MultiLineContent;
import com.waxmonster.waxlab.view.MultiLinePanel;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.swing.SwingUtilities;

public class MovieGeneratorTask
extends AbstractExecution {
    private MultiLinePanel linePanel;
    private long lineOfs;
    private long lineEnd;
    private MultiLineContent viewComponent;
    private int imageWidth;
    private int imageHeight;
    private int imageType;
    private double frameRate;
    private MovieProducer movieProducer;
    private Runnable postHook;

    public MovieGeneratorTask() {
        this.setName("Movie Generator");
        this.setDescription(this.getName());
    }

    public boolean isPauseSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        long oldTimePos = -1L;
        try {
            oldTimePos = this.linePanel.getTimePosition();
            this.perform();
        }
        finally {
            Runnable hook;
            if (oldTimePos >= 0L) {
                this.linePanel.updateTimePosition(oldTimePos);
            }
            if ((hook = this.getPostHook()) != null) {
                SwingUtilities.invokeLater(hook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void perform() throws Exception {
        int integerFrames;
        long timeInc;
        double doubleFrames;
        double frameRate = this.frameRate;
        if (frameRate <= 0.0) {
            throw new IllegalArgumentException("frameRate <= 0");
        }
        long lineOfs = this.getLineOfs();
        long lineEnd = this.getLineEnd();
        long timeNanos = lineEnd - lineOfs;
        if (timeNanos < 0L) {
            timeNanos = 0L;
        }
        if ((doubleFrames = (double)timeNanos / (double)(timeInc = LineUtil.getNanoOfs((long)1L, (double)frameRate))) > (double)(integerFrames = (int)doubleFrames)) {
            ++integerFrames;
        }
        int frames = 1 + integerFrames;
        int x = 0;
        int y = 0;
        int width = this.getImageWidth();
        int height = this.getImageHeight();
        int imageType = this.getImageType();
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics2D g = image.createGraphics();
        try {
            g.translate(x, y);
            g.setClip(0, 0, width, height);
            MultiLineContent viewComponent = this.getViewComponent();
            ImageGenerator imageGenerator = new ImageGenerator(viewComponent, g);
            MovieProducer movieProducer = this.getMovieProducer();
            if (movieProducer == null) {
                throw new IllegalArgumentException("MovieProducer is null");
            }
            try {
                double framesPerSecond = frameRate;
                long maxFrames = frames;
                movieProducer.begin(framesPerSecond, maxFrames);
            }
            catch (Exception e) {
                String msg = "Failed to begin movie producer: " + movieProducer + ", Cause=" + e;
                throw new RuntimeException(msg, e);
            }
            long timePos = lineOfs;
            for (int i = 0; i < frames && this.getSignal() == 0; ++i) {
                this.setProgress((double)i / (double)frames);
                this.linePanel.updateTimePosition(timePos);
                SwingUtilities.invokeAndWait(imageGenerator);
                try {
                    movieProducer.appendImage((RenderedImage)image);
                }
                catch (Exception e) {
                    String msg = "Failed to generate movie frame: #" + i + " of " + frames + ", movieProducer=" + movieProducer + ", Cause=" + e;
                    throw new RuntimeException(msg, e);
                }
                if ((timePos += timeInc) <= lineEnd) continue;
                timePos = lineEnd;
            }
            try {
                movieProducer.finish();
            }
            catch (Exception e) {
                String msg = "Failed to finish movie producer: " + movieProducer + ", Cause=" + e;
                throw new RuntimeException(msg, e);
            }
            this.setProgress(1.0);
        }
        finally {
            g.dispose();
            image.flush();
        }
    }

    public MultiLinePanel getLinePanel() {
        return this.linePanel;
    }

    public void setLinePanel(MultiLinePanel linePanel) {
        this.linePanel = linePanel;
    }

    public MultiLineContent getViewComponent() {
        return this.viewComponent;
    }

    public void setViewComponent(MultiLineContent viewComponent) {
        this.viewComponent = viewComponent;
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int imageType) {
        this.imageType = imageType;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public MovieProducer getMovieProducer() {
        return this.movieProducer;
    }

    public void setMovieProducer(MovieProducer movieProducer) {
        this.movieProducer = movieProducer;
    }

    public Runnable getPostHook() {
        return this.postHook;
    }

    public void setPostHook(Runnable postHook) {
        this.postHook = postHook;
    }

    public long getLineOfs() {
        return this.lineOfs;
    }

    public void setLineOfs(long lineOfs) {
        this.lineOfs = lineOfs;
    }

    public long getLineEnd() {
        return this.lineEnd;
    }

    public void setLineEnd(long lineEnd) {
        this.lineEnd = lineEnd;
    }

    protected class ImageGenerator
    implements Runnable {
        private MultiLineContent viewComponent;
        private Graphics2D g;

        public ImageGenerator(MultiLineContent viewComponent, Graphics2D g) {
            this.viewComponent = viewComponent;
            this.g = g;
        }

        @Override
        public void run() {
            this.viewComponent.paintComponent(this.g);
        }
    }
}

