/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.movie.MovieProducer;
import com.spacekiller.util.movie.MovieProducerType;
import com.spacekiller.util.movie.plugin.MoviePlugin;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.MovieGeneratorOptions;
import com.waxmonster.waxlab.view.MovieGeneratorPanel;
import com.waxmonster.waxlab.view.MovieGeneratorTask;
import com.waxmonster.waxlab.view.MultiLineContent;
import com.waxmonster.waxlab.view.MultiLinePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JViewport;

public class MovieGeneratorUtil {
    private static final Logger logger = Logger.getLogger(MovieGeneratorUtil.class.getName());

    public MovieGeneratorOptions showMovieGeneratorDialog(final MultiLinePanel linePanel, MultiLineContent lineComponent, JViewport lineViewport, MovieGeneratorOptions options) throws Exception {
        AbstractWaxLabPanel waxLabPanel;
        long lineEnd;
        int imageHeight;
        double frameRate = options.getFrameRate();
        boolean hideSelectionBar = options.isHideSelectionBar();
        boolean hidePositionBar = options.isHidePositionBar();
        int viewCompWidth = lineComponent.getWidth();
        int viewCompHeight = lineComponent.getHeight();
        int imageWidth = options.getImageWidth();
        if (imageWidth < 1) {
            imageWidth = viewCompWidth;
        }
        if ((imageHeight = options.getImageHeight()) < 1) {
            imageHeight = viewCompHeight;
        }
        long timeLen = linePanel.getTimeLength();
        long lineOfs = options.getLineOfs();
        if (lineOfs < 0L) {
            lineOfs = 0L;
        }
        if (lineOfs > timeLen) {
            lineOfs = timeLen;
        }
        if ((lineEnd = options.getLineEnd()) < 0L) {
            lineEnd = timeLen;
        }
        if (lineEnd > timeLen) {
            lineEnd = timeLen;
        }
        long selectionAnchorPos = linePanel.getSelectionAnchorPos();
        long selectionLeadPos = linePanel.getSelectionLeadPos();
        if (selectionAnchorPos >= 0L && selectionLeadPos >= 0L) {
            long selectionStartTime = Math.min(selectionAnchorPos, selectionLeadPos);
            long selectionStopTime = Math.max(selectionAnchorPos, selectionLeadPos);
            lineOfs = selectionStartTime;
            lineEnd = selectionStopTime;
        }
        MovieProducerType[] movieProducerTypes = MoviePlugin.getInstance().getMovieProducerTypes();
        if (logger.isLoggable(Level.FINE)) {
            int numTypes = movieProducerTypes == null ? 0 : movieProducerTypes.length;
            logger.fine("Available MovieProducerType(s): " + numTypes);
        }
        String movieProducerTypeId = options.getMovieProducerTypeId();
        MovieProducerType movieProducerType = null;
        if (movieProducerTypes != null && movieProducerTypes.length > 0) {
            if (movieProducerTypeId != null) {
                int numTypes = movieProducerTypes.length;
                for (int i = 0; i < numTypes; ++i) {
                    MovieProducerType mpt = movieProducerTypes[i];
                    if (mpt == null || !movieProducerTypeId.equals(mpt.getId())) continue;
                    movieProducerType = mpt;
                    break;
                }
            }
            if (movieProducerType == null) {
                movieProducerType = movieProducerTypes[0];
            }
        }
        MovieGeneratorPanel panel = new MovieGeneratorPanel();
        panel.setTimeLength(timeLen);
        panel.setStartTime(lineOfs);
        panel.setStopTime(lineEnd);
        panel.setImageWidth(imageWidth);
        panel.setImageHeight(imageHeight);
        panel.setFrameRate(frameRate);
        panel.setHideSelectionView(hideSelectionBar);
        panel.setHidePositionBar(hidePositionBar);
        panel.setMovieProducerTypes(movieProducerTypes);
        panel.setMovieProducerType(movieProducerType);
        String title = "Movie Generator";
        int optionType = 2;
        int msgType = -1;
        Icon icon = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/movie_generator_icon48.png");
        int rc = JOptionPane.showConfirmDialog(linePanel, panel, title, optionType, msgType, icon);
        if (rc != 0) {
            return null;
        }
        lineOfs = panel.getStartTime();
        lineEnd = panel.getStopTime();
        hideSelectionBar = panel.isHideSelectionView();
        hidePositionBar = panel.isHidePositionBar();
        boolean hideFaderRecordingHelper = true;
        boolean hideMidiRecordingHelper = true;
        imageWidth = panel.getImageWidth();
        imageHeight = panel.getImageHeight();
        frameRate = panel.getFrameRate();
        movieProducerType = panel.getMovieProducerType();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("MovieProducerType: " + movieProducerType);
        }
        if (movieProducerType == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("No MovieProducerType selected!");
            }
            return null;
        }
        if (frameRate <= 0.0) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Invalid frame rate specified: " + frameRate);
            }
            return null;
        }
        if (lineOfs < 0L) {
            lineOfs = 0L;
        }
        if (lineEnd < 0L) {
            lineEnd = timeLen;
        }
        if (lineEnd > timeLen) {
            lineEnd = timeLen;
        }
        if (lineEnd < lineOfs) {
            lineEnd = lineOfs;
        }
        int frameWidth = imageWidth / 2 * 2;
        int frameHeight = imageHeight / 2 * 2;
        if (frameWidth < 0) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Invalid frame width specified: " + imageWidth);
            }
            return null;
        }
        if (frameHeight < 0) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Invalid frame height specified: " + imageHeight);
            }
            return null;
        }
        MovieGeneratorOptions newOptions = new MovieGeneratorOptions();
        newOptions.setLineOfs(lineOfs);
        newOptions.setLineEnd(lineEnd);
        newOptions.setImageWidth(frameWidth);
        newOptions.setImageHeight(frameHeight);
        newOptions.setFrameRate(frameRate);
        newOptions.setHidePositionBar(hidePositionBar);
        newOptions.setHideSelectionBar(hideSelectionBar);
        movieProducerTypeId = movieProducerType.getId();
        newOptions.setMovieProducerTypeId(movieProducerTypeId);
        MovieProducer movieProducer = movieProducerType.createMovieProducer();
        Properties movieProducerProps = options.getMovieProducerProperties();
        if (movieProducerProps != null) {
            movieProducer.setProperties(movieProducerProps);
        }
        if (!movieProducer.showConfigDialog((Component)linePanel)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("MovieProducer dialog cancelled: " + movieProducer);
            }
            return null;
        }
        movieProducerProps = movieProducer.getProperties();
        newOptions.setMovieProducerProperties(movieProducerProps);
        Component parentInternalFrame = null;
        Component parentDetachedFrame = null;
        Dimension parentInternalFrameOldSize = null;
        Dimension parentDetachedFrameOldSize = null;
        if (frameWidth != viewCompWidth || frameHeight != viewCompHeight) {
            Dimension newSize;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Resizing component for movie generator: " + frameWidth + " x " + frameHeight);
            }
            for (Container comp = linePanel; comp != null; comp = comp.getParent()) {
                if (comp instanceof JInternalFrame) {
                    parentInternalFrame = (JInternalFrame)comp;
                    break;
                }
                if (!(comp instanceof JFrame)) continue;
                parentDetachedFrame = (JFrame)comp;
                break;
            }
            if (parentInternalFrame != null) {
                parentInternalFrameOldSize = parentInternalFrame.getSize();
                newSize = new Dimension();
                newSize.width = Math.max(0, parentInternalFrameOldSize.width - lineViewport.getWidth()) + frameWidth;
                newSize.height = Math.max(0, parentInternalFrameOldSize.height - lineViewport.getHeight()) + frameHeight;
                parentInternalFrame.setSize(newSize);
                ((Container)parentInternalFrame).validate();
                parentInternalFrame.repaint();
                logger.info("parentInternalFrame: size=" + parentInternalFrame.getSize());
            }
            if (parentDetachedFrame != null) {
                parentDetachedFrameOldSize = parentDetachedFrame.getSize();
                newSize = new Dimension();
                newSize.width = Math.max(0, parentDetachedFrameOldSize.width - lineViewport.getWidth()) + frameWidth;
                newSize.height = Math.max(0, parentDetachedFrameOldSize.height - lineViewport.getHeight()) + frameHeight;
                ((Window)parentDetachedFrame).setSize(newSize);
                ((Container)parentDetachedFrame).validate();
                parentDetachedFrame.repaint();
                logger.info("parentDetachedFrame: size=" + parentDetachedFrame.getSize());
            }
            logger.info("lineViewport: size=" + lineViewport.getSize());
            logger.info("viewComponent: size=" + lineComponent.getSize());
        }
        long oldTimeScrollPos = linePanel.getTimeScrollPosition();
        linePanel.setHidePositionBarView(hidePositionBar);
        linePanel.setHideFaderRecordingHelperView(hideFaderRecordingHelper);
        linePanel.setHideMidiRecordingHelperView(hideMidiRecordingHelper);
        boolean wasHideSelectionBar = hideSelectionBar;
        long oldCursorPos = linePanel.getCursorPosition();
        long oldSelAnchorPos = linePanel.getSelectionAnchorPos();
        long oldSelLeadPos = linePanel.getSelectionLeadPos();
        if (hideSelectionBar) {
            linePanel.setSelectionAnchorPos(-1L);
            linePanel.setSelectionLeadPos(-1L);
            linePanel.setCursorPosition(-1L);
        }
        if ((waxLabPanel = linePanel.getWaxLabPanel()) != null) {
            waxLabPanel.refresh();
        }
        linePanel.refresh();
        Component finalParentInternalFrame = parentInternalFrame;
        Component finalParentDetachedFrame = parentDetachedFrame;
        Dimension finalParentInternalFrameOldSize = parentInternalFrameOldSize;
        Dimension finalParentDetachedFrameOldSize = parentDetachedFrameOldSize;
        Runnable postHook = new Runnable((JInternalFrame)finalParentInternalFrame, finalParentInternalFrameOldSize, (JFrame)finalParentDetachedFrame, finalParentDetachedFrameOldSize, wasHideSelectionBar, oldSelAnchorPos, oldSelLeadPos, oldCursorPos, oldTimeScrollPos){
            final /* synthetic */ JInternalFrame val$finalParentInternalFrame;
            final /* synthetic */ Dimension val$finalParentInternalFrameOldSize;
            final /* synthetic */ JFrame val$finalParentDetachedFrame;
            final /* synthetic */ Dimension val$finalParentDetachedFrameOldSize;
            final /* synthetic */ boolean val$wasHideSelectionBar;
            final /* synthetic */ long val$oldSelAnchorPos;
            final /* synthetic */ long val$oldSelLeadPos;
            final /* synthetic */ long val$oldCursorPos;
            final /* synthetic */ long val$oldTimeScrollPos;
            {
                this.val$finalParentInternalFrame = jInternalFrame;
                this.val$finalParentInternalFrameOldSize = dimension;
                this.val$finalParentDetachedFrame = jFrame;
                this.val$finalParentDetachedFrameOldSize = dimension2;
                this.val$wasHideSelectionBar = bl;
                this.val$oldSelAnchorPos = l;
                this.val$oldSelLeadPos = l2;
                this.val$oldCursorPos = l3;
                this.val$oldTimeScrollPos = l4;
            }

            @Override
            public void run() {
                linePanel.setHidePositionBarView(true);
                linePanel.setHideFaderRecordingHelperView(true);
                linePanel.setHideMidiRecordingHelperView(true);
                if (this.val$finalParentInternalFrame != null && this.val$finalParentInternalFrameOldSize != null) {
                    this.val$finalParentInternalFrame.setSize(this.val$finalParentInternalFrameOldSize);
                    this.val$finalParentInternalFrame.validate();
                    this.val$finalParentInternalFrame.repaint();
                }
                if (this.val$finalParentDetachedFrame != null && this.val$finalParentDetachedFrameOldSize != null) {
                    this.val$finalParentDetachedFrame.setSize(this.val$finalParentDetachedFrameOldSize);
                    this.val$finalParentDetachedFrame.validate();
                    this.val$finalParentDetachedFrame.repaint();
                }
                if (this.val$wasHideSelectionBar) {
                    linePanel.setSelectionAnchorPos(this.val$oldSelAnchorPos);
                    linePanel.setSelectionLeadPos(this.val$oldSelLeadPos);
                    linePanel.setCursorPosition(this.val$oldCursorPos);
                }
                linePanel.setTimeScrollPosition(this.val$oldTimeScrollPos);
                linePanel.refresh();
            }
        };
        int imageType = 1;
        MovieGeneratorTask mg = new MovieGeneratorTask();
        mg.setLinePanel(linePanel);
        mg.setLineOfs(newOptions.getLineOfs());
        mg.setLineEnd(newOptions.getLineEnd());
        mg.setViewComponent(lineComponent);
        mg.setImageWidth(newOptions.getImageWidth());
        mg.setImageHeight(newOptions.getImageHeight());
        mg.setImageType(imageType);
        mg.setFrameRate(newOptions.getFrameRate());
        mg.setMovieProducer(movieProducer);
        mg.setPostHook(postHook);
        ExecutionManager execMan = Platform.getInstance().getExecutionManager();
        if (execMan != null) {
            execMan.addExecution((Execution)mg);
        }
        mg.start();
        return newOptions;
    }
}

