/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.view.View;
import com.waxmonster.waxlab.view.MultiLinePanel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class MultiLineContent
extends JComponent {
    private static final long serialVersionUID = -3032998034577244321L;
    public static final View[] NONE = new View[0];
    private View[] views = NONE;
    private boolean opaque;
    private Paint back;
    private Rectangle clip = this.getBounds();
    private int width;
    private int height;
    private MultiLinePanel linePanel;

    public MultiLineContent() {
        this.width = this.clip.width;
        this.height = this.clip.height;
        this.opaque = this.isOpaque();
    }

    public MultiLinePanel getLinePanel() {
        return this.linePanel;
    }

    public void setLinePanel(MultiLinePanel linePanel) {
        this.linePanel = linePanel;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Paint p;
        Graphics2D g2d = (Graphics2D)g;
        Rectangle r = g2d.getClipBounds(this.clip);
        if (r != this.clip && r != null) {
            this.clip = r;
        }
        if (this.opaque && (p = this.back) != null) {
            g2d.setPaint(p);
            g2d.fillRect(0, 0, this.width, this.height);
        }
        View[] views = this.views;
        int n = views.length;
        int tx = 0;
        int ty = 0;
        Rectangle clip = g2d.getClipBounds();
        for (int i = 0; i < n; ++i) {
            View v = views[i];
            Rectangle vb = v.getBounds();
            if (!r.intersects(vb)) continue;
            tx = vb.x;
            ty = vb.y;
            g2d.translate(tx, ty);
            g2d.clipRect(0, 0, vb.width, vb.height);
            v.paint(g2d);
            g2d.translate(-tx, -ty);
            g2d.setClip(clip);
        }
        MultiLinePanel lp = this.linePanel;
        if (lp != null) {
            lp.paintViewForeground(g2d);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        this.opaque = isOpaque;
        super.setOpaque(isOpaque);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        super.setBounds(x, y, width, height);
    }

    public Paint getBack() {
        return this.back;
    }

    public void setBack(Paint back) {
        this.back = back;
    }

    public View[] getViews() {
        return this.views;
    }

    public void setViews(View[] views) {
        if (views == null) {
            throw new NullPointerException();
        }
        this.views = views;
    }

    public void repaintView(View view) {
        this.repaint(view.getBounds());
    }
}

