/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.view.ScrollView;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.LineHeaderPanel;
import com.waxmonster.waxlab.view.MultiLinePanel;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class MultiLineHeader
extends JComponent {
    private static final long serialVersionUID = 1684541669184878153L;
    private static final int[] NOTHING_SELECTED = new int[0];
    private MultiLinePanel linePanel;
    private int orientation;
    private boolean horiz;
    private AbstractLineWrapper[] lineWrappers;
    private List lineHeaderPanels;
    private int[] selectedLineIndices = NOTHING_SELECTED;
    private int focusLineIndex = -1;

    public MultiLineHeader() {
        this.lineHeaderPanels = new ArrayList();
        this.setOrientation(0);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.horiz = orientation == 0 || orientation == 1;
        this.validate();
    }

    public MultiLinePanel getLinePanel() {
        return this.linePanel;
    }

    public void setLinePanel(MultiLinePanel linePanel) {
        this.linePanel = linePanel;
    }

    public AbstractLineWrapper[] getLineWrappers() {
        return this.lineWrappers;
    }

    public synchronized void setLineWrappers(AbstractLineWrapper[] lineWrappers) {
        this.lineWrappers = lineWrappers;
        this.refresh();
    }

    public int[] getSelectedLineIndices() {
        return this.selectedLineIndices;
    }

    public void setSelectedLineIndices(int[] selectedLineIndices) {
        if (selectedLineIndices == null) {
            selectedLineIndices = NOTHING_SELECTED;
        }
        this.selectedLineIndices = selectedLineIndices;
        this.validate();
    }

    protected boolean isLineSelected(int lineIndex) {
        if (lineIndex < 0) {
            return false;
        }
        int[] sel = this.selectedLineIndices;
        int n = sel.length;
        for (int i = 0; i < n; ++i) {
            if (sel[i] != lineIndex) continue;
            return true;
        }
        return false;
    }

    public int getFocusLineIndex() {
        return this.focusLineIndex;
    }

    public void setFocusLineIndex(int focusLineIndex) {
        if (this.focusLineIndex == focusLineIndex) {
            return;
        }
        this.focusLineIndex = focusLineIndex;
        this.validate();
    }

    public void refresh() {
        this.removeAll();
        this.lineHeaderPanels.clear();
        AbstractLineWrapper[] wrappers = this.getLineWrappers();
        int num = wrappers == null ? 0 : wrappers.length;
        for (int i = 0; i < num; ++i) {
            AbstractLineWrapper wrapper = wrappers[i];
            LineHeaderPanel lhp = wrapper.getLineHeaderPanel();
            if (lhp == null) continue;
            this.lineHeaderPanels.add(lhp);
            this.add(lhp);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void validate() {
        super.validate();
        int focusIndex = this.getFocusLineIndex();
        int num = this.lineHeaderPanels.size();
        for (int i = 0; i < num; ++i) {
            LineHeaderPanel lhp = (LineHeaderPanel)this.lineHeaderPanels.get(i);
            lhp.setLineSelected(this.isLineSelected(i));
            lhp.setLineFocused(focusIndex == i);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        int width = this.getWidth();
        int height = this.getHeight();
        int num = this.lineHeaderPanels.size();
        for (int i = 0; i < num; ++i) {
            Rectangle rect;
            ScrollView scrollView;
            int gridIndex;
            LineHeaderPanel lhp = (LineHeaderPanel)this.lineHeaderPanels.get(i);
            int x = -1;
            int y = -1;
            int w = 0;
            int h = 0;
            AbstractLineWrapper wrapper = lhp.getLineWrapper();
            if (wrapper != null && (gridIndex = wrapper.getGridIndex()) >= 0 && (scrollView = wrapper.getScrollView()) != null && (rect = scrollView.getBounds()) != null) {
                if (this.horiz) {
                    x = 0;
                    y = rect.y;
                    w = width;
                    h = rect.height;
                } else {
                    x = rect.x;
                    y = 0;
                    w = rect.width;
                    h = height;
                }
            }
            lhp.setBounds(x, y, w, h);
        }
    }

    public int computePrefWidth() {
        int maxWidth = 0;
        int num = this.lineHeaderPanels.size();
        for (int i = 0; i < num; ++i) {
            LineHeaderPanel lhp = (LineHeaderPanel)this.lineHeaderPanels.get(i);
            int w = lhp.getPreferredSize().width;
            if (w <= maxWidth) continue;
            maxWidth = w;
        }
        return maxWidth;
    }

    public int computePrefHeight() {
        int maxHeight = 0;
        int num = this.lineHeaderPanels.size();
        for (int i = 0; i < num; ++i) {
            LineHeaderPanel lhp = (LineHeaderPanel)this.lineHeaderPanels.get(i);
            int h = lhp.getPreferredSize().height;
            if (h <= maxHeight) continue;
            maxHeight = h;
        }
        return maxHeight;
    }
}

