/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.swing.LongJScrollBar;
import com.waxmonster.editor.ScratchPatternProvider;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.view.LineManager;
import com.waxmonster.view.ScrollPos;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewLayout;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.MovieGeneratorOptions;
import com.waxmonster.waxlab.view.MovieGeneratorUtil;
import com.waxmonster.waxlab.view.MultiLineContent;
import com.waxmonster.waxlab.view.MultiLineHeader;
import com.waxmonster.waxlab.view.MultiLineRuler;
import com.waxmonster.waxlab.view.MultiLineUtil;
import com.waxmonster.waxlab.view.PositionBarView;
import com.waxmonster.waxlab.view.RulerView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultiLinePanel
extends JPanel
implements LineManager {
    private static final long serialVersionUID = -1194041533853860562L;
    public static final String PROPERTY_FOCUS_LINE_INDEX = "focusLineIndex";
    public static final String PROPERTY_MAXIMIZED_LINE_INDEX = "maximizedLineIndex";
    public static final String PROPERTY_SELECTED_LINE_INDICES = "selectedLineIndices";
    private static final int DRAG_MODE_NONE = 0;
    private static final int DRAG_MODE_SELECT = 1;
    private static final int DRAG_MODE_RESIZE = 2;
    private static final int MOVE_MODE_CURSOR = 0;
    private static final int MOVE_MODE_SELECT = 1;
    private static final int MOVE_MODE_SCROLL = 2;
    private static final int[] NOTHING_SELECTED = new int[0];
    private static final double MIN_ZOOM_RATE = 30.0;
    private static final double MID_ZOOM_RATE = 150.0;
    private static final double MAX_ZOOM_RATE = 200000.0;
    private static final Logger logger = Logger.getLogger(MultiLinePanel.class.getName());
    private final AbstractWaxLabPanel waxLabPanel;
    private int orientation = 0;
    private boolean horiz = true;
    private JPanel controlPanel;
    private LongJScrollBar timeScrollBar;
    long timeScrollMax = 0L;
    long timeScrollExtent = 0L;
    long timeScrollUnit = 1L;
    long timeScrollBlock = 1L;
    private JSlider timeScaleSlider;
    private int scaleSliderSize = 80;
    private JScrollBar lineScrollBar;
    private JComponent cornerNorthWest;
    private JComponent cornerNorthEast;
    private JComponent cornerSouthWest;
    private JComponent cornerSouthEast;
    private JViewport headerViewport;
    private MultiLineHeader multiLineHeader;
    private MultiLineRuler multiLineRuler;
    private JViewport contentViewport;
    private MultiLineContent multiLineContent;
    private AbstractLineWrapper[] lineWrappers;
    private AbstractLineWrapper[] recWrappers;
    private View[] lineSeparators;
    private RulerView lineSeparatorRulerView;
    private TileView lineSeparatorTileView;
    private ScrollView lineSeparatorScrollView;
    private Paint backgroundPaint = Color.GRAY;
    private Paint selectionPaint = Color.BLUE;
    private Paint cursorPaint = Color.RED;
    private Paint rulerBackground = Color.WHITE;
    private Color rulerBorderColor = Color.BLACK;
    private Color rulerMinorTickColor = Color.GRAY;
    private Color rulerMajorTickColor = Color.DARK_GRAY;
    private Color rulerLabelColor = Color.BLACK;
    private int rulerMaxTileCacheCount = 5;
    private Font rulerLabelFont;
    private int rulerViewMode;
    private int focusLineIndex = -1;
    private int[] selectedLineIndices = NOTHING_SELECTED;
    private int maximizedLineIndex = -1;
    private boolean maximizedLineSwitchEnabled = true;
    private boolean maximizedLineSwitchRestore = true;
    private long timeLength = 0L;
    private double zoomRate = 150.0;
    private double minZoomRate = 30.0;
    private double midZoomRate = 150.0;
    private double maxZoomRate = 200000.0;
    private double pixNanos;
    private long visibleTime;
    private long visibleHalf;
    private int timeScrollUnitIncrement = 20;
    private int lineScrollUnitIncrement = 20;
    private boolean refreshing;
    private ScratchPatternProvider[] scratchPatternProviders;
    private JPopupMenu titlePopupMenu;
    private JPopupMenu rulerPopupMenu;
    private JPopupMenu cornerMenu;
    private PositionBarView positionBarView;
    private Rectangle positionBarBounds;
    private int positionBarSize;
    private int positionBarHalf;
    private int minorRulerTickCount = 10;
    private int lineSeparatorSize = 10;
    private Cursor defaultCursor;
    private Cursor resizeCursorHorizontal;
    private Cursor resizeCursorVertical;
    private DropTargetListener lineDropTargetListener;
    private ViewLayout viewLayout;
    private volatile long timeScrollPos;
    private volatile long timePosition = -1L;
    private long cursorPosition = 0L;
    private long selectionAnchorPos = -1L;
    private long selectionLeadPos = -1L;
    private int dragMode = 0;
    private int anchorX = -1;
    private int anchorY = -1;
    private int extendSelectionWidth = 2;
    private boolean snapLineGridEnabled = true;
    private int snapLineGridSize = 5;
    private int resizeLineIndex = -1;
    private int enteredLineIndex = -1;
    private int enteredSeparatorIndex = -1;
    private boolean enteredLeadPosition;
    private boolean enteredAnchorPosition;
    private int scrollUnitSize = 10;
    private Timer cursorMoveTimer;
    private CursorMover cursorMover;
    private int cursorMoveDelay = 10;
    private int cursorMoveInitialDelay = 100;
    private int cursorMoveIncrement;
    private int cursorMoveMode;
    private boolean cursorMoveSpeedup;
    private int cursorMoveCounter;
    private int cursorMoveFactor;
    private int cursorMoveMaxFactor = 100;
    private int cursorMoveSpeedupDelay = 20;
    private Point tempPoint = new Point();
    private boolean hidePositionBarView;
    private boolean hideFaderRecordingHelperView;
    private boolean hideMidiRecordingHelperView;
    private MovieGeneratorOptions movieGeneratorOptions;

    public MultiLinePanel(AbstractWaxLabPanel waxLabPanel) {
        this.waxLabPanel = waxLabPanel;
        this.initPanel();
    }

    private void initPanel() {
        this.defaultCursor = Cursor.getDefaultCursor();
        this.resizeCursorHorizontal = Cursor.getPredefinedCursor(11);
        this.resizeCursorVertical = Cursor.getPredefinedCursor(9);
        this.positionBarBounds = new Rectangle(0, 0, -1, -1);
        this.setPositionBarSize(5);
        this.lineWrappers = new AbstractLineWrapper[0];
        this.recWrappers = new AbstractLineWrapper[0];
        this.cursorMover = new CursorMover();
        this.cursorMoveTimer = new Timer(this.cursorMoveDelay, this.cursorMover);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new GridBagLayout());
        this.controlPanel.setOpaque(false);
        this.timeScrollBar = new LongJScrollBar();
        this.timeScrollBar.setLongMinimum(0L);
        this.timeScrollBar.setOrientation(0);
        this.timeScrollBar.setToolTipText("Time");
        this.timeScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!MultiLinePanel.this.refreshing) {
                    MultiLinePanel.this.handleScroll();
                }
            }
        });
        this.lineScrollBar = new JScrollBar();
        this.lineScrollBar.setOrientation(1);
        this.lineScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!MultiLinePanel.this.refreshing) {
                    MultiLinePanel.this.handleLineScroll();
                }
            }
        });
        this.timeScaleSlider = new JSlider();
        this.timeScaleSlider.setOrientation(0);
        this.timeScaleSlider.setToolTipText("Zoom");
        this.timeScaleSlider.setOpaque(false);
        this.timeScaleSlider.setBorder(new EtchedBorder(1));
        this.timeScaleSlider.setMinimum(0);
        this.timeScaleSlider.setMaximum(200);
        this.timeScaleSlider.setValue(100);
        this.timeScaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MultiLinePanel.this.handleScale();
            }
        });
        JButton cornerButton = new JButton();
        cornerButton.setToolTipText("Layout");
        URL imageURL = this.getClass().getResource("/com/waxmonster/waxlab/view/icons/corner_icon16.gif");
        if (imageURL != null) {
            cornerButton.setIcon(new ImageIcon(imageURL));
        } else {
            cornerButton.setText("x");
        }
        cornerButton.setMargin(new Insets(0, 0, 0, 0));
        int cornerSize = this.timeScrollBar.getPreferredSize().height;
        cornerButton.setMinimumSize(new Dimension(cornerSize, cornerSize));
        cornerButton.setPreferredSize(new Dimension(cornerSize, cornerSize));
        cornerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiLinePanel.this.handleCornerAction(e);
            }
        });
        this.cornerSouthEast = cornerButton;
        Color cornerBorderColor = new Color(0.6f, 0.6f, 0.6f);
        JPanel corner = new JPanel();
        corner.setBorder(new LineBorder(cornerBorderColor));
        corner.setOpaque(false);
        corner.setEnabled(false);
        this.cornerNorthWest = corner;
        corner = new JPanel();
        corner.setBorder(new LineBorder(cornerBorderColor));
        corner.setOpaque(false);
        corner.setEnabled(false);
        this.cornerNorthEast = corner;
        corner = new JPanel();
        corner.setBorder(new LineBorder(cornerBorderColor));
        corner.setOpaque(false);
        corner.setEnabled(false);
        this.cornerSouthWest = corner;
        this.multiLineContent = new MultiLineContent();
        this.multiLineContent.setLinePanel(this);
        this.multiLineContent.setOpaque(true);
        this.multiLineContent.setFocusable(true);
        this.multiLineContent.addKeyListener(new MultiLineUtil.ViewKeyHandler(this));
        this.multiLineContent.addMouseListener(new MultiLineUtil.ViewMouseHandler(this));
        this.multiLineContent.addMouseMotionListener(new MultiLineUtil.ViewMouseMotionHandler(this));
        this.multiLineContent.addMouseWheelListener(new MultiLineUtil.ViewMouseWheelHandler(this));
        this.contentViewport = new JViewport();
        this.contentViewport.setView(this.multiLineContent);
        this.multiLineHeader = new MultiLineHeader();
        this.multiLineHeader.setFocusable(true);
        this.multiLineHeader.addKeyListener(new MultiLineUtil.ViewKeyHandler(this));
        this.multiLineHeader.addMouseListener(new MultiLineUtil.TitleMouseHandler(this));
        this.multiLineHeader.setLinePanel(this);
        this.headerViewport = new JViewport();
        this.headerViewport.setView(this.multiLineHeader);
        this.multiLineRuler = new MultiLineRuler();
        this.multiLineRuler.setLinePanel(this);
        this.multiLineRuler.setFocusable(true);
        this.multiLineRuler.addKeyListener(new MultiLineUtil.ViewKeyHandler(this));
        this.multiLineRuler.addMouseListener(new MultiLineUtil.RulerMouseHandler(this));
        this.multiLineRuler.addMouseMotionListener(new MultiLineUtil.RulerMouseMotionHandler(this));
        this.multiLineRuler.addMouseWheelListener(new MultiLineUtil.RulerMouseWheelHandler(this));
        this.multiLineRuler.setBackPaint(this.rulerBackground);
        this.multiLineRuler.setRulerFont(this.rulerLabelFont);
        this.multiLineRuler.setStaticFont(this.rulerLabelFont);
        this.lineSeparatorRulerView = new RulerView();
        this.lineSeparatorRulerView.setBackPaint(null);
        this.lineSeparatorRulerView.setLabelPainted(false);
        this.setLayout(new GridBagLayout());
        this.setOrientation(0);
        this.handleScale();
        this.initActionMap();
        this.initInputMap();
    }

    protected void refresh() {
        Dimension scalePrefSize;
        int scaleOrient;
        PositionBarView posView;
        this.adjustTimeLength();
        this.removeAll();
        this.controlPanel.removeAll();
        LinkedList<Object> viewList = new LinkedList<Object>();
        for (AbstractLineWrapper wrapper : this.lineWrappers) {
            View[] fronts;
            this.refreshLineWrapper(wrapper);
            int gridIndex = wrapper.getGridIndex();
            if (gridIndex < 0) continue;
            ScrollView scrollView = wrapper.getScrollView();
            if (scrollView != null) {
                Rectangle bounds = scrollView.getBounds();
                Dimension viewSize = scrollView.getViewSize();
                viewSize.width = bounds.width;
                viewSize.height = bounds.height;
                scrollView.setViewSize(viewSize);
                viewList.add(scrollView);
            }
            if ((fronts = wrapper.getFrontViews()) == null) continue;
            for (int k = 0; k < fronts.length; ++k) {
                View fv = fronts[k];
                if (fv == null) continue;
                viewList.add(fv);
            }
        }
        if (this.lineSeparators != null) {
            int sn = this.lineSeparators.length;
            for (int i = 0; i < sn; ++i) {
                viewList.add(this.lineSeparators[i]);
            }
        }
        if ((posView = this.positionBarView) != null && !this.hidePositionBarView) {
            viewList.add((Object)posView);
        }
        this.multiLineContent.setBack(this.backgroundPaint);
        if (this.rulerLabelFont == null) {
            this.rulerLabelFont = this.multiLineRuler.getFont();
        }
        this.multiLineRuler.setRulerFont(this.rulerLabelFont);
        this.multiLineRuler.setStaticFont(this.rulerLabelFont);
        this.multiLineRuler.setRulerViewMode(this.rulerViewMode);
        View[] views = viewList.toArray(new View[viewList.size()]);
        this.multiLineContent.setViews(views);
        if (this.viewLayout != null) {
            Dimension prefHeaderSize;
            Dimension prefContentSize;
            int fh = this.multiLineHeader.getFontMetrics(this.multiLineHeader.getFont()).getHeight() + 2;
            Dimension prefRulerSize = new Dimension(fh, fh);
            if (this.horiz) {
                int vh = this.viewLayout.preferredLayoutSize().height;
                prefContentSize = new Dimension(fh, vh);
                int headerSize = this.multiLineHeader.computePrefWidth();
                prefHeaderSize = new Dimension(headerSize, vh);
            } else {
                int vw = this.viewLayout.preferredLayoutSize().width;
                prefContentSize = new Dimension(vw, fh);
                int headerSize = this.multiLineHeader.computePrefHeight();
                prefHeaderSize = new Dimension(vw, headerSize);
            }
            this.multiLineContent.setPreferredSize(prefContentSize);
            this.multiLineHeader.setPreferredSize(prefHeaderSize);
            this.multiLineHeader.setMinimumSize(prefHeaderSize);
            this.multiLineRuler.setPreferredSize(prefRulerSize);
            this.multiLineRuler.setMinimumSize(prefRulerSize);
        }
        this.multiLineHeader.setOrientation(this.orientation);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        if (this.horiz) {
            gbc.gridx = 0;
            gbc.gridy = 1;
        } else {
            gbc.gridx = 1;
            gbc.gridy = 0;
        }
        this.headerViewport.setMinimumSize(this.multiLineHeader.getMinimumSize());
        this.add((Component)this.headerViewport, gbc);
        this.refreshRuler();
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        if (this.horiz) {
            gbc.gridx = 1;
            gbc.gridy = 0;
        } else {
            gbc.gridx = 0;
            gbc.gridy = 1;
        }
        this.add((Component)this.multiLineRuler, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)this.contentViewport, gbc);
        this.timeScrollBar.setOrientation(this.horiz ? 0 : 1);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.controlPanel.add((Component)this.timeScrollBar, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        if (this.horiz) {
            scaleOrient = 0;
            scalePrefSize = new Dimension(this.scaleSliderSize, 10);
            gbc.gridx = 1;
            gbc.gridy = 0;
        } else {
            scaleOrient = 1;
            scalePrefSize = new Dimension(10, this.scaleSliderSize);
            gbc.gridx = 0;
            gbc.gridy = 1;
        }
        this.timeScaleSlider.setOrientation(scaleOrient);
        this.timeScaleSlider.setMinimumSize(scalePrefSize);
        this.timeScaleSlider.setPreferredSize(scalePrefSize);
        this.controlPanel.add((Component)this.timeScaleSlider, gbc);
        gbc = new GridBagConstraints();
        if (this.horiz) {
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
        } else {
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.fill = 3;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
        }
        this.add((Component)this.controlPanel, gbc);
        gbc = new GridBagConstraints();
        if (this.horiz) {
            this.lineScrollBar.setOrientation(1);
            gbc.fill = 3;
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
        } else {
            this.lineScrollBar.setOrientation(0);
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
        }
        this.add((Component)this.lineScrollBar, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.add((Component)this.cornerSouthEast, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.cornerNorthWest, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.add((Component)this.cornerNorthEast, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.add((Component)this.cornerSouthWest, gbc);
        this.validate();
        this.refreshTimeScrollBar();
        this.repaint();
        this.multiLineContent.requestFocus();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.horiz = orientation == 0 || orientation == 1;
        this.refresh();
        AbstractLineWrapper[] wrappers = this.lineWrappers;
        int n = wrappers.length;
        for (int i = 0; i < n; ++i) {
            this.refreshLineWrapper(wrappers[i]);
        }
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public long getTimeLength() {
        return this.timeLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTimeLength(long timeLength) {
        if (timeLength < this.timeLength) {
            if (this.selectionAnchorPos > timeLength) {
                this.selectionAnchorPos = timeLength;
            }
            if (this.selectionLeadPos > timeLength) {
                this.selectionLeadPos = timeLength;
            }
        }
        this.timeLength = timeLength;
        this.timeScrollMax = timeLength + this.visibleHalf;
        try {
            this.refreshing = true;
            this.timeScrollBar.setLongMaximum(this.timeScrollMax);
        }
        finally {
            this.refreshing = false;
        }
    }

    public long getTimePosition() {
        return this.timePosition;
    }

    public boolean isUpdateTimerRunning() {
        return this.waxLabPanel.isRefreshTimerRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimePosition(long timePosition) {
        long tsp;
        this.timePosition = timePosition;
        PositionBarView posView = this.positionBarView;
        if (posView != null) {
            int pos = (int)LineUtil.getUnitOfs((long)timePosition, (double)this.zoomRate);
            Rectangle rect = this.positionBarBounds;
            if (this.horiz) {
                int halfWidth = this.multiLineContent.getWidth() / 2;
                rect.x = (pos < halfWidth ? pos : halfWidth) - this.positionBarHalf;
            } else {
                int halfHeight = this.multiLineContent.getHeight() / 2;
                rect.y = (pos < halfHeight ? pos : halfHeight) - this.positionBarHalf;
            }
            posView.setBounds(rect);
        }
        if ((tsp = timePosition - this.visibleHalf) < 0L) {
            tsp = 0L;
        }
        this.timeScrollPos = tsp;
        this.scroll();
        AbstractLineWrapper[] wrappers = this.recWrappers;
        int n = wrappers.length;
        for (int i = 0; i < n; ++i) {
            wrappers[i].validateRecView();
        }
        this.multiLineContent.repaint();
        this.multiLineRuler.repaint();
        if (this.timeScrollPos != this.timeScrollBar.getLongValue()) {
            try {
                this.refreshing = true;
                this.timeScrollBar.setLongValue(this.timeScrollPos);
            }
            finally {
                this.refreshing = false;
            }
        }
    }

    protected void scroll() {
        long scrollPos = this.timeScrollPos;
        long timePos = this.timePosition;
        long pix = LineUtil.getUnitOfs((long)scrollPos, (double)this.zoomRate);
        this.multiLineRuler.scroll(timePos, scrollPos, pix);
        ScrollView sv = this.lineSeparatorScrollView;
        if (sv != null) {
            ScrollPos pnt = sv.getPosition();
            if (this.horiz) {
                pnt.x = pix;
            } else {
                pnt.y = pix;
            }
            sv.setPosition(pnt);
        }
        AbstractLineWrapper[] wrappers = this.lineWrappers;
        int num = wrappers.length;
        for (int i = 0; i < num; ++i) {
            wrappers[i].scroll(timePos, scrollPos, pix);
        }
    }

    public double getZoomRate() {
        return this.zoomRate;
    }

    public void setZoomRate(double zoomRate) {
        long cursorPos;
        if (zoomRate > this.maxZoomRate) {
            zoomRate = this.maxZoomRate;
        }
        if (zoomRate < this.minZoomRate) {
            zoomRate = this.minZoomRate;
        }
        long oldCenterPos = this.timeScrollPos + this.visibleHalf;
        this.zoomRate = zoomRate;
        this.pixNanos = 1.0E9 / zoomRate;
        this.doLayout();
        long newScrollPos = oldCenterPos - this.visibleHalf;
        long selAnchor = this.selectionAnchorPos;
        long selLead = this.selectionLeadPos;
        if (selAnchor >= 0L && selLead >= 0L) {
            long centerPos = -1L;
            long minPos = newScrollPos;
            long maxPos = (long)((double)(newScrollPos + this.visibleTime) - this.pixNanos);
            long selPos = (selAnchor + selLead) / 2L;
            selPos = (long)(this.pixNanos * (double)((long)((double)selPos / this.pixNanos)));
            if (selAnchor < minPos) {
                centerPos = selPos;
            } else if (selAnchor > maxPos) {
                centerPos = selPos;
            }
            if (selLead < minPos) {
                centerPos = selPos;
            } else if (selLead > maxPos) {
                centerPos = selPos;
            }
            if (centerPos >= 0L) {
                newScrollPos = centerPos - this.visibleHalf;
            }
        }
        if ((cursorPos = this.cursorPosition) >= 0L) {
            long centerPos = -1L;
            long minPos = newScrollPos;
            long maxPos = (long)((double)(newScrollPos + this.visibleTime) - this.pixNanos);
            if (cursorPos < minPos) {
                centerPos = cursorPos;
            } else if (cursorPos > maxPos) {
                centerPos = cursorPos;
            }
            if (centerPos >= 0L) {
                newScrollPos = centerPos - this.visibleHalf;
            }
        }
        if (newScrollPos < 0L) {
            newScrollPos = 0L;
        }
        this.timeScrollPos = newScrollPos;
        AbstractLineWrapper[] wrappers = this.lineWrappers;
        int num = wrappers.length;
        for (int i = 0; i < num; ++i) {
            this.refreshLineWrapper(wrappers[i]);
        }
        this.scroll();
        this.repaint();
    }

    public int getScaleSliderSize() {
        return this.scaleSliderSize;
    }

    public void setScaleSliderSize(int scaleSliderSize) {
        this.scaleSliderSize = scaleSliderSize;
        this.refresh();
    }

    protected void refreshLineWrapper(AbstractLineWrapper wrapper) {
        wrapper.setZoomRate(this.zoomRate);
    }

    protected void adjustTimeLength() {
        long max = 0L;
        for (AbstractLineWrapper wrapper : this.lineWrappers) {
            long t = wrapper.computeTimeLength();
            if (t <= max) continue;
            max = t;
        }
        if (max != this.timeLength) {
            this.setTimeLength(max);
        }
    }

    protected void adjustTimeLength(LineChunk chunk) {
        long t = chunk.computeLineEnd();
        if (t > this.timeLength) {
            this.setTimeLength(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshLineScrollBar() {
        int viewLen = this.horiz ? this.contentViewport.getHeight() : this.contentViewport.getWidth();
        int maximum = 0;
        if (this.viewLayout != null) {
            Dimension pref = this.viewLayout.preferredLayoutSize();
            maximum = this.horiz ? pref.height : pref.width;
        }
        int value = this.lineScrollBar.getValue();
        try {
            this.refreshing = true;
            this.lineScrollBar.setMinimum(0);
            this.lineScrollBar.setMaximum(maximum);
            this.lineScrollBar.setVisibleAmount(viewLen);
            this.lineScrollBar.setUnitIncrement(this.lineScrollUnitIncrement);
            this.lineScrollBar.setBlockIncrement(viewLen);
            if (value + viewLen > maximum) {
                value = maximum - viewLen;
                if (value < 0) {
                    value = 0;
                }
                this.lineScrollBar.setValue(value);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshTimeScrollBar() {
        try {
            this.refreshing = true;
            this.timeScrollBar.setLongExtent(this.timeScrollExtent);
            this.timeScrollBar.setLongMaximum(this.timeScrollMax);
            this.timeScrollBar.setLongValue(this.timeScrollPos);
            this.timeScrollBar.setLongUnit(this.timeScrollUnit);
            this.timeScrollBar.setLongBlock(this.timeScrollBlock);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void handleScroll() {
        this.timeScrollPos = this.timeScrollBar.getLongValue();
        this.scroll();
        this.multiLineContent.repaint();
        this.multiLineRuler.repaint();
    }

    protected void handleScale() {
        double zoom;
        int val = this.timeScaleSlider.getValue();
        int min = this.timeScaleSlider.getMinimum();
        int max = this.timeScaleSlider.getMaximum();
        double norm = 0.0;
        if (max > min) {
            norm = (double)(val - min) / (double)(max - min);
        }
        if ((zoom = (zoom = this.normToZoomRate(norm)) > 100.0 ? (double)((long)zoom) : (double)((long)(zoom * 10.0)) / 10.0) == this.zoomRate) {
            return;
        }
        this.setZoomRate(zoom);
    }

    protected double normToZoomRate(double norm) {
        double exp = 1.0E9;
        double exp1 = 1.0 / exp;
        double min = Math.pow(this.minZoomRate, exp1);
        double max = Math.pow(this.maxZoomRate, exp1);
        double zoom = Math.pow(min + norm * (max - min), exp);
        return zoom;
    }

    protected void zoomIn() {
        int max;
        int val = this.timeScaleSlider.getValue();
        if (val < (max = this.timeScaleSlider.getMaximum())) {
            this.timeScaleSlider.setValue(++val);
        }
    }

    protected void zoomOut() {
        int min;
        int val = this.timeScaleSlider.getValue();
        if (val > (min = this.timeScaleSlider.getMinimum())) {
            this.timeScaleSlider.setValue(--val);
        }
    }

    protected void handleCornerAction(ActionEvent ev) {
        if (this.cornerMenu != null) {
            int y;
            int x;
            Dimension dim = this.cornerMenu.getPreferredSize();
            if (this.horiz) {
                x = this.cornerSouthEast.getWidth() - dim.width;
                y = -dim.height;
            } else {
                x = -dim.width;
                y = this.cornerSouthEast.getHeight() - dim.height;
            }
            this.cornerMenu.show(this.cornerSouthEast, x, y);
        }
    }

    public JPopupMenu getTitlePopupMenu() {
        return this.titlePopupMenu;
    }

    public void setTitlePopupMenu(JPopupMenu popupMenu) {
        this.titlePopupMenu = popupMenu;
    }

    public int[] getSelectedLineIndices() {
        return this.selectedLineIndices;
    }

    public void setSelectedLineIndices(int[] selectedLineIndices) {
        if (selectedLineIndices == null) {
            selectedLineIndices = NOTHING_SELECTED;
        }
        int[] old = this.selectedLineIndices;
        this.selectedLineIndices = selectedLineIndices;
        this.multiLineHeader.setSelectedLineIndices(selectedLineIndices);
        if (!this.isLineSelected(this.focusLineIndex)) {
            int newFocusIndex = -1;
            if (selectedLineIndices.length > 0) {
                newFocusIndex = selectedLineIndices[0];
            }
            this.setFocusLineIndex(newFocusIndex);
        }
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTED_LINE_INDICES, old, selectedLineIndices);
    }

    public boolean isLineSelected(int lineIndex) {
        if (lineIndex < 0) {
            return false;
        }
        int[] sel = this.selectedLineIndices;
        int n = sel.length;
        for (int i = 0; i < n; ++i) {
            if (sel[i] != lineIndex) continue;
            return true;
        }
        return false;
    }

    public void selectLine(int lineIndex) {
        if (lineIndex < 0) {
            return;
        }
        int[] old = this.selectedLineIndices;
        int oldLen = old.length;
        int pos = -1;
        for (int i = 0; i < oldLen; ++i) {
            int idx = old[i];
            if (idx == lineIndex) {
                return;
            }
            if (pos >= 0 || idx <= lineIndex) continue;
            pos = i;
        }
        if (pos < 0) {
            pos = oldLen;
        }
        int[] arr = new int[oldLen + 1];
        if (pos > 0) {
            System.arraycopy(old, 0, arr, 0, pos);
        }
        arr[pos] = lineIndex;
        if (pos < oldLen) {
            System.arraycopy(old, pos, arr, pos + 1, oldLen - pos);
        }
        this.setSelectedLineIndices(arr);
    }

    public void deselectLine(int lineIndex) {
        if (lineIndex < 0) {
            return;
        }
        int[] old = this.selectedLineIndices;
        int oldLen = old.length;
        if (oldLen < 1) {
            return;
        }
        int pos = -1;
        for (int i = 0; i < oldLen; ++i) {
            if (old[i] != lineIndex) continue;
            pos = i;
            break;
        }
        if (pos < 0) {
            return;
        }
        int[] arr = new int[oldLen - 1];
        if (pos > 0) {
            System.arraycopy(old, 0, arr, 0, pos);
        }
        if (pos + 1 < oldLen) {
            System.arraycopy(old, pos + 1, arr, pos, oldLen - pos - 1);
        }
        this.setSelectedLineIndices(arr);
    }

    public int getMaximizedLineIndex() {
        return this.maximizedLineIndex;
    }

    public void setMaximizedLineIndex(int maximizedLineIndex) {
        AbstractLineWrapper wrapper;
        int oldIndex = this.maximizedLineIndex;
        if (maximizedLineIndex == oldIndex) {
            return;
        }
        int lineCount = this.getLineCount();
        if (oldIndex >= 0 && oldIndex < lineCount) {
            wrapper = this.getLineWrapperAt(oldIndex);
            wrapper.setTrackSize(wrapper.getNormalTrackSize());
        }
        this.maximizedLineIndex = maximizedLineIndex;
        if (maximizedLineIndex >= 0 && maximizedLineIndex < lineCount) {
            wrapper = this.getLineWrapperAt(maximizedLineIndex);
            wrapper.setNormalTrackSize(wrapper.getTrackSize());
        }
        this.firePropertyChange(PROPERTY_MAXIMIZED_LINE_INDEX, oldIndex, maximizedLineIndex);
    }

    public void scrollLineToVisible(int lineIndex) {
        int max;
        int min;
        AbstractLineWrapper wrapper = this.lineWrapperAtIndex(lineIndex);
        if (wrapper == null) {
            return;
        }
        ScrollView scrollView = wrapper.getScrollView();
        if (scrollView == null) {
            return;
        }
        Rectangle bounds = scrollView.getBounds();
        if (bounds == null) {
            return;
        }
        if (this.horiz) {
            min = bounds.y;
            max = min + bounds.height;
        } else {
            min = bounds.x;
            max = min + bounds.width;
        }
        int val = this.lineScrollBar.getValue();
        int vis = this.lineScrollBar.getVisibleAmount();
        if (val <= min && val + vis >= max) {
            return;
        }
        val = (min + max - vis) / 2;
        if (val < 0) {
            val = 0;
        }
        this.lineScrollBar.setValue(val);
    }

    public int getFocusLineIndex() {
        return this.focusLineIndex;
    }

    public void setFocusLineIndex(int focusLineIndex) {
        int old = this.focusLineIndex;
        if (focusLineIndex == old) {
            return;
        }
        if (this.maximizedLineIndex >= 0 && focusLineIndex != this.maximizedLineIndex) {
            this.setMaximizedLineIndex(-1);
        }
        this.focusLineIndex = focusLineIndex;
        this.multiLineHeader.setFocusLineIndex(focusLineIndex);
        if (focusLineIndex >= 0 && !this.isLineSelected(focusLineIndex)) {
            this.setSelectedLineIndices(new int[]{focusLineIndex});
            this.scrollLineToVisible(focusLineIndex);
        }
        this.repaint();
        this.firePropertyChange(PROPERTY_FOCUS_LINE_INDEX, old, focusLineIndex);
    }

    public AbstractLineWrapper getFocusLineWrapper() {
        int sel = this.getFocusLineIndex();
        if (sel < 0) {
            return null;
        }
        AbstractLineWrapper[] alw = this.lineWrappers;
        if (sel >= alw.length) {
            return null;
        }
        return alw[sel];
    }

    public int getLineCount() {
        return this.lineWrappers.length;
    }

    public AbstractLineWrapper getLineWrapperAt(int index) {
        if (index < 0) {
            return null;
        }
        AbstractLineWrapper[] alw = this.lineWrappers;
        if (index >= alw.length) {
            return null;
        }
        return alw[index];
    }

    public AbstractLineWrapper[] getLineWrappers() {
        return this.lineWrappers;
    }

    protected void setLineWrappers(AbstractLineWrapper[] newLineWrappers) {
        this.lineWrappers = newLineWrappers;
        MultiLineHeader mlh = this.multiLineHeader;
        if (mlh != null) {
            mlh.setLineWrappers(newLineWrappers);
        }
    }

    protected void registerRecordingWrapper(AbstractLineWrapper recWrapper) {
        AbstractLineWrapper[] oldRecs = this.recWrappers;
        int oldCount = oldRecs.length;
        AbstractLineWrapper[] newRecs = new AbstractLineWrapper[oldCount + 1];
        System.arraycopy(oldRecs, 0, newRecs, 0, oldCount);
        newRecs[oldCount] = recWrapper;
        this.recWrappers = newRecs;
    }

    protected void unregisterRecordingWrapper(AbstractLineWrapper recWrapper) {
        AbstractLineWrapper[] oldRecs = this.recWrappers;
        int count = oldRecs.length;
        int index = -1;
        for (int i = 0; i < count; ++i) {
            if (oldRecs[i] != recWrapper) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        AbstractLineWrapper[] newRecs = new AbstractLineWrapper[--count];
        System.arraycopy(oldRecs, 0, newRecs, 0, index);
        System.arraycopy(oldRecs, index + 1, newRecs, index, count - index);
        this.recWrappers = newRecs;
    }

    protected AbstractLineWrapper lineWrapperAtIndex(int index) {
        AbstractLineWrapper[] wrappers = this.lineWrappers;
        if (wrappers != null && index >= 0 && index < wrappers.length) {
            return wrappers[index];
        }
        return null;
    }

    protected AbstractLineWrapper lineWrapperAtPoint(int x, int y) {
        int i = this.lineIndexAtPoint(x, y);
        if (i < 0) {
            return null;
        }
        return this.lineWrappers[i];
    }

    protected int lineIndexAtPoint(int x, int y) {
        AbstractLineWrapper[] wrappers = this.lineWrappers;
        int n = wrappers.length;
        for (int i = 0; i < n; ++i) {
            ScrollView scrollView;
            AbstractLineWrapper wrapper = wrappers[i];
            if (wrapper.gridIndex < 0 || (scrollView = wrapper.getScrollView()) == null || !scrollView.getBounds().contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    protected int lineSeparatorAtPoint(int x, int y) {
        View[] seps = this.lineSeparators;
        if (seps != null) {
            int num = seps.length;
            for (int i = 0; i < num; ++i) {
                if (!seps[i].getBounds().contains(x, y)) continue;
                return i;
            }
        }
        return -1;
    }

    public long getVisibleTime() {
        return this.visibleTime;
    }

    public long getVisibleHalf() {
        return this.visibleHalf;
    }

    @Override
    public void doLayout() {
        long len;
        ViewLayout layout;
        AbstractLineWrapper wrapper;
        int lineCount;
        super.doLayout();
        int w = this.contentViewport.getWidth();
        int h = this.contentViewport.getHeight();
        int maximizedLineIndex = this.maximizedLineIndex;
        if (maximizedLineIndex >= 0 && maximizedLineIndex < (lineCount = this.getLineCount()) && (wrapper = this.getLineWrapperAt(maximizedLineIndex)) != null) {
            int newTrackSize;
            int n = newTrackSize = this.horiz ? h : w;
            if (newTrackSize != wrapper.trackSize) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("doLayout: w=" + w + ", h=" + h + ", maximizedLineIndex=" + maximizedLineIndex + ", newTrackSize=" + newTrackSize);
                }
                this.resizeLineTrackSize(wrapper, newTrackSize);
            }
        }
        if ((layout = this.viewLayout) != null) {
            Dimension size = layout.preferredLayoutSize();
            if (this.horiz) {
                size.width = w;
            } else {
                size.height = h;
            }
            layout.layoutViews(size);
        }
        long l = len = this.horiz ? (long)w : (long)h;
        if (len < 1L) {
            len = 1L;
        }
        this.visibleTime = LineUtil.getNanoOfs((long)len, (double)this.zoomRate);
        this.visibleHalf = LineUtil.getNanoOfs((long)(len / 2L), (double)this.zoomRate);
        this.timeScrollExtent = this.visibleTime;
        long unitIncrement = LineUtil.getNanoOfs((long)this.timeScrollUnitIncrement, (double)this.zoomRate);
        if (unitIncrement < 1L) {
            unitIncrement = 1L;
        }
        this.timeScrollUnit = unitIncrement;
        long blockIncrement = this.visibleHalf;
        if (blockIncrement < 1L) {
            blockIncrement = 1L;
        }
        this.timeScrollBlock = blockIncrement;
        if (this.horiz) {
            this.positionBarBounds.y = 0;
            this.positionBarBounds.width = this.positionBarSize;
            this.positionBarBounds.height = this.multiLineContent.getHeight();
        } else {
            this.positionBarBounds.x = 0;
            this.positionBarBounds.width = this.multiLineContent.getWidth();
            this.positionBarBounds.height = this.positionBarSize;
        }
        this.refreshTimeScrollBar();
        this.refreshLineScrollBar();
        this.refreshRuler();
    }

    public void invalidateTiles() {
        AbstractLineWrapper[] wrappers = this.lineWrappers;
        int n = wrappers.length;
        for (int i = 0; i < n; ++i) {
            TileView tileView = wrappers[i].getTileView();
            if (tileView == null) continue;
            tileView.invalidate();
        }
    }

    public PositionBarView getPositionBarView() {
        return this.positionBarView;
    }

    public void setPositionBarView(PositionBarView positionBarView) {
        this.positionBarView = positionBarView;
    }

    public int getPositionBarSize() {
        return this.positionBarSize;
    }

    public void setPositionBarSize(int positionBarSize) {
        this.positionBarSize = positionBarSize;
        this.positionBarHalf = positionBarSize / 2;
    }

    public int getLineSeparatorSize() {
        return this.lineSeparatorSize;
    }

    public void setLineSeparatorSize(int lineSeparatorSize) {
        this.lineSeparatorSize = lineSeparatorSize;
    }

    public DropTargetListener getLineDropTargetListener() {
        return this.lineDropTargetListener;
    }

    public void setLineDropTargetListener(DropTargetListener lineDropTargetListener) {
        this.lineDropTargetListener = lineDropTargetListener;
        DropTarget lineDropTarget = null;
        if (lineDropTargetListener != null) {
            lineDropTarget = new DropTarget(this.multiLineContent, lineDropTargetListener);
        }
        this.multiLineContent.setDropTarget(lineDropTarget);
    }

    public ViewLayout getViewLayout() {
        return this.viewLayout;
    }

    public void setViewLayout(ViewLayout viewLayout) {
        this.viewLayout = viewLayout;
    }

    public JPopupMenu getCornerMenu() {
        return this.cornerMenu;
    }

    public void setCornerMenu(JPopupMenu cornerMenu) {
        this.cornerMenu = cornerMenu;
    }

    public long timePositionForPoint(int x, int y) {
        if (this.horiz) {
            return this.timeScrollPos + (long)((double)x * this.pixNanos);
        }
        return this.timeScrollPos + (long)((double)y * this.pixNanos);
    }

    public long getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(long cursorPosition) {
        this.cursorPosition = cursorPosition;
        this.multiLineContent.repaint();
        this.multiLineRuler.repaint();
    }

    public long getSelectionAnchorPos() {
        return this.selectionAnchorPos;
    }

    public void setSelectionAnchorPos(long selectionAnchorPos) {
        if (this.selectionAnchorPos == selectionAnchorPos) {
            return;
        }
        this.selectionAnchorPos = selectionAnchorPos;
        this.multiLineContent.repaint();
        this.multiLineRuler.repaint();
        this.fireSelectionAreaChanged();
    }

    public long getSelectionLeadPos() {
        return this.selectionLeadPos;
    }

    public void setSelectionLeadPos(long selectionLeadPos) {
        if (this.selectionLeadPos == selectionLeadPos) {
            return;
        }
        this.selectionLeadPos = selectionLeadPos;
        this.multiLineContent.repaint();
        this.multiLineRuler.repaint();
        this.fireSelectionAreaChanged();
    }

    protected void fireSelectionAreaChanged() {
        this.waxLabPanel.lineSelectionAreaChanged(this);
    }

    protected void handleMousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.multiLineContent.requestFocus();
        if (this.dragMode == 0) {
            this.anchorX = x;
            this.anchorY = y;
        }
        this.handleMousePosition(e);
        int lineIndex = this.lineIndexAtPoint(x, y);
        if (lineIndex >= 0 && lineIndex != this.focusLineIndex) {
            this.setFocusLineIndex(lineIndex);
            this.scrollLineToVisible(lineIndex);
        }
        if (lineIndex >= 0) {
            AbstractLineWrapper wrapper = this.lineWrapperAtIndex(lineIndex);
            if (wrapper != null) {
                MouseListener listener = wrapper.mouseListener;
                if (listener != null) {
                    listener.mousePressed(e);
                    if (e.isConsumed()) {
                        return;
                    }
                }
                if (e.isPopupTrigger()) {
                    e.consume();
                    this.showLinePopupMenu(wrapper, x, y);
                    return;
                }
            }
        } else {
            this.handleSeparatorMousePressed(e);
            return;
        }
        this.handleRulerMousePressed(e);
    }

    protected void handleMouseReleased(MouseEvent e) {
        MouseListener listener;
        MouseListener listener2;
        int x = e.getX();
        int y = e.getY();
        if (this.dragMode == 2) {
            this.handleSeparatorMouseReleased(e);
            this.handleRulerMouseReleased(e);
        }
        this.dragMode = 0;
        if (this.cursorMoveTimer.isRunning()) {
            this.stopCursorMoveTimer();
        }
        AbstractLineWrapper anchor = null;
        if ((this.anchorX >= 0 || this.anchorY >= 0) && (anchor = this.lineWrapperAtPoint(this.anchorX, this.anchorY)) != null && (listener2 = anchor.mouseListener) != null) {
            listener2.mouseReleased(e);
        }
        this.anchorX = -1;
        this.anchorY = -1;
        this.handleMousePosition(e);
        AbstractLineWrapper wrapper = this.lineWrapperAtPoint(x, y);
        if (wrapper != null && wrapper != anchor && (listener = wrapper.mouseListener) != null) {
            listener.mouseReleased(e);
        }
        if (e.isConsumed()) {
            return;
        }
        if (e.isPopupTrigger() && wrapper != null) {
            e.consume();
            this.showLinePopupMenu(wrapper, x, y);
            return;
        }
    }

    protected void handleMouseClicked(MouseEvent e) {
        AbstractLineWrapper wrapper;
        int y;
        int x = e.getX();
        int lineIndex = this.lineIndexAtPoint(x, y = e.getY());
        if (lineIndex >= 0 && lineIndex != this.focusLineIndex) {
            this.setFocusLineIndex(lineIndex);
            this.scrollLineToVisible(lineIndex);
        }
        if (lineIndex >= 0 && (wrapper = this.lineWrapperAtIndex(lineIndex)) != null) {
            MouseListener listener = wrapper.mouseListener;
            if (listener != null) {
                listener.mouseClicked(e);
                if (e.isConsumed()) {
                    return;
                }
            }
            if (e.isPopupTrigger()) {
                e.consume();
                this.showLinePopupMenu(wrapper, x, y);
                return;
            }
        }
    }

    protected void handleMouseEntered(MouseEvent e) {
        this.handleMouseMoved(e);
    }

    protected void handleMouseExited(MouseEvent e) {
        this.handleMouseMoved(e);
    }

    protected void handleMouseMoved(MouseEvent e) {
        MouseMotionListener listener;
        AbstractLineWrapper wrapper;
        this.handleMousePosition(e);
        int x = e.getX();
        int y = e.getY();
        int lineIndex = this.lineIndexAtPoint(x, y);
        if (lineIndex >= 0 && (wrapper = this.lineWrapperAtIndex(lineIndex)) != null && (listener = wrapper.mouseMotionListener) != null) {
            listener.mouseMoved(e);
        }
    }

    protected void handleMousePosition(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int lineIndex = this.lineIndexAtPoint(x, y);
        long timePos = this.timePositionForPoint(x, y);
        if (lineIndex != this.enteredLineIndex) {
            MouseListener listener;
            AbstractLineWrapper wrapper;
            if (this.enteredLineIndex >= 0 && (wrapper = this.lineWrapperAtIndex(this.enteredLineIndex)) != null && (listener = wrapper.mouseListener) != null) {
                listener.mouseExited(e);
            }
            this.enteredLineIndex = lineIndex;
            if (lineIndex >= 0 && (wrapper = this.lineWrapperAtIndex(lineIndex)) != null && (listener = wrapper.mouseListener) != null) {
                listener.mouseEntered(e);
            }
        }
        int sepIndex = -1;
        if (lineIndex < 0) {
            sepIndex = this.lineSeparatorAtPoint(x, y);
        }
        if (sepIndex != this.enteredSeparatorIndex) {
            if (this.enteredSeparatorIndex >= 0) {
                this.enteredSeparatorIndex = -1;
                this.handleSeparatorMouseExited(e);
            }
            this.enteredSeparatorIndex = sepIndex;
            if (sepIndex >= 0) {
                this.handleSeparatorMouseEntered(e);
            }
        }
        long selAnchor = this.selectionAnchorPos;
        long selLead = this.selectionLeadPos;
        boolean enteredAnchor = false;
        boolean enteredLead = false;
        if (selAnchor >= 0L && selLead >= 0L) {
            double deltaMax = LineUtil.getNanoPos((long)this.extendSelectionWidth, (double)this.zoomRate);
            long deltaPos = Math.abs(timePos - selLead);
            if ((double)deltaPos <= deltaMax) {
                enteredLead = true;
            } else {
                deltaPos = Math.abs(timePos - selAnchor);
                if ((double)deltaPos <= deltaMax) {
                    enteredAnchor = true;
                }
            }
        }
        if (enteredAnchor != this.enteredAnchorPosition) {
            this.enteredAnchorPosition = enteredAnchor;
            if (enteredAnchor) {
                this.handleAnchorPositionEntered(e);
            } else {
                this.handleAnchorPositionExited(e);
            }
        }
        if (enteredLead != this.enteredLeadPosition) {
            this.enteredLeadPosition = enteredLead;
            if (enteredLead) {
                this.handleLeadPositionEntered(e);
            } else {
                this.handleLeadPositionExited(e);
            }
        }
    }

    protected void handleMouseDragged(MouseEvent e) {
        AbstractLineWrapper anchor = null;
        if (this.anchorX >= 0 || this.anchorY >= 0) {
            anchor = this.lineWrapperAtPoint(this.anchorX, this.anchorY);
            if (anchor != null && this.dragMode != 2) {
                MouseMotionListener listener = anchor.mouseMotionListener;
                if (listener != null) {
                    listener.mouseDragged(e);
                    if (e.isConsumed()) {
                        return;
                    }
                }
            } else {
                this.handleSeparatorMouseDragged(e);
                return;
            }
        }
        this.handleRulerMouseDragged(e);
    }

    protected void handleMouseWheelMoved(MouseWheelEvent e) {
        MouseWheelListener listener;
        int y;
        int x = e.getX();
        AbstractLineWrapper wrapper = this.lineWrapperAtPoint(x, y = e.getY());
        if (wrapper != null && (listener = wrapper.mouseWheelListener) != null) {
            listener.mouseWheelMoved(e);
            if (e.isConsumed()) {
                return;
            }
        }
        this.handleRulerMouseWheelMoved(e);
    }

    protected void adjustMouseCursor() {
        Cursor cursor = this.defaultCursor;
        if (this.enteredSeparatorIndex >= 0 && (this.dragMode == 0 || this.dragMode == 2)) {
            cursor = this.horiz ? this.resizeCursorVertical : this.resizeCursorHorizontal;
        } else if (this.enteredLeadPosition || this.enteredAnchorPosition || this.dragMode == 2) {
            cursor = this.horiz ? this.resizeCursorHorizontal : this.resizeCursorVertical;
        }
        this.setCursor(cursor);
    }

    protected void handleLeadPositionEntered(MouseEvent e) {
        this.adjustMouseCursor();
    }

    protected void handleLeadPositionExited(MouseEvent e) {
        this.adjustMouseCursor();
    }

    protected void handleAnchorPositionEntered(MouseEvent e) {
        this.adjustMouseCursor();
    }

    protected void handleAnchorPositionExited(MouseEvent e) {
        this.adjustMouseCursor();
    }

    protected void handleSeparatorMouseEntered(MouseEvent e) {
        if (this.dragMode == 2) {
            return;
        }
        this.adjustMouseCursor();
    }

    protected void handleSeparatorMouseExited(MouseEvent e) {
        if (this.dragMode == 2) {
            return;
        }
        this.adjustMouseCursor();
    }

    protected void handleSeparatorMousePressed(MouseEvent e) {
    }

    protected void handleSeparatorMouseReleased(MouseEvent e) {
        if (this.dragMode == 2) {
            this.dragMode = 0;
            this.resizeLineIndex = -1;
            this.enteredSeparatorIndex = -1;
            this.adjustMouseCursor();
            return;
        }
        this.handleRulerMouseReleased(e);
    }

    protected void handleSeparatorMouseDragged(MouseEvent e) {
        if (this.dragMode == 2 || this.dragMode == 0) {
            AbstractLineWrapper wrapper;
            int sepIndex = this.resizeLineIndex;
            if (sepIndex < 0) {
                sepIndex = this.lineSeparatorAtPoint(this.anchorX, this.anchorY);
            }
            if ((wrapper = this.lineWrapperAtIndex(sepIndex)) != null) {
                int snapLineGridSize;
                int newTrackSize;
                if (this.dragMode == 0) {
                    this.dragMode = 2;
                    this.resizeLineIndex = sepIndex;
                }
                int oldTrackSize = wrapper.getTrackSize();
                if (this.horiz) {
                    int newY = e.getY();
                    int relY = newY - this.anchorY;
                    if (relY == 0) {
                        return;
                    }
                    newTrackSize = oldTrackSize + relY;
                } else {
                    int newX = e.getX();
                    int relX = newX - this.anchorX;
                    if (relX == 0) {
                        return;
                    }
                    newTrackSize = oldTrackSize + relX;
                }
                if (newTrackSize < 0) {
                    newTrackSize = 0;
                }
                if (this.snapLineGridEnabled && (snapLineGridSize = this.snapLineGridSize) > 1) {
                    newTrackSize = newTrackSize / snapLineGridSize * snapLineGridSize;
                }
                if (newTrackSize == oldTrackSize) {
                    return;
                }
                if (this.horiz) {
                    this.anchorY += newTrackSize - oldTrackSize;
                } else {
                    this.anchorX += newTrackSize - oldTrackSize;
                }
                wrapper.setNormalTrackSize(newTrackSize);
                Line line = wrapper.line;
                if (line != null) {
                    line.setTrackSize(newTrackSize);
                }
                this.resizeLineTrackSize(wrapper, newTrackSize);
                return;
            }
        }
        this.handleRulerMouseDragged(e);
    }

    protected void resizeLineTrackSize(AbstractLineWrapper wrapper, int newTrackSize) {
        wrapper.setTrackSize(newTrackSize);
        wrapper.refresh();
        wrapper.layout();
        this.refresh();
    }

    protected void handleRulerMousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.multiLineRuler.requestFocus();
        if (this.dragMode == 0) {
            this.anchorX = x;
            this.anchorY = y;
        }
        if (e.isPopupTrigger()) {
            if (this.rulerPopupMenu != null) {
                this.rulerPopupMenu.show(this.multiLineRuler, x, y);
            }
            e.consume();
            return;
        }
        this.handleMousePosition(e);
        long pos = this.timePositionForPoint(x, y);
        if (e.isShiftDown() && this.dragMode == 0) {
            this.dragMode = 1;
            this.extendSelectionLeadPos(pos);
            this.moveCursorPosition(pos, false);
            e.consume();
            return;
        }
        int clicks = e.getClickCount();
        if (clicks == 2 && pos == this.cursorPosition) {
            this.deselectAll();
            e.consume();
            return;
        }
        int button = e.getButton();
        if (button == 1) {
            this.moveCursorPosition(pos, false);
            e.consume();
            return;
        }
    }

    public boolean moveCursorHome(boolean extendSelection, boolean jumpSelection) {
        long newPos = jumpSelection ? this.computeJumpBackwardPos(this.cursorPosition) : 0L;
        if (newPos != this.cursorPosition) {
            if (extendSelection) {
                this.extendSelectionLeadPos(newPos);
            }
            this.moveCursorPosition(newPos, true);
            return true;
        }
        return false;
    }

    public boolean moveCursorEnd(boolean extendSelection, boolean jumpSelection) {
        long newPos = jumpSelection ? this.computeJumpForwardPos(this.cursorPosition) : this.timeLength;
        if (newPos != this.cursorPosition) {
            if (extendSelection) {
                this.extendSelectionLeadPos(newPos);
            }
            this.moveCursorPosition(newPos, true);
            return true;
        }
        return false;
    }

    public boolean moveCursorPageBackward(boolean extendSelection) {
        long newPos = this.cursorPosition - this.visibleHalf;
        if (newPos < 0L) {
            newPos = 0L;
        }
        if (newPos != this.cursorPosition) {
            if (extendSelection) {
                this.extendSelectionLeadPos(newPos);
            }
            this.moveCursorPosition(newPos, true);
            return true;
        }
        return false;
    }

    public boolean moveCursorPageForward(boolean extendSelection) {
        long newPos = this.cursorPosition + this.visibleHalf;
        if (newPos > this.timeLength) {
            newPos = this.timeLength;
        }
        if (newPos != this.cursorPosition) {
            if (extendSelection) {
                this.extendSelectionLeadPos(newPos);
            }
            this.moveCursorPosition(newPos, true);
            return true;
        }
        return false;
    }

    public void moveCursorPosition(long newPosition, boolean center) {
        if (newPosition > this.timeLength) {
            newPosition = this.timeLength;
        }
        if (newPosition < 0L) {
            newPosition = 0L;
        }
        this.cursorPosition = newPosition;
        long scrollPos = this.timeScrollPos;
        if (center) {
            scrollPos = newPosition - this.visibleHalf;
        } else if (newPosition < scrollPos) {
            scrollPos = newPosition;
        } else if ((double)newPosition > (double)(scrollPos + this.visibleTime) - this.pixNanos) {
            scrollPos = (long)((double)(newPosition - this.visibleTime) + this.pixNanos);
        } else {
            this.multiLineContent.repaint();
            this.multiLineRuler.repaint();
            return;
        }
        this.scrollTo(scrollPos);
    }

    protected void scrollTo(long scrollPos) {
        if (scrollPos < 0L) {
            scrollPos = 0L;
        }
        this.timeScrollPos = scrollPos;
        this.refreshTimeScrollBar();
        this.scroll();
        this.multiLineContent.repaint();
        this.multiLineRuler.repaint();
    }

    public void extendSelectionLeadPos(long newPosition) {
        long anchorPos;
        if (newPosition > this.timeLength) {
            newPosition = this.timeLength;
        }
        if (newPosition < 0L) {
            newPosition = 0L;
        }
        if ((anchorPos = this.cursorPosition) >= 0L) {
            if (anchorPos == this.selectionLeadPos) {
                anchorPos = this.selectionAnchorPos;
            } else if (anchorPos == this.selectionAnchorPos) {
                anchorPos = this.selectionLeadPos;
            }
        }
        if (anchorPos < 0L) {
            anchorPos = 0L;
        }
        this.selectionAnchorPos = anchorPos;
        this.selectionLeadPos = newPosition;
        this.multiLineContent.repaint();
        this.multiLineRuler.repaint();
        this.fireSelectionAreaChanged();
    }

    public void moveSelectionLeadPos(long newPosition) {
        if (newPosition > this.timeLength) {
            newPosition = this.timeLength;
        }
        if (newPosition < 0L) {
            newPosition = 0L;
        }
        this.selectionLeadPos = newPosition;
        this.multiLineContent.repaint();
        this.multiLineRuler.repaint();
        this.fireSelectionAreaChanged();
    }

    public void scrollLinePageUp() {
        AbstractLineWrapper sel = this.getFocusLineWrapper();
        if (sel != null) {
            sel.scrollLinePageUp();
        }
    }

    public void scrollLinePageDown() {
        AbstractLineWrapper sel = this.getFocusLineWrapper();
        if (sel != null) {
            sel.scrollLinePageDown();
        }
    }

    protected void handleRulerMouseReleased(MouseEvent e) {
        MouseListener listener;
        int x = e.getX();
        int y = e.getY();
        this.dragMode = 0;
        if (this.cursorMoveTimer.isRunning()) {
            this.stopCursorMoveTimer();
        }
        AbstractLineWrapper anchor = null;
        if ((this.anchorX >= 0 || this.anchorY >= 0) && (anchor = this.lineWrapperAtPoint(this.anchorX, this.anchorY)) != null && (listener = anchor.mouseListener) != null) {
            listener.mouseReleased(e);
        }
        this.anchorX = -1;
        this.anchorY = -1;
        this.handleMousePosition(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.isPopupTrigger()) {
            if (this.rulerPopupMenu != null) {
                this.rulerPopupMenu.show(this.multiLineRuler, x, y);
            }
            e.consume();
            return;
        }
    }

    protected void handleRulerMouseClicked(MouseEvent e) {
        int clicks = e.getClickCount();
        if (clicks == 2) {
            this.deselectAll();
            return;
        }
    }

    public void deselectAll() {
        if ((double)this.selectionAnchorPos >= 0.0 || (double)this.selectionLeadPos >= 0.0) {
            this.setSelectionLeadPos(-1L);
            this.setSelectionAnchorPos(-1L);
        }
    }

    public void selectAll() {
        long timeLength = this.getTimeLength();
        this.setSelectionAnchorPos(0L);
        this.setSelectionLeadPos(timeLength);
    }

    public void selectAllLines() {
        int num = this.getLineCount();
        if (num < 1) {
            return;
        }
        int[] arr = new int[num];
        for (int i = 0; i < num; ++i) {
            arr[i] = i;
        }
        this.setSelectedLineIndices(arr);
    }

    protected void handleRulerMouseMoved(MouseEvent e) {
        this.handleMousePosition(e);
    }

    protected void handleRulerMouseDragged(MouseEvent e) {
        if (this.timeLength <= 0L) {
            this.handleMousePosition(e);
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int newLeadX = x;
        int newLeadY = y;
        int leadScroll = 0;
        if (this.horiz) {
            int width = this.multiLineRuler.getWidth();
            if (newLeadX >= width) {
                leadScroll = newLeadX + 1 - width;
                newLeadX = width - 1;
            }
            if (newLeadX < 0) {
                leadScroll = newLeadX;
                newLeadX = 0;
            }
        } else {
            int height = this.multiLineRuler.getHeight();
            if (newLeadY >= height) {
                leadScroll = newLeadY + 1 - height;
                newLeadY = height - 1;
            }
            if (newLeadY < 0) {
                leadScroll = newLeadY;
                newLeadY = 0;
            }
        }
        long newLead = this.timePositionForPoint(newLeadX, newLeadY);
        long oldAnchor = this.getSelectionAnchorPos();
        long oldLead = this.getSelectionLeadPos();
        if (newLead > this.timeLength) {
            newLead = this.timeLength;
        }
        if (newLead < 0L) {
            newLead = 0L;
        }
        if (this.dragMode == 1) {
            this.selectionLeadPos = newLead;
            this.moveCursorPosition(newLead, false);
            this.fireSelectionAreaChanged();
            e.consume();
            this.handleMousePosition(e);
            if (leadScroll == 0) {
                if (this.cursorMoveTimer.isRunning()) {
                    this.stopCursorMoveTimer();
                }
            } else {
                int increment = leadScroll;
                if (!this.cursorMoveTimer.isRunning()) {
                    int moveMode = 1;
                    boolean speedup = false;
                    this.startCursorMoveTimer(moveMode, increment, speedup);
                } else {
                    this.cursorMoveIncrement = increment;
                    this.cursorMoveFactor = 1;
                    this.cursorMoveCounter = 0;
                }
            }
            return;
        }
        if (this.dragMode != 0) {
            this.handleMousePosition(e);
            return;
        }
        if (!e.isShiftDown()) {
            long newAnchor;
            this.dragMode = 1;
            if (this.anchorX >= 0 || this.anchorY >= 0) {
                newAnchor = this.timePositionForPoint(this.anchorX, this.anchorY);
                if (newAnchor > this.timeLength) {
                    newAnchor = this.timeLength;
                }
                if (newAnchor < 0L) {
                    newAnchor = 0L;
                }
            } else {
                this.anchorX = x;
                this.anchorY = y;
                newAnchor = newLead;
            }
            if (oldAnchor >= 0L && oldLead >= 0L) {
                long deltaMax = LineUtil.getNanoOfs((long)this.extendSelectionWidth, (double)this.zoomRate);
                long deltaPos = Math.abs(newLead - oldLead);
                if (deltaPos <= deltaMax) {
                    newAnchor = oldAnchor;
                } else {
                    deltaPos = Math.abs(newAnchor - oldAnchor);
                    if (deltaPos <= deltaMax) {
                        newAnchor = oldLead;
                    }
                }
            }
            this.selectionAnchorPos = newAnchor;
            this.selectionLeadPos = newLead;
            this.cursorPosition = newLead;
            this.multiLineContent.repaint();
            this.multiLineRuler.repaint();
            this.fireSelectionAreaChanged();
            e.consume();
            this.handleMousePosition(e);
            return;
        }
        this.handleMousePosition(e);
    }

    protected void handleRulerMouseWheelMoved(MouseWheelEvent e) {
        switch (e.getScrollType()) {
            case 0: {
                long scroll = LineUtil.getNanoOfs((long)(e.getWheelRotation() * e.getScrollAmount() * this.scrollUnitSize), (double)this.zoomRate);
                long value = this.timeScrollBar.getLongValue() + scroll;
                this.timeScrollBar.setLongValue(value);
                e.consume();
                return;
            }
        }
    }

    protected void initActionMap() {
        ActionMap actionMap = this.getActionMap();
        if (actionMap == null) {
            return;
        }
        actionMap.put("MoveCursorPageBackwardAction", new MultiLineUtil.MoveCursorPageBackwardAction(this, false));
        actionMap.put("MoveCursorSelectPageBackwardAction", new MultiLineUtil.MoveCursorPageBackwardAction(this, true));
        actionMap.put("ScrollLinePageUpAction", new MultiLineUtil.ScrollLinePageUpAction(this));
        actionMap.put("MoveCursorPageForwardAction", new MultiLineUtil.MoveCursorPageForwardAction(this, false));
        actionMap.put("ShiftMoveCursorPageForwardAction", new MultiLineUtil.MoveCursorPageForwardAction(this, true));
        actionMap.put("ScrollLinePageDownAction", new MultiLineUtil.ScrollLinePageDownAction(this));
        actionMap.put("SelectAllAction", new MultiLineUtil.SelectAllAction(this));
        actionMap.put("DeselectAllAction", new MultiLineUtil.DeselectAllAction(this));
        actionMap.put("SelectAllLinesAction", new MultiLineUtil.SelectAllLinesAction(this));
        actionMap.put("SelectAllLineAreasAction", new MultiLineUtil.SelectAllLineAreasAction(this));
        actionMap.put("ZoomInAction", new MultiLineUtil.ZoomInAction(this));
        actionMap.put("ZoomOutAction", new MultiLineUtil.ZoomOutAction(this));
        actionMap.put("ToggleMaximizeRestoreLineAction", new MultiLineUtil.ToggleMaximizeRestoreLineAction(this));
        actionMap.put("RestoreMaximizedLineAction", new MultiLineUtil.RestoreMaximizedLineAction(this));
        actionMap.put("UndoAction", new MultiLineUtil.UndoAction(this));
        actionMap.put("RedoAction", new MultiLineUtil.RedoAction(this));
        actionMap.put("CopyAction", new MultiLineUtil.CopyAction(this));
        actionMap.put("CutAction", new MultiLineUtil.CutAction(this));
        actionMap.put("DeleteRemoveAction", new MultiLineUtil.DeleteAction(this, false));
        actionMap.put("DeleteClearAction", new MultiLineUtil.DeleteAction(this, true));
        actionMap.put("PasteInsertAction", new MultiLineUtil.PasteAction(this, false));
        actionMap.put("PasteReplaceAction", new MultiLineUtil.PasteAction(this, true));
        actionMap.put("InsertAction", new MultiLineUtil.InsertAction(this));
    }

    protected void initInputMap() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap == null) {
            return;
        }
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "MoveCursorPageBackwardAction");
        inputMap.put(KeyStroke.getKeyStroke(33, 64), "MoveCursorSelectPageBackwardAction");
        inputMap.put(KeyStroke.getKeyStroke(33, 512), "ScrollLinePageUpAction");
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "MoveCursorPageForwardAction");
        inputMap.put(KeyStroke.getKeyStroke(34, 64), "ShiftMoveCursorPageForwardAction");
        inputMap.put(KeyStroke.getKeyStroke(34, 512), "ScrollLinePageDownAction");
        inputMap.put(KeyStroke.getKeyStroke(65, 128), "SelectAllAction");
        inputMap.put(KeyStroke.getKeyStroke(65, 512), "SelectAllLinesAction");
        inputMap.put(KeyStroke.getKeyStroke(65, 640), "SelectAllLineAreasAction");
        inputMap.put(KeyStroke.getKeyStroke(32, 128), "DeselectAllAction");
        inputMap.put(KeyStroke.getKeyStroke(107, 0), "ZoomInAction");
        inputMap.put(KeyStroke.getKeyStroke(109, 0), "ZoomOutAction");
        inputMap.put(KeyStroke.getKeyStroke(70, 0), "ToggleMaximizeRestoreLineAction");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "RestoreMaximizedLineAction");
        inputMap.put(KeyStroke.getKeyStroke(90, 128), "UndoAction");
        inputMap.put(KeyStroke.getKeyStroke(89, 128), "RedoAction");
        inputMap.put(KeyStroke.getKeyStroke(67, 128), "CopyAction");
        inputMap.put(KeyStroke.getKeyStroke(155, 128), "CopyAction");
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "CutAction");
        inputMap.put(KeyStroke.getKeyStroke(127, 64), "CutAction");
        inputMap.put(KeyStroke.getKeyStroke(86, 128), "PasteInsertAction");
        inputMap.put(KeyStroke.getKeyStroke(86, 640), "PasteReplaceAction");
        inputMap.put(KeyStroke.getKeyStroke(155, 64), "PasteInsertAction");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "DeleteClearAction");
        inputMap.put(KeyStroke.getKeyStroke(127, 64), "DeleteRemoveAction");
        inputMap.put(KeyStroke.getKeyStroke(155, 0), "InsertAction");
    }

    protected void handleKeyTyped(KeyEvent e) {
        KeyListener listener;
        AbstractLineWrapper sel = this.getFocusLineWrapper();
        if (sel != null && (listener = sel.keyListener) != null) {
            listener.keyTyped(e);
        }
    }

    protected void handleKeyPressed(KeyEvent e) {
        KeyListener listener;
        switch (e.getKeyCode()) {
            case 37: 
            case 38: {
                boolean speedup;
                int moveMode;
                if (e.isControlDown()) break;
                int n = moveMode = e.isShiftDown() ? 1 : 0;
                if (e.isAltDown()) {
                    if ((!this.horiz || e.getKeyCode() != 37) && (this.horiz || e.getKeyCode() != 38)) break;
                    moveMode = 2;
                }
                if (this.horiz && e.getKeyCode() == 37 || !this.horiz && e.getKeyCode() == 38) {
                    e.consume();
                    if (this.cursorPosition <= 0L) break;
                    speedup = true;
                    this.startCursorMoveTimer(moveMode, -1, speedup);
                    break;
                }
                e.consume();
                if (!this.maximizedLineSwitchEnabled && this.maximizedLineIndex >= 0) break;
                this.switchFocusLine(-1, e.isShiftDown());
                break;
            }
            case 39: 
            case 40: {
                boolean speedup;
                int moveMode;
                if (e.isControlDown()) break;
                int n = moveMode = e.isShiftDown() ? 1 : 0;
                if (e.isAltDown()) {
                    if ((!this.horiz || e.getKeyCode() != 39) && (this.horiz || e.getKeyCode() != 40)) break;
                    moveMode = 2;
                }
                if (this.horiz && e.getKeyCode() == 39 || !this.horiz && e.getKeyCode() == 40) {
                    e.consume();
                    if (this.cursorPosition < 0L || this.cursorPosition >= this.timeLength) break;
                    speedup = true;
                    this.startCursorMoveTimer(moveMode, 1, speedup);
                    break;
                }
                e.consume();
                if (!this.maximizedLineSwitchEnabled && this.maximizedLineIndex >= 0) break;
                this.switchFocusLine(1, e.isShiftDown());
                break;
            }
            case 36: {
                e.consume();
                this.moveCursorHome(e.isShiftDown(), !e.isControlDown());
                break;
            }
            case 35: {
                e.consume();
                this.moveCursorEnd(e.isShiftDown(), !e.isControlDown());
            }
        }
        AbstractLineWrapper sel = this.getFocusLineWrapper();
        if (sel != null && !e.isConsumed() && (listener = sel.keyListener) != null) {
            listener.keyPressed(e);
        }
    }

    protected void handleKeyReleased(KeyEvent e) {
        KeyListener listener;
        switch (e.getKeyCode()) {
            case 37: 
            case 38: {
                if ((!this.horiz || e.getKeyCode() != 37) && (this.horiz || e.getKeyCode() != 38) || this.cursorMoveIncrement >= 0) break;
                this.stopCursorMoveTimer();
                break;
            }
            case 39: 
            case 40: {
                if ((!this.horiz || e.getKeyCode() != 39) && (this.horiz || e.getKeyCode() != 40) || this.cursorMoveIncrement <= 0) break;
                this.stopCursorMoveTimer();
            }
        }
        AbstractLineWrapper sel = this.getFocusLineWrapper();
        if (sel != null && (listener = sel.keyListener) != null) {
            listener.keyReleased(e);
        }
    }

    protected void startCursorMoveTimer(int moveMode, int increment, boolean speedup) {
        if (this.cursorMoveTimer.isRunning() && this.cursorMoveMode == moveMode) {
            if (increment > 0 && this.cursorMoveIncrement > 0 || increment < 0 && this.cursorMoveIncrement < 0) {
                return;
            }
            this.cursorMoveIncrement = increment;
            this.cursorMoveSpeedup = speedup;
            this.cursorMoveCounter = 0;
            this.cursorMoveFactor = 1;
            this.cursorMover.actionPerformed(null);
            return;
        }
        if (moveMode == 1 && this.cursorPosition != this.selectionLeadPos) {
            this.selectionAnchorPos = this.cursorPosition == this.selectionAnchorPos ? this.selectionLeadPos : this.cursorPosition;
            this.selectionLeadPos = this.cursorPosition;
            this.multiLineContent.repaint();
            this.multiLineRuler.repaint();
        }
        this.cursorMoveMode = moveMode;
        this.cursorMoveIncrement = increment;
        this.cursorMoveSpeedup = speedup;
        this.cursorMoveCounter = 0;
        this.cursorMoveFactor = 1;
        this.cursorMover.actionPerformed(null);
        this.cursorMoveTimer.setInitialDelay(this.cursorMoveInitialDelay);
        this.cursorMoveTimer.setDelay(this.cursorMoveDelay);
        this.cursorMoveTimer.start();
    }

    protected void stopCursorMoveTimer() {
        this.cursorMoveMode = 0;
        this.cursorMoveIncrement = 0;
        this.cursorMoveTimer.stop();
    }

    protected void handleLineScroll() {
        int value = this.lineScrollBar.getValue();
        Point p = this.tempPoint;
        if (this.horiz) {
            p.x = 0;
            p.y = value;
        } else {
            p.x = value;
            p.y = 0;
        }
        this.contentViewport.setViewPosition(p);
        this.headerViewport.setViewPosition(p);
    }

    protected void handleTitleMousePressed(MouseEvent e) {
        this.multiLineContent.requestFocus();
        int x = e.getX();
        int y = e.getY();
        int lineIndex = this.lineIndexAtPoint(x, y);
        int focusLineIndex = this.focusLineIndex;
        if (e.isControlDown()) {
            if (this.isLineSelected(lineIndex)) {
                this.deselectLine(lineIndex);
                lineIndex = focusLineIndex;
            } else {
                this.selectLine(lineIndex);
            }
        } else {
            int[] old = this.selectedLineIndices;
            if (e.getButton() == 1) {
                if (old.length != 1 || old[0] != lineIndex) {
                    this.setSelectedLineIndices(new int[]{lineIndex});
                }
            } else if (!this.isLineSelected(lineIndex)) {
                this.setSelectedLineIndices(new int[]{lineIndex});
            }
        }
        if (lineIndex != focusLineIndex) {
            this.setFocusLineIndex(lineIndex);
            this.scrollLineToVisible(lineIndex);
        }
        if (e.isPopupTrigger()) {
            this.showTitlePopupMenu(x, y);
            return;
        }
    }

    protected void handleTitleMouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger()) {
            this.showTitlePopupMenu(x, y);
            return;
        }
    }

    protected void handleTitleMouseClicked(MouseEvent e) {
        int y;
        int x;
        int lineIndex;
        int clicks = e.getClickCount();
        if (clicks == 2 && (lineIndex = this.lineIndexAtPoint(x = e.getX(), y = e.getY())) >= 0 && lineIndex == this.focusLineIndex) {
            int oldLineIndex = this.maximizedLineIndex;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("handleTitleMouseClicked: maximize/restore lineIndex=" + lineIndex + ", oldLineIndex=" + oldLineIndex);
            }
            if (lineIndex == oldLineIndex) {
                lineIndex = -1;
            }
            this.setMaximizedLineIndex(lineIndex);
            if (oldLineIndex >= 0) {
                this.scrollLineToVisible(oldLineIndex);
            }
        }
    }

    protected void showTitlePopupMenu() {
        int x = -this.multiLineHeader.getX();
        int y = -this.multiLineHeader.getY();
        int lineIndex = this.focusLineIndex;
        if (lineIndex >= 0) {
            AbstractLineWrapper wrapper = this.lineWrapperAtIndex(lineIndex);
            if (wrapper == null) {
                return;
            }
            ScrollView scrollView = wrapper.getScrollView();
            if (scrollView == null) {
                return;
            }
            x = scrollView.getX();
            y = scrollView.getY();
        }
        this.showTitlePopupMenu(x, y);
    }

    protected void showTitlePopupMenu(int x, int y) {
        if (this.titlePopupMenu != null) {
            this.titlePopupMenu.show(this.multiLineHeader, x, y);
        }
    }

    public long computeJumpBackwardPos(long from) {
        long newPos = 0L;
        if (this.selectionLeadPos < from && this.selectionLeadPos > newPos) {
            newPos = this.selectionLeadPos;
        }
        if (this.selectionAnchorPos < from && this.selectionAnchorPos > newPos) {
            newPos = this.selectionAnchorPos;
        }
        return newPos;
    }

    public long computeJumpForwardPos(long from) {
        long newPos = this.timeLength;
        if (this.selectionLeadPos > from && this.selectionLeadPos < newPos) {
            newPos = this.selectionLeadPos;
        }
        if (this.selectionAnchorPos > from && this.selectionAnchorPos < newPos) {
            newPos = this.selectionAnchorPos;
        }
        return newPos;
    }

    public View[] getLineSeparators() {
        return this.lineSeparators;
    }

    public void setLineSeparators(View[] lineSeparators) {
        this.lineSeparators = lineSeparators;
    }

    public ScrollView getLineSeparatorScrollView() {
        return this.lineSeparatorScrollView;
    }

    public void setLineSeparatorScrollView(ScrollView lineSeparatorScrollView) {
        this.lineSeparatorScrollView = lineSeparatorScrollView;
    }

    protected void refreshMultiLineHeader() {
        this.multiLineHeader.refresh();
    }

    protected MultiLineHeader getMultiLineHeader() {
        return this.multiLineHeader;
    }

    protected void refreshRuler() {
        int tileHeight;
        int tileWidth;
        double majorTickSize;
        for (majorTickSize = this.zoomRate; majorTickSize > 200.0; majorTickSize /= 2.0) {
        }
        double minorTickSize = majorTickSize / (double)this.minorRulerTickCount;
        this.multiLineRuler.setBackPaint(this.rulerBackground);
        this.multiLineRuler.setStaticBorderColor(this.rulerBorderColor);
        this.multiLineRuler.setOrientation(this.orientation);
        RulerView rulerView = this.multiLineRuler.getRulerView();
        rulerView.setZoomRate(this.zoomRate);
        rulerView.setMinorTickSize(minorTickSize);
        rulerView.setMajorTickSize(majorTickSize);
        rulerView.setMinorTickColor(this.rulerMinorTickColor);
        rulerView.setMajorTickColor(this.rulerMajorTickColor);
        rulerView.setBorderColor(this.rulerBorderColor);
        rulerView.setLabelColor(this.rulerLabelColor);
        this.multiLineRuler.setForeground(this.rulerLabelColor);
        this.multiLineRuler.getTileView().invalidate();
        this.lineSeparatorRulerView.setZoomRate(this.zoomRate);
        this.lineSeparatorRulerView.setMinorTickSize(minorTickSize);
        this.lineSeparatorRulerView.setMajorTickSize(majorTickSize);
        this.lineSeparatorRulerView.setMinorTickColor(this.rulerMinorTickColor);
        this.lineSeparatorRulerView.setMajorTickColor(this.rulerMajorTickColor);
        if (this.horiz) {
            tileWidth = this.contentViewport.getWidth();
            tileHeight = this.lineSeparatorSize;
        } else {
            tileWidth = this.lineSeparatorSize;
            tileHeight = this.contentViewport.getHeight();
        }
        if (this.lineSeparatorTileView != null) {
            this.lineSeparatorTileView.flush();
        }
        this.lineSeparatorTileView = new TileView(tileWidth, tileHeight, this.rulerMaxTileCacheCount, this.rulerBackground);
        this.lineSeparatorTileView.addView((View)this.lineSeparatorRulerView);
        if (this.lineSeparatorScrollView != null) {
            this.lineSeparatorScrollView.setViews(new View[]{this.lineSeparatorTileView});
            this.lineSeparatorScrollView.setViewSize(new Dimension(tileWidth, tileHeight));
        }
        this.lineSeparatorRulerView.setOrientation(this.orientation);
        this.lineSeparatorRulerView.setBounds(new Rectangle(0, 0, tileWidth, tileHeight));
    }

    public Paint getRulerBackground() {
        return this.rulerBackground;
    }

    public void setRulerBackground(Paint rulerBackground) {
        this.rulerBackground = rulerBackground;
    }

    public Color getRulerBorderColor() {
        return this.rulerBorderColor;
    }

    public void setRulerBorderColor(Color rulerBorderColor) {
        this.rulerBorderColor = rulerBorderColor;
    }

    public Color getRulerLabelColor() {
        return this.rulerLabelColor;
    }

    public void setRulerLabelColor(Color rulerLabelColor) {
        this.rulerLabelColor = rulerLabelColor;
    }

    public int getRulerMaxTileCacheCount() {
        return this.rulerMaxTileCacheCount;
    }

    public void setRulerMaxTileCacheCount(int rulerMaxTileCacheCount) {
        this.rulerMaxTileCacheCount = rulerMaxTileCacheCount;
    }

    public int getTimeScrollUnitIncrement() {
        return this.timeScrollUnitIncrement;
    }

    public void setTimeScrollUnitIncrement(int timeScrollUnitIncrement) {
        this.timeScrollUnitIncrement = timeScrollUnitIncrement;
    }

    public int getLineScrollUnitIncrement() {
        return this.lineScrollUnitIncrement;
    }

    public void setLineScrollUnitIncrement(int lineScrollUnitIncrement) {
        this.lineScrollUnitIncrement = lineScrollUnitIncrement;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public Paint getSelectionPaint() {
        return this.selectionPaint;
    }

    public void setSelectionPaint(Paint selectionPaint) {
        this.selectionPaint = selectionPaint;
    }

    public Font getRulerLabelFont() {
        return this.rulerLabelFont;
    }

    public void setRulerLabelFont(Font rulerLabelFont) {
        this.rulerLabelFont = rulerLabelFont;
    }

    public long getTimeScrollPosition() {
        return this.timeScrollBar.getLongValue();
    }

    public void setTimeScrollPosition(long value) {
        long max;
        if (value < 0L) {
            value = 0L;
        }
        if (value > (max = this.timeScrollBar.getLongMaximum())) {
            value = max;
        }
        this.timeScrollBar.setLongValue(value);
    }

    public int getScrollUnitSize() {
        return this.scrollUnitSize;
    }

    public void setScrollUnitSize(int scrollUnitSize) {
        this.scrollUnitSize = scrollUnitSize;
    }

    protected void showLinePopupMenu() {
        int lineIndex = this.focusLineIndex;
        if (lineIndex < 0) {
            return;
        }
        AbstractLineWrapper wrapper = this.lineWrapperAtIndex(lineIndex);
        if (wrapper == null) {
            return;
        }
        ScrollView scrollView = wrapper.getScrollView();
        if (scrollView == null) {
            return;
        }
        int x = scrollView.getX();
        int y = scrollView.getY();
        this.showLinePopupMenu(wrapper, x, y);
    }

    protected void showLinePopupMenu(AbstractLineWrapper wrapper, int x, int y) {
        if (wrapper == null) {
            return;
        }
        JPopupMenu linePopupMenu = wrapper.getLinePopupMenu();
        if (linePopupMenu == null) {
            return;
        }
        linePopupMenu.show(this.multiLineContent, x, y);
    }

    public void requestViewFocus() {
        this.multiLineContent.requestFocus();
    }

    public void showMovieGeneratorDialog() throws Exception {
        MovieGeneratorOptions newOptions;
        MovieGeneratorOptions options = this.getMovieGeneratorOptions();
        if (options == null) {
            options = new MovieGeneratorOptions();
        }
        if ((newOptions = new MovieGeneratorUtil().showMovieGeneratorDialog(this, this.multiLineContent, this.contentViewport, options)) != null) {
            this.setMovieGeneratorOptions(newOptions);
        }
    }

    protected void paintViewForeground(Graphics2D g) {
        double pos;
        Paint paint;
        int vw = this.multiLineContent.getWidth();
        int vh = this.multiLineContent.getHeight();
        long anchor = this.selectionAnchorPos;
        long lead = this.selectionLeadPos;
        if (anchor >= 0L && lead >= 0L && (paint = this.selectionPaint) != null) {
            long anchorPoint = LineUtil.getUnitOfs((long)(anchor - this.timeScrollPos), (double)this.zoomRate);
            long leadPoint = LineUtil.getUnitOfs((long)(lead - this.timeScrollPos), (double)this.zoomRate);
            long v0 = Math.min(anchorPoint, leadPoint);
            long v1 = Math.max(anchorPoint, leadPoint);
            int p0 = -1;
            int p1 = -1;
            if (this.horiz) {
                if (v1 >= 0L && v0 <= (long)vw) {
                    p0 = (int)Math.max(0L, v0);
                    p1 = (int)Math.min((long)vw, v1);
                }
            } else if (v1 >= 0L && v0 <= (long)vh) {
                p0 = (int)Math.max(0L, v0);
                p1 = (int)Math.min((long)vh, v1);
            }
            if (p1 >= 0) {
                g.setPaint(paint);
                int lineCount = this.getLineCount();
                int[] sel = this.getSelectedLineIndices();
                for (int i = 0; i < sel.length; ++i) {
                    AbstractLineWrapper selLineWrapper;
                    ScrollView scrollView;
                    int selLineIndex = sel[i];
                    if (selLineIndex < 0 || selLineIndex >= lineCount || (scrollView = (selLineWrapper = this.getLineWrapperAt(selLineIndex)).getScrollView()) == null) continue;
                    if (this.horiz) {
                        g.fillRect(p0, scrollView.getY(), p1 - p0 + 1, scrollView.getHeight());
                        continue;
                    }
                    g.fillRect(scrollView.getX(), p0, scrollView.getWidth(), p1 - p0 + 1);
                }
            }
        }
        if ((pos = (double)this.cursorPosition) >= 0.0) {
            long cp = LineUtil.getUnitOfs((double)(pos - (double)this.timeScrollPos), (double)this.zoomRate);
            paint = this.cursorPaint;
            if (paint != null && cp >= 0L) {
                g.setPaint(paint);
                int lineCount = this.getLineCount();
                int[] sel = this.getSelectedLineIndices();
                for (int i = 0; i < sel.length; ++i) {
                    int p;
                    AbstractLineWrapper selLineWrapper;
                    ScrollView scrollView;
                    int selLineIndex = sel[i];
                    if (selLineIndex < 0 || selLineIndex >= lineCount || (scrollView = (selLineWrapper = this.getLineWrapperAt(selLineIndex)).getScrollView()) == null) continue;
                    if (this.horiz) {
                        if (cp >= (long)scrollView.getWidth()) continue;
                        p = (int)cp;
                        g.drawLine(p, scrollView.getY(), p, scrollView.getY() + scrollView.getHeight());
                        continue;
                    }
                    if (cp >= (long)scrollView.getHeight()) continue;
                    p = (int)cp;
                    g.drawLine(scrollView.getX(), p, scrollView.getX() + scrollView.getWidth(), p);
                }
            }
        }
    }

    protected void paintRulerForeground(Graphics2D g) {
        double pos;
        Paint paint;
        int vw = this.multiLineRuler.getWidth();
        int vh = this.multiLineRuler.getHeight();
        long anchor = this.selectionAnchorPos;
        long lead = this.selectionLeadPos;
        if (anchor >= 0L && lead >= 0L && (paint = this.selectionPaint) != null) {
            long anchorPoint = LineUtil.getUnitOfs((long)(anchor - this.timeScrollPos), (double)this.zoomRate);
            long leadPoint = LineUtil.getUnitOfs((long)(lead - this.timeScrollPos), (double)this.zoomRate);
            long v0 = Math.min(anchorPoint, leadPoint);
            long v1 = Math.max(anchorPoint, leadPoint);
            if (this.horiz) {
                if (v1 >= 0L && v0 <= (long)vw) {
                    int p0 = (int)Math.max(0L, v0);
                    int p1 = (int)Math.min((long)vw, v1);
                    g.setPaint(paint);
                    g.fillRect(p0, 0, p1 - p0 + 1, vh);
                }
            } else if (v1 >= 0L && v0 <= (long)vh) {
                int p0 = (int)Math.max(0L, v0);
                int p1 = (int)Math.min((long)vh, v1);
                g.setPaint(paint);
                g.fillRect(0, p0, vw, p1 - p0 + 1);
            }
        }
        if ((pos = (double)this.cursorPosition) >= 0.0) {
            long cp = LineUtil.getUnitOfs((double)(pos - (double)this.timeScrollPos), (double)this.zoomRate);
            paint = this.cursorPaint;
            if (paint != null && cp >= 0L) {
                if (this.horiz) {
                    if (cp < (long)vw) {
                        int p = (int)cp;
                        g.setPaint(paint);
                        g.drawLine(p, 0, p, vh);
                    }
                } else if (cp < (long)vh) {
                    int p = (int)cp;
                    g.setPaint(paint);
                    g.drawLine(0, p, vw, p);
                }
            }
        }
    }

    public Paint getCursorPaint() {
        return this.cursorPaint;
    }

    public void setCursorPaint(Paint cursorPaint) {
        this.cursorPaint = cursorPaint;
    }

    public JPopupMenu getRulerPopupMenu() {
        return this.rulerPopupMenu;
    }

    public void setRulerPopupMenu(JPopupMenu rulerPopupMenu) {
        this.rulerPopupMenu = rulerPopupMenu;
    }

    public ScratchPatternProvider[] getScratchPatternProviders() {
        return this.scratchPatternProviders;
    }

    public void setScratchPatternProviders(ScratchPatternProvider[] scratchPatternProviders) {
        this.scratchPatternProviders = scratchPatternProviders;
    }

    public double getMidZoomRate() {
        return this.midZoomRate;
    }

    public void setMidZoomRate(double midZoomRate) {
        this.midZoomRate = midZoomRate;
        if (this.minZoomRate > midZoomRate) {
            this.minZoomRate = midZoomRate;
        }
        if (this.maxZoomRate < midZoomRate) {
            this.maxZoomRate = midZoomRate;
        }
    }

    public double getMinZoomRate() {
        return this.minZoomRate;
    }

    public void setMinZoomRate(double minZoomRate) {
        this.minZoomRate = minZoomRate;
        if (this.maxZoomRate < minZoomRate) {
            this.maxZoomRate = minZoomRate;
        }
        if (this.midZoomRate < minZoomRate) {
            this.midZoomRate = minZoomRate;
        }
    }

    public double getMaxZoomRate() {
        return this.maxZoomRate;
    }

    public void setMaxZoomRate(double maxZoomRate) {
        this.maxZoomRate = maxZoomRate;
        if (this.minZoomRate > maxZoomRate) {
            this.minZoomRate = maxZoomRate;
        }
        if (this.midZoomRate > maxZoomRate) {
            this.midZoomRate = maxZoomRate;
        }
    }

    protected AbstractWaxLabPanel getWaxLabPanel() {
        return this.waxLabPanel;
    }

    public int getSnapLineGridSize() {
        return this.snapLineGridSize;
    }

    public void setSnapLineGridSize(int snapLineGridSize) {
        this.snapLineGridSize = snapLineGridSize;
    }

    public boolean isSnapLineGridEnabled() {
        return this.snapLineGridEnabled;
    }

    public void setSnapLineGridEnabled(boolean snapLineGridEnabled) {
        this.snapLineGridEnabled = snapLineGridEnabled;
    }

    public boolean isHidePositionBarView() {
        return this.hidePositionBarView;
    }

    public void setHidePositionBarView(boolean hidePositionBarView) {
        this.hidePositionBarView = hidePositionBarView;
    }

    public boolean isHideFaderRecordingHelperView() {
        return this.hideFaderRecordingHelperView;
    }

    public void setHideFaderRecordingHelperView(boolean hideFaderRecordingHelperView) {
        this.hideFaderRecordingHelperView = hideFaderRecordingHelperView;
    }

    public boolean isHideMidiRecordingHelperView() {
        return this.hideMidiRecordingHelperView;
    }

    public void setHideMidiRecordingHelperView(boolean hideMidiRecordingHelperView) {
        this.hideMidiRecordingHelperView = hideMidiRecordingHelperView;
    }

    public MovieGeneratorOptions getMovieGeneratorOptions() {
        return this.movieGeneratorOptions;
    }

    public void setMovieGeneratorOptions(MovieGeneratorOptions movieGeneratorOptions) {
        this.movieGeneratorOptions = movieGeneratorOptions;
    }

    public int getCursorMoveDelay() {
        return this.cursorMoveDelay;
    }

    public void setCursorMoveDelay(int cursorMoveDelay) {
        this.cursorMoveDelay = cursorMoveDelay;
    }

    public int getCursorMoveMaxFactor() {
        return this.cursorMoveMaxFactor;
    }

    public void setCursorMoveMaxFactor(int cursorMoveMaxFactor) {
        this.cursorMoveMaxFactor = cursorMoveMaxFactor;
    }

    public int getCursorMoveSpeedupDelay() {
        return this.cursorMoveSpeedupDelay;
    }

    public void setCursorMoveSpeedupDelay(int cursorMoveSpeedupDelay) {
        this.cursorMoveSpeedupDelay = cursorMoveSpeedupDelay;
    }

    public int getCursorMoveInitialDelay() {
        return this.cursorMoveInitialDelay;
    }

    public void setCursorMoveInitialDelay(int cursorMoveInitialDelay) {
        this.cursorMoveInitialDelay = cursorMoveInitialDelay;
    }

    public int getExtendSelectionWidth() {
        return this.extendSelectionWidth;
    }

    public void setExtendSelectionWidth(int extendSelectionWidth) {
        this.extendSelectionWidth = extendSelectionWidth;
    }

    public int getRulerViewMode() {
        return this.rulerViewMode;
    }

    public void setRulerViewMode(int rulerViewMode) {
        this.rulerViewMode = rulerViewMode;
        this.multiLineRuler.setRulerViewMode(rulerViewMode);
    }

    public boolean isMaximizedLineSwitchEnabled() {
        return this.maximizedLineSwitchEnabled;
    }

    public void setMaximizedLineSwitchEnabled(boolean maximizedLineSwitchEnabled) {
        this.maximizedLineSwitchEnabled = maximizedLineSwitchEnabled;
    }

    public void switchFocusLine(int relative, boolean extendSelection) {
        int lineCount = this.getLineCount();
        int oldIndex = this.getFocusLineIndex();
        int newIndex = oldIndex + relative;
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (newIndex >= lineCount) {
            newIndex = lineCount - 1;
        }
        if (newIndex == oldIndex) {
            return;
        }
        int maxIndex = -1;
        if (!this.maximizedLineSwitchRestore && this.maximizedLineIndex >= 0) {
            maxIndex = newIndex;
        }
        if (extendSelection) {
            if (this.isLineSelected(newIndex)) {
                this.deselectLine(oldIndex);
            } else {
                this.selectLine(newIndex);
            }
        } else if (newIndex < 0) {
            this.setSelectedLineIndices(NOTHING_SELECTED);
        } else {
            this.setSelectedLineIndices(new int[]{newIndex});
        }
        this.setFocusLineIndex(newIndex);
        this.scrollLineToVisible(newIndex);
        this.setMaximizedLineIndex(maxIndex);
    }

    public boolean isMaximizedLineSwitchRestore() {
        return this.maximizedLineSwitchRestore;
    }

    public void setMaximizedLineSwitchRestore(boolean maximizedLineSwitchRestore) {
        this.maximizedLineSwitchRestore = maximizedLineSwitchRestore;
    }

    public Color getRulerMinorTickColor() {
        return this.rulerMinorTickColor;
    }

    public void setRulerMinorTickColor(Color rulerMinorTickColor) {
        this.rulerMinorTickColor = rulerMinorTickColor;
    }

    public Color getRulerMajorTickColor() {
        return this.rulerMajorTickColor;
    }

    public void setRulerMajorTickColor(Color rulerMajorTickColor) {
        this.rulerMajorTickColor = rulerMajorTickColor;
    }

    protected class CursorMover
    implements ActionListener {
        protected CursorMover() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int moveMode = MultiLinePanel.this.cursorMoveMode;
            if (moveMode == 2) {
                long pixPos = Math.round(LineUtil.getUnitPos((long)MultiLinePanel.this.timeScrollPos, (double)MultiLinePanel.this.zoomRate) + (double)(MultiLinePanel.this.cursorMoveIncrement * MultiLinePanel.this.cursorMoveFactor));
                long newPosition = LineUtil.getNanoOfs((long)pixPos, (double)MultiLinePanel.this.zoomRate);
                MultiLinePanel.this.scrollTo(newPosition);
            } else {
                long pixPos = Math.round(LineUtil.getUnitPos((long)MultiLinePanel.this.cursorPosition, (double)MultiLinePanel.this.zoomRate) + (double)(MultiLinePanel.this.cursorMoveIncrement * MultiLinePanel.this.cursorMoveFactor));
                long newPosition = LineUtil.getNanoOfs((long)pixPos, (double)MultiLinePanel.this.zoomRate);
                if (moveMode == 1) {
                    MultiLinePanel.this.moveSelectionLeadPos(newPosition);
                }
                MultiLinePanel.this.moveCursorPosition(newPosition, false);
            }
            if (MultiLinePanel.this.cursorMoveSpeedup && ++MultiLinePanel.this.cursorMoveCounter > MultiLinePanel.this.cursorMoveSpeedupDelay && MultiLinePanel.this.cursorMoveFactor < MultiLinePanel.this.cursorMoveMaxFactor) {
                MultiLinePanel.this.cursorMoveFactor++;
                MultiLinePanel.this.cursorMoveCounter = 0;
            }
        }
    }
}

