/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.studio.common.CharSeq;
import com.waxmonster.view.ImageFontCache;
import com.waxmonster.view.ScrollPos;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.TextView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.waxlab.view.MultiLinePanel;
import com.waxmonster.waxlab.view.RulerView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class MultiLineRuler
extends JComponent {
    private static final long serialVersionUID = 6135965103227176373L;
    public static final int RULER_MODE_DISABLED = -1;
    public static final int RULER_MODE_SCROLL_TIME = 0;
    public static final int RULER_MODE_STATIC_TIME = 1;
    private MultiLinePanel linePanel;
    private int orientation;
    private Paint backPaint = Color.GREEN;
    private int rulerViewMode;
    private int maxTileCacheCount = 5;
    private RulerView rulerView;
    private TileView tileView;
    private ScrollView scrollView;
    private Font rulerFont;
    private TextView staticTextView;
    private CharSeq staticCharSeq;
    private int staticTextSpacing = 5;
    private Font staticFont;
    private int staticFontHeight;
    private Color staticBorderColor = Color.GRAY;

    public MultiLineRuler() {
        this.scrollView = new ScrollView();
        this.rulerView = new RulerView();
        this.rulerView.setBackPaint(null);
        this.staticTextView = new TextView();
        this.staticTextView.setBounds(new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.staticCharSeq = new CharSeq(new char[CharSeq.MIN_LONG_LEN], 0, 0);
        this.staticTextView.setText((CharSequence)this.staticCharSeq);
        this.doLayout();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.rulerView.setOrientation(orientation);
        ScrollPos p = this.scrollView.getPosition();
        switch (orientation) {
            case 0: {
                p.y = 0L;
                break;
            }
            case 2: {
                p.x = 0L;
            }
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Rectangle r = this.getBounds();
        this.rulerView.setBounds(new Rectangle(r));
        int tileWidth = r.width;
        int tileHeight = r.height;
        if (this.tileView != null) {
            this.tileView.flush();
        }
        this.tileView = new TileView(tileWidth, tileHeight, this.maxTileCacheCount, this.backPaint);
        this.tileView.addView((View)this.rulerView);
        this.scrollView.setViews(new View[]{this.tileView});
        this.scrollView.setViewSize(new Dimension(r.width, r.height));
        this.layoutStaticViews();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        switch (this.rulerViewMode) {
            case 0: {
                this.scrollView.paint(g2d);
                break;
            }
            case 1: {
                this.paintStaticViews(g2d);
            }
        }
        MultiLinePanel lp = this.linePanel;
        if (lp != null) {
            lp.paintRulerForeground(g2d);
        }
    }

    public RulerView getRulerView() {
        return this.rulerView;
    }

    protected void setRulerView(RulerView rulerView) {
        this.rulerView = rulerView;
    }

    public void scroll(long timePos, long scrollPos, long pix) {
        switch (this.orientation) {
            case 0: {
                ScrollPos p = this.scrollView.getPosition();
                p.x = pix;
                this.scrollView.setPosition(p);
                break;
            }
            case 2: {
                ScrollPos p = this.scrollView.getPosition();
                p.y = pix;
                this.scrollView.setPosition(p);
                break;
            }
        }
        if (this.rulerViewMode == 1) {
            this.staticCharSeq.setMillis(timePos / 1000000L);
            this.layoutStaticViews();
        }
    }

    protected void layoutStaticViews() {
        Rectangle staticTextBounds = this.staticTextView.getBounds();
        int barWidth = this.getWidth();
        int barHeight = this.getHeight();
        switch (this.orientation) {
            case 0: {
                int textY = barHeight / 2 - this.staticFontHeight / 2;
                staticTextBounds.x = barWidth / 2 - this.staticTextView.textWidth() / 2;
                staticTextBounds.y = textY;
                break;
            }
            case 2: {
                int textY = barWidth / 2 - this.staticFontHeight / 2;
                staticTextBounds.x = barHeight / 2 - this.staticTextView.textWidth() / 2;
                staticTextBounds.y = textY;
                break;
            }
        }
        this.staticTextView.setBounds(staticTextBounds);
    }

    protected void paintStaticViews(Graphics2D g2d) {
        int w = this.getWidth();
        int h = this.getHeight();
        Paint backPaint = this.backPaint;
        if (backPaint != null) {
            g2d.setPaint(backPaint);
            g2d.fillRect(0, 0, w, h);
        }
        switch (this.orientation) {
            case 0: {
                int tx = this.staticTextView.getX();
                int ty = this.staticTextView.getY();
                g2d.translate(tx, ty);
                this.staticTextView.paint(g2d);
                g2d.translate(-tx, -ty);
                Color col = this.staticBorderColor;
                if (col == null) break;
                g2d.setColor(col);
                g2d.drawLine(0, 0, w - 1, 0);
                g2d.drawLine(0, h - 1, w - 1, h - 1);
                break;
            }
            case 2: {
                int transX = 0;
                int transY = h - 1;
                double theta = -1.5707963267948966;
                g2d.translate(transX, transY);
                g2d.rotate(theta);
                int tx = this.staticTextView.getX();
                int ty = this.staticTextView.getY();
                g2d.translate(tx, ty);
                this.staticTextView.paint(g2d);
                g2d.translate(-tx, -ty);
                g2d.rotate(-theta);
                g2d.translate(-transX, -transY);
                Color col = this.staticBorderColor;
                if (col == null) break;
                g2d.setColor(col);
                g2d.drawLine(0, 0, 0, h - 1);
                g2d.drawLine(w - 1, 0, w - 1, h - 1);
                break;
            }
        }
    }

    public Paint getBackPaint() {
        return this.backPaint;
    }

    public void setBackPaint(Paint backPaint) {
        this.backPaint = backPaint;
    }

    public int getMaxTileCacheCount() {
        return this.maxTileCacheCount;
    }

    public void setMaxTileCacheCount(int maxTileCacheCount) {
        this.maxTileCacheCount = maxTileCacheCount;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        ScrollPos vp = this.scrollView.getPosition();
        long x = vp.x + (long)event.getX();
        long y = vp.y + (long)event.getY();
        return this.rulerView.getToolTipText(x, y);
    }

    public TileView getTileView() {
        return this.tileView;
    }

    protected void setTileView(TileView tileView) {
        this.tileView = tileView;
    }

    public MultiLinePanel getLinePanel() {
        return this.linePanel;
    }

    public void setLinePanel(MultiLinePanel linePanel) {
        this.linePanel = linePanel;
    }

    public Font getRulerFont() {
        return this.rulerFont;
    }

    public void setRulerFont(Font rulerFont) {
        this.rulerFont = rulerFont;
        if (this.rulerView != null) {
            this.rulerView.setLabelPainted(rulerFont != null);
            this.rulerView.setFont(rulerFont);
        }
    }

    public Font getStaticFont() {
        return this.staticFont;
    }

    public void setStaticFont(Font staticFont) {
        FontMetrics metrics;
        this.staticFont = staticFont;
        Font font = staticFont;
        Color fontBack = this.getBackground();
        if (this.backPaint != null && this.backPaint instanceof Color) {
            fontBack = (Color)this.backPaint;
        }
        Color fontColor = this.getForeground();
        ImageFontCache fontCache = null;
        if (font != null && (metrics = this.getFontMetrics(font)) != null) {
            int trans = 1;
            fontCache = new ImageFontCache(metrics, fontBack, fontColor, trans);
            this.staticFontHeight = metrics.getHeight();
        }
        if (this.staticTextView != null) {
            this.staticTextView.setFont(fontCache);
        }
        this.repaint();
    }

    public int getRulerViewMode() {
        return this.rulerViewMode;
    }

    public void setRulerViewMode(int rulerViewMode) {
        this.rulerViewMode = rulerViewMode;
        this.repaint();
    }

    public int getStaticTextSpacing() {
        return this.staticTextSpacing;
    }

    public void setStaticTextSpacing(int staticTextSpacing) {
        this.staticTextSpacing = staticTextSpacing;
    }

    public Color getStaticBorderColor() {
        return this.staticBorderColor;
    }

    public void setStaticBorderColor(Color staticBorderColor) {
        this.staticBorderColor = staticBorderColor;
    }
}

