/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.beans.BeanDropManager;
import com.spacekiller.util.beans.ClipboardManager;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.edit.WaxLabSelectionEdit;
import com.waxmonster.waxlab.util.LineModelCopyInfo;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.MultiLinePanel;
import com.waxmonster.waxlab.view.WaxLabClipboardContent;
import com.waxmonster.waxlab.view.WaxLabClipboardTransferable;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class MultiLineUtil {
    private static final Logger logger = Logger.getLogger(MultiLineUtil.class.getName());

    private MultiLineUtil() {
    }

    protected static void registerEdit(MultiLinePanel linePanel, UndoableEdit edit) {
        UndoManager undoManager = MultiLineUtil.getUndoManager(linePanel);
        if (undoManager != null) {
            undoManager.addEdit(edit);
        } else {
            edit.die();
        }
    }

    protected static ClipboardManager getClipboardManager(MultiLinePanel linePanel) {
        AbstractWaxLabPanel waxPanel = linePanel.getWaxLabPanel();
        if (waxPanel == null) {
            return null;
        }
        return waxPanel.getClipboardManager();
    }

    protected static UndoManager getUndoManager(MultiLinePanel linePanel) {
        AbstractWaxLabPanel waxPanel = linePanel.getWaxLabPanel();
        if (waxPanel != null) {
            return waxPanel.getUndoManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean performUndoAction(MultiLinePanel linePanel) {
        UndoManager undoManager = MultiLineUtil.getUndoManager(linePanel);
        if (undoManager == null) {
            return false;
        }
        try {
            if (!undoManager.canUndo()) {
                boolean bl = false;
                return bl;
            }
            undoManager.undo();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            linePanel.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean performRedoAction(MultiLinePanel linePanel) {
        UndoManager undoManager = MultiLineUtil.getUndoManager(linePanel);
        if (undoManager == null) {
            return false;
        }
        try {
            if (!undoManager.canRedo()) {
                boolean bl = false;
                return bl;
            }
            undoManager.redo();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            linePanel.refresh();
        }
    }

    protected static boolean performCutAction(MultiLinePanel linePanel, boolean keepDeletedArea) {
        boolean done = MultiLineUtil.performCopyAction(linePanel);
        if (!done) {
            return false;
        }
        MultiLineUtil.performDeleteAction(linePanel, keepDeletedArea);
        return true;
    }

    protected static boolean performDeleteAction(MultiLinePanel linePanel, boolean keepDeletedArea) {
        AbstractLineWrapper wrapper;
        int i;
        int[] sel = linePanel.getSelectedLineIndices();
        int num = sel.length;
        if (num < 1) {
            return false;
        }
        long selAnchorPos = linePanel.getSelectionAnchorPos();
        if (selAnchorPos < 0L) {
            return false;
        }
        long selLeadPos = linePanel.getSelectionLeadPos();
        if (selLeadPos < 0L) {
            return false;
        }
        long selMinPos = Math.min(selAnchorPos, selLeadPos);
        long selMaxPos = Math.max(selAnchorPos, selLeadPos);
        long selNanos = selMaxPos - selMinPos;
        if (selNanos <= 0L) {
            return false;
        }
        CompoundEdit compoundEdit = null;
        for (i = 0; i < num; ++i) {
            wrapper = linePanel.getLineWrapperAt(sel[i]);
            if (wrapper == null) continue;
            UndoableEdit lineEdit = null;
            try {
                lineEdit = wrapper.performDeleteAction(selMinPos, selMaxPos);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (lineEdit == null) continue;
            if (compoundEdit == null) {
                compoundEdit = new CompoundEdit();
            }
            compoundEdit.addEdit(lineEdit);
        }
        if (keepDeletedArea) {
            if (compoundEdit != null) {
                long newCursorPosition = linePanel.getCursorPosition();
                long newSelectionAnchorPos = selAnchorPos;
                long newSelectionLeadPos = selLeadPos;
                WaxLabSelectionEdit selectionEdit = new WaxLabSelectionEdit(linePanel, newCursorPosition, newSelectionAnchorPos, newSelectionLeadPos);
                selectionEdit.perform();
                compoundEdit.addEdit(selectionEdit);
            }
        } else {
            for (i = 0; i < num; ++i) {
                wrapper = linePanel.getLineWrapperAt(sel[i]);
                if (wrapper == null) continue;
                UndoableEdit moveEdit = null;
                try {
                    long minStartTime = selMinPos;
                    long maxEndTime = Long.MAX_VALUE;
                    moveEdit = wrapper.performMoveAction(minStartTime, maxEndTime, -selNanos);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                if (moveEdit == null) continue;
                if (compoundEdit == null) {
                    compoundEdit = new CompoundEdit();
                }
                compoundEdit.addEdit(moveEdit);
            }
            long newCursorPosition = selMinPos;
            long newSelectionAnchorPos = -1L;
            long newSelectionLeadPos = -1L;
            WaxLabSelectionEdit selectionEdit = new WaxLabSelectionEdit(linePanel, newCursorPosition, newSelectionAnchorPos, newSelectionLeadPos);
            selectionEdit.perform();
            if (compoundEdit == null) {
                compoundEdit = new CompoundEdit();
            }
            compoundEdit.addEdit(selectionEdit);
        }
        if (compoundEdit == null) {
            return false;
        }
        compoundEdit.end();
        MultiLineUtil.registerEdit(linePanel, compoundEdit);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean performCopyAction(MultiLinePanel linePanel) {
        ClipboardManager clipManager = MultiLineUtil.getClipboardManager(linePanel);
        if (clipManager == null) {
            throw new RuntimeException("ClipboardManager is not available: linePanel=" + linePanel);
        }
        int[] sel = linePanel.getSelectedLineIndices();
        int num = sel.length;
        if (num < 1) {
            return false;
        }
        long selAnchorPos = linePanel.getSelectionAnchorPos();
        if (selAnchorPos < 0L) {
            return false;
        }
        long selLeadPos = linePanel.getSelectionLeadPos();
        if (selLeadPos < 0L) {
            return false;
        }
        long selMinPos = Math.min(selAnchorPos, selLeadPos);
        long selMaxPos = Math.max(selAnchorPos, selLeadPos);
        long selNanos = selMaxPos - selMinPos;
        if (selNanos <= 0L) {
            return false;
        }
        LinkedList<LineModelCopyInfo> infoList = null;
        boolean success = false;
        try {
            for (int i = 0; i < num; ++i) {
                int infoCount;
                LineModelCopyInfo[] infos;
                AbstractLineWrapper wrapper = linePanel.getLineWrapperAt(sel[i]);
                if (wrapper == null || (infos = wrapper.performCopyAction(selMinPos, selMaxPos)) == null || (infoCount = infos.length) < 1) continue;
                if (infoList == null) {
                    infoList = new LinkedList<LineModelCopyInfo>();
                }
                for (int k = 0; k < infoCount; ++k) {
                    infoList.add(infos[k]);
                }
            }
            long timeLength = selNanos;
            LineModelCopyInfo[] sampleModelCopyInfos = null;
            if (infoList != null) {
                sampleModelCopyInfos = infoList.toArray(new LineModelCopyInfo[infoList.size()]);
            }
            WaxLabClipboardContent content = new WaxLabClipboardContent(timeLength, sampleModelCopyInfos);
            WaxLabClipboardTransferable trans = new WaxLabClipboardTransferable(content);
            clipManager.setContents((Transferable)trans, (ClipboardOwner)trans);
            success = true;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!success && infoList != null) {
                int infoCount = infoList.size();
                for (int k = 0; k < infoCount; ++k) {
                    LineModelCopyInfo info = (LineModelCopyInfo)infoList.get(k);
                    if (info == null) continue;
                    info.dispose();
                }
            }
        }
    }

    protected static boolean performPasteAction(MultiLinePanel linePanel, boolean replaceArea) {
        ClipboardManager clipManager = MultiLineUtil.getClipboardManager(linePanel);
        if (clipManager == null) {
            throw new RuntimeException("ClipboardManager is not available: linePanel=" + linePanel);
        }
        long pastePos = linePanel.getCursorPosition();
        if (pastePos < 0L) {
            pastePos = 0L;
        }
        WaxLabClipboardContent content = null;
        try {
            DataFlavor dataFlavor = BeanDropManager.getJavaJVMLocalObjectFlavor();
            Transferable trans = clipManager.getTransferable();
            if (!trans.isDataFlavorSupported(dataFlavor)) {
                return false;
            }
            Object object = trans.getTransferData(dataFlavor);
            if (object == null) {
                return false;
            }
            if (object instanceof WaxLabClipboardContent) {
                content = (WaxLabClipboardContent)object;
            }
            if (content == null) {
                return false;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        return MultiLineUtil.performInsertAction(linePanel, pastePos, replaceArea, content);
    }

    protected static boolean performInsertAction(MultiLinePanel linePanel, long pastePos, boolean replaceArea, WaxLabClipboardContent content) {
        long leadPos;
        AbstractLineWrapper wrapper;
        int i;
        CompoundEdit compoundEdit = null;
        int[] sel = linePanel.getSelectedLineIndices();
        if (sel.length < 1) {
            return false;
        }
        int num = sel.length;
        long contentNanos = content.getTimeLength();
        for (i = 0; i < num; ++i) {
            wrapper = linePanel.getLineWrapperAt(sel[i]);
            if (wrapper == null) continue;
            try {
                long moveNanos;
                long maxEndTime;
                long minStartTime;
                UndoableEdit moveEdit;
                if (replaceArea) {
                    throw new UnsupportedOperationException("TODO replaceArea=" + replaceArea + ", contentNanos=" + contentNanos);
                }
                long splitTime = pastePos;
                UndoableEdit splitEdit = wrapper.performSplitAction(splitTime);
                if (splitEdit != null) {
                    if (compoundEdit == null) {
                        compoundEdit = new CompoundEdit();
                    }
                    compoundEdit.addEdit(splitEdit);
                }
                if ((moveEdit = wrapper.performMoveAction(minStartTime = pastePos, maxEndTime = Long.MAX_VALUE, moveNanos = contentNanos)) == null) continue;
                if (compoundEdit == null) {
                    compoundEdit = new CompoundEdit();
                }
                compoundEdit.addEdit(moveEdit);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        for (i = 0; i < num; ++i) {
            LineModelCopyInfo[] lineModelCopyInfos;
            wrapper = linePanel.getLineWrapperAt(sel[i]);
            if (wrapper == null || (lineModelCopyInfos = content.getLineModelCopyInfos()) == null) continue;
            for (int k = 0; k < lineModelCopyInfos.length; ++k) {
                long modelEnd;
                long modelOfs;
                long relativeChunkEnd;
                long chunkEnd;
                LineModel lineModel;
                LineChunk sourceChunk;
                LineModelCopyInfo lineModelCopyInfo = lineModelCopyInfos[k];
                if (lineModelCopyInfo == null || (sourceChunk = lineModelCopyInfo.getLineChunk()) == null || (lineModel = sourceChunk.getLineModel()) == null) continue;
                Line originalLine = lineModelCopyInfo.getOriginalLine();
                long relativeChunkOfs = sourceChunk.getChunkOfs();
                long chunkOfs = pastePos + relativeChunkOfs;
                MutableLineChunk chunk = lineModel.createLineChunk(chunkOfs, chunkEnd = pastePos + (relativeChunkEnd = sourceChunk.getChunkEnd()), modelOfs = sourceChunk.getModelOfs(), modelEnd = sourceChunk.getModelEnd());
                if (chunk == null) continue;
                try {
                    UndoableEdit pasteEdit = wrapper.performPasteAction((LineChunk)chunk);
                    if (pasteEdit == null) continue;
                    if (compoundEdit == null) {
                        compoundEdit = new CompoundEdit();
                    }
                    compoundEdit.addEdit(pasteEdit);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        if (compoundEdit == null) {
            return false;
        }
        long anchorPos = pastePos;
        long newCursorPosition = leadPos = pastePos + contentNanos;
        long newSelectionAnchorPos = anchorPos;
        long newSelectionLeadPos = leadPos;
        WaxLabSelectionEdit selectionEdit = new WaxLabSelectionEdit(linePanel, newCursorPosition, newSelectionAnchorPos, newSelectionLeadPos);
        selectionEdit.perform();
        compoundEdit.addEdit(selectionEdit);
        compoundEdit.end();
        MultiLineUtil.registerEdit(linePanel, compoundEdit);
        return true;
    }

    protected static boolean performInsertFileAction(MultiLinePanel linePanel, boolean replaceArea) {
        AbstractLineWrapper wrapper = linePanel.getFocusLineWrapper();
        if (wrapper == null) {
            return false;
        }
        long pastePos = linePanel.getCursorPosition();
        if (pastePos < 0L) {
            pastePos = 0L;
        }
        File file = null;
        try {
            file = wrapper.showOpenFileDialog();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (file == null) {
            return false;
        }
        return MultiLineUtil.performInsertFileAction(linePanel, wrapper, pastePos, replaceArea, file);
    }

    protected static boolean performInsertFileAction(MultiLinePanel linePanel, AbstractLineWrapper wrapper, long pastePos, boolean replaceArea, File file) {
        int infoNum;
        if (wrapper == null) {
            return false;
        }
        LineChunk[] lineChunks = null;
        try {
            lineChunks = wrapper.openLineChunks(file);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        if (lineChunks == null) {
            return false;
        }
        int num = lineChunks.length;
        if (num < 1) {
            return false;
        }
        long contentNanos = 0L;
        LinkedList<LineModelCopyInfo> lineModelCopyInfoList = new LinkedList<LineModelCopyInfo>();
        for (int i = 0; i < num; ++i) {
            LineModel lineModel;
            LineChunk lineChunk = lineChunks[i];
            if (lineChunk == null || (lineModel = lineChunk.getLineModel()) == null) continue;
            long chunkOfs = lineChunk.getChunkOfs();
            long chunkEnd = lineChunk.getChunkEnd();
            if (chunkEnd <= chunkOfs) continue;
            if (chunkEnd > contentNanos) {
                contentNanos = chunkEnd;
            }
            Line originalLine = wrapper.getLine();
            LineModelCopyInfo copyInfo = new LineModelCopyInfo(lineChunk, originalLine);
            lineModelCopyInfoList.add(copyInfo);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("performInsertFileAction: pastePos=" + pastePos + ", models=" + num + ", contentNanos=" + contentNanos);
        }
        if ((infoNum = lineModelCopyInfoList.size()) < 1) {
            return false;
        }
        LineModelCopyInfo[] lineModelCopyInfos = lineModelCopyInfoList.toArray(new LineModelCopyInfo[infoNum]);
        long timeLength = contentNanos;
        WaxLabClipboardContent content = new WaxLabClipboardContent(timeLength, lineModelCopyInfos);
        return MultiLineUtil.performInsertAction(linePanel, pastePos, replaceArea, content);
    }

    protected static class InsertAction
    extends AbstractAction {
        private static final long serialVersionUID = 3213153513788819666L;
        public static final String ACTION_INSERT_FILE = "InsertAction";
        private MultiLinePanel linePanel;

        public InsertAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean replaceArea = false;
            MultiLineUtil.performInsertFileAction(this.linePanel, replaceArea);
        }
    }

    protected static class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -1584122362384429167L;
        public static final String ACTION_REDO = "RedoAction";
        private MultiLinePanel linePanel;

        public RedoAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiLineUtil.performRedoAction(this.linePanel);
        }
    }

    protected static class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 2867260888131319014L;
        public static final String ACTION_UNDO = "UndoAction";
        private MultiLinePanel linePanel;

        public UndoAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiLineUtil.performUndoAction(this.linePanel);
        }
    }

    protected static class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -8359976651174254236L;
        public static final String ACTION_DELETE_REMOVE = "DeleteRemoveAction";
        public static final String ACTION_DELETE_CLEAR = "DeleteClearAction";
        private MultiLinePanel linePanel;
        private boolean keepDeletedArea;

        public DeleteAction(MultiLinePanel linePanel, boolean keepDeletedArea) {
            this.linePanel = linePanel;
            this.keepDeletedArea = keepDeletedArea;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiLineUtil.performDeleteAction(this.linePanel, this.keepDeletedArea);
        }
    }

    protected static class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = -3311833047047727384L;
        public static final String ACTION_PASTE_INSERT = "PasteInsertAction";
        public static final String ACTION_PASTE_REPLACE = "PasteReplaceAction";
        private MultiLinePanel linePanel;
        private boolean replaceArea;

        public PasteAction(MultiLinePanel linePanel, boolean replaceArea) {
            this.linePanel = linePanel;
            this.replaceArea = replaceArea;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiLineUtil.performPasteAction(this.linePanel, this.replaceArea);
        }
    }

    protected static class CutAction
    extends AbstractAction {
        private static final long serialVersionUID = -4289814352886386208L;
        public static final String ACTION_CUT = "CutAction";
        private MultiLinePanel linePanel;

        public CutAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean keepDeletedArea = false;
            MultiLineUtil.performCutAction(this.linePanel, keepDeletedArea);
        }
    }

    protected static class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = -6632583375615957934L;
        public static final String ACTION_COPY = "CopyAction";
        private MultiLinePanel linePanel;

        public CopyAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiLineUtil.performCopyAction(this.linePanel);
        }
    }

    protected static class RestoreMaximizedLineAction
    extends AbstractAction {
        private static final long serialVersionUID = 4295403374881516800L;
        public static final String ACTION_RESTORE_MAXIMIZED_LINE = "RestoreMaximizedLineAction";
        private MultiLinePanel linePanel;

        public RestoreMaximizedLineAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int maximizedLineIndex = this.linePanel.getMaximizedLineIndex();
            if (maximizedLineIndex >= 0) {
                int focIndex = this.linePanel.getFocusLineIndex();
                this.linePanel.setMaximizedLineIndex(-1);
                if (focIndex >= 0) {
                    this.linePanel.scrollLineToVisible(focIndex);
                }
            }
        }
    }

    protected static class ToggleMaximizeRestoreLineAction
    extends AbstractAction {
        private static final long serialVersionUID = 3114957564745800391L;
        public static final String ACTION_TOGGLE_MAXIMIZE_RESTORE_LINE = "ToggleMaximizeRestoreLineAction";
        private MultiLinePanel linePanel;

        public ToggleMaximizeRestoreLineAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int focIndex = this.linePanel.getFocusLineIndex();
            if (focIndex >= 0) {
                int maximizedLineIndex = this.linePanel.getMaximizedLineIndex();
                if (focIndex == maximizedLineIndex) {
                    this.linePanel.setMaximizedLineIndex(-1);
                    this.linePanel.scrollLineToVisible(focIndex);
                } else {
                    this.linePanel.setMaximizedLineIndex(focIndex);
                }
            }
        }
    }

    protected static class ZoomOutAction
    extends AbstractAction {
        private static final long serialVersionUID = -1223309571109430965L;
        public static final String ACTION_ZOOM_OUT = "ZoomOutAction";
        private MultiLinePanel linePanel;

        public ZoomOutAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.linePanel.zoomOut();
        }
    }

    protected static class ZoomInAction
    extends AbstractAction {
        private static final long serialVersionUID = 7873798675452308985L;
        public static final String ACTION_ZOOM_IN = "ZoomInAction";
        private MultiLinePanel linePanel;

        public ZoomInAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.linePanel.zoomIn();
        }
    }

    protected static class SelectAllLineAreasAction
    extends AbstractAction {
        private static final long serialVersionUID = 6662570894808101159L;
        public static final String ACTION_SELECT_ALL_LINE_AREAS = "SelectAllLineAreasAction";
        private MultiLinePanel linePanel;

        public SelectAllLineAreasAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.linePanel.selectAllLines();
            this.linePanel.selectAll();
        }
    }

    protected static class SelectAllLinesAction
    extends AbstractAction {
        private static final long serialVersionUID = 8840578632839064640L;
        public static final String ACTION_SELECT_ALL_LINES = "SelectAllLinesAction";
        private MultiLinePanel linePanel;

        public SelectAllLinesAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int lineCount = this.linePanel.getLineCount();
            int[] sel = this.linePanel.getSelectedLineIndices();
            if (sel.length < lineCount) {
                this.linePanel.selectAllLines();
            } else {
                int lineIndex = this.linePanel.getFocusLineIndex();
                if (lineIndex >= 0) {
                    this.linePanel.setSelectedLineIndices(new int[]{lineIndex});
                } else {
                    this.linePanel.setSelectedLineIndices(null);
                }
            }
        }
    }

    protected static class DeselectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 5936370195202678796L;
        public static final String ACTION_DESELECT_ALL = "DeselectAllAction";
        private MultiLinePanel linePanel;

        public DeselectAllAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.linePanel.deselectAll();
        }
    }

    protected static class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 4775954760844578780L;
        public static final String ACTION_SELECT_ALL = "SelectAllAction";
        private MultiLinePanel linePanel;

        public SelectAllAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.linePanel.selectAll();
        }
    }

    protected static class ScrollLinePageDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 1355435702197577953L;
        public static final String ACTION_SCROLL_LINE_PAGE_DOWN = "ScrollLinePageDownAction";
        private MultiLinePanel linePanel;

        public ScrollLinePageDownAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.linePanel.scrollLinePageDown();
        }
    }

    protected static class ScrollLinePageUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -5577114879910910970L;
        public static final String ACTION_SCROLL_LINE_PAGE_UP = "ScrollLinePageUpAction";
        private MultiLinePanel linePanel;

        public ScrollLinePageUpAction(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.linePanel.scrollLinePageUp();
        }
    }

    protected static class MoveCursorPageForwardAction
    extends AbstractAction {
        private static final long serialVersionUID = -8936553215694762546L;
        public static final String ACTION_MOVE_CURSOR_PAGE_FWRD = "MoveCursorPageForwardAction";
        public static final String ACTION_MOVE_CURSOR_SELECT_PAGE_FWRD = "ShiftMoveCursorPageForwardAction";
        private MultiLinePanel linePanel;
        private boolean shiftDown;

        public MoveCursorPageForwardAction(MultiLinePanel linePanel, boolean shiftDown) {
            this.linePanel = linePanel;
            this.shiftDown = shiftDown;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.linePanel.moveCursorPageForward(this.shiftDown);
        }
    }

    protected static class MoveCursorPageBackwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 3584237380817079533L;
        public static final String ACTION_MOVE_CURSOR_PAGE_BWRD = "MoveCursorPageBackwardAction";
        public static final String ACTION_MOVE_CURSOR_SELECT_PAGE_BWRD = "MoveCursorSelectPageBackwardAction";
        private MultiLinePanel linePanel;
        private boolean shiftDown;

        public MoveCursorPageBackwardAction(MultiLinePanel linePanel, boolean shiftDown) {
            this.linePanel = linePanel;
            this.shiftDown = shiftDown;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.linePanel.moveCursorPageBackward(this.shiftDown);
        }
    }

    protected static class ViewKeyHandler
    extends KeyAdapter {
        private MultiLinePanel linePanel;

        public ViewKeyHandler(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            this.linePanel.handleKeyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            super.keyReleased(e);
            this.linePanel.handleKeyReleased(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            this.linePanel.handleKeyTyped(e);
        }
    }

    protected static class TitleMouseHandler
    extends MouseAdapter {
        private MultiLinePanel linePanel;

        public TitleMouseHandler(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.linePanel.handleTitleMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.linePanel.handleTitleMouseReleased(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            this.linePanel.handleTitleMouseClicked(e);
        }
    }

    protected static class RulerMouseWheelHandler
    implements MouseWheelListener {
        private MultiLinePanel linePanel;

        public RulerMouseWheelHandler(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.linePanel.handleRulerMouseWheelMoved(e);
        }
    }

    protected static class RulerMouseMotionHandler
    extends MouseMotionAdapter {
        private MultiLinePanel linePanel;

        public RulerMouseMotionHandler(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            this.linePanel.handleRulerMouseMoved(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            this.linePanel.handleRulerMouseDragged(e);
        }
    }

    protected static class RulerMouseHandler
    extends MouseAdapter {
        private MultiLinePanel linePanel;

        public RulerMouseHandler(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.linePanel.handleRulerMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.linePanel.handleRulerMouseReleased(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            this.linePanel.handleRulerMouseClicked(e);
        }
    }

    protected static class ViewMouseWheelHandler
    implements MouseWheelListener {
        private MultiLinePanel linePanel;

        public ViewMouseWheelHandler(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.linePanel.handleMouseWheelMoved(e);
        }
    }

    protected static class ViewMouseMotionHandler
    extends MouseMotionAdapter {
        private MultiLinePanel linePanel;

        public ViewMouseMotionHandler(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            this.linePanel.handleMouseMoved(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            this.linePanel.handleMouseDragged(e);
        }
    }

    protected static class ViewMouseHandler
    extends MouseAdapter {
        private MultiLinePanel linePanel;

        public ViewMouseHandler(MultiLinePanel linePanel) {
            this.linePanel = linePanel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.linePanel.handleMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.linePanel.handleMouseReleased(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            this.linePanel.handleMouseClicked(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            this.linePanel.handleMouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            this.linePanel.handleMouseExited(e);
        }
    }
}

