/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.ControlListener;
import com.spacekiller.util.media.control.FaderControlPanel;
import com.spacekiller.util.media.control.TextFieldControlPanel;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.PitchBpmControl;
import com.waxmonster.waxlab.PitchDeckControl;
import com.waxmonster.waxlab.PitchFactorControl;
import com.waxmonster.waxlab.PitchModeControl;
import com.waxmonster.waxlab.impl.AbstractPitchFactorControl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PitchControlPanel
extends JPanel {
    private static final long serialVersionUID = 1098018082087789040L;
    public static final String SYNC_BPM_TITLE_33 = "33 + 1/3";
    public static final String SYNC_BPM_TITLE_66 = "66 + 2/3";
    public static final String SYNC_BPM_TITLE_76 = "76 + 4/21";
    public static final String SYNC_BPM_TITLE_80 = "80";
    public static final String SYNC_BPM_TITLE_88 = "88 + 8/9";
    public static final String SYNC_BPM_TITLE_100 = "100";
    public static final String SYNC_BPM_TITLE_106 = "106 + 2/3";
    public static final String SYNC_BPM_TITLE_114 = "114 + 2/7";
    public static final String SYNC_BPM_TITLE_118 = "118 + 14/27";
    public static final String SYNC_BPM_TITLE_133 = "133 + 1/3";
    public static final String SYNC_BPM_TITLE_152 = "152 + 8/21";
    public static final String SYNC_BPM_TITLE_160 = "160";
    public static final String SYNC_BPM_TITLE_177 = "177 + 7/9";
    public static final String SYNC_BPM_TITLE_200 = "200";
    private PitchModeControl pitchModeControl;
    private PitchFactorControl pitchFactorControl;
    private PitchBpmControl pitchBpmControl;
    private PitchDeckControl pitchDeckControl;
    private String[] pitchRanges;
    private ControlHandler controlHandler = new ControlHandler();
    private boolean refreshing;
    private JComboBox comboBoxRange;
    private FaderControlPanel faderControlPanel;
    private TextFieldControlPanel textFieldControlPanel;
    private JRadioButton rdbtnCustom;
    private JRadioButton rdbtnBpmSync;
    private JRadioButton rdbtnDeckSync;
    private JTextField textFieldBPM;
    private JComboBox comboBoxDeck;
    private JLabel label;
    private JLabel label_1;
    private JRadioButton rdbtnNormal;
    private JLabel lblLabelSync;
    private JComboBox comboBoxLabelSyncBpm;
    private JLabel lblBpm;

    public PitchControlPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
        this.rdbtnCustom = new JRadioButton("Custom:");
        this.rdbtnCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PitchControlPanel.this.refreshing) {
                    PitchControlPanel.this.applyPitchMode();
                }
            }
        });
        this.rdbtnNormal = new JRadioButton("Normal");
        this.rdbtnNormal.setToolTipText("Use normal pitch");
        GridBagConstraints gbc_rdbtnNormal = new GridBagConstraints();
        gbc_rdbtnNormal.anchor = 17;
        gbc_rdbtnNormal.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnNormal.gridx = 0;
        gbc_rdbtnNormal.gridy = 0;
        this.add((Component)this.rdbtnNormal, gbc_rdbtnNormal);
        this.rdbtnCustom.setToolTipText("Use custom pitch...");
        this.rdbtnCustom.setOpaque(false);
        GridBagConstraints gbc_rdbtnCustom = new GridBagConstraints();
        gbc_rdbtnCustom.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnCustom.anchor = 17;
        gbc_rdbtnCustom.gridx = 0;
        gbc_rdbtnCustom.gridy = 1;
        this.add((Component)this.rdbtnCustom, gbc_rdbtnCustom);
        JPanel panelCustom = new JPanel();
        GridBagConstraints gbc_panelCustom = new GridBagConstraints();
        gbc_panelCustom.insets = new Insets(4, 4, 5, 5);
        gbc_panelCustom.weightx = 1.0;
        gbc_panelCustom.fill = 2;
        gbc_panelCustom.gridx = 1;
        gbc_panelCustom.gridy = 1;
        this.add((Component)panelCustom, gbc_panelCustom);
        GridBagLayout gbl_panelCustom = new GridBagLayout();
        gbl_panelCustom.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panelCustom.rowHeights = new int[]{0, 0, 0};
        gbl_panelCustom.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelCustom.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        panelCustom.setLayout(gbl_panelCustom);
        this.textFieldControlPanel = new TextFieldControlPanel();
        this.textFieldControlPanel.setToolTipText("Custom pitch percent");
        this.textFieldControlPanel.setColumns(6);
        GridBagConstraints gbc_textFieldControlPanel = new GridBagConstraints();
        gbc_textFieldControlPanel.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldControlPanel.fill = 1;
        gbc_textFieldControlPanel.gridx = 0;
        gbc_textFieldControlPanel.gridy = 0;
        panelCustom.add((Component)this.textFieldControlPanel, gbc_textFieldControlPanel);
        this.label = new JLabel("%");
        this.label.setToolTipText("Percent pitch");
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.fill = 1;
        gbc_label.insets = new Insets(0, 0, 0, 5);
        gbc_label.gridx = 1;
        gbc_label.gridy = 0;
        panelCustom.add((Component)this.label, gbc_label);
        this.faderControlPanel = new FaderControlPanel();
        this.faderControlPanel.setToolTipText("Custom pitch");
        this.faderControlPanel.setOrientation(0);
        GridBagConstraints gbc_faderControlPanel = new GridBagConstraints();
        gbc_faderControlPanel.insets = new Insets(0, 4, 0, 5);
        gbc_faderControlPanel.weightx = 1.0;
        gbc_faderControlPanel.fill = 1;
        gbc_faderControlPanel.gridx = 2;
        gbc_faderControlPanel.gridy = 0;
        panelCustom.add((Component)this.faderControlPanel, gbc_faderControlPanel);
        this.comboBoxRange = new JComboBox();
        this.comboBoxRange.setPreferredSize(new Dimension(80, 25));
        this.comboBoxRange.setEditable(true);
        this.comboBoxRange.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PitchControlPanel.this.refreshing) {
                    PitchControlPanel.this.applyRange();
                }
            }
        });
        this.comboBoxRange.setToolTipText("Pitch range");
        this.comboBoxRange.setOpaque(false);
        GridBagConstraints gbc_comboBoxRange = new GridBagConstraints();
        gbc_comboBoxRange.insets = new Insets(0, 5, 0, 5);
        gbc_comboBoxRange.fill = 1;
        gbc_comboBoxRange.gridx = 3;
        gbc_comboBoxRange.gridy = 0;
        panelCustom.add((Component)this.comboBoxRange, gbc_comboBoxRange);
        this.label_1 = new JLabel("%");
        GridBagConstraints gbc_label_1 = new GridBagConstraints();
        gbc_label_1.insets = new Insets(0, 0, 0, 4);
        gbc_label_1.gridx = 4;
        gbc_label_1.gridy = 0;
        panelCustom.add((Component)this.label_1, gbc_label_1);
        this.rdbtnBpmSync = new JRadioButton("Beat Sync:");
        this.rdbtnBpmSync.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PitchControlPanel.this.refreshing) {
                    PitchControlPanel.this.applyPitchMode();
                }
            }
        });
        this.rdbtnBpmSync.setToolTipText("Synchronize to target BPM...");
        this.rdbtnBpmSync.setOpaque(false);
        GridBagConstraints gbc_rdbtnBpmSync = new GridBagConstraints();
        gbc_rdbtnBpmSync.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnBpmSync.anchor = 17;
        gbc_rdbtnBpmSync.gridx = 0;
        gbc_rdbtnBpmSync.gridy = 2;
        this.add((Component)this.rdbtnBpmSync, gbc_rdbtnBpmSync);
        JPanel panelBeatSync = new JPanel();
        GridBagConstraints gbc_panelBeatSync = new GridBagConstraints();
        gbc_panelBeatSync.insets = new Insets(4, 4, 5, 5);
        gbc_panelBeatSync.weightx = 1.0;
        gbc_panelBeatSync.fill = 2;
        gbc_panelBeatSync.gridx = 1;
        gbc_panelBeatSync.gridy = 2;
        this.add((Component)panelBeatSync, gbc_panelBeatSync);
        GridBagLayout gbl_panelBeatSync = new GridBagLayout();
        gbl_panelBeatSync.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panelBeatSync.rowHeights = new int[]{0, 0};
        gbl_panelBeatSync.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelBeatSync.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelBeatSync.setLayout(gbl_panelBeatSync);
        this.textFieldBPM = new JTextField();
        this.textFieldBPM.setHorizontalAlignment(2);
        this.textFieldBPM.setToolTipText("Target BPM (beats per minute)");
        this.textFieldBPM.setOpaque(false);
        GridBagConstraints gbc_textFieldBPM = new GridBagConstraints();
        gbc_textFieldBPM.weightx = 1.0;
        gbc_textFieldBPM.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldBPM.weighty = 1.0;
        gbc_textFieldBPM.fill = 1;
        gbc_textFieldBPM.gridx = 0;
        gbc_textFieldBPM.gridy = 0;
        panelBeatSync.add((Component)this.textFieldBPM, gbc_textFieldBPM);
        this.textFieldBPM.setColumns(6);
        this.lblBpm = new JLabel("BPM");
        this.lblBpm.setToolTipText("BPM (beats per minute)");
        GridBagConstraints gbc_lblBpm = new GridBagConstraints();
        gbc_lblBpm.insets = new Insets(0, 0, 0, 5);
        gbc_lblBpm.gridx = 1;
        gbc_lblBpm.gridy = 0;
        panelBeatSync.add((Component)this.lblBpm, gbc_lblBpm);
        this.lblLabelSync = new JLabel("Rotation-Sync:");
        this.lblLabelSync.setToolTipText("Sticker-Rotation-Sync BPM");
        GridBagConstraints gbc_lblLabelSync = new GridBagConstraints();
        gbc_lblLabelSync.insets = new Insets(0, 8, 0, 5);
        gbc_lblLabelSync.anchor = 13;
        gbc_lblLabelSync.gridx = 2;
        gbc_lblLabelSync.gridy = 0;
        panelBeatSync.add((Component)this.lblLabelSync, gbc_lblLabelSync);
        this.comboBoxLabelSyncBpm = new JComboBox();
        this.comboBoxLabelSyncBpm.setToolTipText("Sticker-Rotation-Sync BPM");
        this.comboBoxLabelSyncBpm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PitchControlPanel.this.refreshing) {
                    PitchControlPanel.this.applyLabelSyncBpm();
                }
            }
        });
        GridBagConstraints gbc_comboBoxLabelSyncBpm = new GridBagConstraints();
        gbc_comboBoxLabelSyncBpm.fill = 2;
        gbc_comboBoxLabelSyncBpm.gridx = 3;
        gbc_comboBoxLabelSyncBpm.gridy = 0;
        panelBeatSync.add((Component)this.comboBoxLabelSyncBpm, gbc_comboBoxLabelSyncBpm);
        this.rdbtnDeckSync = new JRadioButton("Deck Sync:");
        this.rdbtnDeckSync.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PitchControlPanel.this.refreshing) {
                    PitchControlPanel.this.applyPitchMode();
                }
            }
        });
        this.rdbtnDeckSync.setToolTipText("Synchronize with source deck...");
        this.rdbtnDeckSync.setOpaque(false);
        GridBagConstraints gbc_rdbtnDeckSync = new GridBagConstraints();
        gbc_rdbtnDeckSync.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnDeckSync.anchor = 17;
        gbc_rdbtnDeckSync.gridx = 0;
        gbc_rdbtnDeckSync.gridy = 3;
        this.add((Component)this.rdbtnDeckSync, gbc_rdbtnDeckSync);
        JPanel panelDeckSync = new JPanel();
        GridBagConstraints gbc_panelDeckSync = new GridBagConstraints();
        gbc_panelDeckSync.insets = new Insets(4, 4, 5, 5);
        gbc_panelDeckSync.weightx = 1.0;
        gbc_panelDeckSync.fill = 2;
        gbc_panelDeckSync.gridx = 1;
        gbc_panelDeckSync.gridy = 3;
        this.add((Component)panelDeckSync, gbc_panelDeckSync);
        GridBagLayout gbl_panelDeckSync = new GridBagLayout();
        gbl_panelDeckSync.columnWidths = new int[]{0, 0};
        gbl_panelDeckSync.rowHeights = new int[]{0, 0};
        gbl_panelDeckSync.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelDeckSync.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelDeckSync.setLayout(gbl_panelDeckSync);
        this.comboBoxDeck = new JComboBox();
        this.comboBoxDeck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PitchControlPanel.this.refreshing) {
                    PitchControlPanel.this.applyDeck();
                }
            }
        });
        this.comboBoxDeck.setToolTipText("Sync source deck");
        this.comboBoxDeck.setOpaque(false);
        GridBagConstraints gbc_comboBoxDeck = new GridBagConstraints();
        gbc_comboBoxDeck.fill = 3;
        gbc_comboBoxDeck.anchor = 17;
        gbc_comboBoxDeck.gridx = 0;
        gbc_comboBoxDeck.gridy = 0;
        panelDeckSync.add((Component)this.comboBoxDeck, gbc_comboBoxDeck);
        this.initPitchControlPanel();
    }

    protected JComboBox getComboBoxRange() {
        return this.comboBoxRange;
    }

    protected FaderControlPanel getFaderControlPanel() {
        return this.faderControlPanel;
    }

    protected TextFieldControlPanel getTextFieldControlPanel() {
        return this.textFieldControlPanel;
    }

    protected JRadioButton getRdbtnCustom() {
        return this.rdbtnCustom;
    }

    protected JRadioButton getRdbtnBpmSync() {
        return this.rdbtnBpmSync;
    }

    protected JRadioButton getRdbtnDeckSync() {
        return this.rdbtnDeckSync;
    }

    protected JTextField getTextFieldBPM() {
        return this.textFieldBPM;
    }

    protected JComboBox getComboBoxDeck() {
        return this.comboBoxDeck;
    }

    protected void initPitchControlPanel() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rdbtnNormal);
        bg.add(this.rdbtnCustom);
        bg.add(this.rdbtnBpmSync);
        bg.add(this.rdbtnDeckSync);
        this.textFieldBPM.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!PitchControlPanel.this.refreshing) {
                    PitchControlPanel.this.applyBPM();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!PitchControlPanel.this.refreshing) {
                    PitchControlPanel.this.applyBPM();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!PitchControlPanel.this.refreshing) {
                    PitchControlPanel.this.applyBPM();
                }
            }
        });
        this.textFieldControlPanel.setFormat((Format)new DecimalFormat("0.000"));
        this.setPitchRanges(AbstractPitchFactorControl.getCommonPitchRanges());
        this.comboBoxDeck.setRenderer(new LineListCellRenderer());
        this.comboBoxLabelSyncBpm.removeAllItems();
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_33);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_66);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_76);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_80);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_88);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_100);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_106);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_114);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_118);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_133);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_152);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_160);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_177);
        this.comboBoxLabelSyncBpm.addItem(SYNC_BPM_TITLE_200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        double bpm = 133.33333333333334;
        try {
            this.refreshing = true;
            PitchModeControl modeControl = this.pitchModeControl;
            PitchFactorControl factorControl = this.pitchFactorControl;
            PitchBpmControl bpmControl = this.pitchBpmControl;
            PitchDeckControl deckControl = this.pitchDeckControl;
            Object mode = "Normal";
            double pitchMin = 0.0;
            double pitchMax = 0.0;
            Object deck = null;
            Object[] decks = null;
            if (modeControl != null) {
                mode = modeControl.getValue();
            }
            if (factorControl != null) {
                pitchMin = factorControl.getMinimum();
                pitchMax = factorControl.getMaximum();
            }
            if (bpmControl != null) {
                bpm = bpmControl.getDouble();
            }
            if (deckControl != null) {
                deck = deckControl.getValue();
                decks = deckControl.getValues();
            }
            if ("BPM".equals(mode)) {
                this.rdbtnBpmSync.setSelected(true);
            } else if ("Deck".equals(mode)) {
                this.rdbtnDeckSync.setSelected(true);
            } else if ("Custom".equals(mode)) {
                this.rdbtnCustom.setSelected(true);
            } else {
                this.rdbtnNormal.setSelected(true);
            }
            String pitchRange = AbstractPitchFactorControl.formatPitchRange((double)pitchMin, (double)pitchMax);
            int rangeIndex = -1;
            this.comboBoxRange.removeAllItems();
            String[] ranges = this.pitchRanges;
            if (ranges != null) {
                for (int i = 0; i < ranges.length; ++i) {
                    String range = ranges[i];
                    if (pitchRange.equals(range)) {
                        rangeIndex = i;
                    }
                    this.comboBoxRange.addItem(range);
                }
            }
            if (rangeIndex < 0) {
                rangeIndex = this.comboBoxRange.getItemCount();
                this.comboBoxRange.addItem(pitchRange);
            }
            this.comboBoxRange.setSelectedIndex(rangeIndex);
            this.textFieldBPM.setText(String.valueOf(bpm));
            this.textFieldBPM.setCaretPosition(0);
            this.comboBoxDeck.removeAllItems();
            int selDeck = -1;
            if (decks != null) {
                for (int i = 0; i < decks.length; ++i) {
                    if (deck != null && deck.equals(decks[i])) {
                        selDeck = this.comboBoxDeck.getItemCount();
                    }
                    this.comboBoxDeck.addItem(decks[i]);
                }
            }
            if (selDeck < 0 && deck != null) {
                selDeck = this.comboBoxDeck.getItemCount();
                this.comboBoxDeck.addItem(deck);
            }
            if (selDeck >= 0) {
                this.comboBoxDeck.setSelectedIndex(selDeck);
            }
            this.checkEnable();
        }
        finally {
            this.refreshing = false;
        }
        this.refreshLabelSyncBpm(bpm);
    }

    protected void checkEnable() {
        this.textFieldControlPanel.setEnabled(this.rdbtnCustom.isSelected());
        this.faderControlPanel.setEnabled(this.rdbtnCustom.isSelected());
        this.comboBoxRange.setEnabled(this.rdbtnCustom.isSelected());
        this.textFieldBPM.setEnabled(this.rdbtnBpmSync.isSelected());
        this.lblBpm.setEnabled(this.rdbtnBpmSync.isSelected());
        this.lblLabelSync.setEnabled(this.rdbtnBpmSync.isSelected());
        this.comboBoxLabelSyncBpm.setEnabled(this.rdbtnBpmSync.isSelected());
        this.comboBoxDeck.setEnabled(this.rdbtnDeckSync.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyPitchMode() {
        this.checkEnable();
        PitchModeControl control = this.pitchModeControl;
        if (control == null) {
            return;
        }
        String newMode = this.rdbtnBpmSync.isSelected() ? "BPM" : (this.rdbtnDeckSync.isSelected() ? "Deck" : (this.rdbtnCustom.isSelected() ? "Custom" : "Normal"));
        try {
            this.refreshing = true;
            control.setValue((Object)newMode);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyRange() {
        block7: {
            PitchFactorControl control = this.pitchFactorControl;
            if (control == null) {
                return;
            }
            Object item = this.comboBoxRange.getSelectedItem();
            if (item == null) {
                return;
            }
            String value = String.valueOf(item);
            try {
                double[] range = AbstractPitchFactorControl.parsePitchRange((String)value);
                if (range == null) break block7;
                double pitchMin = range[0];
                double pitchMax = range[1];
                try {
                    this.refreshing = true;
                    control.setPitchRange(pitchMin, pitchMax);
                }
                finally {
                    this.refreshing = false;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyBPM() {
        PitchBpmControl control = this.pitchBpmControl;
        if (control == null) {
            return;
        }
        String s = this.textFieldBPM.getText();
        if (s != null && s.length() > 0) {
            s = s.trim();
            try {
                double value = Double.parseDouble(s);
                try {
                    this.refreshing = true;
                    control.setDouble(value);
                }
                finally {
                    this.refreshing = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.refreshLabelSyncBpm(control.getDouble());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyDeck() {
        PitchDeckControl control = this.pitchDeckControl;
        if (control == null) {
            return;
        }
        Object deckItem = this.comboBoxDeck.getSelectedItem();
        try {
            this.refreshing = true;
            control.setValue(deckItem);
        }
        finally {
            this.refreshing = false;
        }
    }

    public String[] getPitchRanges() {
        return this.pitchRanges;
    }

    public void setPitchRanges(String[] pitchRanges) {
        this.pitchRanges = pitchRanges;
        this.refresh();
    }

    protected JComboBox getComboBoxLabelSyncBpm() {
        return this.comboBoxLabelSyncBpm;
    }

    protected double getLabelSyncBpm(String title) {
        if (SYNC_BPM_TITLE_33.equals(title)) {
            return 33.333333333333336;
        }
        if (SYNC_BPM_TITLE_66.equals(title)) {
            return 66.66666666666667;
        }
        if (SYNC_BPM_TITLE_76.equals(title)) {
            return 76.19047619047619;
        }
        if (SYNC_BPM_TITLE_80.equals(title)) {
            return 80.0;
        }
        if (SYNC_BPM_TITLE_88.equals(title)) {
            return 88.88888888888889;
        }
        if (SYNC_BPM_TITLE_100.equals(title)) {
            return 100.0;
        }
        if (SYNC_BPM_TITLE_106.equals(title)) {
            return 106.66666666666667;
        }
        if (SYNC_BPM_TITLE_114.equals(title)) {
            return 114.28571428571429;
        }
        if (SYNC_BPM_TITLE_118.equals(title)) {
            return 118.51851851851852;
        }
        if (SYNC_BPM_TITLE_133.equals(title)) {
            return 133.33333333333334;
        }
        if (SYNC_BPM_TITLE_152.equals(title)) {
            return 152.38095238095238;
        }
        if (SYNC_BPM_TITLE_160.equals(title)) {
            return 160.0;
        }
        if (SYNC_BPM_TITLE_177.equals(title)) {
            return 177.77777777777777;
        }
        if (SYNC_BPM_TITLE_200.equals(title)) {
            return 200.0;
        }
        return 0.0;
    }

    protected String getLabelSyncTitle(double bpm) {
        if (bpm == 33.333333333333336) {
            return SYNC_BPM_TITLE_33;
        }
        if (bpm == 66.66666666666667) {
            return SYNC_BPM_TITLE_66;
        }
        if (bpm == 76.19047619047619) {
            return SYNC_BPM_TITLE_76;
        }
        if (bpm == 80.0) {
            return SYNC_BPM_TITLE_80;
        }
        if (bpm == 88.88888888888889) {
            return SYNC_BPM_TITLE_88;
        }
        if (bpm == 100.0) {
            return SYNC_BPM_TITLE_100;
        }
        if (bpm == 106.66666666666667) {
            return SYNC_BPM_TITLE_106;
        }
        if (bpm == 114.28571428571429) {
            return SYNC_BPM_TITLE_114;
        }
        if (bpm == 118.51851851851852) {
            return SYNC_BPM_TITLE_118;
        }
        if (bpm == 133.33333333333334) {
            return SYNC_BPM_TITLE_133;
        }
        if (bpm == 152.38095238095238) {
            return SYNC_BPM_TITLE_152;
        }
        if (bpm == 160.0) {
            return SYNC_BPM_TITLE_160;
        }
        if (bpm == 177.77777777777777) {
            return SYNC_BPM_TITLE_177;
        }
        if (bpm == 200.0) {
            return SYNC_BPM_TITLE_200;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshLabelSyncBpm(double bpm) {
        try {
            this.refreshing = true;
            String labelSyncTitle = this.getLabelSyncTitle(bpm);
            if (labelSyncTitle != null) {
                this.comboBoxLabelSyncBpm.setSelectedItem(labelSyncTitle);
            } else {
                this.comboBoxLabelSyncBpm.setSelectedIndex(-1);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void applyLabelSyncBpm() {
        Object item = this.comboBoxLabelSyncBpm.getSelectedItem();
        if (item == null) {
            return;
        }
        String title = String.valueOf(item);
        double bpm = this.getLabelSyncBpm(title);
        if (bpm > 0.0) {
            this.textFieldBPM.setText(String.valueOf(bpm));
            this.textFieldBPM.setCaretPosition(0);
        }
    }

    public PitchModeControl getPitchModeControl() {
        return this.pitchModeControl;
    }

    public synchronized void setPitchModeControl(PitchModeControl pitchModeControl) {
        if (this.pitchModeControl == pitchModeControl) {
            return;
        }
        if (this.pitchModeControl != null) {
            this.pitchModeControl.removeControlListener((ControlListener)this.controlHandler);
        }
        this.pitchModeControl = pitchModeControl;
        if (pitchModeControl != null) {
            pitchModeControl.addControlListener((ControlListener)this.controlHandler);
        }
        this.refresh();
    }

    public PitchFactorControl getPitchFactorControl() {
        return this.pitchFactorControl;
    }

    public synchronized void setPitchFactorControl(PitchFactorControl pitchFactorControl) {
        if (this.pitchFactorControl == pitchFactorControl) {
            return;
        }
        if (this.pitchFactorControl != null) {
            this.pitchFactorControl.removeControlListener((ControlListener)this.controlHandler);
        }
        this.pitchFactorControl = pitchFactorControl;
        if (pitchFactorControl != null) {
            pitchFactorControl.addControlListener((ControlListener)this.controlHandler);
        }
        this.faderControlPanel.setControl((Control)pitchFactorControl);
        this.textFieldControlPanel.setControl((Control)pitchFactorControl);
        this.refresh();
    }

    public PitchBpmControl getPitchBpmControl() {
        return this.pitchBpmControl;
    }

    public synchronized void setPitchBpmControl(PitchBpmControl pitchBpmControl) {
        if (this.pitchBpmControl == pitchBpmControl) {
            return;
        }
        if (this.pitchBpmControl != null) {
            this.pitchBpmControl.removeControlListener((ControlListener)this.controlHandler);
        }
        this.pitchBpmControl = pitchBpmControl;
        if (pitchBpmControl != null) {
            pitchBpmControl.addControlListener((ControlListener)this.controlHandler);
        }
        this.refresh();
    }

    public PitchDeckControl getPitchDeckControl() {
        return this.pitchDeckControl;
    }

    public synchronized void setPitchDeckControl(PitchDeckControl pitchDeckControl) {
        if (this.pitchDeckControl == pitchDeckControl) {
            return;
        }
        if (this.pitchDeckControl != null) {
            this.pitchDeckControl.removeControlListener((ControlListener)this.controlHandler);
        }
        this.pitchDeckControl = pitchDeckControl;
        if (pitchDeckControl != null) {
            pitchDeckControl.addControlListener((ControlListener)this.controlHandler);
        }
        this.refresh();
    }

    protected JLabel getLblLabelSync() {
        return this.lblLabelSync;
    }

    protected JLabel getLblBpm() {
        return this.lblBpm;
    }

    protected class LineListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8937568306209705319L;

        protected LineListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof Line) {
                Line line = (Line)value;
                String name = line.getName();
                this.setText(String.valueOf(name));
            }
            return result;
        }
    }

    protected class ControlHandler
    implements ControlListener {
        protected ControlHandler() {
        }

        public void controlChanged(Control control) {
            if (!PitchControlPanel.this.refreshing) {
                PitchControlPanel.this.refresh();
            }
        }
    }
}

