/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.model.LineUtil;
import com.waxmonster.view.AbstractView;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;

public class RulerView
extends AbstractView {
    private int orientation;
    private Paint backPaint = Color.LIGHT_GRAY;
    private Color borderColor = Color.GRAY;
    private double minorTickSize = 20.0;
    private double majorTickSize = 100.0;
    private Color minorTickColor = Color.GRAY;
    private Color majorTickColor = Color.DARK_GRAY;
    private double zoomRate;
    private Color labelColor = Color.DARK_GRAY;
    private boolean labelPainted;
    private Font font;

    public void flush() {
    }

    public void paint(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        int cx = clip.x;
        int cy = clip.y;
        int cw = clip.width;
        int ch = clip.height;
        if (this.backPaint != null) {
            g.setPaint(this.backPaint);
            g.fillRect(cx, cy, cw, ch);
        }
        switch (this.orientation) {
            case 0: {
                int pos;
                double nextPos;
                int endPos = cx + cw;
                int y0 = this.bounds.height / 2;
                int y1 = this.bounds.height * 3 / 4;
                int y2 = this.bounds.height - 1;
                if (this.borderColor != null) {
                    g.setColor(this.borderColor);
                    g.drawLine(cx, 0, endPos, 0);
                    g.drawLine(cx, y2, endPos, y2);
                }
                g.setColor(this.minorTickColor);
                for (nextPos = (double)cx - (double)cx % this.minorTickSize; nextPos < (double)endPos; nextPos += this.minorTickSize) {
                    pos = (int)Math.round(nextPos);
                    g.drawLine(pos, y1, pos, y2);
                }
                g.setColor(this.majorTickColor);
                for (nextPos = (double)cx - (double)cx % this.majorTickSize; nextPos < (double)endPos; nextPos += this.majorTickSize) {
                    pos = (int)Math.round(nextPos);
                    g.drawLine(pos, y0, pos, y2);
                }
                if (!this.labelPainted) break;
                g.setColor(this.labelColor);
                g.setFont(this.font);
                int y3 = y1 / 2 + g.getFontMetrics().getAscent() / 2 - 1;
                for (nextPos = (double)cx - (double)cx % this.majorTickSize; nextPos < (double)endPos; nextPos += this.majorTickSize) {
                    long lineOfs = LineUtil.getNanoOfs((double)nextPos, (double)this.zoomRate);
                    String s = this.getLabelText(lineOfs);
                    pos = (int)Math.round(nextPos);
                    g.drawString(s, pos + 1, y3);
                }
                break;
            }
            case 2: {
                int pos;
                double nextPos;
                int endPos = cy + ch;
                int x0 = this.bounds.width / 2;
                int x1 = this.bounds.width * 3 / 4;
                int x2 = this.bounds.width - 1;
                if (this.borderColor != null) {
                    g.setColor(this.borderColor);
                    g.drawLine(0, cy, 0, endPos);
                    g.drawLine(x2, cy, x2, endPos);
                }
                g.setColor(this.minorTickColor);
                for (nextPos = (double)cy - (double)cy % this.minorTickSize; nextPos < (double)endPos; nextPos += this.minorTickSize) {
                    pos = (int)Math.round(nextPos);
                    g.drawLine(x1, pos, x2, pos);
                }
                g.setColor(this.majorTickColor);
                for (nextPos = (double)cy - (double)cy % this.majorTickSize; nextPos < (double)endPos; nextPos += this.majorTickSize) {
                    pos = (int)Math.round(nextPos);
                    g.drawLine(x0, pos, x2, pos);
                }
                if (!this.labelPainted) break;
                g.setColor(this.labelColor);
                g.setFont(this.font);
                FontMetrics fm = g.getFontMetrics();
                int x3 = x1 / 2 + fm.getAscent() / 2 - 1;
                double theta = -1.5707963267948966;
                g.rotate(theta);
                for (nextPos = (double)cy - (double)cy % this.majorTickSize; nextPos < (double)endPos; nextPos += this.majorTickSize) {
                    long lineOfs = LineUtil.getNanoOfs((double)nextPos, (double)this.zoomRate);
                    String s = this.getLabelText(lineOfs);
                    pos = (int)Math.round(nextPos);
                    g.drawString(s, -pos - fm.stringWidth(s) - 1, x3);
                }
                g.rotate(-theta);
                break;
            }
        }
    }

    public Paint getBackPaint() {
        return this.backPaint;
    }

    public void setBackPaint(Paint backPaint) {
        this.backPaint = backPaint;
    }

    public double getMinorTickSize() {
        return this.minorTickSize;
    }

    public void setMinorTickSize(double minorTickSize) {
        this.minorTickSize = minorTickSize;
    }

    public double getMajorTickSize() {
        return this.majorTickSize;
    }

    public void setMajorTickSize(double majorTickSize) {
        this.majorTickSize = majorTickSize;
    }

    public Color getMinorTickColor() {
        return this.minorTickColor;
    }

    public void setMinorTickColor(Color minorTickColor) {
        this.minorTickColor = minorTickColor;
    }

    public Color getMajorTickColor() {
        return this.majorTickColor;
    }

    public void setMajorTickColor(Color majorTickColor) {
        this.majorTickColor = majorTickColor;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public String getToolTipText(long x, long y) {
        long lineOfs2;
        switch (this.orientation) {
            case 0: {
                lineOfs2 = LineUtil.getNanoOfs((long)x, (double)this.zoomRate);
                break;
            }
            case 2: {
                long lineOfs2 = LineUtil.getNanoOfs((long)y, (double)this.zoomRate);
            }
            default: {
                return null;
            }
        }
        return this.getToolTipText(lineOfs2);
    }

    public String getToolTipText(long lineOfs) {
        long v = lineOfs / 1000000L;
        int millis = (int)(v % 1000L);
        int secs = (int)((v /= 1000L) % 60L);
        long mins = v / 60L;
        StringBuffer sb = new StringBuffer();
        sb.append(mins);
        sb.append(':');
        sb.append(String.valueOf(100 + secs).substring(1));
        sb.append('.');
        sb.append(String.valueOf(1000 + millis).substring(1));
        return sb.toString();
    }

    public String getLabelText(long lineOfs) {
        long v = lineOfs / 1000000L;
        int millis = (int)(v % 1000L);
        int secs = (int)((v /= 1000L) % 60L);
        long mins = v / 60L;
        StringBuffer sb = new StringBuffer();
        sb.append(mins);
        sb.append(':');
        sb.append(String.valueOf(100 + secs).substring(1));
        if (millis > 0) {
            sb.append('.');
            sb.append(String.valueOf(1000 + millis).substring(1));
        }
        return sb.toString();
    }

    public double getZoomRate() {
        return this.zoomRate;
    }

    public void setZoomRate(double zoomRate) {
        this.zoomRate = zoomRate;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public boolean isLabelPainted() {
        return this.labelPainted;
    }

    public void setLabelPainted(boolean labelPainted) {
        this.labelPainted = labelPainted;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }
}

