/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.editor.impl.WaxMonsterFaderMoveInterpreterConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ScratchAnalyzerPanel
extends JPanel {
    private static final long serialVersionUID = 2611124764887945179L;
    private static final String ITEM_OFF_CLICKS_FIRST = "Off-Clicks First";
    private static final String ITEM_ON_CLICKS_FIRST = "On-Clicks First";
    private static final String ITEM_OFF_CLICKS_ONLY = "Off-Clicks Only";
    private static final String ITEM_ON_CLICKS_ONLY = "On-Clicks Only";
    private static final String ITEM_NONE_CLICKS = "None";
    private double maxTimecodePoints = 50.0;
    private double maxTimecodeErrorRate = 2.0;
    private boolean faderEnabled = true;
    private boolean faderSelected = true;
    private String faderInfoText;
    private Icon faderInfoIcon;
    private double maxFaderPoints = 50.0;
    private double maxFaderErrorRate = 0.5;
    private boolean faderInterSelected = true;
    private WaxMonsterFaderMoveInterpreterConfig faderMoveInterpreterConfig;
    private boolean refreshing;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JComboBox jComboBoxTimecodePoints = null;
    private JComboBox jComboBoxTimecodeError = null;
    private JPanel panelFaderAnalyzer;
    private JPanel panelTimecode;
    private JLabel lblFaderPoints;
    private JLabel lblFaderError;
    private JComboBox comboBoxFaderPoints;
    private JComboBox comboBoxFaderError;
    private JLabel lblFaderPercent;
    private JLabel lblMillis;
    private JLabel lblNewLabel;
    private JLabel lblFaderMaxPoints;
    private JCheckBox chckbxAnalyzeFader;
    private JLabel lblFaderInfo;
    private JComboBox comboBoxDetectFaderClicks;
    private JPanel panelFaderInterpreter;
    private JLabel lblSimplifyTolerance;
    private JCheckBox chckbxFaderInterpreter;
    private JLabel lblFaderClickDetection;
    private JComboBox comboBoxFaderSimplifyTolerance;
    private JLabel lblFaderSimpUnit;

    public ScratchAnalyzerPanel() {
        this.initialize();
        this.initScratchAnalyzerPanel();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(456, 416));
        this.panelTimecode = new JPanel();
        this.panelTimecode.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Scratch Analyzer", 4, 2, null, null));
        GridBagConstraints gbc_panelTimecode = new GridBagConstraints();
        gbc_panelTimecode.insets = new Insets(4, 4, 5, 4);
        gbc_panelTimecode.weightx = 1.0;
        gbc_panelTimecode.fill = 1;
        gbc_panelTimecode.gridx = 0;
        gbc_panelTimecode.gridy = 0;
        this.add((Component)this.panelTimecode, gbc_panelTimecode);
        GridBagLayout gbl_panelTimecode = new GridBagLayout();
        gbl_panelTimecode.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelTimecode.rowHeights = new int[]{0, 0, 0};
        gbl_panelTimecode.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelTimecode.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panelTimecode.setLayout(gbl_panelTimecode);
        this.jLabel1 = new JLabel();
        GridBagConstraints gbc_jLabel1 = new GridBagConstraints();
        gbc_jLabel1.anchor = 17;
        gbc_jLabel1.insets = new Insets(4, 4, 4, 5);
        gbc_jLabel1.gridx = 0;
        gbc_jLabel1.gridy = 0;
        this.panelTimecode.add((Component)this.jLabel1, gbc_jLabel1);
        this.jLabel1.setText("Target Precision:");
        GridBagConstraints gbc_jComboBoxTimecodeError = new GridBagConstraints();
        gbc_jComboBoxTimecodeError.insets = new Insets(4, 4, 4, 5);
        gbc_jComboBoxTimecodeError.gridx = 1;
        gbc_jComboBoxTimecodeError.gridy = 0;
        this.panelTimecode.add((Component)this.getJComboBoxTimecodeError(), gbc_jComboBoxTimecodeError);
        this.lblMillis = new JLabel("Milliseconds");
        GridBagConstraints gbc_lblMillis = new GridBagConstraints();
        gbc_lblMillis.insets = new Insets(0, 4, 0, 0);
        gbc_lblMillis.anchor = 17;
        gbc_lblMillis.gridx = 2;
        gbc_lblMillis.gridy = 0;
        this.panelTimecode.add((Component)this.lblMillis, gbc_lblMillis);
        this.jLabel = new JLabel();
        GridBagConstraints gbc_jLabel = new GridBagConstraints();
        gbc_jLabel.anchor = 17;
        gbc_jLabel.insets = new Insets(4, 4, 4, 5);
        gbc_jLabel.gridx = 0;
        gbc_jLabel.gridy = 1;
        this.panelTimecode.add((Component)this.jLabel, gbc_jLabel);
        this.jLabel.setText("Interpolation Limit:");
        GridBagConstraints gbc_jComboBoxTimecodePoints = new GridBagConstraints();
        gbc_jComboBoxTimecodePoints.insets = new Insets(4, 4, 4, 5);
        gbc_jComboBoxTimecodePoints.gridx = 1;
        gbc_jComboBoxTimecodePoints.gridy = 1;
        this.panelTimecode.add((Component)this.getJComboBoxTimecodePoints(), gbc_jComboBoxTimecodePoints);
        this.lblNewLabel = new JLabel("Average points / second");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.weightx = 1.0;
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 4, 0, 4);
        gbc_lblNewLabel.gridx = 2;
        gbc_lblNewLabel.gridy = 1;
        this.panelTimecode.add((Component)this.lblNewLabel, gbc_lblNewLabel);
        this.panelFaderAnalyzer = new JPanel();
        this.panelFaderAnalyzer.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Fader Analyzer", 4, 2, null, null));
        GridBagConstraints gbc_panelFaderAnalyzer = new GridBagConstraints();
        gbc_panelFaderAnalyzer.insets = new Insets(4, 4, 5, 4);
        gbc_panelFaderAnalyzer.fill = 1;
        gbc_panelFaderAnalyzer.gridx = 0;
        gbc_panelFaderAnalyzer.gridy = 1;
        this.add((Component)this.panelFaderAnalyzer, gbc_panelFaderAnalyzer);
        GridBagLayout gbl_panelFaderAnalyzer = new GridBagLayout();
        gbl_panelFaderAnalyzer.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelFaderAnalyzer.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panelFaderAnalyzer.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelFaderAnalyzer.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.panelFaderAnalyzer.setLayout(gbl_panelFaderAnalyzer);
        this.chckbxAnalyzeFader = new JCheckBox("Enable");
        this.chckbxAnalyzeFader.setToolTipText("Analyze fader movement (optional)");
        this.chckbxAnalyzeFader.setOpaque(false);
        this.chckbxAnalyzeFader.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ScratchAnalyzerPanel.this.refreshing) {
                    ScratchAnalyzerPanel.this.chckbxFaderInterpreter.setSelected(ScratchAnalyzerPanel.this.chckbxAnalyzeFader.isSelected() && ScratchAnalyzerPanel.this.faderInterSelected);
                    ScratchAnalyzerPanel.this.apply();
                    ScratchAnalyzerPanel.this.checkEnable();
                }
            }
        });
        GridBagConstraints gbc_chckbxAnalyzeFader = new GridBagConstraints();
        gbc_chckbxAnalyzeFader.anchor = 17;
        gbc_chckbxAnalyzeFader.insets = new Insets(4, 0, 5, 5);
        gbc_chckbxAnalyzeFader.gridx = 0;
        gbc_chckbxAnalyzeFader.gridy = 0;
        this.panelFaderAnalyzer.add((Component)this.chckbxAnalyzeFader, gbc_chckbxAnalyzeFader);
        this.lblFaderInfo = new JLabel("Info");
        GridBagConstraints gbc_lblFaderInfo = new GridBagConstraints();
        gbc_lblFaderInfo.gridwidth = 2;
        gbc_lblFaderInfo.fill = 1;
        gbc_lblFaderInfo.anchor = 17;
        gbc_lblFaderInfo.insets = new Insets(4, 4, 5, 4);
        gbc_lblFaderInfo.gridx = 1;
        gbc_lblFaderInfo.gridy = 0;
        this.panelFaderAnalyzer.add((Component)this.lblFaderInfo, gbc_lblFaderInfo);
        this.lblFaderError = new JLabel("Target Precision:");
        GridBagConstraints gbc_lblFaderError = new GridBagConstraints();
        gbc_lblFaderError.insets = new Insets(4, 4, 5, 5);
        gbc_lblFaderError.anchor = 17;
        gbc_lblFaderError.gridx = 0;
        gbc_lblFaderError.gridy = 1;
        this.panelFaderAnalyzer.add((Component)this.lblFaderError, gbc_lblFaderError);
        this.comboBoxFaderError = new JComboBox();
        this.comboBoxFaderError.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ScratchAnalyzerPanel.this.refreshing) {
                    ScratchAnalyzerPanel.this.apply();
                }
            }
        });
        this.comboBoxFaderError.setToolTipText("Maximum target error rate in percent (lower is more precise)");
        this.comboBoxFaderError.setOpaque(false);
        this.comboBoxFaderError.setEditable(true);
        GridBagConstraints gbc_comboBoxFaderError = new GridBagConstraints();
        gbc_comboBoxFaderError.insets = new Insets(4, 4, 5, 5);
        gbc_comboBoxFaderError.fill = 2;
        gbc_comboBoxFaderError.gridx = 1;
        gbc_comboBoxFaderError.gridy = 1;
        this.panelFaderAnalyzer.add((Component)this.comboBoxFaderError, gbc_comboBoxFaderError);
        this.lblFaderPercent = new JLabel("Percent %");
        GridBagConstraints gbc_lblFaderPercent = new GridBagConstraints();
        gbc_lblFaderPercent.insets = new Insets(0, 4, 5, 0);
        gbc_lblFaderPercent.anchor = 17;
        gbc_lblFaderPercent.gridx = 2;
        gbc_lblFaderPercent.gridy = 1;
        this.panelFaderAnalyzer.add((Component)this.lblFaderPercent, gbc_lblFaderPercent);
        this.lblFaderPoints = new JLabel("Interpolation Limit:");
        GridBagConstraints gbc_lblFaderPoints = new GridBagConstraints();
        gbc_lblFaderPoints.anchor = 17;
        gbc_lblFaderPoints.insets = new Insets(4, 4, 5, 5);
        gbc_lblFaderPoints.gridx = 0;
        gbc_lblFaderPoints.gridy = 2;
        this.panelFaderAnalyzer.add((Component)this.lblFaderPoints, gbc_lblFaderPoints);
        this.comboBoxFaderPoints = new JComboBox();
        this.comboBoxFaderPoints.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ScratchAnalyzerPanel.this.refreshing) {
                    ScratchAnalyzerPanel.this.apply();
                }
            }
        });
        this.comboBoxFaderPoints.setToolTipText("Max. average number of points per second (higher is more precise)");
        this.comboBoxFaderPoints.setOpaque(false);
        this.comboBoxFaderPoints.setEditable(true);
        GridBagConstraints gbc_comboBoxFaderPoints = new GridBagConstraints();
        gbc_comboBoxFaderPoints.insets = new Insets(4, 4, 5, 5);
        gbc_comboBoxFaderPoints.fill = 2;
        gbc_comboBoxFaderPoints.gridx = 1;
        gbc_comboBoxFaderPoints.gridy = 2;
        this.panelFaderAnalyzer.add((Component)this.comboBoxFaderPoints, gbc_comboBoxFaderPoints);
        this.lblFaderMaxPoints = new JLabel("Average points / second");
        GridBagConstraints gbc_lblFaderMaxPoints = new GridBagConstraints();
        gbc_lblFaderMaxPoints.weightx = 1.0;
        gbc_lblFaderMaxPoints.anchor = 17;
        gbc_lblFaderMaxPoints.insets = new Insets(0, 4, 5, 4);
        gbc_lblFaderMaxPoints.gridx = 2;
        gbc_lblFaderMaxPoints.gridy = 2;
        this.panelFaderAnalyzer.add((Component)this.lblFaderMaxPoints, gbc_lblFaderMaxPoints);
        this.panelFaderInterpreter = new JPanel();
        this.panelFaderInterpreter.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Fader Interpreter", 4, 2, null, null));
        GridBagConstraints gbc_panelFaderInterpreter = new GridBagConstraints();
        gbc_panelFaderInterpreter.insets = new Insets(4, 4, 5, 4);
        gbc_panelFaderInterpreter.fill = 1;
        gbc_panelFaderInterpreter.gridx = 0;
        gbc_panelFaderInterpreter.gridy = 2;
        this.add((Component)this.panelFaderInterpreter, gbc_panelFaderInterpreter);
        GridBagLayout gbl_panelFaderInterpreter = new GridBagLayout();
        gbl_panelFaderInterpreter.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelFaderInterpreter.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelFaderInterpreter.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panelFaderInterpreter.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panelFaderInterpreter.setLayout(gbl_panelFaderInterpreter);
        this.chckbxFaderInterpreter = new JCheckBox("Enable");
        this.chckbxFaderInterpreter.setToolTipText("Interpret fader moves (optional)");
        this.chckbxFaderInterpreter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ScratchAnalyzerPanel.this.refreshing) {
                    ScratchAnalyzerPanel.this.apply();
                    ScratchAnalyzerPanel.this.checkEnable();
                }
            }
        });
        GridBagConstraints gbc_chckbxFaderInterpreter = new GridBagConstraints();
        gbc_chckbxFaderInterpreter.anchor = 17;
        gbc_chckbxFaderInterpreter.insets = new Insets(4, 0, 5, 5);
        gbc_chckbxFaderInterpreter.gridx = 0;
        gbc_chckbxFaderInterpreter.gridy = 0;
        this.panelFaderInterpreter.add((Component)this.chckbxFaderInterpreter, gbc_chckbxFaderInterpreter);
        this.lblSimplifyTolerance = new JLabel("Linear-Fade Tolerance:");
        GridBagConstraints gbc_lblSimplifyTolerance = new GridBagConstraints();
        gbc_lblSimplifyTolerance.anchor = 13;
        gbc_lblSimplifyTolerance.insets = new Insets(4, 4, 5, 5);
        gbc_lblSimplifyTolerance.gridx = 0;
        gbc_lblSimplifyTolerance.gridy = 1;
        this.panelFaderInterpreter.add((Component)this.lblSimplifyTolerance, gbc_lblSimplifyTolerance);
        this.comboBoxDetectFaderClicks = new JComboBox();
        this.comboBoxDetectFaderClicks.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ScratchAnalyzerPanel.this.refreshing) {
                    ScratchAnalyzerPanel.this.apply();
                }
            }
        });
        this.comboBoxFaderSimplifyTolerance = new JComboBox();
        this.comboBoxFaderSimplifyTolerance.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ScratchAnalyzerPanel.this.refreshing) {
                    ScratchAnalyzerPanel.this.apply();
                }
            }
        });
        this.comboBoxFaderSimplifyTolerance.setOpaque(false);
        this.comboBoxFaderSimplifyTolerance.setEditable(true);
        GridBagConstraints gbc_comboBoxFaderSimplifyTolerance = new GridBagConstraints();
        gbc_comboBoxFaderSimplifyTolerance.fill = 2;
        gbc_comboBoxFaderSimplifyTolerance.anchor = 17;
        gbc_comboBoxFaderSimplifyTolerance.insets = new Insets(4, 4, 5, 5);
        gbc_comboBoxFaderSimplifyTolerance.gridx = 1;
        gbc_comboBoxFaderSimplifyTolerance.gridy = 1;
        this.panelFaderInterpreter.add((Component)this.comboBoxFaderSimplifyTolerance, gbc_comboBoxFaderSimplifyTolerance);
        this.lblFaderSimpUnit = new JLabel("Percent %");
        GridBagConstraints gbc_lblFaderSimpUnit = new GridBagConstraints();
        gbc_lblFaderSimpUnit.anchor = 17;
        gbc_lblFaderSimpUnit.weightx = 1.0;
        gbc_lblFaderSimpUnit.insets = new Insets(4, 4, 5, 0);
        gbc_lblFaderSimpUnit.gridx = 2;
        gbc_lblFaderSimpUnit.gridy = 1;
        this.panelFaderInterpreter.add((Component)this.lblFaderSimpUnit, gbc_lblFaderSimpUnit);
        this.lblFaderClickDetection = new JLabel("Fader-Click Detection:");
        GridBagConstraints gbc_lblFaderClickDetection = new GridBagConstraints();
        gbc_lblFaderClickDetection.insets = new Insets(4, 4, 4, 5);
        gbc_lblFaderClickDetection.anchor = 17;
        gbc_lblFaderClickDetection.gridx = 0;
        gbc_lblFaderClickDetection.gridy = 2;
        this.panelFaderInterpreter.add((Component)this.lblFaderClickDetection, gbc_lblFaderClickDetection);
        GridBagConstraints gbc_comboBoxDetectFaderClicks = new GridBagConstraints();
        gbc_comboBoxDetectFaderClicks.gridwidth = 2;
        gbc_comboBoxDetectFaderClicks.anchor = 17;
        gbc_comboBoxDetectFaderClicks.insets = new Insets(4, 4, 4, 5);
        gbc_comboBoxDetectFaderClicks.gridx = 1;
        gbc_comboBoxDetectFaderClicks.gridy = 2;
        this.panelFaderInterpreter.add((Component)this.comboBoxDetectFaderClicks, gbc_comboBoxDetectFaderClicks);
        this.comboBoxDetectFaderClicks.setOpaque(false);
    }

    private JComboBox getJComboBoxTimecodePoints() {
        if (this.jComboBoxTimecodePoints == null) {
            this.jComboBoxTimecodePoints = new JComboBox();
            this.jComboBoxTimecodePoints.setOpaque(false);
            this.jComboBoxTimecodePoints.setToolTipText("Max. average number of points per second (higher is more precise)");
            this.jComboBoxTimecodePoints.setEditable(true);
            this.jComboBoxTimecodePoints.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!ScratchAnalyzerPanel.this.refreshing) {
                        ScratchAnalyzerPanel.this.apply();
                    }
                }
            });
        }
        return this.jComboBoxTimecodePoints;
    }

    private JComboBox getJComboBoxTimecodeError() {
        if (this.jComboBoxTimecodeError == null) {
            this.jComboBoxTimecodeError = new JComboBox();
            this.jComboBoxTimecodeError.setOpaque(false);
            this.jComboBoxTimecodeError.setToolTipText("Maximum target error rate in milliseconds (lower is more precise)");
            this.jComboBoxTimecodeError.setEditable(true);
            this.jComboBoxTimecodeError.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!ScratchAnalyzerPanel.this.refreshing) {
                        ScratchAnalyzerPanel.this.apply();
                    }
                }
            });
        }
        return this.jComboBoxTimecodeError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initScratchAnalyzerPanel() {
        this.faderMoveInterpreterConfig = new WaxMonsterFaderMoveInterpreterConfig();
        try {
            this.refreshing = true;
            this.jComboBoxTimecodePoints.removeAllItems();
            this.jComboBoxTimecodePoints.addItem("10");
            this.jComboBoxTimecodePoints.addItem("25");
            this.jComboBoxTimecodePoints.addItem("50");
            this.jComboBoxTimecodePoints.addItem("75");
            this.jComboBoxTimecodePoints.addItem("100");
            this.jComboBoxTimecodeError.removeAllItems();
            this.jComboBoxTimecodeError.addItem("10.0");
            this.jComboBoxTimecodeError.addItem("5.0");
            this.jComboBoxTimecodeError.addItem("2.0");
            this.jComboBoxTimecodeError.addItem("1.0");
            this.jComboBoxTimecodeError.addItem("0.5");
            this.comboBoxFaderPoints.removeAllItems();
            this.comboBoxFaderPoints.addItem("10");
            this.comboBoxFaderPoints.addItem("25");
            this.comboBoxFaderPoints.addItem("50");
            this.comboBoxFaderPoints.addItem("75");
            this.comboBoxFaderPoints.addItem("100");
            this.comboBoxFaderError.removeAllItems();
            this.comboBoxFaderError.addItem("2.0");
            this.comboBoxFaderError.addItem("1.0");
            this.comboBoxFaderError.addItem("0.5");
            this.comboBoxFaderError.addItem("0.2");
            this.comboBoxFaderError.addItem("0.1");
            this.comboBoxFaderSimplifyTolerance.removeAllItems();
            this.comboBoxFaderSimplifyTolerance.addItem("2.0");
            this.comboBoxFaderSimplifyTolerance.addItem("1.0");
            this.comboBoxFaderSimplifyTolerance.addItem("0.5");
            this.comboBoxFaderSimplifyTolerance.addItem("0.2");
            this.comboBoxFaderSimplifyTolerance.addItem("0.1");
        }
        finally {
            this.refreshing = false;
        }
        this.refresh();
    }

    protected void checkEnable() {
        this.panelFaderAnalyzer.setEnabled(this.faderEnabled);
        this.chckbxAnalyzeFader.setEnabled(this.faderEnabled);
        this.lblFaderPoints.setEnabled(this.faderSelected);
        this.comboBoxFaderPoints.setEnabled(this.faderSelected);
        this.lblFaderMaxPoints.setEnabled(this.faderSelected);
        this.lblFaderError.setEnabled(this.faderSelected);
        this.comboBoxFaderError.setEnabled(this.faderSelected);
        this.lblFaderPercent.setEnabled(this.faderSelected);
        this.panelFaderInterpreter.setEnabled(this.faderSelected);
        this.chckbxFaderInterpreter.setEnabled(this.faderSelected);
        boolean faderInter = this.faderSelected && this.faderInterSelected;
        this.lblSimplifyTolerance.setEnabled(faderInter);
        this.comboBoxFaderSimplifyTolerance.setEnabled(faderInter);
        this.lblFaderClickDetection.setEnabled(faderInter);
        this.comboBoxDetectFaderClicks.setEnabled(faderInter);
        this.lblFaderSimpUnit.setEnabled(faderInter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            this.setComboDouble(this.jComboBoxTimecodePoints, this.maxTimecodePoints);
            this.setComboDouble(this.jComboBoxTimecodeError, this.maxTimecodeErrorRate);
            this.setComboDouble(this.comboBoxFaderPoints, this.maxFaderPoints);
            this.setComboDouble(this.comboBoxFaderError, this.maxFaderErrorRate);
            this.chckbxAnalyzeFader.setSelected(this.faderSelected && this.faderEnabled);
            this.chckbxFaderInterpreter.setSelected(this.faderInterSelected && this.faderSelected && this.faderEnabled);
            double faderSimplifyPercent = this.faderMoveInterpreterConfig.getSimplifyTolerance() * 100.0;
            this.setComboDouble(this.comboBoxFaderSimplifyTolerance, faderSimplifyPercent);
            this.comboBoxDetectFaderClicks.removeAllItems();
            this.comboBoxDetectFaderClicks.addItem(ITEM_OFF_CLICKS_FIRST);
            this.comboBoxDetectFaderClicks.addItem(ITEM_ON_CLICKS_FIRST);
            this.comboBoxDetectFaderClicks.addItem(ITEM_OFF_CLICKS_ONLY);
            this.comboBoxDetectFaderClicks.addItem(ITEM_ON_CLICKS_ONLY);
            this.comboBoxDetectFaderClicks.addItem(ITEM_NONE_CLICKS);
            String clickItem = ITEM_NONE_CLICKS;
            if (this.faderMoveInterpreterConfig.isDetectFaderOffClicks()) {
                clickItem = this.faderMoveInterpreterConfig.isDetectFaderOnClicks() ? (this.faderMoveInterpreterConfig.isDetectFaderOffClicksFirst() ? ITEM_OFF_CLICKS_FIRST : ITEM_ON_CLICKS_FIRST) : ITEM_OFF_CLICKS_ONLY;
            } else if (this.faderMoveInterpreterConfig.isDetectFaderOnClicks()) {
                clickItem = ITEM_ON_CLICKS_ONLY;
            }
            this.comboBoxDetectFaderClicks.setSelectedItem(clickItem);
            this.checkEnable();
        }
        finally {
            this.refreshing = false;
        }
    }

    private void setComboDouble(JComboBox box, double value) {
        int num = box.getItemCount();
        for (int i = 0; i < num; ++i) {
            String s = String.valueOf(box.getItemAt(i));
            try {
                double v = Double.parseDouble(s.trim());
                if (v != value) continue;
                box.setSelectedIndex(i);
                return;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        box.addItem(String.valueOf(value));
        box.setSelectedIndex(num);
    }

    protected void apply() {
        String s;
        try {
            s = String.valueOf(this.getJComboBoxTimecodePoints().getSelectedItem());
            this.maxTimecodePoints = Double.parseDouble(s.trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            s = String.valueOf(this.getJComboBoxTimecodeError().getSelectedItem());
            this.maxTimecodeErrorRate = Double.parseDouble(s.trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.faderSelected = this.chckbxAnalyzeFader.isSelected();
        try {
            s = String.valueOf(this.getComboBoxFaderPoints().getSelectedItem());
            this.maxFaderPoints = Double.parseDouble(s.trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            s = String.valueOf(this.getComboBoxFaderError().getSelectedItem());
            this.maxFaderErrorRate = Double.parseDouble(s.trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.faderSelected) {
            this.faderInterSelected = this.chckbxFaderInterpreter.isSelected();
        }
        try {
            s = String.valueOf(this.comboBoxFaderSimplifyTolerance.getSelectedItem());
            double simplifyPercent = Double.parseDouble(s.trim());
            double simplifyTolerance = simplifyPercent / 100.0;
            this.faderMoveInterpreterConfig.setSimplifyTolerance(simplifyTolerance);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        Object clickItem = this.comboBoxDetectFaderClicks.getSelectedItem();
        if (clickItem != null) {
            boolean detectOnClicks = false;
            boolean detectOffClicks = false;
            boolean detectOffFirst = false;
            if (clickItem == ITEM_OFF_CLICKS_FIRST) {
                detectOnClicks = true;
                detectOffClicks = true;
                detectOffFirst = true;
            } else if (clickItem == ITEM_ON_CLICKS_FIRST) {
                detectOnClicks = true;
                detectOffClicks = true;
            } else if (clickItem == ITEM_OFF_CLICKS_ONLY) {
                detectOffClicks = true;
            } else if (clickItem == ITEM_ON_CLICKS_ONLY) {
                detectOnClicks = true;
            }
            this.faderMoveInterpreterConfig.setDetectFaderOnClicks(detectOnClicks);
            this.faderMoveInterpreterConfig.setDetectFaderOffClicks(detectOffClicks);
            this.faderMoveInterpreterConfig.setDetectFaderOffClicksFirst(detectOffFirst);
        }
    }

    protected JPanel getPanelFader() {
        return this.panelFaderAnalyzer;
    }

    protected JPanel getPanelTimecode() {
        return this.panelTimecode;
    }

    protected JLabel getLblFaderPoints() {
        return this.lblFaderPoints;
    }

    protected JLabel getLblFaderError() {
        return this.lblFaderError;
    }

    protected JComboBox getComboBoxFaderPoints() {
        return this.comboBoxFaderPoints;
    }

    protected JComboBox getComboBoxFaderError() {
        return this.comboBoxFaderError;
    }

    protected JLabel getLblFaderPercent() {
        return this.lblFaderPercent;
    }

    public double getMaxTimecodePoints() {
        return this.maxTimecodePoints;
    }

    public void setMaxTimecodePoints(double maxTimecodePoints) {
        this.maxTimecodePoints = maxTimecodePoints;
        this.refresh();
    }

    public double getMaxTimecodeErrorRate() {
        return this.maxTimecodeErrorRate;
    }

    public void setMaxTimecodeErrorRate(double maxTimecodeErrorRate) {
        this.maxTimecodeErrorRate = maxTimecodeErrorRate;
        this.refresh();
    }

    public double getMaxFaderPoints() {
        return this.maxFaderPoints;
    }

    public void setMaxFaderPoints(double maxFaderPoints) {
        this.maxFaderPoints = maxFaderPoints;
        this.refresh();
    }

    public double getMaxFaderErrorRate() {
        return this.maxFaderErrorRate;
    }

    public void setMaxFaderErrorRate(double maxFaderErrorRate) {
        this.maxFaderErrorRate = maxFaderErrorRate;
        this.refresh();
    }

    public boolean isFaderEnabled() {
        return this.faderEnabled;
    }

    public void setFaderEnabled(boolean faderEnabled) {
        this.faderEnabled = faderEnabled;
        this.refresh();
    }

    protected JCheckBox getChckbxAnalyzeFader() {
        return this.chckbxAnalyzeFader;
    }

    protected JLabel getLblFaderMaxPoints() {
        return this.lblFaderMaxPoints;
    }

    public boolean isFaderSelected() {
        return this.faderSelected;
    }

    public void setFaderSelected(boolean faderSelected) {
        this.faderSelected = faderSelected;
        this.refresh();
    }

    protected JLabel getLblFaderInfo() {
        return this.lblFaderInfo;
    }

    public String getFaderInfoText() {
        return this.faderInfoText;
    }

    public void setFaderInfoText(String faderInfoText) {
        this.faderInfoText = faderInfoText;
        this.lblFaderInfo.setText(faderInfoText);
    }

    public Icon getFaderInfoIcon() {
        return this.faderInfoIcon;
    }

    public void setFaderInfoIcon(Icon faderInfoIcon) {
        this.faderInfoIcon = faderInfoIcon;
        this.lblFaderInfo.setIcon(faderInfoIcon);
    }

    protected JComboBox getComboBoxDetectFaderClicks() {
        return this.comboBoxDetectFaderClicks;
    }

    protected JCheckBox getChckbxFaderInterpreter() {
        return this.chckbxFaderInterpreter;
    }

    protected JComboBox getComboBoxFaderSimplifyTolerance() {
        return this.comboBoxFaderSimplifyTolerance;
    }

    public boolean isFaderInterSelected() {
        return this.faderInterSelected;
    }

    public void setFaderInterSelected(boolean faderInterSelected) {
        this.faderInterSelected = faderInterSelected;
        this.refresh();
    }

    protected JPanel getPanelFaderInterpreter() {
        return this.panelFaderInterpreter;
    }

    protected JLabel getLblSimplifyTolerance() {
        return this.lblSimplifyTolerance;
    }

    protected JLabel getLblFaderClickDetection() {
        return this.lblFaderClickDetection;
    }

    protected JLabel getLblFaderSimpUnit() {
        return this.lblFaderSimpUnit;
    }

    public WaxMonsterFaderMoveInterpreterConfig getFaderMoveInterpreterConfig() {
        return this.faderMoveInterpreterConfig;
    }

    public void setFaderMoveInterpreterConfig(WaxMonsterFaderMoveInterpreterConfig faderMoveInterpreterConfig) {
        if (faderMoveInterpreterConfig == null) {
            throw new IllegalArgumentException("faderMoveInterpreterConfig=" + faderMoveInterpreterConfig);
        }
        this.faderMoveInterpreterConfig = faderMoveInterpreterConfig;
        this.refresh();
    }
}

