/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.AbstractExecution;
import com.waxmonster.editor.FaderModelAnalyzer;
import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.TimecodeModelAnalyzer;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.impl.DefaultFaderClick;
import com.waxmonster.editor.impl.DefaultFaderMove;
import com.waxmonster.editor.impl.DefaultWaxEditorModel;
import com.waxmonster.editor.impl.WaxMonsterFaderModelAnalyzer;
import com.waxmonster.editor.impl.WaxMonsterFaderMoveInterpreter;
import com.waxmonster.editor.impl.WaxMonsterFaderMoveInterpreterConfig;
import com.waxmonster.editor.impl.WaxMonsterTimecodeModelAnalyzer;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.MultiLinePanel;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class ScratchAnalyzerTask
extends AbstractExecution {
    private static final Logger logger = Logger.getLogger(ScratchAnalyzerTask.class.getName());
    private WaxLab waxLab;
    private AbstractWaxLabPanel waxLabPanel;
    private MultiLinePanel linePanel;
    private EditorLine targetLine;
    private TimecodeModel timecodeModel;
    private TimecodeModelAnalyzer timecodeModelAnalyzer;
    private FaderModel faderModel;
    private FaderModelAnalyzer faderModelAnalyzer;
    private boolean faderReverse;
    private FaderCurve faderCurve;
    private WaxMonsterFaderMoveInterpreterConfig faderMoveInterpreterConfig;

    public ScratchAnalyzerTask(String name, WaxLab waxLab, AbstractWaxLabPanel waxLabPanel, MultiLinePanel linePanel, EditorLine targetLine, TimecodeModel tcModel, int maxPoints, double maxErrorRate, FaderModel faderModel, int maxFaderPoints, double maxFaderError, boolean faderReverse, FaderCurve faderCurve, WaxMonsterFaderMoveInterpreterConfig faderMoveInterpreterConfig) throws IOException {
        this.setName(name);
        this.setDescription(name);
        this.setStopSupported(true);
        this.setPauseSupported(false);
        this.waxLab = waxLab;
        this.waxLabPanel = waxLabPanel;
        this.linePanel = linePanel;
        this.targetLine = targetLine;
        this.timecodeModel = tcModel;
        this.timecodeModelAnalyzer = new WaxMonsterTimecodeModelAnalyzer(tcModel, maxPoints, maxErrorRate);
        this.faderModel = faderModel;
        if (faderModel != null) {
            this.faderModelAnalyzer = new WaxMonsterFaderModelAnalyzer(faderModel, maxFaderPoints, maxFaderError);
        }
        this.faderReverse = faderReverse;
        this.faderCurve = faderCurve;
        this.faderMoveInterpreterConfig = faderMoveInterpreterConfig;
    }

    protected void execute() throws Exception {
        WaxEditorItem waxEditorItem = this.timecodeModelAnalyzer.analyzeTimecodeModel();
        ScratchEditorModel scratchEditorModel = waxEditorItem.getModel();
        int points = scratchEditorModel.getTimecodePointCount();
        double millis = scratchEditorModel.getTimeLength();
        double millisPerPoint = Double.NaN;
        double pointsPerSecond = 0.0;
        if (points > 0) {
            millisPerPoint = millis / (double)points;
            pointsPerSecond = (double)points * 1000.0 / millis;
        }
        logger.info("Number of timecode points: " + points);
        logger.info(" - Average millis per point: " + (double)Math.round(millisPerPoint * 1000.0) / 1000.0);
        logger.info(" - Average points per second: " + (double)Math.round(pointsPerSecond * 1000.0) / 1000.0);
        ScratchEditorModel faderEditorModel = null;
        if (this.faderModelAnalyzer != null && this.faderModel != null) {
            ScratchEditorModel interpretedModel;
            int moveCount;
            faderEditorModel = this.faderModelAnalyzer.analyzeFaderModel();
            if (logger.isLoggable(Level.INFO)) {
                moveCount = faderEditorModel.getFaderMoveCount();
                double millisPerMove = Double.NaN;
                double movesPerSecond = 0.0;
                if (moveCount > 0) {
                    float faderRate = this.faderModel.getFrameRate();
                    long faderFrames = this.faderModel.getFrameLength();
                    double faderMillis = (double)faderFrames * 1000.0 / (double)faderRate;
                    millisPerMove = faderMillis / (double)moveCount;
                    movesPerSecond = (double)moveCount * 1000.0 / faderMillis;
                }
                logger.info("Number of fader moves: " + moveCount);
                logger.info(" - Average millis per move: " + (double)Math.round(millisPerMove * 1000.0) / 1000.0);
                logger.info(" - Average moves per second: " + (double)Math.round(movesPerSecond * 1000.0) / 1000.0);
            }
            if (this.faderReverse) {
                moveCount = faderEditorModel.getFaderMoveCount();
                for (int i = 0; i < moveCount; ++i) {
                    FaderMove move = faderEditorModel.getFaderMoveAt(i);
                    if (move == null) continue;
                    if (move instanceof DefaultFaderClick) {
                        DefaultFaderClick fc = (DefaultFaderClick)move;
                        fc.setTargetValue(1.0f - fc.getTargetValue());
                        continue;
                    }
                    if (move instanceof DefaultFaderMove) {
                        DefaultFaderMove fm = (DefaultFaderMove)move;
                        fm.setTargetValue(1.0f - fm.getTargetValue());
                        continue;
                    }
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.warning("Unsupported fader move type: " + move.getClass());
                }
            }
            WaxMonsterFaderMoveInterpreter faderMoveInterpreter = null;
            if (this.faderMoveInterpreterConfig != null && (interpretedModel = (faderMoveInterpreter = new WaxMonsterFaderMoveInterpreter(faderEditorModel, this.faderCurve, this.faderMoveInterpreterConfig)).interpretFaderMoves()) != null) {
                faderEditorModel = interpretedModel;
            }
            int moveCount2 = faderEditorModel.getFaderMoveCount();
            throw new UnsupportedOperationException("TODO");
        }
        final DefaultWaxEditorModel waxEditorModel = new DefaultWaxEditorModel();
        waxEditorModel.setStartTime(0.0);
        waxEditorModel.addItem(waxEditorItem);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScratchAnalyzerTask.this.targetLine.getMutableChunkModel().addChunk((LineChunk)waxEditorModel);
                int lineIndex = ScratchAnalyzerTask.this.waxLab.getLineIndex((Line)ScratchAnalyzerTask.this.targetLine);
                if (lineIndex < 0) {
                    lineIndex = ScratchAnalyzerTask.this.waxLab.getLineCount();
                    ScratchAnalyzerTask.this.waxLab.addLine((Line)ScratchAnalyzerTask.this.targetLine);
                }
                ScratchAnalyzerTask.this.waxLabPanel.refresh();
                ScratchAnalyzerTask.this.linePanel.setFocusLineIndex(lineIndex);
            }
        });
    }

    public void stop() {
        super.stop();
        this.timecodeModelAnalyzer.cancel();
        if (this.faderModelAnalyzer != null) {
            this.faderModelAnalyzer.cancel();
        }
    }

    public double getProgress() {
        double progress = this.timecodeModelAnalyzer.getProgress();
        if (this.faderModelAnalyzer != null) {
            double faderProgress = this.faderModelAnalyzer.getProgress();
            progress = (progress + faderProgress) / 2.0;
        }
        return progress;
    }
}

