/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.ScratchPattern;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.DefaultWaxEditorItem;
import com.waxmonster.waxlab.view.EditorLineWrapper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScratchGeneratorPanel
extends JPanel {
    private static final long serialVersionUID = 2184092940820513234L;
    private ScratchPattern[] scratchPatterns;
    private boolean refreshing;
    private JDialog dialog;
    private EditorLineWrapper editorLineWrapper;
    private WaxEditorModel targetWaxEditorModel;
    private WaxEditorItem targetWaxEditorItem;
    private double insertTimePosition;
    private double insertNeedlePosition;
    private JTextField textFieldDuration;
    private JTextField textFieldBeats;
    private JTextField textFieldBPM;
    private JTextField textFieldNeedleScale;
    private JList listPattern;
    private JRadioButton rdbtnBeatDuration;
    private JRadioButton rdbtnCustomDuration;
    private JRadioButton rdbtnProportional;
    private JRadioButton rdbtnCustomScale;
    private JCheckBox chckbxAutoConnect;
    private JLabel label;
    private JTextField textFieldBeatDivisor;
    private JRadioButton rdbtnGoofy;
    private JPanel panel;
    private JButton btnGenerate;
    private JButton btnCancel;
    private JCheckBox chckbxAppendExisting;

    public ScratchGeneratorPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelPattern = new JPanel();
        panelPattern.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Scratch Pattern", 4, 2, null, null));
        GridBagConstraints gbc_panelPattern = new GridBagConstraints();
        gbc_panelPattern.weighty = 1.0;
        gbc_panelPattern.weightx = 1.0;
        gbc_panelPattern.insets = new Insets(0, 0, 5, 0);
        gbc_panelPattern.fill = 1;
        gbc_panelPattern.gridx = 0;
        gbc_panelPattern.gridy = 0;
        this.add((Component)panelPattern, gbc_panelPattern);
        GridBagLayout gbl_panelPattern = new GridBagLayout();
        gbl_panelPattern.columnWidths = new int[]{0, 0};
        gbl_panelPattern.rowHeights = new int[]{0, 0};
        gbl_panelPattern.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelPattern.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelPattern.setLayout(gbl_panelPattern);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panelPattern.add((Component)scrollPane, gbc_scrollPane);
        this.listPattern = new JList();
        this.listPattern.setSelectionMode(0);
        this.listPattern.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ScratchGeneratorPanel.this.refreshScratchPatternDetails();
            }
        });
        this.listPattern.setOpaque(false);
        scrollPane.setViewportView(this.listPattern);
        JPanel panelDuration = new JPanel();
        panelDuration.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Scratch Duration", 4, 2, null, null));
        GridBagConstraints gbc_panelDuration = new GridBagConstraints();
        gbc_panelDuration.insets = new Insets(0, 0, 5, 0);
        gbc_panelDuration.fill = 1;
        gbc_panelDuration.gridx = 0;
        gbc_panelDuration.gridy = 1;
        this.add((Component)panelDuration, gbc_panelDuration);
        GridBagLayout gbl_panelDuration = new GridBagLayout();
        gbl_panelDuration.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_panelDuration.rowHeights = new int[]{0, 0, 0};
        gbl_panelDuration.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelDuration.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelDuration.setLayout(gbl_panelDuration);
        this.rdbtnBeatDuration = new JRadioButton("Beats:");
        this.rdbtnBeatDuration.setOpaque(false);
        this.rdbtnBeatDuration.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ScratchGeneratorPanel.this.checkEnable();
                if (!ScratchGeneratorPanel.this.refreshing && ScratchGeneratorPanel.this.rdbtnBeatDuration.isSelected()) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }
        });
        GridBagConstraints gbc_rdbtnBeatDuration = new GridBagConstraints();
        gbc_rdbtnBeatDuration.anchor = 17;
        gbc_rdbtnBeatDuration.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnBeatDuration.gridx = 0;
        gbc_rdbtnBeatDuration.gridy = 0;
        panelDuration.add((Component)this.rdbtnBeatDuration, gbc_rdbtnBeatDuration);
        this.textFieldBeats = new JTextField();
        this.textFieldBeats.setToolTipText("Duration in beats");
        this.textFieldBeats.setOpaque(false);
        GridBagConstraints gbc_textFieldBeats = new GridBagConstraints();
        gbc_textFieldBeats.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldBeats.fill = 2;
        gbc_textFieldBeats.gridx = 1;
        gbc_textFieldBeats.gridy = 0;
        panelDuration.add((Component)this.textFieldBeats, gbc_textFieldBeats);
        this.textFieldBeats.setColumns(8);
        this.label = new JLabel("/");
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.insets = new Insets(4, 4, 5, 5);
        gbc_label.gridx = 2;
        gbc_label.gridy = 0;
        panelDuration.add((Component)this.label, gbc_label);
        this.textFieldBeatDivisor = new JTextField();
        this.textFieldBeatDivisor.setToolTipText("Beat divisor (units)");
        this.textFieldBeatDivisor.setOpaque(false);
        GridBagConstraints gbc_textFieldBeatDivisor = new GridBagConstraints();
        gbc_textFieldBeatDivisor.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldBeatDivisor.fill = 2;
        gbc_textFieldBeatDivisor.gridx = 3;
        gbc_textFieldBeatDivisor.gridy = 0;
        panelDuration.add((Component)this.textFieldBeatDivisor, gbc_textFieldBeatDivisor);
        this.textFieldBeatDivisor.setColumns(2);
        JLabel lblBpm = new JLabel("BPM:");
        GridBagConstraints gbc_lblBpm = new GridBagConstraints();
        gbc_lblBpm.anchor = 13;
        gbc_lblBpm.insets = new Insets(4, 8, 5, 5);
        gbc_lblBpm.gridx = 4;
        gbc_lblBpm.gridy = 0;
        panelDuration.add((Component)lblBpm, gbc_lblBpm);
        this.textFieldBPM = new JTextField();
        this.textFieldBPM.setToolTipText("Beats per minute");
        this.textFieldBPM.setOpaque(false);
        GridBagConstraints gbc_textFieldBPM = new GridBagConstraints();
        gbc_textFieldBPM.weightx = 1.0;
        gbc_textFieldBPM.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldBPM.fill = 2;
        gbc_textFieldBPM.gridx = 5;
        gbc_textFieldBPM.gridy = 0;
        panelDuration.add((Component)this.textFieldBPM, gbc_textFieldBPM);
        this.textFieldBPM.setColumns(3);
        this.rdbtnCustomDuration = new JRadioButton("Custom:");
        this.rdbtnCustomDuration.setOpaque(false);
        this.rdbtnCustomDuration.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ScratchGeneratorPanel.this.checkEnable();
            }
        });
        GridBagConstraints gbc_rdbtnCustomDuration = new GridBagConstraints();
        gbc_rdbtnCustomDuration.anchor = 17;
        gbc_rdbtnCustomDuration.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnCustomDuration.gridx = 0;
        gbc_rdbtnCustomDuration.gridy = 1;
        panelDuration.add((Component)this.rdbtnCustomDuration, gbc_rdbtnCustomDuration);
        this.textFieldDuration = new JTextField();
        this.textFieldDuration.setToolTipText("Duration in milliseconds");
        this.textFieldDuration.setOpaque(false);
        GridBagConstraints gbc_textFieldDuration = new GridBagConstraints();
        gbc_textFieldDuration.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldDuration.fill = 2;
        gbc_textFieldDuration.gridx = 1;
        gbc_textFieldDuration.gridy = 1;
        panelDuration.add((Component)this.textFieldDuration, gbc_textFieldDuration);
        this.textFieldDuration.setColumns(8);
        JLabel lblMs = new JLabel("ms.");
        lblMs.setToolTipText("Milliseconds");
        GridBagConstraints gbc_lblMs = new GridBagConstraints();
        gbc_lblMs.gridwidth = 2;
        gbc_lblMs.anchor = 17;
        gbc_lblMs.insets = new Insets(4, 4, 5, 5);
        gbc_lblMs.gridx = 2;
        gbc_lblMs.gridy = 1;
        panelDuration.add((Component)lblMs, gbc_lblMs);
        JPanel panelNeedleScale = new JPanel();
        panelNeedleScale.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Needle Scale", 4, 2, null, null));
        GridBagConstraints gbc_panelNeedleScale = new GridBagConstraints();
        gbc_panelNeedleScale.insets = new Insets(0, 0, 5, 0);
        gbc_panelNeedleScale.fill = 1;
        gbc_panelNeedleScale.gridx = 0;
        gbc_panelNeedleScale.gridy = 2;
        this.add((Component)panelNeedleScale, gbc_panelNeedleScale);
        GridBagLayout gbl_panelNeedleScale = new GridBagLayout();
        gbl_panelNeedleScale.columnWidths = new int[]{0, 0, 0};
        gbl_panelNeedleScale.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelNeedleScale.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelNeedleScale.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelNeedleScale.setLayout(gbl_panelNeedleScale);
        this.rdbtnProportional = new JRadioButton("Normal (Proportional)");
        this.rdbtnProportional.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ScratchGeneratorPanel.this.checkEnable();
                if (ScratchGeneratorPanel.this.rdbtnProportional.isSelected()) {
                    ScratchGeneratorPanel.this.getTextFieldNeedleScale().setText("1.0");
                }
            }
        });
        this.rdbtnProportional.setToolTipText("Scale needle proportional to scratch duration");
        this.rdbtnProportional.setOpaque(false);
        GridBagConstraints gbc_rdbtnProportional = new GridBagConstraints();
        gbc_rdbtnProportional.gridwidth = 2;
        gbc_rdbtnProportional.insets = new Insets(4, 4, 5, 0);
        gbc_rdbtnProportional.anchor = 17;
        gbc_rdbtnProportional.gridx = 0;
        gbc_rdbtnProportional.gridy = 0;
        panelNeedleScale.add((Component)this.rdbtnProportional, gbc_rdbtnProportional);
        this.rdbtnCustomScale = new JRadioButton("Custom:");
        this.rdbtnCustomScale.setToolTipText("Custom needle scale factor...");
        this.rdbtnCustomScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ScratchGeneratorPanel.this.checkEnable();
            }
        });
        this.rdbtnGoofy = new JRadioButton("Inverse (Goofy Paw)");
        this.rdbtnGoofy.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ScratchGeneratorPanel.this.checkEnable();
                if (ScratchGeneratorPanel.this.rdbtnGoofy.isSelected()) {
                    ScratchGeneratorPanel.this.getTextFieldNeedleScale().setText("-1.0");
                }
            }
        });
        this.rdbtnGoofy.setOpaque(false);
        this.rdbtnGoofy.setToolTipText("Inverse needle direction (aka. Goofy Paw)");
        GridBagConstraints gbc_rdbtnGoofy = new GridBagConstraints();
        gbc_rdbtnGoofy.gridwidth = 2;
        gbc_rdbtnGoofy.anchor = 17;
        gbc_rdbtnGoofy.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnGoofy.gridx = 0;
        gbc_rdbtnGoofy.gridy = 1;
        panelNeedleScale.add((Component)this.rdbtnGoofy, gbc_rdbtnGoofy);
        this.rdbtnCustomScale.setOpaque(false);
        GridBagConstraints gbc_rdbtnCustomScale = new GridBagConstraints();
        gbc_rdbtnCustomScale.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnCustomScale.anchor = 17;
        gbc_rdbtnCustomScale.gridx = 0;
        gbc_rdbtnCustomScale.gridy = 2;
        panelNeedleScale.add((Component)this.rdbtnCustomScale, gbc_rdbtnCustomScale);
        this.textFieldNeedleScale = new JTextField();
        this.textFieldNeedleScale.setToolTipText("Needle scale factor");
        this.textFieldNeedleScale.setOpaque(false);
        GridBagConstraints gbc_textFieldNeedleScale = new GridBagConstraints();
        gbc_textFieldNeedleScale.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldNeedleScale.fill = 2;
        gbc_textFieldNeedleScale.gridx = 1;
        gbc_textFieldNeedleScale.gridy = 2;
        panelNeedleScale.add((Component)this.textFieldNeedleScale, gbc_textFieldNeedleScale);
        this.textFieldNeedleScale.setColumns(8);
        this.chckbxAppendExisting = new JCheckBox("Append to selected scratch model");
        this.chckbxAppendExisting.setOpaque(false);
        this.chckbxAppendExisting.setToolTipText("Append scratch pattern to the selected scratch model ?");
        this.chckbxAppendExisting.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ScratchGeneratorPanel.this.chckbxAutoConnect == null) {
                    return;
                }
                if (ScratchGeneratorPanel.this.chckbxAppendExisting.isSelected()) {
                    ScratchGeneratorPanel.this.chckbxAutoConnect.setEnabled(false);
                } else {
                    ScratchGeneratorPanel.this.chckbxAutoConnect.setEnabled(true);
                }
            }
        });
        this.chckbxAppendExisting.setSelected(true);
        GridBagConstraints gbc_chckbxAppendExisting = new GridBagConstraints();
        gbc_chckbxAppendExisting.insets = new Insets(4, 4, 0, 5);
        gbc_chckbxAppendExisting.anchor = 17;
        gbc_chckbxAppendExisting.gridx = 0;
        gbc_chckbxAppendExisting.gridy = 3;
        this.add((Component)this.chckbxAppendExisting, gbc_chckbxAppendExisting);
        this.chckbxAutoConnect = new JCheckBox("Connect to previous scratch model");
        this.chckbxAutoConnect.setEnabled(false);
        this.chckbxAutoConnect.setSelected(true);
        this.chckbxAutoConnect.setOpaque(false);
        this.chckbxAutoConnect.setToolTipText("Auto-connect to previous scratch model ?");
        GridBagConstraints gbc_chckbxAutoConnect = new GridBagConstraints();
        gbc_chckbxAutoConnect.anchor = 17;
        gbc_chckbxAutoConnect.insets = new Insets(0, 4, 5, 4);
        gbc_chckbxAutoConnect.gridx = 0;
        gbc_chckbxAutoConnect.gridy = 4;
        this.add((Component)this.chckbxAutoConnect, gbc_chckbxAutoConnect);
        this.panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(8, 4, 4, 4);
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 5;
        this.add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.btnGenerate = new JButton("Generate");
        this.btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScratchGeneratorPanel.this.actionCreate();
            }
        });
        this.btnGenerate.setToolTipText("Generate scratch");
        GridBagConstraints gbc_btnGenerate = new GridBagConstraints();
        gbc_btnGenerate.insets = new Insets(0, 0, 0, 5);
        gbc_btnGenerate.gridx = 0;
        gbc_btnGenerate.gridy = 0;
        this.panel.add((Component)this.btnGenerate, gbc_btnGenerate);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScratchGeneratorPanel.this.actionCancel();
            }
        });
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.gridx = 1;
        gbc_btnCancel.gridy = 0;
        this.panel.add((Component)this.btnCancel, gbc_btnCancel);
        this.initScratchWizardPanel();
    }

    public ScratchPattern[] getScratchPatterns() {
        return this.scratchPatterns;
    }

    public void setScratchPatterns(ScratchPattern[] scratchPatterns) {
        this.scratchPatterns = scratchPatterns;
        this.refresh();
    }

    protected void initScratchWizardPanel() {
        this.btnGenerate.setEnabled(false);
        ButtonGroup groupDuration = new ButtonGroup();
        groupDuration.add(this.rdbtnBeatDuration);
        groupDuration.add(this.rdbtnCustomDuration);
        this.rdbtnBeatDuration.setSelected(true);
        ButtonGroup groupNeedle = new ButtonGroup();
        groupNeedle.add(this.rdbtnProportional);
        groupNeedle.add(this.rdbtnGoofy);
        groupNeedle.add(this.rdbtnCustomScale);
        this.rdbtnProportional.setSelected(true);
        this.textFieldBeats.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!ScratchGeneratorPanel.this.refreshing) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!ScratchGeneratorPanel.this.refreshing) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!ScratchGeneratorPanel.this.refreshing) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }
        });
        this.textFieldBeatDivisor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!ScratchGeneratorPanel.this.refreshing) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!ScratchGeneratorPanel.this.refreshing) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!ScratchGeneratorPanel.this.refreshing) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }
        });
        this.textFieldBPM.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!ScratchGeneratorPanel.this.refreshing) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!ScratchGeneratorPanel.this.refreshing) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!ScratchGeneratorPanel.this.refreshing) {
                    ScratchGeneratorPanel.this.refreshBeatDuration();
                }
            }
        });
        this.textFieldBeats.setText("1");
        this.textFieldBeatDivisor.setText("4");
        this.textFieldBPM.setText("100");
        this.textFieldNeedleScale.setText("1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            ScratchPattern selPattern = this.getSelectedScratchPattern();
            DefaultListModel<ScratchPattern> listModel = new DefaultListModel<ScratchPattern>();
            int selIndex = -1;
            ScratchPattern[] patterns = this.getScratchPatterns();
            if (patterns != null) {
                for (int i = 0; i < patterns.length; ++i) {
                    ScratchPattern pattern = patterns[i];
                    if (pattern == null) continue;
                    if (pattern == selPattern) {
                        selIndex = listModel.getSize();
                    }
                    listModel.addElement(pattern);
                }
            }
            this.getListPattern().setModel(listModel);
            if (selIndex < 0 && !listModel.isEmpty()) {
                selIndex = 0;
            }
            if (selIndex >= 0) {
                this.getListPattern().setSelectedIndex(selIndex);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    public ScratchPattern getSelectedScratchPattern() {
        Object obj = this.getListPattern().getSelectedValue();
        if (obj != null && obj instanceof ScratchPattern) {
            return (ScratchPattern)obj;
        }
        return null;
    }

    public boolean isBeatDurationSelected() {
        return this.rdbtnBeatDuration.isSelected();
    }

    public double getBeats() throws NumberFormatException {
        String sBeats = this.textFieldBeats.getText().trim();
        return Double.parseDouble(sBeats);
    }

    public double getBeatDivisor() throws NumberFormatException {
        String sDiv = this.textFieldBeatDivisor.getText().trim();
        return Double.parseDouble(sDiv);
    }

    public double getBPM() throws NumberFormatException {
        String sBPM = this.textFieldBPM.getText().trim();
        return Double.parseDouble(sBPM);
    }

    public double getDurationMillis() throws NumberFormatException {
        String sMillis = this.textFieldDuration.getText().trim();
        return Double.parseDouble(sMillis);
    }

    public boolean isNeedleProportionalSelected() {
        return this.rdbtnProportional.isSelected();
    }

    public boolean isNeedleGoofyPawSelected() {
        return this.rdbtnGoofy.isSelected();
    }

    public double getNeedleScaleFactor() throws NumberFormatException {
        String sFactor = this.textFieldNeedleScale.getText().trim();
        return Double.parseDouble(sFactor);
    }

    public boolean isAutoConnect() {
        return this.chckbxAutoConnect.isSelected();
    }

    public double computeMillis(double beats, double div, double bpm) {
        if (beats > 0.0 && div > 0.0 && bpm > 0.0) {
            return beats * 60000.0 / bpm / div;
        }
        return Double.NaN;
    }

    protected void refreshScratchPatternDetails() {
        double beatLen;
        ScratchPattern pattern = this.getSelectedScratchPattern();
        this.getBtnGenerate().setEnabled(pattern != null);
        if (pattern != null && (beatLen = pattern.getBeatLength()) >= 0.0) {
            String sBeats = String.valueOf(beatLen);
            if (sBeats.endsWith(".0")) {
                sBeats = sBeats.substring(0, sBeats.length() - 2);
            }
            this.getTextFieldBeats().setText(sBeats);
        }
    }

    protected void refreshBeatDuration() {
        double beats = Double.NaN;
        double div = Double.NaN;
        double bpm = Double.NaN;
        try {
            beats = this.getBeats();
            div = this.getBeatDivisor();
            bpm = this.getBPM();
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        double millis = this.computeMillis(beats, div, bpm);
        String sMillis = String.valueOf(millis);
        if (sMillis.endsWith(".0")) {
            sMillis = sMillis.substring(0, sMillis.length() - 2);
        }
        this.textFieldDuration.setText(sMillis);
    }

    protected void checkEnable() {
        this.textFieldBeats.setEnabled(this.rdbtnBeatDuration.isSelected());
        this.textFieldBeatDivisor.setEnabled(this.rdbtnBeatDuration.isSelected());
        this.textFieldBPM.setEnabled(this.rdbtnBeatDuration.isSelected());
        this.textFieldDuration.setEnabled(this.rdbtnCustomDuration.isSelected());
        this.textFieldNeedleScale.setEnabled(this.rdbtnCustomScale.isSelected());
    }

    protected JList getListPattern() {
        return this.listPattern;
    }

    protected JTextField getTextFieldBeats() {
        return this.textFieldBeats;
    }

    protected JTextField getTextFieldBPM() {
        return this.textFieldBPM;
    }

    protected JTextField getTextFieldDuration() {
        return this.textFieldDuration;
    }

    protected JRadioButton getRdbtnBeatDuration() {
        return this.rdbtnBeatDuration;
    }

    protected JRadioButton getRdbtnCustomDuration() {
        return this.rdbtnCustomDuration;
    }

    protected JRadioButton getRdbtnProportional() {
        return this.rdbtnProportional;
    }

    protected JRadioButton getRdbtnCustomScale() {
        return this.rdbtnCustomScale;
    }

    protected JTextField getTextFieldNeedleScale() {
        return this.textFieldNeedleScale;
    }

    protected JCheckBox getChckbxAutoConnect() {
        return this.chckbxAutoConnect;
    }

    protected JTextField getTextFieldBeatDivisor() {
        return this.textFieldBeatDivisor;
    }

    protected JRadioButton getRdbtnGoofy() {
        return this.rdbtnGoofy;
    }

    protected void actionCreate() {
        ScratchPattern scratchPattern = this.getSelectedScratchPattern();
        if (scratchPattern == null) {
            return;
        }
        double beats = -1.0;
        double div = -1.0;
        double bpm = -1.0;
        double millis = -1.0;
        if (this.isBeatDurationSelected()) {
            beats = this.getBeats();
            div = this.getBeatDivisor();
            bpm = this.getBPM();
            millis = this.computeMillis(beats, div, bpm);
        } else {
            millis = this.getDurationMillis();
        }
        if (this.isNeedleProportionalSelected()) {
            double d = 1.0;
        }
        double needleFactor = this.isNeedleGoofyPawSelected() ? -1.0 : this.getNeedleScaleFactor();
        boolean autoConnect = this.isAutoConnect();
        ScratchEditorModel model = scratchPattern.createScratchEditorModel();
        if (model == null) {
            return;
        }
        double modelMillis = model.getTimeLength();
        if (modelMillis <= 0.0) {
            return;
        }
        double timeFactor = millis / modelMillis;
        ScratchEditorModel scaledModel = model.createCopy(timeFactor, needleFactor *= timeFactor);
        DefaultWaxEditorItem item = null;
        WaxEditorItem theItem = this.targetWaxEditorItem;
        if (this.chckbxAppendExisting.isSelected() && theItem != null) {
            if (this.editorLineWrapper.appendScratchEditorModel(theItem, scaledModel)) {
                item = theItem;
                scaledModel = theItem.getModel();
            }
            theItem = null;
        }
        if (item == null) {
            item = new DefaultWaxEditorItem(scaledModel);
            item.setStartTime(this.insertTimePosition);
            item.setStartValue(this.insertNeedlePosition);
            item.setAutoConnect(autoConnect);
            this.editorLineWrapper.insertWaxEditorItem((WaxEditorItem)item, this.targetWaxEditorModel);
            this.targetWaxEditorItem = item;
        }
        this.insertTimePosition = item.getStartTime() + scaledModel.getTimeLength();
        int tn = scaledModel.getTimecodePointCount();
        if (tn > 0) {
            this.insertNeedlePosition += scaledModel.getTimecodePointValueAt(tn - 1);
        }
    }

    protected void actionCancel() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public WaxEditorModel getTargetWaxEditorModel() {
        return this.targetWaxEditorModel;
    }

    public void setTargetWaxEditorModel(WaxEditorModel targetWaxEditorModel) {
        this.targetWaxEditorModel = targetWaxEditorModel;
    }

    public double getInsertTimePosition() {
        return this.insertTimePosition;
    }

    public void setInsertTimePosition(double insertTimePosition) {
        this.insertTimePosition = insertTimePosition;
    }

    public double getInsertNeedlePosition() {
        return this.insertNeedlePosition;
    }

    public void setInsertNeedlePosition(double insertNeedlePosition) {
        this.insertNeedlePosition = insertNeedlePosition;
    }

    public EditorLineWrapper getEditorLineWrapper() {
        return this.editorLineWrapper;
    }

    public void setEditorLineWrapper(EditorLineWrapper editorLineWrapper) {
        this.editorLineWrapper = editorLineWrapper;
    }

    protected JButton getBtnGenerate() {
        return this.btnGenerate;
    }

    protected JButton getBtnCancel() {
        return this.btnCancel;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    protected JCheckBox getChckbxAppendExisting() {
        return this.chckbxAppendExisting;
    }

    public WaxEditorItem getTargetWaxEditorItem() {
        return this.targetWaxEditorItem;
    }

    public void setTargetWaxEditorItem(WaxEditorItem targetWaxEditorItem) {
        this.targetWaxEditorItem = targetWaxEditorItem;
    }
}

