/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.Data;
import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.Tools;
import com.spacekiller.util.media.control.AbstractDoubleControl;
import com.spacekiller.util.media.control.AbstractEnumControl;
import com.spacekiller.util.media.control.AbstractFloatControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.DoubleControl;
import com.spacekiller.util.media.control.FloatControl;
import com.spacekiller.util.media.control.TextFieldControlPanel;
import com.spacekiller.util.midi.MidiFormatter;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.fader.FaderConfig;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.Studio;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.common.TimecodeFormatListCellRenderer;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.PitchBpmControl;
import com.waxmonster.waxlab.PitchDeckControl;
import com.waxmonster.waxlab.PitchFactorControl;
import com.waxmonster.waxlab.PitchModeControl;
import com.waxmonster.waxlab.ScratchLine;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.AbstractPitchBpmControl;
import com.waxmonster.waxlab.impl.AbstractPitchFactorControl;
import com.waxmonster.waxlab.impl.AbstractPitchModeControl;
import com.waxmonster.waxlab.impl.AbstractScratchModeControl;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.util.WaxLabXmlUtil;
import com.waxmonster.waxlab.view.CommonLineConfigPanel;
import com.waxmonster.waxlab.view.FaderConfigManagerPanel;
import com.waxmonster.waxlab.view.PitchControlPanel;
import com.waxmonster.waxlab.view.VolumeControlPanel;
import com.waxmonster.waxlab.view.WaxLabMidiMappingPanel;
import com.waxmonster.waxlab.view.WaxLabMidiTriggerPanel;
import com.waxmonster.waxlab.view.WaxLabPortChooser;
import com.waxmonster.waxlab.view.WaxLabViewUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimecodeLineConfigPanel
extends JPanel {
    private static final long serialVersionUID = -4466152577913917776L;
    private static final Logger logger = Logger.getLogger(TimecodeLineConfigPanel.class.getName());
    public static final String MIDI_LINE_NONE = "<select>";
    private WaxLabDevice waxLabDevice;
    private WaxLabPortInfo[] waxLabPorts;
    private Line[] waxLabLines;
    private TimecodeLine timecodeLine;
    private TimecodeFormat[] timecodeFormats;
    private TimecodeLineConfig timecodeLineConfig;
    private boolean liveFeed;
    private Resource audioResource;
    private DoubleControl preFaderVolumeControl;
    private DoubleControl postFaderVolumeControl;
    private PitchModeControlImpl pitchModeControl;
    private PitchFactorControlImpl pitchFactorControl;
    private PitchBpmControlImpl pitchBpmControl;
    private PitchDeckControlImpl pitchDeckControl;
    private FloatControl resampleControl;
    private boolean refreshing;
    private Icon scratchModeWarningIcon;
    private Icon audioFaderWarningIcon;
    private JPanel jPanelFill = null;
    private JPanel jPanelTimecodeAudioInput = null;
    private JCheckBox jCheckBoxRecordingEnabled = null;
    private JPanel jPanelViewOptions = null;
    private JCheckBox jCheckBoxInvertedView = null;
    private JPanel jPanelScratchAudioOutput = null;
    private JCheckBox jCheckBoxDisableFaderShading = null;
    private JComboBox jComboBoxPlaybackFile = null;
    private JButton jButtonBrowsePlaybackFile = null;
    private JCheckBox jCheckBoxDisableAutoScroll = null;
    private JLabel labelChannels;
    private JComboBox comboBoxPlayChannels;
    private JRadioButton rdbtnLiveFeed;
    private JRadioButton rdbtnAudioFile;
    private JLabel lblScratchMode;
    private JComboBox comboBoxScratchMode;
    private WaxLabPortChooser waxLabPortChooserRec;
    private JLabel lblPostFaderPorts;
    private WaxLabPortChooser waxLabPortChooserPostFader;
    private WaxLabPortChooser waxLabPortChooserLiveFeed;
    private JLabel lblPitch;
    private JTabbedPane tabbedPane;
    private JPanel panelAudioOutputTab;
    private JPanel panelScratchControlTab;
    private JPanel panelScratchControl;
    private VolumeControlPanel volumeControlPanelPreFader;
    private PitchControlPanel pitchControlPanel;
    private JPanel panelTrackSourceTab;
    private JPanel panelTrackSource;
    private JPanel panelAudioFile;
    private JPanel panelViewOptionsTab;
    private JPanel panel_10;
    private JLabel lblLeftInputPort;
    private JLabel lblRightInputPort;
    private JCheckBox checkboxRealtimeScratching;
    private JPanel panel_4;
    private JCheckBox checkboxPlaybackScratching;
    private JLabel lblBeatJump;
    private JPanel panelBeatJump;
    private JComboBox comboBoxBeatJump;
    private JLabel lblJumpBeats;
    private JLabel lblCuePoints;
    private JPanel panelCuePoints;
    private JComboBox comboBoxCuePoints;
    private JPanel panelResampling;
    private JRadioButton rdbtnOutputSampleRate;
    private JRadioButton rdbtnSourceSampleRate;
    private JRadioButton rdbtnCustomSampleRate;
    private TextFieldControlPanel textFieldControlPanelResampleCustom;
    private JLabel lblHz;
    private JPanel panel_6;
    private JCheckBox chckbxScratchPositionView;
    private JCheckBox chckbxBeatCompassView;
    private JCheckBox chckbxBeatRadarView;
    private JPanel panel_7;
    private JPanel panelMidiPortsTab;
    private JPanel panelMidiInput;
    private JPanel panelMidiOutput;
    private JPanel panelScratchInputTab;
    private JPanel panelScratchMode;
    private JPanel panelTimecodeMidiInput;
    private JPanel panel_5;
    private JLabel lblMidiInputPort_1;
    private WaxLabPortChooser waxLabPortChooserTimecodeMidiInput;
    private CommonLineConfigPanel commonLineConfigPanel;
    private JPanel panelTimecodeFormat;
    private JComboBox comboBoxTimecodeFormat;
    private JPanel panelFaderControlTab;
    private FaderConfigManagerPanel faderConfigManagerPanel;
    private JPanel panelMidiInputLine;
    private JComboBox comboBoxMidiInputLine;
    private JLabel lblMidiInputLineInfo;
    private WaxLabPortChooser waxLabPortChooserPreFader;
    private JLabel lblPreFaderPorts;
    private JPanel panelPreFaderOutput;
    private JLabel lblLiveFeedPorts;
    private JPanel panelLiveFeedPorts;
    private JPanel panelPostFaderOutput;
    private JLabel lblPreFaderLine;
    private JLabel lblNewLabel_1;
    private JCheckBox chckbxAudioFader;
    private JLabel lblPostFaderLine;
    private VolumeControlPanel volumeControlPanelPostFader;
    private JLabel lblNewLabel_2;
    private JPanel panel_11;
    private JPanel panel_12;
    private JCheckBox chckbxPreFaderEnabled;
    private JCheckBox chckbxPostFaderEnabled;
    private JLabel lblPreFaderVolume;
    private JLabel lblPostFaderVolume;
    private JPanel panel_13;
    private JPanel panel_14;
    private JLabel lblAudioFaderInfo;
    private JPanel panelTimecodeInput;
    private JLabel labelTimecodeFormat;
    private JLabel lblScratchModeInfo;
    private JPanel panelFaderMidiLine;
    private JPanel panelMidiLine;
    private JLabel lblFaderMidiLine;
    private JRadioButton rdbtnAudioBridge;
    private JPanel panelAudioBridge;
    private JLabel lblNewLabel;
    private JLabel lblNewLabel_3;
    private WaxLabMidiMappingPanel waxLabMidiMappingPanel;
    private WaxLabMidiTriggerPanel waxLabMidiTriggerPanel;
    private JLabel lblBeatSlicer;
    private JPanel panelBeatSlicer;
    private JComboBox comboBoxSliceBeats;
    private JLabel lblSliceBeats;

    public TimecodeLineConfigPanel() {
        this.initialize();
        this.initTimecodeLineConfigPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints21.gridy = 1;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.gridy = 2;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(711, 585));
        GridBagConstraints gbc_commonLineConfigPanel = new GridBagConstraints();
        gbc_commonLineConfigPanel.weightx = 1.0;
        gbc_commonLineConfigPanel.insets = new Insets(0, 0, 5, 0);
        gbc_commonLineConfigPanel.fill = 1;
        gbc_commonLineConfigPanel.gridx = 0;
        gbc_commonLineConfigPanel.gridy = 0;
        this.add((Component)this.getCommonLineConfigPanel(), gbc_commonLineConfigPanel);
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.weightx = 1.0;
        gbc_tabbedPane.insets = new Insets(0, 4, 5, 4);
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 1;
        this.add((Component)this.getTabbedPane(), gbc_tabbedPane);
        this.add((Component)this.getJPanelFill(), gridBagConstraints11);
    }

    protected void initTimecodeLineConfigPanel() {
        this.waxLabMidiMappingPanel.setDeviceName("WaxLabScratchDeck");
        this.waxLabMidiTriggerPanel.setDeviceName("WaxLabScratchDeck");
        ButtonGroup groupTrackSrc = new ButtonGroup();
        groupTrackSrc.add(this.rdbtnAudioFile);
        groupTrackSrc.add(this.rdbtnAudioBridge);
        groupTrackSrc.add(this.rdbtnLiveFeed);
        ButtonGroup groupResampling = new ButtonGroup();
        groupResampling.add(this.rdbtnOutputSampleRate);
        groupResampling.add(this.rdbtnSourceSampleRate);
        groupResampling.add(this.rdbtnCustomSampleRate);
        this.preFaderVolumeControl = new VolumeControlImpl();
        this.volumeControlPanelPreFader.setTextFormat(new DecimalFormat("0.0"));
        this.volumeControlPanelPreFader.setVolumeControl(this.preFaderVolumeControl);
        this.postFaderVolumeControl = new VolumeControlImpl();
        this.volumeControlPanelPostFader.setTextFormat(new DecimalFormat("0.0"));
        this.volumeControlPanelPostFader.setVolumeControl(this.postFaderVolumeControl);
        this.pitchModeControl = new PitchModeControlImpl();
        this.pitchFactorControl = new PitchFactorControlImpl();
        this.pitchBpmControl = new PitchBpmControlImpl();
        this.pitchDeckControl = new PitchDeckControlImpl();
        this.pitchControlPanel.setPitchRanges(AbstractPitchFactorControl.getCommonPitchRanges());
        this.pitchControlPanel.setPitchModeControl((PitchModeControl)this.pitchModeControl);
        this.pitchControlPanel.setPitchFactorControl((PitchFactorControl)this.pitchFactorControl);
        this.pitchControlPanel.setPitchBpmControl((PitchBpmControl)this.pitchBpmControl);
        this.pitchControlPanel.setPitchDeckControl(this.pitchDeckControl);
        this.resampleControl = new ResampleControlImpl();
        this.resampleControl.setFloat(44100.0f);
        this.textFieldControlPanelResampleCustom.setControl((Control)this.resampleControl);
        this.scratchModeWarningIcon = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/view/icons/scratch_mode_warn.gif");
        this.audioFaderWarningIcon = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/view/icons/scratch_mode_warn.gif");
        this.comboBoxBeatJump.removeAllItems();
        this.comboBoxBeatJump.addItem(new BeatsItem("32", 32.0));
        this.comboBoxBeatJump.addItem(new BeatsItem("16", 16.0));
        this.comboBoxBeatJump.addItem(new BeatsItem("8", 8.0));
        this.comboBoxBeatJump.addItem(new BeatsItem("4", 4.0));
        this.comboBoxBeatJump.addItem(new BeatsItem("2", 2.0));
        this.comboBoxBeatJump.addItem(new BeatsItem("1", 1.0));
        this.comboBoxBeatJump.addItem(new BeatsItem("1 / 2", 0.5));
        this.comboBoxBeatJump.addItem(new BeatsItem("1 / 4", 0.25));
        this.comboBoxBeatJump.addItem(new BeatsItem("1 / 8", 0.125));
        this.comboBoxBeatJump.addItem(new BeatsItem("1 / 16", 0.0625));
        this.comboBoxBeatJump.addItem(new BeatsItem("1 / 32", 0.03125));
        this.comboBoxSliceBeats.removeAllItems();
        this.comboBoxSliceBeats.addItem(new BeatsItem("1", 1.0));
        this.comboBoxSliceBeats.addItem(new BeatsItem("1 / 2", 0.5));
        this.comboBoxSliceBeats.addItem(new BeatsItem("1 / 4", 0.25));
        this.comboBoxSliceBeats.addItem(new BeatsItem("1 / 8", 0.125));
        this.comboBoxCuePoints.removeAllItems();
        this.comboBoxCuePoints.addItem(Data.toInteger((int)5));
        this.comboBoxCuePoints.addItem(Data.toInteger((int)8));
        this.comboBoxCuePoints.addItem(Data.toInteger((int)10));
        this.comboBoxTimecodeFormat.setRenderer(new TimecodeFormatListCellRenderer());
        this.comboBoxMidiInputLine.setRenderer(new LineListCellRenderer());
        this.validate();
        this.checkEnable();
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            this.getCommonLineConfigPanel().setLineConfig((LineConfig)this.timecodeLineConfig);
            String timecodeFormatName = null;
            boolean recEnabled = false;
            int recChannels = 2;
            boolean playerEnabled = false;
            boolean scratcherEnabled = false;
            int playFrameType = -1;
            String pitchMode = null;
            double pitchFactor = 1.0;
            double pitchMin = 0.0;
            double pitchMax = 0.0;
            double pitchBPM = 133.33333333333334;
            ScratchLine pitchLine = null;
            double jumpBeats = 1.0;
            double sliceBeats = 1.0;
            int cuePointCount = 8;
            float resampleRate = 0.0f;
            boolean audioFaderEnabled = false;
            FaderConfig[] audioFaderConfigs = null;
            String scratchMode = null;
            boolean invertedView = false;
            boolean timecodeAutoScrolling = true;
            boolean faderShading = false;
            boolean scratchPositionView = true;
            boolean beatCompassView = true;
            boolean beatRadarView = true;
            WaxLabPortInfo[] preFaderPorts = null;
            WaxLabPortInfo[] postFaderPorts = null;
            WaxLabPortInfo[] recPorts = null;
            WaxLabPortInfo[] feedPorts = null;
            boolean preFaderEnabled = false;
            double preFaderVolume = 1.0;
            boolean postFaderEnabled = false;
            double postFaderVolume = 1.0;
            MidiLine midiInputLine = null;
            WaxLabPortInfo midiInputPort = null;
            WaxLabPortInfo midiOutputPort = null;
            WaxLabPortInfo timecodeMidiInputPort = null;
            if (this.timecodeLineConfig != null) {
                timecodeFormatName = this.timecodeLineConfig.getTimecodeFormatName();
                recEnabled = this.timecodeLineConfig.isRecordingEnabled();
                playerEnabled = this.timecodeLineConfig.isPlaybackEnabled();
                scratcherEnabled = this.timecodeLineConfig.isScratchingEnabled();
                playFrameType = this.timecodeLineConfig.getPlaybackFrameType();
                pitchMode = this.timecodeLineConfig.getPitchMode();
                pitchFactor = this.timecodeLineConfig.getPitchFactor();
                pitchMin = this.timecodeLineConfig.getPitchMin();
                pitchMax = this.timecodeLineConfig.getPitchMax();
                pitchBPM = this.timecodeLineConfig.getPitchBPM();
                pitchLine = this.timecodeLineConfig.getPitchLine();
                jumpBeats = this.timecodeLineConfig.getJumpBeats();
                sliceBeats = this.timecodeLineConfig.getSliceBeats();
                cuePointCount = this.timecodeLineConfig.getCuePointCount();
                resampleRate = this.timecodeLineConfig.getResampleRate();
                audioFaderEnabled = this.timecodeLineConfig.isAudioFaderEnabled();
                audioFaderConfigs = this.timecodeLineConfig.getAudioFaderConfigs();
                scratchMode = this.timecodeLineConfig.getScratchMode();
                invertedView = this.timecodeLineConfig.isInvertedView();
                faderShading = this.timecodeLineConfig.isFaderShadingView();
                timecodeAutoScrolling = this.timecodeLineConfig.isTimecodeAutoScrolling();
                scratchPositionView = this.timecodeLineConfig.isScratchPositionViewEnabled();
                beatCompassView = this.timecodeLineConfig.isBeatCompassViewEnabled();
                beatRadarView = this.timecodeLineConfig.isBeatRadarViewEnabled();
                preFaderPorts = this.timecodeLineConfig.getPreFaderPorts();
                postFaderPorts = this.timecodeLineConfig.getPostFaderPorts();
                recPorts = this.timecodeLineConfig.getRecordingPorts();
                feedPorts = this.timecodeLineConfig.getLiveFeedPorts();
                preFaderEnabled = this.timecodeLineConfig.isPreFaderEnabled();
                preFaderVolume = this.timecodeLineConfig.getPreFaderVolume();
                postFaderEnabled = this.timecodeLineConfig.isPostFaderEnabled();
                postFaderVolume = this.timecodeLineConfig.getPostFaderVolume();
                midiInputLine = this.timecodeLineConfig.getFaderMidiLine();
                midiInputPort = this.timecodeLineConfig.getMidiInputPort();
                midiOutputPort = this.timecodeLineConfig.getMidiOutputPort();
                timecodeMidiInputPort = this.timecodeLineConfig.getTimecodeMidiInputPort();
            }
            this.jCheckBoxRecordingEnabled.setSelected(recEnabled);
            this.waxLabPortChooserRec.setAudioChannelCount(recChannels);
            this.waxLabPortChooserRec.setSelectedPorts(recPorts);
            this.checkboxRealtimeScratching.setSelected(scratcherEnabled);
            this.checkboxPlaybackScratching.setSelected(playerEnabled);
            this.chckbxAudioFader.setSelected(audioFaderEnabled);
            this.comboBoxScratchMode.removeAllItems();
            String[] scratchModes = AbstractScratchModeControl.getScratchModes();
            int numModes = scratchModes == null ? 0 : scratchModes.length;
            int selMode = -1;
            for (int i = 0; i < numModes; ++i) {
                String mode = scratchModes[i];
                this.comboBoxScratchMode.addItem(mode);
                if (mode == null || !mode.equalsIgnoreCase(scratchMode)) continue;
                selMode = i;
            }
            if (selMode >= 0) {
                this.comboBoxScratchMode.setSelectedIndex(selMode);
            }
            int[] frameTypes = WaxLabViewUtil.getFrameTypes();
            this.comboBoxPlayChannels.removeAllItems();
            int playFrameTypeIndex = -1;
            for (int i = 0; i < frameTypes.length; ++i) {
                int frameType = frameTypes[i];
                String frameTypeString = WaxLabViewUtil.formatFrameType(frameType);
                if (frameTypeString == null) continue;
                if (playFrameType == frameType) {
                    playFrameTypeIndex = this.comboBoxPlayChannels.getItemCount();
                }
                this.comboBoxPlayChannels.addItem(frameTypeString);
            }
            if (playFrameTypeIndex >= 0) {
                this.comboBoxPlayChannels.setSelectedIndex(playFrameTypeIndex);
            }
            int playChannels = WaxLabXmlUtil.getFrameTypeChannelCount((int)playFrameType);
            this.waxLabPortChooserPreFader.setAudioChannelCount(playChannels);
            this.waxLabPortChooserPreFader.setSelectedPorts(preFaderPorts);
            this.waxLabPortChooserPostFader.setAudioChannelCount(playChannels);
            this.waxLabPortChooserPostFader.setSelectedPorts(postFaderPorts);
            this.waxLabPortChooserTimecodeMidiInput.setSelectedPorts(new WaxLabPortInfo[]{timecodeMidiInputPort});
            this.comboBoxMidiInputLine.removeAllItems();
            this.comboBoxMidiInputLine.addItem(MIDI_LINE_NONE);
            int selMidiLineIndex = 0;
            Line[] lines = this.getWaxLabLines();
            int numLines = lines == null ? 0 : lines.length;
            for (int i = 0; i < numLines; ++i) {
                Line line = lines[i];
                if (line == null || !(line instanceof MidiLine)) continue;
                if (line == midiInputLine) {
                    selMidiLineIndex = this.comboBoxMidiInputLine.getItemCount();
                }
                this.comboBoxMidiInputLine.addItem(line);
            }
            this.comboBoxMidiInputLine.setSelectedIndex(selMidiLineIndex);
            this.waxLabMidiMappingPanel.setMidiInputPort(midiInputPort);
            this.waxLabMidiTriggerPanel.setMidiOutputPort(midiOutputPort);
            this.chckbxPreFaderEnabled.setSelected(preFaderEnabled);
            this.preFaderVolumeControl.setDouble(preFaderVolume * 100.0);
            this.chckbxPostFaderEnabled.setSelected(postFaderEnabled);
            this.postFaderVolumeControl.setDouble(postFaderVolume * 100.0);
            if (this.pitchModeControl != null) {
                if (!this.pitchModeControl.isValueSupported(pitchMode)) {
                    pitchMode = "Normal";
                }
                this.pitchModeControl.setValue(pitchMode);
            }
            if (this.pitchFactorControl != null) {
                this.pitchFactorControl.setPitchRange(pitchMin * 100.0, pitchMax * 100.0);
                this.pitchFactorControl.setDouble(pitchFactor * 100.0);
            }
            if (this.pitchBpmControl != null) {
                this.pitchBpmControl.setDouble(pitchBPM);
            }
            if (this.pitchDeckControl != null) {
                LinkedList<String> pitchDeckList = new LinkedList<String>();
                pitchDeckList.add(MIDI_LINE_NONE);
                for (int i = 0; i < numLines; ++i) {
                    Line line = lines[i];
                    if (line == null || line == this.timecodeLine || !(line instanceof ScratchLine)) continue;
                    pitchDeckList.add((String)((ScratchLine)line));
                }
                Object[] values = pitchDeckList.toArray();
                this.pitchDeckControl.setValues(values);
                Object pitchLineValue = pitchLine;
                if (!this.pitchDeckControl.isValueSupported(pitchLineValue)) {
                    pitchLineValue = MIDI_LINE_NONE;
                }
                this.pitchDeckControl.setValue(pitchLineValue);
            }
            this.comboBoxTimecodeFormat.removeAllItems();
            if (this.timecodeFormats != null) {
                for (int i = 0; i < this.timecodeFormats.length; ++i) {
                    TimecodeFormat tcFormat = this.timecodeFormats[i];
                    this.comboBoxTimecodeFormat.addItem(tcFormat);
                    if (!tcFormat.getName().equals(timecodeFormatName)) continue;
                    this.comboBoxTimecodeFormat.setSelectedIndex(i);
                }
            }
            int jumpBeatsIndex = -1;
            int jumpBeatsCount = this.comboBoxBeatJump.getItemCount();
            for (int i = 0; i < jumpBeatsCount; ++i) {
                BeatsItem item = (BeatsItem)this.comboBoxBeatJump.getItemAt(i);
                if (jumpBeats != item.getBeats()) continue;
                jumpBeatsIndex = i;
                break;
            }
            if (jumpBeatsIndex < 0) {
                jumpBeatsIndex = jumpBeatsCount;
                this.comboBoxBeatJump.addItem(new BeatsItem(String.valueOf(jumpBeats), jumpBeats));
            }
            this.comboBoxBeatJump.setSelectedIndex(jumpBeatsIndex);
            int sliceBeatsIndex = -1;
            int sliceBeatsCount = this.comboBoxSliceBeats.getItemCount();
            for (int i = 0; i < sliceBeatsCount; ++i) {
                BeatsItem item = (BeatsItem)this.comboBoxSliceBeats.getItemAt(i);
                if (sliceBeats != item.getBeats()) continue;
                sliceBeatsIndex = i;
                break;
            }
            if (sliceBeatsIndex < 0) {
                sliceBeatsIndex = sliceBeatsCount;
                this.comboBoxSliceBeats.addItem(new BeatsItem(String.valueOf(sliceBeats), sliceBeats));
            }
            this.comboBoxSliceBeats.setSelectedIndex(sliceBeatsIndex);
            int selCuePointsIndex = -1;
            int cuePointsItems = this.comboBoxCuePoints.getItemCount();
            for (int i = 0; i < cuePointsItems; ++i) {
                Integer item = (Integer)this.comboBoxCuePoints.getItemAt(i);
                if (cuePointCount != item) continue;
                selCuePointsIndex = i;
                break;
            }
            if (selCuePointsIndex < 0) {
                selCuePointsIndex = cuePointsItems;
                this.comboBoxCuePoints.addItem(Data.toInteger((int)cuePointCount));
            }
            this.comboBoxCuePoints.setSelectedIndex(selCuePointsIndex);
            if (Float.isNaN(resampleRate)) {
                this.rdbtnSourceSampleRate.setSelected(true);
            } else if (resampleRate > 0.0f) {
                this.rdbtnCustomSampleRate.setSelected(true);
                this.resampleControl.setFloat(resampleRate);
            } else {
                this.rdbtnOutputSampleRate.setSelected(true);
            }
            this.faderConfigManagerPanel.setFaderConfigs(audioFaderConfigs);
            this.jCheckBoxInvertedView.setSelected(invertedView);
            this.jCheckBoxDisableFaderShading.setSelected(!faderShading);
            this.jCheckBoxDisableAutoScroll.setSelected(!timecodeAutoScrolling);
            this.chckbxScratchPositionView.setSelected(scratchPositionView);
            this.chckbxBeatCompassView.setSelected(beatCompassView);
            this.chckbxBeatRadarView.setSelected(beatRadarView);
            this.jComboBoxPlaybackFile.removeAllItems();
            if (this.isLiveFeed()) {
                this.rdbtnLiveFeed.setSelected(true);
            } else {
                this.rdbtnAudioFile.setSelected(true);
                Resource audioResource = this.getAudioResource();
                if (audioResource != null) {
                    String path = audioResource.toString();
                    int fileIndex = this.jComboBoxPlaybackFile.getItemCount();
                    this.jComboBoxPlaybackFile.addItem(path);
                    this.jComboBoxPlaybackFile.setSelectedIndex(fileIndex);
                }
            }
            this.waxLabPortChooserLiveFeed.setAudioChannelCount(playChannels);
            this.waxLabPortChooserLiveFeed.setSelectedPorts(feedPorts);
            this.checkPorts();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    private JPanel getJPanelFill() {
        if (this.jPanelFill == null) {
            this.jPanelFill = new JPanel();
            this.jPanelFill.setLayout(new GridBagLayout());
            this.jPanelFill.setOpaque(false);
        }
        return this.jPanelFill;
    }

    private JPanel getJPanelTimecodeAudioInput() {
        if (this.jPanelTimecodeAudioInput == null) {
            this.jPanelTimecodeAudioInput = new JPanel();
            GridBagLayout gbl_jPanelTimecodeAudioInput = new GridBagLayout();
            gbl_jPanelTimecodeAudioInput.rowHeights = new int[]{0, 0, 0};
            gbl_jPanelTimecodeAudioInput.rowWeights = new double[]{1.0, 1.0, 0.0};
            gbl_jPanelTimecodeAudioInput.columnWidths = new int[]{0, 0};
            gbl_jPanelTimecodeAudioInput.columnWeights = new double[]{0.0, 0.0};
            this.jPanelTimecodeAudioInput.setLayout(gbl_jPanelTimecodeAudioInput);
            this.jPanelTimecodeAudioInput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Timecode Audio Input", 4, 2, null, new Color(51, 51, 51)));
            GridBagConstraints gbc_panel_10 = new GridBagConstraints();
            gbc_panel_10.fill = 1;
            gbc_panel_10.insets = new Insets(4, 4, 5, 5);
            gbc_panel_10.gridx = 0;
            gbc_panel_10.gridy = 2;
            this.jPanelTimecodeAudioInput.add((Component)this.getPanel_10(), gbc_panel_10);
            GridBagConstraints gbc_waxLabPortChooserRec = new GridBagConstraints();
            gbc_waxLabPortChooserRec.fill = 1;
            gbc_waxLabPortChooserRec.weightx = 1.0;
            gbc_waxLabPortChooserRec.anchor = 17;
            gbc_waxLabPortChooserRec.insets = new Insets(4, 4, 5, 5);
            gbc_waxLabPortChooserRec.gridx = 1;
            gbc_waxLabPortChooserRec.gridy = 2;
            this.jPanelTimecodeAudioInput.add((Component)this.getWaxLabPortChooserRec(), gbc_waxLabPortChooserRec);
        }
        return this.jPanelTimecodeAudioInput;
    }

    protected void apply() {
        float resampleRate;
        Integer cuePointsItem;
        Object sliceBeatsItem;
        Object jumpBeatsItem;
        TimecodeLineConfig config = this.getTimecodeLineConfig();
        if (config == null) {
            return;
        }
        TimecodeFormat tcFormat = (TimecodeFormat)this.comboBoxTimecodeFormat.getSelectedItem();
        String tcFormatName = tcFormat == null ? null : tcFormat.getName();
        config.setTimecodeFormatName(tcFormatName);
        config.setRecordingEnabled(this.jCheckBoxRecordingEnabled.isSelected());
        config.setPlaybackEnabled(this.checkboxPlaybackScratching.isSelected());
        config.setScratchingEnabled(this.checkboxRealtimeScratching.isSelected());
        config.setAudioFaderEnabled(this.chckbxAudioFader.isSelected());
        config.setScratchMode(String.valueOf(this.comboBoxScratchMode.getSelectedItem()));
        config.setInvertedView(this.jCheckBoxInvertedView.isSelected());
        config.setFaderShadingView(!this.jCheckBoxDisableFaderShading.isSelected());
        config.setTimecodeAutoScrolling(!this.getJCheckBoxDisableAutoScroll().isSelected());
        config.setScratchPositionViewEnabled(this.chckbxScratchPositionView.isSelected());
        config.setBeatCompassViewEnabled(this.chckbxBeatCompassView.isSelected());
        config.setBeatRadarViewEnabled(this.chckbxBeatRadarView.isSelected());
        config.setPreFaderEnabled(this.chckbxPreFaderEnabled.isSelected());
        config.setPostFaderEnabled(this.chckbxPostFaderEnabled.isSelected());
        config.setPreFaderVolume(this.preFaderVolumeControl.getDouble() / 100.0);
        config.setPostFaderVolume(this.postFaderVolumeControl.getDouble() / 100.0);
        if (this.pitchModeControl != null) {
            Object pitchMode = this.pitchModeControl.getValue();
            config.setPitchMode(pitchMode == null ? null : String.valueOf(pitchMode));
        }
        if (this.pitchFactorControl != null) {
            config.setPitchMin(this.pitchFactorControl.getMinimum() / 100.0);
            config.setPitchMax(this.pitchFactorControl.getMaximum() / 100.0);
            config.setPitchFactor(this.pitchFactorControl.getDouble() / 100.0);
        }
        if (this.pitchBpmControl != null) {
            config.setPitchBPM(this.pitchBpmControl.getDouble());
        }
        if (this.pitchDeckControl != null) {
            Object pitchDeck = this.pitchDeckControl.getValue();
            ScratchLine pitchLine = null;
            if (pitchDeck != null && pitchDeck instanceof ScratchLine) {
                pitchLine = (ScratchLine)pitchDeck;
            }
            config.setPitchLine(pitchLine);
        }
        if ((jumpBeatsItem = this.comboBoxBeatJump.getSelectedItem()) != null && jumpBeatsItem instanceof BeatsItem) {
            BeatsItem bji = (BeatsItem)jumpBeatsItem;
            config.setJumpBeats(bji.getBeats());
        }
        if ((sliceBeatsItem = this.comboBoxSliceBeats.getSelectedItem()) != null && sliceBeatsItem instanceof BeatsItem) {
            BeatsItem bji = (BeatsItem)sliceBeatsItem;
            config.setSliceBeats(bji.getBeats());
        }
        if ((cuePointsItem = (Integer)this.comboBoxCuePoints.getSelectedItem()) != null) {
            config.setCuePointCount(cuePointsItem.intValue());
        }
        if (this.rdbtnOutputSampleRate.isSelected()) {
            resampleRate = 0.0f;
        } else if (this.rdbtnSourceSampleRate.isSelected()) {
            resampleRate = Float.NaN;
        } else {
            resampleRate = this.resampleControl.getFloat();
            if (resampleRate < 0.0f) {
                resampleRate = 0.0f;
            }
        }
        config.setResampleRate(resampleRate);
        FaderConfig[] audioFaderConfigs = this.faderConfigManagerPanel.getFaderConfigs();
        config.setAudioFaderConfigs(audioFaderConfigs);
        int playFrameType = -1;
        Object playFrameTypeItem = this.comboBoxPlayChannels.getSelectedItem();
        if (playFrameTypeItem != null) {
            playFrameType = WaxLabViewUtil.parseFrameType(String.valueOf(playFrameTypeItem));
        }
        config.setPlaybackFrameType(playFrameType);
        this.liveFeed = this.rdbtnLiveFeed.isSelected();
        WaxLabPortInfo[] preFaderPorts = this.waxLabPortChooserPreFader.getSelectedPorts();
        config.setPreFaderPorts(preFaderPorts);
        WaxLabPortInfo[] postFaderPorts = this.waxLabPortChooserPostFader.getSelectedPorts();
        config.setPostFaderPorts(postFaderPorts);
        WaxLabPortInfo[] recPorts = this.waxLabPortChooserRec.getSelectedPorts();
        config.setRecordingPorts(recPorts);
        WaxLabPortInfo[] feedPorts = this.waxLabPortChooserLiveFeed.getSelectedPorts();
        config.setLiveFeedPorts(feedPorts);
        MidiLine midiInputLine = null;
        Object midiInputLineObj = this.comboBoxMidiInputLine.getSelectedItem();
        if (midiInputLineObj != null && midiInputLineObj instanceof MidiLine) {
            midiInputLine = (MidiLine)midiInputLineObj;
        }
        config.setFaderMidiLine(midiInputLine);
        WaxLabPortInfo midiInputPort = this.waxLabMidiMappingPanel.getMidiInputPort();
        config.setMidiInputPort(midiInputPort);
        WaxLabPortInfo midiOutputPort = this.waxLabMidiTriggerPanel.getMidiOutputPort();
        config.setMidiOutputPort(midiOutputPort);
        WaxLabPortInfo[] timecodeMidiInputPorts = this.waxLabPortChooserTimecodeMidiInput.getSelectedPorts();
        WaxLabPortInfo timecodeMidiInputPort = timecodeMidiInputPorts.length < 1 ? null : timecodeMidiInputPorts[0];
        config.setTimecodeMidiInputPort(timecodeMidiInputPort);
    }

    public TimecodeLineConfig getTimecodeLineConfig() {
        return this.timecodeLineConfig;
    }

    public void setTimecodeLineConfig(TimecodeLineConfig timecodeLineConfig) {
        this.timecodeLineConfig = timecodeLineConfig;
        this.refresh();
    }

    public TimecodeFormat[] getTimecodeFormats() {
        return this.timecodeFormats;
    }

    public void setTimecodeFormats(TimecodeFormat[] timecodeFormats) {
        this.timecodeFormats = timecodeFormats;
    }

    private JCheckBox getJCheckBoxRecordingEnabled() {
        if (this.jCheckBoxRecordingEnabled == null) {
            this.jCheckBoxRecordingEnabled = new JCheckBox();
            this.jCheckBoxRecordingEnabled.setText("Scratch Recording");
            this.jCheckBoxRecordingEnabled.setToolTipText("Scratch recording enabled ?");
            this.jCheckBoxRecordingEnabled.setOpaque(false);
            this.jCheckBoxRecordingEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxRecordingEnabled;
    }

    protected void checkEnable() {
        boolean preFaderEnabled = this.chckbxPreFaderEnabled.isSelected();
        this.lblPreFaderPorts.setEnabled(preFaderEnabled);
        this.lblPreFaderVolume.setEnabled(preFaderEnabled);
        this.volumeControlPanelPreFader.setEnabled(preFaderEnabled);
        this.waxLabPortChooserPreFader.setEnabled(preFaderEnabled);
        boolean postFaderEnabled = this.chckbxPostFaderEnabled.isSelected();
        this.lblPostFaderPorts.setEnabled(postFaderEnabled);
        this.lblPostFaderVolume.setEnabled(postFaderEnabled);
        this.volumeControlPanelPostFader.setEnabled(postFaderEnabled);
        this.waxLabPortChooserPostFader.setEnabled(postFaderEnabled);
        this.jComboBoxPlaybackFile.setEnabled(this.rdbtnAudioFile.isSelected());
        this.jButtonBrowsePlaybackFile.setEnabled(this.jComboBoxPlaybackFile.isEnabled());
        this.lblLiveFeedPorts.setEnabled(this.rdbtnLiveFeed.isSelected());
        this.waxLabPortChooserLiveFeed.setEnabled(this.rdbtnLiveFeed.isSelected());
        this.textFieldControlPanelResampleCustom.setEnabled(this.rdbtnCustomSampleRate.isSelected());
        this.chckbxBeatCompassView.setEnabled(this.chckbxScratchPositionView.isSelected());
        this.chckbxBeatRadarView.setEnabled(this.chckbxScratchPositionView.isSelected());
        if (this.waxLabLines != null) {
            String scratchModeText = "";
            String scratchModeTip = null;
            Icon scratchModeIcon = null;
            TimecodeFormat tcFormat = (TimecodeFormat)this.comboBoxTimecodeFormat.getSelectedItem();
            if (tcFormat != null) {
                String selScratchMode = String.valueOf(this.comboBoxScratchMode.getSelectedItem());
                int scratchMode = AbstractScratchModeControl.getTimecodeDecoderMode((String)selScratchMode);
                if (!tcFormat.isScratchModeSupported(scratchMode)) {
                    scratchModeText = "Mode not supported by selected timecode format!";
                    scratchModeTip = selScratchMode + " mode is not supported by selected timecode format: " + tcFormat.getName();
                    scratchModeIcon = this.scratchModeWarningIcon;
                }
            } else {
                scratchModeText = "No timecode format selected.";
                scratchModeTip = "Please select the timecode format in the 'Input' tab.";
                scratchModeIcon = this.scratchModeWarningIcon;
            }
            this.lblScratchModeInfo.setText(scratchModeText);
            this.lblScratchModeInfo.setToolTipText(scratchModeTip);
            this.lblScratchModeInfo.setIcon(scratchModeIcon);
        }
        if (this.waxLabLines != null) {
            this.updateAudioFaderInfo();
        }
    }

    private JPanel getJPanelViewOptions() {
        if (this.jPanelViewOptions == null) {
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints35.gridx = 0;
            gridBagConstraints35.anchor = 17;
            gridBagConstraints35.weightx = 1.0;
            gridBagConstraints35.gridy = 2;
            GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
            gridBagConstraints61.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints61.anchor = 17;
            gridBagConstraints61.gridy = 0;
            gridBagConstraints61.fill = 0;
            gridBagConstraints61.weightx = 1.0;
            gridBagConstraints61.gridx = 0;
            this.jPanelViewOptions = new JPanel();
            this.jPanelViewOptions.setLayout(new GridBagLayout());
            this.jPanelViewOptions.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Timecode View Options", 4, 2, null, null));
            this.jPanelViewOptions.add((Component)this.getJCheckBoxInvertedView(), gridBagConstraints61);
            GridBagConstraints gbc_jCheckBoxDisableFaderShading = new GridBagConstraints();
            gbc_jCheckBoxDisableFaderShading.insets = new Insets(4, 4, 5, 5);
            gbc_jCheckBoxDisableFaderShading.gridx = 0;
            gbc_jCheckBoxDisableFaderShading.anchor = 17;
            gbc_jCheckBoxDisableFaderShading.weightx = 1.0;
            gbc_jCheckBoxDisableFaderShading.gridy = 1;
            this.jPanelViewOptions.add((Component)this.getJCheckBoxDisableFaderShading(), gbc_jCheckBoxDisableFaderShading);
            this.jPanelViewOptions.add((Component)this.getJCheckBoxDisableAutoScroll(), gridBagConstraints35);
        }
        return this.jPanelViewOptions;
    }

    private JCheckBox getJCheckBoxInvertedView() {
        if (this.jCheckBoxInvertedView == null) {
            this.jCheckBoxInvertedView = new JCheckBox();
            this.jCheckBoxInvertedView.setText("Inverted Direction");
            this.jCheckBoxInvertedView.setOpaque(false);
            this.jCheckBoxInvertedView.setToolTipText("Inverted view direction ?");
            this.jCheckBoxInvertedView.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxInvertedView;
    }

    private JPanel getJPanelScratchAudioOutput() {
        if (this.jPanelScratchAudioOutput == null) {
            this.jPanelScratchAudioOutput = new JPanel();
            GridBagLayout gbl_jPanelScratchAudioOutput = new GridBagLayout();
            gbl_jPanelScratchAudioOutput.rowHeights = new int[]{0, 0, 0};
            gbl_jPanelScratchAudioOutput.columnWidths = new int[]{0, 0};
            gbl_jPanelScratchAudioOutput.rowWeights = new double[]{0.0, 0.0, 0.0};
            gbl_jPanelScratchAudioOutput.columnWeights = new double[]{0.0, 0.0};
            this.jPanelScratchAudioOutput.setLayout(gbl_jPanelScratchAudioOutput);
            this.jPanelScratchAudioOutput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Scratch Audio Output", 4, 2, null, new Color(51, 51, 51)));
            GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
            gbc_lblNewLabel_2.anchor = 17;
            gbc_lblNewLabel_2.insets = new Insets(4, 4, 5, 5);
            gbc_lblNewLabel_2.gridx = 0;
            gbc_lblNewLabel_2.gridy = 0;
            this.jPanelScratchAudioOutput.add((Component)this.getLblNewLabel_2(), gbc_lblNewLabel_2);
            GridBagConstraints gbc_panel_4 = new GridBagConstraints();
            gbc_panel_4.anchor = 17;
            gbc_panel_4.insets = new Insets(4, 4, 5, 0);
            gbc_panel_4.gridx = 1;
            gbc_panel_4.gridy = 0;
            this.jPanelScratchAudioOutput.add((Component)this.getPanel_4(), gbc_panel_4);
            GridBagConstraints gbc_labelChannels = new GridBagConstraints();
            gbc_labelChannels.insets = new Insets(4, 4, 5, 5);
            gbc_labelChannels.anchor = 17;
            gbc_labelChannels.gridx = 0;
            gbc_labelChannels.gridy = 1;
            this.jPanelScratchAudioOutput.add((Component)this.getLabelChannels(), gbc_labelChannels);
            GridBagConstraints gbc_panel_13 = new GridBagConstraints();
            gbc_panel_13.insets = new Insets(4, 4, 5, 5);
            gbc_panel_13.fill = 1;
            gbc_panel_13.gridx = 1;
            gbc_panel_13.gridy = 1;
            this.jPanelScratchAudioOutput.add((Component)this.getPanel_13(), gbc_panel_13);
            GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
            gbc_lblNewLabel_1.insets = new Insets(4, 4, 5, 5);
            gbc_lblNewLabel_1.anchor = 17;
            gbc_lblNewLabel_1.gridx = 0;
            gbc_lblNewLabel_1.gridy = 2;
            this.jPanelScratchAudioOutput.add((Component)this.getLblNewLabel_1(), gbc_lblNewLabel_1);
            GridBagConstraints gbc_panel_14 = new GridBagConstraints();
            gbc_panel_14.weightx = 1.0;
            gbc_panel_14.insets = new Insets(4, 4, 5, 5);
            gbc_panel_14.fill = 1;
            gbc_panel_14.gridx = 1;
            gbc_panel_14.gridy = 2;
            this.jPanelScratchAudioOutput.add((Component)this.getPanel_14(), gbc_panel_14);
        }
        return this.jPanelScratchAudioOutput;
    }

    private JCheckBox getJCheckBoxDisableFaderShading() {
        if (this.jCheckBoxDisableFaderShading == null) {
            this.jCheckBoxDisableFaderShading = new JCheckBox();
            this.jCheckBoxDisableFaderShading.setText("Disable Fader-Shading");
            this.jCheckBoxDisableFaderShading.setOpaque(false);
            this.jCheckBoxDisableFaderShading.setToolTipText("Disable fader volume shading view ?");
            this.jCheckBoxDisableFaderShading.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxDisableFaderShading;
    }

    public void enableRecording() {
        this.getJCheckBoxRecordingEnabled().setSelected(true);
    }

    public void enableScratching() {
        this.getCheckboxPlaybackScratching().setSelected(false);
        this.getCheckboxRealtimeScratching().setSelected(true);
    }

    private JComboBox getJComboBoxPlaybackFile() {
        if (this.jComboBoxPlaybackFile == null) {
            this.jComboBoxPlaybackFile = new JComboBox();
            this.jComboBoxPlaybackFile.setOpaque(false);
            this.jComboBoxPlaybackFile.setPreferredSize(new Dimension(420, 25));
            this.jComboBoxPlaybackFile.setToolTipText("Audio resource / file");
            this.jComboBoxPlaybackFile.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        File file = null;
                        Object item = TimecodeLineConfigPanel.this.jComboBoxPlaybackFile.getSelectedItem();
                        if (item != null) {
                            String path = String.valueOf(item);
                            file = new File(path);
                        }
                        TimecodeLineConfigPanel.this.setAudioResource((Resource)new FileResource(file));
                    }
                }
            });
        }
        return this.jComboBoxPlaybackFile;
    }

    private JButton getJButtonBrowsePlaybackFile() {
        if (this.jButtonBrowsePlaybackFile == null) {
            this.jButtonBrowsePlaybackFile = new JButton();
            this.jButtonBrowsePlaybackFile.setIcon(new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/button-browse.gif")));
            this.jButtonBrowsePlaybackFile.setToolTipText("Open audio file...");
            this.jButtonBrowsePlaybackFile.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonBrowsePlaybackFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimecodeLineConfigPanel.this.actionBrowsePlaybackFile();
                }
            });
        }
        return this.jButtonBrowsePlaybackFile;
    }

    public Resource getAudioResource() {
        return this.audioResource;
    }

    public void setAudioResource(Resource audioResource) {
        this.audioResource = audioResource;
        this.refresh();
    }

    protected void actionBrowsePlaybackFile() {
        int rc;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        File audioFile = null;
        Resource audioResource = this.getAudioResource();
        if (audioResource != null && audioResource.isFile()) {
            try {
                audioFile = audioResource.getFile();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (audioFile != null) {
            chooser.setSelectedFile(audioFile);
        }
        if ((rc = chooser.showOpenDialog(this)) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.setAudioResource((Resource)new FileResource(file));
    }

    private JCheckBox getJCheckBoxDisableAutoScroll() {
        if (this.jCheckBoxDisableAutoScroll == null) {
            this.jCheckBoxDisableAutoScroll = new JCheckBox();
            this.jCheckBoxDisableAutoScroll.setToolTipText("Disable automatic timecode scrolling ?");
            this.jCheckBoxDisableAutoScroll.setText("Disable Auto-Scrolling");
            this.jCheckBoxDisableAutoScroll.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.jCheckBoxDisableAutoScroll;
    }

    private JLabel getLabelChannels() {
        if (this.labelChannels == null) {
            this.labelChannels = new JLabel("Output Channels:");
            this.labelChannels.setToolTipText("Number of audio channels");
        }
        return this.labelChannels;
    }

    private JComboBox getComboBoxPlayChannels() {
        if (this.comboBoxPlayChannels == null) {
            this.comboBoxPlayChannels = new JComboBox();
            this.comboBoxPlayChannels.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.checkPorts();
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.comboBoxPlayChannels.setOpaque(false);
        }
        return this.comboBoxPlayChannels;
    }

    private JRadioButton getRdbtnLiveFeed() {
        if (this.rdbtnLiveFeed == null) {
            this.rdbtnLiveFeed = new JRadioButton("Live Feed:");
            this.rdbtnLiveFeed.setToolTipText("Live feed from audio input port(s) ?");
            this.rdbtnLiveFeed.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.rdbtnLiveFeed;
    }

    private JRadioButton getRdbtnAudioFile() {
        if (this.rdbtnAudioFile == null) {
            this.rdbtnAudioFile = new JRadioButton("Audio Resource:");
            this.rdbtnAudioFile.setToolTipText("Audio resource / file ?");
            this.rdbtnAudioFile.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.rdbtnAudioFile;
    }

    private JLabel getLblScratchMode() {
        if (this.lblScratchMode == null) {
            this.lblScratchMode = new JLabel("Scratch Mode:");
            this.lblScratchMode.setHorizontalTextPosition(2);
            this.lblScratchMode.setToolTipText("Scratch mode");
        }
        return this.lblScratchMode;
    }

    private JComboBox getComboBoxScratchMode() {
        if (this.comboBoxScratchMode == null) {
            this.comboBoxScratchMode = new JComboBox();
            this.comboBoxScratchMode.setToolTipText("Scratch mode");
            this.comboBoxScratchMode.setOpaque(false);
            this.comboBoxScratchMode.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.comboBoxScratchMode;
    }

    private WaxLabPortChooser getWaxLabPortChooserRec() {
        if (this.waxLabPortChooserRec == null) {
            this.waxLabPortChooserRec = new WaxLabPortChooser();
            this.waxLabPortChooserRec.setOpaque(false);
            this.waxLabPortChooserRec.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.waxLabPortChooserRec;
    }

    private JLabel getLblPostFaderPorts() {
        if (this.lblPostFaderPorts == null) {
            this.lblPostFaderPorts = new JLabel("Output Ports:");
            this.lblPostFaderPorts.setToolTipText("Post-Fader output port(s)");
        }
        return this.lblPostFaderPorts;
    }

    private WaxLabPortChooser getWaxLabPortChooserPostFader() {
        if (this.waxLabPortChooserPostFader == null) {
            this.waxLabPortChooserPostFader = new WaxLabPortChooser();
            this.waxLabPortChooserPostFader.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.waxLabPortChooserPostFader;
    }

    public WaxLabDevice getWaxLabDevice() {
        return this.waxLabDevice;
    }

    public void setWaxLabDevice(WaxLabDevice waxLabDevice) {
        this.waxLabDevice = waxLabDevice;
        this.faderConfigManagerPanel.setDevice((Device)waxLabDevice);
    }

    public WaxLabPortInfo[] getWaxLabPorts() {
        return this.waxLabPorts;
    }

    public void setWaxLabPorts(WaxLabPortInfo[] waxLabPorts) {
        this.waxLabPorts = waxLabPorts;
        LinkedList<WaxLabPortInfo> listAudioInput = new LinkedList<WaxLabPortInfo>();
        LinkedList<WaxLabPortInfo> listAudioOutput = new LinkedList<WaxLabPortInfo>();
        LinkedList<WaxLabPortInfo> listMidiInput = new LinkedList<WaxLabPortInfo>();
        LinkedList<WaxLabPortInfo> listMidiOutput = new LinkedList<WaxLabPortInfo>();
        if (waxLabPorts != null) {
            for (int i = 0; i < waxLabPorts.length; ++i) {
                PortType portType;
                WaxLabPortInfo info = waxLabPorts[i];
                if (info == null || (portType = info.getType()) == null) continue;
                if (portType instanceof AudioInputPortType) {
                    listAudioInput.add(info);
                    continue;
                }
                if (portType instanceof AudioOutputPortType) {
                    listAudioOutput.add(info);
                    continue;
                }
                if (portType instanceof MidiInputPortType) {
                    listMidiInput.add(info);
                    continue;
                }
                if (!(portType instanceof MidiOutputPortType)) continue;
                listMidiOutput.add(info);
            }
        }
        WaxLabPortInfo[] audioInputPorts = listAudioInput.toArray(new WaxLabPortInfo[listAudioInput.size()]);
        WaxLabPortInfo[] audioOutputPorts = listAudioOutput.toArray(new WaxLabPortInfo[listAudioOutput.size()]);
        WaxLabPortInfo[] midiInputPorts = listMidiInput.toArray(new WaxLabPortInfo[listMidiInput.size()]);
        WaxLabPortInfo[] midiOutputPorts = listMidiOutput.toArray(new WaxLabPortInfo[listMidiOutput.size()]);
        this.waxLabPortChooserPostFader.setAvailablePorts(audioOutputPorts);
        this.waxLabPortChooserPreFader.setAvailablePorts(audioOutputPorts);
        this.waxLabPortChooserRec.setAvailablePorts(audioInputPorts);
        this.waxLabPortChooserLiveFeed.setAvailablePorts(audioInputPorts);
        this.waxLabMidiMappingPanel.setAvailablePorts(midiInputPorts);
        this.waxLabMidiTriggerPanel.setAvailablePorts(midiOutputPorts);
        this.waxLabPortChooserTimecodeMidiInput.setAvailablePorts(midiInputPorts);
    }

    protected void checkPorts() {
        int playFrameType = -1;
        Object playFrameTypeitem = this.comboBoxPlayChannels.getSelectedItem();
        if (playFrameTypeitem != null) {
            playFrameType = WaxLabViewUtil.parseFrameType(String.valueOf(playFrameTypeitem));
        }
        int playChannels = -1;
        if (playFrameType >= 0) {
            playChannels = WaxLabXmlUtil.getFrameTypeChannelCount((int)playFrameType);
        }
        if (playChannels < 0) {
            playChannels = 0;
        }
        boolean repaint = false;
        if (playChannels != this.waxLabPortChooserPostFader.getAudioChannelCount()) {
            this.waxLabPortChooserPostFader.setAudioChannelCount(playChannels);
            repaint = true;
        }
        if (playChannels != this.waxLabPortChooserPreFader.getAudioChannelCount()) {
            this.waxLabPortChooserPreFader.setAudioChannelCount(playChannels);
            repaint = true;
        }
        if (playChannels != this.waxLabPortChooserLiveFeed.getAudioChannelCount()) {
            this.waxLabPortChooserLiveFeed.setAudioChannelCount(playChannels);
            repaint = true;
        }
        this.faderConfigManagerPanel.setChannelCount(playChannels);
        if (repaint) {
            this.validate();
            this.repaint();
        }
    }

    public Line[] getWaxLabLines() {
        return this.waxLabLines;
    }

    public void setWaxLabLines(Line[] waxLabLines) {
        this.waxLabLines = waxLabLines;
        this.updateMidiInputLineInfo();
    }

    public TimecodeLine getTimecodeLine() {
        return this.timecodeLine;
    }

    public void setTimecodeLine(TimecodeLine timecodeLine) {
        this.timecodeLine = timecodeLine;
    }

    private WaxLabPortChooser getWaxLabPortChooserLiveFeed() {
        if (this.waxLabPortChooserLiveFeed == null) {
            this.waxLabPortChooserLiveFeed = new WaxLabPortChooser();
            this.waxLabPortChooserLiveFeed.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.waxLabPortChooserLiveFeed;
    }

    public boolean isLiveFeed() {
        return this.liveFeed;
    }

    public void setLiveFeed(boolean liveFeed) {
        if (this.liveFeed == liveFeed) {
            return;
        }
        this.liveFeed = liveFeed;
        this.refresh();
    }

    private JLabel getLblPitch() {
        if (this.lblPitch == null) {
            this.lblPitch = new JLabel("Relative Pitch:");
            this.lblPitch.setToolTipText("Relative pitch factor");
        }
        return this.lblPitch;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(1);
            this.tabbedPane.setTabLayoutPolicy(1);
            this.tabbedPane.addTab("Output  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/export_wiz.gif")), this.getPanelAudioOutputTab(), "Audio output ports");
            this.tabbedPane.addTab("Timecode  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/import_wiz.gif")), this.getPanelScratchInputTab(), "Timecode input ports");
            this.tabbedPane.addTab("MIDI  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/midi_mapping_icon16.png")), this.getPanelMidiPortsTab(), "MIDI control");
            this.tabbedPane.addTab("Scratch  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/timecode_icon.png")), this.getPanelScratchControlTab(), "Scratch control");
            this.tabbedPane.addTab("Fader  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/fader_icon.png")), this.getPanelFaderControlTab(), "Fader control");
            this.tabbedPane.addTab("Track  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/audioline_icon.gif")), this.getPanelTrackSourceTab(), "Track source");
            this.tabbedPane.addTab("View  ", new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/color_icon.gif")), this.getPanelViewOptionsTab(), "View options");
        }
        return this.tabbedPane;
    }

    private JPanel getPanelAudioOutputTab() {
        if (this.panelAudioOutputTab == null) {
            this.panelAudioOutputTab = new JPanel();
            GridBagLayout gbl_panelAudioOutputTab = new GridBagLayout();
            gbl_panelAudioOutputTab.columnWidths = new int[]{0, 0};
            gbl_panelAudioOutputTab.rowHeights = new int[]{0, 0, 0, 0};
            gbl_panelAudioOutputTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelAudioOutputTab.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panelAudioOutputTab.setLayout(gbl_panelAudioOutputTab);
            GridBagConstraints gbc_jPanelScratchAudioOutput = new GridBagConstraints();
            gbc_jPanelScratchAudioOutput.insets = new Insets(4, 4, 5, 5);
            gbc_jPanelScratchAudioOutput.weightx = 1.0;
            gbc_jPanelScratchAudioOutput.fill = 2;
            gbc_jPanelScratchAudioOutput.gridx = 0;
            gbc_jPanelScratchAudioOutput.gridy = 0;
            this.panelAudioOutputTab.add((Component)this.getJPanelScratchAudioOutput(), gbc_jPanelScratchAudioOutput);
            GridBagConstraints gbc_panelPostFaderOutput = new GridBagConstraints();
            gbc_panelPostFaderOutput.insets = new Insets(4, 4, 5, 5);
            gbc_panelPostFaderOutput.fill = 1;
            gbc_panelPostFaderOutput.gridx = 0;
            gbc_panelPostFaderOutput.gridy = 2;
            this.panelAudioOutputTab.add((Component)this.getPanelPostFaderOutput(), gbc_panelPostFaderOutput);
            GridBagConstraints gbc_panelPreFaderOutput = new GridBagConstraints();
            gbc_panelPreFaderOutput.insets = new Insets(4, 4, 5, 5);
            gbc_panelPreFaderOutput.fill = 1;
            gbc_panelPreFaderOutput.gridx = 0;
            gbc_panelPreFaderOutput.gridy = 1;
            this.panelAudioOutputTab.add((Component)this.getPanelPreFaderOutput(), gbc_panelPreFaderOutput);
        }
        return this.panelAudioOutputTab;
    }

    private JPanel getPanelScratchControlTab() {
        if (this.panelScratchControlTab == null) {
            this.panelScratchControlTab = new JPanel();
            GridBagLayout gbl_panelScratchControlTab = new GridBagLayout();
            gbl_panelScratchControlTab.columnWidths = new int[]{0, 0};
            gbl_panelScratchControlTab.rowHeights = new int[]{0, 0};
            gbl_panelScratchControlTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelScratchControlTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelScratchControlTab.setLayout(gbl_panelScratchControlTab);
            GridBagConstraints gbc_panel_7 = new GridBagConstraints();
            gbc_panel_7.weightx = 1.0;
            gbc_panel_7.insets = new Insets(4, 4, 4, 4);
            gbc_panel_7.fill = 1;
            gbc_panel_7.gridx = 0;
            gbc_panel_7.gridy = 0;
            this.panelScratchControlTab.add((Component)this.getPanel_7(), gbc_panel_7);
        }
        return this.panelScratchControlTab;
    }

    private JPanel getPanelScratchControl() {
        if (this.panelScratchControl == null) {
            this.panelScratchControl = new JPanel();
            GridBagLayout gbl_panelScratchControl = new GridBagLayout();
            gbl_panelScratchControl.columnWidths = new int[]{0, 0, 0};
            gbl_panelScratchControl.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
            gbl_panelScratchControl.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelScratchControl.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panelScratchControl.setLayout(gbl_panelScratchControl);
            GridBagConstraints gbc_lblScratchMode = new GridBagConstraints();
            gbc_lblScratchMode.anchor = 17;
            gbc_lblScratchMode.insets = new Insets(4, 4, 5, 5);
            gbc_lblScratchMode.gridx = 0;
            gbc_lblScratchMode.gridy = 0;
            this.panelScratchControl.add((Component)this.getLblScratchMode(), gbc_lblScratchMode);
            GridBagConstraints gbc_panelScratchMode = new GridBagConstraints();
            gbc_panelScratchMode.insets = new Insets(4, 4, 5, 0);
            gbc_panelScratchMode.fill = 1;
            gbc_panelScratchMode.gridx = 1;
            gbc_panelScratchMode.gridy = 0;
            this.panelScratchControl.add((Component)this.getPanelScratchMode(), gbc_panelScratchMode);
            GridBagConstraints gbc_lblPitch = new GridBagConstraints();
            gbc_lblPitch.anchor = 18;
            gbc_lblPitch.insets = new Insets(8, 4, 5, 5);
            gbc_lblPitch.gridx = 0;
            gbc_lblPitch.gridy = 1;
            this.panelScratchControl.add((Component)this.getLblPitch(), gbc_lblPitch);
            GridBagConstraints gbc_pitchControlPanel = new GridBagConstraints();
            gbc_pitchControlPanel.weightx = 1.0;
            gbc_pitchControlPanel.insets = new Insets(4, 4, 5, 0);
            gbc_pitchControlPanel.fill = 1;
            gbc_pitchControlPanel.gridx = 1;
            gbc_pitchControlPanel.gridy = 1;
            this.panelScratchControl.add((Component)this.getPitchControlPanel(), gbc_pitchControlPanel);
            GridBagConstraints gbc_lblCuePoints = new GridBagConstraints();
            gbc_lblCuePoints.anchor = 17;
            gbc_lblCuePoints.insets = new Insets(4, 4, 5, 5);
            gbc_lblCuePoints.gridx = 0;
            gbc_lblCuePoints.gridy = 2;
            this.panelScratchControl.add((Component)this.getLblCuePoints(), gbc_lblCuePoints);
            GridBagConstraints gbc_panelCuePoints = new GridBagConstraints();
            gbc_panelCuePoints.insets = new Insets(4, 4, 5, 0);
            gbc_panelCuePoints.fill = 1;
            gbc_panelCuePoints.gridx = 1;
            gbc_panelCuePoints.gridy = 2;
            this.panelScratchControl.add((Component)this.getPanelCuePoints(), gbc_panelCuePoints);
            GridBagConstraints gbc_lblBeatJump = new GridBagConstraints();
            gbc_lblBeatJump.anchor = 17;
            gbc_lblBeatJump.insets = new Insets(4, 4, 5, 5);
            gbc_lblBeatJump.gridx = 0;
            gbc_lblBeatJump.gridy = 3;
            this.panelScratchControl.add((Component)this.getLblBeatJump(), gbc_lblBeatJump);
            GridBagConstraints gbc_panelBeatJump = new GridBagConstraints();
            gbc_panelBeatJump.insets = new Insets(4, 4, 5, 0);
            gbc_panelBeatJump.fill = 1;
            gbc_panelBeatJump.gridx = 1;
            gbc_panelBeatJump.gridy = 3;
            this.panelScratchControl.add((Component)this.getPanelBeatJump(), gbc_panelBeatJump);
            GridBagConstraints gbc_lblBeatSlicer = new GridBagConstraints();
            gbc_lblBeatSlicer.anchor = 17;
            gbc_lblBeatSlicer.insets = new Insets(4, 4, 5, 5);
            gbc_lblBeatSlicer.gridx = 0;
            gbc_lblBeatSlicer.gridy = 4;
            this.panelScratchControl.add((Component)this.getLblBeatSlicer(), gbc_lblBeatSlicer);
            GridBagConstraints gbc_panelBeatSlicer = new GridBagConstraints();
            gbc_panelBeatSlicer.insets = new Insets(4, 4, 5, 0);
            gbc_panelBeatSlicer.fill = 1;
            gbc_panelBeatSlicer.gridx = 1;
            gbc_panelBeatSlicer.gridy = 4;
            this.panelScratchControl.add((Component)this.getPanelBeatSlicer(), gbc_panelBeatSlicer);
        }
        return this.panelScratchControl;
    }

    private VolumeControlPanel getVolumeControlPanelPreFader() {
        if (this.volumeControlPanelPreFader == null) {
            this.volumeControlPanelPreFader = new VolumeControlPanel();
            this.volumeControlPanelPreFader.setOpaque(false);
        }
        return this.volumeControlPanelPreFader;
    }

    private PitchControlPanel getPitchControlPanel() {
        if (this.pitchControlPanel == null) {
            this.pitchControlPanel = new PitchControlPanel();
            this.pitchControlPanel.setOpaque(false);
            this.pitchControlPanel.setBorder(new EtchedBorder(1, null, null));
        }
        return this.pitchControlPanel;
    }

    private JPanel getPanelTrackSourceTab() {
        if (this.panelTrackSourceTab == null) {
            this.panelTrackSourceTab = new JPanel();
            GridBagLayout gbl_panelTrackSourceTab = new GridBagLayout();
            gbl_panelTrackSourceTab.columnWidths = new int[]{0, 0};
            gbl_panelTrackSourceTab.rowHeights = new int[]{0, 0, 0};
            gbl_panelTrackSourceTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelTrackSourceTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelTrackSourceTab.setLayout(gbl_panelTrackSourceTab);
            GridBagConstraints gbc_panelTrackSource = new GridBagConstraints();
            gbc_panelTrackSource.anchor = 11;
            gbc_panelTrackSource.fill = 2;
            gbc_panelTrackSource.weightx = 1.0;
            gbc_panelTrackSource.insets = new Insets(4, 4, 5, 4);
            gbc_panelTrackSource.gridx = 0;
            gbc_panelTrackSource.gridy = 0;
            this.panelTrackSourceTab.add((Component)this.getPanelTrackSource(), gbc_panelTrackSource);
            GridBagConstraints gbc_panelResampling = new GridBagConstraints();
            gbc_panelResampling.insets = new Insets(4, 4, 5, 4);
            gbc_panelResampling.fill = 1;
            gbc_panelResampling.gridx = 0;
            gbc_panelResampling.gridy = 1;
            this.panelTrackSourceTab.add((Component)this.getPanelResampling(), gbc_panelResampling);
        }
        return this.panelTrackSourceTab;
    }

    private JPanel getPanelTrackSource() {
        if (this.panelTrackSource == null) {
            this.panelTrackSource = new JPanel();
            this.panelTrackSource.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Track Source", 4, 2, null, new Color(51, 51, 51)));
            GridBagLayout gbl_panelTrackSource = new GridBagLayout();
            gbl_panelTrackSource.columnWidths = new int[]{0, 0, 0};
            gbl_panelTrackSource.rowHeights = new int[]{0, 0, 0, 0};
            gbl_panelTrackSource.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelTrackSource.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panelTrackSource.setLayout(gbl_panelTrackSource);
            GridBagConstraints gbc_rdbtnAudioFile = new GridBagConstraints();
            gbc_rdbtnAudioFile.anchor = 17;
            gbc_rdbtnAudioFile.insets = new Insets(4, 4, 5, 5);
            gbc_rdbtnAudioFile.gridx = 0;
            gbc_rdbtnAudioFile.gridy = 0;
            this.panelTrackSource.add((Component)this.getRdbtnAudioFile(), gbc_rdbtnAudioFile);
            GridBagConstraints gbc_panelAudioFile = new GridBagConstraints();
            gbc_panelAudioFile.insets = new Insets(4, 4, 5, 5);
            gbc_panelAudioFile.fill = 1;
            gbc_panelAudioFile.gridx = 1;
            gbc_panelAudioFile.gridy = 0;
            this.panelTrackSource.add((Component)this.getPanelAudioFile(), gbc_panelAudioFile);
            GridBagConstraints gbc_rdbtnAudioBridge = new GridBagConstraints();
            gbc_rdbtnAudioBridge.anchor = 18;
            gbc_rdbtnAudioBridge.insets = new Insets(4, 4, 5, 5);
            gbc_rdbtnAudioBridge.gridx = 0;
            gbc_rdbtnAudioBridge.gridy = 1;
            this.panelTrackSource.add((Component)this.getRdbtnAudioBridge(), gbc_rdbtnAudioBridge);
            GridBagConstraints gbc_panelAudioBridge = new GridBagConstraints();
            gbc_panelAudioBridge.weightx = 1.0;
            gbc_panelAudioBridge.insets = new Insets(4, 4, 5, 5);
            gbc_panelAudioBridge.fill = 1;
            gbc_panelAudioBridge.gridx = 1;
            gbc_panelAudioBridge.gridy = 1;
            this.panelTrackSource.add((Component)this.getPanelAudioBridge(), gbc_panelAudioBridge);
            GridBagConstraints gbc_rdbtnLiveFeed = new GridBagConstraints();
            gbc_rdbtnLiveFeed.anchor = 18;
            gbc_rdbtnLiveFeed.insets = new Insets(4, 4, 5, 5);
            gbc_rdbtnLiveFeed.gridx = 0;
            gbc_rdbtnLiveFeed.gridy = 2;
            this.panelTrackSource.add((Component)this.getRdbtnLiveFeed(), gbc_rdbtnLiveFeed);
            GridBagConstraints gbc_panelLiveFeedPorts = new GridBagConstraints();
            gbc_panelLiveFeedPorts.insets = new Insets(4, 4, 5, 5);
            gbc_panelLiveFeedPorts.weighty = 1.0;
            gbc_panelLiveFeedPorts.weightx = 1.0;
            gbc_panelLiveFeedPorts.fill = 1;
            gbc_panelLiveFeedPorts.gridx = 1;
            gbc_panelLiveFeedPorts.gridy = 2;
            this.panelTrackSource.add((Component)this.getPanelLiveFeedPorts(), gbc_panelLiveFeedPorts);
        }
        return this.panelTrackSource;
    }

    private JPanel getPanelAudioFile() {
        if (this.panelAudioFile == null) {
            this.panelAudioFile = new JPanel();
            GridBagLayout gbl_panelAudioFile = new GridBagLayout();
            gbl_panelAudioFile.columnWidths = new int[]{0, 0, 0};
            gbl_panelAudioFile.rowHeights = new int[]{0, 0};
            gbl_panelAudioFile.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelAudioFile.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelAudioFile.setLayout(gbl_panelAudioFile);
            GridBagConstraints gbc_jComboBoxPlaybackFile = new GridBagConstraints();
            gbc_jComboBoxPlaybackFile.fill = 2;
            gbc_jComboBoxPlaybackFile.weightx = 1.0;
            gbc_jComboBoxPlaybackFile.insets = new Insets(0, 0, 0, 5);
            gbc_jComboBoxPlaybackFile.gridx = 0;
            gbc_jComboBoxPlaybackFile.gridy = 0;
            this.panelAudioFile.add((Component)this.getJComboBoxPlaybackFile(), gbc_jComboBoxPlaybackFile);
            GridBagConstraints gbc_jButtonBrowsePlaybackFile = new GridBagConstraints();
            gbc_jButtonBrowsePlaybackFile.gridx = 1;
            gbc_jButtonBrowsePlaybackFile.gridy = 0;
            this.panelAudioFile.add((Component)this.getJButtonBrowsePlaybackFile(), gbc_jButtonBrowsePlaybackFile);
        }
        return this.panelAudioFile;
    }

    private JPanel getPanelViewOptionsTab() {
        if (this.panelViewOptionsTab == null) {
            this.panelViewOptionsTab = new JPanel();
            GridBagLayout gbl_panelViewOptionsTab = new GridBagLayout();
            gbl_panelViewOptionsTab.columnWidths = new int[]{0, 0};
            gbl_panelViewOptionsTab.rowHeights = new int[]{0, 0, 0};
            gbl_panelViewOptionsTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelViewOptionsTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelViewOptionsTab.setLayout(gbl_panelViewOptionsTab);
            GridBagConstraints gbc_jPanelViewOptions = new GridBagConstraints();
            gbc_jPanelViewOptions.insets = new Insets(4, 4, 5, 4);
            gbc_jPanelViewOptions.fill = 2;
            gbc_jPanelViewOptions.weightx = 1.0;
            gbc_jPanelViewOptions.gridx = 0;
            gbc_jPanelViewOptions.gridy = 0;
            this.panelViewOptionsTab.add((Component)this.getJPanelViewOptions(), gbc_jPanelViewOptions);
            GridBagConstraints gbc_panel_6 = new GridBagConstraints();
            gbc_panel_6.insets = new Insets(4, 4, 5, 4);
            gbc_panel_6.fill = 1;
            gbc_panel_6.gridx = 0;
            gbc_panel_6.gridy = 1;
            this.panelViewOptionsTab.add((Component)this.getPanel_6(), gbc_panel_6);
        }
        return this.panelViewOptionsTab;
    }

    private JPanel getPanel_10() {
        if (this.panel_10 == null) {
            this.panel_10 = new JPanel();
            this.panel_10.setOpaque(false);
            GridBagLayout gbl_panel_10 = new GridBagLayout();
            gbl_panel_10.columnWidths = new int[]{0, 0};
            gbl_panel_10.rowHeights = new int[]{0, 0, 0};
            gbl_panel_10.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_10.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panel_10.setLayout(gbl_panel_10);
            GridBagConstraints gbc_lblLeftInputPort = new GridBagConstraints();
            gbc_lblLeftInputPort.weighty = 1.0;
            gbc_lblLeftInputPort.anchor = 17;
            gbc_lblLeftInputPort.insets = new Insets(4, 0, 4, 4);
            gbc_lblLeftInputPort.gridx = 0;
            gbc_lblLeftInputPort.gridy = 0;
            this.panel_10.add((Component)this.getLblLeftInputPort(), gbc_lblLeftInputPort);
            GridBagConstraints gbc_lblRightInputPort = new GridBagConstraints();
            gbc_lblRightInputPort.weighty = 1.0;
            gbc_lblRightInputPort.anchor = 17;
            gbc_lblRightInputPort.insets = new Insets(4, 0, 4, 4);
            gbc_lblRightInputPort.gridx = 0;
            gbc_lblRightInputPort.gridy = 1;
            this.panel_10.add((Component)this.getLblRightInputPort(), gbc_lblRightInputPort);
        }
        return this.panel_10;
    }

    private JLabel getLblLeftInputPort() {
        if (this.lblLeftInputPort == null) {
            this.lblLeftInputPort = new JLabel("Left Input Port:");
            this.lblLeftInputPort.setToolTipText("Timecode audio input port (left channel)");
            this.lblLeftInputPort.setIcon(null);
        }
        return this.lblLeftInputPort;
    }

    private JLabel getLblRightInputPort() {
        if (this.lblRightInputPort == null) {
            this.lblRightInputPort = new JLabel("Right Input Port:");
            this.lblRightInputPort.setToolTipText("Timecode audio input port (right channel)");
            this.lblRightInputPort.setIcon(null);
        }
        return this.lblRightInputPort;
    }

    private JCheckBox getCheckboxRealtimeScratching() {
        if (this.checkboxRealtimeScratching == null) {
            this.checkboxRealtimeScratching = new JCheckBox("Realtime");
            this.checkboxRealtimeScratching.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        if (e.getStateChange() == 1 && TimecodeLineConfigPanel.this.checkboxPlaybackScratching.isSelected()) {
                            TimecodeLineConfigPanel.this.checkboxPlaybackScratching.setSelected(false);
                        }
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.checkboxRealtimeScratching.setToolTipText("Realtime scratching using timecode input ?");
        }
        return this.checkboxRealtimeScratching;
    }

    private JPanel getPanel_4() {
        if (this.panel_4 == null) {
            this.panel_4 = new JPanel();
            GridBagLayout gbl_panel_4 = new GridBagLayout();
            gbl_panel_4.columnWidths = new int[]{0, 0, 0};
            gbl_panel_4.rowHeights = new int[]{0, 0};
            gbl_panel_4.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_4.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_4.setLayout(gbl_panel_4);
            GridBagConstraints gbc_checkboxRealtimeScratching = new GridBagConstraints();
            gbc_checkboxRealtimeScratching.insets = new Insets(0, 0, 0, 5);
            gbc_checkboxRealtimeScratching.anchor = 17;
            gbc_checkboxRealtimeScratching.gridx = 0;
            gbc_checkboxRealtimeScratching.gridy = 0;
            this.panel_4.add((Component)this.getCheckboxRealtimeScratching(), gbc_checkboxRealtimeScratching);
            GridBagConstraints gbc_checkboxPlaybackScratching = new GridBagConstraints();
            gbc_checkboxPlaybackScratching.anchor = 17;
            gbc_checkboxPlaybackScratching.gridx = 1;
            gbc_checkboxPlaybackScratching.gridy = 0;
            this.panel_4.add((Component)this.getCheckboxPlaybackScratching(), gbc_checkboxPlaybackScratching);
        }
        return this.panel_4;
    }

    private JCheckBox getCheckboxPlaybackScratching() {
        if (this.checkboxPlaybackScratching == null) {
            this.checkboxPlaybackScratching = new JCheckBox("Playback");
            this.checkboxPlaybackScratching.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        if (e.getStateChange() == 1 && TimecodeLineConfigPanel.this.checkboxRealtimeScratching.isSelected()) {
                            TimecodeLineConfigPanel.this.checkboxRealtimeScratching.setSelected(false);
                        }
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.checkboxPlaybackScratching.setToolTipText("Playback timecode model ?");
        }
        return this.checkboxPlaybackScratching;
    }

    private JLabel getLblBeatJump() {
        if (this.lblBeatJump == null) {
            this.lblBeatJump = new JLabel("Beat Jump:");
            this.lblBeatJump.setToolTipText("Beat jump");
        }
        return this.lblBeatJump;
    }

    private JPanel getPanelBeatJump() {
        if (this.panelBeatJump == null) {
            this.panelBeatJump = new JPanel();
            this.panelBeatJump.setOpaque(false);
            GridBagLayout gbl_panelBeatJump = new GridBagLayout();
            gbl_panelBeatJump.columnWidths = new int[]{0, 0, 0};
            gbl_panelBeatJump.rowHeights = new int[]{0, 0};
            gbl_panelBeatJump.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelBeatJump.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelBeatJump.setLayout(gbl_panelBeatJump);
            GridBagConstraints gbc_comboBoxBeatJump = new GridBagConstraints();
            gbc_comboBoxBeatJump.insets = new Insets(0, 0, 0, 5);
            gbc_comboBoxBeatJump.fill = 2;
            gbc_comboBoxBeatJump.gridx = 0;
            gbc_comboBoxBeatJump.gridy = 0;
            this.panelBeatJump.add((Component)this.getComboBoxBeatJump(), gbc_comboBoxBeatJump);
            GridBagConstraints gbc_lblJumpBeats = new GridBagConstraints();
            gbc_lblJumpBeats.gridx = 1;
            gbc_lblJumpBeats.gridy = 0;
            this.panelBeatJump.add((Component)this.getLblJumpBeats(), gbc_lblJumpBeats);
        }
        return this.panelBeatJump;
    }

    private JComboBox getComboBoxBeatJump() {
        if (this.comboBoxBeatJump == null) {
            this.comboBoxBeatJump = new JComboBox();
            this.comboBoxBeatJump.setToolTipText("Number of beat(s) to jump");
            this.comboBoxBeatJump.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.comboBoxBeatJump;
    }

    private JLabel getLblJumpBeats() {
        if (this.lblJumpBeats == null) {
            this.lblJumpBeats = new JLabel("beat(s)");
        }
        return this.lblJumpBeats;
    }

    private JLabel getLblCuePoints() {
        if (this.lblCuePoints == null) {
            this.lblCuePoints = new JLabel("Cue Points:");
            this.lblCuePoints.setToolTipText("Cue points");
        }
        return this.lblCuePoints;
    }

    private JPanel getPanelCuePoints() {
        if (this.panelCuePoints == null) {
            this.panelCuePoints = new JPanel();
            this.panelCuePoints.setOpaque(false);
            GridBagLayout gbl_panelCuePoints = new GridBagLayout();
            gbl_panelCuePoints.columnWidths = new int[]{0, 0};
            gbl_panelCuePoints.rowHeights = new int[]{0, 0};
            gbl_panelCuePoints.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelCuePoints.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelCuePoints.setLayout(gbl_panelCuePoints);
            GridBagConstraints gbc_comboBoxCuePoints = new GridBagConstraints();
            gbc_comboBoxCuePoints.fill = 2;
            gbc_comboBoxCuePoints.gridx = 0;
            gbc_comboBoxCuePoints.gridy = 0;
            this.panelCuePoints.add((Component)this.getComboBoxCuePoints(), gbc_comboBoxCuePoints);
        }
        return this.panelCuePoints;
    }

    private JComboBox getComboBoxCuePoints() {
        if (this.comboBoxCuePoints == null) {
            this.comboBoxCuePoints = new JComboBox();
            this.comboBoxCuePoints.setToolTipText("Number of cue points");
            this.comboBoxCuePoints.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.comboBoxCuePoints;
    }

    private JPanel getPanelResampling() {
        if (this.panelResampling == null) {
            this.panelResampling = new JPanel();
            this.panelResampling.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Audio Resampling", 4, 2, null, new Color(51, 51, 51)));
            GridBagLayout gbl_panelResampling = new GridBagLayout();
            gbl_panelResampling.columnWidths = new int[]{0, 0, 0, 0};
            gbl_panelResampling.rowHeights = new int[]{0, 0, 0, 0};
            gbl_panelResampling.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panelResampling.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
            this.panelResampling.setLayout(gbl_panelResampling);
            GridBagConstraints gbc_rdbtnOutputSampleRate = new GridBagConstraints();
            gbc_rdbtnOutputSampleRate.anchor = 17;
            gbc_rdbtnOutputSampleRate.insets = new Insets(4, 4, 0, 5);
            gbc_rdbtnOutputSampleRate.gridx = 0;
            gbc_rdbtnOutputSampleRate.gridy = 0;
            this.panelResampling.add((Component)this.getRdbtnOutputSampleRate(), gbc_rdbtnOutputSampleRate);
            GridBagConstraints gbc_rdbtnSourceSampleRate = new GridBagConstraints();
            gbc_rdbtnSourceSampleRate.anchor = 17;
            gbc_rdbtnSourceSampleRate.insets = new Insets(4, 4, 0, 5);
            gbc_rdbtnSourceSampleRate.gridx = 0;
            gbc_rdbtnSourceSampleRate.gridy = 1;
            this.panelResampling.add((Component)this.getRdbtnSourceSampleRate(), gbc_rdbtnSourceSampleRate);
            GridBagConstraints gbc_rdbtnCustomSampleRate = new GridBagConstraints();
            gbc_rdbtnCustomSampleRate.anchor = 17;
            gbc_rdbtnCustomSampleRate.insets = new Insets(4, 4, 5, 5);
            gbc_rdbtnCustomSampleRate.gridx = 0;
            gbc_rdbtnCustomSampleRate.gridy = 2;
            this.panelResampling.add((Component)this.getRdbtnCustomSampleRate(), gbc_rdbtnCustomSampleRate);
            GridBagConstraints gbc_textFieldControlPanelResampleCustom = new GridBagConstraints();
            gbc_textFieldControlPanelResampleCustom.insets = new Insets(0, 0, 0, 5);
            gbc_textFieldControlPanelResampleCustom.fill = 2;
            gbc_textFieldControlPanelResampleCustom.gridx = 1;
            gbc_textFieldControlPanelResampleCustom.gridy = 2;
            this.panelResampling.add((Component)this.getTextFieldControlPanelResampleCustom(), gbc_textFieldControlPanelResampleCustom);
            GridBagConstraints gbc_lblHz = new GridBagConstraints();
            gbc_lblHz.gridx = 2;
            gbc_lblHz.gridy = 2;
            this.panelResampling.add((Component)this.getLblHz(), gbc_lblHz);
        }
        return this.panelResampling;
    }

    private JRadioButton getRdbtnOutputSampleRate() {
        if (this.rdbtnOutputSampleRate == null) {
            this.rdbtnOutputSampleRate = new JRadioButton("Output sample rate");
            this.rdbtnOutputSampleRate.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.rdbtnOutputSampleRate.setToolTipText("Resampling to output sample rate (default)");
        }
        return this.rdbtnOutputSampleRate;
    }

    private JRadioButton getRdbtnSourceSampleRate() {
        if (this.rdbtnSourceSampleRate == null) {
            this.rdbtnSourceSampleRate = new JRadioButton("Source sample rate");
            this.rdbtnSourceSampleRate.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.rdbtnSourceSampleRate.setToolTipText("Keep source sample rate (no resampling)");
        }
        return this.rdbtnSourceSampleRate;
    }

    private JRadioButton getRdbtnCustomSampleRate() {
        if (this.rdbtnCustomSampleRate == null) {
            this.rdbtnCustomSampleRate = new JRadioButton("Custom sample rate:");
            this.rdbtnCustomSampleRate.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.rdbtnCustomSampleRate.setToolTipText("Custom sample rate (e.g. over-sampling)");
        }
        return this.rdbtnCustomSampleRate;
    }

    private TextFieldControlPanel getTextFieldControlPanelResampleCustom() {
        if (this.textFieldControlPanelResampleCustom == null) {
            this.textFieldControlPanelResampleCustom = new TextFieldControlPanel();
            this.textFieldControlPanelResampleCustom.setColumns(10);
        }
        return this.textFieldControlPanelResampleCustom;
    }

    private JLabel getLblHz() {
        if (this.lblHz == null) {
            this.lblHz = new JLabel("Hz.");
        }
        return this.lblHz;
    }

    private JPanel getPanel_6() {
        if (this.panel_6 == null) {
            this.panel_6 = new JPanel();
            this.panel_6.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Scratch Position View Options", 4, 2, null, null));
            GridBagLayout gbl_panel_6 = new GridBagLayout();
            gbl_panel_6.columnWidths = new int[]{0, 0};
            gbl_panel_6.rowHeights = new int[]{0, 0, 0, 0};
            gbl_panel_6.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_6.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panel_6.setLayout(gbl_panel_6);
            GridBagConstraints gbc_chckbxScratchPositionView = new GridBagConstraints();
            gbc_chckbxScratchPositionView.anchor = 17;
            gbc_chckbxScratchPositionView.insets = new Insets(4, 4, 5, 5);
            gbc_chckbxScratchPositionView.gridx = 0;
            gbc_chckbxScratchPositionView.gridy = 0;
            this.panel_6.add((Component)this.getChckbxScratchPositionView(), gbc_chckbxScratchPositionView);
            GridBagConstraints gbc_chckbxBeatCompassView = new GridBagConstraints();
            gbc_chckbxBeatCompassView.anchor = 17;
            gbc_chckbxBeatCompassView.insets = new Insets(4, 4, 5, 5);
            gbc_chckbxBeatCompassView.gridx = 0;
            gbc_chckbxBeatCompassView.gridy = 2;
            this.panel_6.add((Component)this.getChckbxBeatCompassView(), gbc_chckbxBeatCompassView);
            GridBagConstraints gbc_chckbxBeatRadarView = new GridBagConstraints();
            gbc_chckbxBeatRadarView.insets = new Insets(4, 4, 5, 5);
            gbc_chckbxBeatRadarView.anchor = 17;
            gbc_chckbxBeatRadarView.gridx = 0;
            gbc_chckbxBeatRadarView.gridy = 1;
            this.panel_6.add((Component)this.getChckbxBeatRadarView(), gbc_chckbxBeatRadarView);
        }
        return this.panel_6;
    }

    private JCheckBox getChckbxScratchPositionView() {
        if (this.chckbxScratchPositionView == null) {
            this.chckbxScratchPositionView = new JCheckBox("Scratch Position View");
            this.chckbxScratchPositionView.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.chckbxScratchPositionView;
    }

    private JCheckBox getChckbxBeatCompassView() {
        if (this.chckbxBeatCompassView == null) {
            this.chckbxBeatCompassView = new JCheckBox("Beat Compass View");
            this.chckbxBeatCompassView.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.chckbxBeatCompassView;
    }

    private JCheckBox getChckbxBeatRadarView() {
        if (this.chckbxBeatRadarView == null) {
            this.chckbxBeatRadarView = new JCheckBox("Beat Radar View");
            this.chckbxBeatRadarView.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.chckbxBeatRadarView;
    }

    private JPanel getPanel_7() {
        if (this.panel_7 == null) {
            this.panel_7 = new JPanel();
            this.panel_7.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Scratch Control", 4, 2, null, null));
            GridBagLayout gbl_panel_7 = new GridBagLayout();
            gbl_panel_7.columnWidths = new int[]{0, 0};
            gbl_panel_7.rowHeights = new int[]{0, 0};
            gbl_panel_7.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_7.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_7.setLayout(gbl_panel_7);
            GridBagConstraints gbc_panelScratchControl = new GridBagConstraints();
            gbc_panelScratchControl.weightx = 1.0;
            gbc_panelScratchControl.weighty = 1.0;
            gbc_panelScratchControl.insets = new Insets(0, 0, 4, 4);
            gbc_panelScratchControl.anchor = 11;
            gbc_panelScratchControl.fill = 2;
            gbc_panelScratchControl.gridx = 0;
            gbc_panelScratchControl.gridy = 0;
            this.panel_7.add((Component)this.getPanelScratchControl(), gbc_panelScratchControl);
        }
        return this.panel_7;
    }

    private JPanel getPanelMidiPortsTab() {
        if (this.panelMidiPortsTab == null) {
            this.panelMidiPortsTab = new JPanel();
            GridBagLayout gbl_panelMidiPortsTab = new GridBagLayout();
            gbl_panelMidiPortsTab.columnWidths = new int[]{0, 0};
            gbl_panelMidiPortsTab.rowHeights = new int[]{0, 0, 0};
            gbl_panelMidiPortsTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelMidiPortsTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelMidiPortsTab.setLayout(gbl_panelMidiPortsTab);
            GridBagConstraints gbc_panelMidiInput = new GridBagConstraints();
            gbc_panelMidiInput.insets = new Insets(4, 4, 5, 4);
            gbc_panelMidiInput.weightx = 1.0;
            gbc_panelMidiInput.fill = 2;
            gbc_panelMidiInput.gridx = 0;
            gbc_panelMidiInput.gridy = 0;
            this.panelMidiPortsTab.add((Component)this.getPanelMidiInput(), gbc_panelMidiInput);
            GridBagConstraints gbc_panelMidiOutput = new GridBagConstraints();
            gbc_panelMidiOutput.weightx = 1.0;
            gbc_panelMidiOutput.insets = new Insets(4, 4, 0, 4);
            gbc_panelMidiOutput.fill = 1;
            gbc_panelMidiOutput.gridx = 0;
            gbc_panelMidiOutput.gridy = 1;
            this.panelMidiPortsTab.add((Component)this.getPanelMidiOutput(), gbc_panelMidiOutput);
        }
        return this.panelMidiPortsTab;
    }

    private JPanel getPanelMidiInput() {
        if (this.panelMidiInput == null) {
            this.panelMidiInput = new JPanel();
            this.panelMidiInput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Input", 4, 2, null, new Color(51, 51, 51)));
            GridBagLayout gbl_panelMidiInput = new GridBagLayout();
            gbl_panelMidiInput.columnWidths = new int[]{0, 0};
            gbl_panelMidiInput.rowHeights = new int[]{0, 0};
            gbl_panelMidiInput.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelMidiInput.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelMidiInput.setLayout(gbl_panelMidiInput);
            GridBagConstraints gbc_waxLabMidiMappingPanel = new GridBagConstraints();
            gbc_waxLabMidiMappingPanel.weightx = 1.0;
            gbc_waxLabMidiMappingPanel.fill = 1;
            gbc_waxLabMidiMappingPanel.gridx = 0;
            gbc_waxLabMidiMappingPanel.gridy = 0;
            this.panelMidiInput.add((Component)this.getWaxLabMidiMappingPanel(), gbc_waxLabMidiMappingPanel);
        }
        return this.panelMidiInput;
    }

    private JPanel getPanelMidiOutput() {
        if (this.panelMidiOutput == null) {
            this.panelMidiOutput = new JPanel();
            this.panelMidiOutput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Output", 4, 2, null, null));
            GridBagLayout gbl_panelMidiOutput = new GridBagLayout();
            gbl_panelMidiOutput.columnWidths = new int[]{0, 0};
            gbl_panelMidiOutput.rowHeights = new int[]{0, 0};
            gbl_panelMidiOutput.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelMidiOutput.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelMidiOutput.setLayout(gbl_panelMidiOutput);
            GridBagConstraints gbc_waxLabMidiTriggerPanel = new GridBagConstraints();
            gbc_waxLabMidiTriggerPanel.weightx = 1.0;
            gbc_waxLabMidiTriggerPanel.fill = 1;
            gbc_waxLabMidiTriggerPanel.gridx = 0;
            gbc_waxLabMidiTriggerPanel.gridy = 0;
            this.panelMidiOutput.add((Component)this.getWaxLabMidiTriggerPanel(), gbc_waxLabMidiTriggerPanel);
        }
        return this.panelMidiOutput;
    }

    private JPanel getPanelScratchInputTab() {
        if (this.panelScratchInputTab == null) {
            this.panelScratchInputTab = new JPanel();
            GridBagLayout gbl_panelScratchInputTab = new GridBagLayout();
            gbl_panelScratchInputTab.columnWidths = new int[]{0, 0};
            gbl_panelScratchInputTab.rowHeights = new int[]{0, 0, 0, 0};
            gbl_panelScratchInputTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelScratchInputTab.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panelScratchInputTab.setLayout(gbl_panelScratchInputTab);
            GridBagConstraints gbc_panelTimecodeInput = new GridBagConstraints();
            gbc_panelTimecodeInput.insets = new Insets(4, 4, 5, 4);
            gbc_panelTimecodeInput.fill = 1;
            gbc_panelTimecodeInput.gridx = 0;
            gbc_panelTimecodeInput.gridy = 0;
            this.panelScratchInputTab.add((Component)this.getPanelTimecodeInput(), gbc_panelTimecodeInput);
            GridBagConstraints gbc_jPanelTimecodeAudioInput = new GridBagConstraints();
            gbc_jPanelTimecodeAudioInput.fill = 2;
            gbc_jPanelTimecodeAudioInput.weightx = 1.0;
            gbc_jPanelTimecodeAudioInput.insets = new Insets(4, 4, 5, 4);
            gbc_jPanelTimecodeAudioInput.gridx = 0;
            gbc_jPanelTimecodeAudioInput.gridy = 1;
            this.panelScratchInputTab.add((Component)this.getJPanelTimecodeAudioInput(), gbc_jPanelTimecodeAudioInput);
            GridBagConstraints gbc_panelTimecodeMidiInput = new GridBagConstraints();
            gbc_panelTimecodeMidiInput.weightx = 1.0;
            gbc_panelTimecodeMidiInput.insets = new Insets(4, 4, 0, 4);
            gbc_panelTimecodeMidiInput.fill = 1;
            gbc_panelTimecodeMidiInput.gridx = 0;
            gbc_panelTimecodeMidiInput.gridy = 2;
            this.panelScratchInputTab.add((Component)this.getPanelTimecodeMidiInput(), gbc_panelTimecodeMidiInput);
        }
        return this.panelScratchInputTab;
    }

    private JPanel getPanelScratchMode() {
        if (this.panelScratchMode == null) {
            this.panelScratchMode = new JPanel();
            this.panelScratchMode.setOpaque(false);
            GridBagLayout gbl_panelScratchMode = new GridBagLayout();
            gbl_panelScratchMode.columnWidths = new int[]{0, 0, 0};
            gbl_panelScratchMode.rowHeights = new int[]{0, 0};
            gbl_panelScratchMode.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelScratchMode.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelScratchMode.setLayout(gbl_panelScratchMode);
            GridBagConstraints gbc_comboBoxScratchMode = new GridBagConstraints();
            gbc_comboBoxScratchMode.insets = new Insets(0, 0, 0, 5);
            gbc_comboBoxScratchMode.gridx = 0;
            gbc_comboBoxScratchMode.gridy = 0;
            this.panelScratchMode.add((Component)this.getComboBoxScratchMode(), gbc_comboBoxScratchMode);
            GridBagConstraints gbc_lblScratchModeInfo = new GridBagConstraints();
            gbc_lblScratchModeInfo.insets = new Insets(0, 8, 0, 0);
            gbc_lblScratchModeInfo.fill = 2;
            gbc_lblScratchModeInfo.weightx = 1.0;
            gbc_lblScratchModeInfo.gridx = 1;
            gbc_lblScratchModeInfo.gridy = 0;
            this.panelScratchMode.add((Component)this.getLabel_1_1(), gbc_lblScratchModeInfo);
        }
        return this.panelScratchMode;
    }

    private JPanel getPanelTimecodeMidiInput() {
        if (this.panelTimecodeMidiInput == null) {
            this.panelTimecodeMidiInput = new JPanel();
            this.panelTimecodeMidiInput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Timecode MIDI Input", 4, 2, null, null));
            GridBagLayout gbl_panelTimecodeMidiInput = new GridBagLayout();
            gbl_panelTimecodeMidiInput.columnWidths = new int[]{0, 0};
            gbl_panelTimecodeMidiInput.rowHeights = new int[]{0, 0};
            gbl_panelTimecodeMidiInput.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelTimecodeMidiInput.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelTimecodeMidiInput.setLayout(gbl_panelTimecodeMidiInput);
            GridBagConstraints gbc_panel_5 = new GridBagConstraints();
            gbc_panel_5.insets = new Insets(4, 4, 4, 4);
            gbc_panel_5.weighty = 1.0;
            gbc_panel_5.weightx = 1.0;
            gbc_panel_5.fill = 1;
            gbc_panel_5.gridx = 0;
            gbc_panel_5.gridy = 0;
            this.panelTimecodeMidiInput.add((Component)this.getPanel_5(), gbc_panel_5);
        }
        return this.panelTimecodeMidiInput;
    }

    private JPanel getPanel_5() {
        if (this.panel_5 == null) {
            this.panel_5 = new JPanel();
            GridBagLayout gbl_panel_5 = new GridBagLayout();
            gbl_panel_5.columnWidths = new int[]{0, 0, 0};
            gbl_panel_5.rowHeights = new int[]{0, 0};
            gbl_panel_5.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_5.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_5.setLayout(gbl_panel_5);
            GridBagConstraints gbc_lblMidiInputPort_1 = new GridBagConstraints();
            gbc_lblMidiInputPort_1.anchor = 17;
            gbc_lblMidiInputPort_1.insets = new Insets(4, 0, 5, 5);
            gbc_lblMidiInputPort_1.gridx = 0;
            gbc_lblMidiInputPort_1.gridy = 0;
            this.panel_5.add((Component)this.getLblMidiInputPort_1(), gbc_lblMidiInputPort_1);
            GridBagConstraints gbc_waxLabPortChooserTimecodeMidiInput = new GridBagConstraints();
            gbc_waxLabPortChooserTimecodeMidiInput.weightx = 1.0;
            gbc_waxLabPortChooserTimecodeMidiInput.insets = new Insets(4, 4, 5, 5);
            gbc_waxLabPortChooserTimecodeMidiInput.fill = 1;
            gbc_waxLabPortChooserTimecodeMidiInput.gridx = 1;
            gbc_waxLabPortChooserTimecodeMidiInput.gridy = 0;
            this.panel_5.add((Component)this.getWaxLabPortChooserTimecodeMidiInput(), gbc_waxLabPortChooserTimecodeMidiInput);
        }
        return this.panel_5;
    }

    private JLabel getLblMidiInputPort_1() {
        if (this.lblMidiInputPort_1 == null) {
            this.lblMidiInputPort_1 = new JLabel("MIDI Input Port:");
            this.lblMidiInputPort_1.setToolTipText("Timecode MIDI input port");
        }
        return this.lblMidiInputPort_1;
    }

    private WaxLabPortChooser getWaxLabPortChooserTimecodeMidiInput() {
        if (this.waxLabPortChooserTimecodeMidiInput == null) {
            this.waxLabPortChooserTimecodeMidiInput = new WaxLabPortChooser();
            this.waxLabPortChooserTimecodeMidiInput.setAudioChannelCount(1);
        }
        return this.waxLabPortChooserTimecodeMidiInput;
    }

    private CommonLineConfigPanel getCommonLineConfigPanel() {
        if (this.commonLineConfigPanel == null) {
            this.commonLineConfigPanel = new CommonLineConfigPanel();
        }
        return this.commonLineConfigPanel;
    }

    private JPanel getPanelTimecodeFormat() {
        if (this.panelTimecodeFormat == null) {
            this.panelTimecodeFormat = new JPanel();
            this.panelTimecodeFormat.setOpaque(false);
            GridBagLayout gbl_panelTimecodeFormat = new GridBagLayout();
            gbl_panelTimecodeFormat.columnWidths = new int[]{0, 0};
            gbl_panelTimecodeFormat.rowHeights = new int[]{0, 0};
            gbl_panelTimecodeFormat.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelTimecodeFormat.rowWeights = new double[]{Double.MIN_VALUE, Double.MIN_VALUE};
            this.panelTimecodeFormat.setLayout(gbl_panelTimecodeFormat);
            GridBagConstraints gbc_comboBoxTimecodeFormat = new GridBagConstraints();
            gbc_comboBoxTimecodeFormat.fill = 2;
            gbc_comboBoxTimecodeFormat.anchor = 17;
            gbc_comboBoxTimecodeFormat.gridx = 0;
            gbc_comboBoxTimecodeFormat.gridy = 0;
            this.panelTimecodeFormat.add((Component)this.getComboBoxTimecodeFormat(), gbc_comboBoxTimecodeFormat);
        }
        return this.panelTimecodeFormat;
    }

    private JComboBox getComboBoxTimecodeFormat() {
        if (this.comboBoxTimecodeFormat == null) {
            this.comboBoxTimecodeFormat = new JComboBox();
            this.comboBoxTimecodeFormat.setToolTipText("Timecode Format");
            this.comboBoxTimecodeFormat.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.comboBoxTimecodeFormat.setOpaque(false);
        }
        return this.comboBoxTimecodeFormat;
    }

    private JPanel getPanelFaderControlTab() {
        if (this.panelFaderControlTab == null) {
            this.panelFaderControlTab = new JPanel();
            GridBagLayout gbl_panelFaderControlTab = new GridBagLayout();
            gbl_panelFaderControlTab.columnWidths = new int[]{0, 0};
            gbl_panelFaderControlTab.rowHeights = new int[]{0, 0, 0};
            gbl_panelFaderControlTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelFaderControlTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelFaderControlTab.setLayout(gbl_panelFaderControlTab);
            GridBagConstraints gbc_faderConfigManagerPanel = new GridBagConstraints();
            gbc_faderConfigManagerPanel.insets = new Insets(4, 4, 5, 4);
            gbc_faderConfigManagerPanel.weighty = 1.0;
            gbc_faderConfigManagerPanel.weightx = 1.0;
            gbc_faderConfigManagerPanel.fill = 1;
            gbc_faderConfigManagerPanel.gridx = 0;
            gbc_faderConfigManagerPanel.gridy = 1;
            this.panelFaderControlTab.add((Component)this.getFaderConfigManagerPanel(), gbc_faderConfigManagerPanel);
            GridBagConstraints gbc_panelFaderMidiLine = new GridBagConstraints();
            gbc_panelFaderMidiLine.insets = new Insets(4, 4, 4, 4);
            gbc_panelFaderMidiLine.fill = 1;
            gbc_panelFaderMidiLine.gridx = 0;
            gbc_panelFaderMidiLine.gridy = 0;
            this.panelFaderControlTab.add((Component)this.getPanelFaderMidiLine(), gbc_panelFaderMidiLine);
        }
        return this.panelFaderControlTab;
    }

    private FaderConfigManagerPanel getFaderConfigManagerPanel() {
        if (this.faderConfigManagerPanel == null) {
            this.faderConfigManagerPanel = new FaderConfigManagerPanel();
        }
        return this.faderConfigManagerPanel;
    }

    private JPanel getPanelMidiInputLine() {
        if (this.panelMidiInputLine == null) {
            this.panelMidiInputLine = new JPanel();
            this.panelMidiInputLine.setOpaque(false);
            GridBagLayout gbl_panelMidiInputLine = new GridBagLayout();
            gbl_panelMidiInputLine.columnWidths = new int[]{0, 0, 0};
            gbl_panelMidiInputLine.rowHeights = new int[]{0, 0};
            gbl_panelMidiInputLine.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelMidiInputLine.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelMidiInputLine.setLayout(gbl_panelMidiInputLine);
            GridBagConstraints gbc_comboBoxMidiInputLine = new GridBagConstraints();
            gbc_comboBoxMidiInputLine.insets = new Insets(0, 0, 0, 5);
            gbc_comboBoxMidiInputLine.fill = 2;
            gbc_comboBoxMidiInputLine.gridx = 0;
            gbc_comboBoxMidiInputLine.gridy = 0;
            this.panelMidiInputLine.add((Component)this.getComboBoxMidiInputLine(), gbc_comboBoxMidiInputLine);
            GridBagConstraints gbc_lblMidiInputLineInfo = new GridBagConstraints();
            gbc_lblMidiInputLineInfo.anchor = 17;
            gbc_lblMidiInputLineInfo.weightx = 1.0;
            gbc_lblMidiInputLineInfo.insets = new Insets(0, 8, 0, 4);
            gbc_lblMidiInputLineInfo.gridx = 1;
            gbc_lblMidiInputLineInfo.gridy = 0;
            this.panelMidiInputLine.add((Component)this.getLblMidiInputLineInfo(), gbc_lblMidiInputLineInfo);
        }
        return this.panelMidiInputLine;
    }

    private JComboBox getComboBoxMidiInputLine() {
        if (this.comboBoxMidiInputLine == null) {
            this.comboBoxMidiInputLine = new JComboBox();
            this.comboBoxMidiInputLine.setToolTipText("MIDI input line");
            this.comboBoxMidiInputLine.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                    TimecodeLineConfigPanel.this.checkEnable();
                }
            });
        }
        return this.comboBoxMidiInputLine;
    }

    private JLabel getLblMidiInputLineInfo() {
        if (this.lblMidiInputLineInfo == null) {
            this.lblMidiInputLineInfo = new JLabel("(INFO PLACEHOLDER)");
        }
        return this.lblMidiInputLineInfo;
    }

    protected void updateMidiInputLineInfo() {
        String text;
        Icon icon;
        String tip = null;
        int numMidiLines = 0;
        Line[] lines = this.getWaxLabLines();
        int numLines = lines == null ? 0 : lines.length;
        for (int i = 0; i < numLines; ++i) {
            Line line = lines[i];
            if (line == null || !(line instanceof MidiLine)) continue;
            ++numMidiLines;
        }
        if (numMidiLines < 1) {
            icon = null;
            text = "No Midi-Line(s) available in project.";
            tip = "Need to add a 'MIDI-Line' into the Wax-Lab project.";
        } else {
            icon = null;
            text = "";
        }
        this.lblMidiInputLineInfo.setIcon(icon);
        this.lblMidiInputLineInfo.setText(text);
        this.lblMidiInputLineInfo.setToolTipText(tip);
    }

    protected void updateAudioFaderInfo() {
        String text = null;
        Icon icon = null;
        String tip = null;
        if (this.chckbxAudioFader.isSelected() && this.timecodeLineConfig != null && this.timecodeLineConfig.getFaderMidiLine() == null) {
            icon = this.audioFaderWarningIcon;
            text = "Fader MIDI Line not specified!";
            tip = "See the 'Fader' tab to specify the Fader MIDI Line.";
        }
        if (text == null) {
            text = "";
        }
        this.lblAudioFaderInfo.setText(text);
        this.lblAudioFaderInfo.setIcon(icon);
        this.lblAudioFaderInfo.setToolTipText(tip);
    }

    private WaxLabPortChooser getWaxLabPortChooserPreFader() {
        if (this.waxLabPortChooserPreFader == null) {
            this.waxLabPortChooserPreFader = new WaxLabPortChooser();
            this.waxLabPortChooserPreFader.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.waxLabPortChooserPreFader;
    }

    private JLabel getLblPreFaderPorts() {
        if (this.lblPreFaderPorts == null) {
            this.lblPreFaderPorts = new JLabel("Output Ports:");
            this.lblPreFaderPorts.setToolTipText("Pre-Fader output port(s)");
        }
        return this.lblPreFaderPorts;
    }

    private JPanel getPanelPreFaderOutput() {
        if (this.panelPreFaderOutput == null) {
            this.panelPreFaderOutput = new JPanel();
            this.panelPreFaderOutput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Pre-Fader Audio Output", 4, 2, null, new Color(51, 51, 51)));
            GridBagLayout gbl_panelPreFaderOutput = new GridBagLayout();
            gbl_panelPreFaderOutput.columnWidths = new int[]{0, 0, 0};
            gbl_panelPreFaderOutput.rowHeights = new int[]{0, 0, 0, 0};
            gbl_panelPreFaderOutput.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelPreFaderOutput.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
            this.panelPreFaderOutput.setLayout(gbl_panelPreFaderOutput);
            GridBagConstraints gbc_lblPreFaderLine = new GridBagConstraints();
            gbc_lblPreFaderLine.anchor = 17;
            gbc_lblPreFaderLine.insets = new Insets(4, 4, 5, 5);
            gbc_lblPreFaderLine.gridx = 0;
            gbc_lblPreFaderLine.gridy = 0;
            this.panelPreFaderOutput.add((Component)this.getLblPreFaderLine(), gbc_lblPreFaderLine);
            GridBagConstraints gbc_panel_11 = new GridBagConstraints();
            gbc_panel_11.weightx = 1.0;
            gbc_panel_11.insets = new Insets(4, 4, 5, 0);
            gbc_panel_11.fill = 1;
            gbc_panel_11.gridx = 1;
            gbc_panel_11.gridy = 0;
            this.panelPreFaderOutput.add((Component)this.getPanel_11(), gbc_panel_11);
            GridBagConstraints gbc_lblPreFaderPorts = new GridBagConstraints();
            gbc_lblPreFaderPorts.anchor = 18;
            gbc_lblPreFaderPorts.insets = new Insets(8, 4, 5, 5);
            gbc_lblPreFaderPorts.gridx = 0;
            gbc_lblPreFaderPorts.gridy = 1;
            this.panelPreFaderOutput.add((Component)this.getLblPreFaderPorts(), gbc_lblPreFaderPorts);
            GridBagConstraints gbc_waxLabPortChooserPreFader = new GridBagConstraints();
            gbc_waxLabPortChooserPreFader.weightx = 1.0;
            gbc_waxLabPortChooserPreFader.fill = 1;
            gbc_waxLabPortChooserPreFader.anchor = 17;
            gbc_waxLabPortChooserPreFader.insets = new Insets(4, 4, 5, 0);
            gbc_waxLabPortChooserPreFader.gridx = 1;
            gbc_waxLabPortChooserPreFader.gridy = 1;
            this.panelPreFaderOutput.add((Component)this.getWaxLabPortChooserPreFader(), gbc_waxLabPortChooserPreFader);
        }
        return this.panelPreFaderOutput;
    }

    private JLabel getLblLiveFeedPorts() {
        if (this.lblLiveFeedPorts == null) {
            this.lblLiveFeedPorts = new JLabel("Input Ports:");
            this.lblLiveFeedPorts.setToolTipText("Live-Feed input port(s)");
        }
        return this.lblLiveFeedPorts;
    }

    private JPanel getPanelLiveFeedPorts() {
        if (this.panelLiveFeedPorts == null) {
            this.panelLiveFeedPorts = new JPanel();
            GridBagLayout gbl_panelLiveFeedPorts = new GridBagLayout();
            gbl_panelLiveFeedPorts.columnWidths = new int[]{0, 0, 0};
            gbl_panelLiveFeedPorts.rowHeights = new int[]{0};
            gbl_panelLiveFeedPorts.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelLiveFeedPorts.rowWeights = new double[]{0.0};
            this.panelLiveFeedPorts.setLayout(gbl_panelLiveFeedPorts);
            GridBagConstraints gbc_lblLiveFeedPorts = new GridBagConstraints();
            gbc_lblLiveFeedPorts.insets = new Insets(4, 0, 4, 4);
            gbc_lblLiveFeedPorts.anchor = 18;
            gbc_lblLiveFeedPorts.gridx = 0;
            gbc_lblLiveFeedPorts.gridy = 0;
            this.panelLiveFeedPorts.add((Component)this.getLblLiveFeedPorts(), gbc_lblLiveFeedPorts);
            GridBagConstraints gbc_waxLabPortChooserLiveFeed = new GridBagConstraints();
            gbc_waxLabPortChooserLiveFeed.weightx = 1.0;
            gbc_waxLabPortChooserLiveFeed.fill = 1;
            gbc_waxLabPortChooserLiveFeed.insets = new Insets(0, 4, 0, 0);
            gbc_waxLabPortChooserLiveFeed.anchor = 17;
            gbc_waxLabPortChooserLiveFeed.gridx = 1;
            gbc_waxLabPortChooserLiveFeed.gridy = 0;
            this.panelLiveFeedPorts.add((Component)this.getWaxLabPortChooserLiveFeed(), gbc_waxLabPortChooserLiveFeed);
        }
        return this.panelLiveFeedPorts;
    }

    private JPanel getPanelPostFaderOutput() {
        if (this.panelPostFaderOutput == null) {
            this.panelPostFaderOutput = new JPanel();
            this.panelPostFaderOutput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Post-Fader Audio Output", 4, 2, null, null));
            GridBagLayout gbl_panelPostFaderOutput = new GridBagLayout();
            gbl_panelPostFaderOutput.columnWidths = new int[]{0, 0, 0};
            gbl_panelPostFaderOutput.rowHeights = new int[]{0, 0, 0, 0};
            gbl_panelPostFaderOutput.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelPostFaderOutput.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
            this.panelPostFaderOutput.setLayout(gbl_panelPostFaderOutput);
            GridBagConstraints gbc_lblPostFaderLine = new GridBagConstraints();
            gbc_lblPostFaderLine.anchor = 17;
            gbc_lblPostFaderLine.insets = new Insets(4, 4, 5, 5);
            gbc_lblPostFaderLine.gridx = 0;
            gbc_lblPostFaderLine.gridy = 0;
            this.panelPostFaderOutput.add((Component)this.getLblPostFaderLine(), gbc_lblPostFaderLine);
            GridBagConstraints gbc_panel_12 = new GridBagConstraints();
            gbc_panel_12.weightx = 1.0;
            gbc_panel_12.insets = new Insets(4, 4, 5, 0);
            gbc_panel_12.fill = 1;
            gbc_panel_12.gridx = 1;
            gbc_panel_12.gridy = 0;
            this.panelPostFaderOutput.add((Component)this.getPanel_12(), gbc_panel_12);
            GridBagConstraints gbc_lblPostFaderPorts = new GridBagConstraints();
            gbc_lblPostFaderPorts.anchor = 18;
            gbc_lblPostFaderPorts.insets = new Insets(8, 4, 5, 5);
            gbc_lblPostFaderPorts.gridx = 0;
            gbc_lblPostFaderPorts.gridy = 1;
            this.panelPostFaderOutput.add((Component)this.getLblPostFaderPorts(), gbc_lblPostFaderPorts);
            GridBagConstraints gbc_waxLabPortChooserPostFader = new GridBagConstraints();
            gbc_waxLabPortChooserPostFader.weightx = 1.0;
            gbc_waxLabPortChooserPostFader.fill = 1;
            gbc_waxLabPortChooserPostFader.anchor = 17;
            gbc_waxLabPortChooserPostFader.insets = new Insets(4, 4, 5, 0);
            gbc_waxLabPortChooserPostFader.gridx = 1;
            gbc_waxLabPortChooserPostFader.gridy = 1;
            this.panelPostFaderOutput.add((Component)this.getWaxLabPortChooserPostFader(), gbc_waxLabPortChooserPostFader);
        }
        return this.panelPostFaderOutput;
    }

    private JLabel getLblPreFaderLine() {
        if (this.lblPreFaderLine == null) {
            this.lblPreFaderLine = new JLabel("Output Line:");
            this.lblPreFaderLine.setToolTipText("Pre-Fader output");
        }
        return this.lblPreFaderLine;
    }

    private JLabel getLblNewLabel_1() {
        if (this.lblNewLabel_1 == null) {
            this.lblNewLabel_1 = new JLabel("Audio Fader:");
        }
        return this.lblNewLabel_1;
    }

    private JCheckBox getChckbxAudioFader() {
        if (this.chckbxAudioFader == null) {
            this.chckbxAudioFader = new JCheckBox("Internal Mixer");
            this.chckbxAudioFader.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                    TimecodeLineConfigPanel.this.checkEnable();
                }
            });
            this.chckbxAudioFader.setToolTipText("Internal audio fader enabled ?");
        }
        return this.chckbxAudioFader;
    }

    private JLabel getLblPostFaderLine() {
        if (this.lblPostFaderLine == null) {
            this.lblPostFaderLine = new JLabel("Output Line:");
            this.lblPostFaderLine.setToolTipText("Post-Fader output");
        }
        return this.lblPostFaderLine;
    }

    private VolumeControlPanel getVolumeControlPanel_1() {
        if (this.volumeControlPanelPostFader == null) {
            this.volumeControlPanelPostFader = new VolumeControlPanel();
        }
        return this.volumeControlPanelPostFader;
    }

    protected VolumeControlPanel getVolumeControlPanelPostFader() {
        return this.getVolumeControlPanel_1();
    }

    private JLabel getLblNewLabel_2() {
        if (this.lblNewLabel_2 == null) {
            this.lblNewLabel_2 = new JLabel("Scratch Feature:");
            this.lblNewLabel_2.setToolTipText("Enabled features...");
        }
        return this.lblNewLabel_2;
    }

    private JPanel getPanel_11() {
        if (this.panel_11 == null) {
            this.panel_11 = new JPanel();
            GridBagLayout gbl_panel_11 = new GridBagLayout();
            gbl_panel_11.columnWidths = new int[]{0, 0, 0, 0};
            gbl_panel_11.rowHeights = new int[]{0, 0};
            gbl_panel_11.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_11.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_11.setLayout(gbl_panel_11);
            GridBagConstraints gbc_chckbxPreFaderEnabled = new GridBagConstraints();
            gbc_chckbxPreFaderEnabled.anchor = 17;
            gbc_chckbxPreFaderEnabled.insets = new Insets(0, 0, 0, 5);
            gbc_chckbxPreFaderEnabled.gridx = 0;
            gbc_chckbxPreFaderEnabled.gridy = 0;
            this.panel_11.add((Component)this.getChckbxPreFaderEnabled(), gbc_chckbxPreFaderEnabled);
            GridBagConstraints gbc_lblPreFaderVolume = new GridBagConstraints();
            gbc_lblPreFaderVolume.insets = new Insets(0, 20, 0, 5);
            gbc_lblPreFaderVolume.gridx = 1;
            gbc_lblPreFaderVolume.gridy = 0;
            this.panel_11.add((Component)this.getLblPreFaderVolume(), gbc_lblPreFaderVolume);
            GridBagConstraints gbc_volumeControlPanelPreFader = new GridBagConstraints();
            gbc_volumeControlPanelPreFader.weightx = 1.0;
            gbc_volumeControlPanelPreFader.fill = 1;
            gbc_volumeControlPanelPreFader.anchor = 18;
            gbc_volumeControlPanelPreFader.gridx = 2;
            gbc_volumeControlPanelPreFader.gridy = 0;
            this.panel_11.add((Component)this.getVolumeControlPanelPreFader(), gbc_volumeControlPanelPreFader);
        }
        return this.panel_11;
    }

    private JPanel getPanel_12() {
        if (this.panel_12 == null) {
            this.panel_12 = new JPanel();
            GridBagLayout gbl_panel_12 = new GridBagLayout();
            gbl_panel_12.columnWidths = new int[]{0, 0, 0, 0};
            gbl_panel_12.rowHeights = new int[]{0, 0};
            gbl_panel_12.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_12.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_12.setLayout(gbl_panel_12);
            GridBagConstraints gbc_chckbxPostFaderEnabled = new GridBagConstraints();
            gbc_chckbxPostFaderEnabled.anchor = 17;
            gbc_chckbxPostFaderEnabled.insets = new Insets(0, 0, 0, 5);
            gbc_chckbxPostFaderEnabled.gridx = 0;
            gbc_chckbxPostFaderEnabled.gridy = 0;
            this.panel_12.add((Component)this.getChckbxPostFaderEnabled(), gbc_chckbxPostFaderEnabled);
            GridBagConstraints gbc_lblPostFaderVolume = new GridBagConstraints();
            gbc_lblPostFaderVolume.insets = new Insets(0, 20, 0, 5);
            gbc_lblPostFaderVolume.gridx = 1;
            gbc_lblPostFaderVolume.gridy = 0;
            this.panel_12.add((Component)this.getLblPostFaderVolume(), gbc_lblPostFaderVolume);
            GridBagConstraints gbc_volumeControlPanelPostFader = new GridBagConstraints();
            gbc_volumeControlPanelPostFader.weightx = 1.0;
            gbc_volumeControlPanelPostFader.fill = 1;
            gbc_volumeControlPanelPostFader.anchor = 18;
            gbc_volumeControlPanelPostFader.gridx = 2;
            gbc_volumeControlPanelPostFader.gridy = 0;
            this.panel_12.add((Component)this.getVolumeControlPanel_1(), gbc_volumeControlPanelPostFader);
        }
        return this.panel_12;
    }

    private JCheckBox getChckbxPreFaderEnabled() {
        if (this.chckbxPreFaderEnabled == null) {
            this.chckbxPreFaderEnabled = new JCheckBox("Enabled");
            this.chckbxPreFaderEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.chckbxPreFaderEnabled.setToolTipText("Pre-Fader output enabled ?");
        }
        return this.chckbxPreFaderEnabled;
    }

    private JCheckBox getChckbxPostFaderEnabled() {
        if (this.chckbxPostFaderEnabled == null) {
            this.chckbxPostFaderEnabled = new JCheckBox("Enabled");
            this.chckbxPostFaderEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.chckbxPostFaderEnabled.setToolTipText("Post-Fader output enabled ?");
        }
        return this.chckbxPostFaderEnabled;
    }

    private JLabel getLblPreFaderVolume() {
        if (this.lblPreFaderVolume == null) {
            this.lblPreFaderVolume = new JLabel("Volume:");
            this.lblPreFaderVolume.setToolTipText("Output volume");
        }
        return this.lblPreFaderVolume;
    }

    private JLabel getLblPostFaderVolume() {
        if (this.lblPostFaderVolume == null) {
            this.lblPostFaderVolume = new JLabel("Volume:");
            this.lblPostFaderVolume.setToolTipText("Output volume");
        }
        return this.lblPostFaderVolume;
    }

    private JPanel getPanel_13() {
        if (this.panel_13 == null) {
            this.panel_13 = new JPanel();
            GridBagLayout gbl_panel_13 = new GridBagLayout();
            gbl_panel_13.columnWidths = new int[]{0, 0};
            gbl_panel_13.rowHeights = new int[]{0, 0};
            gbl_panel_13.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_13.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_13.setLayout(gbl_panel_13);
            GridBagConstraints gbc_comboBoxPlayChannels = new GridBagConstraints();
            gbc_comboBoxPlayChannels.gridx = 0;
            gbc_comboBoxPlayChannels.gridy = 0;
            this.panel_13.add((Component)this.getComboBoxPlayChannels(), gbc_comboBoxPlayChannels);
        }
        return this.panel_13;
    }

    private JPanel getPanel_14() {
        if (this.panel_14 == null) {
            this.panel_14 = new JPanel();
            GridBagLayout gbl_panel_14 = new GridBagLayout();
            gbl_panel_14.columnWidths = new int[]{0, 0, 0};
            gbl_panel_14.rowHeights = new int[]{0, 0};
            gbl_panel_14.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_14.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_14.setLayout(gbl_panel_14);
            GridBagConstraints gbc_chckbxAudioFader = new GridBagConstraints();
            gbc_chckbxAudioFader.insets = new Insets(0, 0, 0, 5);
            gbc_chckbxAudioFader.gridx = 0;
            gbc_chckbxAudioFader.gridy = 0;
            this.panel_14.add((Component)this.getChckbxAudioFader(), gbc_chckbxAudioFader);
            GridBagConstraints gbc_lblAudioFaderInfo = new GridBagConstraints();
            gbc_lblAudioFaderInfo.insets = new Insets(0, 8, 0, 0);
            gbc_lblAudioFaderInfo.anchor = 17;
            gbc_lblAudioFaderInfo.weightx = 1.0;
            gbc_lblAudioFaderInfo.gridx = 1;
            gbc_lblAudioFaderInfo.gridy = 0;
            this.panel_14.add((Component)this.getLblAudioFaderInfo(), gbc_lblAudioFaderInfo);
        }
        return this.panel_14;
    }

    private JLabel getLblAudioFaderInfo() {
        if (this.lblAudioFaderInfo == null) {
            this.lblAudioFaderInfo = new JLabel("(INFO PLACEHOLDER)");
        }
        return this.lblAudioFaderInfo;
    }

    private JPanel getPanelTimecodeInput() {
        if (this.panelTimecodeInput == null) {
            this.panelTimecodeInput = new JPanel();
            this.panelTimecodeInput.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Timecode Input", 4, 2, null, null));
            GridBagLayout gbl_panelTimecodeInput = new GridBagLayout();
            gbl_panelTimecodeInput.columnWidths = new int[]{0, 0};
            gbl_panelTimecodeInput.rowHeights = new int[]{0, 0};
            gbl_panelTimecodeInput.columnWeights = new double[]{0.0, 0.0};
            gbl_panelTimecodeInput.rowWeights = new double[]{0.0, 0.0};
            this.panelTimecodeInput.setLayout(gbl_panelTimecodeInput);
            GridBagConstraints gbc_jCheckBoxRecordingEnabled = new GridBagConstraints();
            gbc_jCheckBoxRecordingEnabled.gridwidth = 2;
            gbc_jCheckBoxRecordingEnabled.anchor = 17;
            gbc_jCheckBoxRecordingEnabled.insets = new Insets(4, 4, 5, 5);
            gbc_jCheckBoxRecordingEnabled.gridx = 0;
            gbc_jCheckBoxRecordingEnabled.gridy = 0;
            this.panelTimecodeInput.add((Component)this.getJCheckBoxRecordingEnabled(), gbc_jCheckBoxRecordingEnabled);
            GridBagConstraints gbc_labelTimecodeFormat = new GridBagConstraints();
            gbc_labelTimecodeFormat.anchor = 17;
            gbc_labelTimecodeFormat.insets = new Insets(4, 4, 5, 5);
            gbc_labelTimecodeFormat.gridx = 0;
            gbc_labelTimecodeFormat.gridy = 1;
            this.panelTimecodeInput.add((Component)this.getLabel_1(), gbc_labelTimecodeFormat);
            GridBagConstraints gbc_panelTimecodeFormat = new GridBagConstraints();
            gbc_panelTimecodeFormat.weightx = 1.0;
            gbc_panelTimecodeFormat.insets = new Insets(4, 4, 5, 5);
            gbc_panelTimecodeFormat.fill = 1;
            gbc_panelTimecodeFormat.gridx = 1;
            gbc_panelTimecodeFormat.gridy = 1;
            this.panelTimecodeInput.add((Component)this.getPanelTimecodeFormat(), gbc_panelTimecodeFormat);
        }
        return this.panelTimecodeInput;
    }

    private JLabel getLabel_1() {
        if (this.labelTimecodeFormat == null) {
            this.labelTimecodeFormat = new JLabel("Timecode Format:");
            this.labelTimecodeFormat.setToolTipText("Timecode format");
        }
        return this.labelTimecodeFormat;
    }

    private JLabel getLabel_1_1() {
        if (this.lblScratchModeInfo == null) {
            this.lblScratchModeInfo = new JLabel("(INFO PLACEHOLDER)");
        }
        return this.lblScratchModeInfo;
    }

    protected JLabel getLblScratchModeInfo() {
        return this.getLabel_1_1();
    }

    private JPanel getPanelFaderMidiLine() {
        if (this.panelFaderMidiLine == null) {
            this.panelFaderMidiLine = new JPanel();
            this.panelFaderMidiLine.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Fader Input", 4, 2, null, new Color(51, 51, 51)));
            GridBagLayout gbl_panelFaderMidiLine = new GridBagLayout();
            gbl_panelFaderMidiLine.columnWidths = new int[]{0, 0};
            gbl_panelFaderMidiLine.rowHeights = new int[]{0, 0};
            gbl_panelFaderMidiLine.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelFaderMidiLine.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelFaderMidiLine.setLayout(gbl_panelFaderMidiLine);
            GridBagConstraints gbc_panelMidiLine = new GridBagConstraints();
            gbc_panelMidiLine.weightx = 1.0;
            gbc_panelMidiLine.insets = new Insets(4, 4, 4, 4);
            gbc_panelMidiLine.fill = 1;
            gbc_panelMidiLine.gridx = 0;
            gbc_panelMidiLine.gridy = 0;
            this.panelFaderMidiLine.add((Component)this.getPanelMidiLine(), gbc_panelMidiLine);
        }
        return this.panelFaderMidiLine;
    }

    private JPanel getPanelMidiLine() {
        if (this.panelMidiLine == null) {
            this.panelMidiLine = new JPanel();
            GridBagLayout gbl_panelMidiLine = new GridBagLayout();
            gbl_panelMidiLine.columnWidths = new int[]{0, 0};
            gbl_panelMidiLine.rowHeights = new int[]{0, 0};
            gbl_panelMidiLine.columnWeights = new double[]{0.0, 0.0};
            gbl_panelMidiLine.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelMidiLine.setLayout(gbl_panelMidiLine);
            GridBagConstraints gbc_lblFaderMidiLine = new GridBagConstraints();
            gbc_lblFaderMidiLine.insets = new Insets(4, 4, 4, 4);
            gbc_lblFaderMidiLine.gridx = 0;
            gbc_lblFaderMidiLine.gridy = 0;
            this.panelMidiLine.add((Component)this.getLblFaderMidiLine(), gbc_lblFaderMidiLine);
            GridBagConstraints gbc_panelMidiInputLine = new GridBagConstraints();
            gbc_panelMidiInputLine.weightx = 1.0;
            gbc_panelMidiInputLine.insets = new Insets(4, 4, 5, 5);
            gbc_panelMidiInputLine.fill = 1;
            gbc_panelMidiInputLine.gridx = 1;
            gbc_panelMidiInputLine.gridy = 0;
            this.panelMidiLine.add((Component)this.getPanelMidiInputLine(), gbc_panelMidiInputLine);
        }
        return this.panelMidiLine;
    }

    private JLabel getLblFaderMidiLine() {
        if (this.lblFaderMidiLine == null) {
            this.lblFaderMidiLine = new JLabel("Input Line:");
            this.lblFaderMidiLine.setToolTipText("Fader MIDI input line");
        }
        return this.lblFaderMidiLine;
    }

    private JRadioButton getRdbtnAudioBridge() {
        if (this.rdbtnAudioBridge == null) {
            this.rdbtnAudioBridge = new JRadioButton("Audio Bridge:");
            this.rdbtnAudioBridge.setToolTipText("Bridge from audio line ?");
            this.rdbtnAudioBridge.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimecodeLineConfigPanel.this.checkEnable();
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
        }
        return this.rdbtnAudioBridge;
    }

    private JPanel getPanelAudioBridge() {
        if (this.panelAudioBridge == null) {
            this.panelAudioBridge = new JPanel();
            GridBagLayout gbl_panelAudioBridge = new GridBagLayout();
            gbl_panelAudioBridge.columnWidths = new int[]{0, 0, 0};
            gbl_panelAudioBridge.rowHeights = new int[]{0, 0};
            gbl_panelAudioBridge.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelAudioBridge.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelAudioBridge.setLayout(gbl_panelAudioBridge);
            GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
            gbc_lblNewLabel.insets = new Insets(4, 0, 5, 5);
            gbc_lblNewLabel.gridx = 0;
            gbc_lblNewLabel.gridy = 0;
            this.panelAudioBridge.add((Component)this.getLblNewLabel(), gbc_lblNewLabel);
            GridBagConstraints gbc_lblNewLabel_3 = new GridBagConstraints();
            gbc_lblNewLabel_3.insets = new Insets(4, 4, 5, 0);
            gbc_lblNewLabel_3.gridx = 1;
            gbc_lblNewLabel_3.gridy = 0;
            this.panelAudioBridge.add((Component)this.getLblNewLabel_3(), gbc_lblNewLabel_3);
        }
        return this.panelAudioBridge;
    }

    private JLabel getLblNewLabel() {
        if (this.lblNewLabel == null) {
            this.lblNewLabel = new JLabel("Audio Line:");
            this.lblNewLabel.setToolTipText("Bridge audio line");
        }
        return this.lblNewLabel;
    }

    private JLabel getLblNewLabel_3() {
        if (this.lblNewLabel_3 == null) {
            this.lblNewLabel_3 = new JLabel("TODO ..");
        }
        return this.lblNewLabel_3;
    }

    private WaxLabMidiMappingPanel getWaxLabMidiMappingPanel() {
        if (this.waxLabMidiMappingPanel == null) {
            this.waxLabMidiMappingPanel = new WaxLabMidiMappingPanel();
        }
        return this.waxLabMidiMappingPanel;
    }

    private WaxLabMidiTriggerPanel getWaxLabMidiTriggerPanel() {
        if (this.waxLabMidiTriggerPanel == null) {
            this.waxLabMidiTriggerPanel = new WaxLabMidiTriggerPanel();
        }
        return this.waxLabMidiTriggerPanel;
    }

    public void setStudio(Studio studio) {
        this.waxLabMidiMappingPanel.setStudio(studio);
        this.waxLabMidiTriggerPanel.setStudio(studio);
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.waxLabMidiMappingPanel.setMidiFormatter(midiFormatter);
        this.waxLabMidiTriggerPanel.setMidiFormatter(midiFormatter);
    }

    public void setMidiActions(MidiAction[] midiActions) {
        this.waxLabMidiMappingPanel.setMidiActions(midiActions);
    }

    public MidiMapping[] getMidiMappings() {
        return this.waxLabMidiMappingPanel.getMidiMappings();
    }

    public void setMidiMappings(MidiMapping[] midiMappings) {
        this.waxLabMidiMappingPanel.setMidiMappings(midiMappings);
    }

    public void setMidiEvents(String[] midiEvents) {
        this.waxLabMidiTriggerPanel.setMidiEvents(midiEvents);
    }

    public MidiTrigger[] getMidiTriggers() {
        return this.waxLabMidiTriggerPanel.getMidiTriggers();
    }

    public void setMidiTriggers(MidiTrigger[] midiTriggers) {
        this.waxLabMidiTriggerPanel.setMidiTriggers(midiTriggers);
    }

    private JLabel getLblBeatSlicer() {
        if (this.lblBeatSlicer == null) {
            this.lblBeatSlicer = new JLabel("Beat Slicer:");
            this.lblBeatSlicer.setToolTipText("Beat slicer");
        }
        return this.lblBeatSlicer;
    }

    private JPanel getPanelBeatSlicer() {
        if (this.panelBeatSlicer == null) {
            this.panelBeatSlicer = new JPanel();
            this.panelBeatSlicer.setOpaque(false);
            GridBagLayout gbl_panelBeatSlicer = new GridBagLayout();
            gbl_panelBeatSlicer.columnWidths = new int[]{0, 0, 0};
            gbl_panelBeatSlicer.rowHeights = new int[]{0, 0};
            gbl_panelBeatSlicer.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panelBeatSlicer.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelBeatSlicer.setLayout(gbl_panelBeatSlicer);
            GridBagConstraints gbc_comboBoxSliceBeats = new GridBagConstraints();
            gbc_comboBoxSliceBeats.fill = 2;
            gbc_comboBoxSliceBeats.insets = new Insets(0, 0, 0, 5);
            gbc_comboBoxSliceBeats.gridx = 0;
            gbc_comboBoxSliceBeats.gridy = 0;
            this.panelBeatSlicer.add((Component)this.getComboBoxSliceBeats(), gbc_comboBoxSliceBeats);
            GridBagConstraints gbc_lblSliceBeats = new GridBagConstraints();
            gbc_lblSliceBeats.gridx = 1;
            gbc_lblSliceBeats.gridy = 0;
            this.panelBeatSlicer.add((Component)this.getLblSliceBeats(), gbc_lblSliceBeats);
        }
        return this.panelBeatSlicer;
    }

    private JComboBox getComboBoxSliceBeats() {
        if (this.comboBoxSliceBeats == null) {
            this.comboBoxSliceBeats = new JComboBox();
            this.comboBoxSliceBeats.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!TimecodeLineConfigPanel.this.refreshing) {
                        TimecodeLineConfigPanel.this.apply();
                    }
                }
            });
            this.comboBoxSliceBeats.setToolTipText("Number of beat(s) to jump");
            this.comboBoxSliceBeats.setSelectedIndex(-1);
        }
        return this.comboBoxSliceBeats;
    }

    private JLabel getLblSliceBeats() {
        if (this.lblSliceBeats == null) {
            this.lblSliceBeats = new JLabel("beat(s)");
        }
        return this.lblSliceBeats;
    }

    protected class LineListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8937568306209705319L;

        protected LineListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof Line) {
                Line line = (Line)value;
                String name = line.getName();
                this.setText(String.valueOf(name));
            }
            return result;
        }
    }

    protected class BeatsItem {
        private String title;
        private double beats;

        public BeatsItem(String title, double beats) {
            this.title = title;
            this.beats = beats;
        }

        public double getBeats() {
            return this.beats;
        }

        public String toString() {
            return this.title;
        }
    }

    protected class ResampleControlImpl
    extends AbstractFloatControl {
        public ResampleControlImpl() {
            this.setMinimum(1.0f);
            this.setMaximum(1048576.0f);
        }

        protected void applyFloat(float v) {
            if (!TimecodeLineConfigPanel.this.refreshing) {
                TimecodeLineConfigPanel.this.apply();
            }
        }
    }

    protected class PitchDeckControlImpl
    extends AbstractEnumControl
    implements PitchDeckControl {
        protected PitchDeckControlImpl() {
        }

        protected void applyValue(Object v) {
            if (!TimecodeLineConfigPanel.this.refreshing) {
                TimecodeLineConfigPanel.this.apply();
            }
        }

        protected void setValues(Object[] values) {
            super.setValues(values);
        }

        public PitchDeck getPitchDeck() {
            throw new UnsupportedOperationException();
        }
    }

    protected class PitchBpmControlImpl
    extends AbstractPitchBpmControl {
        protected PitchBpmControlImpl() {
        }

        protected void applyDouble(double v) {
            if (!TimecodeLineConfigPanel.this.refreshing) {
                TimecodeLineConfigPanel.this.apply();
            }
        }
    }

    protected class PitchFactorControlImpl
    extends AbstractPitchFactorControl {
        protected PitchFactorControlImpl() {
        }

        protected void applyDouble(double v) {
            if (!TimecodeLineConfigPanel.this.refreshing) {
                TimecodeLineConfigPanel.this.apply();
            }
        }
    }

    protected class PitchModeControlImpl
    extends AbstractPitchModeControl {
        protected PitchModeControlImpl() {
        }

        protected void applyValue(Object v) {
            if (!TimecodeLineConfigPanel.this.refreshing) {
                TimecodeLineConfigPanel.this.apply();
            }
        }
    }

    protected class VolumeControlImpl
    extends AbstractDoubleControl {
        public VolumeControlImpl() {
            this.setMinimum(0.0);
            this.setMaximum(100.0);
        }

        protected void applyDouble(double v) {
            if (!TimecodeLineConfigPanel.this.refreshing) {
                TimecodeLineConfigPanel.this.apply();
            }
        }
    }
}

