/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.Data;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.media.control.AbstractAudioFormatControl;
import com.waxmonster.model.TimecodeChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.DefaultTimecodeFile;
import com.waxmonster.model.impl.TimecodeFile;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.WaxLab;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class TimecodeLineExportPanel
extends JPanel {
    private static final long serialVersionUID = -3610296310812945605L;
    private static final Logger logger = Logger.getLogger(TimecodeLineExportPanel.class.getName());
    private WaxLab waxLab;
    private TimecodeLine timecodeLine;
    private JDialog dialog;
    private JComboBox comboBoxTimecodeRate;

    public TimecodeLineExportPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Export Timecode Sample File", 4, 2, null, null));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.insets = new Insets(4, 4, 0, 4);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        this.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblTimecodeSampleRate = new JLabel("Sample Rate:");
        GridBagConstraints gbc_lblTimecodeSampleRate = new GridBagConstraints();
        gbc_lblTimecodeSampleRate.anchor = 17;
        gbc_lblTimecodeSampleRate.insets = new Insets(4, 4, 4, 4);
        gbc_lblTimecodeSampleRate.gridx = 0;
        gbc_lblTimecodeSampleRate.gridy = 0;
        panel_1.add((Component)lblTimecodeSampleRate, gbc_lblTimecodeSampleRate);
        this.comboBoxTimecodeRate = new JComboBox();
        this.comboBoxTimecodeRate.setOpaque(false);
        this.comboBoxTimecodeRate.setEditable(true);
        GridBagConstraints gbc_comboBoxTimecodeRate = new GridBagConstraints();
        gbc_comboBoxTimecodeRate.weightx = 1.0;
        gbc_comboBoxTimecodeRate.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxTimecodeRate.fill = 2;
        gbc_comboBoxTimecodeRate.gridx = 1;
        gbc_comboBoxTimecodeRate.gridy = 0;
        panel_1.add((Component)this.comboBoxTimecodeRate, gbc_comboBoxTimecodeRate);
        JButton btnExportTimecode = new JButton("Export...");
        btnExportTimecode.setMargin(new Insets(2, 4, 2, 4));
        btnExportTimecode.setIcon(new ImageIcon(TimecodeLineExportPanel.class.getResource("/com/waxmonster/waxlab/view/icons/export_icon16.gif")));
        btnExportTimecode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimecodeLineExportPanel.this.actionExportTimecodeModel();
            }
        });
        GridBagConstraints gbc_btnExportTimecode = new GridBagConstraints();
        gbc_btnExportTimecode.insets = new Insets(4, 4, 4, 4);
        gbc_btnExportTimecode.anchor = 13;
        gbc_btnExportTimecode.gridx = 1;
        gbc_btnExportTimecode.gridy = 1;
        panel_1.add((Component)btnExportTimecode, gbc_btnExportTimecode);
        this.initEditorLineExportPanel();
    }

    public WaxLab getWaxLab() {
        return this.waxLab;
    }

    public void setWaxLab(WaxLab waxLab) {
        this.waxLab = waxLab;
    }

    protected void initEditorLineExportPanel() {
        float frameRate = AbstractAudioFormatControl.getDefaultAudioFrameRate();
        float[] commonRates = AbstractAudioFormatControl.getCommonAudioFrameRates();
        int selTimecodeRateIndex = -1;
        for (int i = 0; i < commonRates.length; ++i) {
            float rate = commonRates[i];
            if (rate == frameRate) {
                selTimecodeRateIndex = this.comboBoxTimecodeRate.getItemCount();
            }
            this.comboBoxTimecodeRate.addItem(this.getFrameRateNumber(rate));
        }
        if (selTimecodeRateIndex >= 0) {
            this.comboBoxTimecodeRate.setSelectedIndex(selTimecodeRateIndex);
        }
    }

    public void showDialog(Component parent, String title) {
        Window window;
        if (this.timecodeLine != null) {
            TimecodeChunk[] chunks = this.timecodeLine.getTimecodeChunks();
            for (int i = 0; i < chunks.length; ++i) {
                TimecodeChunk chunk = chunks[i];
                TimecodeModel model = chunk.getTimecodeModel();
                if (model == null) continue;
                float frameRate = model.getFrameRate();
                this.comboBoxTimecodeRate.setSelectedItem(this.getFrameRateNumber(frameRate));
                break;
            }
        }
        this.dialog = (window = SwingUtilities.getWindowAncestor(parent)) != null && window instanceof Frame ? new JDialog((Frame)window) : new JDialog();
        this.dialog.setTitle(title);
        this.dialog.setContentPane(this);
        this.dialog.pack();
        Tools.centerWindow((Component)parent, (Window)this.dialog);
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
    }

    protected long computeTimecodeLineTimeLength() {
        long endTime = 0L;
        TimecodeChunk[] chunks = this.timecodeLine.getTimecodeChunks();
        for (int i = 0; i < chunks.length; ++i) {
            TimecodeChunk chunk = chunks[i];
            long chunkOfs = chunk.getChunkOfs();
            long chunkEnd = chunk.getChunkEnd();
            if (chunkEnd <= chunkOfs || chunkEnd <= endTime) continue;
            endTime = chunkEnd;
        }
        return endTime;
    }

    protected JComboBox getComboBoxTimecodeRate() {
        return this.comboBoxTimecodeRate;
    }

    protected Number getFrameRateNumber(float frameRate) {
        int intRate = (int)frameRate;
        if (frameRate == (float)intRate) {
            return Data.toInteger((int)intRate);
        }
        return Data.toFloat((float)frameRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionExportTimecodeModel() {
        try {
            Object sampleRateObj = this.comboBoxTimecodeRate.getSelectedItem();
            float sampleRate = Float.parseFloat(String.valueOf(sampleRateObj));
            int bufferFrames = this.waxLab.getWaxLabPreferences().getTimecodeExportBufferSize() / 8;
            if (bufferFrames < 1) {
                bufferFrames = 1;
            }
            long lineOfs = 0L;
            long lineEnd = this.computeTimecodeLineTimeLength();
            JFileChooser fileChooser = new JFileChooser();
            File dataDir = Platform.getInstance().getDataDir();
            if (dataDir != null) {
                fileChooser.setCurrentDirectory(dataDir);
            }
            fileChooser.setDialogType(1);
            fileChooser.setFileSelectionMode(0);
            int rc = fileChooser.showDialog(this, "Export");
            if (rc != 0) {
                return;
            }
            File exportFile = fileChooser.getSelectedFile();
            if (exportFile == null) {
                return;
            }
            if (exportFile.exists() && !this.promptOverwrite(exportFile)) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("actionExportTimecodeModel: timecodeLine=" + this.timecodeLine + ", lineOfs=" + lineOfs + ", lineEnd=" + lineEnd + ", sampleRate=" + sampleRate);
            }
            DefaultTimecodeFile timecodeFile = new DefaultTimecodeFile(exportFile, sampleRate);
            long framePos = 0L;
            try {
                this.waxLab.exportTimecodeLineToTimecodeFile(this.timecodeLine, lineOfs, lineEnd, bufferFrames, (TimecodeFile)timecodeFile, framePos);
            }
            finally {
                timecodeFile.close();
            }
            if (this.dialog != null) {
                this.dialog.dispose();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected boolean promptOverwrite(File file) {
        int messageType;
        int optionType;
        String title = "Overwrite ?";
        String message = "Are you sure to overwrite existing file:\n" + file;
        int rc = JOptionPane.showConfirmDialog(this, message, title, optionType = 2, messageType = 3);
        return rc == 0;
    }

    public TimecodeLine getTimecodeLine() {
        return this.timecodeLine;
    }

    public void setTimecodeLine(TimecodeLine timecodeLine) {
        this.timecodeLine = timecodeLine;
    }
}

