/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.fader.FaderConfig;
import com.waxmonster.model.ChunkListener;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.CachedTimecodeModel;
import com.waxmonster.model.view.ChunkModelLineView;
import com.waxmonster.model.view.ChunkRenderer;
import com.waxmonster.model.view.LineManager;
import com.waxmonster.model.view.LineView;
import com.waxmonster.model.view.MidiChunkModelLineView;
import com.waxmonster.model.view.VolumeShaderMidiChunkRenderer;
import com.waxmonster.view.ScrollPos;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewLayout;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.util.WaxLabXmlUtil;
import com.waxmonster.waxlab.view.AbstractScratchLineWrapper;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.ChunkRendererUtil;
import com.waxmonster.waxlab.view.ClockScratchPositionView;
import com.waxmonster.waxlab.view.MultiLinePanel;
import com.waxmonster.waxlab.view.ScratchPositionView;
import com.waxmonster.waxlab.view.TimecodeLineExportPanel;
import com.waxmonster.waxlab.view.WaxLabFileFilters;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;

public class TimecodeLineWrapper
extends AbstractScratchLineWrapper {
    private static final Logger logger = Logger.getLogger(TimecodeLineWrapper.class.getName());
    private final TimecodeLine timecodeLine;
    private ChunkModelLineView chunkModelLineView;
    private ChunkRenderer timecodeChunkRenderer;
    private MidiChunkModelLineView shaderChunkModelLineView;
    private VolumeShaderMidiChunkRenderer shaderRenderer;
    private int timecodeLineThickness;
    private int timecodeInitCapacity;
    private Color[] faderShadeColors;
    private int faderInitCapacity;
    private String timecodeRenderMode;
    private boolean timecodeInverted;
    private LineChunk prevRecChunk;
    private LineChunk prevMidiRecChunk;

    public TimecodeLineWrapper(MultiLinePanel panel, TimecodeLine timecodeLine, ViewLayout layout, int gridIndex, LineManager manager, WaxLabViewSettings viewSettings) {
        super(panel, (Line)timecodeLine, layout, gridIndex);
        this.timecodeLine = timecodeLine;
        this.setLineManager(manager);
        this.setKeyListener(new KeyHandler());
        this.setMouseWheelListener(new MouseHandler());
        int trackSize = timecodeLine.getTrackSize();
        if (trackSize < 0) {
            trackSize = viewSettings.getTimecodeViewSize();
        }
        this.setTrackSize(trackSize);
        ScrollView scrollView = new ScrollView();
        this.setScrollView(scrollView);
        this.setRecRefreshToPos(false);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        ChunkModel chunkModel = this.line.getChunkModel();
        if (chunkModel != null) {
            chunkModel.registerChunkListener((ChunkListener)this.chunkHandler);
        }
    }

    @Override
    public void dispose() {
        ChunkModel chunkModel = this.line.getChunkModel();
        if (chunkModel != null) {
            chunkModel.unregisterChunkListener((ChunkListener)this.chunkHandler);
        }
        super.dispose();
    }

    public TimecodeLine getTimecodeLine() {
        return this.timecodeLine;
    }

    public int getTimecodeLineThickness() {
        return this.timecodeLineThickness;
    }

    public void setTimecodeLineThickness(int timecodeLineThickness) {
        this.timecodeLineThickness = timecodeLineThickness;
    }

    public int getTimecodeInitCapacity() {
        return this.timecodeInitCapacity;
    }

    public void setTimecodeInitCapacity(int timecodeInitCapacity) {
        this.timecodeInitCapacity = timecodeInitCapacity;
    }

    public Color[] getFaderShadeColors() {
        return this.faderShadeColors;
    }

    public void setFaderShadeColors(Color[] faderShadeColors) {
        this.faderShadeColors = faderShadeColors;
    }

    public int getFaderInitCapacity() {
        return this.faderInitCapacity;
    }

    public void setFaderInitCapacity(int faderInitCapacity) {
        this.faderInitCapacity = faderInitCapacity;
    }

    public long getTimecodeScrollPosition() {
        ScrollView scrollView = this.getScrollView();
        if (scrollView == null) {
            return 0L;
        }
        ScrollPos pos = scrollView.getPosition();
        switch (this.getOrientation()) {
            case 0: {
                return pos.y;
            }
            case 2: {
                return pos.x;
            }
        }
        return 0L;
    }

    @Override
    public void setScratchPositionView(ScratchPositionView scratchPositionView) {
        super.setScratchPositionView(scratchPositionView);
        if (scratchPositionView != null) {
            this.setFrontViews(new View[]{scratchPositionView});
        } else {
            this.setFrontViews(null);
        }
    }

    @Override
    public void showExportLineDialog(Component parent, WaxLab waxLab) {
        Line studioLine = this.getLine();
        if (studioLine instanceof TimecodeLine) {
            TimecodeLine tcLine = (TimecodeLine)studioLine;
            String title = "Export Timecode Line";
            TimecodeLineExportPanel panel = new TimecodeLineExportPanel();
            panel.setWaxLab(waxLab);
            panel.setTimecodeLine(tcLine);
            panel.showDialog(parent, title);
        }
    }

    public long computeTimeLength() {
        return this.line.computeTimeLength();
    }

    public void handleMidiRecordingChanged(MidiLine midiLine) {
        MidiChunkModelLineView shaderChunkModelLineView = this.shaderChunkModelLineView;
        if (shaderChunkModelLineView == null) {
            return;
        }
        TimecodeLineConfig config = this.timecodeLine.getTimecodeLineConfig();
        if (!config.isFaderShadingView()) {
            return;
        }
        MidiLine midiInputLine = config.getFaderMidiLine();
        if (midiInputLine == null || midiInputLine != midiLine) {
            return;
        }
        LineChunk oldChunk = this.prevMidiRecChunk;
        LineChunk recChunk = midiInputLine.getRecChunk();
        if (recChunk != oldChunk) {
            this.prevMidiRecChunk = recChunk;
            if (recChunk == null) {
                shaderChunkModelLineView.setRecordingChunk(null);
            } else {
                shaderChunkModelLineView.setRecordingChunk(recChunk);
                if (oldChunk == null) {
                    // empty if block
                }
            }
        }
    }

    @Override
    public void refresh() {
        TileView tileView;
        int tileHeight;
        boolean inverted;
        boolean showShaderView = false;
        TimecodeLineConfig config = this.timecodeLine.getTimecodeLineConfig();
        if (config.isFaderShadingView()) {
            ChunkModel midiChunkModel;
            MidiLine midiLine = config.getFaderMidiLine();
            FaderConfig[] faderConfigs = config.getAudioFaderConfigs();
            if (faderConfigs == null || faderConfigs.length < 1) {
                midiLine = null;
            }
            int playChannels = midiLine == null ? -1 : WaxLabXmlUtil.getFrameTypeChannelCount((int)config.getPlaybackFrameType());
            ChunkModel chunkModel = midiChunkModel = playChannels < 1 ? null : midiLine.getChunkModel();
            if (midiChunkModel != null) {
                if (this.shaderChunkModelLineView == null) {
                    this.shaderChunkModelLineView = new MidiChunkModelLineView();
                }
                this.shaderChunkModelLineView.setChunkModel(midiChunkModel);
                if (this.shaderRenderer == null) {
                    int channels = playChannels;
                    boolean monoMix = true;
                    int eventQueueSize = 4000;
                    int cacheCapacity = 20;
                    this.shaderRenderer = new VolumeShaderMidiChunkRenderer(channels, monoMix, eventQueueSize, cacheCapacity);
                    this.shaderRenderer.setShadeColors(this.faderShadeColors);
                }
                this.shaderRenderer.setFaderConfigArray(faderConfigs);
                this.shaderChunkModelLineView.setChunkRenderer((ChunkRenderer)this.shaderRenderer);
                this.shaderChunkModelLineView.setLineManager(this.lineManager);
                this.layoutLineView((LineView)this.shaderChunkModelLineView);
                showShaderView = true;
                this.handleMidiRecordingChanged(midiLine);
            }
        }
        String tcRenderMode = null;
        if (config != null) {
            // empty if block
        }
        if (tcRenderMode == null) {
            tcRenderMode = "";
        }
        if (!tcRenderMode.equals(this.timecodeRenderMode)) {
            this.timecodeRenderMode = tcRenderMode;
            this.timecodeChunkRenderer = null;
        }
        if ((inverted = this.isInvertedDirection()) != this.timecodeInverted) {
            this.timecodeInverted = inverted;
            this.timecodeChunkRenderer = null;
        }
        if (this.chunkModelLineView == null) {
            this.chunkModelLineView = new ChunkModelLineView();
        }
        this.chunkModelLineView.setChunkModel(this.timecodeLine.getChunkModel());
        if (this.timecodeChunkRenderer == null) {
            this.timecodeChunkRenderer = ChunkRendererUtil.getInstance().createTimecodeChunkRenderer(this.timecodeRenderMode, this.timecodeInitCapacity, this.timecodeInverted, this.viewSettings);
        }
        this.chunkModelLineView.setChunkRenderer(this.timecodeChunkRenderer);
        this.chunkModelLineView.setLineManager(this.lineManager);
        this.layoutLineView((LineView)this.chunkModelLineView);
        this.lineViews = showShaderView ? new LineView[]{this.chunkModelLineView, this.shaderChunkModelLineView} : new LineView[]{this.chunkModelLineView};
        this.setLineViews(this.lineViews);
        int tileWidth = this.trackSize;
        if (tileWidth < 1) {
            tileWidth = 1;
        }
        if ((tileHeight = this.trackSize) < 1) {
            tileHeight = 1;
        }
        if ((tileView = this.tileView) != null && (tileView.getTileWidth() != tileWidth || tileView.getTileHeight() != tileHeight)) {
            tileView.flush();
            tileView = null;
        }
        if (tileView == null) {
            int maxTileCacheCount = this.viewSettings.getTimecodeTileCacheCount();
            if (maxTileCacheCount < 1) {
                maxTileCacheCount = 1;
            }
            Color timecodeLineBackground = this.viewSettings.getTimecodeViewBackground();
            tileView = new TileView(tileWidth, tileHeight, maxTileCacheCount, (Paint)timecodeLineBackground);
            this.setTileView(tileView);
            this.scrollView.setViews(new View[]{tileView});
        }
        tileView.replaceAllViews((View[])this.lineViews);
        tileView.invalidate();
        LineChunk oldChunk = this.prevRecChunk;
        LineChunk recChunk = this.timecodeLine.getRecChunk();
        if (recChunk != oldChunk) {
            this.prevRecChunk = recChunk;
            this.setRecChunk(recChunk);
            if (recChunk == null) {
                this.panel.unregisterRecordingWrapper(this);
            } else if (oldChunk == null) {
                this.panel.registerRecordingWrapper(this);
            }
        }
    }

    @Override
    public void layout() {
        ViewLayout viewLayout;
        TimecodeLineConfig config;
        int orient = this.orientation;
        boolean horiz = orient == 0 || orient == 1;
        boolean invertedDirection = false;
        boolean timecodeAutoScrolling = true;
        boolean scratchPositionView = true;
        boolean beatCompassView = true;
        boolean beatRadarView = true;
        TimecodeLine timecodeLine = this.timecodeLine;
        if (timecodeLine != null && (config = timecodeLine.getTimecodeLineConfig()) != null) {
            timecodeAutoScrolling = config.isTimecodeAutoScrolling();
            invertedDirection = config.isInvertedView();
            scratchPositionView = config.isScratchPositionViewEnabled();
            beatCompassView = config.isBeatCompassViewEnabled();
            beatRadarView = config.isBeatRadarViewEnabled();
        }
        this.setInvertedDirection(invertedDirection);
        this.setTimecodeAutoScrolling(timecodeAutoScrolling);
        if (this.scrollView != null) {
            Dimension prefSize = this.scrollView.getPreferredSize();
            prefSize.width = this.trackSize;
            prefSize.height = this.trackSize;
            this.scrollView.setPreferredSize(prefSize);
        }
        double prevTcPos = timecodeLine.getTimecodeScrollPosition();
        double timeScale = 1000.0 / this.zoomRate;
        long timecodeScrollPos = invertedDirection ? (long)(1.048576E7 + prevTcPos / timeScale - (double)(this.trackSize / 2)) : (long)(1.048576E7 - prevTcPos / timeScale - (double)(this.trackSize / 2));
        ScrollPos pos = this.scrollView.getPosition();
        if (horiz) {
            pos.y = timecodeScrollPos;
        } else {
            pos.x = timecodeScrollPos;
        }
        this.scrollView.setPosition(pos);
        int index = this.getGridIndex();
        ScrollView wrapperView = this.scrollView;
        if (wrapperView != null && (viewLayout = this.viewLayout) != null) {
            viewLayout.removeView((View)wrapperView);
            if (index >= 0) {
                GridBagConstraints gbc = new GridBagConstraints();
                if (horiz) {
                    gbc.gridx = 0;
                    gbc.gridy = index;
                    gbc.weightx = 1.0;
                    gbc.weighty = 0.0;
                } else {
                    gbc.gridx = index;
                    gbc.gridy = 0;
                    gbc.weightx = 0.0;
                    gbc.weighty = 1.0;
                }
                gbc.fill = 1;
                viewLayout.addView((View)wrapperView, (Object)gbc);
            }
        }
        ScratchPositionView oldSPV = this.getScratchPositionView();
        ClockScratchPositionView newSPV = null;
        ClockScratchPositionView clockView = this.clockScratchPositionView;
        if (clockView != null) {
            clockView.setBeatRadarRendererEnabled(beatRadarView);
            clockView.setBeatCompassLineRendererEnabled(beatCompassView && beatRadarView);
            clockView.setBeatCompassPolyRendererEnabled(beatCompassView && !beatRadarView);
            clockView.refresh();
            if (scratchPositionView) {
                newSPV = clockView;
            }
        }
        if (oldSPV != null) {
            ViewLayout viewLayout2;
            if (newSPV == null) {
                this.setScratchPositionView(null);
            }
            if ((viewLayout2 = this.viewLayout) != null) {
                viewLayout2.removeView((View)oldSPV);
            }
        }
        if (newSPV != null) {
            this.setScratchPositionView(newSPV);
            int clockSize = this.trackSize * 4 / 5;
            int clockInsets = (this.trackSize - clockSize) / 2;
            newSPV.setPreferredSize(new Dimension(clockSize, clockSize));
            newSPV.setBounds(new Rectangle(clockInsets, clockInsets, clockSize, clockSize));
            GridBagConstraints gbc = new GridBagConstraints();
            if (horiz) {
                gbc.gridx = 0;
                gbc.gridy = index;
            } else {
                gbc.gridx = index;
                gbc.gridy = 0;
            }
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.insets = new Insets(clockInsets, clockInsets, clockInsets, clockInsets);
            switch (this.orientation) {
                case 0: {
                    gbc.anchor = 13;
                    break;
                }
                case 2: {
                    gbc.anchor = 15;
                    break;
                }
                case 1: {
                    gbc.anchor = 17;
                    break;
                }
                case 3: {
                    gbc.anchor = 11;
                }
            }
            ViewLayout viewLayout3 = this.viewLayout;
            if (viewLayout3 != null && index >= 0) {
                viewLayout3.addView((View)newSPV, (Object)gbc);
            }
        }
    }

    @Override
    public void setViewSettings(WaxLabViewSettings viewSettings) {
        super.setViewSettings(viewSettings);
        if (viewSettings != null) {
            this.setTimecodeLineThickness(viewSettings.getTimecodeLineThickness());
            this.setTimecodeInitCapacity(viewSettings.getTimecodeInitCapacity());
            this.setFaderInitCapacity(viewSettings.getFaderInitCapacity());
            int timecodeScrollThreshold = viewSettings.getTimecodeScrollThreshold();
            if (timecodeScrollThreshold < 0) {
                timecodeScrollThreshold = 0;
            }
            this.setTimecodeScrollThreshold(timecodeScrollThreshold);
            if (this.tileView != null) {
                int maxTileCacheCount = viewSettings.getTimecodeTileCacheCount();
                if (maxTileCacheCount < 1) {
                    maxTileCacheCount = 1;
                }
                this.tileView.setMaxTileCacheCount(maxTileCacheCount);
                this.tileView.setBackground((Paint)viewSettings.getTimecodeViewBackground());
            }
        }
    }

    public File showOpenFileDialog() throws Exception {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setDialogTitle("Open Timecode File");
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        WaxLabFileFilters.TimecodeFileFilter fileFilter = new WaxLabFileFilters.TimecodeFileFilter();
        chooser.setFileFilter(fileFilter);
        int rc = chooser.showOpenDialog(this.panel);
        if (rc != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        return file;
    }

    public LineChunk[] openLineChunks(File file) throws Exception {
        if (file == null) {
            return null;
        }
        AbstractWaxLabPanel waxPanel = this.panel.getWaxLabPanel();
        if (waxPanel == null) {
            return null;
        }
        WaxLab waxLab = waxPanel.getWaxLab();
        if (waxLab == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating timecode model for file: " + file);
        }
        boolean readOnly = true;
        String[] trackIds = null;
        CachedTimecodeModel model = waxLab.createCachedTimecodeModel(file, trackIds, readOnly);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Frame length: " + model.getFrameLength());
            logger.fine("Frame rate: " + model.getFrameRate());
        }
        long modelOfs = 0L;
        long modelEnd = model.getNanoLength();
        long chunkOfs = 0L;
        long chunkEnd = modelEnd;
        MutableLineChunk chunk = model.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
        return new LineChunk[]{chunk};
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseWheelListener {
        protected MouseHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            TimecodeLineWrapper.this.handleMouseWheelMoved(e);
        }
    }

    protected class KeyHandler
    extends KeyAdapter
    implements KeyListener {
        protected KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            TimecodeLineWrapper.this.handleKeyTyped(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TimecodeLineWrapper.this.handleKeyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            TimecodeLineWrapper.this.handleKeyReleased(e);
        }
    }
}

