/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.waxlab.util.LineModelCopyInfo;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxLabClipboardContent {
    private static final Logger logger = Logger.getLogger(WaxLabClipboardContent.class.getName());
    private long timeLength;
    private LineModelCopyInfo[] lineModelCopyInfos;

    public WaxLabClipboardContent(long timeLength, LineModelCopyInfo[] lineModelCopyInfos) {
        this.timeLength = timeLength;
        this.lineModelCopyInfos = lineModelCopyInfos;
    }

    public long getTimeLength() {
        return this.timeLength;
    }

    public LineModelCopyInfo[] getLineModelCopyInfos() {
        LineModelCopyInfo[] arr = this.lineModelCopyInfos;
        if (arr == null) {
            return null;
        }
        int num = arr.length;
        LineModelCopyInfo[] ret = new LineModelCopyInfo[num];
        System.arraycopy(arr, 0, ret, 0, num);
        return ret;
    }

    public void dispose() {
        LineModelCopyInfo[] arr = this.lineModelCopyInfos;
        if (arr != null) {
            this.lineModelCopyInfos = null;
            for (LineModelCopyInfo info : arr) {
                if (info == null) continue;
                try {
                    info.dispose();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }
}

