/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.beans.BeanDropManager;
import com.waxmonster.waxlab.view.WaxLabClipboardContent;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class WaxLabClipboardTransferable
implements Transferable,
ClipboardOwner {
    private WaxLabClipboardContent clipboardContent;
    private DataFlavor dataFlavor;

    public WaxLabClipboardTransferable(WaxLabClipboardContent clipboardContent) throws Exception {
        this.clipboardContent = clipboardContent;
        this.dataFlavor = BeanDropManager.getJavaJVMLocalObjectFlavor();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        WaxLabClipboardContent clipboardContent = this.clipboardContent;
        if (clipboardContent != null) {
            clipboardContent.dispose();
            this.clipboardContent = null;
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.dataFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.dataFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.clipboardContent;
    }
}

