/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class WaxLabFileFilters {
    private WaxLabFileFilters() {
    }

    public static class WaxEditorFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Wax-Editor Files (.wlx)";
        }

        @Override
        public boolean accept(File f) {
            String lower = f.getName().toLowerCase();
            if (lower.endsWith(".wlx")) {
                return true;
            }
            return f.isDirectory();
        }
    }

    public static class FaderFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Fader Files (.wlf)";
        }

        @Override
        public boolean accept(File f) {
            String lower = f.getName().toLowerCase();
            if (lower.endsWith(".wlf")) {
                return true;
            }
            return f.isDirectory();
        }
    }

    public static class TimecodeFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Timecode Files (.wlt)";
        }

        @Override
        public boolean accept(File f) {
            String lower = f.getName().toLowerCase();
            if (lower.endsWith(".wlt")) {
                return true;
            }
            return f.isDirectory();
        }
    }

    public static class MidiFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "MIDI Files (.mid, .wlm)";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String lower = f.getName().toLowerCase();
            if (lower.endsWith(".mid")) {
                return true;
            }
            if (lower.endsWith(".wlm")) {
                return true;
            }
            return f.isDirectory();
        }
    }

    public static class AudioFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Audio Files";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String lower = f.getName().toLowerCase();
            if (lower.endsWith(".wav")) {
                return true;
            }
            if (lower.endsWith(".aif")) {
                return true;
            }
            if (lower.endsWith(".flac")) {
                return true;
            }
            if (lower.endsWith(".mp3")) {
                return true;
            }
            if (lower.endsWith(".mp4")) {
                return true;
            }
            return lower.endsWith(".aac");
        }
    }

    public static class AudioModelFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Audio Files (.wav)";
        }

        @Override
        public boolean accept(File f) {
            String lower = f.getName().toLowerCase();
            if (lower.endsWith(".wav")) {
                return true;
            }
            return f.isDirectory();
        }
    }

    public static class WaxLabFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Wax-Lab Files (.xml)";
        }

        @Override
        public boolean accept(File f) {
            String lower = f.getName().toLowerCase();
            if (lower.endsWith(".xml")) {
                return true;
            }
            return f.isDirectory();
        }
    }
}

