/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.MidiMappingManagerPanel;
import com.waxmonster.studio.Studio;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.view.TimecodeLineConfigPanel;
import com.waxmonster.waxlab.view.WaxLabPortChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WaxLabMidiMappingPanel
extends JPanel {
    private static final long serialVersionUID = -3518406506760084377L;
    private static final Logger logger = Logger.getLogger(WaxLabMidiMappingPanel.class.getName());
    private String deviceName;
    private Studio studio;
    private MidiFormatter midiFormatter;
    private MidiAction[] midiActions;
    private MidiMapping[] midiMappings;
    private JLabel lblMidiInputPort;
    private JLabel lblMidiInputMappings;
    private WaxLabPortChooser waxLabPortChooserMidiInput;
    private JPanel panel_2;
    private JButton btnMidiMappings;

    public WaxLabMidiMappingPanel() {
        GridBagLayout gbl_panelMidiPortsTab = new GridBagLayout();
        gbl_panelMidiPortsTab.columnWidths = new int[]{0, 0};
        gbl_panelMidiPortsTab.rowHeights = new int[]{0, 0, 0};
        gbl_panelMidiPortsTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMidiPortsTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gbl_panelMidiPortsTab);
        GridBagConstraints gbc_lblMidiInputPort = new GridBagConstraints();
        gbc_lblMidiInputPort.anchor = 17;
        gbc_lblMidiInputPort.insets = new Insets(4, 4, 5, 5);
        gbc_lblMidiInputPort.gridx = 0;
        gbc_lblMidiInputPort.gridy = 0;
        this.add((Component)this.getLblMidiInputPort(), gbc_lblMidiInputPort);
        GridBagConstraints gbc_waxLabPortChooserMidiInput = new GridBagConstraints();
        gbc_waxLabPortChooserMidiInput.weightx = 1.0;
        gbc_waxLabPortChooserMidiInput.insets = new Insets(4, 4, 5, 5);
        gbc_waxLabPortChooserMidiInput.fill = 1;
        gbc_waxLabPortChooserMidiInput.gridx = 1;
        gbc_waxLabPortChooserMidiInput.gridy = 0;
        this.add((Component)this.getWaxLabPortChooserMidiInput(), gbc_waxLabPortChooserMidiInput);
        GridBagConstraints gbc_lblMidiInputMappings = new GridBagConstraints();
        gbc_lblMidiInputMappings.anchor = 17;
        gbc_lblMidiInputMappings.insets = new Insets(4, 4, 5, 5);
        gbc_lblMidiInputMappings.gridx = 0;
        gbc_lblMidiInputMappings.gridy = 1;
        this.add((Component)this.getLblMidiInputMappings(), gbc_lblMidiInputMappings);
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(4, 4, 5, 5);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 1;
        gbc_panel_2.gridy = 1;
        this.add((Component)this.getPanel_2(), gbc_panel_2);
    }

    private JLabel getLblMidiInputPort() {
        if (this.lblMidiInputPort == null) {
            this.lblMidiInputPort = new JLabel("Input Port:");
            this.lblMidiInputPort.setToolTipText("MIDI input port");
            this.lblMidiInputPort.setPreferredSize(new Dimension(100, 16));
        }
        return this.lblMidiInputPort;
    }

    private JLabel getLblMidiInputMappings() {
        if (this.lblMidiInputMappings == null) {
            this.lblMidiInputMappings = new JLabel("Input Mappings:");
            this.lblMidiInputMappings.setToolTipText("MIDI input mappings");
        }
        return this.lblMidiInputMappings;
    }

    private WaxLabPortChooser getWaxLabPortChooserMidiInput() {
        if (this.waxLabPortChooserMidiInput == null) {
            this.waxLabPortChooserMidiInput = new WaxLabPortChooser();
            this.waxLabPortChooserMidiInput.setAudioChannelCount(1);
        }
        return this.waxLabPortChooserMidiInput;
    }

    private JPanel getPanel_2() {
        if (this.panel_2 == null) {
            this.panel_2 = new JPanel();
            GridBagLayout gbl_panel_2 = new GridBagLayout();
            gbl_panel_2.columnWidths = new int[]{0, 0};
            gbl_panel_2.rowHeights = new int[]{0, 0};
            gbl_panel_2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_2.setLayout(gbl_panel_2);
            GridBagConstraints gbc_btnMidiMappings = new GridBagConstraints();
            gbc_btnMidiMappings.anchor = 17;
            gbc_btnMidiMappings.gridx = 0;
            gbc_btnMidiMappings.gridy = 0;
            this.panel_2.add((Component)this.getBtnMidiMappings(), gbc_btnMidiMappings);
        }
        return this.panel_2;
    }

    private JButton getBtnMidiMappings() {
        if (this.btnMidiMappings == null) {
            this.btnMidiMappings = new JButton("Mappings...");
            this.btnMidiMappings.setToolTipText("Show MIDI input mapping dialog...");
            this.btnMidiMappings.setOpaque(false);
            this.btnMidiMappings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WaxLabMidiMappingPanel.this.showMidiMappingDialog();
                }
            });
            this.btnMidiMappings.setMargin(new Insets(2, 4, 2, 4));
            this.btnMidiMappings.setIcon(new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/midi_mapping_icon16.png")));
        }
        return this.btnMidiMappings;
    }

    protected void showMidiMappingDialog() {
        try {
            MidiMappingManagerPanel panel = new MidiMappingManagerPanel();
            panel.setStudio(this.studio);
            panel.setDeviceName(this.deviceName);
            panel.setMidiFactory(DefaultMidiFactory.getInstance());
            panel.setMidiFormatter(this.midiFormatter);
            panel.setAvailableActions(this.midiActions);
            MidiMapping[] origMappings = this.getMidiMappings();
            int origCount = origMappings == null ? 0 : origMappings.length;
            MidiMapping[] cloneMappings = new MidiMapping[origCount];
            if (origCount > 0) {
                System.arraycopy(origMappings, 0, cloneMappings, 0, origCount);
            }
            panel.setMappings(cloneMappings);
            String title = "MIDI Mappings";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            MidiMapping[] newMappings = panel.getMappings();
            this.setMidiMappings(newMappings);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setAvailablePorts(WaxLabPortInfo[] midiInputPorts) {
        this.waxLabPortChooserMidiInput.setAvailablePorts(midiInputPorts);
    }

    public WaxLabPortInfo getMidiInputPort() {
        WaxLabPortInfo[] midiInputPorts = this.waxLabPortChooserMidiInput.getSelectedPorts();
        WaxLabPortInfo midiInputPort = midiInputPorts.length < 1 ? null : midiInputPorts[0];
        return midiInputPort;
    }

    public void setMidiInputPort(WaxLabPortInfo midiInputPort) {
        this.waxLabPortChooserMidiInput.setSelectedPorts(new WaxLabPortInfo[]{midiInputPort});
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    public MidiAction[] getMidiActions() {
        return this.midiActions;
    }

    public void setMidiActions(MidiAction[] midiActions) {
        this.midiActions = midiActions;
    }

    public MidiMapping[] getMidiMappings() {
        return this.midiMappings;
    }

    public void setMidiMappings(MidiMapping[] midiMappings) {
        this.midiMappings = midiMappings;
    }
}

