/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiTriggerManagerPanel;
import com.waxmonster.studio.Studio;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.view.TimecodeLineConfigPanel;
import com.waxmonster.waxlab.view.WaxLabPortChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WaxLabMidiTriggerPanel
extends JPanel {
    private static final long serialVersionUID = 3247027078506265865L;
    private static final Logger logger = Logger.getLogger(WaxLabMidiTriggerPanel.class.getName());
    private String deviceName;
    private Studio studio;
    private MidiFormatter midiFormatter;
    private String[] midiEvents;
    private MidiTrigger[] midiTriggers;
    private JLabel lblMidiOutputPort;
    private WaxLabPortChooser waxLabPortChooserMidiOutput;
    private JLabel lblMidiOutputTriggers;
    private JPanel panel_3;
    private JButton btnMidiTriggers;

    public WaxLabMidiTriggerPanel() {
        GridBagLayout gbl_panelMidiOutput = new GridBagLayout();
        gbl_panelMidiOutput.columnWidths = new int[]{0, 0, 0};
        gbl_panelMidiOutput.rowHeights = new int[]{0, 0, 0};
        gbl_panelMidiOutput.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelMidiOutput.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gbl_panelMidiOutput);
        GridBagConstraints gbc_lblMidiOutputPort = new GridBagConstraints();
        gbc_lblMidiOutputPort.anchor = 17;
        gbc_lblMidiOutputPort.insets = new Insets(4, 4, 5, 5);
        gbc_lblMidiOutputPort.gridx = 0;
        gbc_lblMidiOutputPort.gridy = 0;
        this.add((Component)this.getLblMidiOutputPort(), gbc_lblMidiOutputPort);
        GridBagConstraints gbc_waxLabPortChooserMidiOutput = new GridBagConstraints();
        gbc_waxLabPortChooserMidiOutput.fill = 2;
        gbc_waxLabPortChooserMidiOutput.anchor = 17;
        gbc_waxLabPortChooserMidiOutput.weightx = 1.0;
        gbc_waxLabPortChooserMidiOutput.insets = new Insets(4, 4, 5, 5);
        gbc_waxLabPortChooserMidiOutput.gridx = 1;
        gbc_waxLabPortChooserMidiOutput.gridy = 0;
        this.add((Component)this.getWaxLabPortChooserMidiOutput(), gbc_waxLabPortChooserMidiOutput);
        GridBagConstraints gbc_lblMidiOutputTriggers = new GridBagConstraints();
        gbc_lblMidiOutputTriggers.anchor = 17;
        gbc_lblMidiOutputTriggers.insets = new Insets(4, 4, 5, 5);
        gbc_lblMidiOutputTriggers.gridx = 0;
        gbc_lblMidiOutputTriggers.gridy = 1;
        this.add((Component)this.getLblMidiOutputTriggers(), gbc_lblMidiOutputTriggers);
        GridBagConstraints gbc_panel_3 = new GridBagConstraints();
        gbc_panel_3.weightx = 1.0;
        gbc_panel_3.insets = new Insets(4, 4, 5, 5);
        gbc_panel_3.fill = 1;
        gbc_panel_3.gridx = 1;
        gbc_panel_3.gridy = 1;
        this.add((Component)this.getPanel_3(), gbc_panel_3);
    }

    private JLabel getLblMidiOutputPort() {
        if (this.lblMidiOutputPort == null) {
            this.lblMidiOutputPort = new JLabel("Output Port:");
            this.lblMidiOutputPort.setToolTipText("MIDI output port");
            this.lblMidiOutputPort.setPreferredSize(new Dimension(100, 16));
        }
        return this.lblMidiOutputPort;
    }

    private WaxLabPortChooser getWaxLabPortChooserMidiOutput() {
        if (this.waxLabPortChooserMidiOutput == null) {
            this.waxLabPortChooserMidiOutput = new WaxLabPortChooser();
            this.waxLabPortChooserMidiOutput.setToolTipText("MIDI output port");
            this.waxLabPortChooserMidiOutput.setAudioChannelCount(1);
        }
        return this.waxLabPortChooserMidiOutput;
    }

    private JLabel getLblMidiOutputTriggers() {
        if (this.lblMidiOutputTriggers == null) {
            this.lblMidiOutputTriggers = new JLabel("Output Triggers:");
            this.lblMidiOutputTriggers.setToolTipText("MIDI output triggers");
        }
        return this.lblMidiOutputTriggers;
    }

    private JPanel getPanel_3() {
        if (this.panel_3 == null) {
            this.panel_3 = new JPanel();
            GridBagLayout gbl_panel_3 = new GridBagLayout();
            gbl_panel_3.columnWidths = new int[]{0, 0};
            gbl_panel_3.rowHeights = new int[]{0, 0};
            gbl_panel_3.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_3.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_3.setLayout(gbl_panel_3);
            GridBagConstraints gbc_btnMidiTriggers = new GridBagConstraints();
            gbc_btnMidiTriggers.anchor = 17;
            gbc_btnMidiTriggers.gridx = 0;
            gbc_btnMidiTriggers.gridy = 0;
            this.panel_3.add((Component)this.getBtnMidiTriggers(), gbc_btnMidiTriggers);
        }
        return this.panel_3;
    }

    private JButton getBtnMidiTriggers() {
        if (this.btnMidiTriggers == null) {
            this.btnMidiTriggers = new JButton("Triggers...");
            this.btnMidiTriggers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WaxLabMidiTriggerPanel.this.showMidiTriggerDialog();
                }
            });
            this.btnMidiTriggers.setToolTipText("Show MIDI output trigger dialog...");
            this.btnMidiTriggers.setMargin(new Insets(2, 4, 2, 4));
            this.btnMidiTriggers.setIcon(new ImageIcon(TimecodeLineConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/midi_mapping_icon16.png")));
        }
        return this.btnMidiTriggers;
    }

    protected void showMidiTriggerDialog() {
        try {
            MidiTriggerManagerPanel panel = new MidiTriggerManagerPanel();
            panel.setStudio(this.studio);
            panel.setDeviceName(this.deviceName);
            panel.setMidiFactory(DefaultMidiFactory.getInstance());
            panel.setMidiFormatter(this.midiFormatter);
            panel.setAvailableEvents(this.midiEvents);
            MidiTrigger[] origTriggers = this.getMidiTriggers();
            int origCount = origTriggers == null ? 0 : origTriggers.length;
            MidiTrigger[] cloneTriggers = new MidiTrigger[origCount];
            if (origCount > 0) {
                System.arraycopy(origTriggers, 0, cloneTriggers, 0, origCount);
            }
            panel.setTriggers(cloneTriggers);
            String title = "MIDI Triggers";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            MidiTrigger[] newTriggers = panel.getTriggers();
            this.setMidiTriggers(newTriggers);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setAvailablePorts(WaxLabPortInfo[] midiOutputPorts) {
        this.waxLabPortChooserMidiOutput.setAvailablePorts(midiOutputPorts);
    }

    public WaxLabPortInfo getMidiOutputPort() {
        WaxLabPortInfo[] midiOutputPorts = this.waxLabPortChooserMidiOutput.getSelectedPorts();
        WaxLabPortInfo midiOutputPort = midiOutputPorts.length < 1 ? null : midiOutputPorts[0];
        return midiOutputPort;
    }

    public void setMidiOutputPort(WaxLabPortInfo midiOutputPort) {
        this.waxLabPortChooserMidiOutput.setSelectedPorts(new WaxLabPortInfo[]{midiOutputPort});
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    public String[] getMidiEvents() {
        return this.midiEvents;
    }

    public void setMidiEvents(String[] midiEvents) {
        this.midiEvents = midiEvents;
    }

    public MidiTrigger[] getMidiTriggers() {
        return this.midiTriggers;
    }

    public void setMidiTriggers(MidiTrigger[] midiTriggers) {
        this.midiTriggers = midiTriggers;
    }
}

