/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.SwingTools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class WaxLabOnAirPanel
extends JPanel {
    private static final long serialVersionUID = -2955606901634187713L;
    private Window window;
    private Rectangle windowBounds;
    private boolean alwaysOnTop;
    private boolean dragWindowEnabled;
    private boolean windowDrag;
    private int windowDragX;
    private int windowDragY;

    public WaxLabOnAirPanel() {
        this.initStatusInfoPanel();
        this.refresh();
    }

    public static void main(String[] args) {
        try {
            WaxLabOnAirPanel panel = new WaxLabOnAirPanel();
            panel.setBackground(Color.RED);
            panel.setWindowBounds(new Rectangle(50, 50, 100, 100));
            panel.setAlwaysOnTop(true);
            panel.setDragWindowEnabled(true);
            panel.setWindowVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initStatusInfoPanel() {
        this.windowBounds = new Rectangle(10, 10, 30, 30);
        JFrame frame = new JFrame();
        frame.setUndecorated(true);
        JWindow window = new JWindow(frame);
        window.setContentPane(this);
        window.addMouseListener(new MouseHandler());
        window.addMouseMotionListener(new MouseMotionHandler());
        window.setBounds(this.windowBounds);
        this.window = window;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public boolean isWindowVisible() {
        return this.window.isVisible();
    }

    public void setWindowVisible(boolean windowVisible) {
        this.window.setVisible(windowVisible);
    }

    public Rectangle getWindowBounds() {
        return new Rectangle(this.windowBounds);
    }

    public void setWindowBounds(Rectangle windowBounds) {
        this.windowBounds.setBounds(windowBounds);
        this.window.setBounds(this.windowBounds);
        Tools.ensureWindowFitsScreen((Window)this.window);
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.alwaysOnTop = alwaysOnTop;
        this.refresh();
    }

    public void refresh() {
        int width = this.window.getWidth();
        int height = this.window.getHeight();
        if (SwingTools.supportsWindowShape((Window)this.window)) {
            Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, width, height);
            SwingTools.setWindowShape((Window)this.window, (Shape)shape);
        }
        if (SwingTools.supportsWindowAlwaysOnTop((Window)this.window)) {
            SwingTools.setWindowAlwaysOnTop((Window)this.window, (boolean)this.alwaysOnTop);
        }
    }

    public boolean isDragWindowEnabled() {
        return this.dragWindowEnabled;
    }

    public void setDragWindowEnabled(boolean dragWindowEnabled) {
        this.dragWindowEnabled = dragWindowEnabled;
    }

    protected class MouseMotionHandler
    extends MouseMotionAdapter {
        protected MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            if (WaxLabOnAirPanel.this.windowDrag && WaxLabOnAirPanel.this.dragWindowEnabled) {
                int dragX = WaxLabOnAirPanel.this.window.getX() + e.getX();
                int dragY = WaxLabOnAirPanel.this.window.getY() + e.getY();
                int moveX = dragX - WaxLabOnAirPanel.this.windowDragX;
                int moveY = dragY - WaxLabOnAirPanel.this.windowDragY;
                WaxLabOnAirPanel.this.windowDragX = dragX;
                WaxLabOnAirPanel.this.windowDragY = dragY;
                ((WaxLabOnAirPanel)WaxLabOnAirPanel.this).windowBounds.x = WaxLabOnAirPanel.this.window.getX() + moveX;
                ((WaxLabOnAirPanel)WaxLabOnAirPanel.this).windowBounds.y = WaxLabOnAirPanel.this.window.getY() + moveY;
                WaxLabOnAirPanel.this.window.setLocation(((WaxLabOnAirPanel)WaxLabOnAirPanel.this).windowBounds.x, ((WaxLabOnAirPanel)WaxLabOnAirPanel.this).windowBounds.y);
            }
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (WaxLabOnAirPanel.this.dragWindowEnabled) {
                WaxLabOnAirPanel.this.windowDrag = true;
                WaxLabOnAirPanel.this.windowDragX = WaxLabOnAirPanel.this.window.getX() + e.getX();
                WaxLabOnAirPanel.this.windowDragY = WaxLabOnAirPanel.this.window.getY() + e.getY();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            WaxLabOnAirPanel.this.windowDrag = false;
        }
    }
}

