/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.audio.AudioPortType;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.view.WaxLabPortListCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WaxLabPortChooser
extends JPanel {
    private static final long serialVersionUID = 640920832074083042L;
    public static final String PROPERTY_SELECTED_PORTS = "selectedPorts";
    private String nullPortString = "<Select Port>";
    private int audioChannelCount = 2;
    private WaxLabPortInfo[] availablePorts;
    private WaxLabPortInfo[] selectedPorts;
    private boolean refreshing;
    private JComboBox[] portComboBoxes;
    private JLabel[] portInfoLabels;
    private ItemHandler itemHandler = new ItemHandler();
    private WaxLabPortListCellRenderer portRenderer = new WaxLabPortListCellRenderer(this);

    public WaxLabPortChooser() {
        this.setLayout(new GridBagLayout());
        this.refresh();
    }

    public WaxLabPortInfo[] getAvailablePorts() {
        return this.availablePorts;
    }

    public void setAvailablePorts(WaxLabPortInfo[] availablePorts) {
        this.availablePorts = availablePorts;
        this.refresh();
    }

    public int getAudioChannelCount() {
        return this.audioChannelCount;
    }

    public void setAudioChannelCount(int audioChannelCount) {
        if (this.audioChannelCount == audioChannelCount) {
            return;
        }
        this.audioChannelCount = audioChannelCount;
        this.refresh();
    }

    public WaxLabPortInfo[] getSelectedPorts() {
        return this.selectedPorts;
    }

    public void setSelectedPorts(WaxLabPortInfo[] selectedPorts) {
        this.selectedPorts = selectedPorts;
        this.refresh();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (super.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            int rows = 1;
            if (this.audioChannelCount > 0) {
                rows = this.audioChannelCount;
            }
            if (this.portComboBoxes == null || this.portComboBoxes.length < rows) {
                this.portComboBoxes = new JComboBox[rows];
            }
            if (this.portInfoLabels == null || this.portInfoLabels.length < rows) {
                this.portInfoLabels = new JLabel[rows];
            }
            this.removeAll();
            int disableCount = 0;
            for (int i = 0; i < rows; ++i) {
                JComboBox<Object> box = this.portComboBoxes[i];
                if (box == null) {
                    box = new JComboBox<Object>();
                    box.addItemListener(this.itemHandler);
                    box.setRenderer(this.portRenderer);
                }
                box.removeAllItems();
                boolean enable = this.isEnabled();
                if (disableCount > 0) {
                    --disableCount;
                    enable = false;
                }
                box.setEnabled(enable);
                JLabel info = this.portInfoLabels[i];
                if (info == null) {
                    info = new JLabel();
                }
                info.setEnabled(false);
                WaxLabPortInfo selPort = null;
                String selPortId = null;
                if (this.selectedPorts != null && this.selectedPorts.length > i && (selPort = this.selectedPorts[i]) != null) {
                    selPortId = selPort.getId();
                }
                if (this.nullPortString != null) {
                    box.addItem(this.nullPortString);
                }
                int selIndex = 0;
                Icon infoIcon = null;
                String infoText = null;
                if (this.availablePorts != null) {
                    for (int k = 0; k < this.availablePorts.length; ++k) {
                        WaxLabPortInfo ap = this.availablePorts[k];
                        PortType pt = ap.getType();
                        AudioPortType apt = null;
                        if (pt != null && pt instanceof AudioPortType && (apt = (AudioPortType)pt).getChannels() > this.audioChannelCount) continue;
                        if (selPortId != null && selPortId.equals(ap.getId())) {
                            Port port;
                            Connection[] conns;
                            selIndex = box.getItemCount();
                            if (disableCount < 1 && apt != null) {
                                disableCount = apt.getChannels() - 1;
                            }
                            if ((conns = (port = ap.getPort()).getConnections()) == null || conns.length < 1) {
                                infoText = "Not connected";
                            } else if (conns.length == 1) {
                                Connection conn = conns[0];
                                Port partnerPort = conn.getPartner(port);
                                if (partnerPort != null) {
                                    String partnerPortName;
                                    infoText = "Connected with ";
                                    Device partnerDevice = partnerPort.getDevice();
                                    if (partnerDevice != null) {
                                        String pTitle = partnerDevice.getTitle();
                                        if (pTitle == null || pTitle.trim().length() < 1) {
                                            pTitle = partnerDevice.getName();
                                        }
                                        infoText = infoText + "\"" + String.valueOf(pTitle) + "\"";
                                    }
                                    if ((partnerPortName = partnerPort.getName()) != null) {
                                        infoText = infoText + " (" + partnerPortName + ")";
                                    }
                                } else {
                                    infoText = "Not connected";
                                }
                            } else {
                                infoText = String.valueOf(conns.length) + " connections";
                            }
                        }
                        box.addItem(ap);
                    }
                }
                box.setSelectedIndex(selIndex);
                if (infoText == null) {
                    infoText = "";
                }
                info.setText(infoText);
                info.setIcon(infoIcon);
                this.portComboBoxes[i] = box;
                this.portInfoLabels[i] = info;
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = i;
                gbc.fill = 1;
                gbc.insets = new Insets(i > 0 ? 4 : 0, 0, 0, 0);
                this.add(box, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = i;
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(i > 0 ? 4 : 0, 8, 0, 0);
                this.add((Component)info, gbc);
            }
        }
        finally {
            this.refreshing = false;
        }
        this.validate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSelected(ItemEvent e) {
        JComboBox box;
        if (this.refreshing) {
            return;
        }
        if (e.getStateChange() != 1) {
            return;
        }
        ItemSelectable sel = e.getItemSelectable();
        if (sel != null && sel instanceof JComboBox) {
            AudioPortType apt;
            int channels;
            WaxLabPortInfo port;
            PortType portType;
            box = (JComboBox)sel;
            int index = -1;
            for (int i = 0; i < this.audioChannelCount; ++i) {
                if (box != this.portComboBoxes[i]) continue;
                index = i;
                break;
            }
            Object item = e.getItem();
            if (index >= 0 && item != null && item instanceof WaxLabPortInfo && (portType = (port = (WaxLabPortInfo)item).getType()) != null && portType instanceof AudioPortType && (channels = (apt = (AudioPortType)portType).getChannels()) > 1) {
                WaxLabPortInfo otherPort;
                JComboBox other;
                int i;
                int autoSelectCount = channels - 1;
                for (i = index - 1; i >= 0 && (other = this.portComboBoxes[i]) != null && (otherPort = (WaxLabPortInfo)other.getSelectedItem()) == port; --i) {
                    --autoSelectCount;
                }
                for (i = index + 1; i < this.audioChannelCount && autoSelectCount > 0; ++i) {
                    --autoSelectCount;
                    other = this.portComboBoxes[i];
                    if (other == null) continue;
                    try {
                        this.refreshing = true;
                        other.setSelectedItem(port);
                        continue;
                    }
                    finally {
                        this.refreshing = false;
                    }
                }
                for (i = index - 1; i >= 0 && autoSelectCount > 0; --i) {
                    --autoSelectCount;
                    other = this.portComboBoxes[i];
                    if (other == null) continue;
                    try {
                        this.refreshing = true;
                        other.setSelectedItem(port);
                        continue;
                    }
                    finally {
                        this.refreshing = false;
                    }
                }
            }
        }
        this.apply();
        if (sel != null && sel instanceof JComboBox) {
            box = (JComboBox)sel;
            box.requestFocus();
        }
    }

    protected void apply() {
        int rows = 1;
        if (this.audioChannelCount > 0) {
            rows = this.audioChannelCount;
        }
        WaxLabPortInfo[] oldPorts = this.selectedPorts;
        WaxLabPortInfo[] selPorts = new WaxLabPortInfo[rows];
        for (int i = 0; i < rows; ++i) {
            JComboBox box = this.portComboBoxes[i];
            WaxLabPortInfo portInfo = null;
            Object selItem = box.getSelectedItem();
            if (selItem != null && selItem instanceof WaxLabPortInfo) {
                portInfo = (WaxLabPortInfo)selItem;
            }
            selPorts[i] = portInfo;
        }
        this.selectedPorts = selPorts;
        this.refresh();
        this.firePropertyChange(PROPERTY_SELECTED_PORTS, oldPorts, selPorts);
    }

    public String getNullPortString() {
        return this.nullPortString;
    }

    public void setNullPortString(String nullPortString) {
        this.nullPortString = nullPortString;
    }

    protected class ItemHandler
    implements ItemListener {
        protected ItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            WaxLabPortChooser.this.handleSelected(e);
        }
    }
}

