/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.studio.PortType;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.view.WaxLabPortListCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WaxLabPortConfigPanel
extends JPanel {
    private static final long serialVersionUID = 3940845313509259302L;
    private static final String ACTION_REMOVE = "RemoveSelectedPorts";
    private static final String ACTION_MOVE_UP = "MoveUpSelectedPorts";
    private static final String ACTION_MOVE_DOWN = "MoveDownSelectedPorts";
    private String title;
    private String namePrefix;
    private PortType[] portTypes;
    private DefaultListModel portListModel;
    private int selectedIndex = -1;
    private boolean refreshing;
    private JButton btnRemove;
    private JTextField textFieldName;
    private JButton btnMoveup;
    private JButton btnMovedown;
    private JLabel lblName;
    private JLabel lblType;
    private JComboBox comboBoxType;
    private JList listPorts;
    private JPanel panelPorts;

    public WaxLabPortConfigPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.panelPorts = new JPanel();
        this.panelPorts.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Ports", 4, 2, null, null));
        GridBagConstraints gbc_panelPorts = new GridBagConstraints();
        gbc_panelPorts.weighty = 1.0;
        gbc_panelPorts.insets = new Insets(0, 0, 0, 5);
        gbc_panelPorts.fill = 1;
        gbc_panelPorts.gridx = 0;
        gbc_panelPorts.gridy = 0;
        this.add((Component)this.panelPorts, gbc_panelPorts);
        GridBagLayout gbl_panelPorts = new GridBagLayout();
        gbl_panelPorts.columnWidths = new int[]{0, 0};
        gbl_panelPorts.rowHeights = new int[]{0, 0, 0};
        gbl_panelPorts.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelPorts.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panelPorts.setLayout(gbl_panelPorts);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        this.panelPorts.add((Component)scrollPane, gbc_scrollPane);
        this.listPorts = new JList();
        this.listPorts.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WaxLabPortConfigPanel.this.handlePortSelected();
            }
        });
        scrollPane.setViewportView(this.listPorts);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(0, 4, 4, 4);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 1;
        this.panelPorts.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JButton btnAdd = new JButton("");
        btnAdd.setToolTipText("Add port");
        btnAdd.setIcon(new ImageIcon(WaxLabPortConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/insert.gif")));
        btnAdd.setMargin(new Insets(2, 4, 2, 4));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaxLabPortConfigPanel.this.actionAdd();
            }
        });
        GridBagConstraints gbc_btnAdd = new GridBagConstraints();
        gbc_btnAdd.insets = new Insets(0, 0, 0, 5);
        gbc_btnAdd.gridx = 0;
        gbc_btnAdd.gridy = 0;
        panel_1.add((Component)btnAdd, gbc_btnAdd);
        this.btnMoveup = new JButton("");
        this.btnMoveup.setMargin(new Insets(2, 2, 2, 2));
        this.btnMoveup.setToolTipText("Move up");
        this.btnMoveup.setIcon(new ImageIcon(WaxLabPortConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/pageup.gif")));
        this.btnMoveup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaxLabPortConfigPanel.this.actionMoveUp();
            }
        });
        this.btnRemove = new JButton("");
        this.btnRemove.setToolTipText("Remove selected port(s)");
        this.btnRemove.setIcon(new ImageIcon(WaxLabPortConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/remove_icon16.gif")));
        this.btnRemove.setMargin(new Insets(2, 4, 2, 4));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaxLabPortConfigPanel.this.actionRemove();
            }
        });
        GridBagConstraints gbc_btnRemove = new GridBagConstraints();
        gbc_btnRemove.insets = new Insets(0, 0, 0, 5);
        gbc_btnRemove.gridx = 1;
        gbc_btnRemove.gridy = 0;
        panel_1.add((Component)this.btnRemove, gbc_btnRemove);
        GridBagConstraints gbc_btnMoveup = new GridBagConstraints();
        gbc_btnMoveup.insets = new Insets(0, 0, 0, 5);
        gbc_btnMoveup.gridx = 2;
        gbc_btnMoveup.gridy = 0;
        panel_1.add((Component)this.btnMoveup, gbc_btnMoveup);
        this.btnMovedown = new JButton("");
        this.btnMovedown.setMargin(new Insets(2, 2, 2, 2));
        this.btnMovedown.setToolTipText("Move down");
        this.btnMovedown.setIcon(new ImageIcon(WaxLabPortConfigPanel.class.getResource("/com/waxmonster/waxlab/view/icons/pagedown.gif")));
        this.btnMovedown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaxLabPortConfigPanel.this.actionMoveDown();
            }
        });
        GridBagConstraints gbc_btnMovedown = new GridBagConstraints();
        gbc_btnMovedown.gridx = 3;
        gbc_btnMovedown.gridy = 0;
        panel_1.add((Component)this.btnMovedown, gbc_btnMovedown);
        JPanel panelDetails = new JPanel();
        panelDetails.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Port Details", 4, 2, null, null));
        GridBagConstraints gbc_panelDetails = new GridBagConstraints();
        gbc_panelDetails.weightx = 1.0;
        gbc_panelDetails.weighty = 1.0;
        gbc_panelDetails.fill = 1;
        gbc_panelDetails.gridx = 1;
        gbc_panelDetails.gridy = 0;
        this.add((Component)panelDetails, gbc_panelDetails);
        GridBagLayout gbl_panelDetails = new GridBagLayout();
        gbl_panelDetails.columnWidths = new int[]{0, 0, 0};
        gbl_panelDetails.rowHeights = new int[]{0, 0, 0};
        gbl_panelDetails.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelDetails.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelDetails.setLayout(gbl_panelDetails);
        this.lblName = new JLabel("Name:");
        GridBagConstraints gbc_lblName = new GridBagConstraints();
        gbc_lblName.insets = new Insets(4, 4, 5, 5);
        gbc_lblName.anchor = 17;
        gbc_lblName.gridx = 0;
        gbc_lblName.gridy = 0;
        panelDetails.add((Component)this.lblName, gbc_lblName);
        this.textFieldName = new JTextField();
        this.textFieldName.setOpaque(false);
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.weightx = 1.0;
        gbc_textFieldName.insets = new Insets(4, 4, 5, 4);
        gbc_textFieldName.fill = 2;
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 0;
        panelDetails.add((Component)this.textFieldName, gbc_textFieldName);
        this.textFieldName.setColumns(10);
        this.lblType = new JLabel("Type:");
        GridBagConstraints gbc_lblType = new GridBagConstraints();
        gbc_lblType.anchor = 17;
        gbc_lblType.insets = new Insets(4, 4, 0, 5);
        gbc_lblType.gridx = 0;
        gbc_lblType.gridy = 1;
        panelDetails.add((Component)this.lblType, gbc_lblType);
        this.comboBoxType = new JComboBox();
        this.comboBoxType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxLabPortConfigPanel.this.refreshing) {
                    WaxLabPortConfigPanel.this.apply();
                    WaxLabPortConfigPanel.this.handlePortSelected();
                }
            }
        });
        GridBagConstraints gbc_comboBoxType = new GridBagConstraints();
        gbc_comboBoxType.insets = new Insets(4, 4, 0, 4);
        gbc_comboBoxType.fill = 2;
        gbc_comboBoxType.gridx = 1;
        gbc_comboBoxType.gridy = 1;
        panelDetails.add((Component)this.comboBoxType, gbc_comboBoxType);
        this.initWaxLabPortInfoPanel();
    }

    protected void initWaxLabPortInfoPanel() {
        this.portListModel = new DefaultListModel();
        this.listPorts.setModel(this.portListModel);
        this.textFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!WaxLabPortConfigPanel.this.refreshing) {
                    WaxLabPortConfigPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!WaxLabPortConfigPanel.this.refreshing) {
                    WaxLabPortConfigPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!WaxLabPortConfigPanel.this.refreshing) {
                    WaxLabPortConfigPanel.this.apply();
                }
            }
        });
        this.listPorts.setCellRenderer(new WaxLabPortListCellRenderer(this.listPorts));
        this.comboBoxType.setRenderer(new WaxLabPortListCellRenderer(this.comboBoxType));
        this.listPorts.getActionMap().put(ACTION_REMOVE, new ActionRemove());
        this.listPorts.getInputMap().put(KeyStroke.getKeyStroke(127, 0), ACTION_REMOVE);
        this.listPorts.getActionMap().put(ACTION_MOVE_UP, new ActionMoveUp());
        this.listPorts.getInputMap().put(KeyStroke.getKeyStroke(38, 8), ACTION_MOVE_UP);
        this.listPorts.getActionMap().put(ACTION_MOVE_DOWN, new ActionMoveDown());
        this.listPorts.getInputMap().put(KeyStroke.getKeyStroke(40, 8), ACTION_MOVE_DOWN);
        this.handlePortSelected();
    }

    public WaxLabPortInfo[] getPorts() {
        int num = this.portListModel.getSize();
        WaxLabPortInfo[] arr = new WaxLabPortInfo[num];
        for (int i = 0; i < num; ++i) {
            arr[i] = (WaxLabPortInfo)this.portListModel.getElementAt(i);
        }
        return arr;
    }

    public void setPorts(WaxLabPortInfo[] ports) {
        this.portListModel.removeAllElements();
        WaxLabPortInfo[] infos = ports;
        if (infos != null) {
            for (int i = 0; i < infos.length; ++i) {
                this.portListModel.addElement(infos[i]);
            }
        }
    }

    public PortType[] getPortTypes() {
        return this.portTypes;
    }

    public void setPortTypes(PortType[] portTypes) {
        this.portTypes = portTypes;
        this.comboBoxType.removeAllItems();
        if (portTypes != null) {
            for (int i = 0; i < portTypes.length; ++i) {
                this.comboBoxType.addItem(portTypes[i]);
            }
        }
        this.handlePortSelected();
    }

    protected void apply() {
        int index = this.selectedIndex;
        if (index < 0) {
            return;
        }
        String name = this.textFieldName.getText();
        PortType type = (PortType)this.comboBoxType.getSelectedItem();
        WaxLabPortInfo info = (WaxLabPortInfo)this.portListModel.getElementAt(index);
        info.setName(name);
        info.setType(type);
        this.listPorts.validate();
        this.listPorts.repaint();
    }

    protected JButton getBtnRemove() {
        return this.btnRemove;
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }

    protected JButton getBtnMoveup() {
        return this.btnMoveup;
    }

    protected JButton getBtnMovedown() {
        return this.btnMovedown;
    }

    protected void actionAdd() {
        WaxLabPortInfo port = new WaxLabPortInfo();
        if (this.portTypes != null && this.portTypes.length > 0) {
            port.setType(this.portTypes[0]);
        }
        String name = this.uniquePortName();
        port.setName(name);
        int index = this.portListModel.getSize();
        this.portListModel.addElement(port);
        this.listPorts.setSelectedIndex(index);
    }

    protected void actionRemove() {
        int[] sel = this.listPorts.getSelectedIndices();
        for (int i = sel.length - 1; i >= 0; --i) {
            this.portListModel.removeElementAt(sel[i]);
        }
    }

    protected void actionMoveUp() {
        int[] sel = this.listPorts.getSelectedIndices();
        if (sel.length > 0 && sel[0] > 0) {
            for (int i = 0; i < sel.length; ++i) {
                int index = sel[i];
                if (index > 0) {
                    Object element = this.portListModel.remove(index);
                    this.portListModel.add(--index, element);
                }
                sel[i] = index;
            }
            this.listPorts.setSelectedIndices(sel);
            this.listPorts.ensureIndexIsVisible(sel[0]);
        }
    }

    protected void actionMoveDown() {
        int[] sel = this.listPorts.getSelectedIndices();
        int size = this.portListModel.getSize();
        if (sel.length > 0 && sel[sel.length - 1] < size - 1) {
            for (int i = sel.length - 1; i >= 0; --i) {
                int index = sel[i];
                if (index < size - 1) {
                    Object element = this.portListModel.remove(index);
                    this.portListModel.add(++index, element);
                }
                sel[i] = index;
            }
            this.listPorts.setSelectedIndices(sel);
            this.listPorts.ensureIndexIsVisible(sel[sel.length - 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePortSelected() {
        PortType[] types;
        int[] sel = this.listPorts.getSelectedIndices();
        this.btnRemove.setEnabled(sel.length > 0);
        this.btnMoveup.setEnabled(sel.length > 0 && sel[0] > 0);
        int size = this.portListModel.getSize();
        this.btnMovedown.setEnabled(sel.length > 0 && sel[sel.length - 1] < size - 1);
        boolean enable = false;
        String name = null;
        PortType type = null;
        int index = -1;
        if (sel.length == 1) {
            enable = true;
            this.selectedIndex = index = sel[0];
            WaxLabPortInfo portInfo = (WaxLabPortInfo)this.portListModel.getElementAt(index);
            name = portInfo.getName();
            type = portInfo.getType();
        }
        this.selectedIndex = index;
        if (name == null) {
            name = "";
        }
        int typeIndex = -1;
        if (type != null && (types = this.portTypes) != null) {
            for (int i = 0; i < types.length; ++i) {
                if (type != types[i]) continue;
                typeIndex = i;
                break;
            }
        }
        try {
            this.refreshing = true;
            this.lblName.setEnabled(enable);
            this.textFieldName.setEnabled(enable);
            this.textFieldName.setText(name);
            this.lblType.setEnabled(enable);
            this.comboBoxType.setEnabled(enable);
            this.comboBoxType.setSelectedIndex(typeIndex);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JLabel getLblName() {
        return this.lblName;
    }

    protected JLabel getLblType() {
        return this.lblType;
    }

    protected JComboBox getComboBoxType() {
        return this.comboBoxType;
    }

    protected JList getListPorts() {
        return this.listPorts;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        Border border = this.panelPorts.getBorder();
        if (border != null && border instanceof TitledBorder) {
            TitledBorder titled = (TitledBorder)border;
            titled.setTitle(title);
        }
    }

    protected JPanel getPanelPorts() {
        return this.panelPorts;
    }

    protected String uniquePortName() {
        int i;
        String name = this.namePrefix;
        HashSet<String> names = new HashSet<String>();
        int num = this.portListModel.size();
        for (i = 0; i < num; ++i) {
            WaxLabPortInfo info = (WaxLabPortInfo)this.portListModel.getElementAt(i);
            names.add(info.getName());
        }
        for (i = 1; i < Integer.MAX_VALUE; ++i) {
            String key = name + i;
            if (names.contains(key)) continue;
            name = key;
            break;
        }
        return name;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    protected class ActionMoveDown
    extends AbstractAction {
        private static final long serialVersionUID = 541856998331610831L;

        protected ActionMoveDown() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WaxLabPortConfigPanel.this.actionMoveDown();
        }
    }

    protected class ActionMoveUp
    extends AbstractAction {
        private static final long serialVersionUID = -6081710239852711067L;

        protected ActionMoveUp() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WaxLabPortConfigPanel.this.actionMoveUp();
        }
    }

    protected class ActionRemove
    extends AbstractAction {
        private static final long serialVersionUID = -7217287730649087275L;

        protected ActionRemove() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WaxLabPortConfigPanel.this.actionRemove();
        }
    }
}

