/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.waxmonster.studio.PortType;
import com.waxmonster.waxlab.WaxLabPortInfo;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;

public class WaxLabPortListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 6582228133748232824L;
    private final JComponent parent;

    public WaxLabPortListCellRenderer(JComponent parent) {
        this.parent = parent;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String text = null;
        Icon icon = null;
        if (value != null) {
            PortType portType = null;
            if (value instanceof PortType) {
                portType = (PortType)value;
                text = portType.getTooltip();
            } else if (value instanceof WaxLabPortInfo) {
                WaxLabPortInfo info = (WaxLabPortInfo)value;
                portType = info.getType();
                text = info.getName();
            } else {
                text = String.valueOf(value);
            }
            if (portType != null) {
                icon = portType.getIcon(1);
            }
        }
        if (text == null) {
            text = "";
        }
        this.setText(text);
        this.setIcon(icon);
        boolean enabled = true;
        if (this.parent != null && !this.parent.isEnabled()) {
            enabled = false;
        }
        this.setEnabled(enabled);
        return comp;
    }
}

