/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import com.spacekiller.util.Data;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.swing.FileField;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.Studio;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.view.WaxLabMidiMappingPanel;
import com.waxmonster.waxlab.view.WaxLabMidiTriggerPanel;
import com.waxmonster.waxlab.view.WaxLabPortChooser;
import com.waxmonster.waxlab.view.WaxLabPortConfigPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WaxLabSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -670742367209106574L;
    private static final String DEFAULT_REFRESH_RATE = "<default>";
    private static final int[] COMMON_REFRESH_RATES = new int[]{0, 1, 2, 5, 10, 20, 24, 25, 50, 60, 75, 100, 125, 200, 250};
    private static final String ORIENT_LEFT_RIGHT = "Left-Right";
    private static final String ORIENT_TOP_DOWN = "Top-Down";
    private String clockType;
    private WaxLabPortInfo clockAudioPort;
    private int lineOrientation;
    private int refreshRate = -1;
    private int stopDelayMillis;
    private boolean showOnAirWindow;
    private boolean refreshing;
    private JComboBox comboBoxLineOrientation;
    private JLabel lblLineOrientation;
    private JComboBox comboBoxRefreshRate;
    private JTextField textFieldStopDelay;
    private JCheckBox chckbxShowOnAirWindow;
    private WaxLabPortConfigPanel portInfoPanelInput;
    private WaxLabPortConfigPanel portInfoPanelOutput;
    private WaxLabMidiMappingPanel waxLabMidiMappingPanel;
    private WaxLabMidiTriggerPanel waxLabMidiTriggerPanel;
    private JPanel panelInputTab;
    private JPanel panelOutputTab;
    private JPanel panelMidiTab;
    private JPanel panelViewTab;
    private JTabbedPane tabbedPane;
    private JPanel panelClockTab;
    private JPanel panel_2;
    private JPanel panel_3;
    private JRadioButton rdbtnClockAutomatic;
    private JRadioButton rdbtnClockAudioPort;
    private JRadioButton rdbtnClockSystem;
    private WaxLabPortChooser waxLabPortChooserClock;
    private JPanel panelMainTab;
    private JPanel panel_4;
    private JPanel panel_5;
    private JLabel lblNewLabel_1;
    private FileField fileFieldContentDirectory;

    public WaxLabSettingsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component selectedTab = WaxLabSettingsPanel.this.tabbedPane.getSelectedComponent();
                if (selectedTab == WaxLabSettingsPanel.this.panelMidiTab) {
                    WaxLabSettingsPanel.this.refreshMidiPorts();
                }
                if (selectedTab == WaxLabSettingsPanel.this.panelClockTab) {
                    WaxLabSettingsPanel.this.refreshAudioPorts();
                }
            }
        });
        this.tabbedPane.setTabLayoutPolicy(1);
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.weighty = 1.0;
        gbc_tabbedPane.weightx = 1.0;
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 0;
        this.add((Component)this.tabbedPane, gbc_tabbedPane);
        this.panelMainTab = new JPanel();
        this.tabbedPane.addTab("Main  ", new ImageIcon(WaxLabSettingsPanel.class.getResource("/com/waxmonster/waxlab/impl/icons/wax_studio_icon16.png")), this.panelMainTab, "Main Settings");
        GridBagLayout gbl_panelMainTab = new GridBagLayout();
        gbl_panelMainTab.columnWidths = new int[]{0, 0};
        gbl_panelMainTab.rowHeights = new int[]{0, 0};
        gbl_panelMainTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMainTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelMainTab.setLayout(gbl_panelMainTab);
        this.panel_4 = new JPanel();
        GridBagConstraints gbc_panel_4 = new GridBagConstraints();
        gbc_panel_4.weightx = 1.0;
        gbc_panel_4.insets = new Insets(4, 4, 4, 4);
        gbc_panel_4.fill = 1;
        gbc_panel_4.gridx = 0;
        gbc_panel_4.gridy = 0;
        this.panelMainTab.add((Component)this.panel_4, gbc_panel_4);
        GridBagLayout gbl_panel_4 = new GridBagLayout();
        gbl_panel_4.columnWidths = new int[]{0, 0};
        gbl_panel_4.rowHeights = new int[]{0, 0};
        gbl_panel_4.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_4.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel_4.setLayout(gbl_panel_4);
        this.panel_5 = new JPanel();
        this.panel_5.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Directories", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel_5 = new GridBagConstraints();
        gbc_panel_5.weightx = 1.0;
        gbc_panel_5.fill = 1;
        gbc_panel_5.gridx = 0;
        gbc_panel_5.gridy = 0;
        this.panel_4.add((Component)this.panel_5, gbc_panel_5);
        GridBagLayout gbl_panel_5 = new GridBagLayout();
        gbl_panel_5.columnWidths = new int[]{0, 0, 0};
        gbl_panel_5.rowHeights = new int[]{0, 0};
        gbl_panel_5.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_5.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel_5.setLayout(gbl_panel_5);
        this.lblNewLabel_1 = new JLabel("Content Directory:");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.insets = new Insets(4, 4, 5, 5);
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 0;
        this.panel_5.add((Component)this.lblNewLabel_1, gbc_lblNewLabel_1);
        this.fileFieldContentDirectory = new FileField();
        GridBagConstraints gbc_fileFieldContentDirectory = new GridBagConstraints();
        gbc_fileFieldContentDirectory.insets = new Insets(4, 4, 5, 5);
        gbc_fileFieldContentDirectory.weightx = 1.0;
        gbc_fileFieldContentDirectory.fill = 2;
        gbc_fileFieldContentDirectory.gridx = 1;
        gbc_fileFieldContentDirectory.gridy = 0;
        this.panel_5.add((Component)this.fileFieldContentDirectory, gbc_fileFieldContentDirectory);
        this.panelOutputTab = new JPanel();
        this.tabbedPane.addTab("Output  ", new ImageIcon(WaxLabSettingsPanel.class.getResource("/com/waxmonster/waxlab/view/icons/export_wiz.gif")), this.panelOutputTab, "Output Ports");
        GridBagLayout gbl_panelOutputTab = new GridBagLayout();
        gbl_panelOutputTab.columnWidths = new int[]{0, 0};
        gbl_panelOutputTab.rowHeights = new int[]{0, 0};
        gbl_panelOutputTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelOutputTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelOutputTab.setLayout(gbl_panelOutputTab);
        this.portInfoPanelOutput = new WaxLabPortConfigPanel();
        this.portInfoPanelOutput.setTitle("Output Ports");
        GridBagConstraints gbc_portInfoPanelOutput = new GridBagConstraints();
        gbc_portInfoPanelOutput.insets = new Insets(4, 4, 4, 4);
        gbc_portInfoPanelOutput.weighty = 1.0;
        gbc_portInfoPanelOutput.weightx = 1.0;
        gbc_portInfoPanelOutput.fill = 1;
        gbc_portInfoPanelOutput.gridx = 0;
        gbc_portInfoPanelOutput.gridy = 0;
        this.panelOutputTab.add((Component)this.portInfoPanelOutput, gbc_portInfoPanelOutput);
        this.panelInputTab = new JPanel();
        this.tabbedPane.addTab("Input  ", new ImageIcon(WaxLabSettingsPanel.class.getResource("/com/waxmonster/waxlab/view/icons/import_wiz.gif")), this.panelInputTab, "Input Ports");
        GridBagLayout gbl_panelInputTab = new GridBagLayout();
        gbl_panelInputTab.columnWidths = new int[]{0, 0};
        gbl_panelInputTab.rowHeights = new int[]{0, 0};
        gbl_panelInputTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelInputTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelInputTab.setLayout(gbl_panelInputTab);
        this.portInfoPanelInput = new WaxLabPortConfigPanel();
        this.portInfoPanelInput.setTitle("Input Ports");
        GridBagConstraints gbc_portInfoPanelInput = new GridBagConstraints();
        gbc_portInfoPanelInput.insets = new Insets(4, 4, 4, 4);
        gbc_portInfoPanelInput.weighty = 1.0;
        gbc_portInfoPanelInput.weightx = 1.0;
        gbc_portInfoPanelInput.fill = 1;
        gbc_portInfoPanelInput.gridx = 0;
        gbc_portInfoPanelInput.gridy = 0;
        this.panelInputTab.add((Component)this.portInfoPanelInput, gbc_portInfoPanelInput);
        this.panelClockTab = new JPanel();
        this.tabbedPane.addTab("Clock  ", new ImageIcon(WaxLabSettingsPanel.class.getResource("/com/waxmonster/waxlab/view/icons/clock_sync_icon.gif")), this.panelClockTab, "Synchronization");
        GridBagLayout gbl_panelClockTab = new GridBagLayout();
        gbl_panelClockTab.columnWidths = new int[]{0, 0};
        gbl_panelClockTab.rowHeights = new int[]{0, 0};
        gbl_panelClockTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelClockTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelClockTab.setLayout(gbl_panelClockTab);
        this.panel_2 = new JPanel();
        this.panel_2.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Synchronization", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.weightx = 1.0;
        gbc_panel_2.insets = new Insets(4, 4, 4, 4);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 0;
        this.panelClockTab.add((Component)this.panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel_2.setLayout(gbl_panel_2);
        this.panel_3 = new JPanel();
        GridBagConstraints gbc_panel_3 = new GridBagConstraints();
        gbc_panel_3.weightx = 1.0;
        gbc_panel_3.insets = new Insets(4, 4, 4, 4);
        gbc_panel_3.fill = 1;
        gbc_panel_3.gridx = 0;
        gbc_panel_3.gridy = 0;
        this.panel_2.add((Component)this.panel_3, gbc_panel_3);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{0, 0, 0};
        gbl_panel_3.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panel_3.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.panel_3.setLayout(gbl_panel_3);
        this.rdbtnClockAutomatic = new JRadioButton("Automatic");
        this.rdbtnClockAutomatic.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WaxLabSettingsPanel.this.checkEnable();
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_rdbtnClockAutomatic = new GridBagConstraints();
        gbc_rdbtnClockAutomatic.insets = new Insets(0, 0, 5, 5);
        gbc_rdbtnClockAutomatic.anchor = 17;
        gbc_rdbtnClockAutomatic.gridx = 0;
        gbc_rdbtnClockAutomatic.gridy = 0;
        this.panel_3.add((Component)this.rdbtnClockAutomatic, gbc_rdbtnClockAutomatic);
        this.rdbtnClockAudioPort = new JRadioButton("Audio Port:");
        this.rdbtnClockAudioPort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WaxLabSettingsPanel.this.checkEnable();
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_rdbtnClockAudioPort = new GridBagConstraints();
        gbc_rdbtnClockAudioPort.insets = new Insets(0, 0, 5, 5);
        gbc_rdbtnClockAudioPort.anchor = 17;
        gbc_rdbtnClockAudioPort.gridx = 0;
        gbc_rdbtnClockAudioPort.gridy = 1;
        this.panel_3.add((Component)this.rdbtnClockAudioPort, gbc_rdbtnClockAudioPort);
        this.waxLabPortChooserClock = new WaxLabPortChooser();
        this.waxLabPortChooserClock.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }
        });
        this.waxLabPortChooserClock.setAudioChannelCount(1);
        GridBagConstraints gbc_waxLabPortChooserClock = new GridBagConstraints();
        gbc_waxLabPortChooserClock.weightx = 1.0;
        gbc_waxLabPortChooserClock.insets = new Insets(0, 0, 5, 0);
        gbc_waxLabPortChooserClock.fill = 1;
        gbc_waxLabPortChooserClock.gridx = 1;
        gbc_waxLabPortChooserClock.gridy = 1;
        this.panel_3.add((Component)this.waxLabPortChooserClock, gbc_waxLabPortChooserClock);
        this.rdbtnClockSystem = new JRadioButton("System Clock");
        this.rdbtnClockSystem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WaxLabSettingsPanel.this.checkEnable();
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_rdbtnClockSystem = new GridBagConstraints();
        gbc_rdbtnClockSystem.insets = new Insets(0, 0, 0, 5);
        gbc_rdbtnClockSystem.anchor = 17;
        gbc_rdbtnClockSystem.gridx = 0;
        gbc_rdbtnClockSystem.gridy = 2;
        this.panel_3.add((Component)this.rdbtnClockSystem, gbc_rdbtnClockSystem);
        this.panelMidiTab = new JPanel();
        this.tabbedPane.addTab("MIDI  ", new ImageIcon(WaxLabSettingsPanel.class.getResource("/com/waxmonster/waxlab/view/icons/midi_mapping_icon16.png")), this.panelMidiTab, "MIDI Mappings");
        GridBagLayout gbl_panelMidiTab = new GridBagLayout();
        gbl_panelMidiTab.columnWidths = new int[]{0, 0};
        gbl_panelMidiTab.rowHeights = new int[]{0, 0, 0};
        gbl_panelMidiTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMidiTab.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panelMidiTab.setLayout(gbl_panelMidiTab);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Input", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weightx = 1.0;
        gbc_panel.insets = new Insets(4, 4, 5, 4);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.panelMidiTab.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.waxLabMidiMappingPanel = new WaxLabMidiMappingPanel();
        GridBagLayout gbl_waxLabMidiMappingPanel = (GridBagLayout)this.waxLabMidiMappingPanel.getLayout();
        gbl_waxLabMidiMappingPanel.rowWeights = new double[]{0.0, 0.0};
        gbl_waxLabMidiMappingPanel.rowHeights = new int[]{0, 0};
        gbl_waxLabMidiMappingPanel.columnWeights = new double[]{0.0};
        gbl_waxLabMidiMappingPanel.columnWidths = new int[]{0};
        GridBagConstraints gbc_waxLabMidiMappingPanel = new GridBagConstraints();
        gbc_waxLabMidiMappingPanel.weightx = 1.0;
        gbc_waxLabMidiMappingPanel.fill = 1;
        gbc_waxLabMidiMappingPanel.gridx = 0;
        gbc_waxLabMidiMappingPanel.gridy = 0;
        panel.add((Component)this.waxLabMidiMappingPanel, gbc_waxLabMidiMappingPanel);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Output", 4, 2, null, null));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(4, 4, 0, 4);
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 1;
        this.panelMidiTab.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        this.waxLabMidiTriggerPanel = new WaxLabMidiTriggerPanel();
        GridBagLayout gbl_waxLabMidiTriggerPanel = (GridBagLayout)this.waxLabMidiTriggerPanel.getLayout();
        gbl_waxLabMidiTriggerPanel.rowWeights = new double[]{0.0, 0.0};
        gbl_waxLabMidiTriggerPanel.rowHeights = new int[]{0, 0};
        gbl_waxLabMidiTriggerPanel.columnWeights = new double[]{0.0, 0.0};
        gbl_waxLabMidiTriggerPanel.columnWidths = new int[]{0, 0};
        GridBagConstraints gbc_waxLabMidiTriggerPanel = new GridBagConstraints();
        gbc_waxLabMidiTriggerPanel.weightx = 1.0;
        gbc_waxLabMidiTriggerPanel.fill = 1;
        gbc_waxLabMidiTriggerPanel.gridx = 0;
        gbc_waxLabMidiTriggerPanel.gridy = 0;
        panel_1.add((Component)this.waxLabMidiTriggerPanel, gbc_waxLabMidiTriggerPanel);
        this.panelViewTab = new JPanel();
        this.tabbedPane.addTab("View  ", new ImageIcon(WaxLabSettingsPanel.class.getResource("/com/waxmonster/waxlab/view/icons/color_icon.gif")), this.panelViewTab, "View Settings");
        GridBagLayout gbl_panelViewTab = new GridBagLayout();
        gbl_panelViewTab.columnWidths = new int[]{0, 0};
        gbl_panelViewTab.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panelViewTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelViewTab.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        this.panelViewTab.setLayout(gbl_panelViewTab);
        JPanel panelLayout = new JPanel();
        panelLayout.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Layout", 4, 2, null, null));
        GridBagConstraints gbc_panelLayout = new GridBagConstraints();
        gbc_panelLayout.weightx = 1.0;
        gbc_panelLayout.insets = new Insets(4, 4, 5, 4);
        gbc_panelLayout.fill = 1;
        gbc_panelLayout.gridx = 0;
        gbc_panelLayout.gridy = 0;
        this.panelViewTab.add((Component)panelLayout, gbc_panelLayout);
        GridBagLayout gbl_panelLayout = new GridBagLayout();
        gbl_panelLayout.columnWidths = new int[]{0, 0, 0};
        gbl_panelLayout.rowHeights = new int[]{0, 0};
        gbl_panelLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelLayout.setLayout(gbl_panelLayout);
        this.lblLineOrientation = new JLabel("Line Orientation:");
        GridBagConstraints gbc_lblLineOrientation = new GridBagConstraints();
        gbc_lblLineOrientation.insets = new Insets(4, 4, 4, 4);
        gbc_lblLineOrientation.anchor = 13;
        gbc_lblLineOrientation.gridx = 0;
        gbc_lblLineOrientation.gridy = 0;
        panelLayout.add((Component)this.lblLineOrientation, gbc_lblLineOrientation);
        this.comboBoxLineOrientation = new JComboBox();
        this.comboBoxLineOrientation.setToolTipText("Time direction");
        this.comboBoxLineOrientation.setOpaque(false);
        this.comboBoxLineOrientation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxLineOrientation = new GridBagConstraints();
        gbc_comboBoxLineOrientation.anchor = 17;
        gbc_comboBoxLineOrientation.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxLineOrientation.weightx = 1.0;
        gbc_comboBoxLineOrientation.gridx = 1;
        gbc_comboBoxLineOrientation.gridy = 0;
        panelLayout.add((Component)this.comboBoxLineOrientation, gbc_comboBoxLineOrientation);
        JPanel panelRendering = new JPanel();
        panelRendering.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Rendering", 4, 2, null, null));
        GridBagConstraints gbc_panelRendering = new GridBagConstraints();
        gbc_panelRendering.insets = new Insets(4, 4, 5, 4);
        gbc_panelRendering.fill = 1;
        gbc_panelRendering.gridx = 0;
        gbc_panelRendering.gridy = 1;
        this.panelViewTab.add((Component)panelRendering, gbc_panelRendering);
        GridBagLayout gbl_panelRendering = new GridBagLayout();
        gbl_panelRendering.columnWidths = new int[]{0, 0, 0};
        gbl_panelRendering.rowHeights = new int[]{0, 0};
        gbl_panelRendering.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelRendering.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelRendering.setLayout(gbl_panelRendering);
        JLabel lblRefreshRate = new JLabel("Refresh Rate:");
        GridBagConstraints gbc_lblRefreshRate = new GridBagConstraints();
        gbc_lblRefreshRate.anchor = 13;
        gbc_lblRefreshRate.insets = new Insets(4, 4, 4, 5);
        gbc_lblRefreshRate.gridx = 0;
        gbc_lblRefreshRate.gridy = 0;
        panelRendering.add((Component)lblRefreshRate, gbc_lblRefreshRate);
        this.comboBoxRefreshRate = new JComboBox();
        this.comboBoxRefreshRate.setOpaque(false);
        this.comboBoxRefreshRate.setToolTipText("Updates per second");
        this.comboBoxRefreshRate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxRefreshRate = new GridBagConstraints();
        gbc_comboBoxRefreshRate.anchor = 17;
        gbc_comboBoxRefreshRate.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxRefreshRate.fill = 2;
        gbc_comboBoxRefreshRate.gridx = 1;
        gbc_comboBoxRefreshRate.gridy = 0;
        panelRendering.add((Component)this.comboBoxRefreshRate, gbc_comboBoxRefreshRate);
        JPanel panelShowOnAir = new JPanel();
        panelShowOnAir.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "On-Air Window", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panelShowOnAir = new GridBagConstraints();
        gbc_panelShowOnAir.insets = new Insets(4, 4, 5, 4);
        gbc_panelShowOnAir.fill = 1;
        gbc_panelShowOnAir.gridx = 0;
        gbc_panelShowOnAir.gridy = 3;
        this.panelViewTab.add((Component)panelShowOnAir, gbc_panelShowOnAir);
        GridBagLayout gbl_panelShowOnAir = new GridBagLayout();
        gbl_panelShowOnAir.columnWidths = new int[]{0, 0};
        gbl_panelShowOnAir.rowHeights = new int[]{0, 0};
        gbl_panelShowOnAir.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelShowOnAir.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelShowOnAir.setLayout(gbl_panelShowOnAir);
        this.chckbxShowOnAirWindow = new JCheckBox("Show On-Air window when active");
        this.chckbxShowOnAirWindow.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_chckbxShowOnAirWindow = new GridBagConstraints();
        gbc_chckbxShowOnAirWindow.insets = new Insets(4, 0, 4, 0);
        gbc_chckbxShowOnAirWindow.gridx = 0;
        gbc_chckbxShowOnAirWindow.gridy = 0;
        panelShowOnAir.add((Component)this.chckbxShowOnAirWindow, gbc_chckbxShowOnAirWindow);
        JPanel panelStopDelay = new JPanel();
        panelStopDelay.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Stop/Pause Delay", 4, 2, null, null));
        GridBagConstraints gbc_panelStopDelay = new GridBagConstraints();
        gbc_panelStopDelay.insets = new Insets(4, 4, 5, 4);
        gbc_panelStopDelay.weightx = 1.0;
        gbc_panelStopDelay.fill = 1;
        gbc_panelStopDelay.gridx = 0;
        gbc_panelStopDelay.gridy = 2;
        this.panelViewTab.add((Component)panelStopDelay, gbc_panelStopDelay);
        GridBagLayout gbl_panelStopDelay = new GridBagLayout();
        gbl_panelStopDelay.columnWidths = new int[]{34, 114, 21, 0};
        gbl_panelStopDelay.rowHeights = new int[]{20, 0};
        gbl_panelStopDelay.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelStopDelay.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelStopDelay.setLayout(gbl_panelStopDelay);
        JLabel lblNewLabel = new JLabel("Delay:");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(4, 4, 4, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        panelStopDelay.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.textFieldStopDelay = new JTextField();
        this.textFieldStopDelay.setHorizontalAlignment(4);
        this.textFieldStopDelay.setToolTipText("Delay in milliseconds");
        this.textFieldStopDelay.setOpaque(false);
        GridBagConstraints gbc_textFieldStopDelay = new GridBagConstraints();
        gbc_textFieldStopDelay.anchor = 18;
        gbc_textFieldStopDelay.insets = new Insets(4, 4, 4, 5);
        gbc_textFieldStopDelay.gridx = 1;
        gbc_textFieldStopDelay.gridy = 0;
        panelStopDelay.add((Component)this.textFieldStopDelay, gbc_textFieldStopDelay);
        this.textFieldStopDelay.setColumns(10);
        JLabel lblMs = new JLabel("ms.");
        GridBagConstraints gbc_lblMs = new GridBagConstraints();
        gbc_lblMs.weightx = 1.0;
        gbc_lblMs.insets = new Insets(4, 4, 4, 4);
        gbc_lblMs.anchor = 17;
        gbc_lblMs.gridx = 2;
        gbc_lblMs.gridy = 0;
        panelStopDelay.add((Component)lblMs, gbc_lblMs);
        JPanel panelViewFill = new JPanel();
        GridBagConstraints gbc_panelViewFill = new GridBagConstraints();
        gbc_panelViewFill.weighty = 1.0;
        gbc_panelViewFill.fill = 1;
        gbc_panelViewFill.gridx = 0;
        gbc_panelViewFill.gridy = 4;
        this.panelViewTab.add((Component)panelViewFill, gbc_panelViewFill);
        this.initWaxLabSettingsPanel();
    }

    protected void initWaxLabSettingsPanel() {
        this.textFieldStopDelay.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!WaxLabSettingsPanel.this.refreshing) {
                    WaxLabSettingsPanel.this.apply();
                }
            }
        });
        ButtonGroup buttonGroupClock = new ButtonGroup();
        buttonGroupClock.add(this.getRdbtnClockAutomatic());
        buttonGroupClock.add(this.getRdbtnClockAudioPort());
        buttonGroupClock.add(this.getRdbtnClockSystem());
        this.fileFieldContentDirectory.setFileSelectionMode(1);
        this.portInfoPanelInput.setNamePrefix("In-");
        this.portInfoPanelOutput.setNamePrefix("Out-");
        this.waxLabMidiMappingPanel.setDeviceName("WaxLabMidiControl");
        this.waxLabMidiTriggerPanel.setDeviceName("WaxLabMidiControl");
    }

    protected JComboBox getComboBoxOrientation() {
        return this.comboBoxLineOrientation;
    }

    protected JLabel getLblLineOrientation() {
        return this.lblLineOrientation;
    }

    protected JComboBox getComboBoxRefreshRate() {
        return this.comboBoxRefreshRate;
    }

    public int getLineOrientation() {
        return this.lineOrientation;
    }

    public void setLineOrientation(int lineOrientation) {
        this.lineOrientation = lineOrientation;
        this.invalidate();
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
        this.invalidate();
    }

    @Override
    public void validate() {
        this.refresh();
        super.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            WaxLabPortInfo[] waxLabPortInfoArray;
            this.refreshing = true;
            this.refreshAudioPorts();
            this.refreshMidiPorts();
            String clockType = this.clockType;
            if ("AudioPort".equals(clockType)) {
                this.rdbtnClockAudioPort.setSelected(true);
            } else if ("System".equals(clockType)) {
                this.rdbtnClockSystem.setSelected(true);
            } else {
                this.rdbtnClockAutomatic.setSelected(true);
            }
            WaxLabPortInfo clockAudioPort = this.clockAudioPort;
            if (clockAudioPort == null) {
                waxLabPortInfoArray = null;
            } else {
                WaxLabPortInfo[] waxLabPortInfoArray2 = new WaxLabPortInfo[1];
                waxLabPortInfoArray = waxLabPortInfoArray2;
                waxLabPortInfoArray2[0] = clockAudioPort;
            }
            WaxLabPortInfo[] clockAudioPorts = waxLabPortInfoArray;
            this.waxLabPortChooserClock.setSelectedPorts(clockAudioPorts);
            this.comboBoxLineOrientation.removeAllItems();
            this.comboBoxLineOrientation.addItem(ORIENT_LEFT_RIGHT);
            this.comboBoxLineOrientation.addItem(ORIENT_TOP_DOWN);
            switch (this.lineOrientation) {
                case 0: {
                    this.comboBoxLineOrientation.setSelectedItem(ORIENT_LEFT_RIGHT);
                    break;
                }
                case 2: {
                    this.comboBoxLineOrientation.setSelectedItem(ORIENT_TOP_DOWN);
                    break;
                }
                default: {
                    this.comboBoxLineOrientation.setSelectedItem(ORIENT_LEFT_RIGHT);
                }
            }
            this.comboBoxRefreshRate.removeAllItems();
            int refreshRateIndex = -1;
            if (this.refreshRate < 0) {
                refreshRateIndex = this.comboBoxRefreshRate.getItemCount();
            }
            this.comboBoxRefreshRate.addItem(DEFAULT_REFRESH_RATE);
            for (int i = 0; i < COMMON_REFRESH_RATES.length; ++i) {
                if (COMMON_REFRESH_RATES[i] == this.refreshRate) {
                    refreshRateIndex = this.comboBoxRefreshRate.getItemCount();
                }
                this.comboBoxRefreshRate.addItem(Data.toInteger((int)COMMON_REFRESH_RATES[i]));
            }
            if (refreshRateIndex < 0) {
                refreshRateIndex = this.comboBoxRefreshRate.getItemCount();
                this.comboBoxRefreshRate.addItem(Data.toInteger((int)this.refreshRate));
            }
            this.comboBoxRefreshRate.setSelectedIndex(refreshRateIndex);
            this.chckbxShowOnAirWindow.setSelected(this.showOnAirWindow);
            this.textFieldStopDelay.setText(String.valueOf(this.stopDelayMillis));
            this.checkEnable();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected synchronized void refreshAudioPorts() {
        WaxLabPortInfo[] outputPorts;
        LinkedList<WaxLabPortInfo> audioPortList = new LinkedList<WaxLabPortInfo>();
        WaxLabPortInfo[] inputPorts = this.portInfoPanelInput.getPorts();
        if (inputPorts != null) {
            for (int i = 0; i < inputPorts.length; ++i) {
                PortType portType;
                WaxLabPortInfo info = inputPorts[i];
                PortType portType2 = portType = info == null ? null : info.getType();
                if (!(portType instanceof AudioInputPortType)) continue;
                audioPortList.add(info);
            }
        }
        if ((outputPorts = this.portInfoPanelOutput.getPorts()) != null) {
            for (int i = 0; i < outputPorts.length; ++i) {
                PortType portType;
                WaxLabPortInfo info = outputPorts[i];
                PortType portType3 = portType = info == null ? null : info.getType();
                if (!(portType instanceof AudioOutputPortType)) continue;
                audioPortList.add(info);
            }
        }
        WaxLabPortInfo[] audioPorts = audioPortList.toArray(new WaxLabPortInfo[audioPortList.size()]);
        this.waxLabPortChooserClock.setAvailablePorts(audioPorts);
    }

    protected synchronized void refreshMidiPorts() {
        WaxLabPortInfo[] inputPorts = this.portInfoPanelInput.getPorts();
        LinkedList<WaxLabPortInfo> midiInputList = new LinkedList<WaxLabPortInfo>();
        if (inputPorts != null) {
            for (int i = 0; i < inputPorts.length; ++i) {
                PortType portType;
                WaxLabPortInfo info = inputPorts[i];
                PortType portType2 = portType = info == null ? null : info.getType();
                if (!(portType instanceof MidiInputPortType)) continue;
                midiInputList.add(info);
            }
        }
        WaxLabPortInfo[] midiInputPorts = midiInputList.toArray(new WaxLabPortInfo[midiInputList.size()]);
        this.waxLabMidiMappingPanel.setAvailablePorts(midiInputPorts);
        WaxLabPortInfo[] outputPorts = this.portInfoPanelOutput.getPorts();
        LinkedList<WaxLabPortInfo> midiOutputList = new LinkedList<WaxLabPortInfo>();
        if (outputPorts != null) {
            for (int i = 0; i < outputPorts.length; ++i) {
                PortType portType;
                WaxLabPortInfo info = outputPorts[i];
                PortType portType3 = portType = info == null ? null : info.getType();
                if (!(portType instanceof MidiOutputPortType)) continue;
                midiOutputList.add(info);
            }
        }
        WaxLabPortInfo[] midiOutputPorts = midiOutputList.toArray(new WaxLabPortInfo[midiOutputList.size()]);
        this.waxLabMidiTriggerPanel.setAvailablePorts(midiOutputPorts);
    }

    protected void checkEnable() {
        this.waxLabPortChooserClock.setEnabled(this.rdbtnClockAudioPort.isSelected());
    }

    protected void apply() {
        Object refreshItem;
        String clockType = null;
        if (this.rdbtnClockAutomatic.isSelected()) {
            clockType = "Auto";
        }
        if (this.rdbtnClockAudioPort.isSelected()) {
            clockType = "AudioPort";
        }
        if (this.rdbtnClockSystem.isSelected()) {
            clockType = "System";
        }
        this.clockType = clockType;
        WaxLabPortInfo clockAudioPort = null;
        WaxLabPortInfo[] clockAudioPorts = this.waxLabPortChooserClock.getSelectedPorts();
        if (clockAudioPorts != null && clockAudioPorts.length > 0) {
            clockAudioPort = clockAudioPorts[0];
        }
        this.clockAudioPort = clockAudioPort;
        Object orientItem = this.getComboBoxOrientation().getSelectedItem();
        if (ORIENT_LEFT_RIGHT.equals(orientItem)) {
            this.lineOrientation = 0;
        }
        if (ORIENT_TOP_DOWN.equals(orientItem)) {
            this.lineOrientation = 2;
        }
        if (DEFAULT_REFRESH_RATE.equals(refreshItem = this.getComboBoxRefreshRate().getSelectedItem())) {
            this.refreshRate = -1;
        } else {
            try {
                this.refreshRate = Integer.parseInt(String.valueOf(refreshItem));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.showOnAirWindow = this.chckbxShowOnAirWindow.isSelected();
        String sDelay = this.textFieldStopDelay.getText().trim();
        if (sDelay.length() > 0) {
            try {
                int stopDelay = Integer.parseInt(sDelay);
                if (stopDelay < 0) {
                    stopDelay = 0;
                }
                this.stopDelayMillis = stopDelay;
            }
            catch (NumberFormatException e) {}
        } else {
            this.stopDelayMillis = 0;
        }
    }

    public File getContentDirectory() {
        return this.fileFieldContentDirectory.getFile();
    }

    public void setContentDirectory(File contentDirectory) {
        this.fileFieldContentDirectory.setFile(contentDirectory);
    }

    public String getClockType() {
        return this.clockType;
    }

    public void setClockType(String clockType) {
        this.clockType = clockType;
        this.invalidate();
    }

    public WaxLabPortInfo getClockAudioPort() {
        return this.clockAudioPort;
    }

    public void setClockAudioPort(WaxLabPortInfo clockAudioPort) {
        this.clockAudioPort = clockAudioPort;
        this.invalidate();
    }

    protected JCheckBox getChckbxRecStatusInfo() {
        return this.chckbxShowOnAirWindow;
    }

    protected JTextField getTextFieldStopDelay() {
        return this.textFieldStopDelay;
    }

    public int getStopDelayMillis() {
        return this.stopDelayMillis;
    }

    public void setStopDelayMillis(int recordingStopDelay) {
        this.stopDelayMillis = recordingStopDelay;
        this.invalidate();
    }

    public boolean isShowOnAirWindow() {
        return this.showOnAirWindow;
    }

    public void setShowOnAirWindow(boolean recordingStatusInfo) {
        this.showOnAirWindow = recordingStatusInfo;
        this.invalidate();
    }

    public WaxLabPortInfo[] getInputPorts() {
        return this.portInfoPanelInput.getPorts();
    }

    public void setInputPorts(WaxLabPortInfo[] inputPorts) {
        this.portInfoPanelInput.setPorts(inputPorts);
    }

    public WaxLabPortInfo[] getOutputPorts() {
        return this.portInfoPanelOutput.getPorts();
    }

    public void setOutputPorts(WaxLabPortInfo[] outputPorts) {
        this.portInfoPanelOutput.setPorts(outputPorts);
    }

    public PortType[] getInputPortTypes() {
        return this.portInfoPanelInput.getPortTypes();
    }

    public void setInputPortTypes(PortType[] inputPortTypes) {
        this.portInfoPanelInput.setPortTypes(inputPortTypes);
    }

    public PortType[] getOutputPortTypes() {
        return this.portInfoPanelOutput.getPortTypes();
    }

    public void setOutputPortTypes(PortType[] outputPortTypes) {
        this.portInfoPanelOutput.setPortTypes(outputPortTypes);
    }

    protected WaxLabPortConfigPanel getPortInfoPanelInput() {
        return this.portInfoPanelInput;
    }

    protected WaxLabPortConfigPanel getPortInfoPanelOutput() {
        return this.portInfoPanelOutput;
    }

    protected WaxLabMidiMappingPanel getWaxLabMidiMappingPanel() {
        return this.waxLabMidiMappingPanel;
    }

    protected WaxLabMidiTriggerPanel getWaxLabMidiTriggerPanel() {
        return this.waxLabMidiTriggerPanel;
    }

    public void setStudio(Studio studio) {
        this.waxLabMidiMappingPanel.setStudio(studio);
        this.waxLabMidiTriggerPanel.setStudio(studio);
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.waxLabMidiMappingPanel.setMidiFormatter(midiFormatter);
        this.waxLabMidiTriggerPanel.setMidiFormatter(midiFormatter);
    }

    public void setMidiActions(MidiAction[] midiActions) {
        this.waxLabMidiMappingPanel.setMidiActions(midiActions);
    }

    public MidiMapping[] getMidiMappings() {
        return this.waxLabMidiMappingPanel.getMidiMappings();
    }

    public void setMidiMappings(MidiMapping[] midiMappings) {
        this.waxLabMidiMappingPanel.setMidiMappings(midiMappings);
    }

    public WaxLabPortInfo getMidiInputPort() {
        return this.waxLabMidiMappingPanel.getMidiInputPort();
    }

    public void setMidiInputPort(WaxLabPortInfo midiInputPort) {
        this.waxLabMidiMappingPanel.setMidiInputPort(midiInputPort);
    }

    public void setMidiEvents(String[] midiEvents) {
        this.waxLabMidiTriggerPanel.setMidiEvents(midiEvents);
    }

    public MidiTrigger[] getMidiTriggers() {
        return this.waxLabMidiTriggerPanel.getMidiTriggers();
    }

    public void setMidiTriggers(MidiTrigger[] midiTriggers) {
        this.waxLabMidiTriggerPanel.setMidiTriggers(midiTriggers);
    }

    public WaxLabPortInfo getMidiOutputPort() {
        return this.waxLabMidiTriggerPanel.getMidiOutputPort();
    }

    public void setMidiOutputPort(WaxLabPortInfo midiOutputPort) {
        this.waxLabMidiTriggerPanel.setMidiOutputPort(midiOutputPort);
    }

    protected JPanel getPanelInputTab() {
        return this.panelInputTab;
    }

    protected JPanel getPanelOutputTab() {
        return this.panelOutputTab;
    }

    public JPanel getPanelMidiTab() {
        return this.panelMidiTab;
    }

    protected JPanel getPanelViewTab() {
        return this.panelViewTab;
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    protected JRadioButton getRdbtnClockAutomatic() {
        return this.rdbtnClockAutomatic;
    }

    protected JRadioButton getRdbtnClockAudioPort() {
        return this.rdbtnClockAudioPort;
    }

    protected JRadioButton getRdbtnClockSystem() {
        return this.rdbtnClockSystem;
    }

    protected WaxLabPortChooser getWaxLabPortChooserClock() {
        return this.waxLabPortChooserClock;
    }

    protected FileField getFileFieldContentDirectory() {
        return this.fileFieldContentDirectory;
    }
}

