/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

public class WaxLabViewUtil {
    protected static final String SAMPLE_TYPE_SIGNED_16 = "16 bit (signed)";
    protected static final String SAMPLE_TYPE_SIGNED_24 = "24 bit (signed)";
    protected static final String SAMPLE_TYPE_SIGNED_32 = "32 bit (signed)";
    protected static final String SAMPLE_TYPE_FLOAT_32 = "32 bit (float)";
    protected static final String SAMPLE_TYPE_FLOAT_64 = "64 bit (float)";
    private static final String FRAME_TYPE_MONO = "Mono";
    private static final String FRAME_TYPE_STEREO = "Stereo";

    private WaxLabViewUtil() {
    }

    public static int[] getSampleTypes() {
        return new int[]{1, 2, 3, 4, 5};
    }

    public static int getSampleTypeBitDepth(int sampleType) {
        switch (sampleType) {
            case 1: {
                return 16;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        return -1;
    }

    public static String formatSampleType(int sampleType) {
        switch (sampleType) {
            case 1: {
                return SAMPLE_TYPE_SIGNED_16;
            }
            case 2: {
                return SAMPLE_TYPE_SIGNED_24;
            }
            case 3: {
                return SAMPLE_TYPE_SIGNED_32;
            }
            case 4: {
                return SAMPLE_TYPE_FLOAT_32;
            }
            case 5: {
                return SAMPLE_TYPE_FLOAT_64;
            }
        }
        return String.valueOf(sampleType);
    }

    public static int parseSampleType(String value) {
        if (value != null && value.length() > 0) {
            if (SAMPLE_TYPE_SIGNED_16.equals(value = value.trim())) {
                return 1;
            }
            if (SAMPLE_TYPE_SIGNED_24.equals(value)) {
                return 2;
            }
            if (SAMPLE_TYPE_SIGNED_32.equals(value)) {
                return 3;
            }
            if (SAMPLE_TYPE_FLOAT_32.equals(value)) {
                return 4;
            }
            if (SAMPLE_TYPE_FLOAT_64.equals(value)) {
                return 5;
            }
            try {
                int sampleType = Integer.parseInt(value.trim());
                return sampleType;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int[] getFrameTypes() {
        return new int[]{1, 2};
    }

    public static String formatFrameType(int frameType) {
        switch (frameType) {
            case 1: {
                return FRAME_TYPE_MONO;
            }
            case 2: {
                return FRAME_TYPE_STEREO;
            }
        }
        return String.valueOf(frameType);
    }

    public static int parseFrameType(String value) {
        if (value != null && value.length() > 0) {
            if (FRAME_TYPE_MONO.equals(value = value.trim())) {
                return 1;
            }
            if (FRAME_TYPE_STEREO.equals(value)) {
                return 2;
            }
            try {
                int frameType = Integer.parseInt(value.trim());
                return frameType;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

