/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.view;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class WaxLabWizardPanel
extends JPanel {
    private static final long serialVersionUID = 231862659935547644L;
    private static final Logger logger = Logger.getLogger(WaxLabWizardPanel.class.getName());
    private static final String SINGLE_DECK_LEFT = "Left Deck";
    private static final String SINGLE_DECK_RIGHT = "Right Deck";
    private Clip audioClip;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JComboBox jComboBoxDeckCount = null;
    private JPanel jPanel1 = null;
    private JCheckBox jCheckBoxCreateAudio = null;
    private JCheckBox jCheckBoxCreateTimecode = null;
    private JCheckBox jCheckBoxCreateCrossFader = null;
    private JCheckBox jCheckBoxCreateLineFader = null;
    private JLabel jLabelIcon = null;
    private JCheckBox jCheckBoxShowConfig = null;
    private JCheckBox jCheckBoxRecording = null;
    private JCheckBox jCheckBoxPlayback = null;
    private JCheckBox chckbxCreateInputPorts;
    private JCheckBox chckbxCreateOutputPorts;
    private JPanel panel_1;
    private JPanel panel;

    public WaxLabWizardPanel() {
        this.initialize();
        this.initWaxMonsterWizardPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.anchor = 11;
        gridBagConstraints11.insets = new Insets(0, 0, 0, 8);
        gridBagConstraints11.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(499, 390));
        this.add((Component)this.getJPanel(), gridBagConstraints);
        this.add((Component)this.jLabelIcon, gridBagConstraints11);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(0, 8, 8, 8);
            gridBagConstraints8.gridy = 3;
            this.jLabelIcon = new JLabel();
            this.jLabelIcon.setText("");
            this.jLabelIcon.setIcon(new ImageIcon(this.getClass().getResource("/com/waxmonster/waxlab/view/icons/wax_wizard.png")));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.insets = new Insets(8, 4, 5, 4);
            gridBagConstraints3.gridy = 1;
            this.jPanel = new JPanel();
            GridBagLayout gbl_jPanel = new GridBagLayout();
            gbl_jPanel.columnWidths = new int[]{0};
            gbl_jPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            gbl_jPanel.columnWeights = new double[]{0.0};
            this.jPanel.setLayout(gbl_jPanel);
            this.jPanel.setBorder(null);
            GridBagConstraints gbc_panel = new GridBagConstraints();
            gbc_panel.fill = 1;
            gbc_panel.insets = new Insets(4, 4, 5, 8);
            gbc_panel.gridx = 0;
            gbc_panel.gridy = 0;
            this.jPanel.add((Component)this.getPanel(), gbc_panel);
            this.jPanel.add((Component)this.getJPanel1(), gridBagConstraints3);
            GridBagConstraints gbc_panel_1 = new GridBagConstraints();
            gbc_panel_1.fill = 1;
            gbc_panel_1.insets = new Insets(0, 4, 5, 4);
            gbc_panel_1.gridx = 0;
            gbc_panel_1.gridy = 2;
            this.jPanel.add((Component)this.getPanel_1(), gbc_panel_1);
            this.jPanel.add((Component)this.getJCheckBoxShowConfig(), gridBagConstraints8);
        }
        return this.jPanel;
    }

    private JComboBox getJComboBoxDeckCount() {
        if (this.jComboBoxDeckCount == null) {
            this.jComboBoxDeckCount = new JComboBox();
            this.jComboBoxDeckCount.setMaximumRowCount(5);
            this.jComboBoxDeckCount.setEditable(true);
            this.jComboBoxDeckCount.setOpaque(false);
            this.jComboBoxDeckCount.setCursor(new Cursor(0));
        }
        return this.jComboBoxDeckCount;
    }

    private void initWaxMonsterWizardPanel() {
        this.getJComboBoxDeckCount().removeAllItems();
        this.getJComboBoxDeckCount().addItem(SINGLE_DECK_LEFT);
        this.getJComboBoxDeckCount().addItem(SINGLE_DECK_RIGHT);
        this.getJComboBoxDeckCount().addItem("2");
        this.getJComboBoxDeckCount().addItem("3");
        this.getJComboBoxDeckCount().addItem("4");
        this.getJComboBoxDeckCount().setSelectedIndex(2);
        this.getJCheckBoxCreateAudio().setSelected(true);
        this.getJCheckBoxCreateTimecode().setSelected(true);
        this.getJCheckBoxCreateCrossFader().setSelected(true);
        this.getJCheckBoxCreateLineFader().setSelected(false);
    }

    public int getDeckCount() {
        Object item = this.getJComboBoxDeckCount().getSelectedItem();
        if (item != null) {
            if (item == SINGLE_DECK_LEFT || item == SINGLE_DECK_RIGHT) {
                return 1;
            }
            String s = String.valueOf(item.toString()).trim();
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public boolean isSingleDeckLeft() {
        Object item = this.getJComboBoxDeckCount().getSelectedItem();
        return item == SINGLE_DECK_LEFT;
    }

    public boolean isAudioEnabled() {
        return this.jCheckBoxCreateAudio.isSelected();
    }

    public boolean isTimecodeEnabled() {
        return this.jCheckBoxCreateTimecode.isSelected();
    }

    public boolean isLineFaderEnabled() {
        return this.jCheckBoxCreateLineFader.isSelected();
    }

    public boolean isCrossFaderEnabled() {
        return this.jCheckBoxCreateCrossFader.isSelected();
    }

    public boolean isOpenConfigDialogs() {
        return this.jCheckBoxShowConfig.isSelected();
    }

    public boolean isEnableRecording() {
        return this.jCheckBoxRecording.isSelected();
    }

    public boolean isEnablePlayback() {
        return this.jCheckBoxPlayback.isSelected();
    }

    public boolean isCreateInputPorts() {
        return this.chckbxCreateInputPorts.isSelected();
    }

    public boolean isCreateOutputPorts() {
        return this.chckbxCreateOutputPorts.isSelected();
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 4, 5, 0);
            gridBagConstraints7.gridy = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(0, 4, 0, 0);
            gridBagConstraints6.gridy = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 4, 0, 0);
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(4, 4, 0, 0);
            gridBagConstraints4.gridy = 0;
            this.jPanel1 = new JPanel();
            GridBagLayout gbl_jPanel1 = new GridBagLayout();
            gbl_jPanel1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            gbl_jPanel1.columnWeights = new double[]{1.0};
            this.jPanel1.setLayout(gbl_jPanel1);
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Device Options", 0, 0, null, null));
            this.jPanel1.add((Component)this.getJCheckBoxCreateAudio(), gridBagConstraints4);
            this.jPanel1.add((Component)this.getJCheckBoxCreateTimecode(), gridBagConstraints5);
            this.jPanel1.add((Component)this.getJCheckBoxCreateCrossFader(), gridBagConstraints6);
            this.jPanel1.add((Component)this.getJCheckBoxCreateLineFader(), gridBagConstraints7);
        }
        return this.jPanel1;
    }

    private JCheckBox getJCheckBoxCreateAudio() {
        if (this.jCheckBoxCreateAudio == null) {
            this.jCheckBoxCreateAudio = new JCheckBox();
            this.jCheckBoxCreateAudio.setText("Audio");
            this.jCheckBoxCreateAudio.setOpaque(false);
            this.jCheckBoxCreateAudio.setToolTipText("Audio recording ?");
        }
        return this.jCheckBoxCreateAudio;
    }

    private JCheckBox getJCheckBoxCreateTimecode() {
        if (this.jCheckBoxCreateTimecode == null) {
            this.jCheckBoxCreateTimecode = new JCheckBox();
            this.jCheckBoxCreateTimecode.setText("Timecode");
            this.jCheckBoxCreateTimecode.setOpaque(false);
            this.jCheckBoxCreateTimecode.setToolTipText("Timecode recording ?");
        }
        return this.jCheckBoxCreateTimecode;
    }

    private JCheckBox getJCheckBoxCreateCrossFader() {
        if (this.jCheckBoxCreateCrossFader == null) {
            this.jCheckBoxCreateCrossFader = new JCheckBox();
            this.jCheckBoxCreateCrossFader.setText("Cross Fader");
            this.jCheckBoxCreateCrossFader.setOpaque(false);
            this.jCheckBoxCreateCrossFader.setToolTipText("Cross Fader recording ?");
        }
        return this.jCheckBoxCreateCrossFader;
    }

    private JCheckBox getJCheckBoxCreateLineFader() {
        if (this.jCheckBoxCreateLineFader == null) {
            this.jCheckBoxCreateLineFader = new JCheckBox();
            this.jCheckBoxCreateLineFader.setText("Line Fader");
            this.jCheckBoxCreateLineFader.setOpaque(false);
            this.jCheckBoxCreateLineFader.setToolTipText("Line Fader recording ?");
        }
        return this.jCheckBoxCreateLineFader;
    }

    private JCheckBox getJCheckBoxShowConfig() {
        if (this.jCheckBoxShowConfig == null) {
            this.jCheckBoxShowConfig = new JCheckBox();
            this.jCheckBoxShowConfig.setText("Open configuration dialog(s)...");
            this.jCheckBoxShowConfig.setSelected(true);
        }
        return this.jCheckBoxShowConfig;
    }

    private JCheckBox getJCheckBoxRecording() {
        if (this.jCheckBoxRecording == null) {
            this.jCheckBoxRecording = new JCheckBox();
            this.jCheckBoxRecording.setText("Enable recording");
            this.jCheckBoxRecording.setSelected(true);
        }
        return this.jCheckBoxRecording;
    }

    private JCheckBox getJCheckBoxPlayback() {
        if (this.jCheckBoxPlayback == null) {
            this.jCheckBoxPlayback = new JCheckBox();
            this.jCheckBoxPlayback.setText("Enable playback");
            this.jCheckBoxPlayback.setSelected(true);
        }
        return this.jCheckBoxPlayback;
    }

    private JCheckBox getChckbxCreateInputPorts() {
        if (this.chckbxCreateInputPorts == null) {
            this.chckbxCreateInputPorts = new JCheckBox("Create input ports");
            this.chckbxCreateInputPorts.setSelected(true);
        }
        return this.chckbxCreateInputPorts;
    }

    private JCheckBox getChckbxCreateOutputPorts() {
        if (this.chckbxCreateOutputPorts == null) {
            this.chckbxCreateOutputPorts = new JCheckBox("Create output ports");
            this.chckbxCreateOutputPorts.setSelected(true);
        }
        return this.chckbxCreateOutputPorts;
    }

    private JPanel getPanel_1() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            this.panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Line Options", 4, 2, null, null));
            GridBagLayout gbl_panel_1 = new GridBagLayout();
            gbl_panel_1.columnWidths = new int[]{0, 0};
            gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0, 0};
            gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panel_1.setLayout(gbl_panel_1);
            GridBagConstraints gbc_jCheckBoxRecording = new GridBagConstraints();
            gbc_jCheckBoxRecording.anchor = 17;
            gbc_jCheckBoxRecording.insets = new Insets(4, 4, 0, 0);
            gbc_jCheckBoxRecording.gridx = 0;
            gbc_jCheckBoxRecording.gridy = 0;
            this.panel_1.add((Component)this.getJCheckBoxRecording(), gbc_jCheckBoxRecording);
            GridBagConstraints gbc_chckbxCreateInputPorts = new GridBagConstraints();
            gbc_chckbxCreateInputPorts.anchor = 17;
            gbc_chckbxCreateInputPorts.insets = new Insets(0, 4, 0, 0);
            gbc_chckbxCreateInputPorts.gridx = 0;
            gbc_chckbxCreateInputPorts.gridy = 1;
            this.panel_1.add((Component)this.getChckbxCreateInputPorts(), gbc_chckbxCreateInputPorts);
            GridBagConstraints gbc_jCheckBoxPlayback = new GridBagConstraints();
            gbc_jCheckBoxPlayback.anchor = 17;
            gbc_jCheckBoxPlayback.insets = new Insets(0, 4, 0, 0);
            gbc_jCheckBoxPlayback.gridx = 0;
            gbc_jCheckBoxPlayback.gridy = 2;
            this.panel_1.add((Component)this.getJCheckBoxPlayback(), gbc_jCheckBoxPlayback);
            GridBagConstraints gbc_chckbxCreateOutputPorts = new GridBagConstraints();
            gbc_chckbxCreateOutputPorts.insets = new Insets(0, 4, 5, 0);
            gbc_chckbxCreateOutputPorts.anchor = 17;
            gbc_chckbxCreateOutputPorts.gridx = 0;
            gbc_chckbxCreateOutputPorts.gridy = 3;
            this.panel_1.add((Component)this.getChckbxCreateOutputPorts(), gbc_chckbxCreateOutputPorts);
        }
        return this.panel_1;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gbl_panel = new GridBagLayout();
            gbl_panel.columnWidths = new int[]{0, 0, 0};
            gbl_panel.rowHeights = new int[]{0, 0};
            gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel.setLayout(gbl_panel);
            this.jLabel = new JLabel();
            GridBagConstraints gbc_jLabel = new GridBagConstraints();
            gbc_jLabel.insets = new Insets(0, 4, 0, 5);
            gbc_jLabel.gridx = 0;
            gbc_jLabel.gridy = 0;
            this.panel.add((Component)this.jLabel, gbc_jLabel);
            this.jLabel.setText("Number of deck(s):");
            GridBagConstraints gbc_jComboBoxDeckCount = new GridBagConstraints();
            gbc_jComboBoxDeckCount.insets = new Insets(0, 4, 0, 0);
            gbc_jComboBoxDeckCount.gridx = 1;
            gbc_jComboBoxDeckCount.gridy = 0;
            this.panel.add((Component)this.getJComboBoxDeckCount(), gbc_jComboBoxDeckCount);
        }
        return this.panel;
    }

    public void playAudioClip(URL audioClipURL) {
        if (audioClipURL == null) {
            return;
        }
        try {
            Clip clip;
            AudioInputStream sourceStream = AudioSystem.getAudioInputStream(audioClipURL);
            AudioFormat sourceFormat = sourceStream.getFormat();
            float sampleRate = sourceFormat.getSampleRate();
            int sampleBits = 16;
            int channels = 2;
            int frameSize = channels * sampleBits / 8;
            boolean bigEndian = false;
            AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
            AudioFormat targetFormat = new AudioFormat(encoding, sampleRate, sampleBits, channels, frameSize, sampleRate, bigEndian);
            AudioInputStream stream = AudioSystem.getAudioInputStream(targetFormat, sourceStream);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            this.audioClip = clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            clip.start();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void stopAudioClip() {
        Clip clip = this.audioClip;
        if (clip != null) {
            clip.stop();
            clip.close();
            this.audioClip = null;
        }
    }
}

